/* $Id: GSVersion.java 1111 2016-05-22 14:17:58Z ohura $ */
package smart_gs;

/**
 * @author shayashi
 * VERSION update rule:
 *  1. Rewrite VERSION, when an osdn.jp revision is committed for a release. 
 *  Such a revision will be called a release revision.
 *  1.1. How to rewrite:
 *  1.1.1. status is R.
 *  1.1.2. svn_revision_number is the osdn.jp svn revision number for the release.
 *  1.1.3. release_date is the date, when the svn commitment is made. Thus, 
 *  a release might be made some days after release_date, although it is not recommended.
 *  1.1.4. major_version.minor_version.release_number might be revised on an agreement of the
 *  development team.
 *  2. Rewrite VERSION, when an osdn.jp revision is committed right after a release revision.
 *  2.1. How to rewrite:
 *  2.1.1. status should be changed to D.
 *  2.1.2. Do NOT change any other items except status.*   
 *  3. Rewrite VERSION, when it is agreed among the development team.
 *  4. Otherwise, you must not rewrite VERSION.
 *  
 * The structure of version numbers
 * 0.8.11 2011.10.01 r400 R
 * 0.8.11 2011.10.01 r400 D
 * major_version.minor_version.release_number release_date svn_revision_number status
 * Status R means it is a released version. D means it is in a development and not for release.
 */
public class GSVersion {
	

	
	//2011/09/30 kukita
	private static final String VERSION = "0.10.1 2016.5.22 r1111 R";

	
	public static String getVersion() {
		return VERSION;
	}
	
	public static boolean isReleasedVersion() {
		return VERSION.endsWith("R");
	}
	
//	public static void main(String[] args) {
//		System.out.println(""+isReleasedVersion());
//	}

}
