/* $Id: AbstractLinkDialog.java 618 2012-12-31 13:57:33Z shayashi $ */
/*
 * 作成日: 2006/07/21
 *
 */
package smart_gs.connection;

import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

import javax.swing.JDialog;

import smart_gs.reasoning_web.logical.GS_RWElement;


/**
 * @author kazuaki kobayashi
 *
 * 
*/
public abstract class AbstractLinkDialog extends JDialog implements ComponentListener,MouseListener,MouseMotionListener{
	
	public static final int LINK = 0;
	public static final int JUMP = 1;
	
	protected Image image;
	protected Point drawPoint;
	
	protected AbstractLinkDialog(Frame owner,String title){
		super(owner,title);
		this.addComponentListener(this);
		this.toFront();     //modalをtrueにすると、Viewを選択できないのでこの方法で代替
		this.addMouseListener(this);
		this.addMouseMotionListener(this);
		this.setSize(400,200);
	}
	public abstract void setLinkableElement(GS_RWElement element);
	public abstract void notifyRelease(GS_RWElement elem, Point p);
	protected abstract void finish();
	
	public void notifyPaint(Image image, Point p) {
		this.image = image;
		this.drawPoint = p;
		this.repaint();
	}
	
	public void paint(Graphics g){
		super.paint(g);
		if(this.image != null && this.drawPoint != null){
			g.drawImage(image,drawPoint.x,drawPoint.y,this);
		}
	}

	public void componentHidden(ComponentEvent e) {
		this.finish();
	}
	
	public void componentMoved(ComponentEvent e) {
	}

	public void componentResized(ComponentEvent e) {
	}

	public void componentShown(ComponentEvent e) {
		this.image = null;
		this.drawPoint = null;
	}

	public void mouseClicked(MouseEvent e) {
		
	}

	public void mouseEntered(MouseEvent e) {
		
	}

	public void mouseExited(MouseEvent e) {
		this.drawPoint = null;
		repaint();
	}

	public void mousePressed(MouseEvent e) {
		
	}

	public void mouseReleased(MouseEvent e) {
		
	}
	public void mouseDragged(MouseEvent e) {
		
	}

	public void mouseMoved(MouseEvent e) {
	}

}
