/* $Id: DictionaryDialog.java 326 2011-08-27 05:24:05Z shayashi $ */
package smart_gs.dictionary;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Panel;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.TreeMap;

import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.border.LineBorder;
import javax.xml.parsers.ParserConfigurationException;

import reasoning_web.logical.inter_face.NoWayToShowException;
import smart_gs.logical.Region;
import smart_gs.logical.Spread;
import smart_gs.reasoning_web.logical.GS_RWElement;
import smart_gs.swingui.WorkspaceWindow;

import com.hexidec.ekit.component.JComboBoxNoFocus;

/**
 * 辞書ダイアログ
 * @author shimizu
 *
 */
public class DictionaryDialog extends JDialog {
	/**
	 * 一画面あたりの表示件数.
	 */
	public static final int NUMBER_OF_PAGE = 5;
	/**
	 * 自分自身のダイアログ.
	 */
	protected JDialog myDialog;
	/**
	 * 現在画面表示されている単語リスト.
	 */
	protected ArrayList<JTextField> textList = new ArrayList<JTextField>();
	/**
	 * 文字の大きさリスト.
	 */
	protected JComboBoxNoFocus jcmbFontSizeSelector;
	/**
	 * 検索結果パネル.
	 */
	protected JPanel tablePanel;
	/**
	 * スクロールパネル（検索結果のメイン）.
	 */
	protected JScrollPane scrollpane;
	/**
	 * 右クリックメニュー
	 */
	protected JPopupMenu popup;
	/**
	 * 右クリック-削除.
	 */
	protected JMenuItem deleteProperty;
	/**
	 * 右クリック-右へ.
	 */
	protected JMenuItem rightProperty;
	/**
	 * 右クリック-左へ.
	 */
	protected JMenuItem leftProperty;

	/**
	 * 処理タイプ
	 * 0 - 通常
	 * 1 - 単語選択
	 */
	protected int process_type = 0;
	/**
	 * 検索フィールド.
	 */
	protected JTextField searchField;

	/**
	 * 検索件数ラベル.
	 */
	protected JLabel items;
	/**
	 * 次へ検索ボタン.
	 */
	protected JButton nextSearch;
	/**
	 * 前へ検索ボタン.
	 */
	protected JButton previousSearch;
	/**
	 * 現在の検索開始位置.
	 */
	protected int presentPage = 0;
	
	/**
	 * 処理によって選択されている単語.
	 */
	protected String choiceword = "";
	/**
	 * 処理によって選択されている画像番号.
	 */
	protected int choiceindex;
	/**
	 * 処理タイプ-1時にキャンセルを押されたか否か.
	 */
	protected boolean cancel = false;
	/**
	 * 正規表現
	 */
	protected JCheckBox caseSensitiveBox;
	/**
	 * 大文字小文字
	 */
	protected JCheckBox regularExpressionsBox;

	/**
	 * コンストラクタ.
	 * @param frame
	 * @param title
	 * @param modal
	 * @param process_type
	 */
	public DictionaryDialog(Frame frame, String title, boolean modal,int process_type) {
		super(frame, title, modal);
		// 処理タイプを決定
		this.process_type = process_type;
		this.setSize(800, 600); // フレームの初期サイズ
		this.setLocationRelativeTo(null); // フレームを画面の中央に表示
		this.setDefaultCloseOperation(JFrame.DO_NOTHING_ON_CLOSE); // ダイアログで「いいえ」を選択しても、元の状態を保つ
		this.addWindowListener(new WindowClosing());
		// this.setJMenuBar(setMenu()); // メニューバーの処理をまとめる

		// 右クリックメニューを作成
		popup = new JPopupMenu();
		deleteProperty = new JMenuItem("Delete");
		deleteProperty.addActionListener(new DeleteListener());
		rightProperty = new JMenuItem("Move to the Right");
		rightProperty.addActionListener(new RightMovedAction());
		leftProperty = new JMenuItem("Move to the Left");
		leftProperty.addActionListener(new LeftMovedAction());
		popup.add(deleteProperty);
		popup.add(rightProperty);
		popup.add(leftProperty);
		
		Panel toolBarPanel = new Panel();
		toolBarPanel.setLayout(new BorderLayout());
		toolBarPanel.add(getJToolBar(),BorderLayout.NORTH);
		toolBarPanel.add(getJToolBar2(),BorderLayout.SOUTH);
		
		this.add(toolBarPanel, BorderLayout.NORTH);
		
		
		// 対象は0番目-null
		presentPage = 0;
		tablePanel = getTable(presentPage,null);
		setResultPanel(tablePanel,false);
		// 自分自身をクラス変数に登録.
		this.myDialog = this;
		
	}
	/**
	 * メニューバーを作成.
	 * @return
	 */
	public JToolBar getJToolBar(){
		JToolBar jtlbar = new JToolBar();
		// 次へ処理
		nextSearch = new JButton(">>");
		nextSearch.addActionListener(
				new ActionListener(){
					public void actionPerformed(ActionEvent e){
						presentPage+=NUMBER_OF_PAGE;
						research(false);
					}
				}
		);
		// 件数ラベル
		items = new JLabel();
		
		// 前へ処理
		previousSearch = new JButton("<<");
		previousSearch.addActionListener(
				new ActionListener(){
					public void actionPerformed(ActionEvent e){
						presentPage-=NUMBER_OF_PAGE;
						research(false);
					}
				}
		);
		// 検索ボタン
		JButton jbtnSearch = new JButton("Search");
		jbtnSearch.addActionListener(
				new ActionListener(){
					public void actionPerformed(ActionEvent e){
						presentPage=0;
						research(false);
					}
				}
		);
		// 検索単語入力フィールド
		searchField = new JTextField();
		searchField.addKeyListener(new KeyListener(){
			// Enterキーでも検索できるように対応.
			public void keyPressed(KeyEvent e) {
				int keycode = e.getKeyCode();
				if (keycode == KeyEvent.VK_ENTER){
					presentPage=0;
					research(false);
				}				
			}

			public void keyReleased(KeyEvent e) {
				
			}

			public void keyTyped(KeyEvent e) {
				
			}
			
		});
		// 文字の大きさ選択
		jcmbFontSizeSelector = new JComboBoxNoFocus((new String[] { "8", "10",
				"12", "14", "18", "24", "32" }));
		jcmbFontSizeSelector.setMaximumSize(jcmbFontSizeSelector
				.getPreferredSize());
		jcmbFontSizeSelector.setSelectedIndex(4);
		jcmbFontSizeSelector.addActionListener(
			new ActionListener(){
				// 文字の大きさが変更された場合、すべてTextFiledに対して行う.
				public void actionPerformed(ActionEvent e){
					for(int i=0;i<textList.size();i++){
						JTextField textField = textList.get(i);
						String sizeStr = (String)jcmbFontSizeSelector.getSelectedItem();
						textField.setFont(new Font("Serif",Font.PLAIN, Integer.parseInt(sizeStr)));
						tablePanel.updateUI();
					}
				}
			}
		);

		// ツールバーを登録.
		jtlbar.add(previousSearch);
		jtlbar.add(items);
		jtlbar.add(nextSearch);
		jtlbar.add(searchField);
		jtlbar.add(jbtnSearch);
		jtlbar.addSeparator(); // セパレータを追加する
		jtlbar.add(jcmbFontSizeSelector);
	
		return jtlbar;
	}
	/**
	 * ツールバー下段
	 * @return
	 */
	public JToolBar getJToolBar2(){
		JToolBar jtlbar = new JToolBar();
		caseSensitiveBox = new JCheckBox("Case sensitive");
		regularExpressionsBox = new JCheckBox("Regular expressions");
		jtlbar.add(caseSensitiveBox);
		jtlbar.add(regularExpressionsBox);
		return jtlbar;

	}
	/**
	 * 検索結果を反映.
	 * @param jPanel
	 * @param scroll true スクロールバーを維持,false スクロールバーを維持しない.
	 */
	public void setResultPanel(JPanel jPanel,boolean scroll){
		Point point = null;
		if(scrollpane != null){
			// スクロールバーを維持する場合、現在のスクロールバーを一度取得し
			// 再作成後に反映する
			if(scroll){
				JViewport view = scrollpane.getViewport();
				Point viewPosition  = view.getViewPosition();
				point = new Point();
				point.setLocation(viewPosition.getX(), viewPosition.getY());
			}
			// 現在の検索結果を一度破棄
			this.remove(scrollpane);
		}
		// 再度検索結果を作成
		scrollpane = new JScrollPane(jPanel);
	    scrollpane.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_ALWAYS);
	    scrollpane.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_ALWAYS);
	    // スクロールバーの維持を行う場合は前の設定を再設定
	    if(point != null){
	    	JViewport view = scrollpane.getViewport();
			view.setViewPosition(point);
	    }
	    this.add(scrollpane, BorderLayout.CENTER);
	    // 以下処理を呼ばないと画面が再描画されない
	    this.invalidate();
	    this.validate();
	}
	/**
	 * 検索結果を作成.
	 * @param start
	 * @param searchword
	 * @return
	 */
	public JPanel getTable(int start,String searchword){
		// 一度登録されている、単語リストを破棄
		textList.clear();
		TreeMap<String, Dictionary> dictionaryMap = null;
		if(searchword == null){
			searchword = "";
		}
		// 検索条件が設定されてい場合は対処だけ取得、されていない場合すべて取得
		if(searchword.equals("")){
			DictionaryXML dictionaryXML = DictionaryXML.getInstance();
			dictionaryMap = dictionaryXML.getDictionaryMap();
		}else{
			if(!caseSensitiveBox.isSelected()){
				searchword = searchword.toLowerCase();
			}
			if(regularExpressionsBox.isSelected()){
				DictionaryXML dictionaryXML = DictionaryXML.getInstance();
				dictionaryMap = dictionaryXML.getDictionaryMapByregularExpressions(searchword);
			}else{
				DictionaryXML dictionaryXML = DictionaryXML.getInstance();
				dictionaryMap = dictionaryXML.getDictionaryMap(searchword);
			}
		}
		int maximage = 0;
		
		// ベースとなるパネルを[GridBagLayout]として作成
		GridBagLayout layout = new GridBagLayout();
		JPanel panelBase = new JPanel();
		panelBase.setLayout(layout);
		
		
		// 開始位置が0だったら、前のボタンを非活性にする.
		if(start == 0){
			previousSearch.setEnabled(false);
		}else{
			previousSearch.setEnabled(true);
		}
		
		// 終了位置がstart + NUMBER_OF_PAGEより大きい場合次へボタンを非活性にする.
		if(start + NUMBER_OF_PAGE >= dictionaryMap.size()){
			nextSearch.setEnabled(false);
		}else{
			nextSearch.setEnabled(true);
		}
		
		// 検索件数を設定
		int star_label = start;
		if(star_label != 0){
			star_label = star_label / NUMBER_OF_PAGE;
		}
		items.setText(star_label + 1 + "[" + (start + 1) + "-" + (start + NUMBER_OF_PAGE) + "]" + "/" + ((int)Math.ceil((double)dictionaryMap.size() / NUMBER_OF_PAGE)) +"[" + dictionaryMap.size() + "]");

		// フォントサイズ
		int fontsize = 18;
		try{
			fontsize = Integer.parseInt((String)jcmbFontSizeSelector.getSelectedItem());
		}catch(Exception e){}

		
		Iterator<String> itr  = null;
		// カラムの最大値を計算.
		int i=0;
		int counter = -1;
		itr = dictionaryMap.keySet().iterator();
		while(itr.hasNext()){
			counter++;
			String word = itr.next();
			if(counter < start){
				continue;
			}
			// y軸は2ずつ増えるので規定値 * 2で計算する.
			if((NUMBER_OF_PAGE * 2) <= i){
				break;
			}
			Dictionary dictionary = dictionaryMap.get(word);
			ArrayList<DictionaryRegion> list = dictionary.getDictionaryRegionList();
			if(maximage < list.size()){
				maximage = list.size();
			}
			i+=2;
		}
		// 再度取得し、テーブルを作成.
		itr = dictionaryMap.keySet().iterator();
		i=0;
		counter = -1;
		while(itr.hasNext()){
			counter++;
			String word = itr.next();
			if(counter < start){
				continue;
			}
			// y軸は2ずつ増えるので規定値 * 2で計算する.
			if((NUMBER_OF_PAGE * 2) <= i){
				break;
			}
			JTextField textField = new JTextField(word,20);
			textField.setToolTipText(word);
			textField.setFont(new Font("Serif",Font.PLAIN, fontsize));
			textField.addFocusListener(new TextFieldFocusListener(textField));
			
			GridBagLayout wordlayout = new GridBagLayout();
			JPanel wordpanel = new JPanel();
			wordpanel.setLayout(wordlayout);
			wordpanel.setBorder(new LineBorder(Color.BLACK));
			wordpanel.setBackground(Color.WHITE);
//			wordpanel.setLayout(new BorderLayout());

			GridBagConstraints wordgbc = new GridBagConstraints();
			wordgbc.gridx = 0;
			wordgbc.gridy = 0;
			wordgbc.fill = GridBagConstraints.BOTH;
			wordgbc.insets = new Insets(10, 10, 10, 10);
			wordlayout.setConstraints(textField, wordgbc);
			
			wordpanel.add(textField);
			
			// 通常の場合は削除ボタンを配置
			if(process_type == 0){
				JButton button = new JButton("delete");
				button.addActionListener(new DictonaryTextDeleteListener(word));
				Dimension size = new Dimension(100, 20);
				button.setMaximumSize(size);
				button.setMinimumSize(size);
				button.setPreferredSize(size);
				JPanel buttonpanel = new JPanel();
				buttonpanel.setBorder(new LineBorder(Color.WHITE));
				buttonpanel.setBackground(Color.WHITE);
				buttonpanel.add(button);
				
				wordgbc.gridx = 0;
				wordgbc.gridy = 1;
				wordgbc.fill = GridBagConstraints.BOTH;
				wordgbc.insets = new Insets(10, 10, 10, 10);
				wordlayout.setConstraints(buttonpanel, wordgbc);
				wordpanel.add(buttonpanel);
			// 単語選択の場合は選択ボタンを配置
			}else if(process_type == 1){
				JButton button = new JButton("choice");
				button.addActionListener(new SelectWordAction(word));
				Dimension size = new Dimension(100, 20);
				button.setMaximumSize(size);
				button.setMinimumSize(size);
				button.setPreferredSize(size);
				JPanel buttonpanel = new JPanel();
				buttonpanel.setBorder(new LineBorder(Color.WHITE));
				buttonpanel.setBackground(Color.WHITE);
				buttonpanel.add(button);
				wordgbc.gridx = 0;
				wordgbc.gridy = 1;
				wordgbc.fill = GridBagConstraints.BOTH;
				wordgbc.insets = new Insets(10, 10, 10, 10);
				wordlayout.setConstraints(buttonpanel, wordgbc);
				wordpanel.add(buttonpanel);
			}
			// 単語リストに登録
			textList.add(textField);
			GridBagConstraints gbc = new GridBagConstraints();
			gbc.fill = GridBagConstraints.BOTH;
			gbc.weightx = 100.0;
			gbc.weighty = 100.0;
	
			gbc.gridx = 0;
			gbc.gridy = i;
			gbc.gridwidth = 1;
			gbc.gridheight = 2;	// 縦２つ分

			layout.setConstraints(wordpanel, gbc);
			
			// 配置.
			panelBase.add(wordpanel);

			Dictionary dictionary = dictionaryMap.get(word);
			ArrayList<DictionaryRegion> dictionaryList = dictionary.getDictionaryRegionList();
			for(int j=0;j<maximage;j++){
				JPanel labelPanel = new JPanel();
				labelPanel.setBorder(new LineBorder(Color.BLACK));
				labelPanel.setBackground(Color.WHITE);
				if(dictionaryList.size() > j){
					DictionaryRegion dictionaryRegion = dictionaryList.get(j);
					Region region = dictionaryRegion.getRegion();
					Spread spread = region.getSpread();
					//20100825 shimizu add
					JLabel label = new JLabel(spread.getURI());
					if(dictionaryRegion.isSearchable()==false){
					
						label.setText("cannot search");
						label.setBackground(Color.MAGENTA);
						label.setOpaque(true);
					}
					labelPanel.add(label);
				}
				
				JPanel imagePanel = new JPanel();
				imagePanel.setBorder(new LineBorder(Color.BLACK));
				imagePanel.setBackground(Color.WHITE);
				if(dictionaryList.size() > j){
					DictionaryRegion dictionaryRegion = dictionaryList.get(j);
					Region region = dictionaryRegion.getRegion();
					try {
						JPanel regionJPanel = region.createElementViewPanel(); 
						regionJPanel.addMouseListener(new RegionMouseListener(word,j,region));
						imagePanel.add(regionJPanel);
					} catch (NoWayToShowException e) {
						// TODO 自動生成された catch ブロック
						e.printStackTrace();
					}				
				}
				gbc.gridx = j + 1;
				gbc.gridy = i;
				gbc.gridwidth = 1;
				gbc.gridheight = 1;

				layout.setConstraints(labelPanel, gbc);
					
				gbc.gridx = j + 1;
				gbc.gridy = i+1;
				gbc.gridwidth = 1;
				gbc.gridheight = 1;
				layout.setConstraints(imagePanel, gbc);
				
				panelBase.add(labelPanel);
				panelBase.add(imagePanel);
			}
			i+=2;
		}
		return panelBase;
	}
	/***
	 * 再検索
	 * @param scroll
	 */
	public void research(boolean scroll){
		if(scrollpane != null){
			scrollpane.remove(tablePanel);
		}
		tablePanel.removeAll();
		tablePanel = getTable(presentPage,searchField.getText());
		setResultPanel(tablePanel,scroll);
	}
	/**
	 * キャンセルを押されたか否か
	 * @return
	 */
	public boolean isCancel() {
		return cancel;
	}
	/**
	 * 単語選択時の選択された単語
	 * @return
	 */
	public String getCchoiceWord(){
		return choiceword;
	}
	
	public void search(String text,boolean isRegularExpressions,boolean isCaseSensitive){
		this.searchField.setText(text);
		regularExpressionsBox.setSelected(isRegularExpressions);
		caseSensitiveBox.setSelected(isCaseSensitive);
		presentPage=0;
		research(false);
	}
	
	// メニューを設定する
	JMenuBar setMenu() {
		JMenuBar mnbar = new JMenuBar();
		JMenu mnFile = new JMenu("ファイル");
		JMenu mnOption = new JMenu("オプション");
		JMenu mnHelp = new JMenu("ヘルプ");
		mnbar.add(mnFile);
		JMenuItem mniOpen = new JMenuItem("開く");
		JMenuItem mniExit = new JMenuItem("終了");
		mnFile.add(mniOpen);
		mnFile.addSeparator(); // セパレータを追加する
		mnFile.add(mniExit);

		mnbar.add(mnOption);
		mnbar.add(mnHelp);

		mnbar.setToolTipText("これは、メニューバーです");
		mnFile.setToolTipText("これは、ファイル  です");
		mnOption.setToolTipText("これは、オプションです");
		mnHelp.setToolTipText("これは、ヘルプ    です");
		mniOpen.setToolTipText("これは、開く      です");
		mniExit.setToolTipText("これは、終了      です");
		return mnbar;

	}

	/**
	 * Windowsの×を押された時の処理. 
	 *
	 */
	class WindowClosing extends WindowAdapter {
		public void windowClosing(WindowEvent e) {
			myDialog.setVisible(false);
			cancel = true;
		}
	}

	class RegionMouseListener implements MouseListener{
		private GS_RWElement element;
		private String word;
		private int index;
		public RegionMouseListener(String word,int index,GS_RWElement element){
			this.element = element;
			this.word = word;
			this.index = index;
		}
		
		public void mouseClicked(MouseEvent e) {
			if(SwingUtilities.isRightMouseButton(e)){
				choiceindex = index;
				choiceword = word;
				DictionaryXML dictionaryXML = DictionaryXML.getInstance();
				TreeMap<String, Dictionary> dictionaryMap = dictionaryXML.getDictionaryMap();
				Dictionary dictionary = dictionaryMap.get(word);
				ArrayList<DictionaryRegion> regionList = dictionary.getDictionaryRegionList();
				if(index == 0){
					leftProperty.setVisible(false);
				}else{
					leftProperty.setVisible(true);
				}
				if(regionList.size() > (index + 1)){
					rightProperty.setVisible(true);
				}else{
					rightProperty.setVisible(false);
				}
				popup.show(e.getComponent(), e.getX(), e.getY());
			}else{
				element.show();
			}
		}

		public void mouseEntered(MouseEvent e) {
			
		}

		public void mouseExited(MouseEvent e) {
			
		}

		public void mousePressed(MouseEvent e) {
			
		}

		public void mouseReleased(MouseEvent e) {
			
		}
		
	}
	class DictonaryTextDeleteListener implements ActionListener{
		protected String word;
		
		public DictonaryTextDeleteListener(String word){
			this.word = word;
		}
		
		public void actionPerformed(ActionEvent e) {
			int value = JOptionPane.showConfirmDialog(WorkspaceWindow.getInstance() , "Do you delete word ?",	"Confirmation" , JOptionPane.YES_NO_OPTION);
			if (value != JOptionPane.YES_OPTION){
				return;
			}
			DictionaryXML dictionaryXML = DictionaryXML.getInstance();
			dictionaryXML.delete(word);
			try {
				dictionaryXML.write();
				dictionaryXML.load();
				TreeMap<String, Dictionary> dictionaryMap = dictionaryXML.getDictionaryMap();
				if(dictionaryMap.size() != 0){
					if(dictionaryMap.size() % NUMBER_OF_PAGE ==  0){
						presentPage-=NUMBER_OF_PAGE;
					}
				}
				
				research(true); 
			} catch (ParserConfigurationException e1) {
				e1.printStackTrace();
			}
			WorkspaceWindow.setUpdated(true);
		}

	}
	class TextFieldFocusListener implements FocusListener{
		protected JTextField textField;
		protected String temp;
		public TextFieldFocusListener(JTextField textField){
			this.textField = textField;
		}
		public void focusGained(FocusEvent e) {
			temp = textField.getText();
		}

		public void focusLost(FocusEvent e) {
			String temp_ = textField.getText();
			if(!temp_.equals(temp)){
				DictionaryXML dictionaryXML = DictionaryXML.getInstance();
				Dictionary dictionary = dictionaryXML.getDictionary(temp);
				if(dictionary != null){
					dictionaryXML.delete(temp);
					dictionary.setWord(temp_);
					dictionaryXML.add(temp_, dictionary);
					try {
						dictionaryXML.write();
						dictionaryXML.load();
						research(false);
					} catch (ParserConfigurationException e1) {
						e1.printStackTrace();
					}
				}
			}
		}
		
	}
	
	class RightMovedAction implements ActionListener{
		public void actionPerformed(ActionEvent e) {
			DictionaryXML dictionaryXML = DictionaryXML.getInstance();
			TreeMap<String, Dictionary> dictionaryMap = dictionaryXML.getDictionaryMap();
			Dictionary dictionary = dictionaryMap.get(choiceword);
			ArrayList<DictionaryRegion> regionList = dictionary.getDictionaryRegionList();
			
			DictionaryRegion dictionaryRegion = regionList.remove(choiceindex);
			regionList.add(choiceindex + 1,dictionaryRegion);
			try {
				dictionaryXML.write();
				dictionaryXML.load();
				research(true);
				for(int i=0;i<textList.size();i++){
					JTextField textField = textList.get(i);
					if(textField.getText().equals(choiceword)){
						textField.requestFocus();
						break;
					}
				}
			} catch (ParserConfigurationException e1) {
				e1.printStackTrace();
			}
		}
	}
	class LeftMovedAction implements ActionListener{
		public void actionPerformed(ActionEvent e) {
			DictionaryXML dictionaryXML = DictionaryXML.getInstance();
			TreeMap<String, Dictionary> dictionaryMap = dictionaryXML.getDictionaryMap();
			Dictionary dictionary = dictionaryMap.get(choiceword);
			ArrayList<DictionaryRegion> regionList = dictionary.getDictionaryRegionList();
			
			DictionaryRegion dictionaryRegion = regionList.remove(choiceindex);
			regionList.add(choiceindex - 1,dictionaryRegion);
			try {
				dictionaryXML.write();
				dictionaryXML.load();
				research(true);
				for(int i=0;i<textList.size();i++){
					JTextField textField = textList.get(i);
					if(textField.getText().equals(choiceword)){
						textField.requestFocus();
						break;
					}
				}
			} catch (ParserConfigurationException e1) {
				e1.printStackTrace();
			}
		}
	}
	
	class SelectWordAction implements ActionListener{
		protected String word;
		public SelectWordAction(String word){
			this.word = word;
		}
		public void actionPerformed(ActionEvent e) {
			choiceword = word;
			myDialog.setVisible(false);
		}
		
	}
	class DeleteListener implements ActionListener{

		public void actionPerformed(ActionEvent e) {
			DictionaryXML dictionaryXML = DictionaryXML.getInstance();
			dictionaryXML.deleteRegion(choiceword, choiceindex);
			try {
				dictionaryXML.write();
				dictionaryXML.load();
				TreeMap<String, Dictionary> dictionaryMap = dictionaryXML.getDictionaryMap();
				if(dictionaryMap.size() != 0){
					if(dictionaryMap.size() % NUMBER_OF_PAGE ==  0){
						presentPage-=NUMBER_OF_PAGE;
					}
				}
				
				research(true);
			} catch (ParserConfigurationException e1) {
				e1.printStackTrace();
			}
		}

	}
	class ColorLabel extends JLabel {
		ColorLabel() {
			setBackground(Color.WHITE);
			setOpaque(true);
			setBorder(BorderFactory.createLineBorder(Color.BLACK,2));
		}
	}

}