package smart_gs.drawing_tool;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.List;

import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

import smart_gs.drawing_tool.drawing_mode.BookmarkMode;
import smart_gs.drawing_tool.drawing_mode.CloseUpRectangleMode;
import smart_gs.drawing_tool.drawing_mode.DefaultDrawingMode;
import smart_gs.drawing_tool.drawing_mode.DeleteMode;
import smart_gs.drawing_tool.drawing_mode.MarkerMode;
import smart_gs.drawing_tool.drawing_mode.MemoPadMode;
import smart_gs.drawing_tool.drawing_mode.Mode;
import smart_gs.drawing_tool.drawing_mode.PolygonMode;
import smart_gs.drawing_tool.drawing_mode.RectangleMode;
import smart_gs.drawing_tool.state.DefaultState;
import smart_gs.drawing_tool.state.State;
import smart_gs.logical.Preference;
import smart_gs.logical.Spread;
import smart_gs.smleditor.swingui.GSEditor;
import smart_gs.swingui.AbstractGSWindow;
import smart_gs.swingui.GSMouseEvent;
import smart_gs.swingui.WorkspaceWindow;
import smart_gs.swingui.toolbar.ImageToolBar;
import smart_gs.util.ImageToolBarSetModeByMouseEvent;

public class DrawingModeSelectionPopupMenu extends JPopupMenu {
	
	public DrawingModeSelectionPopupMenu(GSMouseEvent e1) {
		AbstractGSWindow editor = null;
		GSEditor gseditor = null;
		SpreadCanvas spreadcanvas = null;
		
		Component component = e1.getComponent();
		if (!(component instanceof ImageLabel)) {
			System.out.println("A fatal bug in DefaultState.java");
			return;
		}
		ImageLabel imageLabel = (ImageLabel)component;
		spreadcanvas = imageLabel.getSpreadCanvas();
		gseditor = spreadcanvas.getGSEditor();
		if (gseditor != null){
			editor = gseditor;
		} else {
			editor = WorkspaceWindow.getInstance();
		}

		JMenuItem select = new JMenuItem("Select");
		select.addActionListener(editor.select);
		this.add(select);
		
		JMenuItem deleter = new JMenuItem("Delete");
		deleter.addActionListener(editor.delete);
		this.add(deleter);	

		JMenuItem closeUp = new JMenuItem("Close Up");
		closeUp.addActionListener(editor.closeup);
		this.add(closeUp);

		JMenuItem rect = new JMenuItem("Rectangle");
		rect.addActionListener(editor.rectangle);
		this.add(rect);

		JMenuItem marker = new JMenuItem("Marker");
		marker.addActionListener(editor.marker);
		this.add(marker);

		JMenuItem polygon = new JMenuItem("Polygon");
		polygon.addActionListener(editor.polygon);
		this.add(polygon);

		JMenuItem memo = new JMenuItem("MemoPad");
		memo.addActionListener(editor.memopad);
		this.add(memo);

		JMenuItem bookmark = new JMenuItem("Bookmark");
		bookmark.addActionListener(editor.bookmark);
		this.add(bookmark);

		if (Preference.getInstance().isTempRegionOn()) {
			JMenuItem tmprect = new JMenuItem("tmp Rectangle");
			tmprect.addActionListener(editor.tmprectangle);
			this.add(tmprect);

			JMenuItem tmpmarker = new JMenuItem("tmp Marker");
			tmpmarker.addActionListener(editor.tmpmarker);
			this.add(tmpmarker);

			JMenuItem tmppolygon = new JMenuItem("tmp Polygon");
			tmppolygon.addActionListener(editor.tmppolygon);
			this.add(tmppolygon);

			JMenuItem tmpbookmark = new JMenuItem("tmp Bookmark");
			tmpbookmark.addActionListener(editor.tmpbookmark);
			this.add(tmpbookmark);
		}
	}
}
