package smart_gs.drawing_tool.action;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;

import javax.swing.JComponent;
import smart_gs.logical.GSResource;
import smart_gs.logical.Region;
import smart_gs.logical.ResourceBasket;
import smart_gs.menu.action.ResourceListSelectionFrame;
import smart_gs.swingui.ResourceBasketsFrame;
import smart_gs.swingui.WorkspaceWindow;

public class AddToBasketAction implements ActionListener {
	
	private ResourceBasket basket;
	private GSResource resource;
	
	public AddToBasketAction(ResourceBasket basket, GSResource resource) {
		this.basket = basket;
		this.resource = resource;
	}

	public AddToBasketAction(GSResource resource) {
		this.resource = resource;
	}

	@Override
	public void actionPerformed(ActionEvent arg0) {
		if (this.basket != null) {
			this.basket.addResource(this.resource);
			ResourceListSelectionFrame selectionFrame = ResourceBasketsFrame.getInstance().getSelectionFrame(this.basket);
			if (selectionFrame != null) {
				selectionFrame.update();
				if (selectionFrame.getSaveOption()) {
					WorkspaceWindow.setUpdated(true);
				}
			} else {
				ResourceBasketsFrame.getInstance().createAndAddResourceListSelectionFrame(this.basket);
			}
		} else {
			ResourceBasketsFrame.getInstance().setResource(this.resource);
			ResourceBasketsFrame.getInstance().showResourceBasketFrame();			
		}
	}

}
