package smart_gs.drawing_tool.action;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import smart_gs.drawing_tool.view.BookmarkView;
import smart_gs.drawing_tool.view.View;
import smart_gs.logical.Region;
import smart_gs.logical.RegionOperation;
import smart_gs.logical.Spread;
import smart_gs.logical.region.BookmarkRegion;
import smart_gs.swingui.WorkspaceWindow;
import smart_gs.util.Pair;

public class BookmarkSizeAction implements ActionListener {

	BookmarkRegion bookmark;
	double old_size, new_size;
	
	public BookmarkSizeAction(BookmarkRegion region, double size) {
			this.bookmark = region;
			this.new_size = size;
			this.old_size = ((BookmarkView)(this.bookmark.getView())).getSize();
	}
	@Override
	public void actionPerformed(ActionEvent arg0) {
		Spread spread = this.bookmark.getSpread();
		spread.pushRegionUndoStack(new RegionOperation(RegionOperation.CHANGE_BOOKMARK_SIZE, this.bookmark, new Pair<Double,Double>(old_size,new_size),spread));
		((BookmarkView)this.bookmark.getView()).setSize(this.new_size);
		WorkspaceWindow.setUpdated(true);
	}

}
