/* $Id: ProtectRegionAction.java 1058 2016-01-17 17:09:20Z shayashi $ */
package smart_gs.drawing_tool.action;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import smart_gs.logical.Region;
import smart_gs.logical.RegionOperation;
import smart_gs.logical.Spread;
import smart_gs.swingui.WorkspaceWindow;
import smart_gs.util.Pair;

public class ProtectRegionAction implements ActionListener {

	private Region region;

	public ProtectRegionAction(Region region) {
		this.region = region;
	}

	public void execute() {
		if (this.region != null) {
			// kazuhiro kobayashi 10/7
			region.setProtection(Region.PROTECTED);
			// 現在表示中のsheetについてregionを操作するので良いかどうかまだわからない
			// region.getSpread().getCurrentSheet().addProtectedRegions(region);
			region.getView().setIsProtected(Region.PROTECTED);
			Spread spread = this.region.getSpread();
			spread.pushRegionUndoStack(new RegionOperation(RegionOperation.PROTECT, region, region,spread));
			WorkspaceWindow.setUpdated(true);
		}
	}

	public void actionPerformed(ActionEvent arg0) {
		// TODO Auto-generated method stub
		this.execute();
	}

}
