/* $Id: EditMenu.java 1064 2016-01-24 16:02:47Z shayashi $ */
package smart_gs.menu;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;

import smart_gs.GSConstants;
import smart_gs.logical.Preference;
import smart_gs.logical.Sheet;
import smart_gs.smleditor.swingui.GSEditorTextPane;
import smart_gs.swingui.AbstractGSWindow;
import smart_gs.swingui.WorkspaceWindow;
import smart_gs.swingui.toolbar.GSEditorToolBar;
import smart_gs.swingui.toolbar.GSMarkupAction;
import smart_gs.swingui.toolbar.GSRemoveTagAction;
import smart_gs.swingui.toolbar.ImageToolBar;
import sml_editor.swingui.EditorTextPane;
import sml_editor.swingui.toolbar.action.CopyAction;
import sml_editor.swingui.toolbar.action.CutAction;
import sml_editor.swingui.toolbar.action.MarkupAction;
import sml_editor.swingui.toolbar.action.PasteAction;
import sml_editor.swingui.toolbar.action.RedoAction;
import sml_editor.swingui.toolbar.action.RemoveTagAction;
import sml_editor.swingui.toolbar.action.UndoAction;

@SuppressWarnings("serial")
public class EditMenu extends JMenu implements ActionListener{
	private JMenuItem select;
	private JMenuItem deleter;
	private JMenuItem rectangle;
	private JMenuItem marker;
	private JMenuItem polygon;
	private JMenuItem memopad;
	private JMenuItem bookmark0;
	private JMenuItem closeUp;
	private JMenuItem tmprectangle;
	private JMenuItem tmpmarker;
	private JMenuItem tmppolygon;
	private JMenuItem tmpbookmark;
	private JMenuItem resourceBasket;
	private JMenuItem reasoningWeb;

	private JMenuItem zoomIn;
	private JMenuItem zoomOut;
	private JMenuItem fullSize;
	private JMenuItem fitWidth;
	private JMenuItem fitHeight;
	private JMenu showRegion;
	private AbstractGSWindow parent;
	private JMenuItem allRegions;
	private JMenuItem protectedRegions;
	private JMenuItem noRegions;
	private JMenuItem protectAllRegions;
	private JMenuItem releaseAllRegions;
	private JMenuItem compare;

	public EditMenu(String title, AbstractGSWindow parent) {
		super(title);
		this.parent = parent;
		this.select = new JMenuItem("Select", new ImageIcon(
				GSConstants.ICON_PATH + "select.gif"));
		this.select.addActionListener(this.parent.select);
		this.add(this.select);

		this.deleter = new JMenuItem("Delete", new ImageIcon(
				GSConstants.ICON_PATH + "delete.png"));
		this.deleter.addActionListener(this.parent.delete);
//		deleter.setAccelerator(KeyStroke.getKeyStroke("ctrl D"));
		this.add(this.deleter);

		this.addSeparator();

		this.rectangle = new JMenuItem("Rectangle",new ImageIcon(
				GSConstants.ICON_PATH + "rectangle.png"));
		this.rectangle.addActionListener(this.parent.rectangle);
		this.add(this.rectangle);
		
		this.bookmark0 = new JMenuItem("Bookmark",new ImageIcon(
				GSConstants.ICON_PATH + "bookmark_small.png"));
		this.bookmark0.addActionListener(this.parent.bookmark);
		this.add(this.bookmark0);

		this.marker = new JMenuItem("Marker", new ImageIcon(
				GSConstants.ICON_PATH + "marker_small.png"));
		this.marker.addActionListener(this.parent.marker);
		this.add(this.marker);

		this.polygon = new JMenuItem("Polygon", new ImageIcon(
				GSConstants.ICON_PATH + "polygon.png"));
		this.polygon.addActionListener(this.parent.polygon);
		this.add(this.polygon);

		this.memopad = new JMenuItem("MemoPad", new ImageIcon(
				GSConstants.ICON_PATH + "memopad_small.png"));
		this.memopad.addActionListener(this.parent.memopad);
		this.add(this.memopad);

		this.closeUp = new JMenuItem("Close Up",new ImageIcon(
				GSConstants.ICON_PATH + "region_close_up_small.png"));
		this.closeUp.addActionListener(this.parent.closeup);
		this.add(this.closeUp);
		
		if (Preference.getInstance().isTempRegionOn()) {
			this.tmprectangle = new JMenuItem("tmp Rectangle",
					new ImageIcon(GSConstants.ICON_PATH+"rectangle_tmp.png"));
			this.tmprectangle.addActionListener(this.parent.tmprectangle);
			this.add(this.tmprectangle);

			this.tmpbookmark = new JMenuItem("tmp Bookmark",
					new ImageIcon(GSConstants.ICON_PATH+"bookmark_small_tmp.png"));
			this.add(this.tmpbookmark);
			this.tmpbookmark.addActionListener(this.parent.tmpbookmark);
			this.add(this.tmpbookmark);

			this.tmpmarker = new JMenuItem("tmp Marker",
					new ImageIcon(GSConstants.ICON_PATH+"marker_small_tmp.png"));
			this.tmpmarker.addActionListener(this.parent.tmpmarker);
			this.add(this.tmpmarker);

			this.tmppolygon = new JMenuItem("tmp Polygon",
					new ImageIcon(GSConstants.ICON_PATH+"polygon_tmp.png"));
			this.tmppolygon.addActionListener(this.parent.tmppolygon);
			this.add(this.tmppolygon);
		}
		
		this.addSeparator();

		this.resourceBasket = new JMenuItem("Resource Basket",
				new ImageIcon(GSConstants.ICON_PATH+"basket.png"));
		this.resourceBasket.addActionListener(this.parent.resourceBasket);
		this.add(this.resourceBasket);
		
		this.reasoningWeb = new JMenuItem("Reasoning Web",
				new ImageIcon(GSConstants.ICON_PATH+"reasoningweb.png"));
		this.reasoningWeb.addActionListener(this.parent.reasoningWeb);
		this.add(this.reasoningWeb);

		this.addSeparator();

		this.zoomIn = new JMenuItem("Zoom in", new ImageIcon(
				GSConstants.ICON_PATH + "zoom_in.gif"));
		this.zoomIn.addActionListener(this.parent.zoomIn);
		this.add(this.zoomIn);

		this.zoomOut = new JMenuItem("Zoom out", new ImageIcon(
				GSConstants.ICON_PATH + "zoom_out.gif"));
		this.zoomOut.addActionListener(this.parent.zoomOut);
		this.add(this.zoomOut);

		this.fullSize = new JMenuItem("Full Size",new ImageIcon(
				GSConstants.ICON_PATH + "100percent.png"));
		this.fullSize.addActionListener(this.parent.fullSize);
		this.add(this.fullSize);

		this.fitWidth = new JMenuItem("Fit Width",new ImageIcon(
				GSConstants.ICON_PATH + "fitwidth.png"));
		this.fitWidth.addActionListener(this.parent.fitWidth);
		this.add(this.fitWidth);

		this.fitHeight = new JMenuItem("Fit Height",new ImageIcon(
				GSConstants.ICON_PATH + "fitheight.png"));
		this.fitHeight.addActionListener(this.parent.fitHeight);
		this.add(this.fitHeight);

		this.addSeparator();

		this.showRegion = new JMenu("Show Region");
		this.add(this.showRegion);

		this.allRegions = new JMenuItem("All Regions");
		this.allRegions.addActionListener(this);
		this.add(this.allRegions);

		this.protectedRegions = new JMenuItem("Protected Regions");
		this.protectedRegions.addActionListener(this);
		this.add(this.protectedRegions);

		this.noRegions = new JMenuItem("No Region");
		this.noRegions.addActionListener(this);
		this.add(this.noRegions);

		this.showRegion.add(this.allRegions);
		this.showRegion.add(this.protectedRegions);
		this.showRegion.add(this.noRegions);

		// 2010/11 kukita
		this.protectAllRegions = new JMenuItem("Protect All Regions");
		this.protectAllRegions.addActionListener(this);
		this.add(this.protectAllRegions);

		// 2010/11 kukita
		this.releaseAllRegions = new JMenuItem("Release All Reagions");
		this.releaseAllRegions.addActionListener(this);
		this.add(this.releaseAllRegions);
		
		this.addSeparator();
	}
	
	public void actionPerformed(ActionEvent e) {
		ImageToolBar imagetoolbar = WorkspaceWindow.getInstance().getImageToolBar();
		if (e.getSource().equals(this.allRegions)) {
			imagetoolbar.setShowRegionItem(ImageToolBar.showAll);
			parent.getSpreadCanvas().getSpread().changeShowRegion(Sheet.SHOW_ALL_REGIONS);
			parent.repaint();
		} else if (e.getSource().equals(this.protectedRegions)) {
			imagetoolbar.setShowRegionItem(ImageToolBar.showProtected);
			parent.getSpreadCanvas().getSpread().changeShowRegion(Sheet.SHOW_PROTECTED_REGIONS);
			parent.repaint();
		} else if (e.getSource().equals(this.noRegions)) {
			imagetoolbar.setShowRegionItem(ImageToolBar.showNo);
			parent.getSpreadCanvas().getSpread().changeShowRegion(Sheet.SHOW_NO_REGIONS);
			parent.repaint();
		} else if (e.getSource().equals(this.protectAllRegions)) {
			parent.getSpreadCanvas().protectAllRegions();
		} else if (e.getSource().equals(this.releaseAllRegions)) {
			parent.getSpreadCanvas().releaseAllRegions();
		} 
	}
}