package smart_gs.network;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Frame;
import java.util.List;

import javax.swing.BoxLayout;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

import jp.ac.nii.hcp.client.core.ProjectEditor;
import jp.ac.nii.hcp.client.shared.HCPClientException;
import jp.ac.nii.hcp.shared.model.HCPProject;

import smart_gs.swingui.ButtonDialog;

public class AddImageToProjectDialog extends ButtonDialog {

	private JTextField idField;
	private JTextArea descriptionArea;
	private ProjectListPanel projectListPanel;
	private String imagePath;
	List<HCPProject> projects;
	private HCPProject project;
	
	public AddImageToProjectDialog(Frame parent, String title) {
		super(parent, title);
		// TODO Auto-generated constructor stub
	}
	
	public AddImageToProjectDialog(Frame parent, String defaultName, String imagePath) {
		this(parent, "Add Image");
		this.imagePath = imagePath;
		JPanel idPanel = new JPanel();
		idPanel.setBorder(new TitledBorder("Image ID"));
		this.idField = new JTextField(22);
		this.idField.setText(defaultName);
		idPanel.add(this.idField);

		this.descriptionArea = new JTextArea(3,22);
		this.descriptionArea.setText("");
		JScrollPane descriptionPane = new JScrollPane(this.descriptionArea);
		descriptionPane.setBorder(new TitledBorder("Description"));
		descriptionPane.setPreferredSize(new Dimension(220, 150));
		
		this.projects = ProjectHandler.getInstance().getProjectsFromWorkspace();
		this.projectListPanel = new ProjectListPanel(projects, Constants.WORKSPACE, false);

		JPanel nPanel = new JPanel();
		nPanel.setLayout(new BoxLayout(nPanel, BoxLayout.PAGE_AXIS));
		nPanel.add(idPanel);
		nPanel.add(descriptionPane);
		nPanel.add(this.projectListPanel);
		
		this.getContentPane().add(nPanel, BorderLayout.NORTH);
		this.setSize(new Dimension(250, 500));
		this.pack();
		
		this.getRootPane().setDefaultButton(this.okButton);
	}
	
	public AddImageToProjectDialog(Frame parent, String defaultName, String imagePath, HCPProject project) {
		this(parent, "Add Image: " + project.name);
		this.project = project;
		this.imagePath = imagePath;
		JPanel idPanel = new JPanel();
		idPanel.setBorder(new TitledBorder("Image ID"));
		this.idField = new JTextField(22);
		this.idField.setText(defaultName);
		idPanel.add(this.idField);

		this.descriptionArea = new JTextArea(3,22);
		this.descriptionArea.setText("");
		JScrollPane descriptionPane = new JScrollPane(this.descriptionArea);
		descriptionPane.setBorder(new TitledBorder("Description"));
		descriptionPane.setPreferredSize(new Dimension(220, 150));
	
		JPanel nPanel = new JPanel();
		nPanel.setLayout(new BoxLayout(nPanel, BoxLayout.PAGE_AXIS));
		nPanel.add(idPanel);
		nPanel.add(descriptionPane);
		
		this.getContentPane().add(nPanel, BorderLayout.NORTH);
		this.setSize(new Dimension(250, 500));
		this.pack();
		
		this.getRootPane().setDefaultButton(this.okButton);
	}

	@Override
	public void ok() {
		String id = this.idField.getText();
		String description = this.descriptionArea.getText();
		if (this.projectListPanel != null) {
			int index = this.projectListPanel.getProjectList().getSelectedIndex();
			if (index < 0) {
				JOptionPane.showMessageDialog(ProjectExplorer.getInstance(), "No project is selected.", "Error", JOptionPane.ERROR_MESSAGE);
			}
			this.project = this.projects.get(index);
		}
		try {
			ProjectEditor editor = ProjectHandler.getInstance().getEditor(project);
			editor.addMaterial(id, this.imagePath, description);
			
		} catch (HCPClientException e) {
			e.printStackTrace();
			new ShowResultDialog("Add Image", e).setVisible(true);
		}
		this.dispose();
	}

	@Override
	public void cancel() {
		this.dispose();		
	}

}
