package smart_gs.network;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.ArrayList;

import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTextArea;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ScrollPaneLayout;


import smart_gs.logical.Preference;

import jp.ac.nii.hcp.shared.model.HCPAttachment;
import jp.ac.nii.hcp.shared.model.HCPDocument;
import jp.ac.nii.hcp.shared.model.HCPMaterial;
import jp.ac.nii.hcp.shared.model.HCPProject;
import jp.ac.nii.hcp.shared.model.HCPProjectContent;

public class ProjectContentPreviewPanel extends JPanel {
	private static final String DEFAULT_STRING = "No content is selected.";
	private HCPDocument document;
	private HCPMaterial material;
	private HCPAttachment attachment;
	private JScrollPane sPane;
	private JTextArea textArea;
	private JLabel label;
	private JLabel title;
	private HCPMaterial image;
	
	public ProjectContentPreviewPanel() {
		super();
		this.setLayout(new BoxLayout(this, BoxLayout.PAGE_AXIS));
		this.title = new JLabel();
		this.title.setBackground(Color.WHITE);
		this.title.setHorizontalTextPosition(JLabel.LEADING);
		this.title.setText(DEFAULT_STRING);
		this.textArea = new JTextArea();
		this.textArea.setWrapStyleWord(true);
		this.textArea.setAutoscrolls(true);
		this.textArea.setEditable(false);
		this.textArea.setText("");
		this.label = new JLabel();
		this.sPane = new JScrollPane(this.textArea);
		this.sPane.setLayout(new ScrollPaneLayout());
		this.sPane.setSize(new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
		this.add(this.sPane);
		this.updateUI();
	}

	public void setDocument(HCPDocument doc) {
		this.document = doc;
		String name = doc.id;
		this.title.setText(name);
		this.textArea.setText(doc.source);
		this.textArea.setEditable(false);
		this.sPane = new JScrollPane(this.textArea);
		this.removeAll();
		this.add(this.title);
		this.add(this.sPane);
		this.updateUI();
	}
	
	public void setImage(HCPMaterial image) {
		this.image = image;
		String name = image.id;
		this.title.setText(name);
		String path = Preference.getInstance().getWorkspaceDirectory() + File.separator + "image" + image.imagePath;
		this.label.setIcon(new ImageIcon(path));
		this.sPane = new JScrollPane(this.label);
		this.removeAll();
		this.add(this.title);
		this.add(this.sPane);
		this.updateUI();
	}

	public void setAttachment(HCPAttachment attachment) {
		HCPProject project = ProjectExplorer.getInstance().getSelectedProjectInWorkspace();
		String workspaceDir = Preference.getInstance().getWorkspaceDirectory();
		this.attachment = attachment;
		this.title.setText(this.attachment.id);
		String inputFileName = workspaceDir + File.separator + "repository" 
							+ File.separator + project.name
							+ File.separator + "attachment"
							+ File.separator + attachment.filePath;
		
		File inputFile = new File(inputFileName);
		this.removeAll();
		this.add(this.title);
		try {
			FileInputStream fis = new FileInputStream(inputFile);
			BufferedInputStream bis = new BufferedInputStream(fis);
			byte[] buf = new byte[1024];
			int len = bis.read(buf);
			String hex = "";
			for ( int i = 0; i < len; i++ ) {
				hex += String.format("%1$x ", buf[i]);
			}
			this.textArea.setText(hex);
			this.textArea.setEditable(false);
			this.sPane = new JScrollPane(this.textArea);
			this.add(this.sPane);
			this.updateUI();
			bis.close();
		} catch(Exception e) {
			this.textArea.setText("File not found.");
			this.textArea.setEditable(false);
			this.sPane = new JScrollPane(this.textArea);
			this.add(this.sPane);
			this.updateUI();
			e.printStackTrace();
		}
	}

	public void setContent(HCPProjectContent content) {
		if (content == null) {return;}
		if (content.getClass() == HCPDocument.class) {
			this.setDocument((HCPDocument)content);
		} else if (content.getClass() == HCPMaterial.class) {
			this.setImage((HCPMaterial)content);
		}  else if (content.getClass() == HCPAttachment.class) {
			this.setAttachment((HCPAttachment)content);
		}
	}

	public void reset() {
		this.attachment = null;
		this.document = null;
		this.image = null;
//		this.textArea.removeAll();
//		this.textArea.setText(null);
		this.title.setText(DEFAULT_STRING);
//		this.label.removeAll();
//		this.label.setText(null);
		this.sPane.removeAll();
		this.repaint();
	}
}
