package smart_gs.network;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.FlowLayout;
import java.util.List;

import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;


import smart_gs.logical.SpreadTree;

import jp.ac.nii.hcp.shared.model.HCPProject;

public class ProjectListPanel extends JPanel{
	private List<HCPProject> projects;
	private ProjectList projectList;
	private JScrollPane scrollPane;
	private ProjectExplorer explorer;

	public ProjectListPanel(String location) {
		JLabel label = new JLabel();
		this.scrollPane = new JScrollPane();
		this.setAutoscrolls(true);
		this.scrollPane.getVerticalScrollBar().setUnitIncrement(20);
		this.scrollPane.getHorizontalScrollBar().setUnitIncrement(10);
		JPanel listPanel = new JPanel();
		listPanel.setLayout(new FlowLayout(FlowLayout.LEFT));
		listPanel.setBackground(Color.white);
		listPanel.add(label);

		this.scrollPane.setViewportView(listPanel);
		this.add(scrollPane,BorderLayout.CENTER);
//		if (location.equals(Constants.WORKSPACE)) {
//			//TODO: Show message.
//			label.setText("No projects to show.");			
//		} else {
//			//TODO: Show message.
//			label.setText("No projects to show.");
//		}
	}
	
	public ProjectListPanel(List<HCPProject> projects, String location, boolean belongToProjectExplorer) {
//		this(location);
		this.projects = projects;
		this.projectList = new ProjectList(this.projects, location, belongToProjectExplorer);
		this.scrollPane = new JScrollPane();
		this.setAutoscrolls(true);
		this.scrollPane.getVerticalScrollBar().setUnitIncrement(20);
		JPanel listPanel = new JPanel();
		listPanel.setLayout(new FlowLayout(FlowLayout.LEFT));
		listPanel.setBackground(Color.white);
		listPanel.add(this.projectList);
		listPanel.setBorder(BorderFactory.createLineBorder(Color.BLACK,1));
		
//		if (projectList.getProjects() == null) {
//			this.scrollPane.add(new JLabel("No projects."));
//		} else
		{
			this.scrollPane.add(listPanel);
		}

		this.scrollPane.setViewportView(listPanel);
		this.add(scrollPane,BorderLayout.CENTER);
	}

	public ProjectList getProjectList() {
		return this.projectList;
	}

	public void setProjects(List<HCPProject> projects) {
		this.projects = projects;
		
	}

	public HCPProject getSelectedProject() {
		return this.getProjectList().getProjects().get(this.getProjectList().getSelectedIndex());
	}

}