package smart_gs.network;

import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;

import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;


import jp.ac.nii.hcp.client.shared.HCPClientException;
import jp.ac.nii.hcp.shared.model.HCPAttachment;
import jp.ac.nii.hcp.shared.model.HCPDocument;
import jp.ac.nii.hcp.shared.model.HCPMaterial;
import jp.ac.nii.hcp.shared.model.HCPProject;
import jp.ac.nii.hcp.shared.model.HCPProjectContent;
import jp.ac.nii.hcp.shared.model.HCPUser;
import jp.ac.nii.hcp.shared.model.ProjectDifference;


public class ProjectTree extends JTree implements TreeSelectionListener, MouseListener {
	HCPProject project;
	private String location;
	
	public ProjectTree(HCPProject project, String location) {
		super(makeTable(project));
		this.setLoc(location);
		this.addTreeSelectionListener(this);
		this.addMouseListener(this);
		this.expandPath(new TreePath(this.getModel().getRoot()));
	}
	
	public ProjectTree(HCPProject project, String location,
			List<HCPDocument> documents, 
			List<HCPMaterial> materials, 
			List<HCPAttachment> attachments) {
		super(makeTable(project, documents, materials, attachments));
		this.setLoc(location);
		this.addTreeSelectionListener(this);
		this.addMouseListener(this);
		this.expandPath(new TreePath(this.getModel().getRoot()));
	}
	
	private static Hashtable<String, Object> makeTable(HCPProject project, 
				List<HCPDocument> documents, 
				List<HCPMaterial> materials, 
				List<HCPAttachment> attachments) {
		Hashtable<String, Object> root = new Hashtable<String, Object>();
		Hashtable<String, Object> contents = new Hashtable<String, Object>();
		ProjectDifference diff = null;
		try {
			diff = ProjectHandler.getInstance().getController().status(project.name);
		} catch (HCPClientException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
			return null;
		}
		for (int i = 0; i < documents.size(); i++) {
			String str = " ";
			if (diff.added.contains(documents.get(i))) {
				str += "+";
			} else if (diff.modified.contains(documents.get(i))) {
				str += "*";
			}
			contents.put(documents.get(i).id + str, documents.get(i));
		}

		Hashtable<String, Object> imageTable = new Hashtable<String, Object>();
		for (int i = 0; i < materials.size(); i++) {
			imageTable.put(materials.get(i).id, materials.get(i));
		}
		contents.put("Images", imageTable);

		Hashtable<String, Object> attachmentTable = new Hashtable<String, Object>();
		for (int i = 0; i < attachments.size(); i++) {
			attachmentTable.put(attachments.get(i).id, attachments.get(i));
		}
		contents.put("Attachments", attachmentTable);
		root.put(project.name, contents);
		return root;		
	}

	private static Hashtable<String, Object> makeTable(HCPProject project) {
		Hashtable<String, Object> root = new Hashtable<String, Object>();
		Hashtable<String, Object> contents = new Hashtable<String, Object>();
		List<HCPDocument> documents = project.documents;
		for (int i = 0; i < documents.size(); i++) {
			contents.put(documents.get(i).id, documents.get(i));
		}

		Hashtable<String, Object> imageTable = new Hashtable<String, Object>();
		List<HCPMaterial> materials = project.materials;
		for (int i = 0; i < materials.size(); i++) {
			imageTable.put(materials.get(i).id, materials.get(i));
		}
		contents.put("Images", imageTable);

		Hashtable<String, Object> attachmentTable = new Hashtable<String, Object>();
		List<HCPAttachment> attachments = project.attachments;
		for (int i = 0; i < attachments.size(); i++) {
			attachmentTable.put(attachments.get(i).id, attachments.get(i));
		}
		contents.put("Attachments", attachmentTable);
		root.put(project.name, contents);
		return root;
	}

	private static String detail(HCPProjectContent content) {
		String desc = content.description;
		HCPProjectContent.Record record = content.record;
		Date date = record.modified;
		HCPUser user = record.modifiedBy;
		int rev = record.revision;
		return "revision " + rev + ", " + date + ", " + user.id + " (" + desc + ")";
	}

	public ProjectTree(Hashtable<String, Object> table) {
		super(table);
	}

	public void setLoc(String location) {
		this.location = location;
	}

	public String getLoc() {
		return location;
	}
	
	public HCPProjectContent getContentAt(TreePath path) {
		DefaultMutableTreeNode selectedNode = (DefaultMutableTreeNode)path.getLastPathComponent();
		String id = (String)selectedNode.getUserObject();
		HCPProject project = ProjectExplorer.getInstance().getSelectecProject(this.location);
		HCPProjectContent content = null;
		for (int i = 0; i < project.documents.size(); i++) {
			if (project.documents.get(i).id.equals(id)) {
				content = project.documents.get(i);
				break;
			}
		}
		if (content != null) {
			return content;
		}
		for (int i = 0; i < project.materials.size(); i++) {
			if (project.materials.get(i).id.equals(id)) {
				content = project.materials.get(i);
				break;
			}
		}
		if (content != null) {
			return content;
		}
		for (int i = 0; i < project.attachments.size(); i++) {
			if (project.attachments.get(i).id.equals(id)) {
				content = project.attachments.get(i);
				break;
			}
		}
		
		return content;
		
	}

	@Override
	public void valueChanged(TreeSelectionEvent arg0) {
		TreePath path = this.getSelectionPath();
		HCPProjectContent content = this.getContentAt(path);
		ProjectExplorer.getInstance().getProjectContentPreviewPanel().setContent(content);

/*		DefaultMutableTreeNode selectedNode = (DefaultMutableTreeNode)path.getLastPathComponent();
		String id = (String)selectedNode.getUserObject();
		HCPProject project = ProjectExplorer.getInstance().getSelectecProject(this.location);
		HCPDocument doc = null;
		for (int i = 0; i < project.documents.size(); i++) {
			if (project.documents.get(i).id.equals(id)) {
				doc = project.documents.get(i);
				break;
			}
		}
		if (doc != null) {
			ProjectExplorer.getInstance().getProjectContentPreviewPanel().setDocument(doc);
			return;
		}

		HCPMaterial image = null;
		for (int i = 0; i < project.materials.size(); i++) {
			if (project.materials.get(i).id.equals(id)) {
				image = project.materials.get(i);
				break;
			}
		}
		if (image != null) {
			ProjectExplorer.getInstance().getProjectContentPreviewPanel().setImage(image);
			return;
		}
		
		HCPAttachment attachment = null;
		for (int i = 0; i < project.attachments.size(); i++) {
			if (project.attachments.get(i).id.equals(id)) {
				attachment = project.attachments.get(i);
				break;
			}
		}
		if (attachment != null) {
			ProjectExplorer.getInstance().getProjectContentPreviewPanel().setAttachment(attachment);
			return;
		}
*/
	}

	@Override
	public void mouseClicked(MouseEvent e) {
		if (e.getButton() == MouseEvent.BUTTON2) {
			new ProjectTreePopupMenu().show(e.getComponent(), e.getX(), e.getY());
		}
		// TODO Auto-generated method stub
		
	}

	@Override
	public void mouseEntered(MouseEvent arg0) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void mouseExited(MouseEvent arg0) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void mousePressed(MouseEvent arg0) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void mouseReleased(MouseEvent arg0) {
		// TODO Auto-generated method stub
		
	}
	
}
