package smart_gs.reasoning_web.swingui;

import java.util.ArrayList;

import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;

import reasoning_web.logical.Connection;
import reasoning_web.logical.ResourcePointer;
import reasoning_web.logical.inter_face.RWElement;
import smart_gs.debugprint.Debugprint;
import smart_gs.logical.GSResource;
import smart_gs.reasoning_web.logical.GSConnection;
import smart_gs.reasoning_web.logical.GSResourcePointer;
import smart_gs.reasoning_web.logical.GS_RWElement;
import smart_gs.reasoning_web.logical.GS_RWRepository;
import smart_gs.reasoning_web.swingui.view.View;

public class ConnectionTable extends ResourceTable {
	
	private MarkupTable markupTable;

	public ConnectionTable(ResourceTableModel model) {
		super(model);
		this.getSelectionModel().addListSelectionListener(new ConnectionTableListSelectionListener(this));

	}

	public MarkupTable getMarkupTable() {
		return markupTable;
	}

	public void setMarkupTable(MarkupTable markupTable) {
		this.markupTable = markupTable;
	}
	
	
	class ConnectionTableListSelectionListener implements ListSelectionListener {

		ConnectionTable table;
		
		ConnectionTableListSelectionListener(ConnectionTable table) {
			this.table = table;
		}
		
		@Override
		public void valueChanged(ListSelectionEvent e) {
			RWElement element = null;
			MarkupTable markupTable = this.table.markupTable;
			ConnectionTable connectionTable = this.table;
			int index = this.table.getSelectedResourceIndex();
			if (index < 0) return;
			ArrayList<GSResource> markups = markupTable.getResourceTableModel().getMarkups();
			ArrayList<GSConnection> connections = connectionTable.getResourceTableModel().getConnections();
			for (int i = 0; i < connections.size(); i++) {
				connections.get(i).getView().setIsSelected(false);
			}
			
			element = connections.get(index);
			if(element == null){
				return;
			}
			GSConnection connection = (GSConnection) element;
			GSResource source = connection.getSourcePointer().getGSResource();
			int sourceIndex = -1;
			if (markups != null) { 
				for (int i = 0; i < markups.size(); i++) {
					if (source == markups.get(i)) {
						sourceIndex = i;
					}
				}
			}
			GSResource target = connection.getTargetPointer().getGSResource();
			int targetIndex = -1;
			if (markups != null) { 
				for (int i = 0; i < markups.size(); i++) {
					if (target == markups.get(i)) {
						targetIndex = i;
					}
				}
			}
			if (!(sourceIndex < 0 || targetIndex < 0)) {
				ResourceTableCellRenderer renderer = new ResourceTableCellRenderer(sourceIndex, targetIndex);
				markupTable.setDefaultRenderer(Object.class, renderer);
			} else {
				ResourceTableCellRenderer renderer = new ResourceTableCellRenderer();
				markupTable.setDefaultRenderer(Object.class, renderer);					
			}
			View.clearSelection();
			View view = connection.getView();
			view.setIsSelected(true);
			markupTable.clearSelection();
			ReasoningWebFrame.getInstance().repaint();
		}
		
	}
	
	public void setSelectedConnection(GSConnection connection) {
		int index = ((ResourceTableModel)this.getModel()).getIndex(connection);
		if (index < 0) return;
		this.setRowSelectionInterval(index, index);
	}



}
