/* $Id: ReasoningWebFrame.java 1109 2016-05-19 00:05:03Z minao $ */
/*
 * 作成日: 2006/06/02
 *
 */
package smart_gs.reasoning_web.swingui;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Image;

import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JPanel;

import reasoning_web.logical.Connection;
import smart_gs.reasoning_web.desktop.logical.DeskTopFolder;
import smart_gs.reasoning_web.desktop.logical.DesktopElement;
import smart_gs.reasoning_web.desktop.swingui.FolderPanel;
import smart_gs.reasoning_web.desktop.swingui.ReasoningWebDesktop;
import smart_gs.reasoning_web.logical.GSConnection;
import smart_gs.reasoning_web.logical.GS_RWRepository;

/**
 * @author kazuaki kobayashi
 *
 * 
*/
@SuppressWarnings("serial")

public class ReasoningWebFrame extends JFrame {
	
	private static ReasoningWebFrame singleton = new ReasoningWebFrame();
		
	private ConnectionViewPanel connectionViewPanel;
	private DesktopPanel desktopPanel;
	public static final int CONNECTION_VIEW = 0;
	public static final int DESKTOP_VIEW = 1;
	private int mode = CONNECTION_VIEW;
	public static final int WIDTH = 1200;
	public static final int HEIGHT = 800;
	
	private GSConnection selectedConnection;
	
	
	private ReasoningWebFrame(){
		super("Reasoning Web Connection View");
		Image icon = new ImageIcon("./icons/SGS_icon.gif").getImage();
		this.setIconImage(icon);
		this.connectionViewPanel = new ConnectionViewPanel();
		this.desktopPanel = new DesktopPanel();	
		this.getContentPane().setLayout(new BorderLayout());
		this.setJMenuBar(new RWMenubar());
		this.getContentPane().add(this.connectionViewPanel.getToolBar(),BorderLayout.NORTH);
		this.getContentPane().add(this.connectionViewPanel,BorderLayout.CENTER);		
		this.setSize(WIDTH, HEIGHT);
	}
	
	public void setMainPanel(FolderPanel panel){
		this.desktopPanel.setMainPanel(panel);
	}
	
	//view modeの切り替え（link view-desktop view）
	public void setMode(int mode){
		this.mode = mode;
		if(this.mode == CONNECTION_VIEW){
			this.setTitle("Reasoning Web Connection View");
			this.getJMenuBar().setVisible(true);
			this.getContentPane().remove(this.desktopPanel);
			this.getContentPane().remove(this.desktopPanel.getToolBar());
			this.getContentPane().add(this.connectionViewPanel,BorderLayout.CENTER);
			this.getContentPane().add(this.connectionViewPanel.getToolBar(),BorderLayout.NORTH);
		}else if(this.mode == DESKTOP_VIEW){
			this.setTitle("Reasoning Web Desktop View");
			this.getJMenuBar().setVisible(false);
			this.getContentPane().remove(this.connectionViewPanel);
			this.getContentPane().remove(this.connectionViewPanel.getToolBar());
			this.getContentPane().add(this.desktopPanel,BorderLayout.CENTER);
			this.getContentPane().add(this.desktopPanel.getToolBar(),BorderLayout.NORTH);
		}
		validate();
		repaint();
	}
	
	//UtilityPanelから呼び出されるメソッド
	public static ReasoningWebFrame getInstance(){
		return singleton;
	}
	
	//DesctopPanelを呼び出す
	public void up(){
		if(this.mode == DESKTOP_VIEW){
				this.desktopPanel.up();
		}
	}
	public void upWithSelectedElements() {
		if(this.mode == DESKTOP_VIEW){
			Object[] elements = this.desktopPanel.getSelectedElements();
			if (elements == null) {
				this.desktopPanel.up();
			} else {
				this.desktopPanel.upWithSelectedElements(elements);
			}
		}
	}
	
	public DesktopPanel getDesktopPanel() {
		return desktopPanel;
	}
	
	public void reload(){
		
		connectionViewPanel.reload();
		desktopPanel.updateAll();
		validate();
		repaint();
	}
	
	public void initializeContentsAndFrame(){
		//these two initialize the contents
		GS_RWRepository.getInstance().initialize();
		ReasoningWebDesktop.getInstance().initialize();
		//this one initializes desktop panel
		desktopPanel.initialize();
		this.reload();
		validate();
		repaint();
	}
	
	public DeskTopFolder getCurrentFolder() {
		return this.desktopPanel.getCurrentFolder();
	}
	public RWElementsPanel getElementsPanel() {
		return this.connectionViewPanel.getElementsPanel();
	}

	public ConnectionViewPanel getConnectionViewPanel() {
		return this.connectionViewPanel;
	}

	public ResourceTable getMarkupTable() {
		return this.connectionViewPanel.getMarkupTable();
	}

	public ResourceTable getConnectionTable() {
		return this.connectionViewPanel.getConnectionTable();
	}

	public GSConnection getSelectedConnection() {
		return selectedConnection;
	}

	public void setSelectedConnection(GSConnection selectedConnection) {
		this.selectedConnection = selectedConnection;
	}
	
}
