package smart_gs.reasoning_web.swingui;

import java.awt.Color;
import java.awt.Component;

import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

public class ResourceTableCellRenderer extends DefaultTableCellRenderer {
	
	private int source;
	private int target;
	
	public ResourceTableCellRenderer(int source, int target) {
		super();
		this.source = source;
		this.target = target;
	}
	
	public ResourceTableCellRenderer() {
		super();
		this.source = -1;
		this.target = -1;
	}

	@Override
	public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
		super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
		if(row == this.source) {
			this.setBackground(Color.YELLOW);
		} else if (row == this.target) {
			this.setBackground(Color.CYAN);
		} else if (!isSelected) {
			this.setBackground(Color.WHITE);
		}
		return this;
	}

}
