package smart_gs.reasoning_web.swingui;

import java.util.ArrayList;
import java.util.List;

import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;

import reasoning_web.logical.Connection;
import smart_gs.GSConstants;
import smart_gs.debugprint.Debugprint;
import smart_gs.logical.GSResource;
import smart_gs.logical.IDAT;
import smart_gs.logical.Region;
import smart_gs.logical.Spread;
import smart_gs.logical.TextSegment;
import smart_gs.logical.URICreator;
import smart_gs.util.RegionSelectionDialog;
import smart_gs.reasoning_web.logical.GSConnection;
import smart_gs.reasoning_web.swingui.ResourceTable;

public abstract class ResourceTableModel extends DefaultTableModel {
	
	protected static String[] markupColumnIdentifiers = 
		{"TYPE", "USER", "DATE", "SPREAD", "DOCUMENT"};
	protected static String[] connectionColumnIdentifiers = 
		{"NAME", "USER", "DATE", "SOURCE", "TARGET", "NOTES"};
	
	public static final int MARKUP_TYPE = 0;
	public static final int MARKUP_USER = 1;
	public static final int MARKUP_DATE = 2;
	public static final int MARKUP_SPREAD = 3;
	public static final int MARKUP_DOCUMENT = 4;

	public static final int  CONNECTION_NAME = 0;
	public static final int  CONNECTION_USER = 1;
	public static final int  CONNECTION_DATE = 2;
	public static final int  CONNECTION_SOURCE = 3;
	public static final int  CONNECTION_TARGET = 4;
	public static final int  CONNECTION_NOTES = 5;

	public static final int MARKUP_COLUMN_COUNT = 5;
	public static final int CONNECTION_COLUMN_COUNT = 6;
	
	private ArrayList<GSResource> markups;
	private ArrayList<GSConnection> connections;
	

	
	public ResourceTableModel(int columnCount) {
		super(0, columnCount);
	}

	public void addMarkupRow(GSResource markup) {
		this.addRow(markupToStringList(markup));
	}

	public void setMarkups(ArrayList<GSResource> markups) {
		for (int i = 0; i < markups.size(); i++) {
			this.addMarkupRow(markups.get(i));
		}
		this.markups = markups;
	}
	
	public void addConnectionRow(GSConnection connection) {
		this.addRow(connectionToStringList(connection));
	}

	public void setConnections(ArrayList<GSConnection> connections) {
		for (int i = 0; i < connections.size(); i++) {
			this.addConnectionRow(connections.get(i));
		}
		this.connections = connections;
	}
	
	private static String[] markupToStringList(GSResource resource) {
		String[] strings = new String[ResourceTableModel.MARKUP_COLUMN_COUNT];
		if (resource.getTypeString().equals(URICreator.TEXT_SEGMENT)) {
			TextSegment segment = (TextSegment) resource;
			strings[MARKUP_DATE] = segment.getDate();
			strings[MARKUP_USER] = segment.getUserName();
			String documentName = "-";
			if (segment.getDocument().isIDAT()) {
				documentName = ((IDAT)segment.getDocument()).getNameToDisplay();
				int idatType = ((IDAT)segment.getDocument()).getType();
				if (documentName == null) {
					if (idatType == GSConstants.FIRSTIDAT) {
						documentName = GSConstants.DEFAULT_FIRST_IDAT_NAME;
					} else if (idatType == GSConstants.SECONDIDAT) {
						documentName =GSConstants.DEFAULT_SECOND_IDAT_NAME;
					} else if (idatType == GSConstants.THIRDIDAT) {
						documentName =GSConstants.DEFAULT_THIRD_IDAT_NAME;
					} else if (idatType == GSConstants.OCRIDAT) {
						documentName =GSConstants.DEFAULT_OCR_IDAT_NAME;
					}
				}
			} else {
				documentName = segment.getDocument().getName();
			}
			if (documentName == null || documentName.equals("")) {
				documentName = "-";
			}
			strings[MARKUP_DOCUMENT] = documentName;
			strings[MARKUP_TYPE] = URICreator.TEXT_SEGMENT;
			if (segment.getDocument().isIDAT()) {
				Spread spread = ((IDAT) segment.getDocument()).getSpread();
				strings[MARKUP_SPREAD] = spread.getName();
			} else {
				strings[MARKUP_SPREAD] = "-";
			}
		} else {
			Region region = (Region) resource;
			strings[MARKUP_DATE] = region.getDate();
			strings[MARKUP_USER] = region.getUserName();
			strings[MARKUP_SPREAD] = region.getSpread().getName();
			String type = region.getTypeString();
			if (type == "rect") {
				type = "rectangle";
			}
			strings[MARKUP_TYPE] = type;
			strings[MARKUP_DOCUMENT] = "-";
		}
		return strings;
	}
	
	private static String[] connectionToStringList(GSConnection connection) {
		String[] strings = new String[6];
		strings[CONNECTION_NAME] = connection.getName();
		strings[CONNECTION_DATE] = connection.getDate();
		strings[CONNECTION_USER] = connection.getUserName();
		strings[CONNECTION_SOURCE] = connection.getSourcePointer().getURI();
		strings[CONNECTION_TARGET] = connection.getSourcePointer().getURI();
		String notes = connection.getExplanatoryNote().getSource();
//		if (notes.startsWith("<xml><html>") && notes.endsWith("</html></xml>")) {
//			notes = notes.substring(11, notes.length()-13);
//		}
		strings[CONNECTION_NOTES] = notes;
		return strings;
	}


	public void removeAllRows() {
		while (this.getRowCount() > 0) {
			this.removeRow(0);
		}
		this.markups = null;
		this.connections = null;
	}


	public ArrayList<GSResource> getMarkups() {
		return this.markups;
	}

	public ArrayList<GSConnection> getConnections() {
		return this.connections;
	}

	public int getIndex(GSConnection element) {
		int index = -1;
		if (this.connections != null) {
			for (int i = 0; i < this.connections.size(); i++) {
				if (this.connections.get(i) == element) {
					index = i;
				}
				
			}
		}
		return index;
	}

	public int getIndex(GSResource element) {
		int index = -1;
		if (this.markups != null) {
			for (int i = 0; i < this.markups.size(); i++) {
				if (this.markups.get(i) == element) {
					index = i;
				}
				
			}
		}
		return index;
	}


}