/* $Id: LineSegEditorNorthPanel.java 626 2013-01-13 18:51:36Z shayashi $ */
package smart_gs.smleditor.swingui;

import java.awt.BorderLayout;

import javax.swing.JPanel;

import smart_gs.logical.Preference;
import smart_gs.swingui.AbstractGSWindow;
import smart_gs.swingui.toolbar.HistoryToolBar;
import smart_gs.swingui.toolbar.ImageToolBar;
import smart_gs.swingui.toolbar.action.LineSegEditorTiltImagePanel;
import sml_editor.logical.LineDirection;

/* this panel is used exclusively by LineSegEditor.
 * It is the same to the full editor except the default
 * menu bar, which includes save, load, etc.
 */
@SuppressWarnings("serial")
public class LineSegEditorNorthPanel extends JPanel{
	
	private LineSegEditorGSMenuBar menuBar;
	private LineSegEditorToolBarPanel toolBarPanel;
	private LineSegEditorTiltImagePanel tiltPanel;
	
	public LineSegEditorNorthPanel(AbstractGSWindow parent){

	}
	
	public LineSegEditorNorthPanel(LineSegEditorTiltImagePanel tiltPanel,
			LineSegEditor parent) {
		this.menuBar = new LineSegEditorGSMenuBar(parent,Preference.getInstance().getLineSegFileDefaultType());
		this.toolBarPanel = new LineSegEditorToolBarPanel(parent);
		this.tiltPanel = tiltPanel;
		this.setLayout(new BorderLayout());
		this.add(this.menuBar, BorderLayout.NORTH);
		this.add(this.toolBarPanel, BorderLayout.WEST);
		this.add(this.tiltPanel,  BorderLayout.EAST);
		this.validate();
	}

	public void setLineDirectionIcon(LineDirection direction) {
		this.toolBarPanel.setLineDirectionIcon(direction);
	}

	public 	HistoryToolBar getHistoryToolBar(){
		return this.toolBarPanel.getHistoryToolBar();
	}

	public 	LineSegEditorToolBarPanel getToolBarPanel(){
		return this.toolBarPanel;
	}
	public 	LineSegEditorToolBar getToolBar(){
		return this.toolBarPanel.getToolBar();
	}
}
