/* $Id: AbstractGSWindow.java 1039 2015-11-23 16:04:25Z shayashi $ */
package smart_gs.swingui;


import java.awt.Image;
import java.awt.event.ActionListener;

import javax.swing.ImageIcon;
import javax.swing.JFrame;

import smart_gs.drawing_tool.SpreadCanvas;
import smart_gs.drawing_tool.drawing_mode.Mode;
import smart_gs.logical.Spread;
import smart_gs.smleditor.swingui.GSEditorFrame;
import smart_gs.smleditor.swingui.GSTabbedPane;
import smart_gs.swingui.toolbar.action.CloseupActionListener;
import smart_gs.swingui.toolbar.action.DeleteActionListener;
import smart_gs.swingui.toolbar.action.DrawBookmarkActionListener;
import smart_gs.swingui.toolbar.action.DrawMarkerActionListener;
import smart_gs.swingui.toolbar.action.DrawMemoPadActionListener;
import smart_gs.swingui.toolbar.action.DrawPolygonActionListener;
import smart_gs.swingui.toolbar.action.DrawRectangleActionListener;
import smart_gs.swingui.toolbar.action.ReasoningWebActionListener;
import smart_gs.swingui.toolbar.action.RedoActionListener;
import smart_gs.swingui.toolbar.action.SelectActionListener;
import smart_gs.swingui.toolbar.action.UndoActionListener;
import smart_gs.swingui.toolbar.action.ZoomInOutActionListener;

public abstract class AbstractGSWindow extends JFrame implements GSEditorFrame{
	
	protected GSTabbedPane tabbedPane;
	private static final Image icon = new ImageIcon("./icons/SGS_icon.gif").getImage();
	
	public final SelectActionListener select;
	public final DrawPolygonActionListener polygon;
	public final DrawRectangleActionListener rectangle;
	public final DrawMarkerActionListener marker;
	public final DrawMemoPadActionListener memopad;
	public final DrawBookmarkActionListener bookmark;
	public final DrawPolygonActionListener tmppolygon;
	public final DrawRectangleActionListener tmprectangle;
	public final DrawMarkerActionListener tmpmarker;
	public final DrawBookmarkActionListener tmpbookmark;
	public final CloseupActionListener closeup;
	public final DeleteActionListener delete;
	public final ZoomInOutActionListener zoomIn;
	public final ZoomInOutActionListener zoomOut;
	public final ZoomInOutActionListener fullSize;
	public final ZoomInOutActionListener fitWidth;
	public final ZoomInOutActionListener fitHeight;
	public final ActionListener resourceBasket;
	public final ActionListener reasoningWeb;
	public final ActionListener undo;
	public final ActionListener redo;
	
	public AbstractGSWindow(String title){
		super(title);
		this.setIconImage(icon);

		this.select                = new SelectActionListener(this);
		this.delete                = new DeleteActionListener(this);
		this.rectangle       	   = new DrawRectangleActionListener(this);
		this.polygon               = new DrawPolygonActionListener(this);
		this.marker                = new DrawMarkerActionListener(this);
		this.memopad               = new DrawMemoPadActionListener(this);
		this.bookmark              = new DrawBookmarkActionListener(this);
		this.tmprectangle          = new DrawRectangleActionListener(this).setTmp(true);
		this.tmppolygon            = new DrawPolygonActionListener(this).setTmp(true);
		this.tmpmarker             = new DrawMarkerActionListener(this).setTmp(true);
		this.tmpbookmark           = new DrawBookmarkActionListener(this).setTmp(true);
		this.closeup               = new CloseupActionListener(this);
		this.zoomIn                = new ZoomInOutActionListener(this,"ZoomIn");
		this.zoomOut               = new ZoomInOutActionListener(this,"ZoomOut");
		this.fullSize              = new ZoomInOutActionListener(this,"FullSize");
		this.fitWidth              = new ZoomInOutActionListener(this,"FitWidth");
		this.fitHeight             = new ZoomInOutActionListener(this,"FitHeight");
		this.resourceBasket        = new ReasoningWebActionListener(this,"rb");
		this.reasoningWeb          = new ReasoningWebActionListener(this,"rw");
		this.undo                  = new UndoActionListener(this);
		this.redo                  = new RedoActionListener(this);
		
	}
	
	public abstract GSTabbedPane createTabbedPane(Spread spread);
	
	public GSTabbedPane getTabbedPane() {
		return this.tabbedPane;
	}
	
	public void close(){
		this.tabbedPane.clear();
	}
	
	public abstract void setSpread(Spread spread);
	public abstract Spread getSpread();
	public abstract void initializeGUI(Spread spread);
	
	public abstract SpreadCanvas getSpreadCanvas();
	public abstract void setMode(Mode mode);
	
}
