package smart_gs.swingui;

import java.awt.BorderLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.geom.Point2D;

import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.text.StyleContext;

import smart_gs.GSConstants;
import smart_gs.drawing_tool.drawing_mode.LineSegEditorTiltImagePanelLevelLineMode;
import smart_gs.smleditor.swingui.LineSegEditor;
import smart_gs.swingui.toolbar.action.LineSegEditorMoveAndResizeFrameButtonsActionListener;
import smart_gs.swingui.toolbar.action.LineSegEditorRotateFrameButtonsActionListener;
import smart_gs.swingui.toolbar.action.LineSegEditorTiltImagePanel;

public class LineSegEditorRotationFrame extends JFrame {

	private LineSegEditor editor;
	private int x=-1, y=-1;

	public LineSegEditorRotationFrame(LineSegEditor editor) {
		super("Rotate Line Segments");
		SetIcon.setIcon(this);
		this.editor = editor;
		
		// rotate buttons panel
		JPanel rotationbuttonspanel = new JPanel();
		rotationbuttonspanel.setLayout(new GridLayout(1,2));
		JButton clockwise = new JButton(new ImageIcon(GSConstants.ICON_PATH+"rotateclockwise.png"));
		clockwise.addActionListener(new LineSegEditorRotateFrameButtonsActionListener(this.editor,this,(double) 0.01));
		JButton anticlockwise = new JButton(new ImageIcon(GSConstants.ICON_PATH+"rotateanticlockwise.png"));
		anticlockwise.addActionListener(new LineSegEditorRotateFrameButtonsActionListener(this.editor,this,(double) -0.01));
		rotationbuttonspanel.add(anticlockwise);
		rotationbuttonspanel.add(clockwise);
		setCenterPoint(0,0);

		this.add(rotationbuttonspanel);
		this.validate();
		this.pack();
		this.setSize(270,170);
		this.setLocationRelativeTo(this.editor);
		this.setAlwaysOnTop(true);
	}

	public void setCenterPoint(int x, int y) {
		this.x = x;
		this.y = y;
	}
	
	public int getCenterX() {
		return this.x;
	}

	public int getCenterY() {
		return this.y;
	}


}
