/* $Id: MoveTreeToolBar.java 1021 2015-10-18 13:40:46Z shayashi $ */
package smart_gs.swingui.toolbar;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;

import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JToolBar;

import smart_gs.GSConstants;
import smart_gs.drawing_tool.ImageLabel.Show;
import smart_gs.logical.Spread;
import smart_gs.smleditor.swingui.GSEditor;
import smart_gs.smleditor.swingui.GSTabbedPane;
import smart_gs.swingui.AbstractGSWindow;
import smart_gs.swingui.WorkspaceTabbedPane;
import smart_gs.swingui.WorkspaceWindow;

@SuppressWarnings("serial")
public class MoveTreeToolBar extends JToolBar implements ActionListener{
	protected JButton prev;
	protected JButton next;
	
	protected int historycounter = 0;
	protected int pathCount = 0;
	
	private AbstractGSWindow parent;
	public MoveTreeToolBar(AbstractGSWindow parent) {
		prev = new JButton(new ImageIcon(GSConstants.ICON_PATH + "prev_page.png"));
		prev.setEnabled(false);
		prev.addActionListener(this);
		prev.setActionCommand("prev");
		prev.setToolTipText("Previous page (Alt + UP)");
		prev.setMnemonic(KeyEvent.VK_UP);
		this.add(prev);

		next = new JButton(new ImageIcon(GSConstants.ICON_PATH + "next_page.png"));
		next.setEnabled(false);
		next.addActionListener(this);
		next.setActionCommand("next");
		next.setToolTipText("Next page (Alt + DOWN)");
		next.setMnemonic(KeyEvent.VK_DOWN);
		this.add(next);

		this.parent = parent;
	}

	public void actionPerformed(ActionEvent e) {
		int scale = parent.getSpreadCanvas().imageLabel.scale;
		int chosen_IDAT_index = parent.getTabbedPane().getSelectedIndex();
		Show lineSegment = parent.getSpreadCanvas().imageLabel.getLineSegShowingMode();
		boolean canceled = false;
		if(e.getActionCommand().equals("next")){
			Spread spread = WorkspaceWindow.getInstance().getSpreadInTree(pathCount + 1);
			if(spread != null) {
				if(!(parent instanceof GSEditor)) {
					WorkspaceWindow workspaceWindow = WorkspaceWindow.getInstance();
					canceled = workspaceWindow.setSpreadToMoveInSpreadTree(spread);
//					if (canceled) return; // do nothing
					workspaceWindow.setImageSearch(spread.toString());
					workspaceWindow.getTabbedPane().setSelectedIndex(chosen_IDAT_index);
					workspaceWindow.getSpreadCanvas().imageLabel.setScale(scale);
					workspaceWindow.getHistoryToolBar().setHistoryCanvasScale(scale);
					workspaceWindow.getSpreadCanvas().imageLabel.setLineSegShowingMode(lineSegment);
					workspaceWindow.getSpreadCanvas().imageLabel.showImage();
				} else { // GSEditor 
					GSEditor editor = (GSEditor) parent;
					editor.setSpread(spread);
					editor.getSpreadCanvas().imageLabel.setScale(scale);
					editor.getTabbedPane().setSelectedIndex(chosen_IDAT_index);
					editor.getSpreadCanvas().imageLabel.setLineSegShowingMode(lineSegment);
					editor.getSpreadCanvas().imageLabel.showImage();
//					editor.updateMoveToolBar();
				}
			}
		} else if(e.getActionCommand().equals("prev")) {
			Spread spread = WorkspaceWindow.getInstance().getSpreadInTree(pathCount - 1);
			if(spread != null) {
				if(!(parent instanceof GSEditor)) {
					WorkspaceWindow workspaceWindow = WorkspaceWindow.getInstance();
					canceled = workspaceWindow.setSpreadToMoveInSpreadTree(spread);
					if (canceled) return; // do nothing
					workspaceWindow.setImageSearch(spread.toString());
					workspaceWindow.getTabbedPane().setSelectedIndex(chosen_IDAT_index);
					workspaceWindow.getSpreadCanvas().imageLabel.setScale(scale);
					workspaceWindow.getHistoryToolBar().setHistoryCanvasScale(scale);
					workspaceWindow.getSpreadCanvas().imageLabel.setLineSegShowingMode(lineSegment);
					workspaceWindow.getSpreadCanvas().imageLabel.showImage();
				} else { // GSEditor
					GSEditor editor = (GSEditor) parent;
					editor.setSpread(spread);
					editor.getSpreadCanvas().imageLabel.setScale(scale);
					editor.getTabbedPane().setSelectedIndex(chosen_IDAT_index);
					editor.getSpreadCanvas().imageLabel.setLineSegShowingMode(lineSegment);
					editor.getSpreadCanvas().imageLabel.showImage();
//					editor.updateMoveToolBar();
				}
			}
		}
	}

	public void setPathCount(int pathCount){
		this.pathCount = pathCount;
		{
			Spread spread = WorkspaceWindow.getInstance().getSpreadInTree(pathCount + 1);
			if(spread != null){
				next.setEnabled(true);
			}else{
				next.setEnabled(false);
			}
		}
		{
			Spread spread = WorkspaceWindow.getInstance().getSpreadInTree(pathCount - 1);
			if(spread != null){
				prev.setEnabled(true);
			}else{
				prev.setEnabled(false);
			}
		}
	}
}
