package smart_gs.swingui.toolbar.action;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;

import javax.swing.JFileChooser;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;

import smart_gs.diff.GsxComparator;
import smart_gs.diff.swingui.DiffViewer;
import smart_gs.logical.Preference;
import smart_gs.swingui.WorkspaceWindow;

public class CompareActionListener implements ActionListener {

	public CompareActionListener() {
		// TODO Auto-generated constructor stub
	}

	@Override
	public void actionPerformed(ActionEvent e) {
		Preference preference = Preference.getInstance();
		String currentDirectory = preference.getGsFolderPathString();

		JFileChooser chooser = new JFileChooser(currentDirectory);
		chooser.setFileFilter(new GSFileFilter());

		int input = chooser.showOpenDialog(WorkspaceWindow.getInstance());
		if (input == JFileChooser.CANCEL_OPTION) {
			return;
		}
		File target = chooser.getSelectedFile();
		compare(target);
	}

	private void compare(File target) {
		GsxComparator comparator = new GsxComparator(target);
		TreeModel diffTree = comparator.compare();
		DiffViewer viewer = new DiffViewer(diffTree);
		viewer.setVisible(true);
	}

	private TreeModel stub() {
		final ArrayList<String> sample = new ArrayList<String>();
		sample.add("Number");
		sample.add("Two");
		sample.add("Three");
		sample.add("Four");
		sample.add("Five");
		sample.add("Six");

		final ArrayList<String> sampleDigit = new ArrayList<String>();
		sampleDigit.add("Digit");
		sampleDigit.add("1");
		sampleDigit.add("2");
		sampleDigit.add("3");
		sampleDigit.add("4");
		sampleDigit.add("5");
		sampleDigit.add("6");

		DefaultMutableTreeNode obj = new DefaultMutableTreeNode("JTree") {
			{
				DefaultMutableTreeNode node_1;
				DefaultMutableTreeNode node_2;
				node_1 = new DefaultMutableTreeNode(sampleDigit.get(0));
				for (int i = 1; i < sampleDigit.size(); i++) {
					node_1.add(new DefaultMutableTreeNode(sampleDigit.get(i)));
				}

				add(node_1);
				node_2 = new DefaultMutableTreeNode(sample.get(0));
				for (int i = 1; i < sample.size(); i++) {
					node_2.add(new DefaultMutableTreeNode(sample.get(i)));
				}

				add(node_2);
			}
		};
		return new DefaultTreeModel(obj);

	}

}
