package smart_gs.swingui.toolbar.action;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import smart_gs.drawing_tool.drawing_mode.BookmarkMode;
import smart_gs.drawing_tool.drawing_mode.Mode;
import smart_gs.drawing_tool.state.DefaultState;
import smart_gs.swingui.AbstractGSWindow;
import smart_gs.swingui.WorkspaceWindow;

public class DrawBookmarkActionListener implements ActionListener {

	private boolean tmpRegion;

	public DrawBookmarkActionListener(AbstractGSWindow abstractGSWindow) {
		this.tmpRegion = false;
	}

	@Override
	public void actionPerformed(ActionEvent e) {
		Mode mode0 = BookmarkMode.getInstance();
		if (WorkspaceWindow.getInstance().onlyOneOfAltCtrlShiftIsPressed()) {
			mode0.setTemporary(true);
			DefaultState.getInstance().setMode(mode0);
		} else {
			mode0.setTemporary(this.tmpRegion);
			DefaultState.getInstance().setMode(mode0);
		}
	}
	
	public DrawBookmarkActionListener setTmp(boolean b) {
		this.tmpRegion = b; 
		return this;
	}

}
