package smart_gs.swingui.toolbar.action;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import smart_gs.drawing_tool.drawing_mode.MarkerMode;
import smart_gs.drawing_tool.drawing_mode.Mode;
import smart_gs.drawing_tool.drawing_mode.PolygonMode;
import smart_gs.drawing_tool.state.DefaultState;
import smart_gs.swingui.AbstractGSWindow;
import smart_gs.swingui.WorkspaceWindow;

public class DrawPolygonActionListener implements ActionListener {

	private boolean tmpRegion;

	public DrawPolygonActionListener(AbstractGSWindow abstractGSWindow) {
		this.tmpRegion = false;
	}

	@Override
	public void actionPerformed(ActionEvent e) {
		Mode mode0 = PolygonMode.getInstance();
		if (WorkspaceWindow.getInstance().onlyOneOfAltCtrlShiftIsPressed()) {
			mode0.setTemporary(true);
			DefaultState.getInstance().setMode(mode0);
		} else {
			mode0.setTemporary(this.tmpRegion);
			DefaultState.getInstance().setMode(mode0);
		}
	}
	
	public DrawPolygonActionListener setTmp(boolean b) {
		this.tmpRegion = b;
		return this;
	}
}
