package smart_gs.swingui.toolbar.action;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;

import javax.swing.JOptionPane;
import javax.swing.JFrame;

import smart_gs.drawing_tool.ImageLabel;
import smart_gs.drawing_tool.SpreadCanvas;
import smart_gs.drawing_tool.state.DefaultState;
import smart_gs.drawing_tool.state.State;
import smart_gs.drawing_tool.state.UniSelectedState;
import smart_gs.image_search.GSSearchEngine;
import smart_gs.logical.LineSegmentForEdit;
import smart_gs.logical.Spread;
import smart_gs.smleditor.swingui.LineSegEditor;
import smart_gs.swingui.AbstractGSWindow;
import smart_gs.swingui.LineSegEditorMoveAndResizeFrame;

public class LineSegEditorMoveAndResizeFrameButtonsActionListener implements ActionListener{
	
	private LineSegEditor editor;
	private int type;
	private int edit;
	
	

	public LineSegEditorMoveAndResizeFrameButtonsActionListener(LineSegEditor parent,int a, int b){
		this.editor = parent;
		this.type = a;
		this.edit = b;		
	}
	
	
	public void execute(){
		this.editor.pushUndoStack();
		LineSegmentForEdit line = editor.getLinesForEdit().get(0);
		if(line == null){
			JOptionPane.showMessageDialog(new JFrame(), "null","error",  JOptionPane.INFORMATION_MESSAGE);
			return;
		}
		if(this.type == 0){
			if(this.edit == 0){
				editor.changeLinesSize(100-0.5*this.editor.getResizeMagnificaiton());
			}
			else{
				editor.changeLinesSize(100+0.5*this.editor.getResizeMagnificaiton());
			}
		}
		else if(this.edit == 0){
			editor.slideLines(0, -5);
		}
		else if(this.edit == 1){
			editor.slideLines(0, 5);
		}
		else if(this.edit == 2){
			editor.slideLines(5, 0);
		}
		else{
			editor.slideLines(-5, 0);
		}
		
	}
	
	public void actionPerformed(ActionEvent e){
		this.execute();
		this.editor.invalidate();
		this.editor.validate();
		this.editor.repaint();
	}
		
	
}
