package smart_gs.swingui.toolbar.action;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.text.NumberFormat;

import javax.swing.JButton;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JWindow;

import smart_gs.drawing_tool.ImageLabel;
import smart_gs.drawing_tool.drawing_mode.LineSegEditorSelectMode;
import smart_gs.logical.Spread;
import smart_gs.smleditor.swingui.LineSegEditor;
import smart_gs.util.GSLog;

public class LineSegEditorTiltImagePanel extends JPanel {

	LineSegEditor callerEditor;
	double degree=0.0;
	double old_degree=0.0;
	JFormattedTextField field;
	GSLog log = GSLog.getInstance();

	public LineSegEditorTiltImagePanel(LineSegEditor editor) {
		this.callerEditor = editor;
		setLayout(new FlowLayout());
		NumberFormat nf = NumberFormat.getNumberInstance();
		nf.setGroupingUsed(false);
		this.field = new JFormattedTextField(nf);
		this.field.setEditable(false);
			
		this.field.setPreferredSize(new Dimension(40, 30));
		field.setValue(degree);
		add(field);
		
		JButton levelLine = new JButton("Level Line");
		levelLine.setToolTipText("Draw level line for tilting");
		levelLine.addActionListener(new LineSegEditorTiltImagePanelLevelLineActionListener(editor));
		this.add(levelLine);
		
		JButton tiltButton = new JButton("Tilt");
		tiltButton.setToolTipText("Tilt Image");
		tiltButton.addActionListener(new LineSegEditorTiltImagePanelTiltActionListener(editor));
		add(tiltButton);
		
		JButton untiltButton = new JButton("Undo Tilt/Cancel");
		untiltButton.setToolTipText("Tilt the image to the original position");
		untiltButton.addActionListener(new LineSegEditorTiltImagePanelUnTiltActionListener(editor));
		add(untiltButton);
		
		
		JButton upButton = new JButton("Up");
		untiltButton.setToolTipText("Up the tilt degree by 0.01");
		upButton.addActionListener(new LineSegEditorTiltImagePanelUpDownActionListener(editor,this,-0.01d));
		add(upButton);
		
		JButton downButton = new JButton("Down");
		untiltButton.setToolTipText("Down the tilt degree by 0.01");
		downButton.addActionListener(new LineSegEditorTiltImagePanelUpDownActionListener(editor,this,0.01d));
		add(downButton);
		
		
//		setPreferredSize(new Dimension(100, 60));
		setVisible(true);
		validate();
		repaint();
	}

	public Double getDegree() {
		return this.degree;
	}

	public void setDegree(double degree) {
		this.degree = degree;
		this.field.setValue(degree);
		this.callerEditor.validate();
		this.callerEditor.repaint();
		this.field.repaint();
	}

	public void saveOldDegree() {
		this.old_degree = this.degree;
	}
	
	public void popOldDegree() {
		this.degree = this.old_degree;
	}
	
	public Double getOldDegree() {
		return this.old_degree;
	}

	public void restoreOldDegree() {
		this.degree = this.old_degree;		
	}

}
