package smart_gs.transcription_tool.tesseract;

import java.io.IOException;

public class TesseractRunner {
	
	public void exec(String in, String out, String lang) throws TesseractRuntimeException {
		try {
			Runtime r = Runtime.getRuntime();
			String[] command = {"tesseract", "-l", lang, in, out, "hocr"};
			Process p = r.exec(command);
			p.waitFor();
			int exitValue = p.exitValue();
			switch(exitValue) {
			case 0 : 
				System.out.println("tesseract process successfully completed.");
				break;
			case 127 :			
				throw new TesseractRuntimeException("Tesseract command not found. Please install tesseract to your machine.");
			default :				
				throw new TesseractRuntimeException("Invoking tesseract process failed for unknown reasons.");
			}	
		} catch (IOException e) {
			throw new TesseractRuntimeException("Invoking tesseract process failed for I/O error.");
		} catch (InterruptedException e) {
			String msg = "Tesseract process was interrupted for unknown reasons.";
			throw new TesseractRuntimeException(msg);
		} 
	}
}
