/* $Id: SmlNode.java 125 2011-03-09 09:49:51Z ohura $ */
/*
 * 作成日： 2004/10/12
 *
 * TODO この生成されたファイルのテンプレートを変更するには次を参照。
 * ウィンドウ ＞ 設定 ＞ Java ＞ コード・スタイル ＞ コード・テンプレート
 */
package sml_editor.node;

import org.w3c.dom.Node;

/**
 * @author kawamura
 *
 * TODO この生成された型コメントのテンプレートを変更するには次を参照。
 * ウィンドウ ＞ 設定 ＞ Java ＞ コード・スタイル ＞ コード・テンプレート
 */
public interface SmlNode {
    /**
     * The node is an <code>Element</code>.
     */
    public static final short ELEMENT_NODE              = 1;
    /**
     * The node is an <code>Attr</code>.
     */
    public static final short ATTRIBUTE_NODE            = 2;
    /**
     * The node is a <code>Text</code> node.
     */
    public static final short TEXT_NODE                 = 3;
    /**
     * The node is a <code>CDATASection</code>.
     */
    public static final short COMMENT_NODE              = 8;
    /**
     * The node is a <code>Document</code>.
     */
    public static final short DOCUMENT_NODE             = 9;
    /**
     * The node is a <code>BR</code>
     */
    public static final short BR_NODE                   = 13;

    
	public Node getNode();
	public int getLength();

	public SmlNode getParentNode();
	public void setParentNode(SmlElement parent);

	public SmlNode appendChild(SmlNode newChild);
	public SmlNode removeChild(SmlNode oldChild);
	public SmlNode replaceChild(SmlNode newChild, SmlNode oldChild);
	public SmlNode insertBefore(SmlNode newChild, SmlNode refChild);
	
	public SmlNode getFirstChild();
	public SmlNode getLastChild();

	public SmlNode getNextSibling();
	public SmlNode getPreviousSibling();

	public String getNodeName();
	public short getNodeType();

	public boolean hasAttributes();
	
	public void setNodeValue(String nodeValue);
	public String getNodeValue();
	
	/**
	 * anotherNode がこのノードの上位ノードである場合、true を返す。
	 * this == anotherNodeの場合もtrueを返す。
	 * @param anotherNode - このノードの上位ノードかどうかを調べるノード
	 * @return このノードが anotherNode の下位ノードである場合は true
	 */
	public boolean isNodeAncestor(SmlNode anotherNode);
	
	/**
	 * このノードと anotherNode にもっとも近い共通の上位ノードを返す。
	 * 一方が他方の上位ノードの場合は上位であるほうのノードを返す。
	 * @param anotherNode - 共通の上位ノードを見つけるノード
	 * @return このノードと anotherNode にもっとも近い共通の上位ノード。
	 * ない場合は null
	 */
	public SmlNode getSharedAncestor(SmlNode anotherNode);
	
	/**
	 * ルートからこのノードまでの深さを返す。
	 * @return ルートからの深さ
	 */
	public int getLevel();

	/**
	 * このノードが root element か判定する
	 * @return このノードが root なら true
	 */
	public boolean isRootElement();
	
	/**
	 * root elementからこのノードまでのパスを返す。例えばこのノードが
	 * root elementの2番目の子の4番目の子の3番目の子である場合、
	 * 戻り値は "/2/4/3" というStringになる。
	 * @return
	 */
	public String getPathFromRootElement();
	
}
