/* $Id: EditorMouseListener.java 972 2015-08-17 00:24:12Z shayashi $ */
package sml_editor.swingui;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;

import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.html.HTML;

import smart_gs.logical.TextSegment;
import smart_gs.reasoning_web.swingui.DirectLinkPanel;
import smart_gs.reasoning_web.swingui.RWGlobalViewPanel;
import smart_gs.reasoning_web.swingui.ReasoningWebFrame;
import smart_gs.smleditor.swingui.GSEditorTextPane;
import sml_editor.swingui.mouse_state.DefaultMouseMode;
import sml_editor.swingui.mouse_state.MouseMode;


public class EditorMouseListener extends MouseAdapter implements MouseMotionListener{
	
	protected EditorTextPane textPane;
	private static MouseMode mouseMode; 
	static{
		mouseMode = DefaultMouseMode.getInstance();
	}
	
	protected EditorMouseListener(EditorTextPane textPane){
		this.textPane = textPane;
	}
	public static void restoreDefaultMouseMode(){
		mouseMode = DefaultMouseMode.getInstance();
	}
	public static void setMouseMode(MouseMode mode){
		EditorMouseListener.mouseMode = mode;
	}
	
	public void mouseClicked(MouseEvent e) {
		mouseMode.mouseClicked(e,textPane);
		//2007/10/30 kazuhiro kobayashi
		SimpleAttributeSet element = textPane.getSelectID(e.getPoint());
		if(element == null){
			return;
		}
		int id = -1;
		try{
			id = new Integer((String)element.getAttribute(HTML.Attribute.HREF)).intValue();
		}catch(NumberFormatException ex){}
		TextSegment segment = ((GSEditorTextPane)textPane).getSmartDocument().getSegmentByID(id);
		ReasoningWebFrame.getInstance().getElementsPanel().setElement(segment);
		RWGlobalViewPanel.getInstance().setSelectedElement(segment);
		RWGlobalViewPanel.getInstance().repaint(); 
	}

	public void mouseEntered(MouseEvent e) {
		mouseMode.mouseEntered(e,textPane);	
	}

	public void mouseExited(MouseEvent e) {
		mouseMode.mouseExited(e,textPane);
	}

	public void mousePressed(MouseEvent e) {
		mouseMode.mousePressed(e,textPane);
	}

	public void mouseReleased(MouseEvent e) {
		mouseMode.mouseReleased(e,textPane);
	}

	public void mouseDragged(MouseEvent e) {
		mouseMode.mouseDragged(e,textPane);
	}

	public void mouseMoved(MouseEvent e) {
		mouseMode.mouseMoved(e,textPane);
	}
}
