/*
Linusが後悔しているらしい、『ダイレクトIO』を使用する
大量のファイルをコピーすると遅い
*/

#define _GNU_SOURCE
#define _XOPEN_SOURCE 600

#include "global.h"
#include "struct.h"
#include "enum.h"

#include "snowcp.h"
#include "ch_time_mod.h"
#include "compare.h"
#include "hash_function.h"
#include "log.h"
#include "rw_thread.h"

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <limits.h>

#include <unistd.h>
#include <fcntl.h>
#include <sys/stat.h>
#include <sys/mman.h>
#include <pthread.h>

struct fd_buf_num
{
	int ifrom;
	int ito;
	int read_buf_num;
	int write_buf_num;
	int read_zero;
	long long from_size;
	long long write_size;
};

static void *buf[2];
static int buffer_size_local;
volatile static long long next_write_size[2];
volatile static long long total_read_local = 0;
volatile static long long total_write_local = 0;

// 関数プロトタイプ
void rw_thread_d(struct cp_target *cp_tmp);
static void * r_func(void *read_t);
static void * w_func(void *write_t);

/*******************************************************************************

*******************************************************************************/
void rw_thread_d(struct cp_target *cp_tmp)
{
	pthread_t t1;
	pthread_t t2;
	struct stat stat_buf;
	struct fd_buf_num rw;
	rw.read_zero = -1;
	errno = 0;

	if((rw.ifrom = open(cp_tmp->from, O_RDONLY | O_NOATIME | O_DIRECT)) == -1)
	{
		log_errors(__FILE__, __LINE__, errno, cp_tmp->from);
		errno = 0;
	}
	if((rw.ito = open(cp_tmp->to, O_WRONLY | O_DIRECT | O_CREAT, S_IRUSR | S_IWUSR)) == -1);
	{
		// 何か普通に戻り値が-1なんだが…ちゃんとO_CREATしてるのに…
		if((errno > 0))
		{
			log_errors(__FILE__, __LINE__, errno, cp_tmp->to);
		}
	}

	// signalハンドラ用
	write_now = cp_tmp->to;

	// open出来たらこのチェックは要らない気がする
	if(fstat(rw.ifrom, &stat_buf) == -1)
	{
		log_errors(__FILE__, __LINE__, errno, cp_tmp->from);
		rw.from_size = -1;
	}
	else
	{
		rw.from_size = stat_buf.st_size;
		/*
		コピー前にファイルをトランケート。いわゆるsparse file化。
		Windowsだと断片化防止に効果があるのだが、Linuxだと？

		1.2TBほどコピーしてみたあと、fsckを実行してみたら、
		non-contiguousは3.2%だった。効果無し？
		*/
		//if(ftruncate(rw.ito, stat_buf.st_size) == -1)
			//log_errors(__FILE__, __LINE__, errno, cp_tmp->to);
	}

	if(rw.from_size > 0)
	{
		if(cp_tmp->copy_mode == SAME)
		{
			buffer_size_local = buffer_size;
			if(posix_memalign((void *)&buf[0], 512, buffer_size_local) != 0)
			{
				log_errors(__FILE__, __LINE__, errno, cp_tmp->to);
			}
			for(;;)
			{
				rw.read_buf_num = 0;
				pthread_create(&t1, NULL, r_func, (void *)&rw);
				pthread_join(t1, NULL);

				rw.write_buf_num = 0;
				pthread_create(&t1, NULL, w_func, (void *)&rw);
				pthread_join(t1, NULL);

				if((rw.from_size <= total_write_local) || (rw.write_size <= 0))
					break;
			}

			free(buf[0]);
		}
		else
		{
			// バッファを同時に二つ使用するので
			buffer_size_local = buffer_size / 2;
			if((posix_memalign((void *)&buf[0], 512, buffer_size_local) != 0) || (posix_memalign((void *)&buf[1], 512, buffer_size_local) != 0))
			{
				log_errors(__FILE__, __LINE__, errno, cp_tmp->to);
			}
			rw.read_buf_num = 0;
			pthread_create(&t1, NULL, r_func, (void *)&rw);
			pthread_join(t1, NULL);
			for(;;)
			{
				rw.read_buf_num = 1;
				rw.write_buf_num = 0;
				pthread_create(&t1, NULL, r_func, (void *)&rw);
				pthread_create(&t2, NULL, w_func, (void *)&rw);
				pthread_join(t1, NULL);
				pthread_join(t2, NULL);

				if((rw.from_size <= total_write_local) || (rw.write_size <= 0))
					break;

				rw.read_buf_num = 0;
				rw.write_buf_num = 1;
				pthread_create(&t1, NULL, r_func, (void *)&rw);
				pthread_create(&t2, NULL, w_func, (void *)&rw);
				pthread_join(t1, NULL);
				pthread_join(t2, NULL);

				if((rw.from_size <= total_write_local) || (rw.write_size <= 0))
					break;
			}
			free(buf[0]);
			free(buf[1]);
		}
	}

	/*
	余計に書き込んだ部分を切り詰め。
	ここを弄ってバージョン0.1.2で余計なバグを出したので、うかつに弄らない。
	*/
	if(ftruncate(rw.ito, rw.from_size) == -1)
		log_errors(__FILE__, __LINE__, errno, cp_tmp->to);

	total_read_local = 0;
	total_write_local = 0;

	if(close(rw.ifrom) == -1)
		log_errors(__FILE__, __LINE__, errno, cp_tmp->from);
	if(close(rw.ito) == -1)
		log_errors(__FILE__, __LINE__, errno, cp_tmp->to);

	ch_time_mod(&stat_buf, cp_tmp->to, REGULAR);

	write_now = NULL;

	if(compare_mode == 1)
	{
		if(C == COMPARE)
		{
			compare(cp_tmp->from, cp_tmp->to);
		}
		else if(C == ONE)
		{
			hash_function(cp_tmp->from, cp_tmp->to, cp_tmp->copy_mode, SHA1SUM);
		}
		else if(C == FIVE)
		{
			hash_function(cp_tmp->from, cp_tmp->to, cp_tmp->copy_mode, MD5SUM);
		}
	}
}

/*******************************************************************************
読み取り関数。pthreadで使うので仮引数はvoid *。
*******************************************************************************/
static void * r_func(void *read_t)
{
	struct fd_buf_num *tmp = (struct fd_buf_num *)read_t;
	int buf_num = tmp->read_buf_num;
	errno = 0;

	if(tmp->from_size <= total_read_local)
	{
		next_write_size[buf_num] = 0;
		return NULL;
	}

	long long read_size = read(tmp->ifrom, buf[buf_num], buffer_size_local);
	if(errno > 0)
	{
		log_errors(__FILE__, __LINE__, errno, write_now);
		errno = 0;
	}

	total_read += read_size;
	total_read_local += read_size;

	// read_sizeを使い回す
	if(read_size != buffer_size_local)
	{
		long long ll = read_size % 512;
		long long mm = read_size - ll + 512;
		if(mm > buffer_size_local)
		{
			read_size = buffer_size_local;
		}
		else
		{
			read_size = mm;
		}
	}
	next_write_size[buf_num] = read_size;

	return NULL;
}

/*******************************************************************************
書き込み関数。pthreadで使うので仮引数はvoid *。
*******************************************************************************/
static void * w_func(void *write_t)
{
	struct fd_buf_num *tmp = (struct fd_buf_num *)write_t;
	int i = tmp->write_buf_num;
	long long write_off = 0;
	errno = 0;

	for(;;)
	{
		long long bytes = pwrite(tmp->ito, buf[i], next_write_size[i], total_write_local);
		write_off += bytes;
		if((bytes == next_write_size[i]) || (bytes <= 0))
		{
			if(errno > 0)
			{
				log_errors(__FILE__, __LINE__, errno, write_now);
				errno = 0;
			}

			break;
		}
	}

	if(write_off > 0)
	{
		total_write += write_off;
		total_write_local += write_off;
	}

	tmp->write_size = write_off;

	lseek(tmp->ito, total_write_local, SEEK_SET);

	return NULL;
}
