#define _BSD_SOURCE

#include "global.h"
#include "struct.h"

#include "add_data.h"
#include "log.h"
#include "snowcp.h"

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <dirent.h>
#include <sys/stat.h>
#include <glib.h>

// 関数プロトタイプ
UNList * dir_traverse(UNList *cp_list, char *from_tmp, char *to_tmp, const char c);
static UNList * running(UNList *tmp_list, const char *from_dir, const char *to_dir);

/*******************************************************************************

*******************************************************************************/
UNList * dir_traverse(UNList *cp_list, char *from_tmp, char *to_tmp, const char c)
{
	char to_path[PATH_LEN];
	if(c == EXISTS)
	{
		char *from_basename = g_path_get_basename(from_tmp);
		sprintf(to_path, "%s%s%s", to_tmp, G_DIR_SEPARATOR_S, from_basename);
		free(from_basename);
		cp_list = add_data(cp_list, from_tmp, to_path, DIRECTORY);
	}
	else
	{
		strcpy(to_path, to_tmp);
		int i = strlen(to_path);
		if(to_path[i - 1] == G_DIR_SEPARATOR)
		{
			to_path[i - 1] = '\0';
		}
		cp_list = add_data(cp_list, from_tmp, to_path, DIRECTORY);
	}

	cp_list = running(cp_list, from_tmp, to_path);

	return cp_list;
}

/*******************************************************************************
フォルダの走査
*******************************************************************************/
static UNList * running(UNList *tmp_list, const char *from_dir, const char *to_dir)
{
	DIR *dp = NULL;
	struct dirent *entry = NULL;
	char from[PATH_LEN];
	char to[PATH_LEN];

	if((dp = opendir(from_dir)) != NULL)
	{
		while((entry = readdir(dp)) != NULL)
		{
			// strcmpは等しければ0を返す（0は偽）
			if(strcmp(entry->d_name, ".") && strcmp(entry->d_name, ".."))
			{
				/*
				sprintfは便利だってLeptonさんが言ってた。
				printf系の関数は遅い？知るか。
				*/
				sprintf(from, "%s%s%s", from_dir, G_DIR_SEPARATOR_S, entry->d_name);
				sprintf(to, "%s%s%s", to_dir, G_DIR_SEPARATOR_S, entry->d_name);
				/*
				strcpy + strcat で書くと以下のようになる。
				約4万個のファイルとフォルダがあるフォルダを走査してみたが、
				sprintfと速度はほぼ同じ。
				*/
				/*
				strcpy(from, from_dir);
				strcat(from, G_DIR_SEPARATOR_S);
				strcat(from, entry->d_name);
				strcpy(to, to_dir);
				strcat(to, G_DIR_SEPARATOR_S);
				strcat(to, entry->d_name);
				*/
				if(entry->d_type == DT_LNK)
				{
					tmp_list = add_data(tmp_list, from, to, SYMBOLIC);
				}
				else if(entry->d_type == DT_REG)
				{
					tmp_list = add_data(tmp_list, from, to, REGULAR);
				}
				else if(entry->d_type == DT_DIR)
				{
					tmp_list = add_data(tmp_list, from, to, DIRECTORY);
					// 再帰
					tmp_list = running(tmp_list, from, to);
				}
			}
		}
		if(closedir(dp) == -1)
		{
			log_errors(__FILE__, __LINE__, errno, from_dir);
		}
	}
	else
	{
		log_errors(__FILE__, __LINE__, errno, from_dir);
		fprintf(stderr, "%s を読み取れませんでした\n", from_dir);
	}

	return tmp_list;
}
