#ifndef INCLUDED_APPEND_LIST_H
#define INCLUDED_APPEND_LIST_H

#include "struct_VList.h"

#include "xmalloc.h"

// 関数プロトタイプ
static inline VList * append_list(VList *first, const void *tmp) __attribute__((always_inline));

/*******************************************************************************
 * 連結リストに構造体を追加し、リストを繋ぐ
*******************************************************************************/
static inline VList * append_list(VList *first, const void *tmp)
{
	if(first != NULL)
	{
		VList *now = xmalloc(sizeof(VList));
		VList *before_last = first->tail;
		/*
		* キャストしないと警告が出る
		* warning: initialization discards qualifiers from pointer target type
		*/
		now->data = (void *)tmp;
		now->next = NULL;
		now->tail = NULL;

		now->prev = before_last;
		before_last->next = now;

		first->tail = now;
	}
	// リストに最初の要素を追加する
	else
	{
		first = xmalloc(sizeof(VList));
		/*
		* キャストしないと警告が出る…
		* warning: initialization discards qualifiers from pointer target type
		*/
		first->data = (void *)tmp;
		first->next = NULL;
		first->prev = NULL;
		first->tail = first;
	}

	return first;
}

#endif
