#define _GNU_SOURCE

#include "struct_OPArg.h"

#include "print_error.h"
#include "write_log_compare.h"

#include <fcntl.h>
#include <sys/mman.h>
#include <sys/stat.h>
#include <unistd.h>

typedef struct compare_check_data
{
	off_t from_size;
	off_t to_size;
	off_t read;
	off_t read_all;
	int ifrom;
	int ito;
	char *buffrom;
	char *bufto;
	long psize;
	_Bool check;
} CCD;

#define MUNMAP_S \
{\
	if(munmap(ccd.buffrom, ccd.read) == -1)\
	{\
		print_error("munmap", __FILE__, __LINE__, cpdd);\
	}\
	if(munmap(ccd.bufto, ccd.read) == -1)\
	{\
		print_error("munmap", __FILE__, __LINE__, cpdd);\
	}\
}

#define MMAP_IS_FAILED \
{\
	ccd.check = false;\
	print_error("mmap", __FILE__, __LINE__, cpdd);\
	fprintf(stderr, "コンペアに失敗しました\n");\
	fprintf(stderr, "%s\n", cpinfo->from);\
	fprintf(stderr, "%s\n", cpinfo->to);\
}

// 関数プロトタイプ
void compare_memcmp(const OPArg *oparg, CPInfo *cpinfo, const SDir *sdir, CPDD *cpdd);

void compare_memcmp(const OPArg *oparg, CPInfo *cpinfo, const SDir *sdir, CPDD *cpdd)
{
	struct stat froms;
	struct stat tos;
	CCD ccd;
	ccd.check = false;
	_Bool from_open = true;
	_Bool to_open = true;

	if((ccd.ifrom = open(cpinfo->from, O_RDONLY | O_NOATIME)) == -1)
	{
		from_open = to_open = false;

		print_error("open", __FILE__, __LINE__, cpdd);
		fprintf(stderr, "コンペアを開始できません\n");
		fprintf(stderr, "from : %s\n", cpinfo->from);
		fprintf(stderr, "to : %s\n", cpinfo->to);
	}
	else if((ccd.ito = open(cpinfo->to, O_RDONLY | O_NOATIME)) == -1)
	{
		to_open = false;

		print_error("open", __FILE__, __LINE__, cpdd);
		fprintf(stderr, "コンペアを開始できません\n");
		fprintf(stderr, "from : %s\n", cpinfo->from);
		fprintf(stderr, "to : %s\n", cpinfo->to);
	}
	else if((fstat(ccd.ifrom, &froms)) == -1)
	{
		print_error("fstat", __FILE__, __LINE__, cpdd);
		fprintf(stderr, "コンペアを開始できません\n");
		fprintf(stderr, "from : %s\n", cpinfo->from);
		fprintf(stderr, "to : %s\n", cpinfo->to);
	}
	else if((fstat(ccd.ito, &tos)) == -1)
	{
		print_error("fstat", __FILE__, __LINE__, cpdd);
		fprintf(stderr, "コンペアを開始できません\n");
		fprintf(stderr, "from : %s\n", cpinfo->from);
		fprintf(stderr, "to : %s\n", cpinfo->to);
	}
	else if(froms.st_size != tos.st_size)
	{
		print_error("compare_memcmp", __FILE__, __LINE__, cpdd);
		fprintf(stderr, "ファイルサイズが一致しませんでした、%sを削除します\n", cpinfo->to);
		write_log_compare(cpinfo, "NULL", "NULL", sdir, cpdd, false);
		unlink(cpinfo->to);
		cpinfo->write = false;
		// falseで初期化しているので要らないはず
		//cpinfo->compare = false;
	}
	else
	{
		ccd.from_size = froms.st_size;
		ccd.to_size = tos.st_size;
		ccd.psize = sysconf(_SC_PAGESIZE);
		ccd.read = 0;
		ccd.read_all = 0;
		off_t buffer_size_local = oparg->buffer_size / 2;

		for(;;)
		{
			ccd.read = ccd.from_size - ccd.read_all;

			/*
			 * mmapはoffsetがページサイズの倍数でないと動作しないので、
			 * 値を調節しておく。
			*/
			if(ccd.read >= buffer_size_local)
			{
				ccd.read = buffer_size_local;
			}
			else
			{
				off_t i = ccd.read % ccd.psize;
				if(i != ccd.read)
				{
					ccd.read = ccd.read - i;
				}
			}

			errno = 0;

			if((ccd.buffrom = mmap(NULL, ccd.read, PROT_READ, MAP_PRIVATE, ccd.ifrom, ccd.read_all)) != MAP_FAILED)
			{
				if((ccd.bufto = mmap(NULL, ccd.read, PROT_READ, MAP_PRIVATE, ccd.ito, ccd.read_all)) != MAP_FAILED)
				{
					errno = 0;
					if(madvise(ccd.buffrom, ccd.read, MADV_WILLNEED) == -1)
					{
						print_error("madvise", __FILE__, __LINE__, cpdd);
					}

					errno = 0;
					if(madvise(ccd.bufto, ccd.read, MADV_WILLNEED) == -1)
					{
						print_error("madvise", __FILE__, __LINE__, cpdd);
					}

					errno = 0;
					if(memcmp(ccd.buffrom, ccd.bufto, ccd.read) == 0)
					{
						ccd.check = true;
						ccd.read_all += ccd.read;

						MUNMAP_S

						if(ccd.read_all >= ccd.from_size)
						{
							break;
						}
					}
					else
					{
						ccd.check = false;

						MUNMAP_S

						print_error("compare_memcmp", __FILE__, __LINE__, cpdd);
						fprintf(stderr, "ファイルが一致しませんでした、%sを削除します\n", cpinfo->to);
						write_log_compare(cpinfo, "NULL", "NULL", sdir, cpdd, false);
						unlink(cpinfo->to);
						cpinfo->write = false;
					}
				}
				else
				{
					MMAP_IS_FAILED

					errno = 0;
					if(munmap(ccd.buffrom, ccd.from_size) == -1)
					{
						print_error("munmap", __FILE__, __LINE__, cpdd);
					}

					goto END;
				}
			}
			else
			{
				MMAP_IS_FAILED

				goto END;
			}
		}
	}

END:

	if(from_open == true)
	{
		if(close(ccd.ifrom) == -1)
		{
			print_error("close", __FILE__, __LINE__, cpdd);
		}
	}

	if(to_open == true)
	{
		if(close(ccd.ito) == -1)
		{
			print_error("close", __FILE__, __LINE__, cpdd);
		}
	}

	if(ccd.check == true)
	{
		cpinfo->compare = true;

		if(oparg->V == VERBOS)
		{
			puts("compare success");
			printf("from : %s\n", cpinfo->from);
			printf("to   : %s\n", cpinfo->to);
		}
	}
}
