#include "struct_OPArg.h"

#include <stdio.h>
#include <stdlib.h>

#include <errno.h>
#include <getopt.h>

// 関数プロトタイプ
void analyze_argument(const int argc, char **argv, OPArg *oparg);

/*******************************************************************************
 * getopt()で引数をチェック。
 * optarg（小文字）という変数名は、getoptの変数と被るので、opargにした。
*******************************************************************************/
void analyze_argument(const int argc, char **argv, OPArg *oparg)
{
	int result;

	// 引数解析
	while((result = getopt(argc, argv, "1:5:0b:c:ilmovw:")) != -1)
	{
		switch(result)
		{
		// SHA1SUMでチェックする
		case '1':
			if(oparg->EFFECT == NOT)
			{
				oparg->EFFECT = EXIST;
			}
			oparg->C = ONE;
			{
				char *endptr = NULL;
				// atoiは使うべきではない、らしい
				oparg->compare_mode = (int)strtol(optarg, &endptr, 10);
			}
			if((oparg->compare_mode == 1) || (oparg->compare_mode == 2))
			{
				break;
			}
			else
			{
				fprintf(stderr, "SHA1SUMモードの指定値が正しくありません\n");
				exit(EXIT_FAILURE);
			}
			break;
		// MD5SUMでチェックする
		case '5':
			if(oparg->EFFECT == NOT)
			{
				oparg->EFFECT = EXIST;
			}
			oparg->C = FIVE;
			{
				char *endptr = NULL;
				// atoiは使うべきではない、らしい
				oparg->compare_mode = (int)strtol(optarg, &endptr, 10);
			}
			if((oparg->compare_mode == 1) || (oparg->compare_mode == 2))
			{
				break;
			}
			else
			{
				fprintf(stderr, "MD5SUMモードの指定値が正しくありません\n");
				exit(EXIT_FAILURE);
			}
			break;
		// コンペアを行わない
		case '0':
			if(oparg->EFFECT == NOT)
			{
				oparg->EFFECT = EXIST;
			}
			oparg->C = NOT;
			oparg->compare_mode = 0;
			break;
		// バッファサイズを指定
		case 'b':
			if(oparg->EFFECT == NOT)
			{
				oparg->EFFECT = EXIST;
			}
			oparg->B = BUFFER;
			{
				char *endptr = NULL;
				errno = 0;
				// atoiは使うべきではない、らしい
				long long b_tmp = strtoll(optarg, &endptr, 10);
				if((endptr[0] != '\0') || (errno != 0) || (b_tmp < 2))
				{
					fprintf(stderr, "バッファの値が正しくありません。\n");
					fprintf(stderr, "値は2以上である必要があります。\n");
					exit(EXIT_FAILURE);
				}

				oparg->buffer_size = 1024 * 1024 * b_tmp;
			}
			break;
		// memcmpでチェックする
		case 'c':
			if(oparg->EFFECT == NOT)
			{
				oparg->EFFECT = EXIST;
			}
			oparg->C = COMPARE;
			{
				char *endptr = NULL;
				// atoiは使うべきではない、らしい
				oparg->compare_mode = (int)strtol(optarg, &endptr, 10);
			}
			if((oparg->compare_mode == 1) || (oparg->compare_mode == 2))
			{
				break;
			}
			else
			{
				fprintf(stderr, "コンペアモードの指定値が正しくありません\n");
				exit(EXIT_FAILURE);
			}
			break;
		// 上書き時に確認する
		case 'i':
			if(oparg->EFFECT == NOT)
			{
				oparg->EFFECT = EXIST;
			}
			oparg->I = INTERACTIVE;
			oparg->write_mode = 3;
			break;
		// コンペアのログを保存する
		case 'l':
			if(oparg->EFFECT == NOT)
			{
				oparg->EFFECT = EXIST;
			}
			oparg->L = LOG;
			break;
		// 移動モード
		case 'm':
			if(oparg->EFFECT == NOT)
			{
				oparg->EFFECT = EXIST;
			}
			oparg->M = MOVE;
			break;
		// オプションの設定
		case 'o':
			if(oparg->EFFECT == NOT)
			{
				oparg->EFFECT = EXIST;
			}
			fprintf(stderr, "-oオプションは無視されます\n");
			break;
		// 表示モード
		case 'v':
			if(oparg->EFFECT == NOT)
			{
				oparg->EFFECT = EXIST;
			}
			oparg->V = VERBOS;
			break;
		// 上書きモード
		case 'w':
			if(oparg->EFFECT == NOT)
			{
				oparg->EFFECT = EXIST;
			}
			oparg->I = NOT;
			{
				char *endptr = NULL;
				// atoiは使うべきではない、らしい
				oparg->write_mode = (int)strtol(optarg, &endptr, 10);
			}
			if((oparg->write_mode == 0) || (oparg->write_mode == 1) || (oparg->write_mode == 2) || (oparg->write_mode == 3))
			{
				break;
			}
			else
			{
				fprintf(stderr, "上書きモードの指定値が正しくありません\n");
				exit(EXIT_FAILURE);
			}
			break;
		// 未知のオプション
		case '?':
			fprintf(stderr, "オプションが正しくありません\n");
			exit(EXIT_FAILURE);
			break;
		}
	}

	if(optind == (argc - 1))
	{
		fprintf(stderr, "引数が足りません\n");
		exit(EXIT_FAILURE);
	}
	else if((oparg->EFFECT == EXIST) && (optind == argc))
	{
		fprintf(stderr, "引数が正しくありません\n");
		exit(EXIT_FAILURE);
	}
	else if((oparg->C == COMPARE) && (oparg->L == LOG))
	{
		fprintf(stderr, "-lオプションはSHA-1、もしくはMD5で比較する場合のみ有効です\n");
		exit(EXIT_FAILURE);
	}

	oparg->argc = argc;
	oparg->fromindex = optind;
	oparg->toindex = argc - 1;
	oparg->argv = argv;
	// コピー元の数をチェック
	oparg->arg_count = 0;

	for(int tmp = optind; tmp < oparg->toindex; tmp++)
	{
		oparg->arg_count++;
	}
}
