#ifndef STRUCT_OPTION_FLAG_H
#define STRUCT_OPTION_FLAG_H

#include <sys/types.h>

typedef enum option_flag
{
	ONE, /* コンペア（SHA-1） */
	FIVE, /* コンペア（MD5） */
	MEMCMP, /* コンペア（memcmp） */
	BEFORE,
	AFTER,
	LOG, /* コンペアログ保存 */

	SIZE_OR_TIME,
	NEW_TIME,
	OVERWRITE,
	NO_OVERWRITE, /* 0 */

	DRIVE_AUTO,
	DRIVE_SAME,
	DRIVE_DIFFERENT,

	INTERACTIVE, /* 上書き確認 */
	MOVE, /* 移動モード */
	VERBOS, /* コピー中ファイル名表示 */

	NOT, /* オプション無効 */
	EXIST, /* オプション有り */
} OPFlag;

typedef struct option_and_argument
{
	off_t buffer_size;
	off_t buffer_size_thread;
	enum option_flag C;
	enum option_flag COMPARE_MODE; /* 1 or 2 */
	enum option_flag WRITE_MODE; /* 1 or 2 or 3 or 0*/
	enum option_flag THREAD_MODE; /* 1 or 2 or 0 */
	enum option_flag I;
	enum option_flag L;
	enum option_flag M;
	enum option_flag V;
	enum option_flag EFFECT;
	int argc; /* 引数の数。main()の仮引数を入れる。 */
	int fromindex; /* getoptのoptindを入れる */
	int toindex; /* argv[argc - 1] */
	int arg_count; /* コピー元の数 */
	char **argv; /* main()の仮引数を入れる。 */
} OPArg;

#endif
