#ifndef WRITE_LOG_COMPARE_H
#define WRITE_LOG_COMPARE_H

#include "struct_CPInfo.h"
#include "struct_SDir.h"

#include <stdbool.h>
#include <stdio.h>
#include <string.h>

#include <glib.h>
#include <linux/limits.h>
#include <sys/stat.h>

// 関数プロトタイプ
static inline void write_log_compare(const CPInfo *cpinfo, const char *from_hash, const char *to_hash, const SDir *sdir, CPDD *cpdd, _Bool c_success) __attribute__((always_inline));
static inline void set_today(char *today) __attribute__((always_inline));
static inline void set_time_now(char *hms) __attribute__((always_inline));

static inline void write_log_compare(const CPInfo *cpinfo, const char *from_hash, const char *to_hash, const SDir *sdir, CPDD *cpdd, _Bool c_success)
{
	// ログを保存するフォルダが存在しない場合は作成する
	if(g_file_test(sdir->config_dir, G_FILE_TEST_EXISTS) == FALSE)
	{
		mkdir(sdir->config_dir, 0777);
		chmod(sdir->config_dir, 0777);
	}

	if(g_file_test(sdir->user_settings_dir, G_FILE_TEST_EXISTS) == FALSE)
	{
		mkdir(sdir->user_settings_dir, 0777);
		chmod(sdir->user_settings_dir, 0777);
	}

	if(g_file_test(sdir->log_dir, G_FILE_TEST_EXISTS) == FALSE)
	{
		mkdir(sdir->log_dir, 0777);
		chmod(sdir->log_dir, 0777);
	}

	char *target_dir;

	if(c_success == true)
	{
		if(g_file_test(sdir->compare_success_dir, G_FILE_TEST_EXISTS) == FALSE)
		{
			mkdir(sdir->compare_success_dir, 0777);
			chmod(sdir->compare_success_dir, 0777);
		}

		target_dir = sdir->compare_success_dir;
	}
	else
	{
		if(g_file_test(sdir->compare_error_dir, G_FILE_TEST_EXISTS) == FALSE)
		{
			mkdir(sdir->compare_error_dir, 0777);
			chmod(sdir->compare_error_dir, 0777);
		}

		target_dir = sdir->compare_error_dir;
	}

	char today[11];
	char hms[9];
	set_today(today);
	set_time_now(hms);

	char today_path[PATH_MAX] = "";
	strcat(today_path, target_dir);
	strcat(today_path, G_DIR_SEPARATOR_S);
	strcat(today_path, today);

	FILE *log;
	if((log = fopen(today_path, "a")) != NULL)
	{
		if(
			(fputs(hms, log) != EOF) &&
			(fputs("\n", log) != EOF) &&
			(fputs(from_hash, log) != EOF) &&
			(fputs(",", log) != EOF) &&
			(fputs(cpinfo->from, log) != EOF) &&
			(fputs("\n", log) != EOF) &&
			(fputs(to_hash, log) != EOF) &&
			(fputs(",", log) != EOF) &&
			(fputs(cpinfo->to, log) != EOF) &&
			(fputs("\n", log) != EOF)
		)
		{
			fclose(log);
			chmod(today, 0777);
		}
		else
		{
			print_error("fputs", __FILE__, __LINE__, cpdd);
			fprintf(stderr, "コンペアログの保存に失敗しました\n");
			fclose(log);
		}
	}
	else
	{
		print_error("fopen", __FILE__, __LINE__, cpdd);
		fprintf(stderr, "コンペアログの保存に失敗しました\n");
	}
}

/*******************************************************************************
 * 今日の日付を文字列に変換
*******************************************************************************/
static inline void set_today(char *today)
{
	time_t timer;
	struct tm *t_st;

	time(&timer);
	t_st = localtime(&timer);
	sprintf(today, "%d%s%d%s%d", t_st->tm_year + 1900, "-", t_st->tm_mon + 1, "-", t_st->tm_mday);
}

/*******************************************************************************
 * 現在時刻を取得
*******************************************************************************/
static inline void set_time_now(char *hms)
{
	time_t timer;
	struct tm *t_st;

	time(&timer);
	t_st = localtime(&timer);
	sprintf(hms, "%d%s%d%s%d", t_st->tm_hour, ":", t_st->tm_min, ":", t_st->tm_sec);
}

#endif
