#define _GNU_SOURCE

#include "print_error.h" // inline
#include "replace_string.h" // inline
#include "struct_CPInfo.h"
#include "struct_OPArg.h"
#include "write_log_hash_check.h" // inline

#include <unistd.h>

// 置換後の文字列の長さをPATH_MAXの三倍までと仮定
static const int REPLACE_LEN = PATH_MAX * 3;

static FILE *pipe_from;
static FILE *pipe_to;
static char *pipe_buf_from;
static char *pipe_buf_to;
static char *re_from;
static char *re_to;
static char *command_from;
static char *command_to;
static int read_size = 0;
static char *ffrom;
static char *tto;

// 関数プロトタイプ
void compare_hash(const OPArg *oparg, CPInfo *cpinfo, const SDir *sdir, CPDD *cpdd);

/*******************************************************************************
*******************************************************************************/
void compare_hash(const OPArg *oparg, CPInfo *cpinfo, const SDir *sdir, CPDD *cpdd)
{
	pipe_from = NULL;
	pipe_to = NULL;
	pipe_buf_from = alloca(PATH_MAX);
	pipe_buf_to = alloca(PATH_MAX);
	re_from = alloca(REPLACE_LEN);
	re_to = alloca(REPLACE_LEN);
	command_from = alloca(REPLACE_LEN);
	command_to = alloca(REPLACE_LEN);

	/*
	 * 以下のコードだとメモリ破壊（cpinfo->toの破壊）を起こしていた。
	 * memset(pipe_buf_from, 0, PATH_MAX);
	 * memset(pipe_buf_to, 0, PATH_MAX);
	*/

	pipe_buf_from[0] = '\0';
	pipe_buf_to[0] = '\0';

	strcpy(re_from, cpinfo->from);
	strcpy(re_to, cpinfo->to);

	// 特殊文字の置換
	// bashのみ対応、他は未確認。
	// かならず最初に\を置換する。
	replace_string(re_from, "\\", "\\\\", REPLACE_LEN);
	replace_string(re_from, "\"", "\\\"", REPLACE_LEN);
	replace_string(re_from, "`", "\\`", REPLACE_LEN);
	replace_string(re_from, "$", "\\$", REPLACE_LEN);

	replace_string(re_to, "\\", "\\\\", REPLACE_LEN);
	replace_string(re_to, "\"", "\\\"", REPLACE_LEN);
	replace_string(re_to, "`", "\\`", REPLACE_LEN);
	replace_string(re_to, "$", "\\$", REPLACE_LEN);

	// 特殊文字を置換済みの場合、'や"で括ると動作しなくなる
	// 'で括る場合、文字列中に'があると動作しない。
	// なので"でくくる。
	if(oparg->CHECK == ONE)
	{
		sprintf(command_from, "%s%s%s%s", "sha1sum -- ", "\"", re_from, "\"");
		sprintf(command_to, "%s%s%s%s", "sha1sum -- ", "\"", re_to, "\"");
	}
	else
	{
		sprintf(command_from, "%s%s%s%s", "md5sum -- ", "\"", re_from, "\"");
		sprintf(command_to, "%s%s%s%s", "md5sum -- ", "\"", re_to, "\"");
	}

	{
		errno = 0;
		// バッファ掃除用の領域
		static char ctmp[PATH_MAX];

		if(cpinfo->copy_mode == DIFFERENT)
		{
			pipe_from = popen(command_from, "r");
			pipe_to = popen(command_to, "r");

			if((pipe_from != NULL) && (pipe_to != NULL))
			{
				read_size = fread(pipe_buf_from, 1, PATH_MAX, pipe_from);
				// パイプのバッファを空にするためにグルグル回す
				while(fread(ctmp, 1, PATH_MAX, pipe_from) > 0) {}

				read_size = fread(pipe_buf_to, 1, PATH_MAX, pipe_to);
				while(fread(ctmp, 1, PATH_MAX, pipe_to) > 0) {}
			}
		}
		else
		{
			pipe_from = popen(command_from, "r");

			if(pipe_from != NULL)
			{
				read_size = fread(pipe_buf_from, 1, PATH_MAX, pipe_from);
				while(fread(ctmp, 1, PATH_MAX, pipe_from) > 0) {}
			}

			pipe_to = popen(command_to, "r");

			if(pipe_to != NULL)
			{
				read_size = fread(pipe_buf_to, 1, PATH_MAX, pipe_to);
				while(fread(ctmp, 1, PATH_MAX, pipe_to) > 0) {}
			}
		}
	}

	if((pipe_from != NULL) && (pipe_to != NULL))
	{
		// チェックしとかないと (半角スペース)が含まれていない場合、SIGSEGVで落ちる
		if(strstr(pipe_buf_from, " ") && strstr(pipe_buf_to, " "))
		{
			ffrom = strtok(pipe_buf_from, " ");
			tto = strtok(pipe_buf_to, " ");

			// Ubuntu 10.10で、ファイル名に\が含まれているファイルをsha1sumやmd5sumに渡すと、
			// 何故かハッシュ値の前に\が挿入されるっぽい。バグか？
			// その所為で文字列の長さが33や41になってハッシュ値が不一致と判定されるので、
			// 文字列の先頭が\だった場合、文字列を一つ前にずらす。
			if(ffrom[0] == '\\')
			{
				memmove(ffrom, ffrom + 1, strlen(ffrom));
			}

			if(tto[0] == '\\')
			{
				memmove(tto, tto + 1, strlen(tto));
			}

			// MD5 == 32桁　SHA-1 == 40桁
			if((strcmp(ffrom, tto) == 0) && ((strlen(ffrom) == 32) || (strlen(ffrom) == 40)))
			{
				cpinfo->hash_check = true;

				if(oparg->V == VERBOS)
				{
					puts("compare success");
					printf("%s : %s\n", ffrom, cpinfo->from);
					printf("%s : %s\n", tto, cpinfo->to);
				}

				if(oparg->L == LOG)
				{
					write_log_hash_check(cpinfo, ffrom, tto, sdir, cpdd, true);
				}
			}
			else
			{
				print_error(__func__, __FILE__, __LINE__, cpdd);
				fprintf(stderr, "ハッシュ値が一致しませんでした、%sを削除します\n", cpinfo->to);
				write_log_hash_check(cpinfo, ffrom, tto, sdir, cpdd, false);
				unlink(cpinfo->to);
				cpinfo->write = false;
				// falseで初期化しているので要らないはず
				//cpinfo->hash_check = false;
			}
		}
		else
		{
			print_error(__func__, __FILE__, __LINE__, cpdd);
			fprintf(stderr, "コンペアに失敗しました\n");
			fprintf(stderr, "%s\n", cpinfo->from);
			fprintf(stderr, "%s\n", cpinfo->to);
			write_log_hash_check(cpinfo, "NULL", "NULL", sdir, cpdd, false);
		}
	}
	else
	{
		print_error(__func__, __FILE__, __LINE__, cpdd);
		fprintf(stderr, "コンペアに失敗しました\n");
		fprintf(stderr, "%s\n", cpinfo->from);
		fprintf(stderr, "%s\n", cpinfo->to);
		write_log_hash_check(cpinfo, "NULL", "NULL", sdir, cpdd, false);
	}

	// 念のため、pipe詰まり対策
	for(;;)
	{
		read_size = 0;
		read_size += fread(pipe_buf_from, 1, PATH_MAX, pipe_from);
		read_size += fread(pipe_buf_to, 1, PATH_MAX, pipe_to);
		if(read_size <= 0)
		{
			break;
		}
	}

	pclose(pipe_from);
	pclose(pipe_to);
}
