#include "struct_OPArg.h"
#include "struct_SDir.h"

#include <stdio.h>
#include <stdlib.h>
#include <stdbool.h>

#include <glib.h>
#include <sys/stat.h>
#include <unistd.h>

#define INPUT_CHECK_CLEAN \
{\
	if(fgets(stdin_buf, INPUT_LEN, stdin) == NULL)\
	{\
		fgets_is_null();\
	}\
\
	clean(stdin_buf, INPUT_LEN);\
}

/* 関数プロトタイプ */
void write_conf(const SDir *sdir);
static void clean(const char stdin_buf[], const int INPUT_LEN);
static void fgets_is_null(void);
static void write_error(const char *mes);

/*******************************************************************************
 * 設定をファイルへ保存する
*******************************************************************************/
void write_conf(const SDir *sdir)
{
	const int INPUT_LEN = 256;
	char stdin_buf[INPUT_LEN];

	_Bool verify_flag = false;
	char hash_check_mode = '@';
	_Bool hash_check_log_flag = false;

	int buffer_size = 0;

	_Bool info_flag = false;
	_Bool overwrite_flag = false;
	char write_mode = '@';
	_Bool delete_flag = false;

	_Bool thread_flag = false;
	char thread_mode = '@';

	_Bool view_flag = false;

	puts("設定の変更を行います");

	{
		puts("");
		puts("ファイルコピー後にベリファイを行いますか?");
		printf("(y / n) :");
		fflush(stdout);

		INPUT_CHECK_CLEAN

		if(stdin_buf[0] == 'y')
		{
			verify_flag = true;

			puts("");
			puts("ベリファイモードを選んでください");
			puts("1 : コピー直後にベリファイ");
			puts("2 : 全コピー終了後に一括ベリファイ");
			printf("(1 / 2) :");
			fflush(stdout);

			INPUT_CHECK_CLEAN

			if((stdin_buf[0] == '1') || (stdin_buf[0] == '2'))
			{
				hash_check_mode = stdin_buf[0];

				puts("");
				puts("ベリファイのログを保存しますか?");
				printf("(y / n) :");
				fflush(stdout);

				INPUT_CHECK_CLEAN

				if(stdin_buf[0] == 'y')
				{
					hash_check_log_flag = true;
				}
			}
			else
			{
				verify_flag = false;
				puts("ベリファイオプションを無効にします");
				fflush(stdout);
			}
		}
	}

	{
		puts("");
		puts("バッファのサイズを変更しますか? (初期値は32MB)");
		printf("(y / n) :");
		fflush(stdout);

		INPUT_CHECK_CLEAN

		if(stdin_buf[0] == 'y')
		{
			puts("数値を入力してください");
			printf(" :");
			fflush(stdout);

			INPUT_CHECK_CLEAN

			char *endptr = NULL;
			buffer_size = (int)strtol(stdin_buf, &endptr, 10);
	
			if(buffer_size < 2)
			{
				buffer_size = 2;
			}
		}
	}

	{
		puts("");
		puts("ファイルを上書きする前に確認しますか?");
		printf("(y / n) :");
		fflush(stdout);

		INPUT_CHECK_CLEAN

		if(stdin_buf[0] == 'y')
		{
			info_flag = true;
		}
	}

	if(info_flag == false)
	{
		puts("");
		puts("上書きモードを変更しますか? (初期設定は、サイズ又は日付が異なる場合に上書き)");
		printf("(y / n) :");
		fflush(stdout);

		INPUT_CHECK_CLEAN

		if(stdin_buf[0] == 'y')
		{
			overwrite_flag = true;

			puts("");
			puts("上書きモードを選んでください");
			puts("1 : 初期設定");
			puts("2 : 日付が新しい場合に上書き");
			puts("3 : 常に上書き");
			puts("0 : 上書きしない");
			printf("(1 / 2 / 3 / 0) :");
			fflush(stdout);

			INPUT_CHECK_CLEAN

			if((stdin_buf[0] == '1') || (stdin_buf[0] == '2') || (stdin_buf[0] == '3') || (stdin_buf[0] == '0'))
			{
				write_mode = stdin_buf[0];
			}
			else
			{
				overwrite_flag = false;
				puts("上書きモードを初期設定にします");
				fflush(stdout);
			}
		}
	}

	{
		puts("");
		puts("移動モード (ファイルコピー後、元ファイルを削除) に設定しますか?");
		printf("(y / n) :");
		fflush(stdout);

		INPUT_CHECK_CLEAN

		if(stdin_buf[0] == 'y')
		{
			delete_flag = true;
		}
	}

	{
		puts("");
		puts("スレッドモードを指定しますか? (初期設定は自動判別)");
		printf("(y / n) :");
		fflush(stdout);

		INPUT_CHECK_CLEAN

		if(stdin_buf[0] == 'y')
		{
			thread_flag = true;

			puts("");
			puts("モードを選んでください (初期設定は自動判別)");
			puts("1 : 常に同一ドライブモード");
			puts("2 : 常に別ドライブモード");
			puts("0 : 初期設定");
			printf("(1 / 2 / 0) :");
			fflush(stdout);

			INPUT_CHECK_CLEAN

			if((stdin_buf[0] == '1') || (stdin_buf[0] == '2') || (stdin_buf[0] == '0'))
			{
				thread_mode = stdin_buf[0];
			}
			else
			{
				thread_flag = false;
				puts("スレッドモードを初期設定にします");
				fflush(stdout);
			}
		}
	}

	{
		puts("");
		puts("コピー中のファイル名を表示しますか?");
		printf("(y / n) :");
		fflush(stdout);

		INPUT_CHECK_CLEAN

		if(stdin_buf[0] == 'y')
		{
			view_flag = true;
		}
	}

	/* 設定をファイルに保存する */
	if(
		(true == verify_flag) ||
		(0 < buffer_size) ||
		(true == info_flag) ||
		(true == overwrite_flag) ||
		(true == delete_flag) ||
		(true == thread_flag) ||
		(true == view_flag)
	)
	{
		/* フォルダが存在しない場合は作成 */
		if(g_file_test(sdir->config_dir, G_FILE_TEST_EXISTS) == FALSE)
		{
			mkdir(sdir->config_dir, 0777);
			chmod(sdir->config_dir, 0777);
		}
		if(g_file_test(sdir->user_settings_dir, G_FILE_TEST_EXISTS) == FALSE)
		{
			mkdir(sdir->user_settings_dir, 0777);
			chmod(sdir->user_settings_dir, 0777);
		}

		if(chdir(sdir->user_settings_dir) != 0)
		{
			fprintf(stderr, "設定フォルダにアクセスできませんでした\n");
			fprintf(stderr, "強制終了します\n");
			exit(EXIT_FAILURE);
		}

		/* ファイルに設定を書き込めない場合、Segmentation faultで落ちるかも */

		FILE *config;
		if((config = fopen(SNOWCP_CONF, "w")) != NULL)
		{
			if(fputs("!,", config) == EOF)
			{
				write_error("fputs");
			}
			else if(fputs(SNOWCP_CONF_VER, config) == EOF)
			{
				write_error("fputs");
			}
			else if(fputs("\n", config) == EOF)
			{
				write_error("fputs");
			}

			puts(" ");

			if(verify_flag == true)
			{
				if(fputc('r', config) == EOF)
				{
					write_error("fputc");
				}
				else if(fputs(",", config) == EOF)
				{
					write_error("fputs");
				}
				else if(fputc(hash_check_mode, config) == EOF)
				{
					write_error("fputc");
				}
				else if(fputs("\n", config) == EOF)
				{
					write_error("fputs");
				}

				printf("ベリファイモード : %c\n", hash_check_mode);
			}

			if(hash_check_log_flag == true)
			{
				if(
					(fputs("l", config) == EOF) ||
					(fputs(",", config) == EOF) ||
					(fputs("NULL", config) == EOF) ||
					(fputs("\n", config) == EOF)
				)
				{
					write_error("fputs");
				}

				puts("ベリファイ/コンペアのログを保存する");
			}

			if(buffer_size > 0)
			{
				char tmp[INPUT_LEN];
				sprintf(tmp, "%d", buffer_size);

				if(
					(fputs("b", config) == EOF) ||
					(fputs(",", config) == EOF) ||
					(fputs(tmp, config) == EOF) ||
					(fputs("\n", config) == EOF)
				)
				{
					write_error("fputs");
				}

				printf("バッファサイズ : %d\n", buffer_size);
			}

			if(info_flag == true)
			{
				if(
					(fputs("i", config) == EOF) ||
					(fputs(",", config) == EOF) ||
					(fputs("NULL", config) == EOF) ||
					(fputs("\n", config) == EOF)
				)
				{
					write_error("fputs");
				}

				puts("上書き確認する");
			}

			if(overwrite_flag == true)
			{
				if(fputs("w", config) == EOF)
				{
					write_error("fputc");
				}
				else if(fputs(",", config) == EOF)
				{
					write_error("fputs");
				}
				else if(fputc(write_mode, config) == EOF)
				{
					write_error("fputc");
				}
				else if(fputs("\n", config) == EOF)
				{
					write_error("fputs");
				}

				printf("上書きモード   : %c\n", write_mode);
			}

			if(delete_flag == true)
			{
				if(
					(fputs("m", config) == EOF) ||
					(fputs(",", config) == EOF) ||
					(fputs("NULL", config) == EOF) ||
					(fputs("\n", config) == EOF)
				)
				{
					write_error("fputs");
				}

				puts("移動モード");
			}

			if(thread_flag == true)
			{
				if(fputs("t", config) == EOF)
				{
					write_error("fputc");
				}
				else if(fputs(",", config) == EOF)
				{
					write_error("fputs");
				}
				else if(fputc(thread_mode, config) == EOF)
				{
					write_error("fputc");
				}
				else if(fputs("\n", config) == EOF)
				{
					write_error("fputs");
				}

				printf("スレッドモード : %c\n", thread_mode);
			}

			if(view_flag == true)
			{
				if(
					(fputs("v", config) == EOF) ||
					(fputs(",", config) == EOF) ||
					(fputs("NULL", config) == EOF) ||
					(fputs("\n", config) == EOF)
				)
				{
					write_error("fputs");
				}

				puts("コピー中のファイル名を表示する");
			}

			fclose(config);
			chmod(SNOWCP_CONF, 0777);
		}
		else
		{
			perror("fopen");
			fprintf(stderr, "設定の保存に失敗しました\n");
			fprintf(stderr, "設定ファイルを削除します\n");
			unlink(SNOWCP_CONF);
		}
	}
	else
	{
		fprintf(stderr, "設定ファイルを削除します\n");
		unlink(SNOWCP_CONF);
	}
}

/*******************************************************************************
 * 入力バッファのクリア
*******************************************************************************/
static void clean(const char stdin_buf[], const int INPUT_LEN)
{
	/* バッファチェック */
	int a = 0;
	for(int i = 0; i < INPUT_LEN; i++)
	{
		if(stdin_buf[i] == '\n')
		{
			a++;
			break;
		}
	}
	/* 入力バッファの掃除 */
	if(a == 0)
	{
		while(getchar() != '\n');
	}
}

/*******************************************************************************
 * fgetsの戻り値がNULLだった場合
*******************************************************************************/
static void fgets_is_null(void)
{
	fprintf(stderr, "エラーが発生しました\n");
	fprintf(stderr, "fgetsの戻り値がNULLです\n");
	exit(EXIT_FAILURE);
}

/*******************************************************************************
 * 設定ファイルに書き込めなかった場合
*******************************************************************************/
static void write_error(const char *mes)
{
	perror(mes);
	fprintf(stderr, "設定ファイル書き込み時にエラーが発生しました\n");
	fprintf(stderr, "設定ファイルを削除します\n");
	unlink(SNOWCP_CONF);
	exit(EXIT_FAILURE);
}
