#define _GNU_SOURCE

#include "print_error.h" // inline
#include "replace_string.h" // inline
#include "struct_CPInfo.h"
#include "struct_OPArg.h"
#include "write_log_hash_check.h" // inline

#include <unistd.h>

/* 置換後の文字列の長さをPATH_MAXの三倍までと仮定 */
static const int REPLACE_LEN = PATH_MAX * 3;

static FILE *pipe_dst;

/* 関数プロトタイプ */
void verify_md5sum(const OPArg *oparg, const SDir *sdir, CPInfo *cpinfo, CPDD *cpdd);

/*******************************************************************************
*******************************************************************************/
void verify_md5sum(const OPArg *oparg, const SDir *sdir, CPInfo *cpinfo, CPDD *cpdd)
{
	char *pipe_buf_dst;
	char *re_dst;
	char *command_dst;
	char *ddst;
	int read_size;

	pipe_dst = NULL;
	pipe_buf_dst = alloca(PATH_MAX);
	re_dst = alloca(REPLACE_LEN);
	command_dst = alloca(REPLACE_LEN);

	pipe_buf_dst[0] = '\0';

	strcpy(re_dst, cpinfo->dst);

	/*
	 * 特殊文字の置換
	 * bashのみ対応、他は未確認。
	 * かならず最初に\を置換する。
	*/
	replace_string(re_dst, "\\", "\\\\", REPLACE_LEN);
	replace_string(re_dst, "\"", "\\\"", REPLACE_LEN);
	replace_string(re_dst, "`", "\\`", REPLACE_LEN);
	replace_string(re_dst, "$", "\\$", REPLACE_LEN);

	/*
	 * 特殊文字を置換済みの場合、'や"で括ると動作しなくなる
	 * 'で括る場合、文字列中に'があると動作しない。
	 * なので"でくくる。
	 */
	sprintf(command_dst, "%s%s%s%s", "md5sum -- ", "\"", re_dst, "\"");

	{
		errno = 0;
		/* バッファ掃除用の領域 */
		static char ctmp[PATH_MAX];

		pipe_dst = popen(command_dst, "r");

		if(pipe_dst != NULL)
		{
			read_size = fread(pipe_buf_dst, 1, PATH_MAX, pipe_dst);
			/* パイプのバッファを空にするためにグルグル回す */
			while(fread(ctmp, 1, PATH_MAX, pipe_dst) > 0) {}
		}
	}

	if(pipe_dst != NULL)
	{
		/* チェックしとかないと (半角スペース)が含まれていない場合、SIGSEGVで落ちる */
		if(strstr(pipe_buf_dst, " "))
		{
			ddst = strtok(pipe_buf_dst, " ");

			/*
			 * Ubuntu 10.10で、ファイル名に\が含まれているファイルをsha1sumやmd5sumに渡すと、
			 * 何故かハッシュ値の前に\が挿入されるっぽい。バグか？
			 * その所為で文字列の長さが33や41になってハッシュ値が不一致と判定されるので、
			 * 文字列の先頭が\だった場合、文字列を一つ前にずらす。
			 */
			if(ddst[0] == '\\')
			{
				memmove(ddst, ddst + 1, strlen(ddst));
			}

			/* MD5 == 32桁　SHA-1 == 40桁 */
			if((strcmp(cpinfo->src_md5, ddst) == 0) && ((strlen(cpinfo->src_md5) == 32) || (strlen(cpinfo->src_md5) == 40)))
			{
				cpinfo->hash_check = true;

				if(oparg->V == VERBOS)
				{
					printf("%s : %s\n", cpinfo->src_md5, cpinfo->src);
					printf("%s : %s\n", ddst, cpinfo->dst);
					fflush(stdout);
				}

				if(oparg->L == LOG)
				{
					write_log_hash_check(cpinfo, cpinfo->src_md5, ddst, sdir, cpdd, true);
				}
			}
			else
			{
				fprintf(stderr, "ハッシュ値が一致しませんでした、%sを削除します\n", cpinfo->dst);
				print_error("NODATA", __FILE__, __LINE__, cpdd);
				write_log_hash_check(cpinfo, cpinfo->src_md5, ddst, sdir, cpdd, false);
				cpinfo->d_para = DELETE;

				errno = 0;
				if(unlink(cpinfo->dst) == -1)
				{
					if(errno != ENOENT)
					{
						print_error("unlink", __FILE__, __LINE__, cpdd);
						fprintf(stderr, "%s の削除に失敗しました\n", cpinfo->dst);
					}
				}
			}
		}
		else
		{
			print_error("NODATA", __FILE__, __LINE__, cpdd);
			fprintf(stderr, "コンペアに失敗しました\n");
			fprintf(stderr, "%s\n", cpinfo->src);
			fprintf(stderr, "%s\n", cpinfo->dst);
			write_log_hash_check(cpinfo, "NULL", "NULL", sdir, cpdd, false);
		}
	}
	else
	{
		print_error("NODATA", __FILE__, __LINE__, cpdd);
		fprintf(stderr, "コンペアに失敗しました\n");
		fprintf(stderr, "%s\n", cpinfo->src);
		fprintf(stderr, "%s\n", cpinfo->dst);
		write_log_hash_check(cpinfo, "NULL", "NULL", sdir, cpdd, false);
	}

	/* 念のため、pipe詰まり対策 */
	for(;;)
	{
		read_size = 0;
		read_size += fread(pipe_buf_dst, 1, PATH_MAX, pipe_dst);

		if(read_size <= 0)
		{
			break;
		}
	}

	pclose(pipe_dst);
}
