#include "append_list.h"
#include "xmalloc.h"
#include "struct_OPArg.h"

#include <stdio.h>
#include <limits.h>

#include <errno.h>
#include <getopt.h>
#include <unistd.h>

#define SET_HASH_CHECK_MODE \
{\
	switch(optarg[0])\
	{\
	case '1':\
		oparg->CHECK_MODE = BEFORE;\
		break;\
\
	case '2':\
		oparg->CHECK_MODE = AFTER;\
		break;\
\
	default:\
		fprintf(stderr, "コンペアモードの指定値が正しくありません\n");\
		exit(EXIT_FAILURE);\
		break;\
	}\
}

/* 関数プロトタイプ */
void analyze_argument(const int argc, char **argv, OPArg *oparg);

/*******************************************************************************
 * getopt()で引数をチェック。
 * optarg（小文字）という変数名は、getoptの変数と被るので、opargにした。
*******************************************************************************/
void analyze_argument(const int argc, char **argv, OPArg *oparg)
{
	int result;

	/* 引数解析 */
	while((result = getopt(argc, argv, "0b:iIlLmMor:t:vw:")) != -1)
	{
		switch(result)
		{
		case '0':	/* コンペアを行わない */
			if(oparg->EFFECT == NOT)
			{
				oparg->EFFECT = EXIST;
			}
			oparg->CHECK = NOT;
			oparg->CHECK_MODE = NOT;
			break;

		case 'b':	/* バッファサイズを指定 */
			if(oparg->EFFECT == NOT)
			{
				oparg->EFFECT = EXIST;
			}
			{
				char *endptr = NULL;
				errno = 0;
				/* atoiは使うべきではない、らしい */
				off_t b_tmp = strtoll(optarg, &endptr, 10);

				if(b_tmp > INT_MAX)
				{
					fprintf(stderr, "バッファサイズの上限は2000MBです\n");
					exit(EXIT_FAILURE);
				}

				if((endptr[0] != '\0') || (errno != 0) || (b_tmp < 2))
				{
					fprintf(stderr, "バッファの値が正しくありません。\n");
					fprintf(stderr, "値は2以上である必要があります。\n");
					exit(EXIT_FAILURE);
				}

				oparg->buffer_size = 1024 * 1024 * b_tmp;
			}
			break;

		case 'i':	/* 上書き時に確認する */
			if(oparg->EFFECT == NOT)
			{
				oparg->EFFECT = EXIST;
			}
			oparg->I = INTERACTIVE;
			oparg->WRITE_MODE = OVERWRITE;
			break;

		case 'I':	/* -iを無効 */
			if(oparg->EFFECT == NOT)
			{
				oparg->EFFECT = EXIST;
			}
			oparg->I = NOT;
			break;

		case 'l':	/* コンペアのログを保存する */
			if(oparg->EFFECT == NOT)
			{
				oparg->EFFECT = EXIST;
			}
			oparg->L = LOG;
			break;

		case 'L':	/* -lを無効にする */
			if(oparg->EFFECT == NOT)
			{
				oparg->EFFECT = EXIST;
			}
			oparg->L = NOT;
			break;

		case 'm':	/* 移動モード */
			if(oparg->EFFECT == NOT)
			{
				oparg->EFFECT = EXIST;
			}
			oparg->M = MOVE;
			break;

		case 'M':	/* 移動モード無効 */
			if(oparg->EFFECT == NOT)
			{
				oparg->EFFECT = EXIST;
			}
			oparg->M = NOT;
			break;

		case 'o':	/* オプションの設定 */
			if(oparg->EFFECT == NOT)
			{
				oparg->EFFECT = EXIST;
			}
			fprintf(stderr, "-oオプションは無視されます\n");
			break;

		case 'r':	/* MD5SUMでチェックする */
			if(oparg->EFFECT == NOT)
			{
				oparg->EFFECT = EXIST;
			}
			oparg->CHECK = V_FIVE;

			SET_HASH_CHECK_MODE
			break;

		case 't':	/* スレッドモード */
			if(oparg->EFFECT == NOT)
			{
				oparg->EFFECT = EXIST;
			}

			switch(optarg[0])
			{
			case '0':
				oparg->THREAD_MODE = DRIVE_AUTO;
				break;

			case '1':
				oparg->THREAD_MODE = DRIVE_SAME;
				break;

			case '2':
				oparg->THREAD_MODE = DRIVE_DIFFERENT;
				break;

			default:
				fprintf(stderr, "スレッドモードの指定値が正しくありません\n");
				exit(EXIT_FAILURE);
			}
			break;

		case 'v':	/* 表示モード */
			if(oparg->EFFECT == NOT)
			{
				oparg->EFFECT = EXIST;
			}
			oparg->V = VERBOS;
			break;

		case 'w':	/* 上書きモード */
			if(oparg->EFFECT == NOT)
			{
				oparg->EFFECT = EXIST;
			}
			oparg->I = NOT;

			switch(optarg[0])
			{
			case '0':
				oparg->WRITE_MODE = NO_OVERWRITE;
				break;

			case '1':
				oparg->WRITE_MODE = SIZE_OR_TIME;
				break;

			case '2':
				oparg->WRITE_MODE = NEW_TIME;
				break;

			case '3':
				oparg->WRITE_MODE = OVERWRITE;
				break;

			default:
				fprintf(stderr, "上書きモードの指定値が正しくありません\n");
				exit(EXIT_FAILURE);
			}
			break;

		case '?':	/* 未知のオプション */
			fprintf(stderr, "オプションが正しくありません\n");
			exit(EXIT_FAILURE);
			break;
		}
	}

	if(optind == (argc - 1))
	{
		fprintf(stderr, "引数が足りません\n");
		exit(EXIT_FAILURE);
	}
	else if((oparg->EFFECT == EXIST) && (optind == argc))
	{
		fprintf(stderr, "引数が正しくありません\n");
		exit(EXIT_FAILURE);
	}

	oparg->argc = argc;
	oparg->src_index = optind;
	oparg->dst_index = argc - 1;
	oparg->argv = argv;

	/* コピー元の数をチェック */
	{
		off_t index_tmp = oparg->dst_index;
		off_t count_tmp = 0;

		for(int tmp = optind; tmp < index_tmp; tmp++)
		{
			count_tmp++;
		}

		oparg->arg_count = count_tmp;
	}

	{
		long psize = sysconf(_SC_PAGESIZE);
		int size = oparg->buffer_size;
		VList *b_size_list = NULL;

		for(;;)
		{
			if((size % psize) == 0)
			{
				int *i = xmalloc(sizeof(int));
				*i = size;
				b_size_list = append_list(i, b_size_list);
			}

			if(size <= 524288)
			{
				break;
			}

			size = size / 2;
		}

		oparg->b_size_list = b_size_list;
	}
}
