#include "analyze_argument.h"
#include "check_target.h"
#include "compare_verify_two.h"
#include "get_drive_list.h"
#include "get_settings_dir.h"
#include "help.h"
#include "print_error.h"
#include "read_conf.h"
#include "remove_source_rmdir.h"
#include "set_signal.h"
#include "struct_CPDD.h"
#include "struct_DPath.h"
#include "struct_OPArg.h"
#include "verify_hash.h"
#include "write_conf.h"

#include <stdbool.h>
#include <stdio.h>
#include <stdlib.h>

#include <unistd.h>

/* 関数プロトタイプ */
static inline void delete_src(const VList *file_list, CPDD *cpdd);

/*******************************************************************************
*******************************************************************************/
int main(int argc, char **argv)
{
	if(argc == 1)
	{
		help();
		return EXIT_SUCCESS;
	}

	SDir *sdir = get_settings_dir();

	if(argc == 2)
	{
		char *tmp = argv[1];

		/* -oの場合、オプションを設定、保存し、終了する。 */
		if((tmp[0] == '-') && (tmp[1] == 'o'))
		{
			write_conf(sdir);
			return EXIT_SUCCESS;
		}
		/* -hの場合はヘルプを表示する */
		else if((tmp[0] == '-') && (tmp[1] == 'h'))
		{
			help();
			return EXIT_SUCCESS;
		}
		/* --helpの場合もヘルプを表示する */
		else if((tmp[0] == '-') && (tmp[1] == '-') && (tmp[2] == 'h') && (tmp[3] == 'e') && (tmp[4] == 'l') && (tmp[5] == 'p'))
		{
			help();
			return EXIT_SUCCESS;
		}
		else
		{
			fprintf(stderr, "引数が足りません\n");
			return EXIT_FAILURE;
		}
	}

	OPArg *oparg = read_conf(sdir);
	analyze_argument(argc, argv, oparg);
	VList *drive_list = get_drive_list();
	set_signal();

	puts("コピーを開始します...");
	fflush(stdout);

	RData *rdata = check_target(oparg, drive_list, sdir);

	puts("コピーを完了しました...");

	VList *file_list = rdata->file_list;
	CPDD *cpdd = rdata->cpdd;

	if((file_list != NULL) && (oparg->CHECK_MODE == AFTER) && (cpdd->mk_file_count > 0))
	{
		puts("ハッシュ値のチェックを開始します...");
		fflush(stdout);

		compare_verify_two(oparg, file_list, sdir, cpdd);

		puts("ハッシュ値のチェックを完了しました...");
		fflush(stdout);
	}

	/* ファイルとリンクはコピー直後もしくはベリファイ直後に削除しているので、チェックするのはフォルダだけでよい。 */
	if((oparg->M == MOVE) && (oparg->CHECK_MODE == AFTER) && (cpdd->dir_count > 0))
	{
		delete_src(file_list, cpdd);
	}

	puts("");

	if(cpdd->file_count > 0)
	{
		printf("File   : %lld / %lld", cpdd->mk_file_count, cpdd->file_count);

		if(cpdd->thread_mode_count > 0)
		{
			printf(" (Thread : %lld / %lld)\n", cpdd->thread_mode_count, cpdd->mk_file_count);
		}
		else
		{
			puts("");
		}
	}

	if(cpdd->link_count > 0)   { printf("Link   : %llu / %llu\n", cpdd->mk_link_count, cpdd->link_count); }
	if(cpdd->dir_count > 0)    { printf("Dir    : %llu / %llu\n", cpdd->mk_dir_count, cpdd->dir_count); }
	if(cpdd->total_source > 0) { printf("Source : %llu MB (%llu Bytes)\n", cpdd->total_source / (1024 * 1024), cpdd->total_source); }
	if(cpdd->total_read > 0)   { printf("Read   : %llu MB (%llu Bytes)\n", cpdd->total_read / (1024 * 1024), cpdd->total_read); }
	if(cpdd->total_write > 0)  { printf("Write  : %llu MB (%llu Bytes)\n", cpdd->total_write / (1024 * 1024), cpdd->total_write); }
	if(cpdd->total_error > 0)  { printf("Error  : %llu\n", cpdd->total_error); }

	/*
	 * close()する必要があるもの
	 * sdir->current_fd
	 */

	/* 基本的に、mallocしたのはfreeしてない。 */

	puts("");

	return EXIT_SUCCESS;
}

/*******************************************************************************
*******************************************************************************/
#include <unistd.h>

/*******************************************************************************
*******************************************************************************/
static inline void delete_src(const VList *file_list, CPDD *cpdd)
{
	/*
	 * キャストしないと警告が出る
	 * warning: initialization discards qualifiers from pointer target type
	 */
	VList *tmp = (VList *)file_list;
	tmp = tmp->tail;

	for(;;)
	{
		CPInfo *cpinfo = (CPInfo *)tmp->data;

		switch(cpinfo->src_type)
		{
		case DIRECTORY:
			REMOVE_SOURCE_RMDIR
			break;

		case SYMBOLICLINK:
			break;

		case REGULAR:
			break;

		default:
			fprintf(stderr, "ファイルタイプが不正です\n");
			break;
		}

		if(tmp->prev == NULL)
		{
			break;
		}

		tmp = tmp->prev;
	}
}
