#ifndef DO_COMPARE_VERIFY_ONE_H
#define DO_COMPARE_VERIFY_ONE_H

#include "print_error.h"
#include "remove_source_rmdir.h"
#include "remove_source_unlink.h"
#include "struct_CPDD.h"
#include "struct_CPInfo.h"
#include "struct_OPArg.h"
#include "struct_SDir.h"
#include "verify_hash.h"

#include <stdlib.h>
#include <stdio.h>
#include <stdbool.h>

#include <errno.h>
#include <unistd.h> 

static inline void compare_verify_two(const OPArg *oparg, const VList *file_list, const SDir *sdir, CPDD *cpdd);

/*******************************************************************************
*******************************************************************************/
static inline void compare_verify_two(const OPArg *oparg, const VList *file_list, const SDir *sdir, CPDD *cpdd)
{
	/*
	 * キャストしないと警告が出る
	 * warning: initialization discards qualifiers from pointer target type
	 */
	VList *tmp = (VList *)file_list;

	_Bool is_move;

	if(oparg->M == MOVE)
	{
		is_move = true;
	}
	else
	{
		is_move = false;
	}

	for(;;)
	{
		CPInfo *cpinfo = (CPInfo *)tmp->data;

		if(cpinfo->src_type == REGULAR)
		{
			switch(oparg->CHECK)
			{
			case V_FIVE:
				if((cpinfo->src_md5 != NULL) && (cpinfo->dst_para == WRITE))
				{
					verify_hash(oparg, sdir, cpinfo, cpdd);

					if(is_move && (cpinfo->hash_check == true))
					{
						REMOVE_SOURCE_UNLINK
					}
				}
				break;

			default:
				fprintf(stderr, "ハッシュチェックオプションが不正です");
				break;
			}
		}
		else if(cpinfo->is_rmdir && is_move && ((cpinfo->dst_para == WRITE) || (cpinfo->dst_para == SKIP)))
		{
			REMOVE_SOURCE_RMDIR
		}
		else if((cpinfo->src_type == SYMBOLICLINK) && is_move && (cpinfo->dst_para == WRITE))
		{
			REMOVE_SOURCE_UNLINK
		}

		if(tmp->next == NULL)
		{
			break;
		}

		tmp = tmp->next;
	}
}

#endif
