/*
 * xgettext -k"_" --from-code UTF-8 -o snowcp.pot *.c *.h
 * msginit --locale=ja --input=snowcp.pot
 * sed -i 's/charset=ASCII/charset=UTF-8/g' ja.po
 * msgfmt -o snowcp.mo ja.po
 * sudo mkdir -p /usr/local/share/locale/ja/LC_MESSAGES
 * sudo cp snowcp.mo /usr/local/share/locale/ja/LC_MESSAGES
 */

#include "analyze_argument.h"
#include "check_target.h"
#include "ch_time_and_mod_global.h"
#include "compare_verify_two.h"
#include "gettext.h"
#include "get_drive_list.h"
#include "get_settings_dir.h"
#include "help.h"
#include "print_error.h"
#include "read_conf.h"
#include "remove_source_rmdir.h"
#include "set_signal.h"
#include "struct_CPDD.h"
#include "struct_DPath.h"
#include "struct_OPArg.h"
#include "verify_hash.h"
#include "write_conf.h"

#include <locale.h> /* setlocale() */
#include <stdbool.h>
#include <stdio.h>
#include <stdlib.h>

/*******************************************************************************
*******************************************************************************/
int main(int argc, char **argv)
{
	if(argc == 1)
	{
		help();
		return EXIT_SUCCESS;
	}

	setlocale(LC_ALL, "");
//	bindtextdomain("snowcp", ".");
	bindtextdomain("snowcp", "/usr/local/share/locale");
	textdomain("snowcp");

	SDir *sdir = get_settings_dir();

	if(argc == 2)
	{
		char *tmp = argv[1];

		/* -oの場合、オプションを設定、保存し、終了する。 */
		if((tmp[0] == '-') && (tmp[1] == 'o'))
		{
			write_conf(sdir);
			return EXIT_SUCCESS;
		}
		/* -hの場合はヘルプを表示する */
		else if((tmp[0] == '-') && (tmp[1] == 'h'))
		{
			help();
			return EXIT_SUCCESS;
		}
		/* --hの場合もヘルプを表示する */
		else if((tmp[0] == '-') && (tmp[1] == '-') && (tmp[2] == 'h') && (tmp[3] == '\0'))
		{
			help();
			return EXIT_SUCCESS;
		}
		/* --helpの場合でもヘルプを表示する */
		else if((tmp[0] == '-') && (tmp[1] == '-') && (tmp[2] == 'h') && (tmp[3] == 'e') && (tmp[4] == 'l') && (tmp[5] == 'p'))
		{
			help();
			return EXIT_SUCCESS;
		}
		else
		{
			fprintf(stderr, _("引数が足りません\n"));
			return EXIT_FAILURE;
		}
	}

	OPArg *oparg = read_conf(sdir);
	analyze_argument(argc, argv, oparg);
	VList *drive_list = get_drive_list();
	set_signal();
	ut = geteuid();

	puts(_("コピーを開始します..."));
	fflush(stdout);

	RData *rdata = check_target(oparg, drive_list, sdir);

	puts(_("コピーを完了しました..."));

	VList *file_list = rdata->file_list;
	CPDD *cpdd = rdata->cpdd;

	if((file_list != NULL) && (oparg->CHECK_MODE == AFTER) && (cpdd->mk_file_count > 0))
	{
		puts(_("ハッシュ値のチェックを開始します..."));
		fflush(stdout);

		compare_verify_two(oparg, file_list, sdir, cpdd);

		puts(_("ハッシュ値のチェックを完了しました..."));
		fflush(stdout);
	}

	puts("");

	if(cpdd->file_count > 0)
	{
		printf(_("File   : %lld / %lld"), cpdd->mk_file_count, cpdd->file_count);

		if(cpdd->thread_mode_count > 0)
		{
			printf(_(" (Thread : %lld / %lld)\n"), cpdd->thread_mode_count, cpdd->mk_file_count);
		}
		else
		{
			puts("");
		}
	}

	if(cpdd->link_count > 0)   { printf(_("Link   : %llu / %llu\n"), cpdd->mk_link_count, cpdd->link_count); }
	if(cpdd->dir_count > 0)    { printf(_("Dir    : %llu / %llu\n"), cpdd->mk_dir_count, cpdd->dir_count); }
	if(cpdd->total_source > 0) { printf(_("Source : %llu MB (%llu Bytes)\n"), cpdd->total_source / (1024 * 1024), cpdd->total_source); }
	if(cpdd->total_read > 0)   { printf(_("Read   : %llu MB (%llu Bytes)\n"), cpdd->total_read / (1024 * 1024), cpdd->total_read); }
	if(cpdd->total_write > 0)  { printf(_("Write  : %llu MB (%llu Bytes)\n"), cpdd->total_write / (1024 * 1024), cpdd->total_write); }
	if(cpdd->total_error > 0)  { printf(_("Error  : %llu\n"), cpdd->total_error); }

	/*
	 * close()する必要があるもの
	 * sdir->current_fd
	 */

	/* 基本的に、mallocしたのはfreeしてない。 */

	puts("");

	return EXIT_SUCCESS;
}
