class DefaultConfigController < ApplicationController

  def update
    @default_config = DefaultConfig.find(params[:id])

    respond_to do |format|
      if @default_config.update_attributes(params[:default_config])
        format.html { redirect_to admin_index_url(timezone: @default_config.timezone) }
        format.json { head :ok }
      else
        format.html { render action: "edit" }
        format.json { render json: @default_config.errors,
          status: :unprocessable_entity }
      end
    end
  end
end
