SoftScheduler::Application.routes.draw do
  scope '(:locale)' do
    controller :sessions do
      get 'login' => :new
      post 'login' => :create
      delete 'logout' => :destroy
    end

    resources :chart do
      collection do
        get 'burn_up_chart'
      end
    end

    resources :tickets, :except => ['destroy', 'edit']
    resources :ticket_logs
    resources :users, :except => ['destroy']
    resources :projects
    resources :admin, :only => ['index', 'edit', 'update']
    resources :default_config, :only => ['update']
    resources :chart, :only => ['show', 'update']
    resources :projects_users, :only => ['create', 'destroy']

    root :to => 'tickets#index'
  end

  # Any routes that aren't defined above here go to the 404
  #match "*path", :to => "application#routing_error"
end
