require 'test_helper'

class TicketsControllerTest < ActionController::TestCase
  setup do
    @input_attributes = {
      title: "Create Project",
      comment: "This is ticket description.",
      project_id: 1,
      state_id: 0,
      priority_id: 0,
      workload_id: 0,
      assigned_user_id: nil,
      updated_by_user_id: nil,
    }

    user = users(:one)
    session[:user_id] = user.id
  end

  test "should get index" do
    get :index
    assert_response :success
  end

  test "should get new" do
    get :new
    assert_redirected_to tickets_url
  end

  test "should create ticket" do
    assert_difference('Ticket.count') do
      post :create, ticket: @input_attributes
    end
    assert_redirected_to tickets_url
  end

  test "should fail creating ticket (no title)" do
    @input_attributes[:title] = ""
    assert_no_difference('Ticket.count') do
      post :create, ticket: @input_attributes
    end
    assert_redirected_to tickets_url
  end

=begin
  test "should update ticket" do
    ticket = tickets(:one)
    put :update, id: ticket.to_param, ticket: ticket.attributes
    assert_redirected_to ticket_path(assigns(:ticket))
  end
=end
end
