unit SOMIRIMP.SOM;

{$WARN UNSAFE_TYPE OFF}

{$IF CompilerVersion >= 17.0}
  {$DEFINE DELPHI_HAS_INLINE}
{$IFEND}

{$IF CompilerVersion >= 23.0}
  {$DEFINE DELPHI_HAS_INTPTR}
{$IFEND}

interface

uses
  SysUtils;

type
  { Hardwired definitions }
  CORBAString = PAnsiChar;
  CORBABoolean = ByteBool;
  TypeCode = class;
  any = packed record
    _type: TypeCode;
    _value: Pointer;
  end;
  TAnyResult = type Int64; { returned in edx:eax by vanilla IBM SOM, but passed via hidden pointer by Delphi when record }
  PEnvironment = ^Environment;
  {$IFNDEF DELPHI_HAS_INTPTR}
  IntPtr = type LongInt;
  UIntPtr = type LongWord;
  {$ENDIF}

  { Forward definitions }
  SOMObject = class;
  Contained = class;
  AttributeDef = class;
  BOA = class;
  SOMEEvent = class;
  SOMEClientEvent = class;
  Context = class;
  ConstantDef = class;
  Container = class;
  SOMEEMan = class;
  SOMEEMRegisterData = class;
  ExceptionDef = class;
  ImplementationDef = class;
  ImplRepository = class;
  InterfaceDef = class;
  ModuleDef = class;
  NVList = class;
  ObjectMgr = class;
  OperationDef = class;
  ORB = class;
  ParameterDef = class;
  Principal = class;
  Repository = class;
  Request = class;
  SOMTEntryC = class;
  SOMTAttributeEntryC = class;
  SOMTBaseClassEntryC = class;
  SOMTClassEntryC = class;
  SOMTCommonEntryC = class;
  SOMTConstEntryC = class;
  SOMTDataEntryC = class;
  SOMTEmitC = class;
  SOMTEnumEntryC = class;
  SOMTEnumNameEntryC = class;
  SOMTMetaClassEntryC = class;
  SOMTMethodEntryC = class;
  SOMTModuleEntryC = class;
  SOMTParameterEntryC = class;
  SOMTPassthruEntryC = class;
  SOMTSequenceEntryC = class;
  SOMTStringEntryC = class;
  SOMTStructEntryC = class;
  SOMTTypedefEntryC = class;
  SOMTTemplateOutputC = class;
  SOMTUnionEntryC = class;
  SOMTUserDefinedTypeEntryC = class;
  SOMDServerMgr = class;
  SOMESinkEvent = class;
  SOMClass = class;
  SOMMSingleInstance = class;
  SOMMBeforeAfter = class;
  SOMClassMgr = class;
  SOMDObject = class;
  SOMDClientProxy = class;
  SOMDMetaproxy = class;
  SOMDObjectMgr = class;
  SOMDServer = class;
  SOMUTId = class;
  SOMOA = class;
  Sockets = class;
  SOMStringTableC = class;
  SOMMTraced = class;
  SOMETimerEvent = class;
  TSIdentification = class;
  TypeDef = class;
  SOMEWorkProcEvent = class;

  { Foreign types }
  somId = Pointer { WARNING: foreign type, size may be different than SizeOf(Pointer) };
  va_list = Pointer { WARNING: foreign type, size may be different than SizeOf(Pointer) };
  Sockets_in_addr = Pointer { WARNING: foreign type, size may be different than SizeOf(Pointer) };

  { Data types }
  int = LongInt;
  uchar_t = Byte;
  size_t = LongWord;
  SOMFOREIGN = Pointer;
  somToken = Pointer;
  TCKind = type LongWord;
  integer1 = ShortInt;
  integer2 = SmallInt;
  uinteger2 = Word;
  integer4 = LongInt;
  uinteger4 = LongWord;
  float4 = Single;
  float8 = Double;
  zString = CORBAString;
  fString = CORBAString;
  somMethodProc = Pointer;
  somMethodPtr = Pointer;
  somMToken = Pointer;
  somMLocator = Pointer;
  somDToken = Pointer;
  somDLocator = Pointer;
  somClassInfo = Pointer;
  SOMTokBuf = Pointer;
  somInitCtrl = Pointer;
  somInitInfo = Pointer;
  somDestructCtrl = Pointer;
  somDestructInfo = Pointer;
  somAssignCtrl = Pointer;
  somAssignInfo = Pointer;
  somRdAppType = LongWord;
  PsomClassList = ^somClassList;
  somClasses = ^somClassList;
  somObjects = Pointer;
  PsomMethodTab = ^somMethodTab;
  PsomMethodTabList = ^somMethodTabList;
  somMethodTabs = ^somMethodTabList;
  somParentMtabStructPtr = ^somMethodTabList;
  _IDL_Array1Of_Pointer = array[0 .. 0] of Pointer;
  somCClassDataStructurePtr = ^somCClassDataStructure;
  somBooleanVector = ^Byte;
  exception_type = type LongWord;
  Identifier = CORBAString;
  RepositoryId = CORBAString;
  P_IDL_ArrayOf_SOMObject = ^_IDL_ArrayOf_SOMObject;
  _IDL_Sequence_SOMObject = packed record
    _maximum: LongWord;
    _length: LongWord;
    _buffer: P_IDL_ArrayOf_SOMObject;
  end;
  SOMObject_SOMObjectSequence = _IDL_Sequence_SOMObject;
  P_IDL_ArrayOf_Byte = ^_IDL_ArrayOf_Byte;
  _IDL_Sequence_Byte = packed record
    _maximum: LongWord;
    _length: LongWord;
    _buffer: P_IDL_ArrayOf_Byte;
  end;
  SOMObject_BooleanSequence = _IDL_Sequence_Byte;
  P_IDL_ArrayOf_SOMObject_somObjectOffset = ^_IDL_ArrayOf_SOMObject_somObjectOffset;
  _IDL_Sequence_SOMObject_somObjectOffset = packed record
    _maximum: LongWord;
    _length: LongWord;
    _buffer: P_IDL_ArrayOf_SOMObject_somObjectOffset;
  end;
  SOMObject_somObjectOffsets = _IDL_Sequence_SOMObject_somObjectOffset;
  Contained_SOMObjectSequence = { inherited } SOMObject_SOMObjectSequence;
  Contained_BooleanSequence = { inherited } SOMObject_BooleanSequence;
  Contained_somObjectOffsets = { inherited } SOMObject_somObjectOffsets;
  AttributeDef_AttributeMode = type LongWord;
  AttributeDef_SOMObjectSequence = { inherited } SOMObject_SOMObjectSequence;
  AttributeDef_BooleanSequence = { inherited } SOMObject_BooleanSequence;
  AttributeDef_somObjectOffsets = { inherited } SOMObject_somObjectOffsets;
  completion_status = type LongWord;
  ORBStatus = LongWord;
  ReferenceData = _IDL_Sequence_Byte;
  Flags = LongWord;
  ImplId = CORBAString;
  BOA_SOMObjectSequence = { inherited } SOMObject_SOMObjectSequence;
  BOA_BooleanSequence = { inherited } SOMObject_BooleanSequence;
  BOA_somObjectOffsets = { inherited } SOMObject_somObjectOffsets;
  SOMEEvent_SOMObjectSequence = { inherited } SOMObject_SOMObjectSequence;
  SOMEEvent_BooleanSequence = { inherited } SOMObject_BooleanSequence;
  SOMEEvent_somObjectOffsets = { inherited } SOMObject_somObjectOffsets;
  SOMEClientEvent_SOMObjectSequence = { inherited } SOMObject_SOMObjectSequence;
  SOMEClientEvent_BooleanSequence = { inherited } SOMObject_BooleanSequence;
  SOMEClientEvent_somObjectOffsets = { inherited } SOMObject_somObjectOffsets;
  Context_SOMObjectSequence = { inherited } SOMObject_SOMObjectSequence;
  Context_BooleanSequence = { inherited } SOMObject_BooleanSequence;
  Context_somObjectOffsets = { inherited } SOMObject_somObjectOffsets;
  ConstantDef_SOMObjectSequence = { inherited } SOMObject_SOMObjectSequence;
  ConstantDef_BooleanSequence = { inherited } SOMObject_BooleanSequence;
  ConstantDef_somObjectOffsets = { inherited } SOMObject_somObjectOffsets;
  Container_InterfaceName = CORBAString;
  Container_SOMObjectSequence = { inherited } SOMObject_SOMObjectSequence;
  Container_BooleanSequence = { inherited } SOMObject_BooleanSequence;
  Container_somObjectOffsets = { inherited } SOMObject_somObjectOffsets;
  EMRegProc = Pointer;
  EMMethodProc = Pointer;
  EMMethodProcEv = Pointer;
  SOMEEMan_SOMObjectSequence = { inherited } SOMObject_SOMObjectSequence;
  SOMEEMan_BooleanSequence = { inherited } SOMObject_BooleanSequence;
  SOMEEMan_somObjectOffsets = { inherited } SOMObject_somObjectOffsets;
  SOMEEMRegisterData_SOMObjectSequence = { inherited } SOMObject_SOMObjectSequence;
  SOMEEMRegisterData_BooleanSequence = { inherited } SOMObject_BooleanSequence;
  SOMEEMRegisterData_somObjectOffsets = { inherited } SOMObject_somObjectOffsets;
  ExceptionDef_SOMObjectSequence = { inherited } SOMObject_SOMObjectSequence;
  ExceptionDef_BooleanSequence = { inherited } SOMObject_BooleanSequence;
  ExceptionDef_somObjectOffsets = { inherited } SOMObject_somObjectOffsets;
  ImplementationDef_SOMObjectSequence = { inherited } SOMObject_SOMObjectSequence;
  ImplementationDef_BooleanSequence = { inherited } SOMObject_BooleanSequence;
  ImplementationDef_somObjectOffsets = { inherited } SOMObject_somObjectOffsets;
  ImplRepository_SOMObjectSequence = { inherited } SOMObject_SOMObjectSequence;
  ImplRepository_BooleanSequence = { inherited } SOMObject_BooleanSequence;
  ImplRepository_somObjectOffsets = { inherited } SOMObject_somObjectOffsets;
  ContextIdentifier = CORBAString;
  InterfaceDef_SOMObjectSequence = { inherited } SOMObject_SOMObjectSequence;
  InterfaceDef_BooleanSequence = { inherited } SOMObject_BooleanSequence;
  InterfaceDef_somObjectOffsets = { inherited } SOMObject_somObjectOffsets;
  InterfaceDef_InterfaceName = { inherited } Container_InterfaceName;
  ModuleDef_SOMObjectSequence = { inherited } SOMObject_SOMObjectSequence;
  ModuleDef_BooleanSequence = { inherited } SOMObject_BooleanSequence;
  ModuleDef_somObjectOffsets = { inherited } SOMObject_somObjectOffsets;
  ModuleDef_InterfaceName = { inherited } Container_InterfaceName;
  NVList_SOMObjectSequence = { inherited } SOMObject_SOMObjectSequence;
  NVList_BooleanSequence = { inherited } SOMObject_BooleanSequence;
  NVList_somObjectOffsets = { inherited } SOMObject_somObjectOffsets;
  ObjectMgr_SOMObjectSequence = { inherited } SOMObject_SOMObjectSequence;
  ObjectMgr_BooleanSequence = { inherited } SOMObject_BooleanSequence;
  ObjectMgr_somObjectOffsets = { inherited } SOMObject_somObjectOffsets;
  OperationDef_OperationMode = type LongWord;
  OperationDef_SOMObjectSequence = { inherited } SOMObject_SOMObjectSequence;
  OperationDef_BooleanSequence = { inherited } SOMObject_BooleanSequence;
  OperationDef_somObjectOffsets = { inherited } SOMObject_somObjectOffsets;
  OperationDef_InterfaceName = { inherited } Container_InterfaceName;
  ORB_SOMObjectSequence = { inherited } SOMObject_SOMObjectSequence;
  ORB_BooleanSequence = { inherited } SOMObject_BooleanSequence;
  ORB_somObjectOffsets = { inherited } SOMObject_somObjectOffsets;
  ParameterDef_ParameterMode = type LongWord;
  ParameterDef_SOMObjectSequence = { inherited } SOMObject_SOMObjectSequence;
  ParameterDef_BooleanSequence = { inherited } SOMObject_BooleanSequence;
  ParameterDef_somObjectOffsets = { inherited } SOMObject_somObjectOffsets;
  Principal_SOMObjectSequence = { inherited } SOMObject_SOMObjectSequence;
  Principal_BooleanSequence = { inherited } SOMObject_BooleanSequence;
  Principal_somObjectOffsets = { inherited } SOMObject_somObjectOffsets;
  Repository_irOpenErrorCodes = type LongWord;
  Repository_InterfaceName = { inherited } Container_InterfaceName;
  Repository_SOMObjectSequence = { inherited } SOMObject_SOMObjectSequence;
  Repository_BooleanSequence = { inherited } SOMObject_BooleanSequence;
  Repository_somObjectOffsets = { inherited } SOMObject_somObjectOffsets;
  Request_SOMObjectSequence = { inherited } SOMObject_SOMObjectSequence;
  Request_BooleanSequence = { inherited } SOMObject_BooleanSequence;
  Request_somObjectOffsets = { inherited } SOMObject_somObjectOffsets;
  Entry = Pointer;
  Mlist = Pointer;
  AttList = Pointer;
  NumberList = Pointer;
  SwitchBody = Pointer;
  SOMTTargetTypeT = type LongWord;
  SOMTTypes = LongWord;
  SOMTEntryC_SOMObjectSequence = { inherited } SOMObject_SOMObjectSequence;
  SOMTEntryC_BooleanSequence = { inherited } SOMObject_BooleanSequence;
  SOMTEntryC_somObjectOffsets = { inherited } SOMObject_somObjectOffsets;
  SOMTAttributeEntryC_SOMObjectSequence = { inherited } SOMObject_SOMObjectSequence;
  SOMTAttributeEntryC_BooleanSequence = { inherited } SOMObject_BooleanSequence;
  SOMTAttributeEntryC_somObjectOffsets = { inherited } SOMObject_somObjectOffsets;
  SOMTBaseClassEntryC_SOMObjectSequence = { inherited } SOMObject_SOMObjectSequence;
  SOMTBaseClassEntryC_BooleanSequence = { inherited } SOMObject_BooleanSequence;
  SOMTBaseClassEntryC_somObjectOffsets = { inherited } SOMObject_somObjectOffsets;
  SOMTClassEntryC_SOMObjectSequence = { inherited } SOMObject_SOMObjectSequence;
  SOMTClassEntryC_BooleanSequence = { inherited } SOMObject_BooleanSequence;
  SOMTClassEntryC_somObjectOffsets = { inherited } SOMObject_somObjectOffsets;
  somtVisibilityT = type LongWord;
  SOMTCommonEntryC_SOMObjectSequence = { inherited } SOMObject_SOMObjectSequence;
  SOMTCommonEntryC_BooleanSequence = { inherited } SOMObject_BooleanSequence;
  SOMTCommonEntryC_somObjectOffsets = { inherited } SOMObject_somObjectOffsets;
  SOMTConstEntryC_SOMObjectSequence = { inherited } SOMObject_SOMObjectSequence;
  SOMTConstEntryC_BooleanSequence = { inherited } SOMObject_BooleanSequence;
  SOMTConstEntryC_somObjectOffsets = { inherited } SOMObject_somObjectOffsets;
  SOMTDataEntryC_SOMObjectSequence = { inherited } SOMObject_SOMObjectSequence;
  SOMTDataEntryC_BooleanSequence = { inherited } SOMObject_BooleanSequence;
  SOMTDataEntryC_somObjectOffsets = { inherited } SOMObject_somObjectOffsets;
  somtCommentStyleT = type LongWord;
  SOMTEmitC_SOMObjectSequence = { inherited } SOMObject_SOMObjectSequence;
  SOMTEmitC_BooleanSequence = { inherited } SOMObject_BooleanSequence;
  SOMTEmitC_somObjectOffsets = { inherited } SOMObject_somObjectOffsets;
  SOMTEnumEntryC_SOMObjectSequence = { inherited } SOMObject_SOMObjectSequence;
  SOMTEnumEntryC_BooleanSequence = { inherited } SOMObject_BooleanSequence;
  SOMTEnumEntryC_somObjectOffsets = { inherited } SOMObject_somObjectOffsets;
  SOMTEnumNameEntryC_SOMObjectSequence = { inherited } SOMObject_SOMObjectSequence;
  SOMTEnumNameEntryC_BooleanSequence = { inherited } SOMObject_BooleanSequence;
  SOMTEnumNameEntryC_somObjectOffsets = { inherited } SOMObject_somObjectOffsets;
  SOMTMetaClassEntryC_SOMObjectSequence = { inherited } SOMObject_SOMObjectSequence;
  SOMTMetaClassEntryC_BooleanSequence = { inherited } SOMObject_BooleanSequence;
  SOMTMetaClassEntryC_somObjectOffsets = { inherited } SOMObject_somObjectOffsets;
  SOMTMethodEntryC_SOMObjectSequence = { inherited } SOMObject_SOMObjectSequence;
  SOMTMethodEntryC_BooleanSequence = { inherited } SOMObject_BooleanSequence;
  SOMTMethodEntryC_somObjectOffsets = { inherited } SOMObject_somObjectOffsets;
  SOMTModuleEntryC_SOMObjectSequence = { inherited } SOMObject_SOMObjectSequence;
  SOMTModuleEntryC_BooleanSequence = { inherited } SOMObject_BooleanSequence;
  SOMTModuleEntryC_somObjectOffsets = { inherited } SOMObject_somObjectOffsets;
  somtParameterDirectionT = type LongWord;
  SOMTParameterEntryC_SOMObjectSequence = { inherited } SOMObject_SOMObjectSequence;
  SOMTParameterEntryC_BooleanSequence = { inherited } SOMObject_BooleanSequence;
  SOMTParameterEntryC_somObjectOffsets = { inherited } SOMObject_somObjectOffsets;
  SOMTPassthruEntryC_SOMObjectSequence = { inherited } SOMObject_SOMObjectSequence;
  SOMTPassthruEntryC_BooleanSequence = { inherited } SOMObject_BooleanSequence;
  SOMTPassthruEntryC_somObjectOffsets = { inherited } SOMObject_somObjectOffsets;
  SOMTSequenceEntryC_SOMObjectSequence = { inherited } SOMObject_SOMObjectSequence;
  SOMTSequenceEntryC_BooleanSequence = { inherited } SOMObject_BooleanSequence;
  SOMTSequenceEntryC_somObjectOffsets = { inherited } SOMObject_somObjectOffsets;
  SOMTStringEntryC_SOMObjectSequence = { inherited } SOMObject_SOMObjectSequence;
  SOMTStringEntryC_BooleanSequence = { inherited } SOMObject_BooleanSequence;
  SOMTStringEntryC_somObjectOffsets = { inherited } SOMObject_somObjectOffsets;
  SOMTStructEntryC_SOMObjectSequence = { inherited } SOMObject_SOMObjectSequence;
  SOMTStructEntryC_BooleanSequence = { inherited } SOMObject_BooleanSequence;
  SOMTStructEntryC_somObjectOffsets = { inherited } SOMObject_somObjectOffsets;
  SOMTTypedefEntryC_SOMObjectSequence = { inherited } SOMObject_SOMObjectSequence;
  SOMTTypedefEntryC_BooleanSequence = { inherited } SOMObject_BooleanSequence;
  SOMTTypedefEntryC_somObjectOffsets = { inherited } SOMObject_somObjectOffsets;
  SOMTTemplateOutputC_SOMObjectSequence = { inherited } SOMObject_SOMObjectSequence;
  SOMTTemplateOutputC_BooleanSequence = { inherited } SOMObject_BooleanSequence;
  SOMTTemplateOutputC_somObjectOffsets = { inherited } SOMObject_somObjectOffsets;
  SOMTUnionEntryC_SOMObjectSequence = { inherited } SOMObject_SOMObjectSequence;
  SOMTUnionEntryC_BooleanSequence = { inherited } SOMObject_BooleanSequence;
  SOMTUnionEntryC_somObjectOffsets = { inherited } SOMObject_somObjectOffsets;
  SOMTUserDefinedTypeEntryC_SOMObjectSequence = { inherited } SOMObject_SOMObjectSequence;
  SOMTUserDefinedTypeEntryC_BooleanSequence = { inherited } SOMObject_BooleanSequence;
  SOMTUserDefinedTypeEntryC_somObjectOffsets = { inherited } SOMObject_somObjectOffsets;
  SOMDServerMgr_SOMObjectSequence = { inherited } SOMObject_SOMObjectSequence;
  SOMDServerMgr_BooleanSequence = { inherited } SOMObject_BooleanSequence;
  SOMDServerMgr_somObjectOffsets = { inherited } SOMObject_somObjectOffsets;
  SOMESinkEvent_SOMObjectSequence = { inherited } SOMObject_SOMObjectSequence;
  SOMESinkEvent_BooleanSequence = { inherited } SOMObject_BooleanSequence;
  SOMESinkEvent_somObjectOffsets = { inherited } SOMObject_somObjectOffsets;
  P_IDL_ArrayOf_Pointer = ^_IDL_ArrayOf_Pointer;
  _IDL_Sequence_Pointer = packed record
    _maximum: LongWord;
    _length: LongWord;
    _buffer: P_IDL_ArrayOf_Pointer;
  end;
  SOMClass_somTokenSequence = _IDL_Sequence_Pointer;
  P_IDL_ArrayOf_SOMClass = ^_IDL_ArrayOf_SOMClass;
  _IDL_Sequence_SOMClass = packed record
    _maximum: LongWord;
    _length: LongWord;
    _buffer: P_IDL_ArrayOf_SOMClass;
  end;
  SOMClass_SOMClassSequence = _IDL_Sequence_SOMClass;
  P_IDL_ArrayOf_SOMClass_somOffsetInfo = ^_IDL_ArrayOf_SOMClass_somOffsetInfo;
  _IDL_Sequence_SOMClass_somOffsetInfo = packed record
    _maximum: LongWord;
    _length: LongWord;
    _buffer: P_IDL_ArrayOf_SOMClass_somOffsetInfo;
  end;
  SOMClass_somOffsets = _IDL_Sequence_SOMClass_somOffsetInfo;
  P_IDL_ArrayOf_somId = ^_IDL_ArrayOf_somId;
  _IDL_Sequence_somId = packed record
    _maximum: LongWord;
    _length: LongWord;
    _buffer: P_IDL_ArrayOf_somId;
  end;
  SOMClass_somIdSequence = _IDL_Sequence_somId;
  SOMClass_SOMObjectSequence = { inherited } SOMObject_SOMObjectSequence;
  SOMClass_BooleanSequence = { inherited } SOMObject_BooleanSequence;
  SOMClass_somObjectOffsets = { inherited } SOMObject_somObjectOffsets;
  SOMMSingleInstance_somTokenSequence = { inherited } SOMClass_somTokenSequence;
  SOMMSingleInstance_SOMClassSequence = { inherited } SOMClass_SOMClassSequence;
  SOMMSingleInstance_somOffsets = { inherited } SOMClass_somOffsets;
  SOMMSingleInstance_somIdSequence = { inherited } SOMClass_somIdSequence;
  SOMMSingleInstance_SOMObjectSequence = { inherited } SOMObject_SOMObjectSequence;
  SOMMSingleInstance_BooleanSequence = { inherited } SOMObject_BooleanSequence;
  SOMMSingleInstance_somObjectOffsets = { inherited } SOMObject_somObjectOffsets;
  SOMMBeforeAfter_somTokenSequence = { inherited } SOMClass_somTokenSequence;
  SOMMBeforeAfter_SOMClassSequence = { inherited } SOMClass_SOMClassSequence;
  SOMMBeforeAfter_somOffsets = { inherited } SOMClass_somOffsets;
  SOMMBeforeAfter_somIdSequence = { inherited } SOMClass_somIdSequence;
  SOMMBeforeAfter_SOMObjectSequence = { inherited } SOMObject_SOMObjectSequence;
  SOMMBeforeAfter_BooleanSequence = { inherited } SOMObject_BooleanSequence;
  SOMMBeforeAfter_somObjectOffsets = { inherited } SOMObject_somObjectOffsets;
  SOMClassMgr_SOMClassArray = ^SOMClass;
  SOMClassMgr_SOMObjectSequence = { inherited } SOMObject_SOMObjectSequence;
  SOMClassMgr_BooleanSequence = { inherited } SOMObject_BooleanSequence;
  SOMClassMgr_somObjectOffsets = { inherited } SOMObject_somObjectOffsets;
  SOMDObject_SOMObjectSequence = { inherited } SOMObject_SOMObjectSequence;
  SOMDObject_BooleanSequence = { inherited } SOMObject_BooleanSequence;
  SOMDObject_somObjectOffsets = { inherited } SOMObject_somObjectOffsets;
  SOMDClientProxy_SOMObjectSequence = { inherited } SOMObject_SOMObjectSequence;
  SOMDClientProxy_BooleanSequence = { inherited } SOMObject_BooleanSequence;
  SOMDClientProxy_somObjectOffsets = { inherited } SOMObject_somObjectOffsets;
  SOMDMetaproxy_somTokenSequence = { inherited } SOMClass_somTokenSequence;
  SOMDMetaproxy_SOMClassSequence = { inherited } SOMClass_SOMClassSequence;
  SOMDMetaproxy_somOffsets = { inherited } SOMClass_somOffsets;
  SOMDMetaproxy_somIdSequence = { inherited } SOMClass_somIdSequence;
  SOMDMetaproxy_SOMObjectSequence = { inherited } SOMObject_SOMObjectSequence;
  SOMDMetaproxy_BooleanSequence = { inherited } SOMObject_BooleanSequence;
  SOMDMetaproxy_somObjectOffsets = { inherited } SOMObject_somObjectOffsets;
  SOMDObjectMgr_SOMObjectSequence = { inherited } SOMObject_SOMObjectSequence;
  SOMDObjectMgr_BooleanSequence = { inherited } SOMObject_BooleanSequence;
  SOMDObjectMgr_somObjectOffsets = { inherited } SOMObject_somObjectOffsets;
  SOMDServer_SOMObjectSequence = { inherited } SOMObject_SOMObjectSequence;
  SOMDServer_BooleanSequence = { inherited } SOMObject_BooleanSequence;
  SOMDServer_somObjectOffsets = { inherited } SOMObject_somObjectOffsets;
  SOMUTId_SOMObjectSequence = { inherited } SOMObject_SOMObjectSequence;
  SOMUTId_BooleanSequence = { inherited } SOMObject_BooleanSequence;
  SOMUTId_somObjectOffsets = { inherited } SOMObject_somObjectOffsets;
  SOMOA_SOMObjectSequence = { inherited } SOMObject_SOMObjectSequence;
  SOMOA_BooleanSequence = { inherited } SOMObject_BooleanSequence;
  SOMOA_somObjectOffsets = { inherited } SOMObject_somObjectOffsets;
  Sockets_SOMObjectSequence = { inherited } SOMObject_SOMObjectSequence;
  Sockets_BooleanSequence = { inherited } SOMObject_BooleanSequence;
  Sockets_somObjectOffsets = { inherited } SOMObject_somObjectOffsets;
  PentryT = ^entryT;
  PPentryT = ^PentryT;
  tablePT = ^PPentryT;
  SOMStringTableC_SOMObjectSequence = { inherited } SOMObject_SOMObjectSequence;
  SOMStringTableC_BooleanSequence = { inherited } SOMObject_BooleanSequence;
  SOMStringTableC_somObjectOffsets = { inherited } SOMObject_somObjectOffsets;
  SOMMTraced_somTokenSequence = { inherited } SOMClass_somTokenSequence;
  SOMMTraced_SOMClassSequence = { inherited } SOMClass_SOMClassSequence;
  SOMMTraced_somOffsets = { inherited } SOMClass_somOffsets;
  SOMMTraced_somIdSequence = { inherited } SOMClass_somIdSequence;
  SOMMTraced_SOMObjectSequence = { inherited } SOMObject_SOMObjectSequence;
  SOMMTraced_BooleanSequence = { inherited } SOMObject_BooleanSequence;
  SOMMTraced_somObjectOffsets = { inherited } SOMObject_somObjectOffsets;
  SOMETimerEvent_SOMObjectSequence = { inherited } SOMObject_SOMObjectSequence;
  SOMETimerEvent_BooleanSequence = { inherited } SOMObject_BooleanSequence;
  SOMETimerEvent_somObjectOffsets = { inherited } SOMObject_somObjectOffsets;
  TSIdentification_SOMObjectSequence = { inherited } SOMObject_SOMObjectSequence;
  TSIdentification_BooleanSequence = { inherited } SOMObject_BooleanSequence;
  TSIdentification_somObjectOffsets = { inherited } SOMObject_somObjectOffsets;
  TypeDef_SOMObjectSequence = { inherited } SOMObject_SOMObjectSequence;
  TypeDef_BooleanSequence = { inherited } SOMObject_BooleanSequence;
  TypeDef_somObjectOffsets = { inherited } SOMObject_somObjectOffsets;
  SOMEWorkProcEvent_SOMObjectSequence = { inherited } SOMObject_SOMObjectSequence;
  SOMEWorkProcEvent_BooleanSequence = { inherited } SOMObject_BooleanSequence;
  SOMEWorkProcEvent_somObjectOffsets = { inherited } SOMObject_somObjectOffsets;

  { Records }
  StExcep = packed record
    minor: LongWord;
    completed: completion_status;
  end;
  PStExcep = ^StExcep;

  Environment = packed record
    _major: exception_type;
    exception_exception_name: PAnsiChar;
    exception_params: Pointer;
    _somdAnchor: Pointer;
  end;

  somMethodTab = packed record
    SOM_classObject: SOMClass;
  end;

  SOMAny = packed record
    mtab: PsomMethodTab;
  end;

  somMethodInfo = packed record
    callType: LongWord;
    va_listSize: LongInt;
    float_map: PLongWord;
  end;

  somMethodDataStruct = packed record
    id: somId;
    SOM_type: LongInt;
    descriptor: somId;
    mToken: Pointer;
    method: Pointer;
    shared: PPointer;
  end;

  somMethodData = packed record
    id: somId;
    SOM_type: LongInt;
    descriptor: somId;
    mToken: Pointer;
    method: Pointer;
    shared: PPointer;
  end;

  somClassList = packed record
    cls: SOMClass;
    next: PsomClassList;
  end;

  somMethodTabList = packed record
    mtab: PsomMethodTab;
    next: PsomMethodTabList;
  end;

  somClassDataStructure = packed record
    SOM_classObject: SOMClass;
    tokens: _IDL_Array1Of_Pointer;
  end;

  somCClassDataStructure = packed record
    parentMtab: PsomMethodTabList;
    instanceDataToken: Pointer;
    ptrs: _IDL_Array1Of_Pointer;
  end;

  somModifier = packed record
    name: CORBAString;
    value: CORBAString;
  end;

  SOMObject_somObjectOffset = packed record
    obj: SOMObject;
    offset: LongInt;
  end;

  Contained_Description = packed record
    name: CORBAString;
    value: any;
  end;
  Contained_somObjectOffset = { inherited } SOMObject_somObjectOffset;

  AttributeDef_AttributeDescription = packed record
    name: CORBAString;
    id: CORBAString;
    defined_in: CORBAString;
    SOM_type: TypeCode;
    mode: AttributeDef_AttributeMode;
  end;
  AttributeDef_Description = { inherited } Contained_Description;
  AttributeDef_somObjectOffset = { inherited } SOMObject_somObjectOffset;

  NamedValue = packed record
    name: CORBAString;
    argument: any;
    len: LongInt;
    arg_modes: LongWord;
  end;
  BOA_somObjectOffset = { inherited } SOMObject_somObjectOffset;
  SOMEEvent_somObjectOffset = { inherited } SOMObject_somObjectOffset;
  SOMEClientEvent_somObjectOffset = { inherited } SOMObject_somObjectOffset;
  Context_somObjectOffset = { inherited } SOMObject_somObjectOffset;

  ConstantDef_ConstantDescription = packed record
    name: CORBAString;
    id: CORBAString;
    defined_in: CORBAString;
    SOM_type: TypeCode;
    value: any;
  end;
  ConstantDef_Description = { inherited } Contained_Description;
  ConstantDef_somObjectOffset = { inherited } SOMObject_somObjectOffset;

  Container_ContainerDescription = packed record
    contained_object: Contained;
    name: CORBAString;
    value: any;
  end;
  Container_somObjectOffset = { inherited } SOMObject_somObjectOffset;
  SOMEEMan_somObjectOffset = { inherited } SOMObject_somObjectOffset;
  SOMEEMRegisterData_somObjectOffset = { inherited } SOMObject_somObjectOffset;

  ExceptionDef_ExceptionDescription = packed record
    name: CORBAString;
    id: CORBAString;
    defined_in: CORBAString;
    SOM_type: TypeCode;
  end;
  ExceptionDef_Description = { inherited } Contained_Description;
  ExceptionDef_somObjectOffset = { inherited } SOMObject_somObjectOffset;
  ImplementationDef_somObjectOffset = { inherited } SOMObject_somObjectOffset;
  ImplRepository_somObjectOffset = { inherited } SOMObject_somObjectOffset;

  P_IDL_ArrayOf_CORBAString = ^_IDL_ArrayOf_CORBAString;
  _IDL_Sequence_CORBAString = packed record
    _maximum: LongWord;
    _length: LongWord;
    _buffer: P_IDL_ArrayOf_CORBAString;
  end;
  P_IDL_ArrayOf_ParameterDef_ParameterDescription = ^_IDL_ArrayOf_ParameterDef_ParameterDescription;
  _IDL_Sequence_ParameterDef_ParameterDescription = packed record
    _maximum: LongWord;
    _length: LongWord;
    _buffer: P_IDL_ArrayOf_ParameterDef_ParameterDescription;
  end;
  P_IDL_ArrayOf_ExceptionDef_ExceptionDescription = ^_IDL_ArrayOf_ExceptionDef_ExceptionDescription;
  _IDL_Sequence_ExceptionDef_ExceptionDescription = packed record
    _maximum: LongWord;
    _length: LongWord;
    _buffer: P_IDL_ArrayOf_ExceptionDef_ExceptionDescription;
  end;
  P_IDL_ArrayOf_OperationDef_OperationDescription = ^_IDL_ArrayOf_OperationDef_OperationDescription;
  _IDL_Sequence_OperationDef_OperationDescription = packed record
    _maximum: LongWord;
    _length: LongWord;
    _buffer: P_IDL_ArrayOf_OperationDef_OperationDescription;
  end;
  P_IDL_ArrayOf_AttributeDef_AttributeDescription = ^_IDL_ArrayOf_AttributeDef_AttributeDescription;
  _IDL_Sequence_AttributeDef_AttributeDescription = packed record
    _maximum: LongWord;
    _length: LongWord;
    _buffer: P_IDL_ArrayOf_AttributeDef_AttributeDescription;
  end;
  InterfaceDef_FullInterfaceDescription = packed record
    name: CORBAString;
    id: CORBAString;
    defined_in: CORBAString;
    operation: _IDL_Sequence_OperationDef_OperationDescription;
    attributes: _IDL_Sequence_AttributeDef_AttributeDescription;
  end;

  InterfaceDef_InterfaceDescription = packed record
    name: CORBAString;
    id: CORBAString;
    defined_in: CORBAString;
  end;
  InterfaceDef_Description = { inherited } Contained_Description;
  InterfaceDef_somObjectOffset = { inherited } SOMObject_somObjectOffset;
  InterfaceDef_ContainerDescription = { inherited } Container_ContainerDescription;

  ModuleDef_ModuleDescription = packed record
    name: CORBAString;
    id: CORBAString;
    defined_in: CORBAString;
  end;
  ModuleDef_Description = { inherited } Contained_Description;
  ModuleDef_somObjectOffset = { inherited } SOMObject_somObjectOffset;
  ModuleDef_ContainerDescription = { inherited } Container_ContainerDescription;
  NVList_somObjectOffset = { inherited } SOMObject_somObjectOffset;
  ObjectMgr_somObjectOffset = { inherited } SOMObject_somObjectOffset;

  OperationDef_OperationDescription = packed record
    name: CORBAString;
    id: CORBAString;
    defined_in: CORBAString;
    SOM_result: TypeCode;
    mode: OperationDef_OperationMode;
    contexts: _IDL_Sequence_CORBAString;
    parameter: _IDL_Sequence_ParameterDef_ParameterDescription;
    exceptions: _IDL_Sequence_ExceptionDef_ExceptionDescription;
  end;
  OperationDef_Description = { inherited } Contained_Description;
  OperationDef_somObjectOffset = { inherited } SOMObject_somObjectOffset;
  OperationDef_ContainerDescription = { inherited } Container_ContainerDescription;
  ORB_somObjectOffset = { inherited } SOMObject_somObjectOffset;

  ParameterDef_ParameterDescription = packed record
    name: CORBAString;
    id: CORBAString;
    defined_in: CORBAString;
    SOM_type: TypeCode;
    mode: ParameterDef_ParameterMode;
  end;
  ParameterDef_Description = { inherited } Contained_Description;
  ParameterDef_somObjectOffset = { inherited } SOMObject_somObjectOffset;
  Principal_somObjectOffset = { inherited } SOMObject_somObjectOffset;

  Repository_RepositoryDescription = packed record
    name: CORBAString;
    id: CORBAString;
    defined_in: CORBAString;
  end;

  Repository_irOpenError = { user exception } packed record
    errorCode: Repository_irOpenErrorCodes;
    fileName: CORBAString;
  end;
  Repository_ContainerDescription = { inherited } Container_ContainerDescription;
  Repository_somObjectOffset = { inherited } SOMObject_somObjectOffset;
  Request_somObjectOffset = { inherited } SOMObject_somObjectOffset;
  SOMTEntryC_somObjectOffset = { inherited } SOMObject_somObjectOffset;
  SOMTAttributeEntryC_somObjectOffset = { inherited } SOMObject_somObjectOffset;
  SOMTBaseClassEntryC_somObjectOffset = { inherited } SOMObject_somObjectOffset;
  SOMTClassEntryC_somObjectOffset = { inherited } SOMObject_somObjectOffset;
  SOMTCommonEntryC_somObjectOffset = { inherited } SOMObject_somObjectOffset;
  SOMTConstEntryC_somObjectOffset = { inherited } SOMObject_somObjectOffset;
  SOMTDataEntryC_somObjectOffset = { inherited } SOMObject_somObjectOffset;
  SOMTEmitC_somObjectOffset = { inherited } SOMObject_somObjectOffset;
  SOMTEnumEntryC_somObjectOffset = { inherited } SOMObject_somObjectOffset;
  SOMTEnumNameEntryC_somObjectOffset = { inherited } SOMObject_somObjectOffset;
  SOMTMetaClassEntryC_somObjectOffset = { inherited } SOMObject_somObjectOffset;
  SOMTMethodEntryC_somObjectOffset = { inherited } SOMObject_somObjectOffset;
  SOMTModuleEntryC_somObjectOffset = { inherited } SOMObject_somObjectOffset;
  SOMTParameterEntryC_somObjectOffset = { inherited } SOMObject_somObjectOffset;
  SOMTPassthruEntryC_somObjectOffset = { inherited } SOMObject_somObjectOffset;
  SOMTSequenceEntryC_somObjectOffset = { inherited } SOMObject_somObjectOffset;
  SOMTStringEntryC_somObjectOffset = { inherited } SOMObject_somObjectOffset;
  SOMTStructEntryC_somObjectOffset = { inherited } SOMObject_somObjectOffset;
  SOMTTypedefEntryC_somObjectOffset = { inherited } SOMObject_somObjectOffset;
  SOMTTemplateOutputC_somObjectOffset = { inherited } SOMObject_somObjectOffset;

  PSOMTUnionEntryC_somtLabelList = ^SOMTUnionEntryC_somtLabelList;
  SOMTUnionEntryC_somtLabelList = packed record
    SOM_label: CORBAString;
    nextLabel: PSOMTUnionEntryC_somtLabelList;
  end;

  SOMTUnionEntryC_somtCaseEntry = packed record
    caseLabels: PSOMTUnionEntryC_somtLabelList;
    memberType: SOMTEntryC;
    memberDeclarator: SOMTDataEntryC;
  end;
  SOMTUnionEntryC_somObjectOffset = { inherited } SOMObject_somObjectOffset;
  SOMTUserDefinedTypeEntryC_somObjectOffset = { inherited } SOMObject_somObjectOffset;
  SOMDServerMgr_somObjectOffset = { inherited } SOMObject_somObjectOffset;
  SOMESinkEvent_somObjectOffset = { inherited } SOMObject_somObjectOffset;

  SOMClass_somOffsetInfo = packed record
    cls: SOMClass;
    offset: LongInt;
  end;
  SOMClass_somObjectOffset = { inherited } SOMObject_somObjectOffset;
  SOMMSingleInstance_somOffsetInfo = { inherited } SOMClass_somOffsetInfo;
  SOMMSingleInstance_somObjectOffset = { inherited } SOMObject_somObjectOffset;
  SOMMBeforeAfter_somOffsetInfo = { inherited } SOMClass_somOffsetInfo;
  SOMMBeforeAfter_somObjectOffset = { inherited } SOMObject_somObjectOffset;
  SOMClassMgr_somObjectOffset = { inherited } SOMObject_somObjectOffset;
  SOMDObject_somObjectOffset = { inherited } SOMObject_somObjectOffset;
  SOMDClientProxy_somObjectOffset = { inherited } SOMObject_somObjectOffset;
  SOMDMetaproxy_somOffsetInfo = { inherited } SOMClass_somOffsetInfo;
  SOMDMetaproxy_somObjectOffset = { inherited } SOMObject_somObjectOffset;
  SOMDObjectMgr_somObjectOffset = { inherited } SOMObject_somObjectOffset;
  SOMDServer_somObjectOffset = { inherited } SOMObject_somObjectOffset;
  SOMUTId_somObjectOffset = { inherited } SOMObject_somObjectOffset;
  SOMOA_somObjectOffset = { inherited } SOMObject_somObjectOffset;
  Sockets_somObjectOffset = { inherited } SOMObject_somObjectOffset;

  entryT = packed record
    key: CORBAString;
    value: CORBAString;
    next: PentryT;
  end;
  SOMStringTableC_somObjectOffset = { inherited } SOMObject_somObjectOffset;
  SOMMTraced_somOffsetInfo = { inherited } SOMClass_somOffsetInfo;
  SOMMTraced_somObjectOffset = { inherited } SOMObject_somObjectOffset;
  StExcep_UNKNOWN = { system exception } StExcep;
  StExcep_BAD_PARAM = { system exception } StExcep;
  StExcep_NO_MEMORY = { system exception } StExcep;
  StExcep_IMP_LIMIT = { system exception } StExcep;
  StExcep_COMM_FAILURE = { system exception } StExcep;
  StExcep_INV_OBJREF = { system exception } StExcep;
  StExcep_NO_PERMISSION = { system exception } StExcep;
  StExcep_INTERNAL = { system exception } StExcep;
  StExcep_MARSHAL = { system exception } StExcep;
  StExcep_INITIALIZE = { system exception } StExcep;
  StExcep_NO_IMPLEMENT = { system exception } StExcep;
  StExcep_BAD_TYPECODE = { system exception } StExcep;
  StExcep_BAD_OPERATION = { system exception } StExcep;
  StExcep_NO_RESOURCES = { system exception } StExcep;
  StExcep_NO_RESPONSE = { system exception } StExcep;
  StExcep_PERSIST_STORE = { system exception } StExcep;
  StExcep_BAD_INV_ORDER = { system exception } StExcep;
  StExcep_TRANSIENT = { system exception } StExcep;
  StExcep_FREE_MEM = { system exception } StExcep;
  StExcep_INV_IDENT = { system exception } StExcep;
  StExcep_INV_FLAG = { system exception } StExcep;
  StExcep_INTF_REPOS = { system exception } StExcep;
  StExcep_CONTEXT = { system exception } StExcep;
  StExcep_OBJ_ADAPTER = { system exception } StExcep;
  StExcep_DATA_CONVERSION = { system exception } StExcep;
  StExcep_OPSYS = { system exception } StExcep;
  StExcep_WMQUIT = { system exception } StExcep;
  StExcep_DISPATCH = { system exception } StExcep;
  StExcep_TransactionRequired = { system exception } StExcep;
  StExcep_TransactionRolledBack = { system exception } StExcep;
  StExcep_InvalidTransaction = { system exception } StExcep;
  StExcep_WrongTransaction = { system exception } StExcep;
  SOMETimerEvent_somObjectOffset = { inherited } SOMObject_somObjectOffset;
  TSIdentification_somObjectOffset = { inherited } SOMObject_somObjectOffset;

  TypeDef_TypeDescription = packed record
    name: CORBAString;
    id: CORBAString;
    defined_in: CORBAString;
    SOM_type: TypeCode;
  end;
  TypeDef_Description = { inherited } Contained_Description;
  TypeDef_somObjectOffset = { inherited } SOMObject_somObjectOffset;
  SOMEWorkProcEvent_somObjectOffset = { inherited } SOMObject_somObjectOffset;

  { Classes }
  SOMObjectBase = class
    { hide or reimplement TObject methods }
  protected
    class procedure Create; reintroduce;
  public
    procedure Free; reintroduce;
  protected
    class procedure InitInstance; reintroduce;
  public
    procedure CleanupInstance; reintroduce;
    function ClassType: SOMClass; reintroduce;
  protected
    class procedure ClassName; reintroduce;
    class procedure ClassNameIs; reintroduce;
    class procedure ClassParent; reintroduce;
    class procedure ClassInfo; reintroduce;
    class procedure InstanceSize; reintroduce;
    class procedure InheritsFrom; reintroduce;
    class procedure MethodAddress; reintroduce;
    class procedure MethodName; reintroduce;
    procedure FieldAddress; reintroduce;
    procedure GetInterface; reintroduce;
    class procedure GetInterfaceEntry; reintroduce;
    class procedure GetInterfaceTable; reintroduce;
    procedure SafeCallException; reintroduce;
  public
    procedure AfterConstruction; reintroduce;
    procedure BeforeDestruction; reintroduce;
  protected
    procedure Dispatch; reintroduce;
    procedure DefaultHandler; reintroduce;
    class procedure NewInstance; reintroduce;
  public
    procedure FreeInstance; reintroduce;
    procedure Destroy; reintroduce;

    { Upcasting }
    function As_SOMObject: SOMObject; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
  end;

  TypeCode = class
    { hide or reimplement TObject methods }
  public
    procedure Free; reintroduce;
  protected
    class procedure InitInstance; reintroduce;
  public
    procedure CleanupInstance; reintroduce;
  protected
    procedure ClassType; reintroduce;
  public
    class function ClassName: string; reintroduce;
    class function ClassNameIs(const Name: string): Boolean; reintroduce;
  protected
    class procedure ClassParent; reintroduce;
    class procedure ClassInfo; reintroduce;
    class procedure InstanceSize; reintroduce;
    class procedure InheritsFrom; reintroduce;
    class procedure MethodAddress; reintroduce;
    class procedure MethodName; reintroduce;
    procedure FieldAddress; reintroduce;
    procedure GetInterface; reintroduce;
    class procedure GetInterfaceEntry; reintroduce;
    class procedure GetInterfaceTable; reintroduce;
    procedure SafeCallException; reintroduce;
  public
    procedure AfterConstruction; reintroduce;
    procedure BeforeDestruction; reintroduce;
  protected
    procedure Dispatch; reintroduce;
    procedure DefaultHandler; reintroduce;
    class procedure NewInstance; reintroduce;
  public
    procedure FreeInstance; reintroduce;
    procedure Destroy; reintroduce;
  protected
    function GetKind: TCKind;
    function GetParamCount: LongInt;
    function GetParameter(Index: LongInt): any;
    function GetAlignment: SmallInt;
    procedure SetAlignment(a: SmallInt);
    function GetSize: LongInt;
  public
    class function TC_null: TypeCode;
    class function TC_void: TypeCode;
    class function TC_short: TypeCode;
    class function TC_long: TypeCode;
    class function TC_ushort: TypeCode;
    class function TC_ulong: TypeCode;
    class function TC_float: TypeCode;
    class function TC_double: TypeCode;
    class function TC_boolean: TypeCode;
    class function TC_char: TypeCode;
    class function TC_octet: TypeCode;
    class function TC_any: TypeCode;
    class function TC_TypeCode: TypeCode;
    class function TC_Principal: TypeCode;
    class function TC_Object: TypeCode;
    class function TC_string: TypeCode;
    class function TC_NamedValue: TypeCode;
    class function TC_InterfaceDescription: TypeCode;
    class function TC_OperationDescription: TypeCode;
    class function TC_AttributeDescription: TypeCode;
    class function TC_ParameterDescription: TypeCode;
    class function TC_RepositoryDescription: TypeCode;
    class function TC_ModuleDescription: TypeCode;
    class function TC_ConstDescription: TypeCode;
    class function TC_ConstantDescription: TypeCode;
    class function TC_ExceptionDescription: TypeCode;
    class function TC_TypeDescription: TypeCode;
    class function TC_FullInterfaceDescription: TypeCode;
    function Equal(y: TypeCode): CORBABoolean;
    function Copy: TypeCode;
    procedure Print;
    class function Create(tag: TCKind): TypeCode; overload;
    class function Create(tag: TCKind; const Arguments: array of const): TypeCode; overload;
    class function Create(tag: TCKind; ap: va_list): TypeCode; overload;
    property Kind: TCKind read GetKind;
    property ParamCount: LongInt read GetParamCount;
    property Parameter[Index: LongInt]: any read GetParameter; default;
    property Alignment: SmallInt read GetAlignment write SetAlignment;
    property Size: LongInt read GetSize;
  end;

  ESOMException = class(Exception)
  protected
    FMajor: exception_type;
    FExceptionId: string;
    FExceptionValue: Pointer;
    FNestedEnvironment: Environment;
    function GetNestedEnvironment: PEnvironment; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
  public
    constructor Create(ev: PEnvironment); overload; // copies ev inside and clears ev argument
    constructor Create(AMajor: exception_type; const AExceptionId: string; AExceptionValue: Pointer); overload; // from user code
    destructor Destroy; override;
    procedure ResetNestedEnvironment; // clears the internal env and thus won't destroy it
    property Major: exception_type read FMajor;
    property ExceptionId: string read FExceptionId;
    property ExceptionValue: Pointer read FExceptionValue;
    property NestedEnvironment: PEnvironment read GetNestedEnvironment;
  end;

  SOMObject = class(SOMObjectBase)
  public
    class function Create: SOMObject; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function InitInstance(Instance: Pointer): SOMObject; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function ClassType: SOMClass; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function ClassName: string; reintroduce;
    class function ClassNameIs(const Name: string): Boolean; reintroduce;
    class function InstanceSize: LongInt; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function InheritsFrom(AClass: SOMClass): Boolean; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function MethodAddress(const Name: string): Pointer; reintroduce;
    class function NewInstance: SOMObject; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function Clone: SOMObject; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultInit(var ctrl: Pointer); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDestruct(doFree: Byte; var ctrl: Pointer); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultCopyInit(var ctrl: Pointer; fromObj: SOMObject); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultAssign(var ctrl: Pointer; fromObj: SOMObject): SOMObject; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultConstCopyInit(var ctrl: Pointer; fromObj: SOMObject); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultVCopyInit(var ctrl: Pointer; fromObj: SOMObject); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultConstVCopyInit(var ctrl: Pointer; fromObj: SOMObject); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultConstAssign(var ctrl: Pointer; fromObj: SOMObject): SOMObject; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultVAssign(var ctrl: Pointer; fromObj: SOMObject): SOMObject; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultConstVAssign(var ctrl: Pointer; fromObj: SOMObject): SOMObject; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somInit; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somFree; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somUninit; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetClass: SOMClass; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetClassName: {dual_owned} CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetSize: LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somIsA(aClassObj: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somIsInstanceOf(aClassObj: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somRespondsTo(mId: somId): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDispatch(out retValue: Pointer; methodId: somId; ap: va_list): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somClassDispatch(clsObj: SOMClass; out retValue: Pointer; methodId: somId; ap: va_list): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somCastObj(cls: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somResetObj: CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somPrintSelf: SOMObject; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDumpSelf(level: LongInt); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDumpSelfInt(level: LongInt); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}

    { Class object access and initialization }
    class function ClassObject: SOMClass; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF} // may be nil before class is created
    class function NewClass: SOMClass; // (not really new every time, but autocreated)

    { Upcasting }

    { Downcasting }
    class function Supports(Instance: SOMObjectBase): Boolean; overload;
    class function Supports(Instance: SOMObjectBase; out Obj: SOMObject): Boolean; overload;

  end;

  P_IDL_ArrayOf_somModifier = ^_IDL_ArrayOf_somModifier;
  _IDL_Sequence_somModifier = packed record
    _maximum: LongWord;
    _length: LongWord;
    _buffer: P_IDL_ArrayOf_somModifier;
  end;
  P_IDL_ArrayOf_Container = ^_IDL_ArrayOf_Container;
  _IDL_Sequence_Container = packed record
    _maximum: LongWord;
    _length: LongWord;
    _buffer: P_IDL_ArrayOf_Container;
  end;
  Contained = class(SOMObjectBase)
  private
    function _get_name: CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure _set_name(name: {caller_owns} CORBAString); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_id: CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure _set_id(id: {caller_owns} CORBAString); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_defined_in: CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure _set_defined_in(defined_in: {caller_owns} CORBAString); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somModifiers: _IDL_Sequence_somModifier; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure _set_somModifiers(const somModifiers: {caller_owns} _IDL_Sequence_somModifier); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
  public
    class function Create: Contained; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function InitInstance(Instance: Pointer): Contained; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function ClassType: SOMClass; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function ClassName: string; reintroduce;
    class function ClassNameIs(const Name: string): Boolean; reintroduce;
    class function InstanceSize: LongInt; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function InheritsFrom(AClass: SOMClass): Boolean; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function MethodAddress(const Name: string): Pointer; reintroduce;
    class function NewInstance: Contained; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function Clone: Contained; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function within: _IDL_Sequence_Container; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function describe: Contained_Description; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultInit(var ctrl: Pointer); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDestruct(doFree: Byte; var ctrl: Pointer); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultCopyInit(var ctrl: Pointer; fromObj: Contained); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultAssign(var ctrl: Pointer; fromObj: Contained): Contained; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultConstCopyInit(var ctrl: Pointer; fromObj: Contained); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultVCopyInit(var ctrl: Pointer; fromObj: Contained); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultConstVCopyInit(var ctrl: Pointer; fromObj: Contained); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultConstAssign(var ctrl: Pointer; fromObj: Contained): Contained; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultVAssign(var ctrl: Pointer; fromObj: Contained): Contained; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultConstVAssign(var ctrl: Pointer; fromObj: Contained): Contained; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somInit; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somFree; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somUninit; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetClass: SOMClass; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetClassName: {dual_owned} CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetSize: LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somIsA(aClassObj: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somIsInstanceOf(aClassObj: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somRespondsTo(mId: somId): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDispatch(out retValue: Pointer; methodId: somId; ap: va_list): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somClassDispatch(clsObj: SOMClass; out retValue: Pointer; methodId: somId; ap: va_list): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somCastObj(cls: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somResetObj: CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somPrintSelf: Contained; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDumpSelf(level: LongInt); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDumpSelfInt(level: LongInt); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}

    { Class object access and initialization }
    class function ClassObject: SOMClass; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF} // may be nil before class is created
    class function NewClass: SOMClass; // (not really new every time, but autocreated)

    { Upcasting }
    function As_Contained: Contained; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}

    { Downcasting }
    class function Supports(Instance: SOMObjectBase): Boolean; overload;
    class function Supports(Instance: SOMObjectBase; out Obj: Contained): Boolean; overload;

    property name: CORBAString read _get_name write _set_name;
    property id: CORBAString read _get_id write _set_id;
    property defined_in: CORBAString read _get_defined_in write _set_defined_in;
    property somModifiers: _IDL_Sequence_somModifier read _get_somModifiers write _set_somModifiers;
  end;

  AttributeDef = class(SOMObjectBase)
  private
    function _get_type: TypeCode; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure _set_type(SOM_type: {caller_owns} TypeCode); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_mode: AttributeDef_AttributeMode; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure _set_mode(mode: AttributeDef_AttributeMode); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_name: CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure _set_name(name: {caller_owns} CORBAString); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_id: CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure _set_id(id: {caller_owns} CORBAString); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_defined_in: CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure _set_defined_in(defined_in: {caller_owns} CORBAString); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somModifiers: _IDL_Sequence_somModifier; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure _set_somModifiers(const somModifiers: {caller_owns} _IDL_Sequence_somModifier); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
  public
    class function Create: AttributeDef; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function InitInstance(Instance: Pointer): AttributeDef; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function ClassType: SOMClass; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function ClassName: string; reintroduce;
    class function ClassNameIs(const Name: string): Boolean; reintroduce;
    class function InstanceSize: LongInt; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function InheritsFrom(AClass: SOMClass): Boolean; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function MethodAddress(const Name: string): Pointer; reintroduce;
    class function NewInstance: AttributeDef; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function Clone: AttributeDef; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function within: _IDL_Sequence_Container; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function describe: Contained_Description; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultInit(var ctrl: Pointer); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDestruct(doFree: Byte; var ctrl: Pointer); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultCopyInit(var ctrl: Pointer; fromObj: AttributeDef); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultAssign(var ctrl: Pointer; fromObj: AttributeDef): AttributeDef; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultConstCopyInit(var ctrl: Pointer; fromObj: AttributeDef); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultVCopyInit(var ctrl: Pointer; fromObj: AttributeDef); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultConstVCopyInit(var ctrl: Pointer; fromObj: AttributeDef); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultConstAssign(var ctrl: Pointer; fromObj: AttributeDef): AttributeDef; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultVAssign(var ctrl: Pointer; fromObj: AttributeDef): AttributeDef; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultConstVAssign(var ctrl: Pointer; fromObj: AttributeDef): AttributeDef; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somInit; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somFree; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somUninit; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetClass: SOMClass; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetClassName: {dual_owned} CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetSize: LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somIsA(aClassObj: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somIsInstanceOf(aClassObj: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somRespondsTo(mId: somId): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDispatch(out retValue: Pointer; methodId: somId; ap: va_list): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somClassDispatch(clsObj: SOMClass; out retValue: Pointer; methodId: somId; ap: va_list): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somCastObj(cls: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somResetObj: CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somPrintSelf: AttributeDef; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDumpSelf(level: LongInt); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDumpSelfInt(level: LongInt); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}

    { Class object access and initialization }
    class function ClassObject: SOMClass; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF} // may be nil before class is created
    class function NewClass: SOMClass; // (not really new every time, but autocreated)

    { Upcasting }
    function As_Contained: Contained; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function As_AttributeDef: AttributeDef; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}

    { Downcasting }
    class function Supports(Instance: SOMObjectBase): Boolean; overload;
    class function Supports(Instance: SOMObjectBase; out Obj: AttributeDef): Boolean; overload;

    property SOM_type: TypeCode read _get_type write _set_type;
    property mode: AttributeDef_AttributeMode read _get_mode write _set_mode;
    property name: CORBAString read _get_name write _set_name;
    property id: CORBAString read _get_id write _set_id;
    property defined_in: CORBAString read _get_defined_in write _set_defined_in;
    property somModifiers: _IDL_Sequence_somModifier read _get_somModifiers write _set_somModifiers;
  end;

  _IDL_Array12Of_Byte = array[0 .. 11] of Byte;
  BOA = class(SOMObjectBase)
  public
    class function Create: BOA; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function InitInstance(Instance: Pointer): BOA; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function ClassType: SOMMSingleInstance; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function ClassName: string; reintroduce;
    class function ClassNameIs(const Name: string): Boolean; reintroduce;
    class function InstanceSize: LongInt; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function InheritsFrom(AClass: SOMClass): Boolean; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function MethodAddress(const Name: string): Pointer; reintroduce;
    class function NewInstance: BOA; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function Clone: BOA; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function SOM_create(const id: _IDL_Sequence_Byte; intf: InterfaceDef; impl: ImplementationDef): SOMDObject; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure dispose(obj: SOMDObject); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function get_id(obj: SOMDObject): _IDL_Sequence_Byte; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function get_principal(obj: SOMDObject; const req_ev: Environment): Principal; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure set_exception(major: exception_type; userid: CORBAString; param: Pointer); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure impl_is_ready(impl: ImplementationDef); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure deactivate_impl(impl: ImplementationDef); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure change_implementation(obj: SOMDObject; impl: ImplementationDef); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure obj_is_ready(obj: SOMDObject; impl: ImplementationDef); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure deactivate_obj(obj: SOMDObject); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultInit(var ctrl: Pointer); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDestruct(doFree: Byte; var ctrl: Pointer); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultCopyInit(var ctrl: Pointer; fromObj: BOA); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultAssign(var ctrl: Pointer; fromObj: BOA): BOA; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultConstCopyInit(var ctrl: Pointer; fromObj: BOA); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultVCopyInit(var ctrl: Pointer; fromObj: BOA); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultConstVCopyInit(var ctrl: Pointer; fromObj: BOA); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultConstAssign(var ctrl: Pointer; fromObj: BOA): BOA; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultVAssign(var ctrl: Pointer; fromObj: BOA): BOA; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultConstVAssign(var ctrl: Pointer; fromObj: BOA): BOA; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somInit; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somFree; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somUninit; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetClass: SOMMSingleInstance; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetClassName: {dual_owned} CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetSize: LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somIsA(aClassObj: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somIsInstanceOf(aClassObj: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somRespondsTo(mId: somId): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDispatch(out retValue: Pointer; methodId: somId; ap: va_list): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somClassDispatch(clsObj: SOMClass; out retValue: Pointer; methodId: somId; ap: va_list): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somCastObj(cls: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somResetObj: CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somPrintSelf: BOA; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDumpSelf(level: LongInt); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDumpSelfInt(level: LongInt); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}

    { Class object access and initialization }
    class function ClassObject: SOMMSingleInstance; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF} // may be nil before class is created
    class function NewClass: SOMMSingleInstance; // (not really new every time, but autocreated)

    { Upcasting }
    function As_BOA: BOA; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}

    { Downcasting }
    class function Supports(Instance: SOMObjectBase): Boolean; overload;
    class function Supports(Instance: SOMObjectBase; out Obj: BOA): Boolean; overload;

  end;

  SOMEEvent = class(SOMObjectBase)
  public
    class function Create: SOMEEvent; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function InitInstance(Instance: Pointer): SOMEEvent; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function ClassType: SOMClass; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function ClassName: string; reintroduce;
    class function ClassNameIs(const Name: string): Boolean; reintroduce;
    class function InstanceSize: LongInt; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function InheritsFrom(AClass: SOMClass): Boolean; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function MethodAddress(const Name: string): Pointer; reintroduce;
    class function NewInstance: SOMEEvent; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function Clone: SOMEEvent; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somevGetEventTime: LongWord; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somevGetEventType: LongWord; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somevSetEventTime(time: LongWord); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somevSetEventType(SOM_type: LongWord); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultInit(var ctrl: Pointer); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDestruct(doFree: Byte; var ctrl: Pointer); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultCopyInit(var ctrl: Pointer; fromObj: SOMEEvent); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultAssign(var ctrl: Pointer; fromObj: SOMEEvent): SOMEEvent; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultConstCopyInit(var ctrl: Pointer; fromObj: SOMEEvent); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultVCopyInit(var ctrl: Pointer; fromObj: SOMEEvent); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultConstVCopyInit(var ctrl: Pointer; fromObj: SOMEEvent); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultConstAssign(var ctrl: Pointer; fromObj: SOMEEvent): SOMEEvent; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultVAssign(var ctrl: Pointer; fromObj: SOMEEvent): SOMEEvent; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultConstVAssign(var ctrl: Pointer; fromObj: SOMEEvent): SOMEEvent; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somInit; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somFree; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somUninit; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetClass: SOMClass; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetClassName: {dual_owned} CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetSize: LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somIsA(aClassObj: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somIsInstanceOf(aClassObj: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somRespondsTo(mId: somId): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDispatch(out retValue: Pointer; methodId: somId; ap: va_list): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somClassDispatch(clsObj: SOMClass; out retValue: Pointer; methodId: somId; ap: va_list): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somCastObj(cls: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somResetObj: CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somPrintSelf: SOMEEvent; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDumpSelf(level: LongInt); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDumpSelfInt(level: LongInt); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}

    { Class object access and initialization }
    class function ClassObject: SOMClass; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF} // may be nil before class is created
    class function NewClass: SOMClass; // (not really new every time, but autocreated)

    { Upcasting }
    function As_SOMEEvent: SOMEEvent; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}

    { Downcasting }
    class function Supports(Instance: SOMObjectBase): Boolean; overload;
    class function Supports(Instance: SOMObjectBase; out Obj: SOMEEvent): Boolean; overload;

  end;

  SOMEClientEvent = class(SOMObjectBase)
  public
    class function Create: SOMEClientEvent; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function InitInstance(Instance: Pointer): SOMEClientEvent; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function ClassType: SOMClass; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function ClassName: string; reintroduce;
    class function ClassNameIs(const Name: string): Boolean; reintroduce;
    class function InstanceSize: LongInt; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function InheritsFrom(AClass: SOMClass): Boolean; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function MethodAddress(const Name: string): Pointer; reintroduce;
    class function NewInstance: SOMEClientEvent; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function Clone: SOMEClientEvent; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somevGetEventClientData: Pointer; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somevGetEventClientType: CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somevSetEventClientData(clientData: Pointer); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somevSetEventClientType(clientType: CORBAString); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somevGetEventTime: LongWord; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somevGetEventType: LongWord; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somevSetEventTime(time: LongWord); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somevSetEventType(SOM_type: LongWord); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultInit(var ctrl: Pointer); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDestruct(doFree: Byte; var ctrl: Pointer); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultCopyInit(var ctrl: Pointer; fromObj: SOMEClientEvent); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultAssign(var ctrl: Pointer; fromObj: SOMEClientEvent): SOMEClientEvent; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultConstCopyInit(var ctrl: Pointer; fromObj: SOMEClientEvent); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultVCopyInit(var ctrl: Pointer; fromObj: SOMEClientEvent); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultConstVCopyInit(var ctrl: Pointer; fromObj: SOMEClientEvent); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultConstAssign(var ctrl: Pointer; fromObj: SOMEClientEvent): SOMEClientEvent; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultVAssign(var ctrl: Pointer; fromObj: SOMEClientEvent): SOMEClientEvent; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultConstVAssign(var ctrl: Pointer; fromObj: SOMEClientEvent): SOMEClientEvent; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somInit; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somFree; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somUninit; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetClass: SOMClass; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetClassName: {dual_owned} CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetSize: LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somIsA(aClassObj: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somIsInstanceOf(aClassObj: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somRespondsTo(mId: somId): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDispatch(out retValue: Pointer; methodId: somId; ap: va_list): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somClassDispatch(clsObj: SOMClass; out retValue: Pointer; methodId: somId; ap: va_list): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somCastObj(cls: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somResetObj: CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somPrintSelf: SOMEClientEvent; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDumpSelf(level: LongInt); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDumpSelfInt(level: LongInt); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}

    { Class object access and initialization }
    class function ClassObject: SOMClass; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF} // may be nil before class is created
    class function NewClass: SOMClass; // (not really new every time, but autocreated)

    { Upcasting }
    function As_SOMEEvent: SOMEEvent; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function As_SOMEClientEvent: SOMEClientEvent; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}

    { Downcasting }
    class function Supports(Instance: SOMObjectBase): Boolean; overload;
    class function Supports(Instance: SOMObjectBase; out Obj: SOMEClientEvent): Boolean; overload;

  end;

  Context = class(SOMObjectBase)
  public
    class function Create: Context; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function InitInstance(Instance: Pointer): Context; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function ClassType: SOMClass; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function ClassName: string; reintroduce;
    class function ClassNameIs(const Name: string): Boolean; reintroduce;
    class function InstanceSize: LongInt; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function InheritsFrom(AClass: SOMClass): Boolean; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function MethodAddress(const Name: string): Pointer; reintroduce;
    class function NewInstance: Context; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function Clone: Context; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function set_one_value(prop_name: CORBAString; value: CORBAString): LongWord; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function set_values(values: NVList): LongWord; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function get_values(start_scope: CORBAString; op_flags: LongWord; prop_name: CORBAString; out values: NVList): LongWord; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function delete_values(prop_name: CORBAString): LongWord; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function create_child(ctx_name: CORBAString; out child_ctx: Context): LongWord; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function SOM_destroy(flags: LongWord): LongWord; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultInit(var ctrl: Pointer); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDestruct(doFree: Byte; var ctrl: Pointer); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultCopyInit(var ctrl: Pointer; fromObj: Context); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultAssign(var ctrl: Pointer; fromObj: Context): Context; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultConstCopyInit(var ctrl: Pointer; fromObj: Context); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultVCopyInit(var ctrl: Pointer; fromObj: Context); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultConstVCopyInit(var ctrl: Pointer; fromObj: Context); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultConstAssign(var ctrl: Pointer; fromObj: Context): Context; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultVAssign(var ctrl: Pointer; fromObj: Context): Context; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultConstVAssign(var ctrl: Pointer; fromObj: Context): Context; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somInit; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somFree; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somUninit; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetClass: SOMClass; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetClassName: {dual_owned} CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetSize: LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somIsA(aClassObj: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somIsInstanceOf(aClassObj: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somRespondsTo(mId: somId): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDispatch(out retValue: Pointer; methodId: somId; ap: va_list): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somClassDispatch(clsObj: SOMClass; out retValue: Pointer; methodId: somId; ap: va_list): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somCastObj(cls: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somResetObj: CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somPrintSelf: Context; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDumpSelf(level: LongInt); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDumpSelfInt(level: LongInt); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}

    { Class object access and initialization }
    class function ClassObject: SOMClass; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF} // may be nil before class is created
    class function NewClass: SOMClass; // (not really new every time, but autocreated)

    { Upcasting }
    function As_Context: Context; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}

    { Downcasting }
    class function Supports(Instance: SOMObjectBase): Boolean; overload;
    class function Supports(Instance: SOMObjectBase; out Obj: Context): Boolean; overload;

  end;

  ConstantDef = class(SOMObjectBase)
  private
    function _get_type: TypeCode; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure _set_type(SOM_type: {caller_owns} TypeCode); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_value: any; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure _set_value(const value: {caller_owns} any); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_name: CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure _set_name(name: {caller_owns} CORBAString); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_id: CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure _set_id(id: {caller_owns} CORBAString); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_defined_in: CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure _set_defined_in(defined_in: {caller_owns} CORBAString); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somModifiers: _IDL_Sequence_somModifier; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure _set_somModifiers(const somModifiers: {caller_owns} _IDL_Sequence_somModifier); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
  public
    class function Create: ConstantDef; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function InitInstance(Instance: Pointer): ConstantDef; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function ClassType: SOMClass; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function ClassName: string; reintroduce;
    class function ClassNameIs(const Name: string): Boolean; reintroduce;
    class function InstanceSize: LongInt; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function InheritsFrom(AClass: SOMClass): Boolean; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function MethodAddress(const Name: string): Pointer; reintroduce;
    class function NewInstance: ConstantDef; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function Clone: ConstantDef; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function within: _IDL_Sequence_Container; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function describe: Contained_Description; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultInit(var ctrl: Pointer); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDestruct(doFree: Byte; var ctrl: Pointer); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultCopyInit(var ctrl: Pointer; fromObj: ConstantDef); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultAssign(var ctrl: Pointer; fromObj: ConstantDef): ConstantDef; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultConstCopyInit(var ctrl: Pointer; fromObj: ConstantDef); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultVCopyInit(var ctrl: Pointer; fromObj: ConstantDef); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultConstVCopyInit(var ctrl: Pointer; fromObj: ConstantDef); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultConstAssign(var ctrl: Pointer; fromObj: ConstantDef): ConstantDef; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultVAssign(var ctrl: Pointer; fromObj: ConstantDef): ConstantDef; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultConstVAssign(var ctrl: Pointer; fromObj: ConstantDef): ConstantDef; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somInit; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somFree; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somUninit; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetClass: SOMClass; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetClassName: {dual_owned} CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetSize: LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somIsA(aClassObj: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somIsInstanceOf(aClassObj: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somRespondsTo(mId: somId): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDispatch(out retValue: Pointer; methodId: somId; ap: va_list): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somClassDispatch(clsObj: SOMClass; out retValue: Pointer; methodId: somId; ap: va_list): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somCastObj(cls: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somResetObj: CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somPrintSelf: ConstantDef; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDumpSelf(level: LongInt); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDumpSelfInt(level: LongInt); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}

    { Class object access and initialization }
    class function ClassObject: SOMClass; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF} // may be nil before class is created
    class function NewClass: SOMClass; // (not really new every time, but autocreated)

    { Upcasting }
    function As_Contained: Contained; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function As_ConstantDef: ConstantDef; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}

    { Downcasting }
    class function Supports(Instance: SOMObjectBase): Boolean; overload;
    class function Supports(Instance: SOMObjectBase; out Obj: ConstantDef): Boolean; overload;

    property SOM_type: TypeCode read _get_type write _set_type;
    property value: any read _get_value write _set_value;
    property name: CORBAString read _get_name write _set_name;
    property id: CORBAString read _get_id write _set_id;
    property defined_in: CORBAString read _get_defined_in write _set_defined_in;
    property somModifiers: _IDL_Sequence_somModifier read _get_somModifiers write _set_somModifiers;
  end;

  P_IDL_ArrayOf_Contained = ^_IDL_ArrayOf_Contained;
  _IDL_Sequence_Contained = packed record
    _maximum: LongWord;
    _length: LongWord;
    _buffer: P_IDL_ArrayOf_Contained;
  end;
  P_IDL_ArrayOf_Container_ContainerDescription = ^_IDL_ArrayOf_Container_ContainerDescription;
  _IDL_Sequence_Container_ContainerDescription = packed record
    _maximum: LongWord;
    _length: LongWord;
    _buffer: P_IDL_ArrayOf_Container_ContainerDescription;
  end;
  Container = class(SOMObjectBase)
  public
    class function Create: Container; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function InitInstance(Instance: Pointer): Container; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function ClassType: SOMClass; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function ClassName: string; reintroduce;
    class function ClassNameIs(const Name: string): Boolean; reintroduce;
    class function InstanceSize: LongInt; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function InheritsFrom(AClass: SOMClass): Boolean; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function MethodAddress(const Name: string): Pointer; reintroduce;
    class function NewInstance: Container; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function Clone: Container; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function contents(limit_type: CORBAString; exclude_inherited: CORBABoolean): {caller_owns} _IDL_Sequence_Contained; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function lookup_name(search_name: {caller_owns} CORBAString; levels_to_search: LongInt; limit_type: CORBAString; exclude_inherited: CORBABoolean): {caller_owns} _IDL_Sequence_Contained; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function describe_contents(limit_type: CORBAString; exclude_inherited: CORBABoolean; max_returned_objs: LongInt): _IDL_Sequence_Container_ContainerDescription; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultInit(var ctrl: Pointer); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDestruct(doFree: Byte; var ctrl: Pointer); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultCopyInit(var ctrl: Pointer; fromObj: Container); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultAssign(var ctrl: Pointer; fromObj: Container): Container; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultConstCopyInit(var ctrl: Pointer; fromObj: Container); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultVCopyInit(var ctrl: Pointer; fromObj: Container); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultConstVCopyInit(var ctrl: Pointer; fromObj: Container); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultConstAssign(var ctrl: Pointer; fromObj: Container): Container; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultVAssign(var ctrl: Pointer; fromObj: Container): Container; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultConstVAssign(var ctrl: Pointer; fromObj: Container): Container; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somInit; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somFree; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somUninit; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetClass: SOMClass; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetClassName: {dual_owned} CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetSize: LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somIsA(aClassObj: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somIsInstanceOf(aClassObj: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somRespondsTo(mId: somId): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDispatch(out retValue: Pointer; methodId: somId; ap: va_list): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somClassDispatch(clsObj: SOMClass; out retValue: Pointer; methodId: somId; ap: va_list): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somCastObj(cls: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somResetObj: CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somPrintSelf: Container; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDumpSelf(level: LongInt); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDumpSelfInt(level: LongInt); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}

    { Class object access and initialization }
    class function ClassObject: SOMClass; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF} // may be nil before class is created
    class function NewClass: SOMClass; // (not really new every time, but autocreated)

    { Upcasting }
    function As_Container: Container; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}

    { Downcasting }
    class function Supports(Instance: SOMObjectBase): Boolean; overload;
    class function Supports(Instance: SOMObjectBase; out Obj: Container): Boolean; overload;

  end;

  SOMEEMan = class(SOMObjectBase)
  public
    class function Create: SOMEEMan; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function InitInstance(Instance: Pointer): SOMEEMan; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function ClassType: SOMMSingleInstance; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function ClassName: string; reintroduce;
    class function ClassNameIs(const Name: string): Boolean; reintroduce;
    class function InstanceSize: LongInt; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function InheritsFrom(AClass: SOMClass): Boolean; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function MethodAddress(const Name: string): Pointer; reintroduce;
    class function NewInstance: SOMEEMan; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function Clone: SOMEEMan; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure someGetEManSem; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure someReleaseEManSem; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure someChangeRegData(registrationId: LongInt; registerData: SOMEEMRegisterData); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure someProcessEvent(mask: LongWord); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure someProcessEvents; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure someQueueEvent(event: SOMEClientEvent); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function someRegister(registerData: SOMEEMRegisterData; targetObject: SOMObject; targetMethod: CORBAString; targetData: Pointer): LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function someRegisterEv(registerData: SOMEEMRegisterData; targetObject: SOMObject; var callbackEv: Environment; targetMethod: CORBAString; targetData: Pointer): LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function someRegisterProc(registerData: SOMEEMRegisterData; targetProcedure: PPointer; targetData: Pointer): LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure someShutdown; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure someUnRegister(registrationId: LongInt); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultInit(var ctrl: Pointer); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDestruct(doFree: Byte; var ctrl: Pointer); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultCopyInit(var ctrl: Pointer; fromObj: SOMEEMan); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultAssign(var ctrl: Pointer; fromObj: SOMEEMan): SOMEEMan; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultConstCopyInit(var ctrl: Pointer; fromObj: SOMEEMan); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultVCopyInit(var ctrl: Pointer; fromObj: SOMEEMan); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultConstVCopyInit(var ctrl: Pointer; fromObj: SOMEEMan); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultConstAssign(var ctrl: Pointer; fromObj: SOMEEMan): SOMEEMan; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultVAssign(var ctrl: Pointer; fromObj: SOMEEMan): SOMEEMan; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultConstVAssign(var ctrl: Pointer; fromObj: SOMEEMan): SOMEEMan; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somInit; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somFree; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somUninit; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetClass: SOMMSingleInstance; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetClassName: {dual_owned} CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetSize: LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somIsA(aClassObj: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somIsInstanceOf(aClassObj: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somRespondsTo(mId: somId): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDispatch(out retValue: Pointer; methodId: somId; ap: va_list): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somClassDispatch(clsObj: SOMClass; out retValue: Pointer; methodId: somId; ap: va_list): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somCastObj(cls: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somResetObj: CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somPrintSelf: SOMEEMan; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDumpSelf(level: LongInt); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDumpSelfInt(level: LongInt); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}

    { Class object access and initialization }
    class function ClassObject: SOMMSingleInstance; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF} // may be nil before class is created
    class function NewClass: SOMMSingleInstance; // (not really new every time, but autocreated)

    { Upcasting }
    function As_SOMEEMan: SOMEEMan; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}

    { Downcasting }
    class function Supports(Instance: SOMObjectBase): Boolean; overload;
    class function Supports(Instance: SOMObjectBase; out Obj: SOMEEMan): Boolean; overload;

  end;

  SOMEEMRegisterData = class(SOMObjectBase)
  public
    class function Create: SOMEEMRegisterData; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function InitInstance(Instance: Pointer): SOMEEMRegisterData; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function ClassType: SOMClass; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function ClassName: string; reintroduce;
    class function ClassNameIs(const Name: string): Boolean; reintroduce;
    class function InstanceSize: LongInt; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function InheritsFrom(AClass: SOMClass): Boolean; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function MethodAddress(const Name: string): Pointer; reintroduce;
    class function NewInstance: SOMEEMRegisterData; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function Clone: SOMEEMRegisterData; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure someClearRegData; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure someSetRegDataClientType(clientType: CORBAString); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure someSetRegDataEventMask(eventType: LongInt; ap: va_list); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure someSetRegDataSink(sink: LongInt); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure someSetRegDataSinkMask(sinkMask: LongWord); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure someSetRegDataTimerCount(count: LongInt); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure someSetRegDataTimerInterval(interval: LongInt); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultInit(var ctrl: Pointer); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDestruct(doFree: Byte; var ctrl: Pointer); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultCopyInit(var ctrl: Pointer; fromObj: SOMEEMRegisterData); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultAssign(var ctrl: Pointer; fromObj: SOMEEMRegisterData): SOMEEMRegisterData; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultConstCopyInit(var ctrl: Pointer; fromObj: SOMEEMRegisterData); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultVCopyInit(var ctrl: Pointer; fromObj: SOMEEMRegisterData); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultConstVCopyInit(var ctrl: Pointer; fromObj: SOMEEMRegisterData); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultConstAssign(var ctrl: Pointer; fromObj: SOMEEMRegisterData): SOMEEMRegisterData; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultVAssign(var ctrl: Pointer; fromObj: SOMEEMRegisterData): SOMEEMRegisterData; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultConstVAssign(var ctrl: Pointer; fromObj: SOMEEMRegisterData): SOMEEMRegisterData; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somInit; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somFree; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somUninit; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetClass: SOMClass; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetClassName: {dual_owned} CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetSize: LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somIsA(aClassObj: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somIsInstanceOf(aClassObj: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somRespondsTo(mId: somId): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDispatch(out retValue: Pointer; methodId: somId; ap: va_list): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somClassDispatch(clsObj: SOMClass; out retValue: Pointer; methodId: somId; ap: va_list): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somCastObj(cls: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somResetObj: CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somPrintSelf: SOMEEMRegisterData; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDumpSelf(level: LongInt); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDumpSelfInt(level: LongInt); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}

    { Class object access and initialization }
    class function ClassObject: SOMClass; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF} // may be nil before class is created
    class function NewClass: SOMClass; // (not really new every time, but autocreated)

    { Upcasting }
    function As_SOMEEMRegisterData: SOMEEMRegisterData; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}

    { Downcasting }
    class function Supports(Instance: SOMObjectBase): Boolean; overload;
    class function Supports(Instance: SOMObjectBase; out Obj: SOMEEMRegisterData): Boolean; overload;

  end;

  ExceptionDef = class(SOMObjectBase)
  private
    function _get_type: TypeCode; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure _set_type(SOM_type: {caller_owns} TypeCode); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_name: CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure _set_name(name: {caller_owns} CORBAString); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_id: CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure _set_id(id: {caller_owns} CORBAString); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_defined_in: CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure _set_defined_in(defined_in: {caller_owns} CORBAString); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somModifiers: _IDL_Sequence_somModifier; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure _set_somModifiers(const somModifiers: {caller_owns} _IDL_Sequence_somModifier); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
  public
    class function Create: ExceptionDef; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function InitInstance(Instance: Pointer): ExceptionDef; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function ClassType: SOMClass; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function ClassName: string; reintroduce;
    class function ClassNameIs(const Name: string): Boolean; reintroduce;
    class function InstanceSize: LongInt; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function InheritsFrom(AClass: SOMClass): Boolean; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function MethodAddress(const Name: string): Pointer; reintroduce;
    class function NewInstance: ExceptionDef; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function Clone: ExceptionDef; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function within: _IDL_Sequence_Container; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function describe: Contained_Description; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultInit(var ctrl: Pointer); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDestruct(doFree: Byte; var ctrl: Pointer); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultCopyInit(var ctrl: Pointer; fromObj: ExceptionDef); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultAssign(var ctrl: Pointer; fromObj: ExceptionDef): ExceptionDef; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultConstCopyInit(var ctrl: Pointer; fromObj: ExceptionDef); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultVCopyInit(var ctrl: Pointer; fromObj: ExceptionDef); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultConstVCopyInit(var ctrl: Pointer; fromObj: ExceptionDef); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultConstAssign(var ctrl: Pointer; fromObj: ExceptionDef): ExceptionDef; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultVAssign(var ctrl: Pointer; fromObj: ExceptionDef): ExceptionDef; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultConstVAssign(var ctrl: Pointer; fromObj: ExceptionDef): ExceptionDef; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somInit; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somFree; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somUninit; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetClass: SOMClass; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetClassName: {dual_owned} CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetSize: LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somIsA(aClassObj: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somIsInstanceOf(aClassObj: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somRespondsTo(mId: somId): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDispatch(out retValue: Pointer; methodId: somId; ap: va_list): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somClassDispatch(clsObj: SOMClass; out retValue: Pointer; methodId: somId; ap: va_list): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somCastObj(cls: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somResetObj: CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somPrintSelf: ExceptionDef; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDumpSelf(level: LongInt); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDumpSelfInt(level: LongInt); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}

    { Class object access and initialization }
    class function ClassObject: SOMClass; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF} // may be nil before class is created
    class function NewClass: SOMClass; // (not really new every time, but autocreated)

    { Upcasting }
    function As_Contained: Contained; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function As_ExceptionDef: ExceptionDef; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}

    { Downcasting }
    class function Supports(Instance: SOMObjectBase): Boolean; overload;
    class function Supports(Instance: SOMObjectBase; out Obj: ExceptionDef): Boolean; overload;

    property SOM_type: TypeCode read _get_type write _set_type;
    property name: CORBAString read _get_name write _set_name;
    property id: CORBAString read _get_id write _set_id;
    property defined_in: CORBAString read _get_defined_in write _set_defined_in;
    property somModifiers: _IDL_Sequence_somModifier read _get_somModifiers write _set_somModifiers;
  end;

  ImplementationDef = class(SOMObjectBase)
  private
    function _get_impl_id: CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure _set_impl_id(impl_id: CORBAString); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_impl_alias: CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure _set_impl_alias(impl_alias: CORBAString); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_impl_program: CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure _set_impl_program(impl_program: CORBAString); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_impl_flags: LongWord; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure _set_impl_flags(impl_flags: LongWord); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_impl_server_class: CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure _set_impl_server_class(impl_server_class: CORBAString); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_impl_refdata_file: CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure _set_impl_refdata_file(impl_refdata_file: CORBAString); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_impl_refdata_bkup: CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure _set_impl_refdata_bkup(impl_refdata_bkup: CORBAString); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_impl_hostname: CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure _set_impl_hostname(impl_hostname: CORBAString); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
  public
    class function Create: ImplementationDef; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function InitInstance(Instance: Pointer): ImplementationDef; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function ClassType: SOMClass; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function ClassName: string; reintroduce;
    class function ClassNameIs(const Name: string): Boolean; reintroduce;
    class function InstanceSize: LongInt; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function InheritsFrom(AClass: SOMClass): Boolean; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function MethodAddress(const Name: string): Pointer; reintroduce;
    class function NewInstance: ImplementationDef; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function Clone: ImplementationDef; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultInit(var ctrl: Pointer); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDestruct(doFree: Byte; var ctrl: Pointer); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultCopyInit(var ctrl: Pointer; fromObj: ImplementationDef); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultAssign(var ctrl: Pointer; fromObj: ImplementationDef): ImplementationDef; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultConstCopyInit(var ctrl: Pointer; fromObj: ImplementationDef); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultVCopyInit(var ctrl: Pointer; fromObj: ImplementationDef); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultConstVCopyInit(var ctrl: Pointer; fromObj: ImplementationDef); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultConstAssign(var ctrl: Pointer; fromObj: ImplementationDef): ImplementationDef; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultVAssign(var ctrl: Pointer; fromObj: ImplementationDef): ImplementationDef; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultConstVAssign(var ctrl: Pointer; fromObj: ImplementationDef): ImplementationDef; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somInit; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somFree; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somUninit; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetClass: SOMClass; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetClassName: {dual_owned} CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetSize: LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somIsA(aClassObj: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somIsInstanceOf(aClassObj: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somRespondsTo(mId: somId): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDispatch(out retValue: Pointer; methodId: somId; ap: va_list): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somClassDispatch(clsObj: SOMClass; out retValue: Pointer; methodId: somId; ap: va_list): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somCastObj(cls: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somResetObj: CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somPrintSelf: ImplementationDef; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDumpSelf(level: LongInt); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDumpSelfInt(level: LongInt); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}

    { Class object access and initialization }
    class function ClassObject: SOMClass; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF} // may be nil before class is created
    class function NewClass: SOMClass; // (not really new every time, but autocreated)

    { Upcasting }
    function As_ImplementationDef: ImplementationDef; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}

    { Downcasting }
    class function Supports(Instance: SOMObjectBase): Boolean; overload;
    class function Supports(Instance: SOMObjectBase; out Obj: ImplementationDef): Boolean; overload;

    property impl_id: CORBAString read _get_impl_id write _set_impl_id;
    property impl_alias: CORBAString read _get_impl_alias write _set_impl_alias;
    property impl_program: CORBAString read _get_impl_program write _set_impl_program;
    property impl_flags: LongWord read _get_impl_flags write _set_impl_flags;
    property impl_server_class: CORBAString read _get_impl_server_class write _set_impl_server_class;
    property impl_refdata_file: CORBAString read _get_impl_refdata_file write _set_impl_refdata_file;
    property impl_refdata_bkup: CORBAString read _get_impl_refdata_bkup write _set_impl_refdata_bkup;
    property impl_hostname: CORBAString read _get_impl_hostname write _set_impl_hostname;
  end;

  P_IDL_ArrayOf_ImplementationDef = ^_IDL_ArrayOf_ImplementationDef;
  _IDL_Sequence_ImplementationDef = packed record
    _maximum: LongWord;
    _length: LongWord;
    _buffer: P_IDL_ArrayOf_ImplementationDef;
  end;
  ImplRepository = class(SOMObjectBase)
  public
    class function Create: ImplRepository; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function InitInstance(Instance: Pointer): ImplRepository; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function ClassType: SOMMSingleInstance; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function ClassName: string; reintroduce;
    class function ClassNameIs(const Name: string): Boolean; reintroduce;
    class function InstanceSize: LongInt; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function InheritsFrom(AClass: SOMClass): Boolean; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function MethodAddress(const Name: string): Pointer; reintroduce;
    class function NewInstance: ImplRepository; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function Clone: ImplRepository; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function find_impldef(implid: CORBAString): ImplementationDef; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function find_impldef_by_alias(alias_name: CORBAString): ImplementationDef; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function find_all_impldefs(out outimpldefs: _IDL_Sequence_ImplementationDef): LongWord; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function find_impldef_by_class(classname: CORBAString): _IDL_Sequence_ImplementationDef; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure add_impldef(impldef: ImplementationDef); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure update_impldef(impldef: ImplementationDef); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure delete_impldef(implid: CORBAString); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure add_class_to_impldef(implid: CORBAString; classname: CORBAString); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure remove_class_from_impldef(implid: CORBAString; classname: CORBAString); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure remove_class_from_all(classname: CORBAString); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function find_classes_by_impldef(implid: CORBAString): _IDL_Sequence_CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultInit(var ctrl: Pointer); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDestruct(doFree: Byte; var ctrl: Pointer); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultCopyInit(var ctrl: Pointer; fromObj: ImplRepository); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultAssign(var ctrl: Pointer; fromObj: ImplRepository): ImplRepository; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultConstCopyInit(var ctrl: Pointer; fromObj: ImplRepository); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultVCopyInit(var ctrl: Pointer; fromObj: ImplRepository); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultConstVCopyInit(var ctrl: Pointer; fromObj: ImplRepository); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultConstAssign(var ctrl: Pointer; fromObj: ImplRepository): ImplRepository; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultVAssign(var ctrl: Pointer; fromObj: ImplRepository): ImplRepository; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultConstVAssign(var ctrl: Pointer; fromObj: ImplRepository): ImplRepository; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somInit; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somFree; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somUninit; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetClass: SOMMSingleInstance; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetClassName: {dual_owned} CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetSize: LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somIsA(aClassObj: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somIsInstanceOf(aClassObj: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somRespondsTo(mId: somId): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDispatch(out retValue: Pointer; methodId: somId; ap: va_list): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somClassDispatch(clsObj: SOMClass; out retValue: Pointer; methodId: somId; ap: va_list): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somCastObj(cls: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somResetObj: CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somPrintSelf: ImplRepository; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDumpSelf(level: LongInt); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDumpSelfInt(level: LongInt); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}

    { Class object access and initialization }
    class function ClassObject: SOMMSingleInstance; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF} // may be nil before class is created
    class function NewClass: SOMMSingleInstance; // (not really new every time, but autocreated)

    { Upcasting }
    function As_ImplRepository: ImplRepository; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}

    { Downcasting }
    class function Supports(Instance: SOMObjectBase): Boolean; overload;
    class function Supports(Instance: SOMObjectBase; out Obj: ImplRepository): Boolean; overload;

  end;

  InterfaceDef = class(SOMObjectBase)
  private
    function _get_base_interfaces: _IDL_Sequence_CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure _set_base_interfaces(const base_interfaces: {caller_owns} _IDL_Sequence_CORBAString); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_instanceData: TypeCode; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure _set_instanceData(instanceData: {caller_owns} TypeCode); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_name: CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure _set_name(name: {caller_owns} CORBAString); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_id: CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure _set_id(id: {caller_owns} CORBAString); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_defined_in: CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure _set_defined_in(defined_in: {caller_owns} CORBAString); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somModifiers: _IDL_Sequence_somModifier; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure _set_somModifiers(const somModifiers: {caller_owns} _IDL_Sequence_somModifier); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
  public
    class function Create: InterfaceDef; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function InitInstance(Instance: Pointer): InterfaceDef; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function ClassType: SOMClass; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function ClassName: string; reintroduce;
    class function ClassNameIs(const Name: string): Boolean; reintroduce;
    class function InstanceSize: LongInt; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function InheritsFrom(AClass: SOMClass): Boolean; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function MethodAddress(const Name: string): Pointer; reintroduce;
    class function NewInstance: InterfaceDef; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function Clone: InterfaceDef; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function describe_interface: InterfaceDef_FullInterfaceDescription; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function within: _IDL_Sequence_Container; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function describe: Contained_Description; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultInit(var ctrl: Pointer); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDestruct(doFree: Byte; var ctrl: Pointer); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultCopyInit(var ctrl: Pointer; fromObj: InterfaceDef); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultAssign(var ctrl: Pointer; fromObj: InterfaceDef): InterfaceDef; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultConstCopyInit(var ctrl: Pointer; fromObj: InterfaceDef); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultVCopyInit(var ctrl: Pointer; fromObj: InterfaceDef); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultConstVCopyInit(var ctrl: Pointer; fromObj: InterfaceDef); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultConstAssign(var ctrl: Pointer; fromObj: InterfaceDef): InterfaceDef; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultVAssign(var ctrl: Pointer; fromObj: InterfaceDef): InterfaceDef; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultConstVAssign(var ctrl: Pointer; fromObj: InterfaceDef): InterfaceDef; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somInit; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somFree; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somUninit; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetClass: SOMClass; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetClassName: {dual_owned} CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetSize: LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somIsA(aClassObj: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somIsInstanceOf(aClassObj: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somRespondsTo(mId: somId): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDispatch(out retValue: Pointer; methodId: somId; ap: va_list): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somClassDispatch(clsObj: SOMClass; out retValue: Pointer; methodId: somId; ap: va_list): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somCastObj(cls: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somResetObj: CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somPrintSelf: InterfaceDef; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDumpSelf(level: LongInt); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDumpSelfInt(level: LongInt); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function contents(limit_type: CORBAString; exclude_inherited: CORBABoolean): {caller_owns} _IDL_Sequence_Contained; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function lookup_name(search_name: {caller_owns} CORBAString; levels_to_search: LongInt; limit_type: CORBAString; exclude_inherited: CORBABoolean): {caller_owns} _IDL_Sequence_Contained; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function describe_contents(limit_type: CORBAString; exclude_inherited: CORBABoolean; max_returned_objs: LongInt): _IDL_Sequence_Container_ContainerDescription; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}

    { Class object access and initialization }
    class function ClassObject: SOMClass; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF} // may be nil before class is created
    class function NewClass: SOMClass; // (not really new every time, but autocreated)

    { Upcasting }
    function As_Contained: Contained; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function As_Container: Container; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function As_InterfaceDef: InterfaceDef; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}

    { Downcasting }
    class function Supports(Instance: SOMObjectBase): Boolean; overload;
    class function Supports(Instance: SOMObjectBase; out Obj: InterfaceDef): Boolean; overload;

    property base_interfaces: _IDL_Sequence_CORBAString read _get_base_interfaces write _set_base_interfaces;
    property instanceData: TypeCode read _get_instanceData write _set_instanceData;
    property name: CORBAString read _get_name write _set_name;
    property id: CORBAString read _get_id write _set_id;
    property defined_in: CORBAString read _get_defined_in write _set_defined_in;
    property somModifiers: _IDL_Sequence_somModifier read _get_somModifiers write _set_somModifiers;
  end;

  ModuleDef = class(SOMObjectBase)
  private
    function _get_name: CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure _set_name(name: {caller_owns} CORBAString); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_id: CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure _set_id(id: {caller_owns} CORBAString); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_defined_in: CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure _set_defined_in(defined_in: {caller_owns} CORBAString); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somModifiers: _IDL_Sequence_somModifier; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure _set_somModifiers(const somModifiers: {caller_owns} _IDL_Sequence_somModifier); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
  public
    class function Create: ModuleDef; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function InitInstance(Instance: Pointer): ModuleDef; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function ClassType: SOMClass; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function ClassName: string; reintroduce;
    class function ClassNameIs(const Name: string): Boolean; reintroduce;
    class function InstanceSize: LongInt; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function InheritsFrom(AClass: SOMClass): Boolean; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function MethodAddress(const Name: string): Pointer; reintroduce;
    class function NewInstance: ModuleDef; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function Clone: ModuleDef; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function within: _IDL_Sequence_Container; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function describe: Contained_Description; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultInit(var ctrl: Pointer); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDestruct(doFree: Byte; var ctrl: Pointer); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultCopyInit(var ctrl: Pointer; fromObj: ModuleDef); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultAssign(var ctrl: Pointer; fromObj: ModuleDef): ModuleDef; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultConstCopyInit(var ctrl: Pointer; fromObj: ModuleDef); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultVCopyInit(var ctrl: Pointer; fromObj: ModuleDef); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultConstVCopyInit(var ctrl: Pointer; fromObj: ModuleDef); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultConstAssign(var ctrl: Pointer; fromObj: ModuleDef): ModuleDef; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultVAssign(var ctrl: Pointer; fromObj: ModuleDef): ModuleDef; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultConstVAssign(var ctrl: Pointer; fromObj: ModuleDef): ModuleDef; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somInit; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somFree; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somUninit; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetClass: SOMClass; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetClassName: {dual_owned} CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetSize: LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somIsA(aClassObj: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somIsInstanceOf(aClassObj: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somRespondsTo(mId: somId): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDispatch(out retValue: Pointer; methodId: somId; ap: va_list): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somClassDispatch(clsObj: SOMClass; out retValue: Pointer; methodId: somId; ap: va_list): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somCastObj(cls: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somResetObj: CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somPrintSelf: ModuleDef; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDumpSelf(level: LongInt); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDumpSelfInt(level: LongInt); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function contents(limit_type: CORBAString; exclude_inherited: CORBABoolean): {caller_owns} _IDL_Sequence_Contained; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function lookup_name(search_name: {caller_owns} CORBAString; levels_to_search: LongInt; limit_type: CORBAString; exclude_inherited: CORBABoolean): {caller_owns} _IDL_Sequence_Contained; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function describe_contents(limit_type: CORBAString; exclude_inherited: CORBABoolean; max_returned_objs: LongInt): _IDL_Sequence_Container_ContainerDescription; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}

    { Class object access and initialization }
    class function ClassObject: SOMClass; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF} // may be nil before class is created
    class function NewClass: SOMClass; // (not really new every time, but autocreated)

    { Upcasting }
    function As_Contained: Contained; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function As_Container: Container; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function As_ModuleDef: ModuleDef; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}

    { Downcasting }
    class function Supports(Instance: SOMObjectBase): Boolean; overload;
    class function Supports(Instance: SOMObjectBase; out Obj: ModuleDef): Boolean; overload;

    property name: CORBAString read _get_name write _set_name;
    property id: CORBAString read _get_id write _set_id;
    property defined_in: CORBAString read _get_defined_in write _set_defined_in;
    property somModifiers: _IDL_Sequence_somModifier read _get_somModifiers write _set_somModifiers;
  end;

  NVList = class(SOMObjectBase)
  public
    class function Create: NVList; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function InitInstance(Instance: Pointer): NVList; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function ClassType: SOMClass; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function ClassName: string; reintroduce;
    class function ClassNameIs(const Name: string): Boolean; reintroduce;
    class function InstanceSize: LongInt; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function InheritsFrom(AClass: SOMClass): Boolean; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function MethodAddress(const Name: string): Pointer; reintroduce;
    class function NewInstance: NVList; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function Clone: NVList; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function add_item(item_name: CORBAString; item_type: TypeCode; value: Pointer; value_len: LongInt; item_flags: LongWord): LongWord; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function free: LongWord; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function free_memory: LongWord; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function get_count(out count: LongInt): LongWord; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function set_item(item_number: LongInt; item_name: CORBAString; item_type: TypeCode; value: Pointer; value_len: LongInt; item_flags: LongWord): LongWord; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function get_item(item_number: LongInt; out item_name: CORBAString; out item_type: TypeCode; out value: Pointer; out value_len: LongInt; out item_flags: LongWord): LongWord; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultInit(var ctrl: Pointer); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDestruct(doFree: Byte; var ctrl: Pointer); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultCopyInit(var ctrl: Pointer; fromObj: NVList); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultAssign(var ctrl: Pointer; fromObj: NVList): NVList; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultConstCopyInit(var ctrl: Pointer; fromObj: NVList); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultVCopyInit(var ctrl: Pointer; fromObj: NVList); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultConstVCopyInit(var ctrl: Pointer; fromObj: NVList); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultConstAssign(var ctrl: Pointer; fromObj: NVList): NVList; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultVAssign(var ctrl: Pointer; fromObj: NVList): NVList; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultConstVAssign(var ctrl: Pointer; fromObj: NVList): NVList; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somInit; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somFree; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somUninit; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetClass: SOMClass; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetClassName: {dual_owned} CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetSize: LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somIsA(aClassObj: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somIsInstanceOf(aClassObj: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somRespondsTo(mId: somId): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDispatch(out retValue: Pointer; methodId: somId; ap: va_list): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somClassDispatch(clsObj: SOMClass; out retValue: Pointer; methodId: somId; ap: va_list): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somCastObj(cls: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somResetObj: CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somPrintSelf: NVList; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDumpSelf(level: LongInt); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDumpSelfInt(level: LongInt); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}

    { Class object access and initialization }
    class function ClassObject: SOMClass; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF} // may be nil before class is created
    class function NewClass: SOMClass; // (not really new every time, but autocreated)

    { Upcasting }
    function As_NVList: NVList; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}

    { Downcasting }
    class function Supports(Instance: SOMObjectBase): Boolean; overload;
    class function Supports(Instance: SOMObjectBase; out Obj: NVList): Boolean; overload;

  end;

  ObjectMgr = class(SOMObjectBase)
  public
    class function Create: ObjectMgr; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function InitInstance(Instance: Pointer): ObjectMgr; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function ClassType: SOMMSingleInstance; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function ClassName: string; reintroduce;
    class function ClassNameIs(const Name: string): Boolean; reintroduce;
    class function InstanceSize: LongInt; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function InheritsFrom(AClass: SOMClass): Boolean; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function MethodAddress(const Name: string): Pointer; reintroduce;
    class function NewInstance: ObjectMgr; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function Clone: ObjectMgr; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somdNewObject(objclass: CORBAString; hints: CORBAString): SOMObject; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somdGetIdFromObject(obj: SOMObject): CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somdGetObjectFromId(id: CORBAString): SOMObject; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somdReleaseObject(obj: SOMObject); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somdDestroyObject(obj: SOMObject); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultInit(var ctrl: Pointer); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDestruct(doFree: Byte; var ctrl: Pointer); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultCopyInit(var ctrl: Pointer; fromObj: ObjectMgr); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultAssign(var ctrl: Pointer; fromObj: ObjectMgr): ObjectMgr; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultConstCopyInit(var ctrl: Pointer; fromObj: ObjectMgr); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultVCopyInit(var ctrl: Pointer; fromObj: ObjectMgr); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultConstVCopyInit(var ctrl: Pointer; fromObj: ObjectMgr); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultConstAssign(var ctrl: Pointer; fromObj: ObjectMgr): ObjectMgr; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultVAssign(var ctrl: Pointer; fromObj: ObjectMgr): ObjectMgr; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultConstVAssign(var ctrl: Pointer; fromObj: ObjectMgr): ObjectMgr; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somInit; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somFree; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somUninit; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetClass: SOMMSingleInstance; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetClassName: {dual_owned} CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetSize: LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somIsA(aClassObj: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somIsInstanceOf(aClassObj: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somRespondsTo(mId: somId): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDispatch(out retValue: Pointer; methodId: somId; ap: va_list): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somClassDispatch(clsObj: SOMClass; out retValue: Pointer; methodId: somId; ap: va_list): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somCastObj(cls: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somResetObj: CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somPrintSelf: ObjectMgr; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDumpSelf(level: LongInt); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDumpSelfInt(level: LongInt); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}

    { Class object access and initialization }
    class function ClassObject: SOMMSingleInstance; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF} // may be nil before class is created
    class function NewClass: SOMMSingleInstance; // (not really new every time, but autocreated)

    { Upcasting }
    function As_ObjectMgr: ObjectMgr; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}

    { Downcasting }
    class function Supports(Instance: SOMObjectBase): Boolean; overload;
    class function Supports(Instance: SOMObjectBase; out Obj: ObjectMgr): Boolean; overload;

  end;

  OperationDef = class(SOMObjectBase)
  private
    function _get_result: TypeCode; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure _set_result(SOM_result: TypeCode); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_mode: OperationDef_OperationMode; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure _set_mode(mode: OperationDef_OperationMode); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_contexts: _IDL_Sequence_CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure _set_contexts(const contexts: _IDL_Sequence_CORBAString); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_name: CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure _set_name(name: {caller_owns} CORBAString); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_id: CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure _set_id(id: {caller_owns} CORBAString); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_defined_in: CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure _set_defined_in(defined_in: {caller_owns} CORBAString); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somModifiers: _IDL_Sequence_somModifier; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure _set_somModifiers(const somModifiers: {caller_owns} _IDL_Sequence_somModifier); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
  public
    class function Create: OperationDef; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function InitInstance(Instance: Pointer): OperationDef; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function ClassType: SOMClass; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function ClassName: string; reintroduce;
    class function ClassNameIs(const Name: string): Boolean; reintroduce;
    class function InstanceSize: LongInt; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function InheritsFrom(AClass: SOMClass): Boolean; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function MethodAddress(const Name: string): Pointer; reintroduce;
    class function NewInstance: OperationDef; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function Clone: OperationDef; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function within: _IDL_Sequence_Container; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function describe: Contained_Description; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultInit(var ctrl: Pointer); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDestruct(doFree: Byte; var ctrl: Pointer); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultCopyInit(var ctrl: Pointer; fromObj: OperationDef); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultAssign(var ctrl: Pointer; fromObj: OperationDef): OperationDef; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultConstCopyInit(var ctrl: Pointer; fromObj: OperationDef); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultVCopyInit(var ctrl: Pointer; fromObj: OperationDef); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultConstVCopyInit(var ctrl: Pointer; fromObj: OperationDef); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultConstAssign(var ctrl: Pointer; fromObj: OperationDef): OperationDef; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultVAssign(var ctrl: Pointer; fromObj: OperationDef): OperationDef; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultConstVAssign(var ctrl: Pointer; fromObj: OperationDef): OperationDef; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somInit; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somFree; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somUninit; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetClass: SOMClass; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetClassName: {dual_owned} CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetSize: LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somIsA(aClassObj: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somIsInstanceOf(aClassObj: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somRespondsTo(mId: somId): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDispatch(out retValue: Pointer; methodId: somId; ap: va_list): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somClassDispatch(clsObj: SOMClass; out retValue: Pointer; methodId: somId; ap: va_list): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somCastObj(cls: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somResetObj: CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somPrintSelf: OperationDef; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDumpSelf(level: LongInt); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDumpSelfInt(level: LongInt); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function contents(limit_type: CORBAString; exclude_inherited: CORBABoolean): {caller_owns} _IDL_Sequence_Contained; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function lookup_name(search_name: {caller_owns} CORBAString; levels_to_search: LongInt; limit_type: CORBAString; exclude_inherited: CORBABoolean): {caller_owns} _IDL_Sequence_Contained; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function describe_contents(limit_type: CORBAString; exclude_inherited: CORBABoolean; max_returned_objs: LongInt): _IDL_Sequence_Container_ContainerDescription; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}

    { Class object access and initialization }
    class function ClassObject: SOMClass; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF} // may be nil before class is created
    class function NewClass: SOMClass; // (not really new every time, but autocreated)

    { Upcasting }
    function As_Contained: Contained; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function As_Container: Container; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function As_OperationDef: OperationDef; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}

    { Downcasting }
    class function Supports(Instance: SOMObjectBase): Boolean; overload;
    class function Supports(Instance: SOMObjectBase; out Obj: OperationDef): Boolean; overload;

    property SOM_result: TypeCode read _get_result write _set_result;
    property mode: OperationDef_OperationMode read _get_mode write _set_mode;
    property contexts: _IDL_Sequence_CORBAString read _get_contexts write _set_contexts;
    property name: CORBAString read _get_name write _set_name;
    property id: CORBAString read _get_id write _set_id;
    property defined_in: CORBAString read _get_defined_in write _set_defined_in;
    property somModifiers: _IDL_Sequence_somModifier read _get_somModifiers write _set_somModifiers;
  end;

  ORB = class(SOMObjectBase)
  public
    class function Create: ORB; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function InitInstance(Instance: Pointer): ORB; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function ClassType: SOMMSingleInstance; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function ClassName: string; reintroduce;
    class function ClassNameIs(const Name: string): Boolean; reintroduce;
    class function InstanceSize: LongInt; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function InheritsFrom(AClass: SOMClass): Boolean; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function MethodAddress(const Name: string): Pointer; reintroduce;
    class function NewInstance: ORB; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function Clone: ORB; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function object_to_string(obj: SOMDObject): CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function string_to_object(str: CORBAString): SOMDObject; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function create_list(count: LongInt; out new_list: NVList): LongWord; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function create_operation_list(oper: OperationDef; out new_list: NVList): LongWord; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function get_default_context(out ctx: Context): LongWord; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultInit(var ctrl: Pointer); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDestruct(doFree: Byte; var ctrl: Pointer); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultCopyInit(var ctrl: Pointer; fromObj: ORB); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultAssign(var ctrl: Pointer; fromObj: ORB): ORB; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultConstCopyInit(var ctrl: Pointer; fromObj: ORB); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultVCopyInit(var ctrl: Pointer; fromObj: ORB); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultConstVCopyInit(var ctrl: Pointer; fromObj: ORB); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultConstAssign(var ctrl: Pointer; fromObj: ORB): ORB; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultVAssign(var ctrl: Pointer; fromObj: ORB): ORB; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultConstVAssign(var ctrl: Pointer; fromObj: ORB): ORB; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somInit; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somFree; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somUninit; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetClass: SOMMSingleInstance; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetClassName: {dual_owned} CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetSize: LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somIsA(aClassObj: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somIsInstanceOf(aClassObj: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somRespondsTo(mId: somId): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDispatch(out retValue: Pointer; methodId: somId; ap: va_list): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somClassDispatch(clsObj: SOMClass; out retValue: Pointer; methodId: somId; ap: va_list): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somCastObj(cls: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somResetObj: CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somPrintSelf: ORB; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDumpSelf(level: LongInt); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDumpSelfInt(level: LongInt); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}

    { Class object access and initialization }
    class function ClassObject: SOMMSingleInstance; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF} // may be nil before class is created
    class function NewClass: SOMMSingleInstance; // (not really new every time, but autocreated)

    { Upcasting }
    function As_ORB: ORB; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}

    { Downcasting }
    class function Supports(Instance: SOMObjectBase): Boolean; overload;
    class function Supports(Instance: SOMObjectBase; out Obj: ORB): Boolean; overload;

  end;

  ParameterDef = class(SOMObjectBase)
  private
    function _get_type: TypeCode; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure _set_type(SOM_type: {caller_owns} TypeCode); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_mode: ParameterDef_ParameterMode; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure _set_mode(mode: ParameterDef_ParameterMode); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_name: CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure _set_name(name: {caller_owns} CORBAString); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_id: CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure _set_id(id: {caller_owns} CORBAString); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_defined_in: CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure _set_defined_in(defined_in: {caller_owns} CORBAString); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somModifiers: _IDL_Sequence_somModifier; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure _set_somModifiers(const somModifiers: {caller_owns} _IDL_Sequence_somModifier); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
  public
    class function Create: ParameterDef; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function InitInstance(Instance: Pointer): ParameterDef; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function ClassType: SOMClass; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function ClassName: string; reintroduce;
    class function ClassNameIs(const Name: string): Boolean; reintroduce;
    class function InstanceSize: LongInt; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function InheritsFrom(AClass: SOMClass): Boolean; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function MethodAddress(const Name: string): Pointer; reintroduce;
    class function NewInstance: ParameterDef; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function Clone: ParameterDef; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function within: _IDL_Sequence_Container; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function describe: Contained_Description; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultInit(var ctrl: Pointer); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDestruct(doFree: Byte; var ctrl: Pointer); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultCopyInit(var ctrl: Pointer; fromObj: ParameterDef); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultAssign(var ctrl: Pointer; fromObj: ParameterDef): ParameterDef; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultConstCopyInit(var ctrl: Pointer; fromObj: ParameterDef); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultVCopyInit(var ctrl: Pointer; fromObj: ParameterDef); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultConstVCopyInit(var ctrl: Pointer; fromObj: ParameterDef); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultConstAssign(var ctrl: Pointer; fromObj: ParameterDef): ParameterDef; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultVAssign(var ctrl: Pointer; fromObj: ParameterDef): ParameterDef; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultConstVAssign(var ctrl: Pointer; fromObj: ParameterDef): ParameterDef; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somInit; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somFree; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somUninit; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetClass: SOMClass; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetClassName: {dual_owned} CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetSize: LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somIsA(aClassObj: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somIsInstanceOf(aClassObj: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somRespondsTo(mId: somId): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDispatch(out retValue: Pointer; methodId: somId; ap: va_list): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somClassDispatch(clsObj: SOMClass; out retValue: Pointer; methodId: somId; ap: va_list): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somCastObj(cls: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somResetObj: CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somPrintSelf: ParameterDef; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDumpSelf(level: LongInt); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDumpSelfInt(level: LongInt); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}

    { Class object access and initialization }
    class function ClassObject: SOMClass; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF} // may be nil before class is created
    class function NewClass: SOMClass; // (not really new every time, but autocreated)

    { Upcasting }
    function As_Contained: Contained; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function As_ParameterDef: ParameterDef; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}

    { Downcasting }
    class function Supports(Instance: SOMObjectBase): Boolean; overload;
    class function Supports(Instance: SOMObjectBase; out Obj: ParameterDef): Boolean; overload;

    property SOM_type: TypeCode read _get_type write _set_type;
    property mode: ParameterDef_ParameterMode read _get_mode write _set_mode;
    property name: CORBAString read _get_name write _set_name;
    property id: CORBAString read _get_id write _set_id;
    property defined_in: CORBAString read _get_defined_in write _set_defined_in;
    property somModifiers: _IDL_Sequence_somModifier read _get_somModifiers write _set_somModifiers;
  end;

  Principal = class(SOMObjectBase)
  private
    function _get_userName: CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure _set_userName(userName: CORBAString); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_hostName: CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure _set_hostName(hostName: CORBAString); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
  public
    class function Create: Principal; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function InitInstance(Instance: Pointer): Principal; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function ClassType: SOMClass; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function ClassName: string; reintroduce;
    class function ClassNameIs(const Name: string): Boolean; reintroduce;
    class function InstanceSize: LongInt; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function InheritsFrom(AClass: SOMClass): Boolean; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function MethodAddress(const Name: string): Pointer; reintroduce;
    class function NewInstance: Principal; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function Clone: Principal; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultInit(var ctrl: Pointer); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDestruct(doFree: Byte; var ctrl: Pointer); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultCopyInit(var ctrl: Pointer; fromObj: Principal); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultAssign(var ctrl: Pointer; fromObj: Principal): Principal; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultConstCopyInit(var ctrl: Pointer; fromObj: Principal); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultVCopyInit(var ctrl: Pointer; fromObj: Principal); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultConstVCopyInit(var ctrl: Pointer; fromObj: Principal); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultConstAssign(var ctrl: Pointer; fromObj: Principal): Principal; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultVAssign(var ctrl: Pointer; fromObj: Principal): Principal; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultConstVAssign(var ctrl: Pointer; fromObj: Principal): Principal; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somInit; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somFree; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somUninit; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetClass: SOMClass; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetClassName: {dual_owned} CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetSize: LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somIsA(aClassObj: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somIsInstanceOf(aClassObj: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somRespondsTo(mId: somId): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDispatch(out retValue: Pointer; methodId: somId; ap: va_list): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somClassDispatch(clsObj: SOMClass; out retValue: Pointer; methodId: somId; ap: va_list): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somCastObj(cls: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somResetObj: CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somPrintSelf: Principal; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDumpSelf(level: LongInt); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDumpSelfInt(level: LongInt); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}

    { Class object access and initialization }
    class function ClassObject: SOMClass; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF} // may be nil before class is created
    class function NewClass: SOMClass; // (not really new every time, but autocreated)

    { Upcasting }
    function As_Principal: Principal; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}

    { Downcasting }
    class function Supports(Instance: SOMObjectBase): Boolean; overload;
    class function Supports(Instance: SOMObjectBase; out Obj: Principal): Boolean; overload;

    property userName: CORBAString read _get_userName write _set_userName;
    property hostName: CORBAString read _get_hostName write _set_hostName;
  end;

  Repository = class(SOMObjectBase)
  public
    class function Create: Repository; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function InitInstance(Instance: Pointer): Repository; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function ClassType: SOMClass; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function ClassName: string; reintroduce;
    class function ClassNameIs(const Name: string): Boolean; reintroduce;
    class function InstanceSize: LongInt; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function InheritsFrom(AClass: SOMClass): Boolean; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function MethodAddress(const Name: string): Pointer; reintroduce;
    class function NewInstance: Repository; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function Clone: Repository; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function lookup_id(search_id: CORBAString): Contained; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function lookup_modifier(name: CORBAString; modifier: CORBAString): CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure release_cache; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function contents(limit_type: CORBAString; exclude_inherited: CORBABoolean): {caller_owns} _IDL_Sequence_Contained; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function lookup_name(search_name: {caller_owns} CORBAString; levels_to_search: LongInt; limit_type: CORBAString; exclude_inherited: CORBABoolean): {caller_owns} _IDL_Sequence_Contained; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function describe_contents(limit_type: CORBAString; exclude_inherited: CORBABoolean; max_returned_objs: LongInt): _IDL_Sequence_Container_ContainerDescription; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultInit(var ctrl: Pointer); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDestruct(doFree: Byte; var ctrl: Pointer); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultCopyInit(var ctrl: Pointer; fromObj: Repository); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultAssign(var ctrl: Pointer; fromObj: Repository): Repository; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultConstCopyInit(var ctrl: Pointer; fromObj: Repository); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultVCopyInit(var ctrl: Pointer; fromObj: Repository); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultConstVCopyInit(var ctrl: Pointer; fromObj: Repository); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultConstAssign(var ctrl: Pointer; fromObj: Repository): Repository; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultVAssign(var ctrl: Pointer; fromObj: Repository): Repository; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultConstVAssign(var ctrl: Pointer; fromObj: Repository): Repository; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somInit; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somFree; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somUninit; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetClass: SOMClass; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetClassName: {dual_owned} CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetSize: LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somIsA(aClassObj: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somIsInstanceOf(aClassObj: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somRespondsTo(mId: somId): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDispatch(out retValue: Pointer; methodId: somId; ap: va_list): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somClassDispatch(clsObj: SOMClass; out retValue: Pointer; methodId: somId; ap: va_list): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somCastObj(cls: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somResetObj: CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somPrintSelf: Repository; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDumpSelf(level: LongInt); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDumpSelfInt(level: LongInt); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}

    { Class object access and initialization }
    class function ClassObject: SOMClass; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF} // may be nil before class is created
    class function NewClass: SOMClass; // (not really new every time, but autocreated)

    { Upcasting }
    function As_Container: Container; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function As_Repository: Repository; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}

    { Downcasting }
    class function Supports(Instance: SOMObjectBase): Boolean; overload;
    class function Supports(Instance: SOMObjectBase; out Obj: Repository): Boolean; overload;

  end;

  Request = class(SOMObjectBase)
  public
    class function Create: Request; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function InitInstance(Instance: Pointer): Request; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function ClassType: SOMClass; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function ClassName: string; reintroduce;
    class function ClassNameIs(const Name: string): Boolean; reintroduce;
    class function InstanceSize: LongInt; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function InheritsFrom(AClass: SOMClass): Boolean; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function MethodAddress(const Name: string): Pointer; reintroduce;
    class function NewInstance: Request; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function Clone: Request; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function add_arg(name: CORBAString; arg_type: TypeCode; value: Pointer; len: LongInt; arg_flags: LongWord): LongWord; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function invoke(invoke_flags: LongWord): LongWord; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function send(invoke_flags: LongWord): LongWord; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function get_response(response_flags: LongWord): LongWord; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function SOM_destroy: LongWord; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultInit(var ctrl: Pointer); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDestruct(doFree: Byte; var ctrl: Pointer); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultCopyInit(var ctrl: Pointer; fromObj: Request); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultAssign(var ctrl: Pointer; fromObj: Request): Request; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultConstCopyInit(var ctrl: Pointer; fromObj: Request); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultVCopyInit(var ctrl: Pointer; fromObj: Request); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultConstVCopyInit(var ctrl: Pointer; fromObj: Request); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultConstAssign(var ctrl: Pointer; fromObj: Request): Request; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultVAssign(var ctrl: Pointer; fromObj: Request): Request; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultConstVAssign(var ctrl: Pointer; fromObj: Request): Request; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somInit; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somFree; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somUninit; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetClass: SOMClass; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetClassName: {dual_owned} CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetSize: LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somIsA(aClassObj: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somIsInstanceOf(aClassObj: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somRespondsTo(mId: somId): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDispatch(out retValue: Pointer; methodId: somId; ap: va_list): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somClassDispatch(clsObj: SOMClass; out retValue: Pointer; methodId: somId; ap: va_list): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somCastObj(cls: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somResetObj: CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somPrintSelf: Request; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDumpSelf(level: LongInt); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDumpSelfInt(level: LongInt); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}

    { Class object access and initialization }
    class function ClassObject: SOMClass; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF} // may be nil before class is created
    class function NewClass: SOMClass; // (not really new every time, but autocreated)

    { Upcasting }
    function As_Request: Request; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}

    { Downcasting }
    class function Supports(Instance: SOMObjectBase): Boolean; overload;
    class function Supports(Instance: SOMObjectBase; out Obj: Request): Boolean; overload;

  end;

  SOMTEntryC = class(SOMObjectBase)
  private
    function _get_somtEntryName: CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure _set_somtEntryName(somtEntryName: CORBAString); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtElementType: LongWord; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure _set_somtElementType(somtElementType: LongWord); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtElementTypeName: CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtEntryComment: CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtSourceLineNumber: LongWord; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtTypeCode: TypeCode; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtIsReference: CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtIDLScopedName: CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtCScopedName: CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
  public
    class function Create: SOMTEntryC; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function InitInstance(Instance: Pointer): SOMTEntryC; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function ClassType: SOMClass; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function ClassName: string; reintroduce;
    class function ClassNameIs(const Name: string): Boolean; reintroduce;
    class function InstanceSize: LongInt; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function InheritsFrom(AClass: SOMClass): Boolean; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function MethodAddress(const Name: string): Pointer; reintroduce;
    class function NewInstance: SOMTEntryC; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function Clone: SOMTEntryC; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtGetModifierValue(modifierName: CORBAString): CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtGetFirstModifier(var modifierName: CORBAString; var modifierValue: CORBAString): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtGetNextModifier(var modifierName: CORBAString; var modifierValue: CORBAString): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtFormatModifier(buffer: CORBAString; name: CORBAString; value: CORBAString): LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtGetModifierList(buffer: CORBAString): LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtSetSymbolsOnEntry(emitter: SOMTEmitC; prefix: CORBAString): LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somtSetEntryStruct(var es: Pointer); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultInit(var ctrl: Pointer); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDestruct(doFree: Byte; var ctrl: Pointer); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultCopyInit(var ctrl: Pointer; fromObj: SOMTEntryC); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultAssign(var ctrl: Pointer; fromObj: SOMTEntryC): SOMTEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultConstCopyInit(var ctrl: Pointer; fromObj: SOMTEntryC); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultVCopyInit(var ctrl: Pointer; fromObj: SOMTEntryC); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultConstVCopyInit(var ctrl: Pointer; fromObj: SOMTEntryC); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultConstAssign(var ctrl: Pointer; fromObj: SOMTEntryC): SOMTEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultVAssign(var ctrl: Pointer; fromObj: SOMTEntryC): SOMTEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultConstVAssign(var ctrl: Pointer; fromObj: SOMTEntryC): SOMTEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somInit; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somFree; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somUninit; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetClass: SOMClass; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetClassName: {dual_owned} CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetSize: LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somIsA(aClassObj: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somIsInstanceOf(aClassObj: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somRespondsTo(mId: somId): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDispatch(out retValue: Pointer; methodId: somId; ap: va_list): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somClassDispatch(clsObj: SOMClass; out retValue: Pointer; methodId: somId; ap: va_list): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somCastObj(cls: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somResetObj: CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somPrintSelf: SOMTEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDumpSelf(level: LongInt); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDumpSelfInt(level: LongInt); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}

    { Class object access and initialization }
    class function ClassObject: SOMClass; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF} // may be nil before class is created
    class function NewClass: SOMClass; // (not really new every time, but autocreated)

    { Upcasting }
    function As_SOMTEntryC: SOMTEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}

    { Downcasting }
    class function Supports(Instance: SOMObjectBase): Boolean; overload;
    class function Supports(Instance: SOMObjectBase; out Obj: SOMTEntryC): Boolean; overload;

    property somtEntryName: CORBAString read _get_somtEntryName write _set_somtEntryName;
    property somtElementType: LongWord read _get_somtElementType write _set_somtElementType;
    property somtElementTypeName: CORBAString read _get_somtElementTypeName;
    property somtEntryComment: CORBAString read _get_somtEntryComment;
    property somtSourceLineNumber: LongWord read _get_somtSourceLineNumber;
    property somtTypeCode: TypeCode read _get_somtTypeCode;
    property somtIsReference: CORBABoolean read _get_somtIsReference;
    property somtIDLScopedName: CORBAString read _get_somtIDLScopedName;
    property somtCScopedName: CORBAString read _get_somtCScopedName;
  end;

  SOMTAttributeEntryC = class(SOMObjectBase)
  private
    function _get_somtIsReadonly: CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtAttribType: SOMTEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtEntryName: CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure _set_somtEntryName(somtEntryName: CORBAString); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtElementType: LongWord; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure _set_somtElementType(somtElementType: LongWord); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtElementTypeName: CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtEntryComment: CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtSourceLineNumber: LongWord; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtTypeCode: TypeCode; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtIsReference: CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtIDLScopedName: CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtCScopedName: CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
  public
    class function Create: SOMTAttributeEntryC; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function InitInstance(Instance: Pointer): SOMTAttributeEntryC; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function ClassType: SOMClass; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function ClassName: string; reintroduce;
    class function ClassNameIs(const Name: string): Boolean; reintroduce;
    class function InstanceSize: LongInt; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function InheritsFrom(AClass: SOMClass): Boolean; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function MethodAddress(const Name: string): Pointer; reintroduce;
    class function NewInstance: SOMTAttributeEntryC; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function Clone: SOMTAttributeEntryC; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtGetFirstAttributeDeclarator: SOMTDataEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtGetNextAttributeDeclarator: SOMTDataEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtGetFirstGetMethod: SOMTMethodEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtGetNextGetMethod: SOMTMethodEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtGetFirstSetMethod: SOMTMethodEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtGetNextSetMethod: SOMTMethodEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtGetModifierValue(modifierName: CORBAString): CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtGetFirstModifier(var modifierName: CORBAString; var modifierValue: CORBAString): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtGetNextModifier(var modifierName: CORBAString; var modifierValue: CORBAString): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtFormatModifier(buffer: CORBAString; name: CORBAString; value: CORBAString): LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtGetModifierList(buffer: CORBAString): LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtSetSymbolsOnEntry(emitter: SOMTEmitC; prefix: CORBAString): LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somtSetEntryStruct(var es: Pointer); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultInit(var ctrl: Pointer); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDestruct(doFree: Byte; var ctrl: Pointer); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultCopyInit(var ctrl: Pointer; fromObj: SOMTAttributeEntryC); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultAssign(var ctrl: Pointer; fromObj: SOMTAttributeEntryC): SOMTAttributeEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultConstCopyInit(var ctrl: Pointer; fromObj: SOMTAttributeEntryC); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultVCopyInit(var ctrl: Pointer; fromObj: SOMTAttributeEntryC); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultConstVCopyInit(var ctrl: Pointer; fromObj: SOMTAttributeEntryC); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultConstAssign(var ctrl: Pointer; fromObj: SOMTAttributeEntryC): SOMTAttributeEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultVAssign(var ctrl: Pointer; fromObj: SOMTAttributeEntryC): SOMTAttributeEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultConstVAssign(var ctrl: Pointer; fromObj: SOMTAttributeEntryC): SOMTAttributeEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somInit; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somFree; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somUninit; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetClass: SOMClass; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetClassName: {dual_owned} CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetSize: LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somIsA(aClassObj: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somIsInstanceOf(aClassObj: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somRespondsTo(mId: somId): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDispatch(out retValue: Pointer; methodId: somId; ap: va_list): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somClassDispatch(clsObj: SOMClass; out retValue: Pointer; methodId: somId; ap: va_list): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somCastObj(cls: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somResetObj: CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somPrintSelf: SOMTAttributeEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDumpSelf(level: LongInt); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDumpSelfInt(level: LongInt); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}

    { Class object access and initialization }
    class function ClassObject: SOMClass; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF} // may be nil before class is created
    class function NewClass: SOMClass; // (not really new every time, but autocreated)

    { Upcasting }
    function As_SOMTEntryC: SOMTEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function As_SOMTAttributeEntryC: SOMTAttributeEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}

    { Downcasting }
    class function Supports(Instance: SOMObjectBase): Boolean; overload;
    class function Supports(Instance: SOMObjectBase; out Obj: SOMTAttributeEntryC): Boolean; overload;

    property somtIsReadonly: CORBABoolean read _get_somtIsReadonly;
    property somtAttribType: SOMTEntryC read _get_somtAttribType;
    property somtEntryName: CORBAString read _get_somtEntryName write _set_somtEntryName;
    property somtElementType: LongWord read _get_somtElementType write _set_somtElementType;
    property somtElementTypeName: CORBAString read _get_somtElementTypeName;
    property somtEntryComment: CORBAString read _get_somtEntryComment;
    property somtSourceLineNumber: LongWord read _get_somtSourceLineNumber;
    property somtTypeCode: TypeCode read _get_somtTypeCode;
    property somtIsReference: CORBABoolean read _get_somtIsReference;
    property somtIDLScopedName: CORBAString read _get_somtIDLScopedName;
    property somtCScopedName: CORBAString read _get_somtCScopedName;
  end;

  SOMTBaseClassEntryC = class(SOMObjectBase)
  private
    function _get_somtBaseClassDef: SOMTClassEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtEntryName: CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure _set_somtEntryName(somtEntryName: CORBAString); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtElementType: LongWord; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure _set_somtElementType(somtElementType: LongWord); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtElementTypeName: CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtEntryComment: CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtSourceLineNumber: LongWord; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtTypeCode: TypeCode; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtIsReference: CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtIDLScopedName: CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtCScopedName: CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
  public
    class function Create: SOMTBaseClassEntryC; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function InitInstance(Instance: Pointer): SOMTBaseClassEntryC; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function ClassType: SOMClass; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function ClassName: string; reintroduce;
    class function ClassNameIs(const Name: string): Boolean; reintroduce;
    class function InstanceSize: LongInt; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function InheritsFrom(AClass: SOMClass): Boolean; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function MethodAddress(const Name: string): Pointer; reintroduce;
    class function NewInstance: SOMTBaseClassEntryC; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function Clone: SOMTBaseClassEntryC; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtGetModifierValue(modifierName: CORBAString): CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtGetFirstModifier(var modifierName: CORBAString; var modifierValue: CORBAString): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtGetNextModifier(var modifierName: CORBAString; var modifierValue: CORBAString): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtFormatModifier(buffer: CORBAString; name: CORBAString; value: CORBAString): LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtGetModifierList(buffer: CORBAString): LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtSetSymbolsOnEntry(emitter: SOMTEmitC; prefix: CORBAString): LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somtSetEntryStruct(var es: Pointer); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultInit(var ctrl: Pointer); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDestruct(doFree: Byte; var ctrl: Pointer); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultCopyInit(var ctrl: Pointer; fromObj: SOMTBaseClassEntryC); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultAssign(var ctrl: Pointer; fromObj: SOMTBaseClassEntryC): SOMTBaseClassEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultConstCopyInit(var ctrl: Pointer; fromObj: SOMTBaseClassEntryC); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultVCopyInit(var ctrl: Pointer; fromObj: SOMTBaseClassEntryC); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultConstVCopyInit(var ctrl: Pointer; fromObj: SOMTBaseClassEntryC); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultConstAssign(var ctrl: Pointer; fromObj: SOMTBaseClassEntryC): SOMTBaseClassEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultVAssign(var ctrl: Pointer; fromObj: SOMTBaseClassEntryC): SOMTBaseClassEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultConstVAssign(var ctrl: Pointer; fromObj: SOMTBaseClassEntryC): SOMTBaseClassEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somInit; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somFree; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somUninit; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetClass: SOMClass; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetClassName: {dual_owned} CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetSize: LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somIsA(aClassObj: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somIsInstanceOf(aClassObj: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somRespondsTo(mId: somId): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDispatch(out retValue: Pointer; methodId: somId; ap: va_list): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somClassDispatch(clsObj: SOMClass; out retValue: Pointer; methodId: somId; ap: va_list): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somCastObj(cls: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somResetObj: CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somPrintSelf: SOMTBaseClassEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDumpSelf(level: LongInt); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDumpSelfInt(level: LongInt); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}

    { Class object access and initialization }
    class function ClassObject: SOMClass; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF} // may be nil before class is created
    class function NewClass: SOMClass; // (not really new every time, but autocreated)

    { Upcasting }
    function As_SOMTEntryC: SOMTEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function As_SOMTBaseClassEntryC: SOMTBaseClassEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}

    { Downcasting }
    class function Supports(Instance: SOMObjectBase): Boolean; overload;
    class function Supports(Instance: SOMObjectBase; out Obj: SOMTBaseClassEntryC): Boolean; overload;

    property somtBaseClassDef: SOMTClassEntryC read _get_somtBaseClassDef;
    property somtEntryName: CORBAString read _get_somtEntryName write _set_somtEntryName;
    property somtElementType: LongWord read _get_somtElementType write _set_somtElementType;
    property somtElementTypeName: CORBAString read _get_somtElementTypeName;
    property somtEntryComment: CORBAString read _get_somtEntryComment;
    property somtSourceLineNumber: LongWord read _get_somtSourceLineNumber;
    property somtTypeCode: TypeCode read _get_somtTypeCode;
    property somtIsReference: CORBABoolean read _get_somtIsReference;
    property somtIDLScopedName: CORBAString read _get_somtIDLScopedName;
    property somtCScopedName: CORBAString read _get_somtCScopedName;
  end;

  SOMTClassEntryC = class(SOMObjectBase)
  private
    function _get_somtSourceFileName: CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtMetaClassEntry: SOMTMetaClassEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtClassModule: SOMTModuleEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtNewMethodCount: LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtLocalInclude: CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtPrivateMethodCount: LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtStaticMethodCount: LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtOverrideMethodCount: LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtProcMethodCount: LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtVAMethodCount: LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtBaseCount: LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtExternalDataCount: LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtPublicDataCount: LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtPrivateDataCount: LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtMetaclassFor: SOMTClassEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtForwardRef: CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtEntryName: CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure _set_somtEntryName(somtEntryName: CORBAString); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtElementType: LongWord; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure _set_somtElementType(somtElementType: LongWord); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtElementTypeName: CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtEntryComment: CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtSourceLineNumber: LongWord; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtTypeCode: TypeCode; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtIsReference: CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtIDLScopedName: CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtCScopedName: CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
  public
    class function Create: SOMTClassEntryC; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function InitInstance(Instance: Pointer): SOMTClassEntryC; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function ClassType: SOMClass; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function ClassName: string; reintroduce;
    class function ClassNameIs(const Name: string): Boolean; reintroduce;
    class function InstanceSize: LongInt; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function InheritsFrom(AClass: SOMClass): Boolean; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function MethodAddress(const Name: string): Pointer; reintroduce;
    class function NewInstance: SOMTClassEntryC; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function Clone: SOMTClassEntryC; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtGetFirstBaseClass: SOMTBaseClassEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtGetNextBaseClass: SOMTBaseClassEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtGetFirstReleaseName: CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtGetNextReleaseName: CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtGetReleaseNameList(buffer: CORBAString): LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtGetFirstPassthru: SOMTPassthruEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtGetNextPassthru: SOMTPassthruEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtGetFirstData: SOMTDataEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtGetNextData: SOMTDataEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtGetFirstStaticData: SOMTDataEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtGetNextStaticData: SOMTDataEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtGetFirstMethod: SOMTMethodEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtGetNextMethod: SOMTMethodEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtGetFirstInheritedMethod: SOMTMethodEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtGetNextInheritedMethod: SOMTMethodEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtGetFirstAttribute: SOMTAttributeEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtGetNextAttribute: SOMTAttributeEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtGetFirstStruct: SOMTStructEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtGetNextStruct: SOMTStructEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtGetFirstTypedef: SOMTTypedefEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtGetNextTypedef: SOMTTypedefEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtGetFirstUnion: SOMTUnionEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtGetNextUnion: SOMTUnionEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtGetFirstEnum: SOMTEnumEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtGetNextEnum: SOMTEnumEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtGetFirstConstant: SOMTConstEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtGetNextConstant: SOMTConstEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtGetFirstSequence: SOMTSequenceEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtGetNextSequence: SOMTSequenceEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtGetFirstPubdef: SOMTEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtGetNextPubdef: SOMTEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtFilterNew(entry: SOMTMethodEntryC): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtFilterOverridden(entry: SOMTMethodEntryC): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtFilterPrivOrPub(entry: SOMTCommonEntryC): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtGetModifierValue(modifierName: CORBAString): CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtGetFirstModifier(var modifierName: CORBAString; var modifierValue: CORBAString): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtGetNextModifier(var modifierName: CORBAString; var modifierValue: CORBAString): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtFormatModifier(buffer: CORBAString; name: CORBAString; value: CORBAString): LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtGetModifierList(buffer: CORBAString): LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtSetSymbolsOnEntry(emitter: SOMTEmitC; prefix: CORBAString): LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somtSetEntryStruct(var es: Pointer); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultInit(var ctrl: Pointer); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDestruct(doFree: Byte; var ctrl: Pointer); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultCopyInit(var ctrl: Pointer; fromObj: SOMTClassEntryC); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultAssign(var ctrl: Pointer; fromObj: SOMTClassEntryC): SOMTClassEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultConstCopyInit(var ctrl: Pointer; fromObj: SOMTClassEntryC); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultVCopyInit(var ctrl: Pointer; fromObj: SOMTClassEntryC); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultConstVCopyInit(var ctrl: Pointer; fromObj: SOMTClassEntryC); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultConstAssign(var ctrl: Pointer; fromObj: SOMTClassEntryC): SOMTClassEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultVAssign(var ctrl: Pointer; fromObj: SOMTClassEntryC): SOMTClassEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultConstVAssign(var ctrl: Pointer; fromObj: SOMTClassEntryC): SOMTClassEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somInit; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somFree; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somUninit; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetClass: SOMClass; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetClassName: {dual_owned} CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetSize: LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somIsA(aClassObj: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somIsInstanceOf(aClassObj: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somRespondsTo(mId: somId): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDispatch(out retValue: Pointer; methodId: somId; ap: va_list): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somClassDispatch(clsObj: SOMClass; out retValue: Pointer; methodId: somId; ap: va_list): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somCastObj(cls: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somResetObj: CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somPrintSelf: SOMTClassEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDumpSelf(level: LongInt); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDumpSelfInt(level: LongInt); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}

    { Class object access and initialization }
    class function ClassObject: SOMClass; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF} // may be nil before class is created
    class function NewClass: SOMClass; // (not really new every time, but autocreated)

    { Upcasting }
    function As_SOMTEntryC: SOMTEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function As_SOMTClassEntryC: SOMTClassEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}

    { Downcasting }
    class function Supports(Instance: SOMObjectBase): Boolean; overload;
    class function Supports(Instance: SOMObjectBase; out Obj: SOMTClassEntryC): Boolean; overload;

    property somtSourceFileName: CORBAString read _get_somtSourceFileName;
    property somtMetaClassEntry: SOMTMetaClassEntryC read _get_somtMetaClassEntry;
    property somtClassModule: SOMTModuleEntryC read _get_somtClassModule;
    property somtNewMethodCount: LongInt read _get_somtNewMethodCount;
    property somtLocalInclude: CORBABoolean read _get_somtLocalInclude;
    property somtPrivateMethodCount: LongInt read _get_somtPrivateMethodCount;
    property somtStaticMethodCount: LongInt read _get_somtStaticMethodCount;
    property somtOverrideMethodCount: LongInt read _get_somtOverrideMethodCount;
    property somtProcMethodCount: LongInt read _get_somtProcMethodCount;
    property somtVAMethodCount: LongInt read _get_somtVAMethodCount;
    property somtBaseCount: LongInt read _get_somtBaseCount;
    property somtExternalDataCount: LongInt read _get_somtExternalDataCount;
    property somtPublicDataCount: LongInt read _get_somtPublicDataCount;
    property somtPrivateDataCount: LongInt read _get_somtPrivateDataCount;
    property somtMetaclassFor: SOMTClassEntryC read _get_somtMetaclassFor;
    property somtForwardRef: CORBABoolean read _get_somtForwardRef;
    property somtEntryName: CORBAString read _get_somtEntryName write _set_somtEntryName;
    property somtElementType: LongWord read _get_somtElementType write _set_somtElementType;
    property somtElementTypeName: CORBAString read _get_somtElementTypeName;
    property somtEntryComment: CORBAString read _get_somtEntryComment;
    property somtSourceLineNumber: LongWord read _get_somtSourceLineNumber;
    property somtTypeCode: TypeCode read _get_somtTypeCode;
    property somtIsReference: CORBABoolean read _get_somtIsReference;
    property somtIDLScopedName: CORBAString read _get_somtIDLScopedName;
    property somtCScopedName: CORBAString read _get_somtCScopedName;
  end;

  SOMTCommonEntryC = class(SOMObjectBase)
  private
    function _get_somtTypeObj: SOMTEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtPtrs: CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtArrayDimsString: CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtSourceText: CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtType: CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtVisibility: somtVisibilityT; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtEntryName: CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure _set_somtEntryName(somtEntryName: CORBAString); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtElementType: LongWord; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure _set_somtElementType(somtElementType: LongWord); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtElementTypeName: CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtEntryComment: CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtSourceLineNumber: LongWord; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtTypeCode: TypeCode; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtIsReference: CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtIDLScopedName: CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtCScopedName: CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
  public
    class function Create: SOMTCommonEntryC; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function InitInstance(Instance: Pointer): SOMTCommonEntryC; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function ClassType: SOMClass; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function ClassName: string; reintroduce;
    class function ClassNameIs(const Name: string): Boolean; reintroduce;
    class function InstanceSize: LongInt; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function InheritsFrom(AClass: SOMClass): Boolean; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function MethodAddress(const Name: string): Pointer; reintroduce;
    class function NewInstance: SOMTCommonEntryC; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function Clone: SOMTCommonEntryC; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtGetFirstArrayDimension: LongWord; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtGetNextArrayDimension: LongWord; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtIsArray(out size: LongInt): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtIsPointer: CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtGetModifierValue(modifierName: CORBAString): CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtGetFirstModifier(var modifierName: CORBAString; var modifierValue: CORBAString): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtGetNextModifier(var modifierName: CORBAString; var modifierValue: CORBAString): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtFormatModifier(buffer: CORBAString; name: CORBAString; value: CORBAString): LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtGetModifierList(buffer: CORBAString): LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtSetSymbolsOnEntry(emitter: SOMTEmitC; prefix: CORBAString): LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somtSetEntryStruct(var es: Pointer); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultInit(var ctrl: Pointer); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDestruct(doFree: Byte; var ctrl: Pointer); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultCopyInit(var ctrl: Pointer; fromObj: SOMTCommonEntryC); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultAssign(var ctrl: Pointer; fromObj: SOMTCommonEntryC): SOMTCommonEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultConstCopyInit(var ctrl: Pointer; fromObj: SOMTCommonEntryC); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultVCopyInit(var ctrl: Pointer; fromObj: SOMTCommonEntryC); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultConstVCopyInit(var ctrl: Pointer; fromObj: SOMTCommonEntryC); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultConstAssign(var ctrl: Pointer; fromObj: SOMTCommonEntryC): SOMTCommonEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultVAssign(var ctrl: Pointer; fromObj: SOMTCommonEntryC): SOMTCommonEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultConstVAssign(var ctrl: Pointer; fromObj: SOMTCommonEntryC): SOMTCommonEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somInit; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somFree; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somUninit; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetClass: SOMClass; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetClassName: {dual_owned} CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetSize: LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somIsA(aClassObj: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somIsInstanceOf(aClassObj: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somRespondsTo(mId: somId): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDispatch(out retValue: Pointer; methodId: somId; ap: va_list): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somClassDispatch(clsObj: SOMClass; out retValue: Pointer; methodId: somId; ap: va_list): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somCastObj(cls: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somResetObj: CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somPrintSelf: SOMTCommonEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDumpSelf(level: LongInt); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDumpSelfInt(level: LongInt); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}

    { Class object access and initialization }
    class function ClassObject: SOMClass; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF} // may be nil before class is created
    class function NewClass: SOMClass; // (not really new every time, but autocreated)

    { Upcasting }
    function As_SOMTEntryC: SOMTEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function As_SOMTCommonEntryC: SOMTCommonEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}

    { Downcasting }
    class function Supports(Instance: SOMObjectBase): Boolean; overload;
    class function Supports(Instance: SOMObjectBase; out Obj: SOMTCommonEntryC): Boolean; overload;

    property somtTypeObj: SOMTEntryC read _get_somtTypeObj;
    property somtPtrs: CORBAString read _get_somtPtrs;
    property somtArrayDimsString: CORBAString read _get_somtArrayDimsString;
    property somtSourceText: CORBAString read _get_somtSourceText;
    property somtType: CORBAString read _get_somtType;
    property somtVisibility: somtVisibilityT read _get_somtVisibility;
    property somtEntryName: CORBAString read _get_somtEntryName write _set_somtEntryName;
    property somtElementType: LongWord read _get_somtElementType write _set_somtElementType;
    property somtElementTypeName: CORBAString read _get_somtElementTypeName;
    property somtEntryComment: CORBAString read _get_somtEntryComment;
    property somtSourceLineNumber: LongWord read _get_somtSourceLineNumber;
    property somtTypeCode: TypeCode read _get_somtTypeCode;
    property somtIsReference: CORBABoolean read _get_somtIsReference;
    property somtIDLScopedName: CORBAString read _get_somtIDLScopedName;
    property somtCScopedName: CORBAString read _get_somtCScopedName;
  end;

  SOMTConstEntryC = class(SOMObjectBase)
  private
    function _get_somtConstTypeObj: SOMTEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtConstType: CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtConstStringVal: CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtConstNumVal: LongWord; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtConstNumNegVal: LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtConstIsNegative: CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtConstVal: CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtEntryName: CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure _set_somtEntryName(somtEntryName: CORBAString); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtElementType: LongWord; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure _set_somtElementType(somtElementType: LongWord); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtElementTypeName: CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtEntryComment: CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtSourceLineNumber: LongWord; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtTypeCode: TypeCode; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtIsReference: CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtIDLScopedName: CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtCScopedName: CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
  public
    class function Create: SOMTConstEntryC; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function InitInstance(Instance: Pointer): SOMTConstEntryC; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function ClassType: SOMClass; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function ClassName: string; reintroduce;
    class function ClassNameIs(const Name: string): Boolean; reintroduce;
    class function InstanceSize: LongInt; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function InheritsFrom(AClass: SOMClass): Boolean; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function MethodAddress(const Name: string): Pointer; reintroduce;
    class function NewInstance: SOMTConstEntryC; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function Clone: SOMTConstEntryC; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtGetModifierValue(modifierName: CORBAString): CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtGetFirstModifier(var modifierName: CORBAString; var modifierValue: CORBAString): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtGetNextModifier(var modifierName: CORBAString; var modifierValue: CORBAString): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtFormatModifier(buffer: CORBAString; name: CORBAString; value: CORBAString): LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtGetModifierList(buffer: CORBAString): LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtSetSymbolsOnEntry(emitter: SOMTEmitC; prefix: CORBAString): LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somtSetEntryStruct(var es: Pointer); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultInit(var ctrl: Pointer); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDestruct(doFree: Byte; var ctrl: Pointer); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultCopyInit(var ctrl: Pointer; fromObj: SOMTConstEntryC); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultAssign(var ctrl: Pointer; fromObj: SOMTConstEntryC): SOMTConstEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultConstCopyInit(var ctrl: Pointer; fromObj: SOMTConstEntryC); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultVCopyInit(var ctrl: Pointer; fromObj: SOMTConstEntryC); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultConstVCopyInit(var ctrl: Pointer; fromObj: SOMTConstEntryC); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultConstAssign(var ctrl: Pointer; fromObj: SOMTConstEntryC): SOMTConstEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultVAssign(var ctrl: Pointer; fromObj: SOMTConstEntryC): SOMTConstEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultConstVAssign(var ctrl: Pointer; fromObj: SOMTConstEntryC): SOMTConstEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somInit; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somFree; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somUninit; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetClass: SOMClass; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetClassName: {dual_owned} CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetSize: LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somIsA(aClassObj: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somIsInstanceOf(aClassObj: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somRespondsTo(mId: somId): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDispatch(out retValue: Pointer; methodId: somId; ap: va_list): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somClassDispatch(clsObj: SOMClass; out retValue: Pointer; methodId: somId; ap: va_list): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somCastObj(cls: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somResetObj: CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somPrintSelf: SOMTConstEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDumpSelf(level: LongInt); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDumpSelfInt(level: LongInt); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}

    { Class object access and initialization }
    class function ClassObject: SOMClass; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF} // may be nil before class is created
    class function NewClass: SOMClass; // (not really new every time, but autocreated)

    { Upcasting }
    function As_SOMTEntryC: SOMTEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function As_SOMTConstEntryC: SOMTConstEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}

    { Downcasting }
    class function Supports(Instance: SOMObjectBase): Boolean; overload;
    class function Supports(Instance: SOMObjectBase; out Obj: SOMTConstEntryC): Boolean; overload;

    property somtConstTypeObj: SOMTEntryC read _get_somtConstTypeObj;
    property somtConstType: CORBAString read _get_somtConstType;
    property somtConstStringVal: CORBAString read _get_somtConstStringVal;
    property somtConstNumVal: LongWord read _get_somtConstNumVal;
    property somtConstNumNegVal: LongInt read _get_somtConstNumNegVal;
    property somtConstIsNegative: CORBABoolean read _get_somtConstIsNegative;
    property somtConstVal: CORBAString read _get_somtConstVal;
    property somtEntryName: CORBAString read _get_somtEntryName write _set_somtEntryName;
    property somtElementType: LongWord read _get_somtElementType write _set_somtElementType;
    property somtElementTypeName: CORBAString read _get_somtElementTypeName;
    property somtEntryComment: CORBAString read _get_somtEntryComment;
    property somtSourceLineNumber: LongWord read _get_somtSourceLineNumber;
    property somtTypeCode: TypeCode read _get_somtTypeCode;
    property somtIsReference: CORBABoolean read _get_somtIsReference;
    property somtIDLScopedName: CORBAString read _get_somtIDLScopedName;
    property somtCScopedName: CORBAString read _get_somtCScopedName;
  end;

  SOMTDataEntryC = class(SOMObjectBase)
  private
    function _get_somtIsSelfRef: CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtTypeObj: SOMTEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtPtrs: CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtArrayDimsString: CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtSourceText: CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtType: CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtVisibility: somtVisibilityT; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtEntryName: CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure _set_somtEntryName(somtEntryName: CORBAString); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtElementType: LongWord; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure _set_somtElementType(somtElementType: LongWord); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtElementTypeName: CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtEntryComment: CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtSourceLineNumber: LongWord; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtTypeCode: TypeCode; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtIsReference: CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtIDLScopedName: CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtCScopedName: CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
  public
    class function Create: SOMTDataEntryC; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function InitInstance(Instance: Pointer): SOMTDataEntryC; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function ClassType: SOMClass; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function ClassName: string; reintroduce;
    class function ClassNameIs(const Name: string): Boolean; reintroduce;
    class function InstanceSize: LongInt; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function InheritsFrom(AClass: SOMClass): Boolean; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function MethodAddress(const Name: string): Pointer; reintroduce;
    class function NewInstance: SOMTDataEntryC; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function Clone: SOMTDataEntryC; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtGetFirstArrayDimension: LongWord; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtGetNextArrayDimension: LongWord; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtIsArray(out size: LongInt): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtIsPointer: CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtGetModifierValue(modifierName: CORBAString): CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtGetFirstModifier(var modifierName: CORBAString; var modifierValue: CORBAString): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtGetNextModifier(var modifierName: CORBAString; var modifierValue: CORBAString): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtFormatModifier(buffer: CORBAString; name: CORBAString; value: CORBAString): LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtGetModifierList(buffer: CORBAString): LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtSetSymbolsOnEntry(emitter: SOMTEmitC; prefix: CORBAString): LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somtSetEntryStruct(var es: Pointer); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultInit(var ctrl: Pointer); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDestruct(doFree: Byte; var ctrl: Pointer); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultCopyInit(var ctrl: Pointer; fromObj: SOMTDataEntryC); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultAssign(var ctrl: Pointer; fromObj: SOMTDataEntryC): SOMTDataEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultConstCopyInit(var ctrl: Pointer; fromObj: SOMTDataEntryC); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultVCopyInit(var ctrl: Pointer; fromObj: SOMTDataEntryC); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultConstVCopyInit(var ctrl: Pointer; fromObj: SOMTDataEntryC); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultConstAssign(var ctrl: Pointer; fromObj: SOMTDataEntryC): SOMTDataEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultVAssign(var ctrl: Pointer; fromObj: SOMTDataEntryC): SOMTDataEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultConstVAssign(var ctrl: Pointer; fromObj: SOMTDataEntryC): SOMTDataEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somInit; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somFree; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somUninit; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetClass: SOMClass; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetClassName: {dual_owned} CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetSize: LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somIsA(aClassObj: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somIsInstanceOf(aClassObj: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somRespondsTo(mId: somId): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDispatch(out retValue: Pointer; methodId: somId; ap: va_list): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somClassDispatch(clsObj: SOMClass; out retValue: Pointer; methodId: somId; ap: va_list): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somCastObj(cls: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somResetObj: CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somPrintSelf: SOMTDataEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDumpSelf(level: LongInt); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDumpSelfInt(level: LongInt); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}

    { Class object access and initialization }
    class function ClassObject: SOMClass; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF} // may be nil before class is created
    class function NewClass: SOMClass; // (not really new every time, but autocreated)

    { Upcasting }
    function As_SOMTCommonEntryC: SOMTCommonEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function As_SOMTEntryC: SOMTEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function As_SOMTDataEntryC: SOMTDataEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}

    { Downcasting }
    class function Supports(Instance: SOMObjectBase): Boolean; overload;
    class function Supports(Instance: SOMObjectBase; out Obj: SOMTDataEntryC): Boolean; overload;

    property somtIsSelfRef: CORBABoolean read _get_somtIsSelfRef;
    property somtTypeObj: SOMTEntryC read _get_somtTypeObj;
    property somtPtrs: CORBAString read _get_somtPtrs;
    property somtArrayDimsString: CORBAString read _get_somtArrayDimsString;
    property somtSourceText: CORBAString read _get_somtSourceText;
    property somtType: CORBAString read _get_somtType;
    property somtVisibility: somtVisibilityT read _get_somtVisibility;
    property somtEntryName: CORBAString read _get_somtEntryName write _set_somtEntryName;
    property somtElementType: LongWord read _get_somtElementType write _set_somtElementType;
    property somtElementTypeName: CORBAString read _get_somtElementTypeName;
    property somtEntryComment: CORBAString read _get_somtEntryComment;
    property somtSourceLineNumber: LongWord read _get_somtSourceLineNumber;
    property somtTypeCode: TypeCode read _get_somtTypeCode;
    property somtIsReference: CORBABoolean read _get_somtIsReference;
    property somtIDLScopedName: CORBAString read _get_somtIDLScopedName;
    property somtCScopedName: CORBAString read _get_somtCScopedName;
  end;

  PSOM_FILE = Pointer{ opaque ^SOM_FILE };
  SOMTEmitC = class(SOMObjectBase)
  private
    function _get_somtTemplate: SOMTTemplateOutputC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure _set_somtTemplate(somtTemplate: SOMTTemplateOutputC); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtTargetFile: PSOM_FILE; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure _set_somtTargetFile(somtTargetFile: PSOM_FILE); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtTargetClass: SOMTClassEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure _set_somtTargetClass(somtTargetClass: SOMTClassEntryC); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtTargetModule: SOMTModuleEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure _set_somtTargetModule(somtTargetModule: SOMTModuleEntryC); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtTargetType: SOMTTargetTypeT; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure _set_somtTargetType(somtTargetType: SOMTTargetTypeT); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtEmitterName: CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure _set_somtEmitterName(somtEmitterName: CORBAString); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
  public
    class function Create: SOMTEmitC; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function InitInstance(Instance: Pointer): SOMTEmitC; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function ClassType: SOMClass; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function ClassName: string; reintroduce;
    class function ClassNameIs(const Name: string): Boolean; reintroduce;
    class function InstanceSize: LongInt; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function InheritsFrom(AClass: SOMClass): Boolean; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function MethodAddress(const Name: string): Pointer; reintroduce;
    class function NewInstance: SOMTEmitC; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function Clone: SOMTEmitC; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtGenerateSections: CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtOpenSymbolsFile(SOM_file: CORBAString; mode: CORBAString): PSOM_FILE; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somtSetPredefinedSymbols; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somtFileSymbols; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somtEmitProlog; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somtEmitBaseIncludesProlog; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somtEmitBaseIncludes(base: SOMTBaseClassEntryC); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somtEmitBaseIncludesEpilog; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somtEmitMetaInclude; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somtEmitClass; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somtEmitMeta; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somtEmitBaseProlog; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somtEmitBase(base: SOMTBaseClassEntryC); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somtEmitBaseEpilog; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somtEmitPassthruProlog; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somtEmitPassthru(entry: SOMTPassthruEntryC); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somtEmitPassthruEpilog; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somtEmitRelease; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somtEmitDataProlog; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somtEmitData(entry: SOMTDataEntryC); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somtEmitDataEpilog; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somtEmitAttributeProlog; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somtEmitAttribute(att: SOMTAttributeEntryC); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somtEmitAttributeEpilog; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somtEmitConstantProlog; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somtEmitConstant(con: SOMTConstEntryC); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somtEmitConstantEpilog; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somtEmitTypedefProlog; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somtEmitTypedef(td: SOMTTypedefEntryC); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somtEmitTypedefEpilog; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somtEmitStructProlog; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somtEmitStruct(struc: SOMTStructEntryC); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somtEmitStructEpilog; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somtEmitUnionProlog; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somtEmitUnion(un: SOMTUnionEntryC); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somtEmitUnionEpilog; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somtEmitEnumProlog; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somtEmitEnum(en: SOMTEnumEntryC); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somtEmitEnumEpilog; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somtEmitInterfaceProlog; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somtEmitInterface(intfc: SOMTClassEntryC); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somtEmitInterfaceEpilog; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somtEmitModuleProlog; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somtEmitModule(SOM_mod: SOMTModuleEntryC); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somtEmitModuleEpilog; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somtEmitMethodsProlog; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somtEmitMethods(method: SOMTMethodEntryC); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somtEmitMethodsEpilog; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somtEmitMethod(entry: SOMTMethodEntryC); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somtEmitEpilog; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtScanBases(prolog: CORBAString; each: CORBAString; epilog: CORBAString): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtCheckVisibility(entry: SOMTMethodEntryC): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtNew(entry: SOMTMethodEntryC): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtImplemented(entry: SOMTMethodEntryC): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtOverridden(entry: SOMTMethodEntryC): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtInherited(entry: SOMTMethodEntryC): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtAllVisible(entry: SOMTMethodEntryC): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtAll(entry: SOMTMethodEntryC): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtNewNoProc(entry: SOMTEntryC): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtPrivOrPub(entry: SOMTEntryC): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtNewProc(entry: SOMTEntryC): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtLink(entry: SOMTEntryC): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtVA(entry: SOMTEntryC): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtScanMethods(filter: CORBAString; prolog: CORBAString; each: CORBAString; epilog: CORBAString; forceProlog: CORBABoolean): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtScanConstants(prolog: CORBAString; each: CORBAString; epilog: CORBAString): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtScanTypedefs(prolog: CORBAString; each: CORBAString; epilog: CORBAString): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtScanStructs(prolog: CORBAString; each: CORBAString; epilog: CORBAString): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtScanUnions(prolog: CORBAString; each: CORBAString; epilog: CORBAString): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtScanEnums(prolog: CORBAString; each: CORBAString; epilog: CORBAString): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtScanData(prolog: CORBAString; each: CORBAString; epilog: CORBAString): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtScanAttributes(prolog: CORBAString; each: CORBAString; epilog: CORBAString): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtScanInterfaces(prolog: CORBAString; each: CORBAString; epilog: CORBAString): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtScanModules(prolog: CORBAString; each: CORBAString; epilog: CORBAString): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtScanPassthru(before: CORBABoolean; prolog: CORBAString; each: CORBAString; epilog: CORBAString): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somtEmitFullPassthru(before: CORBABoolean; language: CORBAString); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtScanDataF(filter: CORBAString; prolog: CORBAString; each: CORBAString; epilog: CORBAString; forceProlog: CORBABoolean): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtScanBasesF(filter: CORBAString; prolog: CORBAString; each: CORBAString; epilog: CORBAString; forceProlog: CORBABoolean): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtGetGlobalModifierValue(modifierName: CORBAString): CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtGetFirstGlobalDefinition: SOMTEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtGetNextGlobalDefinition: SOMTEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultInit(var ctrl: Pointer); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDestruct(doFree: Byte; var ctrl: Pointer); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultCopyInit(var ctrl: Pointer; fromObj: SOMTEmitC); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultAssign(var ctrl: Pointer; fromObj: SOMTEmitC): SOMTEmitC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultConstCopyInit(var ctrl: Pointer; fromObj: SOMTEmitC); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultVCopyInit(var ctrl: Pointer; fromObj: SOMTEmitC); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultConstVCopyInit(var ctrl: Pointer; fromObj: SOMTEmitC); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultConstAssign(var ctrl: Pointer; fromObj: SOMTEmitC): SOMTEmitC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultVAssign(var ctrl: Pointer; fromObj: SOMTEmitC): SOMTEmitC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultConstVAssign(var ctrl: Pointer; fromObj: SOMTEmitC): SOMTEmitC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somInit; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somFree; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somUninit; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetClass: SOMClass; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetClassName: {dual_owned} CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetSize: LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somIsA(aClassObj: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somIsInstanceOf(aClassObj: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somRespondsTo(mId: somId): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDispatch(out retValue: Pointer; methodId: somId; ap: va_list): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somClassDispatch(clsObj: SOMClass; out retValue: Pointer; methodId: somId; ap: va_list): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somCastObj(cls: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somResetObj: CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somPrintSelf: SOMTEmitC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDumpSelf(level: LongInt); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDumpSelfInt(level: LongInt); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}

    { Class object access and initialization }
    class function ClassObject: SOMClass; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF} // may be nil before class is created
    class function NewClass: SOMClass; // (not really new every time, but autocreated)

    { Upcasting }
    function As_SOMTEmitC: SOMTEmitC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}

    { Downcasting }
    class function Supports(Instance: SOMObjectBase): Boolean; overload;
    class function Supports(Instance: SOMObjectBase; out Obj: SOMTEmitC): Boolean; overload;

    property somtTemplate: SOMTTemplateOutputC read _get_somtTemplate write _set_somtTemplate;
    property somtTargetFile: PSOM_FILE read _get_somtTargetFile write _set_somtTargetFile;
    property somtTargetClass: SOMTClassEntryC read _get_somtTargetClass write _set_somtTargetClass;
    property somtTargetModule: SOMTModuleEntryC read _get_somtTargetModule write _set_somtTargetModule;
    property somtTargetType: SOMTTargetTypeT read _get_somtTargetType write _set_somtTargetType;
    property somtEmitterName: CORBAString read _get_somtEmitterName write _set_somtEmitterName;
  end;

  SOMTEnumEntryC = class(SOMObjectBase)
  private
    function _get_somtEntryName: CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure _set_somtEntryName(somtEntryName: CORBAString); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtElementType: LongWord; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure _set_somtElementType(somtElementType: LongWord); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtElementTypeName: CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtEntryComment: CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtSourceLineNumber: LongWord; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtTypeCode: TypeCode; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtIsReference: CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtIDLScopedName: CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtCScopedName: CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
  public
    class function Create: SOMTEnumEntryC; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function InitInstance(Instance: Pointer): SOMTEnumEntryC; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function ClassType: SOMClass; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function ClassName: string; reintroduce;
    class function ClassNameIs(const Name: string): Boolean; reintroduce;
    class function InstanceSize: LongInt; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function InheritsFrom(AClass: SOMClass): Boolean; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function MethodAddress(const Name: string): Pointer; reintroduce;
    class function NewInstance: SOMTEnumEntryC; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function Clone: SOMTEnumEntryC; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtGetFirstEnumName: SOMTEnumNameEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtGetNextEnumName: SOMTEnumNameEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtGetModifierValue(modifierName: CORBAString): CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtGetFirstModifier(var modifierName: CORBAString; var modifierValue: CORBAString): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtGetNextModifier(var modifierName: CORBAString; var modifierValue: CORBAString): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtFormatModifier(buffer: CORBAString; name: CORBAString; value: CORBAString): LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtGetModifierList(buffer: CORBAString): LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtSetSymbolsOnEntry(emitter: SOMTEmitC; prefix: CORBAString): LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somtSetEntryStruct(var es: Pointer); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultInit(var ctrl: Pointer); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDestruct(doFree: Byte; var ctrl: Pointer); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultCopyInit(var ctrl: Pointer; fromObj: SOMTEnumEntryC); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultAssign(var ctrl: Pointer; fromObj: SOMTEnumEntryC): SOMTEnumEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultConstCopyInit(var ctrl: Pointer; fromObj: SOMTEnumEntryC); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultVCopyInit(var ctrl: Pointer; fromObj: SOMTEnumEntryC); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultConstVCopyInit(var ctrl: Pointer; fromObj: SOMTEnumEntryC); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultConstAssign(var ctrl: Pointer; fromObj: SOMTEnumEntryC): SOMTEnumEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultVAssign(var ctrl: Pointer; fromObj: SOMTEnumEntryC): SOMTEnumEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultConstVAssign(var ctrl: Pointer; fromObj: SOMTEnumEntryC): SOMTEnumEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somInit; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somFree; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somUninit; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetClass: SOMClass; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetClassName: {dual_owned} CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetSize: LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somIsA(aClassObj: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somIsInstanceOf(aClassObj: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somRespondsTo(mId: somId): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDispatch(out retValue: Pointer; methodId: somId; ap: va_list): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somClassDispatch(clsObj: SOMClass; out retValue: Pointer; methodId: somId; ap: va_list): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somCastObj(cls: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somResetObj: CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somPrintSelf: SOMTEnumEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDumpSelf(level: LongInt); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDumpSelfInt(level: LongInt); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}

    { Class object access and initialization }
    class function ClassObject: SOMClass; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF} // may be nil before class is created
    class function NewClass: SOMClass; // (not really new every time, but autocreated)

    { Upcasting }
    function As_SOMTEntryC: SOMTEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function As_SOMTEnumEntryC: SOMTEnumEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}

    { Downcasting }
    class function Supports(Instance: SOMObjectBase): Boolean; overload;
    class function Supports(Instance: SOMObjectBase; out Obj: SOMTEnumEntryC): Boolean; overload;

    property somtEntryName: CORBAString read _get_somtEntryName write _set_somtEntryName;
    property somtElementType: LongWord read _get_somtElementType write _set_somtElementType;
    property somtElementTypeName: CORBAString read _get_somtElementTypeName;
    property somtEntryComment: CORBAString read _get_somtEntryComment;
    property somtSourceLineNumber: LongWord read _get_somtSourceLineNumber;
    property somtTypeCode: TypeCode read _get_somtTypeCode;
    property somtIsReference: CORBABoolean read _get_somtIsReference;
    property somtIDLScopedName: CORBAString read _get_somtIDLScopedName;
    property somtCScopedName: CORBAString read _get_somtCScopedName;
  end;

  SOMTEnumNameEntryC = class(SOMObjectBase)
  private
    function _get_somtEnumPtr: SOMTEnumEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtEnumVal: LongWord; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtEntryName: CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure _set_somtEntryName(somtEntryName: CORBAString); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtElementType: LongWord; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure _set_somtElementType(somtElementType: LongWord); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtElementTypeName: CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtEntryComment: CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtSourceLineNumber: LongWord; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtTypeCode: TypeCode; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtIsReference: CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtIDLScopedName: CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtCScopedName: CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
  public
    class function Create: SOMTEnumNameEntryC; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function InitInstance(Instance: Pointer): SOMTEnumNameEntryC; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function ClassType: SOMClass; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function ClassName: string; reintroduce;
    class function ClassNameIs(const Name: string): Boolean; reintroduce;
    class function InstanceSize: LongInt; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function InheritsFrom(AClass: SOMClass): Boolean; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function MethodAddress(const Name: string): Pointer; reintroduce;
    class function NewInstance: SOMTEnumNameEntryC; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function Clone: SOMTEnumNameEntryC; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtGetModifierValue(modifierName: CORBAString): CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtGetFirstModifier(var modifierName: CORBAString; var modifierValue: CORBAString): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtGetNextModifier(var modifierName: CORBAString; var modifierValue: CORBAString): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtFormatModifier(buffer: CORBAString; name: CORBAString; value: CORBAString): LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtGetModifierList(buffer: CORBAString): LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtSetSymbolsOnEntry(emitter: SOMTEmitC; prefix: CORBAString): LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somtSetEntryStruct(var es: Pointer); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultInit(var ctrl: Pointer); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDestruct(doFree: Byte; var ctrl: Pointer); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultCopyInit(var ctrl: Pointer; fromObj: SOMTEnumNameEntryC); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultAssign(var ctrl: Pointer; fromObj: SOMTEnumNameEntryC): SOMTEnumNameEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultConstCopyInit(var ctrl: Pointer; fromObj: SOMTEnumNameEntryC); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultVCopyInit(var ctrl: Pointer; fromObj: SOMTEnumNameEntryC); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultConstVCopyInit(var ctrl: Pointer; fromObj: SOMTEnumNameEntryC); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultConstAssign(var ctrl: Pointer; fromObj: SOMTEnumNameEntryC): SOMTEnumNameEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultVAssign(var ctrl: Pointer; fromObj: SOMTEnumNameEntryC): SOMTEnumNameEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultConstVAssign(var ctrl: Pointer; fromObj: SOMTEnumNameEntryC): SOMTEnumNameEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somInit; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somFree; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somUninit; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetClass: SOMClass; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetClassName: {dual_owned} CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetSize: LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somIsA(aClassObj: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somIsInstanceOf(aClassObj: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somRespondsTo(mId: somId): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDispatch(out retValue: Pointer; methodId: somId; ap: va_list): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somClassDispatch(clsObj: SOMClass; out retValue: Pointer; methodId: somId; ap: va_list): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somCastObj(cls: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somResetObj: CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somPrintSelf: SOMTEnumNameEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDumpSelf(level: LongInt); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDumpSelfInt(level: LongInt); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}

    { Class object access and initialization }
    class function ClassObject: SOMClass; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF} // may be nil before class is created
    class function NewClass: SOMClass; // (not really new every time, but autocreated)

    { Upcasting }
    function As_SOMTEntryC: SOMTEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function As_SOMTEnumNameEntryC: SOMTEnumNameEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}

    { Downcasting }
    class function Supports(Instance: SOMObjectBase): Boolean; overload;
    class function Supports(Instance: SOMObjectBase; out Obj: SOMTEnumNameEntryC): Boolean; overload;

    property somtEnumPtr: SOMTEnumEntryC read _get_somtEnumPtr;
    property somtEnumVal: LongWord read _get_somtEnumVal;
    property somtEntryName: CORBAString read _get_somtEntryName write _set_somtEntryName;
    property somtElementType: LongWord read _get_somtElementType write _set_somtElementType;
    property somtElementTypeName: CORBAString read _get_somtElementTypeName;
    property somtEntryComment: CORBAString read _get_somtEntryComment;
    property somtSourceLineNumber: LongWord read _get_somtSourceLineNumber;
    property somtTypeCode: TypeCode read _get_somtTypeCode;
    property somtIsReference: CORBABoolean read _get_somtIsReference;
    property somtIDLScopedName: CORBAString read _get_somtIDLScopedName;
    property somtCScopedName: CORBAString read _get_somtCScopedName;
  end;

  SOMTMetaClassEntryC = class(SOMObjectBase)
  private
    function _get_somtMetaFile: CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtMetaClassDef: SOMTClassEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtEntryName: CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure _set_somtEntryName(somtEntryName: CORBAString); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtElementType: LongWord; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure _set_somtElementType(somtElementType: LongWord); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtElementTypeName: CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtEntryComment: CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtSourceLineNumber: LongWord; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtTypeCode: TypeCode; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtIsReference: CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtIDLScopedName: CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtCScopedName: CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
  public
    class function Create: SOMTMetaClassEntryC; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function InitInstance(Instance: Pointer): SOMTMetaClassEntryC; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function ClassType: SOMClass; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function ClassName: string; reintroduce;
    class function ClassNameIs(const Name: string): Boolean; reintroduce;
    class function InstanceSize: LongInt; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function InheritsFrom(AClass: SOMClass): Boolean; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function MethodAddress(const Name: string): Pointer; reintroduce;
    class function NewInstance: SOMTMetaClassEntryC; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function Clone: SOMTMetaClassEntryC; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtGetModifierValue(modifierName: CORBAString): CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtGetFirstModifier(var modifierName: CORBAString; var modifierValue: CORBAString): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtGetNextModifier(var modifierName: CORBAString; var modifierValue: CORBAString): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtFormatModifier(buffer: CORBAString; name: CORBAString; value: CORBAString): LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtGetModifierList(buffer: CORBAString): LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtSetSymbolsOnEntry(emitter: SOMTEmitC; prefix: CORBAString): LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somtSetEntryStruct(var es: Pointer); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultInit(var ctrl: Pointer); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDestruct(doFree: Byte; var ctrl: Pointer); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultCopyInit(var ctrl: Pointer; fromObj: SOMTMetaClassEntryC); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultAssign(var ctrl: Pointer; fromObj: SOMTMetaClassEntryC): SOMTMetaClassEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultConstCopyInit(var ctrl: Pointer; fromObj: SOMTMetaClassEntryC); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultVCopyInit(var ctrl: Pointer; fromObj: SOMTMetaClassEntryC); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultConstVCopyInit(var ctrl: Pointer; fromObj: SOMTMetaClassEntryC); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultConstAssign(var ctrl: Pointer; fromObj: SOMTMetaClassEntryC): SOMTMetaClassEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultVAssign(var ctrl: Pointer; fromObj: SOMTMetaClassEntryC): SOMTMetaClassEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultConstVAssign(var ctrl: Pointer; fromObj: SOMTMetaClassEntryC): SOMTMetaClassEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somInit; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somFree; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somUninit; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetClass: SOMClass; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetClassName: {dual_owned} CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetSize: LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somIsA(aClassObj: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somIsInstanceOf(aClassObj: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somRespondsTo(mId: somId): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDispatch(out retValue: Pointer; methodId: somId; ap: va_list): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somClassDispatch(clsObj: SOMClass; out retValue: Pointer; methodId: somId; ap: va_list): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somCastObj(cls: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somResetObj: CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somPrintSelf: SOMTMetaClassEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDumpSelf(level: LongInt); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDumpSelfInt(level: LongInt); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}

    { Class object access and initialization }
    class function ClassObject: SOMClass; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF} // may be nil before class is created
    class function NewClass: SOMClass; // (not really new every time, but autocreated)

    { Upcasting }
    function As_SOMTEntryC: SOMTEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function As_SOMTMetaClassEntryC: SOMTMetaClassEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}

    { Downcasting }
    class function Supports(Instance: SOMObjectBase): Boolean; overload;
    class function Supports(Instance: SOMObjectBase; out Obj: SOMTMetaClassEntryC): Boolean; overload;

    property somtMetaFile: CORBAString read _get_somtMetaFile;
    property somtMetaClassDef: SOMTClassEntryC read _get_somtMetaClassDef;
    property somtEntryName: CORBAString read _get_somtEntryName write _set_somtEntryName;
    property somtElementType: LongWord read _get_somtElementType write _set_somtElementType;
    property somtElementTypeName: CORBAString read _get_somtElementTypeName;
    property somtEntryComment: CORBAString read _get_somtEntryComment;
    property somtSourceLineNumber: LongWord read _get_somtSourceLineNumber;
    property somtTypeCode: TypeCode read _get_somtTypeCode;
    property somtIsReference: CORBABoolean read _get_somtIsReference;
    property somtIDLScopedName: CORBAString read _get_somtIDLScopedName;
    property somtCScopedName: CORBAString read _get_somtCScopedName;
  end;

  PCORBAString = ^CORBAString;
  SOMTMethodEntryC = class(SOMObjectBase)
  private
    function _get_somtIsVarargs: CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtOriginalMethod: SOMTMethodEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtOriginalClass: SOMTClassEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtMethodGroup: SOMTEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtIsPrivateMethod: CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtIsOneway: CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtArgCount: SmallInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtContextArray: PCORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtCReturnType: CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtTypeObj: SOMTEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtPtrs: CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtArrayDimsString: CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtSourceText: CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtType: CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtVisibility: somtVisibilityT; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtEntryName: CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure _set_somtEntryName(somtEntryName: CORBAString); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtElementType: LongWord; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure _set_somtElementType(somtElementType: LongWord); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtElementTypeName: CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtEntryComment: CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtSourceLineNumber: LongWord; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtTypeCode: TypeCode; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtIsReference: CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtIDLScopedName: CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtCScopedName: CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
  public
    class function Create: SOMTMethodEntryC; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function InitInstance(Instance: Pointer): SOMTMethodEntryC; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function ClassType: SOMClass; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function ClassName: string; reintroduce;
    class function ClassNameIs(const Name: string): Boolean; reintroduce;
    class function InstanceSize: LongInt; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function InheritsFrom(AClass: SOMClass): Boolean; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function MethodAddress(const Name: string): Pointer; reintroduce;
    class function NewInstance: SOMTMethodEntryC; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function Clone: SOMTMethodEntryC; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtGetFirstParameter: SOMTParameterEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtGetNextParameter: SOMTParameterEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtGetIDLParamList(buffer: CORBAString): CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtGetShortCParamList(buffer: CORBAString; selfParm: CORBAString; varargsParm: CORBAString): CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtGetFullCParamList(buffer: CORBAString; varargsParm: CORBAString): CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtGetShortParamNameList(buffer: CORBAString; selfParm: CORBAString; varargsParm: CORBAString): CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtGetFullParamNameList(buffer: CORBAString; varargsParm: CORBAString): CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtGetNthParameter(n: SmallInt): SOMTParameterEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtGetFirstException: SOMTStructEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtGetNextException: SOMTStructEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtGetFirstArrayDimension: LongWord; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtGetNextArrayDimension: LongWord; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtIsArray(out size: LongInt): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtIsPointer: CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtGetModifierValue(modifierName: CORBAString): CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtGetFirstModifier(var modifierName: CORBAString; var modifierValue: CORBAString): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtGetNextModifier(var modifierName: CORBAString; var modifierValue: CORBAString): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtFormatModifier(buffer: CORBAString; name: CORBAString; value: CORBAString): LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtGetModifierList(buffer: CORBAString): LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtSetSymbolsOnEntry(emitter: SOMTEmitC; prefix: CORBAString): LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somtSetEntryStruct(var es: Pointer); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultInit(var ctrl: Pointer); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDestruct(doFree: Byte; var ctrl: Pointer); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultCopyInit(var ctrl: Pointer; fromObj: SOMTMethodEntryC); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultAssign(var ctrl: Pointer; fromObj: SOMTMethodEntryC): SOMTMethodEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultConstCopyInit(var ctrl: Pointer; fromObj: SOMTMethodEntryC); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultVCopyInit(var ctrl: Pointer; fromObj: SOMTMethodEntryC); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultConstVCopyInit(var ctrl: Pointer; fromObj: SOMTMethodEntryC); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultConstAssign(var ctrl: Pointer; fromObj: SOMTMethodEntryC): SOMTMethodEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultVAssign(var ctrl: Pointer; fromObj: SOMTMethodEntryC): SOMTMethodEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultConstVAssign(var ctrl: Pointer; fromObj: SOMTMethodEntryC): SOMTMethodEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somInit; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somFree; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somUninit; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetClass: SOMClass; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetClassName: {dual_owned} CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetSize: LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somIsA(aClassObj: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somIsInstanceOf(aClassObj: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somRespondsTo(mId: somId): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDispatch(out retValue: Pointer; methodId: somId; ap: va_list): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somClassDispatch(clsObj: SOMClass; out retValue: Pointer; methodId: somId; ap: va_list): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somCastObj(cls: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somResetObj: CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somPrintSelf: SOMTMethodEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDumpSelf(level: LongInt); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDumpSelfInt(level: LongInt); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}

    { Class object access and initialization }
    class function ClassObject: SOMClass; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF} // may be nil before class is created
    class function NewClass: SOMClass; // (not really new every time, but autocreated)

    { Upcasting }
    function As_SOMTCommonEntryC: SOMTCommonEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function As_SOMTEntryC: SOMTEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function As_SOMTMethodEntryC: SOMTMethodEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}

    { Downcasting }
    class function Supports(Instance: SOMObjectBase): Boolean; overload;
    class function Supports(Instance: SOMObjectBase; out Obj: SOMTMethodEntryC): Boolean; overload;

    property somtIsVarargs: CORBABoolean read _get_somtIsVarargs;
    property somtOriginalMethod: SOMTMethodEntryC read _get_somtOriginalMethod;
    property somtOriginalClass: SOMTClassEntryC read _get_somtOriginalClass;
    property somtMethodGroup: SOMTEntryC read _get_somtMethodGroup;
    property somtIsPrivateMethod: CORBABoolean read _get_somtIsPrivateMethod;
    property somtIsOneway: CORBABoolean read _get_somtIsOneway;
    property somtArgCount: SmallInt read _get_somtArgCount;
    property somtContextArray: PCORBAString read _get_somtContextArray;
    property somtCReturnType: CORBAString read _get_somtCReturnType;
    property somtTypeObj: SOMTEntryC read _get_somtTypeObj;
    property somtPtrs: CORBAString read _get_somtPtrs;
    property somtArrayDimsString: CORBAString read _get_somtArrayDimsString;
    property somtSourceText: CORBAString read _get_somtSourceText;
    property somtType: CORBAString read _get_somtType;
    property somtVisibility: somtVisibilityT read _get_somtVisibility;
    property somtEntryName: CORBAString read _get_somtEntryName write _set_somtEntryName;
    property somtElementType: LongWord read _get_somtElementType write _set_somtElementType;
    property somtElementTypeName: CORBAString read _get_somtElementTypeName;
    property somtEntryComment: CORBAString read _get_somtEntryComment;
    property somtSourceLineNumber: LongWord read _get_somtSourceLineNumber;
    property somtTypeCode: TypeCode read _get_somtTypeCode;
    property somtIsReference: CORBABoolean read _get_somtIsReference;
    property somtIDLScopedName: CORBAString read _get_somtIDLScopedName;
    property somtCScopedName: CORBAString read _get_somtCScopedName;
  end;

  SOMTModuleEntryC = class(SOMObjectBase)
  private
    function _get_somtOuterModule: SOMTModuleEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtModuleFile: CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtEntryName: CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure _set_somtEntryName(somtEntryName: CORBAString); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtElementType: LongWord; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure _set_somtElementType(somtElementType: LongWord); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtElementTypeName: CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtEntryComment: CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtSourceLineNumber: LongWord; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtTypeCode: TypeCode; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtIsReference: CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtIDLScopedName: CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtCScopedName: CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
  public
    class function Create: SOMTModuleEntryC; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function InitInstance(Instance: Pointer): SOMTModuleEntryC; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function ClassType: SOMClass; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function ClassName: string; reintroduce;
    class function ClassNameIs(const Name: string): Boolean; reintroduce;
    class function InstanceSize: LongInt; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function InheritsFrom(AClass: SOMClass): Boolean; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function MethodAddress(const Name: string): Pointer; reintroduce;
    class function NewInstance: SOMTModuleEntryC; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function Clone: SOMTModuleEntryC; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtGetFirstModuleStruct: SOMTStructEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtGetNextModuleStruct: SOMTStructEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtGetFirstModuleTypedef: SOMTTypedefEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtGetNextModuleTypedef: SOMTTypedefEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtGetFirstModuleUnion: SOMTUnionEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtGetNextModuleUnion: SOMTUnionEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtGetFirstModuleEnum: SOMTEnumEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtGetNextModuleEnum: SOMTEnumEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtGetFirstModuleConstant: SOMTConstEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtGetNextModuleConstant: SOMTConstEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtGetFirstModuleSequence: SOMTSequenceEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtGetNextModuleSequence: SOMTSequenceEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtGetFirstInterface: SOMTClassEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtGetNextInterface: SOMTClassEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtGetFirstModule: SOMTModuleEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtGetNextModule: SOMTModuleEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtGetFirstModuleDef: SOMTEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtGetNextModuleDef: SOMTEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtGetModifierValue(modifierName: CORBAString): CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtGetFirstModifier(var modifierName: CORBAString; var modifierValue: CORBAString): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtGetNextModifier(var modifierName: CORBAString; var modifierValue: CORBAString): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtFormatModifier(buffer: CORBAString; name: CORBAString; value: CORBAString): LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtGetModifierList(buffer: CORBAString): LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtSetSymbolsOnEntry(emitter: SOMTEmitC; prefix: CORBAString): LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somtSetEntryStruct(var es: Pointer); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultInit(var ctrl: Pointer); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDestruct(doFree: Byte; var ctrl: Pointer); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultCopyInit(var ctrl: Pointer; fromObj: SOMTModuleEntryC); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultAssign(var ctrl: Pointer; fromObj: SOMTModuleEntryC): SOMTModuleEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultConstCopyInit(var ctrl: Pointer; fromObj: SOMTModuleEntryC); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultVCopyInit(var ctrl: Pointer; fromObj: SOMTModuleEntryC); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultConstVCopyInit(var ctrl: Pointer; fromObj: SOMTModuleEntryC); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultConstAssign(var ctrl: Pointer; fromObj: SOMTModuleEntryC): SOMTModuleEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultVAssign(var ctrl: Pointer; fromObj: SOMTModuleEntryC): SOMTModuleEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultConstVAssign(var ctrl: Pointer; fromObj: SOMTModuleEntryC): SOMTModuleEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somInit; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somFree; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somUninit; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetClass: SOMClass; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetClassName: {dual_owned} CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetSize: LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somIsA(aClassObj: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somIsInstanceOf(aClassObj: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somRespondsTo(mId: somId): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDispatch(out retValue: Pointer; methodId: somId; ap: va_list): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somClassDispatch(clsObj: SOMClass; out retValue: Pointer; methodId: somId; ap: va_list): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somCastObj(cls: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somResetObj: CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somPrintSelf: SOMTModuleEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDumpSelf(level: LongInt); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDumpSelfInt(level: LongInt); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}

    { Class object access and initialization }
    class function ClassObject: SOMClass; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF} // may be nil before class is created
    class function NewClass: SOMClass; // (not really new every time, but autocreated)

    { Upcasting }
    function As_SOMTEntryC: SOMTEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function As_SOMTModuleEntryC: SOMTModuleEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}

    { Downcasting }
    class function Supports(Instance: SOMObjectBase): Boolean; overload;
    class function Supports(Instance: SOMObjectBase; out Obj: SOMTModuleEntryC): Boolean; overload;

    property somtOuterModule: SOMTModuleEntryC read _get_somtOuterModule;
    property somtModuleFile: CORBAString read _get_somtModuleFile;
    property somtEntryName: CORBAString read _get_somtEntryName write _set_somtEntryName;
    property somtElementType: LongWord read _get_somtElementType write _set_somtElementType;
    property somtElementTypeName: CORBAString read _get_somtElementTypeName;
    property somtEntryComment: CORBAString read _get_somtEntryComment;
    property somtSourceLineNumber: LongWord read _get_somtSourceLineNumber;
    property somtTypeCode: TypeCode read _get_somtTypeCode;
    property somtIsReference: CORBABoolean read _get_somtIsReference;
    property somtIDLScopedName: CORBAString read _get_somtIDLScopedName;
    property somtCScopedName: CORBAString read _get_somtCScopedName;
  end;

  SOMTParameterEntryC = class(SOMObjectBase)
  private
    function _get_somtParameterDirection: somtParameterDirectionT; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtIDLParameterDeclaration: CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtCParameterDeclaration: CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtTypeObj: SOMTEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtPtrs: CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtArrayDimsString: CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtSourceText: CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtType: CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtVisibility: somtVisibilityT; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtEntryName: CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure _set_somtEntryName(somtEntryName: CORBAString); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtElementType: LongWord; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure _set_somtElementType(somtElementType: LongWord); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtElementTypeName: CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtEntryComment: CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtSourceLineNumber: LongWord; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtTypeCode: TypeCode; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtIsReference: CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtIDLScopedName: CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtCScopedName: CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
  public
    class function Create: SOMTParameterEntryC; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function InitInstance(Instance: Pointer): SOMTParameterEntryC; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function ClassType: SOMClass; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function ClassName: string; reintroduce;
    class function ClassNameIs(const Name: string): Boolean; reintroduce;
    class function InstanceSize: LongInt; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function InheritsFrom(AClass: SOMClass): Boolean; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function MethodAddress(const Name: string): Pointer; reintroduce;
    class function NewInstance: SOMTParameterEntryC; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function Clone: SOMTParameterEntryC; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtGetFirstArrayDimension: LongWord; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtGetNextArrayDimension: LongWord; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtIsArray(out size: LongInt): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtIsPointer: CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtGetModifierValue(modifierName: CORBAString): CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtGetFirstModifier(var modifierName: CORBAString; var modifierValue: CORBAString): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtGetNextModifier(var modifierName: CORBAString; var modifierValue: CORBAString): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtFormatModifier(buffer: CORBAString; name: CORBAString; value: CORBAString): LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtGetModifierList(buffer: CORBAString): LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtSetSymbolsOnEntry(emitter: SOMTEmitC; prefix: CORBAString): LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somtSetEntryStruct(var es: Pointer); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultInit(var ctrl: Pointer); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDestruct(doFree: Byte; var ctrl: Pointer); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultCopyInit(var ctrl: Pointer; fromObj: SOMTParameterEntryC); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultAssign(var ctrl: Pointer; fromObj: SOMTParameterEntryC): SOMTParameterEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultConstCopyInit(var ctrl: Pointer; fromObj: SOMTParameterEntryC); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultVCopyInit(var ctrl: Pointer; fromObj: SOMTParameterEntryC); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultConstVCopyInit(var ctrl: Pointer; fromObj: SOMTParameterEntryC); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultConstAssign(var ctrl: Pointer; fromObj: SOMTParameterEntryC): SOMTParameterEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultVAssign(var ctrl: Pointer; fromObj: SOMTParameterEntryC): SOMTParameterEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultConstVAssign(var ctrl: Pointer; fromObj: SOMTParameterEntryC): SOMTParameterEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somInit; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somFree; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somUninit; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetClass: SOMClass; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetClassName: {dual_owned} CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetSize: LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somIsA(aClassObj: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somIsInstanceOf(aClassObj: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somRespondsTo(mId: somId): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDispatch(out retValue: Pointer; methodId: somId; ap: va_list): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somClassDispatch(clsObj: SOMClass; out retValue: Pointer; methodId: somId; ap: va_list): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somCastObj(cls: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somResetObj: CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somPrintSelf: SOMTParameterEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDumpSelf(level: LongInt); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDumpSelfInt(level: LongInt); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}

    { Class object access and initialization }
    class function ClassObject: SOMClass; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF} // may be nil before class is created
    class function NewClass: SOMClass; // (not really new every time, but autocreated)

    { Upcasting }
    function As_SOMTCommonEntryC: SOMTCommonEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function As_SOMTEntryC: SOMTEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function As_SOMTParameterEntryC: SOMTParameterEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}

    { Downcasting }
    class function Supports(Instance: SOMObjectBase): Boolean; overload;
    class function Supports(Instance: SOMObjectBase; out Obj: SOMTParameterEntryC): Boolean; overload;

    property somtParameterDirection: somtParameterDirectionT read _get_somtParameterDirection;
    property somtIDLParameterDeclaration: CORBAString read _get_somtIDLParameterDeclaration;
    property somtCParameterDeclaration: CORBAString read _get_somtCParameterDeclaration;
    property somtTypeObj: SOMTEntryC read _get_somtTypeObj;
    property somtPtrs: CORBAString read _get_somtPtrs;
    property somtArrayDimsString: CORBAString read _get_somtArrayDimsString;
    property somtSourceText: CORBAString read _get_somtSourceText;
    property somtType: CORBAString read _get_somtType;
    property somtVisibility: somtVisibilityT read _get_somtVisibility;
    property somtEntryName: CORBAString read _get_somtEntryName write _set_somtEntryName;
    property somtElementType: LongWord read _get_somtElementType write _set_somtElementType;
    property somtElementTypeName: CORBAString read _get_somtElementTypeName;
    property somtEntryComment: CORBAString read _get_somtEntryComment;
    property somtSourceLineNumber: LongWord read _get_somtSourceLineNumber;
    property somtTypeCode: TypeCode read _get_somtTypeCode;
    property somtIsReference: CORBABoolean read _get_somtIsReference;
    property somtIDLScopedName: CORBAString read _get_somtIDLScopedName;
    property somtCScopedName: CORBAString read _get_somtCScopedName;
  end;

  SOMTPassthruEntryC = class(SOMObjectBase)
  private
    function _get_somtPassthruBody: CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtPassthruLanguage: CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtPassthruTarget: CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtEntryName: CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure _set_somtEntryName(somtEntryName: CORBAString); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtElementType: LongWord; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure _set_somtElementType(somtElementType: LongWord); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtElementTypeName: CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtEntryComment: CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtSourceLineNumber: LongWord; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtTypeCode: TypeCode; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtIsReference: CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtIDLScopedName: CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtCScopedName: CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
  public
    class function Create: SOMTPassthruEntryC; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function InitInstance(Instance: Pointer): SOMTPassthruEntryC; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function ClassType: SOMClass; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function ClassName: string; reintroduce;
    class function ClassNameIs(const Name: string): Boolean; reintroduce;
    class function InstanceSize: LongInt; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function InheritsFrom(AClass: SOMClass): Boolean; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function MethodAddress(const Name: string): Pointer; reintroduce;
    class function NewInstance: SOMTPassthruEntryC; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function Clone: SOMTPassthruEntryC; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtIsBeforePassthru: CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtGetModifierValue(modifierName: CORBAString): CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtGetFirstModifier(var modifierName: CORBAString; var modifierValue: CORBAString): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtGetNextModifier(var modifierName: CORBAString; var modifierValue: CORBAString): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtFormatModifier(buffer: CORBAString; name: CORBAString; value: CORBAString): LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtGetModifierList(buffer: CORBAString): LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtSetSymbolsOnEntry(emitter: SOMTEmitC; prefix: CORBAString): LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somtSetEntryStruct(var es: Pointer); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultInit(var ctrl: Pointer); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDestruct(doFree: Byte; var ctrl: Pointer); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultCopyInit(var ctrl: Pointer; fromObj: SOMTPassthruEntryC); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultAssign(var ctrl: Pointer; fromObj: SOMTPassthruEntryC): SOMTPassthruEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultConstCopyInit(var ctrl: Pointer; fromObj: SOMTPassthruEntryC); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultVCopyInit(var ctrl: Pointer; fromObj: SOMTPassthruEntryC); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultConstVCopyInit(var ctrl: Pointer; fromObj: SOMTPassthruEntryC); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultConstAssign(var ctrl: Pointer; fromObj: SOMTPassthruEntryC): SOMTPassthruEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultVAssign(var ctrl: Pointer; fromObj: SOMTPassthruEntryC): SOMTPassthruEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultConstVAssign(var ctrl: Pointer; fromObj: SOMTPassthruEntryC): SOMTPassthruEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somInit; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somFree; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somUninit; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetClass: SOMClass; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetClassName: {dual_owned} CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetSize: LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somIsA(aClassObj: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somIsInstanceOf(aClassObj: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somRespondsTo(mId: somId): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDispatch(out retValue: Pointer; methodId: somId; ap: va_list): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somClassDispatch(clsObj: SOMClass; out retValue: Pointer; methodId: somId; ap: va_list): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somCastObj(cls: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somResetObj: CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somPrintSelf: SOMTPassthruEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDumpSelf(level: LongInt); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDumpSelfInt(level: LongInt); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}

    { Class object access and initialization }
    class function ClassObject: SOMClass; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF} // may be nil before class is created
    class function NewClass: SOMClass; // (not really new every time, but autocreated)

    { Upcasting }
    function As_SOMTEntryC: SOMTEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function As_SOMTPassthruEntryC: SOMTPassthruEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}

    { Downcasting }
    class function Supports(Instance: SOMObjectBase): Boolean; overload;
    class function Supports(Instance: SOMObjectBase; out Obj: SOMTPassthruEntryC): Boolean; overload;

    property somtPassthruBody: CORBAString read _get_somtPassthruBody;
    property somtPassthruLanguage: CORBAString read _get_somtPassthruLanguage;
    property somtPassthruTarget: CORBAString read _get_somtPassthruTarget;
    property somtEntryName: CORBAString read _get_somtEntryName write _set_somtEntryName;
    property somtElementType: LongWord read _get_somtElementType write _set_somtElementType;
    property somtElementTypeName: CORBAString read _get_somtElementTypeName;
    property somtEntryComment: CORBAString read _get_somtEntryComment;
    property somtSourceLineNumber: LongWord read _get_somtSourceLineNumber;
    property somtTypeCode: TypeCode read _get_somtTypeCode;
    property somtIsReference: CORBABoolean read _get_somtIsReference;
    property somtIDLScopedName: CORBAString read _get_somtIDLScopedName;
    property somtCScopedName: CORBAString read _get_somtCScopedName;
  end;

  SOMTSequenceEntryC = class(SOMObjectBase)
  private
    function _get_somtSeqLength: LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtSeqType: SOMTEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtEntryName: CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure _set_somtEntryName(somtEntryName: CORBAString); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtElementType: LongWord; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure _set_somtElementType(somtElementType: LongWord); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtElementTypeName: CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtEntryComment: CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtSourceLineNumber: LongWord; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtTypeCode: TypeCode; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtIsReference: CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtIDLScopedName: CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtCScopedName: CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
  public
    class function Create: SOMTSequenceEntryC; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function InitInstance(Instance: Pointer): SOMTSequenceEntryC; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function ClassType: SOMClass; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function ClassName: string; reintroduce;
    class function ClassNameIs(const Name: string): Boolean; reintroduce;
    class function InstanceSize: LongInt; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function InheritsFrom(AClass: SOMClass): Boolean; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function MethodAddress(const Name: string): Pointer; reintroduce;
    class function NewInstance: SOMTSequenceEntryC; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function Clone: SOMTSequenceEntryC; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtGetModifierValue(modifierName: CORBAString): CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtGetFirstModifier(var modifierName: CORBAString; var modifierValue: CORBAString): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtGetNextModifier(var modifierName: CORBAString; var modifierValue: CORBAString): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtFormatModifier(buffer: CORBAString; name: CORBAString; value: CORBAString): LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtGetModifierList(buffer: CORBAString): LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtSetSymbolsOnEntry(emitter: SOMTEmitC; prefix: CORBAString): LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somtSetEntryStruct(var es: Pointer); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultInit(var ctrl: Pointer); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDestruct(doFree: Byte; var ctrl: Pointer); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultCopyInit(var ctrl: Pointer; fromObj: SOMTSequenceEntryC); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultAssign(var ctrl: Pointer; fromObj: SOMTSequenceEntryC): SOMTSequenceEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultConstCopyInit(var ctrl: Pointer; fromObj: SOMTSequenceEntryC); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultVCopyInit(var ctrl: Pointer; fromObj: SOMTSequenceEntryC); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultConstVCopyInit(var ctrl: Pointer; fromObj: SOMTSequenceEntryC); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultConstAssign(var ctrl: Pointer; fromObj: SOMTSequenceEntryC): SOMTSequenceEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultVAssign(var ctrl: Pointer; fromObj: SOMTSequenceEntryC): SOMTSequenceEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultConstVAssign(var ctrl: Pointer; fromObj: SOMTSequenceEntryC): SOMTSequenceEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somInit; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somFree; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somUninit; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetClass: SOMClass; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetClassName: {dual_owned} CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetSize: LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somIsA(aClassObj: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somIsInstanceOf(aClassObj: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somRespondsTo(mId: somId): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDispatch(out retValue: Pointer; methodId: somId; ap: va_list): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somClassDispatch(clsObj: SOMClass; out retValue: Pointer; methodId: somId; ap: va_list): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somCastObj(cls: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somResetObj: CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somPrintSelf: SOMTSequenceEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDumpSelf(level: LongInt); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDumpSelfInt(level: LongInt); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}

    { Class object access and initialization }
    class function ClassObject: SOMClass; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF} // may be nil before class is created
    class function NewClass: SOMClass; // (not really new every time, but autocreated)

    { Upcasting }
    function As_SOMTEntryC: SOMTEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function As_SOMTSequenceEntryC: SOMTSequenceEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}

    { Downcasting }
    class function Supports(Instance: SOMObjectBase): Boolean; overload;
    class function Supports(Instance: SOMObjectBase; out Obj: SOMTSequenceEntryC): Boolean; overload;

    property somtSeqLength: LongInt read _get_somtSeqLength;
    property somtSeqType: SOMTEntryC read _get_somtSeqType;
    property somtEntryName: CORBAString read _get_somtEntryName write _set_somtEntryName;
    property somtElementType: LongWord read _get_somtElementType write _set_somtElementType;
    property somtElementTypeName: CORBAString read _get_somtElementTypeName;
    property somtEntryComment: CORBAString read _get_somtEntryComment;
    property somtSourceLineNumber: LongWord read _get_somtSourceLineNumber;
    property somtTypeCode: TypeCode read _get_somtTypeCode;
    property somtIsReference: CORBABoolean read _get_somtIsReference;
    property somtIDLScopedName: CORBAString read _get_somtIDLScopedName;
    property somtCScopedName: CORBAString read _get_somtCScopedName;
  end;

  SOMTStringEntryC = class(SOMObjectBase)
  private
    function _get_somtStringLength: LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtEntryName: CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure _set_somtEntryName(somtEntryName: CORBAString); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtElementType: LongWord; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure _set_somtElementType(somtElementType: LongWord); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtElementTypeName: CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtEntryComment: CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtSourceLineNumber: LongWord; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtTypeCode: TypeCode; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtIsReference: CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtIDLScopedName: CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtCScopedName: CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
  public
    class function Create: SOMTStringEntryC; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function InitInstance(Instance: Pointer): SOMTStringEntryC; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function ClassType: SOMClass; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function ClassName: string; reintroduce;
    class function ClassNameIs(const Name: string): Boolean; reintroduce;
    class function InstanceSize: LongInt; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function InheritsFrom(AClass: SOMClass): Boolean; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function MethodAddress(const Name: string): Pointer; reintroduce;
    class function NewInstance: SOMTStringEntryC; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function Clone: SOMTStringEntryC; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtGetModifierValue(modifierName: CORBAString): CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtGetFirstModifier(var modifierName: CORBAString; var modifierValue: CORBAString): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtGetNextModifier(var modifierName: CORBAString; var modifierValue: CORBAString): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtFormatModifier(buffer: CORBAString; name: CORBAString; value: CORBAString): LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtGetModifierList(buffer: CORBAString): LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtSetSymbolsOnEntry(emitter: SOMTEmitC; prefix: CORBAString): LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somtSetEntryStruct(var es: Pointer); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultInit(var ctrl: Pointer); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDestruct(doFree: Byte; var ctrl: Pointer); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultCopyInit(var ctrl: Pointer; fromObj: SOMTStringEntryC); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultAssign(var ctrl: Pointer; fromObj: SOMTStringEntryC): SOMTStringEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultConstCopyInit(var ctrl: Pointer; fromObj: SOMTStringEntryC); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultVCopyInit(var ctrl: Pointer; fromObj: SOMTStringEntryC); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultConstVCopyInit(var ctrl: Pointer; fromObj: SOMTStringEntryC); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultConstAssign(var ctrl: Pointer; fromObj: SOMTStringEntryC): SOMTStringEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultVAssign(var ctrl: Pointer; fromObj: SOMTStringEntryC): SOMTStringEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultConstVAssign(var ctrl: Pointer; fromObj: SOMTStringEntryC): SOMTStringEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somInit; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somFree; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somUninit; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetClass: SOMClass; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetClassName: {dual_owned} CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetSize: LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somIsA(aClassObj: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somIsInstanceOf(aClassObj: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somRespondsTo(mId: somId): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDispatch(out retValue: Pointer; methodId: somId; ap: va_list): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somClassDispatch(clsObj: SOMClass; out retValue: Pointer; methodId: somId; ap: va_list): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somCastObj(cls: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somResetObj: CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somPrintSelf: SOMTStringEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDumpSelf(level: LongInt); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDumpSelfInt(level: LongInt); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}

    { Class object access and initialization }
    class function ClassObject: SOMClass; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF} // may be nil before class is created
    class function NewClass: SOMClass; // (not really new every time, but autocreated)

    { Upcasting }
    function As_SOMTEntryC: SOMTEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function As_SOMTStringEntryC: SOMTStringEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}

    { Downcasting }
    class function Supports(Instance: SOMObjectBase): Boolean; overload;
    class function Supports(Instance: SOMObjectBase; out Obj: SOMTStringEntryC): Boolean; overload;

    property somtStringLength: LongInt read _get_somtStringLength;
    property somtEntryName: CORBAString read _get_somtEntryName write _set_somtEntryName;
    property somtElementType: LongWord read _get_somtElementType write _set_somtElementType;
    property somtElementTypeName: CORBAString read _get_somtElementTypeName;
    property somtEntryComment: CORBAString read _get_somtEntryComment;
    property somtSourceLineNumber: LongWord read _get_somtSourceLineNumber;
    property somtTypeCode: TypeCode read _get_somtTypeCode;
    property somtIsReference: CORBABoolean read _get_somtIsReference;
    property somtIDLScopedName: CORBAString read _get_somtIDLScopedName;
    property somtCScopedName: CORBAString read _get_somtCScopedName;
  end;

  SOMTStructEntryC = class(SOMObjectBase)
  private
    function _get_somtStructClass: SOMTClassEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtIsException: CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtEntryName: CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure _set_somtEntryName(somtEntryName: CORBAString); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtElementType: LongWord; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure _set_somtElementType(somtElementType: LongWord); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtElementTypeName: CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtEntryComment: CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtSourceLineNumber: LongWord; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtTypeCode: TypeCode; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtIsReference: CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtIDLScopedName: CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtCScopedName: CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
  public
    class function Create: SOMTStructEntryC; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function InitInstance(Instance: Pointer): SOMTStructEntryC; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function ClassType: SOMClass; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function ClassName: string; reintroduce;
    class function ClassNameIs(const Name: string): Boolean; reintroduce;
    class function InstanceSize: LongInt; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function InheritsFrom(AClass: SOMClass): Boolean; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function MethodAddress(const Name: string): Pointer; reintroduce;
    class function NewInstance: SOMTStructEntryC; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function Clone: SOMTStructEntryC; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtGetFirstMember: SOMTTypedefEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtGetNextMember: SOMTTypedefEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtGetModifierValue(modifierName: CORBAString): CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtGetFirstModifier(var modifierName: CORBAString; var modifierValue: CORBAString): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtGetNextModifier(var modifierName: CORBAString; var modifierValue: CORBAString): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtFormatModifier(buffer: CORBAString; name: CORBAString; value: CORBAString): LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtGetModifierList(buffer: CORBAString): LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtSetSymbolsOnEntry(emitter: SOMTEmitC; prefix: CORBAString): LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somtSetEntryStruct(var es: Pointer); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultInit(var ctrl: Pointer); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDestruct(doFree: Byte; var ctrl: Pointer); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultCopyInit(var ctrl: Pointer; fromObj: SOMTStructEntryC); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultAssign(var ctrl: Pointer; fromObj: SOMTStructEntryC): SOMTStructEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultConstCopyInit(var ctrl: Pointer; fromObj: SOMTStructEntryC); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultVCopyInit(var ctrl: Pointer; fromObj: SOMTStructEntryC); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultConstVCopyInit(var ctrl: Pointer; fromObj: SOMTStructEntryC); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultConstAssign(var ctrl: Pointer; fromObj: SOMTStructEntryC): SOMTStructEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultVAssign(var ctrl: Pointer; fromObj: SOMTStructEntryC): SOMTStructEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultConstVAssign(var ctrl: Pointer; fromObj: SOMTStructEntryC): SOMTStructEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somInit; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somFree; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somUninit; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetClass: SOMClass; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetClassName: {dual_owned} CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetSize: LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somIsA(aClassObj: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somIsInstanceOf(aClassObj: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somRespondsTo(mId: somId): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDispatch(out retValue: Pointer; methodId: somId; ap: va_list): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somClassDispatch(clsObj: SOMClass; out retValue: Pointer; methodId: somId; ap: va_list): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somCastObj(cls: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somResetObj: CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somPrintSelf: SOMTStructEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDumpSelf(level: LongInt); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDumpSelfInt(level: LongInt); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}

    { Class object access and initialization }
    class function ClassObject: SOMClass; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF} // may be nil before class is created
    class function NewClass: SOMClass; // (not really new every time, but autocreated)

    { Upcasting }
    function As_SOMTEntryC: SOMTEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function As_SOMTStructEntryC: SOMTStructEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}

    { Downcasting }
    class function Supports(Instance: SOMObjectBase): Boolean; overload;
    class function Supports(Instance: SOMObjectBase; out Obj: SOMTStructEntryC): Boolean; overload;

    property somtStructClass: SOMTClassEntryC read _get_somtStructClass;
    property somtIsException: CORBABoolean read _get_somtIsException;
    property somtEntryName: CORBAString read _get_somtEntryName write _set_somtEntryName;
    property somtElementType: LongWord read _get_somtElementType write _set_somtElementType;
    property somtElementTypeName: CORBAString read _get_somtElementTypeName;
    property somtEntryComment: CORBAString read _get_somtEntryComment;
    property somtSourceLineNumber: LongWord read _get_somtSourceLineNumber;
    property somtTypeCode: TypeCode read _get_somtTypeCode;
    property somtIsReference: CORBABoolean read _get_somtIsReference;
    property somtIDLScopedName: CORBAString read _get_somtIDLScopedName;
    property somtCScopedName: CORBAString read _get_somtCScopedName;
  end;

  SOMTTypedefEntryC = class(SOMObjectBase)
  private
    function _get_somtTypedefType: SOMTEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtEntryName: CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure _set_somtEntryName(somtEntryName: CORBAString); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtElementType: LongWord; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure _set_somtElementType(somtElementType: LongWord); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtElementTypeName: CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtEntryComment: CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtSourceLineNumber: LongWord; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtTypeCode: TypeCode; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtIsReference: CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtIDLScopedName: CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtCScopedName: CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
  public
    class function Create: SOMTTypedefEntryC; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function InitInstance(Instance: Pointer): SOMTTypedefEntryC; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function ClassType: SOMClass; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function ClassName: string; reintroduce;
    class function ClassNameIs(const Name: string): Boolean; reintroduce;
    class function InstanceSize: LongInt; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function InheritsFrom(AClass: SOMClass): Boolean; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function MethodAddress(const Name: string): Pointer; reintroduce;
    class function NewInstance: SOMTTypedefEntryC; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function Clone: SOMTTypedefEntryC; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtGetFirstDeclarator: SOMTCommonEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtGetNextDeclarator: SOMTCommonEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtGetModifierValue(modifierName: CORBAString): CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtGetFirstModifier(var modifierName: CORBAString; var modifierValue: CORBAString): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtGetNextModifier(var modifierName: CORBAString; var modifierValue: CORBAString): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtFormatModifier(buffer: CORBAString; name: CORBAString; value: CORBAString): LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtGetModifierList(buffer: CORBAString): LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtSetSymbolsOnEntry(emitter: SOMTEmitC; prefix: CORBAString): LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somtSetEntryStruct(var es: Pointer); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultInit(var ctrl: Pointer); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDestruct(doFree: Byte; var ctrl: Pointer); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultCopyInit(var ctrl: Pointer; fromObj: SOMTTypedefEntryC); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultAssign(var ctrl: Pointer; fromObj: SOMTTypedefEntryC): SOMTTypedefEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultConstCopyInit(var ctrl: Pointer; fromObj: SOMTTypedefEntryC); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultVCopyInit(var ctrl: Pointer; fromObj: SOMTTypedefEntryC); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultConstVCopyInit(var ctrl: Pointer; fromObj: SOMTTypedefEntryC); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultConstAssign(var ctrl: Pointer; fromObj: SOMTTypedefEntryC): SOMTTypedefEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultVAssign(var ctrl: Pointer; fromObj: SOMTTypedefEntryC): SOMTTypedefEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultConstVAssign(var ctrl: Pointer; fromObj: SOMTTypedefEntryC): SOMTTypedefEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somInit; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somFree; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somUninit; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetClass: SOMClass; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetClassName: {dual_owned} CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetSize: LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somIsA(aClassObj: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somIsInstanceOf(aClassObj: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somRespondsTo(mId: somId): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDispatch(out retValue: Pointer; methodId: somId; ap: va_list): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somClassDispatch(clsObj: SOMClass; out retValue: Pointer; methodId: somId; ap: va_list): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somCastObj(cls: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somResetObj: CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somPrintSelf: SOMTTypedefEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDumpSelf(level: LongInt); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDumpSelfInt(level: LongInt); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}

    { Class object access and initialization }
    class function ClassObject: SOMClass; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF} // may be nil before class is created
    class function NewClass: SOMClass; // (not really new every time, but autocreated)

    { Upcasting }
    function As_SOMTEntryC: SOMTEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function As_SOMTTypedefEntryC: SOMTTypedefEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}

    { Downcasting }
    class function Supports(Instance: SOMObjectBase): Boolean; overload;
    class function Supports(Instance: SOMObjectBase; out Obj: SOMTTypedefEntryC): Boolean; overload;

    property somtTypedefType: SOMTEntryC read _get_somtTypedefType;
    property somtEntryName: CORBAString read _get_somtEntryName write _set_somtEntryName;
    property somtElementType: LongWord read _get_somtElementType write _set_somtElementType;
    property somtElementTypeName: CORBAString read _get_somtElementTypeName;
    property somtEntryComment: CORBAString read _get_somtEntryComment;
    property somtSourceLineNumber: LongWord read _get_somtSourceLineNumber;
    property somtTypeCode: TypeCode read _get_somtTypeCode;
    property somtIsReference: CORBABoolean read _get_somtIsReference;
    property somtIDLScopedName: CORBAString read _get_somtIDLScopedName;
    property somtCScopedName: CORBAString read _get_somtCScopedName;
  end;

  SOMTTemplateOutputC = class(SOMObjectBase)
  private
    function _get_somtCommentStyle: somtCommentStyleT; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure _set_somtCommentStyle(somtCommentStyle: somtCommentStyleT); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtLineLength: LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure _set_somtLineLength(somtLineLength: LongInt); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtCommentNewline: CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure _set_somtCommentNewline(somtCommentNewline: CORBABoolean); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
  public
    class function Create: SOMTTemplateOutputC; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function InitInstance(Instance: Pointer): SOMTTemplateOutputC; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function ClassType: SOMClass; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function ClassName: string; reintroduce;
    class function ClassNameIs(const Name: string): Boolean; reintroduce;
    class function InstanceSize: LongInt; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function InheritsFrom(AClass: SOMClass): Boolean; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function MethodAddress(const Name: string): Pointer; reintroduce;
    class function NewInstance: SOMTTemplateOutputC; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function Clone: SOMTTemplateOutputC; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtGetSymbol(name: CORBAString): CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somtSetSymbol(name: CORBAString; value: CORBAString); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somtSetSymbolCopyName(name: CORBAString; value: CORBAString); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somtSetSymbolCopyValue(name: CORBAString; value: CORBAString); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somtSetSymbolCopyBoth(name: CORBAString; value: CORBAString); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtCheckSymbol(name: CORBAString): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somtSetOutputFile(var fp{: opaque SOM_FILE}); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somto(tmplt: CORBAString); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somtOutputComment(comment: CORBAString); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somtOutputSection(sectionName: CORBAString); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somtAddSectionDefinitions(defString: CORBAString); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somtReadSectionDefinitions(var fp{: opaque SOM_FILE}); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtExpandSymbol(s: CORBAString; buf: CORBAString): CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultInit(var ctrl: Pointer); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDestruct(doFree: Byte; var ctrl: Pointer); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultCopyInit(var ctrl: Pointer; fromObj: SOMTTemplateOutputC); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultAssign(var ctrl: Pointer; fromObj: SOMTTemplateOutputC): SOMTTemplateOutputC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultConstCopyInit(var ctrl: Pointer; fromObj: SOMTTemplateOutputC); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultVCopyInit(var ctrl: Pointer; fromObj: SOMTTemplateOutputC); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultConstVCopyInit(var ctrl: Pointer; fromObj: SOMTTemplateOutputC); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultConstAssign(var ctrl: Pointer; fromObj: SOMTTemplateOutputC): SOMTTemplateOutputC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultVAssign(var ctrl: Pointer; fromObj: SOMTTemplateOutputC): SOMTTemplateOutputC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultConstVAssign(var ctrl: Pointer; fromObj: SOMTTemplateOutputC): SOMTTemplateOutputC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somInit; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somFree; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somUninit; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetClass: SOMClass; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetClassName: {dual_owned} CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetSize: LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somIsA(aClassObj: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somIsInstanceOf(aClassObj: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somRespondsTo(mId: somId): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDispatch(out retValue: Pointer; methodId: somId; ap: va_list): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somClassDispatch(clsObj: SOMClass; out retValue: Pointer; methodId: somId; ap: va_list): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somCastObj(cls: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somResetObj: CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somPrintSelf: SOMTTemplateOutputC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDumpSelf(level: LongInt); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDumpSelfInt(level: LongInt); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}

    { Class object access and initialization }
    class function ClassObject: SOMClass; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF} // may be nil before class is created
    class function NewClass: SOMClass; // (not really new every time, but autocreated)

    { Upcasting }
    function As_SOMTTemplateOutputC: SOMTTemplateOutputC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}

    { Downcasting }
    class function Supports(Instance: SOMObjectBase): Boolean; overload;
    class function Supports(Instance: SOMObjectBase; out Obj: SOMTTemplateOutputC): Boolean; overload;

    property somtCommentStyle: somtCommentStyleT read _get_somtCommentStyle write _set_somtCommentStyle;
    property somtLineLength: LongInt read _get_somtLineLength write _set_somtLineLength;
    property somtCommentNewline: CORBABoolean read _get_somtCommentNewline write _set_somtCommentNewline;
  end;

  PSOMTUnionEntryC_somtCaseEntry = ^SOMTUnionEntryC_somtCaseEntry;
  SOMTUnionEntryC = class(SOMObjectBase)
  private
    function _get_somtSwitchType: SOMTEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtEntryName: CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure _set_somtEntryName(somtEntryName: CORBAString); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtElementType: LongWord; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure _set_somtElementType(somtElementType: LongWord); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtElementTypeName: CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtEntryComment: CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtSourceLineNumber: LongWord; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtTypeCode: TypeCode; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtIsReference: CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtIDLScopedName: CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtCScopedName: CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
  public
    class function Create: SOMTUnionEntryC; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function InitInstance(Instance: Pointer): SOMTUnionEntryC; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function ClassType: SOMClass; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function ClassName: string; reintroduce;
    class function ClassNameIs(const Name: string): Boolean; reintroduce;
    class function InstanceSize: LongInt; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function InheritsFrom(AClass: SOMClass): Boolean; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function MethodAddress(const Name: string): Pointer; reintroduce;
    class function NewInstance: SOMTUnionEntryC; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function Clone: SOMTUnionEntryC; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtGetFirstCaseEntry: PSOMTUnionEntryC_somtCaseEntry; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtGetNextCaseEntry: PSOMTUnionEntryC_somtCaseEntry; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtGetModifierValue(modifierName: CORBAString): CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtGetFirstModifier(var modifierName: CORBAString; var modifierValue: CORBAString): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtGetNextModifier(var modifierName: CORBAString; var modifierValue: CORBAString): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtFormatModifier(buffer: CORBAString; name: CORBAString; value: CORBAString): LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtGetModifierList(buffer: CORBAString): LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtSetSymbolsOnEntry(emitter: SOMTEmitC; prefix: CORBAString): LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somtSetEntryStruct(var es: Pointer); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultInit(var ctrl: Pointer); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDestruct(doFree: Byte; var ctrl: Pointer); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultCopyInit(var ctrl: Pointer; fromObj: SOMTUnionEntryC); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultAssign(var ctrl: Pointer; fromObj: SOMTUnionEntryC): SOMTUnionEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultConstCopyInit(var ctrl: Pointer; fromObj: SOMTUnionEntryC); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultVCopyInit(var ctrl: Pointer; fromObj: SOMTUnionEntryC); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultConstVCopyInit(var ctrl: Pointer; fromObj: SOMTUnionEntryC); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultConstAssign(var ctrl: Pointer; fromObj: SOMTUnionEntryC): SOMTUnionEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultVAssign(var ctrl: Pointer; fromObj: SOMTUnionEntryC): SOMTUnionEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultConstVAssign(var ctrl: Pointer; fromObj: SOMTUnionEntryC): SOMTUnionEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somInit; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somFree; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somUninit; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetClass: SOMClass; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetClassName: {dual_owned} CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetSize: LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somIsA(aClassObj: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somIsInstanceOf(aClassObj: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somRespondsTo(mId: somId): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDispatch(out retValue: Pointer; methodId: somId; ap: va_list): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somClassDispatch(clsObj: SOMClass; out retValue: Pointer; methodId: somId; ap: va_list): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somCastObj(cls: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somResetObj: CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somPrintSelf: SOMTUnionEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDumpSelf(level: LongInt); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDumpSelfInt(level: LongInt); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}

    { Class object access and initialization }
    class function ClassObject: SOMClass; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF} // may be nil before class is created
    class function NewClass: SOMClass; // (not really new every time, but autocreated)

    { Upcasting }
    function As_SOMTEntryC: SOMTEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function As_SOMTUnionEntryC: SOMTUnionEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}

    { Downcasting }
    class function Supports(Instance: SOMObjectBase): Boolean; overload;
    class function Supports(Instance: SOMObjectBase; out Obj: SOMTUnionEntryC): Boolean; overload;

    property somtSwitchType: SOMTEntryC read _get_somtSwitchType;
    property somtEntryName: CORBAString read _get_somtEntryName write _set_somtEntryName;
    property somtElementType: LongWord read _get_somtElementType write _set_somtElementType;
    property somtElementTypeName: CORBAString read _get_somtElementTypeName;
    property somtEntryComment: CORBAString read _get_somtEntryComment;
    property somtSourceLineNumber: LongWord read _get_somtSourceLineNumber;
    property somtTypeCode: TypeCode read _get_somtTypeCode;
    property somtIsReference: CORBABoolean read _get_somtIsReference;
    property somtIDLScopedName: CORBAString read _get_somtIDLScopedName;
    property somtCScopedName: CORBAString read _get_somtCScopedName;
  end;

  SOMTUserDefinedTypeEntryC = class(SOMObjectBase)
  private
    function _get_somtOriginalTypedef: SOMTTypedefEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtBaseTypeObj: SOMTEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtTypeObj: SOMTEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtPtrs: CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtArrayDimsString: CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtSourceText: CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtType: CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtVisibility: somtVisibilityT; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtEntryName: CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure _set_somtEntryName(somtEntryName: CORBAString); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtElementType: LongWord; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure _set_somtElementType(somtElementType: LongWord); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtElementTypeName: CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtEntryComment: CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtSourceLineNumber: LongWord; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtTypeCode: TypeCode; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtIsReference: CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtIDLScopedName: CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somtCScopedName: CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
  public
    class function Create: SOMTUserDefinedTypeEntryC; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function InitInstance(Instance: Pointer): SOMTUserDefinedTypeEntryC; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function ClassType: SOMClass; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function ClassName: string; reintroduce;
    class function ClassNameIs(const Name: string): Boolean; reintroduce;
    class function InstanceSize: LongInt; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function InheritsFrom(AClass: SOMClass): Boolean; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function MethodAddress(const Name: string): Pointer; reintroduce;
    class function NewInstance: SOMTUserDefinedTypeEntryC; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function Clone: SOMTUserDefinedTypeEntryC; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtGetFirstArrayDimension: LongWord; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtGetNextArrayDimension: LongWord; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtIsArray(out size: LongInt): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtIsPointer: CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtGetModifierValue(modifierName: CORBAString): CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtGetFirstModifier(var modifierName: CORBAString; var modifierValue: CORBAString): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtGetNextModifier(var modifierName: CORBAString; var modifierValue: CORBAString): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtFormatModifier(buffer: CORBAString; name: CORBAString; value: CORBAString): LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtGetModifierList(buffer: CORBAString): LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somtSetSymbolsOnEntry(emitter: SOMTEmitC; prefix: CORBAString): LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somtSetEntryStruct(var es: Pointer); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultInit(var ctrl: Pointer); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDestruct(doFree: Byte; var ctrl: Pointer); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultCopyInit(var ctrl: Pointer; fromObj: SOMTUserDefinedTypeEntryC); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultAssign(var ctrl: Pointer; fromObj: SOMTUserDefinedTypeEntryC): SOMTUserDefinedTypeEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultConstCopyInit(var ctrl: Pointer; fromObj: SOMTUserDefinedTypeEntryC); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultVCopyInit(var ctrl: Pointer; fromObj: SOMTUserDefinedTypeEntryC); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultConstVCopyInit(var ctrl: Pointer; fromObj: SOMTUserDefinedTypeEntryC); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultConstAssign(var ctrl: Pointer; fromObj: SOMTUserDefinedTypeEntryC): SOMTUserDefinedTypeEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultVAssign(var ctrl: Pointer; fromObj: SOMTUserDefinedTypeEntryC): SOMTUserDefinedTypeEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultConstVAssign(var ctrl: Pointer; fromObj: SOMTUserDefinedTypeEntryC): SOMTUserDefinedTypeEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somInit; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somFree; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somUninit; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetClass: SOMClass; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetClassName: {dual_owned} CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetSize: LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somIsA(aClassObj: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somIsInstanceOf(aClassObj: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somRespondsTo(mId: somId): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDispatch(out retValue: Pointer; methodId: somId; ap: va_list): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somClassDispatch(clsObj: SOMClass; out retValue: Pointer; methodId: somId; ap: va_list): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somCastObj(cls: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somResetObj: CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somPrintSelf: SOMTUserDefinedTypeEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDumpSelf(level: LongInt); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDumpSelfInt(level: LongInt); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}

    { Class object access and initialization }
    class function ClassObject: SOMClass; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF} // may be nil before class is created
    class function NewClass: SOMClass; // (not really new every time, but autocreated)

    { Upcasting }
    function As_SOMTCommonEntryC: SOMTCommonEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function As_SOMTEntryC: SOMTEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function As_SOMTUserDefinedTypeEntryC: SOMTUserDefinedTypeEntryC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}

    { Downcasting }
    class function Supports(Instance: SOMObjectBase): Boolean; overload;
    class function Supports(Instance: SOMObjectBase; out Obj: SOMTUserDefinedTypeEntryC): Boolean; overload;

    property somtOriginalTypedef: SOMTTypedefEntryC read _get_somtOriginalTypedef;
    property somtBaseTypeObj: SOMTEntryC read _get_somtBaseTypeObj;
    property somtTypeObj: SOMTEntryC read _get_somtTypeObj;
    property somtPtrs: CORBAString read _get_somtPtrs;
    property somtArrayDimsString: CORBAString read _get_somtArrayDimsString;
    property somtSourceText: CORBAString read _get_somtSourceText;
    property somtType: CORBAString read _get_somtType;
    property somtVisibility: somtVisibilityT read _get_somtVisibility;
    property somtEntryName: CORBAString read _get_somtEntryName write _set_somtEntryName;
    property somtElementType: LongWord read _get_somtElementType write _set_somtElementType;
    property somtElementTypeName: CORBAString read _get_somtElementTypeName;
    property somtEntryComment: CORBAString read _get_somtEntryComment;
    property somtSourceLineNumber: LongWord read _get_somtSourceLineNumber;
    property somtTypeCode: TypeCode read _get_somtTypeCode;
    property somtIsReference: CORBABoolean read _get_somtIsReference;
    property somtIDLScopedName: CORBAString read _get_somtIDLScopedName;
    property somtCScopedName: CORBAString read _get_somtCScopedName;
  end;

  SOMDServerMgr = class(SOMObjectBase)
  public
    class function Create: SOMDServerMgr; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function InitInstance(Instance: Pointer): SOMDServerMgr; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function ClassType: SOMClass; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function ClassName: string; reintroduce;
    class function ClassNameIs(const Name: string): Boolean; reintroduce;
    class function InstanceSize: LongInt; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function InheritsFrom(AClass: SOMClass): Boolean; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function MethodAddress(const Name: string): Pointer; reintroduce;
    class function NewInstance: SOMDServerMgr; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function Clone: SOMDServerMgr; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somdShutdownServer(server_alias: CORBAString): LongWord; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somdStartServer(server_alias: CORBAString): LongWord; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somdRestartServer(server_alias: CORBAString): LongWord; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somdListServer(server_alias: CORBAString): LongWord; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somdDisableServer(server_alias: CORBAString): LongWord; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somdEnableServer(server_alias: CORBAString): LongWord; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somdIsServerEnabled(impldef: ImplementationDef): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultInit(var ctrl: Pointer); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDestruct(doFree: Byte; var ctrl: Pointer); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultCopyInit(var ctrl: Pointer; fromObj: SOMDServerMgr); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultAssign(var ctrl: Pointer; fromObj: SOMDServerMgr): SOMDServerMgr; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultConstCopyInit(var ctrl: Pointer; fromObj: SOMDServerMgr); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultVCopyInit(var ctrl: Pointer; fromObj: SOMDServerMgr); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultConstVCopyInit(var ctrl: Pointer; fromObj: SOMDServerMgr); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultConstAssign(var ctrl: Pointer; fromObj: SOMDServerMgr): SOMDServerMgr; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultVAssign(var ctrl: Pointer; fromObj: SOMDServerMgr): SOMDServerMgr; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultConstVAssign(var ctrl: Pointer; fromObj: SOMDServerMgr): SOMDServerMgr; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somInit; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somFree; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somUninit; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetClass: SOMClass; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetClassName: {dual_owned} CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetSize: LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somIsA(aClassObj: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somIsInstanceOf(aClassObj: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somRespondsTo(mId: somId): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDispatch(out retValue: Pointer; methodId: somId; ap: va_list): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somClassDispatch(clsObj: SOMClass; out retValue: Pointer; methodId: somId; ap: va_list): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somCastObj(cls: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somResetObj: CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somPrintSelf: SOMDServerMgr; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDumpSelf(level: LongInt); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDumpSelfInt(level: LongInt); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}

    { Class object access and initialization }
    class function ClassObject: SOMClass; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF} // may be nil before class is created
    class function NewClass: SOMClass; // (not really new every time, but autocreated)

    { Upcasting }
    function As_SOMDServerMgr: SOMDServerMgr; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}

    { Downcasting }
    class function Supports(Instance: SOMObjectBase): Boolean; overload;
    class function Supports(Instance: SOMObjectBase; out Obj: SOMDServerMgr): Boolean; overload;

  end;

  SOMESinkEvent = class(SOMObjectBase)
  public
    class function Create: SOMESinkEvent; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function InitInstance(Instance: Pointer): SOMESinkEvent; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function ClassType: SOMClass; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function ClassName: string; reintroduce;
    class function ClassNameIs(const Name: string): Boolean; reintroduce;
    class function InstanceSize: LongInt; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function InheritsFrom(AClass: SOMClass): Boolean; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function MethodAddress(const Name: string): Pointer; reintroduce;
    class function NewInstance: SOMESinkEvent; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function Clone: SOMESinkEvent; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somevGetEventSink: LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somevSetEventSink(sink: LongInt); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somevGetEventTime: LongWord; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somevGetEventType: LongWord; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somevSetEventTime(time: LongWord); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somevSetEventType(SOM_type: LongWord); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultInit(var ctrl: Pointer); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDestruct(doFree: Byte; var ctrl: Pointer); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultCopyInit(var ctrl: Pointer; fromObj: SOMESinkEvent); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultAssign(var ctrl: Pointer; fromObj: SOMESinkEvent): SOMESinkEvent; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultConstCopyInit(var ctrl: Pointer; fromObj: SOMESinkEvent); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultVCopyInit(var ctrl: Pointer; fromObj: SOMESinkEvent); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultConstVCopyInit(var ctrl: Pointer; fromObj: SOMESinkEvent); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultConstAssign(var ctrl: Pointer; fromObj: SOMESinkEvent): SOMESinkEvent; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultVAssign(var ctrl: Pointer; fromObj: SOMESinkEvent): SOMESinkEvent; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultConstVAssign(var ctrl: Pointer; fromObj: SOMESinkEvent): SOMESinkEvent; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somInit; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somFree; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somUninit; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetClass: SOMClass; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetClassName: {dual_owned} CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetSize: LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somIsA(aClassObj: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somIsInstanceOf(aClassObj: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somRespondsTo(mId: somId): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDispatch(out retValue: Pointer; methodId: somId; ap: va_list): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somClassDispatch(clsObj: SOMClass; out retValue: Pointer; methodId: somId; ap: va_list): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somCastObj(cls: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somResetObj: CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somPrintSelf: SOMESinkEvent; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDumpSelf(level: LongInt); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDumpSelfInt(level: LongInt); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}

    { Class object access and initialization }
    class function ClassObject: SOMClass; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF} // may be nil before class is created
    class function NewClass: SOMClass; // (not really new every time, but autocreated)

    { Upcasting }
    function As_SOMEEvent: SOMEEvent; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function As_SOMESinkEvent: SOMESinkEvent; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}

    { Downcasting }
    class function Supports(Instance: SOMObjectBase): Boolean; overload;
    class function Supports(Instance: SOMObjectBase; out Obj: SOMESinkEvent): Boolean; overload;

  end;

  PsomClassDataStructure = ^somClassDataStructure;
  SOMClass = class(SOMObjectBase)
  private
    function _get_somDataAlignment: LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somInstanceDataOffsets: _IDL_Sequence_SOMClass_somOffsetInfo; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somDirectInitClasses: _IDL_Sequence_SOMClass; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure _set_somDirectInitClasses(const somDirectInitClasses: _IDL_Sequence_SOMClass); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somClassAllocate: PPointer; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somClassDeallocate: PPointer; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
  public
    class function Create: SOMClass; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function InitInstance(Instance: Pointer): SOMClass; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function ClassType: SOMClass; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function ClassName: string; reintroduce;
    class function ClassNameIs(const Name: string): Boolean; reintroduce;
    class function InstanceSize: LongInt; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function InheritsFrom(AClass: SOMClass): Boolean; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function MethodAddress(const Name: string): Pointer; reintroduce;
    class function NewInstance: SOMClass; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function Clone: SOMClass; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somNew: SOMObject; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somNewNoInit: SOMObject; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somRenew(obj: Pointer): SOMObject; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somRenewNoInit(obj: Pointer): SOMObject; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somRenewNoZero(obj: Pointer): SOMObject; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somRenewNoInitNoZero(obj: Pointer): SOMObject; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somAllocate(size: LongInt): CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDeallocate(memptr: CORBAString); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetInstanceInitMask(out ctrl: Pointer): PByte; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetInstanceDestructionMask(out ctrl: Pointer): PByte; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetInstanceAssignmentMask(out ctrl: Pointer): PByte; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somInitClass(className: CORBAString; parentClass: SOMClass; dataSize: LongInt; maxStaticMethods: LongInt; majorVersion: LongInt; minorVersion: LongInt); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somInitMIClass(inherit_vars: LongInt; className: CORBAString; const parentClasses: _IDL_Sequence_SOMClass; dataSize: LongInt; dataAlignment: LongInt; maxStaticMethods: LongInt; majorVersion: LongInt; minorVersion: LongInt); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somAddStaticMethod(methodId: somId; methodDescriptor: somId; method: Pointer; redispatchStub: Pointer; applyStub: Pointer): Pointer; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somAddDynamicMethod(methodId: somId; methodDescriptor: somId; method: Pointer; applyStub: Pointer); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somOverrideSMethod(methodId: somId; method: Pointer); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somClassReady; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetClassData: PsomClassDataStructure; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somSetClassData(const cds: somClassDataStructure); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetClassMtab: PsomMethodTab; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetInstanceOffset: LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetInstancePartSize: LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetInstanceSize: LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetInstanceToken: Pointer; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetMemberToken(memberOffset: LongInt; instanceToken: Pointer): Pointer; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetMethodData(methodId: somId; out md: somMethodDataStruct): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetRdStub(methodId: somId): PPointer; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetMethodDescriptor(methodId: somId): somId; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetMethodIndex(id: somId): LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetMethodToken(methodId: somId): Pointer; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetName: {dual_owned} CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetNthMethodData(n: LongInt; out md: somMethodDataStruct): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetNthMethodInfo(n: LongInt; out descriptor: somId): somId; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetNumMethods: LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetNumStaticMethods: LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetParent: SOMClass; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetParents: {dual_owned} _IDL_Sequence_SOMClass; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetPClsMtab: PsomMethodTabList; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetPClsMtabs: PsomMethodTabList; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somGetVersionNumbers(out majorVersion: LongInt; out minorVersion: LongInt); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somSetMethodDescriptor(methodId: somId; descriptor: somId): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somFindMethod(methodId: somId; out m: Pointer): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somFindMethodOk(methodId: somId; out m: Pointer): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somFindSMethod(methodId: somId): Pointer; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somFindSMethodOk(methodId: somId): Pointer; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somLookupMethod(methodId: somId): Pointer; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somCheckVersion(majorVersion: LongInt; minorVersion: LongInt): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDescendedFrom(aClassObj: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somSupportsMethod(mId: somId): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefinedMethod(method: Pointer): Pointer; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somOverrideMtab; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultInit(var ctrl: Pointer); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDestruct(doFree: Byte; var ctrl: Pointer); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultCopyInit(var ctrl: Pointer; fromObj: SOMClass); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultAssign(var ctrl: Pointer; fromObj: SOMClass): SOMClass; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultConstCopyInit(var ctrl: Pointer; fromObj: SOMClass); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultVCopyInit(var ctrl: Pointer; fromObj: SOMClass); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultConstVCopyInit(var ctrl: Pointer; fromObj: SOMClass); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultConstAssign(var ctrl: Pointer; fromObj: SOMClass): SOMClass; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultVAssign(var ctrl: Pointer; fromObj: SOMClass): SOMClass; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultConstVAssign(var ctrl: Pointer; fromObj: SOMClass): SOMClass; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somInit; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somFree; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somUninit; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetClass: SOMClass; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetClassName: {dual_owned} CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetSize: LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somIsA(aClassObj: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somIsInstanceOf(aClassObj: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somRespondsTo(mId: somId): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDispatch(out retValue: Pointer; methodId: somId; ap: va_list): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somClassDispatch(clsObj: SOMClass; out retValue: Pointer; methodId: somId; ap: va_list): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somCastObj(cls: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somResetObj: CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somPrintSelf: SOMClass; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDumpSelf(level: LongInt); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDumpSelfInt(level: LongInt); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}

    { Class object access and initialization }
    class function ClassObject: SOMClass; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF} // may be nil before class is created
    class function NewClass: SOMClass; // (not really new every time, but autocreated)

    { Upcasting }
    function As_SOMClass: SOMClass; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}

    { Downcasting }
    class function Supports(Instance: SOMObjectBase): Boolean; overload;
    class function Supports(Instance: SOMObjectBase; out Obj: SOMClass): Boolean; overload;

    property somDataAlignment: LongInt read _get_somDataAlignment;
    property somInstanceDataOffsets: _IDL_Sequence_SOMClass_somOffsetInfo read _get_somInstanceDataOffsets;
    property somDirectInitClasses: _IDL_Sequence_SOMClass read _get_somDirectInitClasses write _set_somDirectInitClasses;
    property somClassAllocate: PPointer read _get_somClassAllocate;
    property somClassDeallocate: PPointer read _get_somClassDeallocate;
  end;

  SOMMSingleInstance = class(SOMObjectBase)
  private
    function _get_somDataAlignment: LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somInstanceDataOffsets: _IDL_Sequence_SOMClass_somOffsetInfo; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somDirectInitClasses: _IDL_Sequence_SOMClass; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure _set_somDirectInitClasses(const somDirectInitClasses: _IDL_Sequence_SOMClass); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somClassAllocate: PPointer; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somClassDeallocate: PPointer; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
  public
    class function Create: SOMMSingleInstance; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function InitInstance(Instance: Pointer): SOMMSingleInstance; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function ClassType: SOMClass; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function ClassName: string; reintroduce;
    class function ClassNameIs(const Name: string): Boolean; reintroduce;
    class function InstanceSize: LongInt; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function InheritsFrom(AClass: SOMClass): Boolean; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function MethodAddress(const Name: string): Pointer; reintroduce;
    class function NewInstance: SOMMSingleInstance; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function Clone: SOMMSingleInstance; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function sommGetSingleInstance: SOMObject; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure sommFreeSingleInstance; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somNew: SOMObject; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somNewNoInit: SOMObject; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somRenew(obj: Pointer): SOMObject; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somRenewNoInit(obj: Pointer): SOMObject; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somRenewNoZero(obj: Pointer): SOMObject; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somRenewNoInitNoZero(obj: Pointer): SOMObject; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somAllocate(size: LongInt): CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDeallocate(memptr: CORBAString); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetInstanceInitMask(out ctrl: Pointer): PByte; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetInstanceDestructionMask(out ctrl: Pointer): PByte; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetInstanceAssignmentMask(out ctrl: Pointer): PByte; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somInitClass(className: CORBAString; parentClass: SOMClass; dataSize: LongInt; maxStaticMethods: LongInt; majorVersion: LongInt; minorVersion: LongInt); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somInitMIClass(inherit_vars: LongInt; className: CORBAString; const parentClasses: _IDL_Sequence_SOMClass; dataSize: LongInt; dataAlignment: LongInt; maxStaticMethods: LongInt; majorVersion: LongInt; minorVersion: LongInt); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somAddStaticMethod(methodId: somId; methodDescriptor: somId; method: Pointer; redispatchStub: Pointer; applyStub: Pointer): Pointer; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somAddDynamicMethod(methodId: somId; methodDescriptor: somId; method: Pointer; applyStub: Pointer); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somOverrideSMethod(methodId: somId; method: Pointer); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somClassReady; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetClassData: PsomClassDataStructure; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somSetClassData(const cds: somClassDataStructure); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetClassMtab: PsomMethodTab; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetInstanceOffset: LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetInstancePartSize: LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetInstanceSize: LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetInstanceToken: Pointer; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetMemberToken(memberOffset: LongInt; instanceToken: Pointer): Pointer; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetMethodData(methodId: somId; out md: somMethodDataStruct): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetRdStub(methodId: somId): PPointer; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetMethodDescriptor(methodId: somId): somId; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetMethodIndex(id: somId): LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetMethodToken(methodId: somId): Pointer; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetName: {dual_owned} CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetNthMethodData(n: LongInt; out md: somMethodDataStruct): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetNthMethodInfo(n: LongInt; out descriptor: somId): somId; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetNumMethods: LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetNumStaticMethods: LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetParent: SOMClass; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetParents: {dual_owned} _IDL_Sequence_SOMClass; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetPClsMtab: PsomMethodTabList; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetPClsMtabs: PsomMethodTabList; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somGetVersionNumbers(out majorVersion: LongInt; out minorVersion: LongInt); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somSetMethodDescriptor(methodId: somId; descriptor: somId): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somFindMethod(methodId: somId; out m: Pointer): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somFindMethodOk(methodId: somId; out m: Pointer): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somFindSMethod(methodId: somId): Pointer; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somFindSMethodOk(methodId: somId): Pointer; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somLookupMethod(methodId: somId): Pointer; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somCheckVersion(majorVersion: LongInt; minorVersion: LongInt): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDescendedFrom(aClassObj: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somSupportsMethod(mId: somId): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefinedMethod(method: Pointer): Pointer; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somOverrideMtab; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultInit(var ctrl: Pointer); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDestruct(doFree: Byte; var ctrl: Pointer); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultCopyInit(var ctrl: Pointer; fromObj: SOMMSingleInstance); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultAssign(var ctrl: Pointer; fromObj: SOMMSingleInstance): SOMMSingleInstance; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultConstCopyInit(var ctrl: Pointer; fromObj: SOMMSingleInstance); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultVCopyInit(var ctrl: Pointer; fromObj: SOMMSingleInstance); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultConstVCopyInit(var ctrl: Pointer; fromObj: SOMMSingleInstance); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultConstAssign(var ctrl: Pointer; fromObj: SOMMSingleInstance): SOMMSingleInstance; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultVAssign(var ctrl: Pointer; fromObj: SOMMSingleInstance): SOMMSingleInstance; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultConstVAssign(var ctrl: Pointer; fromObj: SOMMSingleInstance): SOMMSingleInstance; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somInit; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somFree; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somUninit; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetClass: SOMClass; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetClassName: {dual_owned} CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetSize: LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somIsA(aClassObj: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somIsInstanceOf(aClassObj: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somRespondsTo(mId: somId): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDispatch(out retValue: Pointer; methodId: somId; ap: va_list): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somClassDispatch(clsObj: SOMClass; out retValue: Pointer; methodId: somId; ap: va_list): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somCastObj(cls: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somResetObj: CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somPrintSelf: SOMMSingleInstance; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDumpSelf(level: LongInt); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDumpSelfInt(level: LongInt); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}

    { Class object access and initialization }
    class function ClassObject: SOMClass; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF} // may be nil before class is created
    class function NewClass: SOMClass; // (not really new every time, but autocreated)

    { Upcasting }
    function As_SOMClass: SOMClass; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function As_SOMMSingleInstance: SOMMSingleInstance; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}

    { Downcasting }
    class function Supports(Instance: SOMObjectBase): Boolean; overload;
    class function Supports(Instance: SOMObjectBase; out Obj: SOMMSingleInstance): Boolean; overload;

    property somDataAlignment: LongInt read _get_somDataAlignment;
    property somInstanceDataOffsets: _IDL_Sequence_SOMClass_somOffsetInfo read _get_somInstanceDataOffsets;
    property somDirectInitClasses: _IDL_Sequence_SOMClass read _get_somDirectInitClasses write _set_somDirectInitClasses;
    property somClassAllocate: PPointer read _get_somClassAllocate;
    property somClassDeallocate: PPointer read _get_somClassDeallocate;
  end;

  SOMMBeforeAfter = class(SOMObjectBase)
  private
    function _get_somDataAlignment: LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somInstanceDataOffsets: _IDL_Sequence_SOMClass_somOffsetInfo; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somDirectInitClasses: _IDL_Sequence_SOMClass; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure _set_somDirectInitClasses(const somDirectInitClasses: _IDL_Sequence_SOMClass); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somClassAllocate: PPointer; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somClassDeallocate: PPointer; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
  public
    class function Create: SOMMBeforeAfter; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function InitInstance(Instance: Pointer): SOMMBeforeAfter; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function ClassType: SOMClass; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function ClassName: string; reintroduce;
    class function ClassNameIs(const Name: string): Boolean; reintroduce;
    class function InstanceSize: LongInt; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function InheritsFrom(AClass: SOMClass): Boolean; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function MethodAddress(const Name: string): Pointer; reintroduce;
    class function NewInstance: SOMMBeforeAfter; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function Clone: SOMMBeforeAfter; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function sommBeforeMethod(SOM_object: SOMObject; methodId: somId; ap: va_list): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure sommAfterMethod(SOM_object: SOMObject; methodId: somId; returnedvalue: Pointer; ap: va_list); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somNew: SOMObject; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somNewNoInit: SOMObject; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somRenew(obj: Pointer): SOMObject; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somRenewNoInit(obj: Pointer): SOMObject; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somRenewNoZero(obj: Pointer): SOMObject; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somRenewNoInitNoZero(obj: Pointer): SOMObject; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somAllocate(size: LongInt): CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDeallocate(memptr: CORBAString); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetInstanceInitMask(out ctrl: Pointer): PByte; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetInstanceDestructionMask(out ctrl: Pointer): PByte; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetInstanceAssignmentMask(out ctrl: Pointer): PByte; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somInitClass(className: CORBAString; parentClass: SOMClass; dataSize: LongInt; maxStaticMethods: LongInt; majorVersion: LongInt; minorVersion: LongInt); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somInitMIClass(inherit_vars: LongInt; className: CORBAString; const parentClasses: _IDL_Sequence_SOMClass; dataSize: LongInt; dataAlignment: LongInt; maxStaticMethods: LongInt; majorVersion: LongInt; minorVersion: LongInt); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somAddStaticMethod(methodId: somId; methodDescriptor: somId; method: Pointer; redispatchStub: Pointer; applyStub: Pointer): Pointer; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somAddDynamicMethod(methodId: somId; methodDescriptor: somId; method: Pointer; applyStub: Pointer); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somOverrideSMethod(methodId: somId; method: Pointer); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somClassReady; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetClassData: PsomClassDataStructure; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somSetClassData(const cds: somClassDataStructure); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetClassMtab: PsomMethodTab; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetInstanceOffset: LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetInstancePartSize: LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetInstanceSize: LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetInstanceToken: Pointer; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetMemberToken(memberOffset: LongInt; instanceToken: Pointer): Pointer; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetMethodData(methodId: somId; out md: somMethodDataStruct): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetRdStub(methodId: somId): PPointer; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetMethodDescriptor(methodId: somId): somId; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetMethodIndex(id: somId): LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetMethodToken(methodId: somId): Pointer; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetName: {dual_owned} CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetNthMethodData(n: LongInt; out md: somMethodDataStruct): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetNthMethodInfo(n: LongInt; out descriptor: somId): somId; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetNumMethods: LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetNumStaticMethods: LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetParent: SOMClass; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetParents: {dual_owned} _IDL_Sequence_SOMClass; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetPClsMtab: PsomMethodTabList; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetPClsMtabs: PsomMethodTabList; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somGetVersionNumbers(out majorVersion: LongInt; out minorVersion: LongInt); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somSetMethodDescriptor(methodId: somId; descriptor: somId): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somFindMethod(methodId: somId; out m: Pointer): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somFindMethodOk(methodId: somId; out m: Pointer): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somFindSMethod(methodId: somId): Pointer; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somFindSMethodOk(methodId: somId): Pointer; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somLookupMethod(methodId: somId): Pointer; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somCheckVersion(majorVersion: LongInt; minorVersion: LongInt): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDescendedFrom(aClassObj: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somSupportsMethod(mId: somId): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefinedMethod(method: Pointer): Pointer; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somOverrideMtab; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultInit(var ctrl: Pointer); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDestruct(doFree: Byte; var ctrl: Pointer); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultCopyInit(var ctrl: Pointer; fromObj: SOMMBeforeAfter); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultAssign(var ctrl: Pointer; fromObj: SOMMBeforeAfter): SOMMBeforeAfter; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultConstCopyInit(var ctrl: Pointer; fromObj: SOMMBeforeAfter); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultVCopyInit(var ctrl: Pointer; fromObj: SOMMBeforeAfter); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultConstVCopyInit(var ctrl: Pointer; fromObj: SOMMBeforeAfter); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultConstAssign(var ctrl: Pointer; fromObj: SOMMBeforeAfter): SOMMBeforeAfter; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultVAssign(var ctrl: Pointer; fromObj: SOMMBeforeAfter): SOMMBeforeAfter; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultConstVAssign(var ctrl: Pointer; fromObj: SOMMBeforeAfter): SOMMBeforeAfter; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somInit; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somFree; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somUninit; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetClass: SOMClass; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetClassName: {dual_owned} CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetSize: LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somIsA(aClassObj: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somIsInstanceOf(aClassObj: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somRespondsTo(mId: somId): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDispatch(out retValue: Pointer; methodId: somId; ap: va_list): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somClassDispatch(clsObj: SOMClass; out retValue: Pointer; methodId: somId; ap: va_list): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somCastObj(cls: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somResetObj: CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somPrintSelf: SOMMBeforeAfter; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDumpSelf(level: LongInt); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDumpSelfInt(level: LongInt); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}

    { Class object access and initialization }
    class function ClassObject: SOMClass; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF} // may be nil before class is created
    class function NewClass: SOMClass; // (not really new every time, but autocreated)

    { Upcasting }
    function As_SOMClass: SOMClass; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function As_SOMMBeforeAfter: SOMMBeforeAfter; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}

    { Downcasting }
    class function Supports(Instance: SOMObjectBase): Boolean; overload;
    class function Supports(Instance: SOMObjectBase; out Obj: SOMMBeforeAfter): Boolean; overload;

    property somDataAlignment: LongInt read _get_somDataAlignment;
    property somInstanceDataOffsets: _IDL_Sequence_SOMClass_somOffsetInfo read _get_somInstanceDataOffsets;
    property somDirectInitClasses: _IDL_Sequence_SOMClass read _get_somDirectInitClasses write _set_somDirectInitClasses;
    property somClassAllocate: PPointer read _get_somClassAllocate;
    property somClassDeallocate: PPointer read _get_somClassDeallocate;
  end;

  PSOMClass = ^SOMClass;
  SOMClassMgr = class(SOMObjectBase)
  private
    function _get_somInterfaceRepository: Repository; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure _set_somInterfaceRepository(somInterfaceRepository: Repository); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somRegisteredClasses: {caller_owns} _IDL_Sequence_SOMClass; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
  public
    class function Create: SOMClassMgr; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function InitInstance(Instance: Pointer): SOMClassMgr; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function ClassType: SOMClass; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function ClassName: string; reintroduce;
    class function ClassNameIs(const Name: string): Boolean; reintroduce;
    class function InstanceSize: LongInt; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function InheritsFrom(AClass: SOMClass): Boolean; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function MethodAddress(const Name: string): Pointer; reintroduce;
    class function NewInstance: SOMClassMgr; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function Clone: SOMClassMgr; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somLoadClassFile(classId: {caller_owns} somId; majorVersion: LongInt; minorVersion: LongInt; SOM_file: {caller_owns} CORBAString): SOMClass; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somLocateClassFile(classId: {caller_owns} somId; majorVersion: LongInt; minorVersion: LongInt): CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somRegisterClass(classObj: SOMClass); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somRegisterClassLibrary(libraryName: {caller_owns} CORBAString; libraryInitRtn: Pointer); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somUnregisterClassLibrary(libraryName: {caller_owns} CORBAString); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somUnloadClassFile(classObj: SOMClass): LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somUnregisterClass(classObj: SOMClass): LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somBeginPersistentClasses; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somEndPersistentClasses; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somJoinAffinityGroup(SOM_newClass: SOMClass; affClass: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetInitFunction: CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetRelatedClasses(classObj: SOMClass): {caller_owns} PSOMClass; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somClassFromId(classId: {caller_owns} somId): SOMClass; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somFindClass(classId: {caller_owns} somId; majorVersion: LongInt; minorVersion: LongInt): SOMClass; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somFindClsInFile(classId: {caller_owns} somId; majorVersion: LongInt; minorVersion: LongInt; SOM_file: {caller_owns} CORBAString): SOMClass; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somMergeInto(targetObj: SOMObject); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somSubstituteClass(origClassName: {caller_owns} CORBAString; newClassName: {caller_owns} CORBAString): LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultInit(var ctrl: Pointer); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDestruct(doFree: Byte; var ctrl: Pointer); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultCopyInit(var ctrl: Pointer; fromObj: SOMClassMgr); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultAssign(var ctrl: Pointer; fromObj: SOMClassMgr): SOMClassMgr; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultConstCopyInit(var ctrl: Pointer; fromObj: SOMClassMgr); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultVCopyInit(var ctrl: Pointer; fromObj: SOMClassMgr); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultConstVCopyInit(var ctrl: Pointer; fromObj: SOMClassMgr); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultConstAssign(var ctrl: Pointer; fromObj: SOMClassMgr): SOMClassMgr; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultVAssign(var ctrl: Pointer; fromObj: SOMClassMgr): SOMClassMgr; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultConstVAssign(var ctrl: Pointer; fromObj: SOMClassMgr): SOMClassMgr; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somInit; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somFree; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somUninit; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetClass: SOMClass; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetClassName: {dual_owned} CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetSize: LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somIsA(aClassObj: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somIsInstanceOf(aClassObj: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somRespondsTo(mId: somId): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDispatch(out retValue: Pointer; methodId: somId; ap: va_list): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somClassDispatch(clsObj: SOMClass; out retValue: Pointer; methodId: somId; ap: va_list): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somCastObj(cls: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somResetObj: CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somPrintSelf: SOMClassMgr; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDumpSelf(level: LongInt); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDumpSelfInt(level: LongInt); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}

    { Class object access and initialization }
    class function ClassObject: SOMClass; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF} // may be nil before class is created
    class function NewClass: SOMClass; // (not really new every time, but autocreated)

    { Upcasting }
    function As_SOMClassMgr: SOMClassMgr; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}

    { Downcasting }
    class function Supports(Instance: SOMObjectBase): Boolean; overload;
    class function Supports(Instance: SOMObjectBase; out Obj: SOMClassMgr): Boolean; overload;

    property somInterfaceRepository: Repository read _get_somInterfaceRepository write _set_somInterfaceRepository;
    property somRegisteredClasses: _IDL_Sequence_SOMClass read _get_somRegisteredClasses;
  end;

  SOMDObject = class(SOMObjectBase)
  public
    class function Create: SOMDObject; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function InitInstance(Instance: Pointer): SOMDObject; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function ClassType: SOMClass; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function ClassName: string; reintroduce;
    class function ClassNameIs(const Name: string): Boolean; reintroduce;
    class function InstanceSize: LongInt; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function InheritsFrom(AClass: SOMClass): Boolean; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function MethodAddress(const Name: string): Pointer; reintroduce;
    class function NewInstance: SOMDObject; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function Clone: SOMDObject; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function get_implementation: ImplementationDef; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function get_interface: InterfaceDef; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function is_nil: CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function is_SOM_ref: CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function is_constant: CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function is_proxy: CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function duplicate: SOMDObject; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure release; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function create_request(ctx: Context; operation: CORBAString; arg_list: NVList; var SOM_result: NamedValue; out request: Request; req_flags: LongWord): LongWord; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function create_request_args(operation: CORBAString; out arg_list: NVList; out SOM_result: NamedValue): LongWord; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultInit(var ctrl: Pointer); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDestruct(doFree: Byte; var ctrl: Pointer); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultCopyInit(var ctrl: Pointer; fromObj: SOMDObject); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultAssign(var ctrl: Pointer; fromObj: SOMDObject): SOMDObject; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultConstCopyInit(var ctrl: Pointer; fromObj: SOMDObject); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultVCopyInit(var ctrl: Pointer; fromObj: SOMDObject); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultConstVCopyInit(var ctrl: Pointer; fromObj: SOMDObject); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultConstAssign(var ctrl: Pointer; fromObj: SOMDObject): SOMDObject; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultVAssign(var ctrl: Pointer; fromObj: SOMDObject): SOMDObject; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultConstVAssign(var ctrl: Pointer; fromObj: SOMDObject): SOMDObject; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somInit; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somFree; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somUninit; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetClass: SOMClass; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetClassName: {dual_owned} CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetSize: LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somIsA(aClassObj: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somIsInstanceOf(aClassObj: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somRespondsTo(mId: somId): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDispatch(out retValue: Pointer; methodId: somId; ap: va_list): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somClassDispatch(clsObj: SOMClass; out retValue: Pointer; methodId: somId; ap: va_list): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somCastObj(cls: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somResetObj: CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somPrintSelf: SOMDObject; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDumpSelf(level: LongInt); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDumpSelfInt(level: LongInt); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}

    { Class object access and initialization }
    class function ClassObject: SOMClass; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF} // may be nil before class is created
    class function NewClass: SOMClass; // (not really new every time, but autocreated)

    { Upcasting }
    function As_SOMDObject: SOMDObject; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}

    { Downcasting }
    class function Supports(Instance: SOMObjectBase): Boolean; overload;
    class function Supports(Instance: SOMObjectBase; out Obj: SOMDObject): Boolean; overload;

  end;

  SOMDClientProxy = class(SOMObjectBase)
  public
    class function Create: SOMDClientProxy; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function InitInstance(Instance: Pointer): SOMDClientProxy; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function ClassType: SOMClass; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function ClassName: string; reintroduce;
    class function ClassNameIs(const Name: string): Boolean; reintroduce;
    class function InstanceSize: LongInt; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function InheritsFrom(AClass: SOMClass): Boolean; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function MethodAddress(const Name: string): Pointer; reintroduce;
    class function NewInstance: SOMDClientProxy; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function Clone: SOMDClientProxy; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somdTargetFree; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somdTargetGetClass: SOMClass; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somdTargetGetClassName: CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somdProxyFree; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somdProxyGetClass: SOMClass; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somdProxyGetClassName: CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somdReleaseResources; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function get_implementation: ImplementationDef; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function get_interface: InterfaceDef; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function is_nil: CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function is_SOM_ref: CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function is_constant: CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function is_proxy: CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function duplicate: SOMDObject; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure release; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function create_request(ctx: Context; operation: CORBAString; arg_list: NVList; var SOM_result: NamedValue; out request: Request; req_flags: LongWord): LongWord; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function create_request_args(operation: CORBAString; out arg_list: NVList; out SOM_result: NamedValue): LongWord; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultInit(var ctrl: Pointer); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDestruct(doFree: Byte; var ctrl: Pointer); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultCopyInit(var ctrl: Pointer; fromObj: SOMDClientProxy); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultAssign(var ctrl: Pointer; fromObj: SOMDClientProxy): SOMDClientProxy; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultConstCopyInit(var ctrl: Pointer; fromObj: SOMDClientProxy); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultVCopyInit(var ctrl: Pointer; fromObj: SOMDClientProxy); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultConstVCopyInit(var ctrl: Pointer; fromObj: SOMDClientProxy); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultConstAssign(var ctrl: Pointer; fromObj: SOMDClientProxy): SOMDClientProxy; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultVAssign(var ctrl: Pointer; fromObj: SOMDClientProxy): SOMDClientProxy; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultConstVAssign(var ctrl: Pointer; fromObj: SOMDClientProxy): SOMDClientProxy; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somInit; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somFree; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somUninit; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetClass: SOMClass; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetClassName: {dual_owned} CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetSize: LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somIsA(aClassObj: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somIsInstanceOf(aClassObj: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somRespondsTo(mId: somId): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDispatch(out retValue: Pointer; methodId: somId; ap: va_list): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somClassDispatch(clsObj: SOMClass; out retValue: Pointer; methodId: somId; ap: va_list): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somCastObj(cls: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somResetObj: CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somPrintSelf: SOMDClientProxy; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDumpSelf(level: LongInt); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDumpSelfInt(level: LongInt); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}

    { Class object access and initialization }
    class function ClassObject: SOMClass; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF} // may be nil before class is created
    class function NewClass: SOMClass; // (not really new every time, but autocreated)

    { Upcasting }
    function As_SOMDObject: SOMDObject; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function As_SOMDClientProxy: SOMDClientProxy; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}

    { Downcasting }
    class function Supports(Instance: SOMObjectBase): Boolean; overload;
    class function Supports(Instance: SOMObjectBase; out Obj: SOMDClientProxy): Boolean; overload;

  end;

  SOMDMetaproxy = class(SOMObjectBase)
  private
    function _get_somDataAlignment: LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somInstanceDataOffsets: _IDL_Sequence_SOMClass_somOffsetInfo; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somDirectInitClasses: _IDL_Sequence_SOMClass; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure _set_somDirectInitClasses(const somDirectInitClasses: _IDL_Sequence_SOMClass); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somClassAllocate: PPointer; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somClassDeallocate: PPointer; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
  public
    class function Create: SOMDMetaproxy; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function InitInstance(Instance: Pointer): SOMDMetaproxy; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function ClassType: SOMClass; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function ClassName: string; reintroduce;
    class function ClassNameIs(const Name: string): Boolean; reintroduce;
    class function InstanceSize: LongInt; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function InheritsFrom(AClass: SOMClass): Boolean; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function MethodAddress(const Name: string): Pointer; reintroduce;
    class function NewInstance: SOMDMetaproxy; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function Clone: SOMDMetaproxy; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somNew: SOMObject; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somNewNoInit: SOMObject; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somRenew(obj: Pointer): SOMObject; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somRenewNoInit(obj: Pointer): SOMObject; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somRenewNoZero(obj: Pointer): SOMObject; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somRenewNoInitNoZero(obj: Pointer): SOMObject; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somAllocate(size: LongInt): CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDeallocate(memptr: CORBAString); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetInstanceInitMask(out ctrl: Pointer): PByte; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetInstanceDestructionMask(out ctrl: Pointer): PByte; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetInstanceAssignmentMask(out ctrl: Pointer): PByte; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somInitClass(className: CORBAString; parentClass: SOMClass; dataSize: LongInt; maxStaticMethods: LongInt; majorVersion: LongInt; minorVersion: LongInt); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somInitMIClass(inherit_vars: LongInt; className: CORBAString; const parentClasses: _IDL_Sequence_SOMClass; dataSize: LongInt; dataAlignment: LongInt; maxStaticMethods: LongInt; majorVersion: LongInt; minorVersion: LongInt); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somAddStaticMethod(methodId: somId; methodDescriptor: somId; method: Pointer; redispatchStub: Pointer; applyStub: Pointer): Pointer; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somAddDynamicMethod(methodId: somId; methodDescriptor: somId; method: Pointer; applyStub: Pointer); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somOverrideSMethod(methodId: somId; method: Pointer); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somClassReady; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetClassData: PsomClassDataStructure; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somSetClassData(const cds: somClassDataStructure); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetClassMtab: PsomMethodTab; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetInstanceOffset: LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetInstancePartSize: LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetInstanceSize: LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetInstanceToken: Pointer; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetMemberToken(memberOffset: LongInt; instanceToken: Pointer): Pointer; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetMethodData(methodId: somId; out md: somMethodDataStruct): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetRdStub(methodId: somId): PPointer; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetMethodDescriptor(methodId: somId): somId; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetMethodIndex(id: somId): LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetMethodToken(methodId: somId): Pointer; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetName: {dual_owned} CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetNthMethodData(n: LongInt; out md: somMethodDataStruct): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetNthMethodInfo(n: LongInt; out descriptor: somId): somId; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetNumMethods: LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetNumStaticMethods: LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetParent: SOMClass; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetParents: {dual_owned} _IDL_Sequence_SOMClass; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetPClsMtab: PsomMethodTabList; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetPClsMtabs: PsomMethodTabList; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somGetVersionNumbers(out majorVersion: LongInt; out minorVersion: LongInt); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somSetMethodDescriptor(methodId: somId; descriptor: somId): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somFindMethod(methodId: somId; out m: Pointer): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somFindMethodOk(methodId: somId; out m: Pointer): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somFindSMethod(methodId: somId): Pointer; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somFindSMethodOk(methodId: somId): Pointer; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somLookupMethod(methodId: somId): Pointer; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somCheckVersion(majorVersion: LongInt; minorVersion: LongInt): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDescendedFrom(aClassObj: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somSupportsMethod(mId: somId): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefinedMethod(method: Pointer): Pointer; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somOverrideMtab; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultInit(var ctrl: Pointer); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDestruct(doFree: Byte; var ctrl: Pointer); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultCopyInit(var ctrl: Pointer; fromObj: SOMDMetaproxy); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultAssign(var ctrl: Pointer; fromObj: SOMDMetaproxy): SOMDMetaproxy; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultConstCopyInit(var ctrl: Pointer; fromObj: SOMDMetaproxy); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultVCopyInit(var ctrl: Pointer; fromObj: SOMDMetaproxy); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultConstVCopyInit(var ctrl: Pointer; fromObj: SOMDMetaproxy); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultConstAssign(var ctrl: Pointer; fromObj: SOMDMetaproxy): SOMDMetaproxy; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultVAssign(var ctrl: Pointer; fromObj: SOMDMetaproxy): SOMDMetaproxy; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultConstVAssign(var ctrl: Pointer; fromObj: SOMDMetaproxy): SOMDMetaproxy; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somInit; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somFree; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somUninit; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetClass: SOMClass; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetClassName: {dual_owned} CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetSize: LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somIsA(aClassObj: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somIsInstanceOf(aClassObj: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somRespondsTo(mId: somId): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDispatch(out retValue: Pointer; methodId: somId; ap: va_list): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somClassDispatch(clsObj: SOMClass; out retValue: Pointer; methodId: somId; ap: va_list): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somCastObj(cls: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somResetObj: CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somPrintSelf: SOMDMetaproxy; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDumpSelf(level: LongInt); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDumpSelfInt(level: LongInt); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}

    { Class object access and initialization }
    class function ClassObject: SOMClass; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF} // may be nil before class is created
    class function NewClass: SOMClass; // (not really new every time, but autocreated)

    { Upcasting }
    function As_SOMClass: SOMClass; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function As_SOMDMetaproxy: SOMDMetaproxy; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}

    { Downcasting }
    class function Supports(Instance: SOMObjectBase): Boolean; overload;
    class function Supports(Instance: SOMObjectBase; out Obj: SOMDMetaproxy): Boolean; overload;

    property somDataAlignment: LongInt read _get_somDataAlignment;
    property somInstanceDataOffsets: _IDL_Sequence_SOMClass_somOffsetInfo read _get_somInstanceDataOffsets;
    property somDirectInitClasses: _IDL_Sequence_SOMClass read _get_somDirectInitClasses write _set_somDirectInitClasses;
    property somClassAllocate: PPointer read _get_somClassAllocate;
    property somClassDeallocate: PPointer read _get_somClassDeallocate;
  end;

  P_IDL_ArrayOf_SOMDServer = ^_IDL_ArrayOf_SOMDServer;
  _IDL_Sequence_SOMDServer = packed record
    _maximum: LongWord;
    _length: LongWord;
    _buffer: P_IDL_ArrayOf_SOMDServer;
  end;
  SOMDObjectMgr = class(SOMObjectBase)
  private
    function _get_somd21somFree: CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure _set_somd21somFree(somd21somFree: CORBABoolean); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
  public
    class function Create: SOMDObjectMgr; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function InitInstance(Instance: Pointer): SOMDObjectMgr; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function ClassType: SOMClass; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function ClassName: string; reintroduce;
    class function ClassNameIs(const Name: string): Boolean; reintroduce;
    class function InstanceSize: LongInt; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function InheritsFrom(AClass: SOMClass): Boolean; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function MethodAddress(const Name: string): Pointer; reintroduce;
    class function NewInstance: SOMDObjectMgr; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function Clone: SOMDObjectMgr; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somdFindServer(serverid: CORBAString): SOMDServer; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somdFindServerByName(servername: CORBAString): SOMDServer; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somdFindServersByClass(objclass: CORBAString): _IDL_Sequence_SOMDServer; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somdFindAnyServerByClass(objclass: CORBAString): SOMDServer; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somdNewObject(objclass: CORBAString; hints: CORBAString): SOMObject; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somdGetIdFromObject(obj: SOMObject): CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somdGetObjectFromId(id: CORBAString): SOMObject; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somdReleaseObject(obj: SOMObject); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somdDestroyObject(obj: SOMObject); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultInit(var ctrl: Pointer); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDestruct(doFree: Byte; var ctrl: Pointer); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultCopyInit(var ctrl: Pointer; fromObj: SOMDObjectMgr); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultAssign(var ctrl: Pointer; fromObj: SOMDObjectMgr): SOMDObjectMgr; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultConstCopyInit(var ctrl: Pointer; fromObj: SOMDObjectMgr); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultVCopyInit(var ctrl: Pointer; fromObj: SOMDObjectMgr); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultConstVCopyInit(var ctrl: Pointer; fromObj: SOMDObjectMgr); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultConstAssign(var ctrl: Pointer; fromObj: SOMDObjectMgr): SOMDObjectMgr; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultVAssign(var ctrl: Pointer; fromObj: SOMDObjectMgr): SOMDObjectMgr; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultConstVAssign(var ctrl: Pointer; fromObj: SOMDObjectMgr): SOMDObjectMgr; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somInit; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somFree; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somUninit; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetClass: SOMClass; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetClassName: {dual_owned} CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetSize: LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somIsA(aClassObj: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somIsInstanceOf(aClassObj: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somRespondsTo(mId: somId): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDispatch(out retValue: Pointer; methodId: somId; ap: va_list): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somClassDispatch(clsObj: SOMClass; out retValue: Pointer; methodId: somId; ap: va_list): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somCastObj(cls: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somResetObj: CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somPrintSelf: SOMDObjectMgr; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDumpSelf(level: LongInt); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDumpSelfInt(level: LongInt); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}

    { Class object access and initialization }
    class function ClassObject: SOMClass; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF} // may be nil before class is created
    class function NewClass: SOMClass; // (not really new every time, but autocreated)

    { Upcasting }
    function As_ObjectMgr: ObjectMgr; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function As_SOMDObjectMgr: SOMDObjectMgr; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}

    { Downcasting }
    class function Supports(Instance: SOMObjectBase): Boolean; overload;
    class function Supports(Instance: SOMObjectBase; out Obj: SOMDObjectMgr): Boolean; overload;

    property somd21somFree: CORBABoolean read _get_somd21somFree write _set_somd21somFree;
  end;

  SOMDServer = class(SOMObjectBase)
  public
    class function Create: SOMDServer; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function InitInstance(Instance: Pointer): SOMDServer; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function ClassType: SOMMSingleInstance; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function ClassName: string; reintroduce;
    class function ClassNameIs(const Name: string): Boolean; reintroduce;
    class function InstanceSize: LongInt; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function InheritsFrom(AClass: SOMClass): Boolean; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function MethodAddress(const Name: string): Pointer; reintroduce;
    class function NewInstance: SOMDServer; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function Clone: SOMDServer; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somdRefFromSOMObj(somobj: SOMObject): SOMDObject; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somdSOMObjFromRef(objref: SOMDObject): SOMObject; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somdDispatchMethod(somobj: SOMObject; out retValue: Pointer; methodId: somId; ap: va_list); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somdCreateObj(objclass: CORBAString; hints: CORBAString): SOMObject; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somdDeleteObj(somobj: SOMObject); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somdGetClassObj(objclass: CORBAString): SOMClass; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somdObjReferencesCached: CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultInit(var ctrl: Pointer); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDestruct(doFree: Byte; var ctrl: Pointer); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultCopyInit(var ctrl: Pointer; fromObj: SOMDServer); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultAssign(var ctrl: Pointer; fromObj: SOMDServer): SOMDServer; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultConstCopyInit(var ctrl: Pointer; fromObj: SOMDServer); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultVCopyInit(var ctrl: Pointer; fromObj: SOMDServer); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultConstVCopyInit(var ctrl: Pointer; fromObj: SOMDServer); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultConstAssign(var ctrl: Pointer; fromObj: SOMDServer): SOMDServer; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultVAssign(var ctrl: Pointer; fromObj: SOMDServer): SOMDServer; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultConstVAssign(var ctrl: Pointer; fromObj: SOMDServer): SOMDServer; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somInit; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somFree; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somUninit; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetClass: SOMMSingleInstance; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetClassName: {dual_owned} CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetSize: LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somIsA(aClassObj: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somIsInstanceOf(aClassObj: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somRespondsTo(mId: somId): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDispatch(out retValue: Pointer; methodId: somId; ap: va_list): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somClassDispatch(clsObj: SOMClass; out retValue: Pointer; methodId: somId; ap: va_list): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somCastObj(cls: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somResetObj: CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somPrintSelf: SOMDServer; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDumpSelf(level: LongInt); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDumpSelfInt(level: LongInt); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}

    { Class object access and initialization }
    class function ClassObject: SOMMSingleInstance; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF} // may be nil before class is created
    class function NewClass: SOMMSingleInstance; // (not really new every time, but autocreated)

    { Upcasting }
    function As_SOMDServer: SOMDServer; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}

    { Downcasting }
    class function Supports(Instance: SOMObjectBase): Boolean; overload;
    class function Supports(Instance: SOMObjectBase; out Obj: SOMDServer): Boolean; overload;

  end;

  SOMUTId = class(SOMObjectBase)
  public
    class function Create: SOMUTId; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function InitInstance(Instance: Pointer): SOMUTId; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function ClassType: SOMClass; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function ClassName: string; reintroduce;
    class function ClassNameIs(const Name: string): Boolean; reintroduce;
    class function InstanceSize: LongInt; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function InheritsFrom(AClass: SOMClass): Boolean; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function MethodAddress(const Name: string): Pointer; reintroduce;
    class function NewInstance: SOMUTId; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function Clone: SOMUTId; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somutSetIdId(otherId: SOMUTId); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somutEqualsId(otherId: SOMUTId): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somutCompareId(otherId: SOMUTId): SmallInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somutHashId: LongWord; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultInit(var ctrl: Pointer); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDestruct(doFree: Byte; var ctrl: Pointer); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultCopyInit(var ctrl: Pointer; fromObj: SOMUTId); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultAssign(var ctrl: Pointer; fromObj: SOMUTId): SOMUTId; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultConstCopyInit(var ctrl: Pointer; fromObj: SOMUTId); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultVCopyInit(var ctrl: Pointer; fromObj: SOMUTId); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultConstVCopyInit(var ctrl: Pointer; fromObj: SOMUTId); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultConstAssign(var ctrl: Pointer; fromObj: SOMUTId): SOMUTId; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultVAssign(var ctrl: Pointer; fromObj: SOMUTId): SOMUTId; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultConstVAssign(var ctrl: Pointer; fromObj: SOMUTId): SOMUTId; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somInit; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somFree; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somUninit; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetClass: SOMClass; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetClassName: {dual_owned} CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetSize: LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somIsA(aClassObj: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somIsInstanceOf(aClassObj: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somRespondsTo(mId: somId): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDispatch(out retValue: Pointer; methodId: somId; ap: va_list): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somClassDispatch(clsObj: SOMClass; out retValue: Pointer; methodId: somId; ap: va_list): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somCastObj(cls: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somResetObj: CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somPrintSelf: SOMUTId; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDumpSelf(level: LongInt); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDumpSelfInt(level: LongInt); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}

    { Class object access and initialization }
    class function ClassObject: SOMClass; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF} // may be nil before class is created
    class function NewClass: SOMClass; // (not really new every time, but autocreated)

    { Upcasting }
    function As_SOMUTId: SOMUTId; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}

    { Downcasting }
    class function Supports(Instance: SOMObjectBase): Boolean; overload;
    class function Supports(Instance: SOMObjectBase; out Obj: SOMUTId): Boolean; overload;

  end;

  SOMOA = class(SOMObjectBase)
  public
    class function Create: SOMOA; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function InitInstance(Instance: Pointer): SOMOA; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function ClassType: SOMClass; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function ClassName: string; reintroduce;
    class function ClassNameIs(const Name: string): Boolean; reintroduce;
    class function InstanceSize: LongInt; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function InheritsFrom(AClass: SOMClass): Boolean; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function MethodAddress(const Name: string): Pointer; reintroduce;
    class function NewInstance: SOMOA; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function Clone: SOMOA; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function execute_next_request(waitFlag: LongWord): LongWord; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function execute_request_loop(waitFlag: LongWord): LongWord; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure change_id(objref: SOMDObject; const id: _IDL_Sequence_Byte); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function create_constant(const id: _IDL_Sequence_Byte; intf: InterfaceDef; impl: ImplementationDef): SOMDObject; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function create_SOM_ref(somobj: SOMObject; impl: ImplementationDef): SOMDObject; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function get_SOM_object(somref: SOMDObject): SOMObject; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure activate_impl_failed(impl: ImplementationDef; rc: LongWord); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure interrupt_server; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function SOM_create(const id: _IDL_Sequence_Byte; intf: InterfaceDef; impl: ImplementationDef): SOMDObject; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure dispose(obj: SOMDObject); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function get_id(obj: SOMDObject): _IDL_Sequence_Byte; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function get_principal(obj: SOMDObject; const req_ev: Environment): Principal; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure set_exception(major: exception_type; userid: CORBAString; param: Pointer); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure impl_is_ready(impl: ImplementationDef); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure deactivate_impl(impl: ImplementationDef); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure change_implementation(obj: SOMDObject; impl: ImplementationDef); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure obj_is_ready(obj: SOMDObject; impl: ImplementationDef); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure deactivate_obj(obj: SOMDObject); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultInit(var ctrl: Pointer); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDestruct(doFree: Byte; var ctrl: Pointer); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultCopyInit(var ctrl: Pointer; fromObj: SOMOA); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultAssign(var ctrl: Pointer; fromObj: SOMOA): SOMOA; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultConstCopyInit(var ctrl: Pointer; fromObj: SOMOA); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultVCopyInit(var ctrl: Pointer; fromObj: SOMOA); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultConstVCopyInit(var ctrl: Pointer; fromObj: SOMOA); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultConstAssign(var ctrl: Pointer; fromObj: SOMOA): SOMOA; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultVAssign(var ctrl: Pointer; fromObj: SOMOA): SOMOA; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultConstVAssign(var ctrl: Pointer; fromObj: SOMOA): SOMOA; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somInit; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somFree; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somUninit; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetClass: SOMClass; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetClassName: {dual_owned} CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetSize: LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somIsA(aClassObj: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somIsInstanceOf(aClassObj: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somRespondsTo(mId: somId): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDispatch(out retValue: Pointer; methodId: somId; ap: va_list): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somClassDispatch(clsObj: SOMClass; out retValue: Pointer; methodId: somId; ap: va_list): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somCastObj(cls: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somResetObj: CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somPrintSelf: SOMOA; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDumpSelf(level: LongInt); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDumpSelfInt(level: LongInt); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}

    { Class object access and initialization }
    class function ClassObject: SOMClass; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF} // may be nil before class is created
    class function NewClass: SOMClass; // (not really new every time, but autocreated)

    { Upcasting }
    function As_BOA: BOA; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function As_SOMOA: SOMOA; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}

    { Downcasting }
    class function Supports(Instance: SOMObjectBase): Boolean; overload;
    class function Supports(Instance: SOMObjectBase; out Obj: SOMOA): Boolean; overload;

  end;

  PSockets_hostent = Pointer{ opaque ^Sockets_hostent };
  PSockets_servent = Pointer{ opaque ^Sockets_servent };
  Sockets = class(SOMObjectBase)
  private
    function _get_serrno: LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure _set_serrno(serrno: LongInt); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
  public
    class function Create: Sockets; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function InitInstance(Instance: Pointer): Sockets; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function ClassType: SOMMSingleInstance; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function ClassName: string; reintroduce;
    class function ClassNameIs(const Name: string): Boolean; reintroduce;
    class function InstanceSize: LongInt; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function InheritsFrom(AClass: SOMClass): Boolean; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function MethodAddress(const Name: string): Pointer; reintroduce;
    class function NewInstance: Sockets; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function Clone: Sockets; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somsAccept(s: LongInt; out name{: opaque Sockets_sockaddr}; out namelen: LongInt): LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somsBind(s: LongInt; var name{: opaque Sockets_sockaddr}; namelen: LongInt): LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somsConnect(s: LongInt; var name{: opaque Sockets_sockaddr}; namelen: LongInt): LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somsGethostbyaddr(addr: PShortInt; addrlen: LongInt; domain: LongInt): PSockets_hostent; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somsGethostbyname(name: CORBAString): PSockets_hostent; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somsGethostent: PSockets_hostent; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somsGethostid: LongWord; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somsGethostname(name: CORBAString; namelength: LongInt): LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somsGetpeername(s: LongInt; out name{: opaque Sockets_sockaddr}; out namelen: LongInt): LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somsGetservbyname(name: CORBAString; protocol: CORBAString): PSockets_servent; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somsGetsockname(s: LongInt; out name{: opaque Sockets_sockaddr}; out namelen: LongInt): LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somsGetsockopt(s: LongInt; level: LongInt; optname: LongInt; optval: PShortInt; out option: LongInt): LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somsHtonl(a: LongWord): LongWord; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somsHtons(a: Word): Word; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somsIoctl(s: LongInt; cmd: LongInt; data: PShortInt; length: LongInt): LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somsInet_addr(cp: CORBAString): LongWord; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somsInet_lnaof(addr: Sockets_in_addr): LongWord; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somsInet_makeaddr(net: LongWord; lna: LongWord): Sockets_in_addr; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somsInet_netof(addr: Sockets_in_addr): LongWord; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somsInet_network(cp: CORBAString): LongWord; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somsInet_ntoa(addr: Sockets_in_addr): CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somsListen(s: LongInt; backlog: LongInt): LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somsNtohl(a: LongWord): LongWord; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somsNtohs(a: Word): Word; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somsReadv(s: LongInt; var iov{: opaque Sockets_iovec}; iovcnt: LongInt): LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somsRecv(s: LongInt; buf: PShortInt; len: LongInt; flags: LongInt): LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somsRecvfrom(s: LongInt; buf: PShortInt; len: LongInt; flags: LongInt; out name{: opaque Sockets_sockaddr}; out namelen: LongInt): LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somsRecvmsg(s: LongInt; var msg{: opaque Sockets_msghdr}; flags: LongInt): LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somsSelect(nfds: LongInt; var readfds{: opaque Sockets_fd_set}; var writefds{: opaque Sockets_fd_set}; var exceptfds{: opaque Sockets_fd_set}; var timeout{: opaque Sockets_timeval}): LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somsSend(s: LongInt; msg: PShortInt; len: LongInt; flags: LongInt): LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somsSendmsg(s: LongInt; var msg{: opaque Sockets_msghdr}; flags: LongInt): LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somsSendto(s: LongInt; var msg: ShortInt; len: LongInt; flags: LongInt; var SOM_to{: opaque Sockets_sockaddr}; tolen: LongInt): LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somsSetsockopt(s: LongInt; level: LongInt; optname: LongInt; optval: PShortInt; optlen: LongInt): LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somsShutdown(s: LongInt; how: LongInt): LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somsSocket(domain: LongInt; SOM_type: LongInt; protocol: LongInt): LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somsSoclose(s: LongInt): LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somsWritev(s: LongInt; var iov{: opaque Sockets_iovec}; iovcnt: LongInt): LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultInit(var ctrl: Pointer); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDestruct(doFree: Byte; var ctrl: Pointer); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultCopyInit(var ctrl: Pointer; fromObj: Sockets); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultAssign(var ctrl: Pointer; fromObj: Sockets): Sockets; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultConstCopyInit(var ctrl: Pointer; fromObj: Sockets); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultVCopyInit(var ctrl: Pointer; fromObj: Sockets); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultConstVCopyInit(var ctrl: Pointer; fromObj: Sockets); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultConstAssign(var ctrl: Pointer; fromObj: Sockets): Sockets; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultVAssign(var ctrl: Pointer; fromObj: Sockets): Sockets; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultConstVAssign(var ctrl: Pointer; fromObj: Sockets): Sockets; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somInit; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somFree; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somUninit; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetClass: SOMMSingleInstance; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetClassName: {dual_owned} CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetSize: LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somIsA(aClassObj: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somIsInstanceOf(aClassObj: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somRespondsTo(mId: somId): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDispatch(out retValue: Pointer; methodId: somId; ap: va_list): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somClassDispatch(clsObj: SOMClass; out retValue: Pointer; methodId: somId; ap: va_list): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somCastObj(cls: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somResetObj: CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somPrintSelf: Sockets; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDumpSelf(level: LongInt); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDumpSelfInt(level: LongInt); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}

    { Class object access and initialization }
    class function ClassObject: SOMMSingleInstance; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF} // may be nil before class is created
    class function NewClass: SOMMSingleInstance; // (not really new every time, but autocreated)

    { Upcasting }
    function As_Sockets: Sockets; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}

    { Downcasting }
    class function Supports(Instance: SOMObjectBase): Boolean; overload;
    class function Supports(Instance: SOMObjectBase; out Obj: Sockets): Boolean; overload;

    property serrno: LongInt read _get_serrno write _set_serrno;
  end;

  SOMStringTableC = class(SOMObjectBase)
  private
    function _get_somstTargetCapacity: LongWord; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure _set_somstTargetCapacity(somstTargetCapacity: LongWord); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somstAssociationsCount: LongWord; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
  public
    class function Create: SOMStringTableC; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function InitInstance(Instance: Pointer): SOMStringTableC; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function ClassType: SOMClass; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function ClassName: string; reintroduce;
    class function ClassNameIs(const Name: string): Boolean; reintroduce;
    class function InstanceSize: LongInt; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function InheritsFrom(AClass: SOMClass): Boolean; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function MethodAddress(const Name: string): Pointer; reintroduce;
    class function NewInstance: SOMStringTableC; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function Clone: SOMStringTableC; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somstAssociate(key: CORBAString; value: CORBAString): SmallInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somstAssociateCopyKey(key: CORBAString; value: CORBAString): SmallInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somstAssociateCopyValue(key: CORBAString; value: CORBAString): SmallInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somstAssociateCopyBoth(key: CORBAString; value: CORBAString): SmallInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somstGetAssociation(key: CORBAString): CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somstClearAssociation(key: CORBAString): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somstGetIthKey(i: LongWord): CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somstGetIthValue(i: LongWord): CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultInit(var ctrl: Pointer); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDestruct(doFree: Byte; var ctrl: Pointer); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultCopyInit(var ctrl: Pointer; fromObj: SOMStringTableC); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultAssign(var ctrl: Pointer; fromObj: SOMStringTableC): SOMStringTableC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultConstCopyInit(var ctrl: Pointer; fromObj: SOMStringTableC); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultVCopyInit(var ctrl: Pointer; fromObj: SOMStringTableC); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultConstVCopyInit(var ctrl: Pointer; fromObj: SOMStringTableC); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultConstAssign(var ctrl: Pointer; fromObj: SOMStringTableC): SOMStringTableC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultVAssign(var ctrl: Pointer; fromObj: SOMStringTableC): SOMStringTableC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultConstVAssign(var ctrl: Pointer; fromObj: SOMStringTableC): SOMStringTableC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somInit; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somFree; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somUninit; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetClass: SOMClass; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetClassName: {dual_owned} CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetSize: LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somIsA(aClassObj: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somIsInstanceOf(aClassObj: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somRespondsTo(mId: somId): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDispatch(out retValue: Pointer; methodId: somId; ap: va_list): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somClassDispatch(clsObj: SOMClass; out retValue: Pointer; methodId: somId; ap: va_list): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somCastObj(cls: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somResetObj: CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somPrintSelf: SOMStringTableC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDumpSelf(level: LongInt); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDumpSelfInt(level: LongInt); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}

    { Class object access and initialization }
    class function ClassObject: SOMClass; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF} // may be nil before class is created
    class function NewClass: SOMClass; // (not really new every time, but autocreated)

    { Upcasting }
    function As_SOMStringTableC: SOMStringTableC; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}

    { Downcasting }
    class function Supports(Instance: SOMObjectBase): Boolean; overload;
    class function Supports(Instance: SOMObjectBase; out Obj: SOMStringTableC): Boolean; overload;

    property somstTargetCapacity: LongWord read _get_somstTargetCapacity write _set_somstTargetCapacity;
    property somstAssociationsCount: LongWord read _get_somstAssociationsCount;
  end;

  SOMMTraced = class(SOMObjectBase)
  private
    function _get_sommTraceIsOn: CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure _set_sommTraceIsOn(sommTraceIsOn: CORBABoolean); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somDataAlignment: LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somInstanceDataOffsets: _IDL_Sequence_SOMClass_somOffsetInfo; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somDirectInitClasses: _IDL_Sequence_SOMClass; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure _set_somDirectInitClasses(const somDirectInitClasses: _IDL_Sequence_SOMClass); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somClassAllocate: PPointer; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somClassDeallocate: PPointer; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
  public
    class function Create: SOMMTraced; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function InitInstance(Instance: Pointer): SOMMTraced; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function ClassType: SOMClass; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function ClassName: string; reintroduce;
    class function ClassNameIs(const Name: string): Boolean; reintroduce;
    class function InstanceSize: LongInt; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function InheritsFrom(AClass: SOMClass): Boolean; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function MethodAddress(const Name: string): Pointer; reintroduce;
    class function NewInstance: SOMMTraced; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function Clone: SOMMTraced; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function sommBeforeMethod(SOM_object: SOMObject; methodId: somId; ap: va_list): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure sommAfterMethod(SOM_object: SOMObject; methodId: somId; returnedvalue: Pointer; ap: va_list); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somNew: SOMObject; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somNewNoInit: SOMObject; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somRenew(obj: Pointer): SOMObject; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somRenewNoInit(obj: Pointer): SOMObject; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somRenewNoZero(obj: Pointer): SOMObject; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somRenewNoInitNoZero(obj: Pointer): SOMObject; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somAllocate(size: LongInt): CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDeallocate(memptr: CORBAString); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetInstanceInitMask(out ctrl: Pointer): PByte; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetInstanceDestructionMask(out ctrl: Pointer): PByte; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetInstanceAssignmentMask(out ctrl: Pointer): PByte; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somInitClass(className: CORBAString; parentClass: SOMClass; dataSize: LongInt; maxStaticMethods: LongInt; majorVersion: LongInt; minorVersion: LongInt); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somInitMIClass(inherit_vars: LongInt; className: CORBAString; const parentClasses: _IDL_Sequence_SOMClass; dataSize: LongInt; dataAlignment: LongInt; maxStaticMethods: LongInt; majorVersion: LongInt; minorVersion: LongInt); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somAddStaticMethod(methodId: somId; methodDescriptor: somId; method: Pointer; redispatchStub: Pointer; applyStub: Pointer): Pointer; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somAddDynamicMethod(methodId: somId; methodDescriptor: somId; method: Pointer; applyStub: Pointer); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somOverrideSMethod(methodId: somId; method: Pointer); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somClassReady; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetClassData: PsomClassDataStructure; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somSetClassData(const cds: somClassDataStructure); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetClassMtab: PsomMethodTab; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetInstanceOffset: LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetInstancePartSize: LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetInstanceSize: LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetInstanceToken: Pointer; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetMemberToken(memberOffset: LongInt; instanceToken: Pointer): Pointer; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetMethodData(methodId: somId; out md: somMethodDataStruct): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetRdStub(methodId: somId): PPointer; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetMethodDescriptor(methodId: somId): somId; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetMethodIndex(id: somId): LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetMethodToken(methodId: somId): Pointer; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetName: {dual_owned} CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetNthMethodData(n: LongInt; out md: somMethodDataStruct): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetNthMethodInfo(n: LongInt; out descriptor: somId): somId; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetNumMethods: LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetNumStaticMethods: LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetParent: SOMClass; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetParents: {dual_owned} _IDL_Sequence_SOMClass; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetPClsMtab: PsomMethodTabList; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetPClsMtabs: PsomMethodTabList; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somGetVersionNumbers(out majorVersion: LongInt; out minorVersion: LongInt); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somSetMethodDescriptor(methodId: somId; descriptor: somId): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somFindMethod(methodId: somId; out m: Pointer): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somFindMethodOk(methodId: somId; out m: Pointer): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somFindSMethod(methodId: somId): Pointer; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somFindSMethodOk(methodId: somId): Pointer; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somLookupMethod(methodId: somId): Pointer; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somCheckVersion(majorVersion: LongInt; minorVersion: LongInt): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDescendedFrom(aClassObj: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somSupportsMethod(mId: somId): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefinedMethod(method: Pointer): Pointer; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somOverrideMtab; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultInit(var ctrl: Pointer); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDestruct(doFree: Byte; var ctrl: Pointer); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultCopyInit(var ctrl: Pointer; fromObj: SOMMTraced); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultAssign(var ctrl: Pointer; fromObj: SOMMTraced): SOMMTraced; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultConstCopyInit(var ctrl: Pointer; fromObj: SOMMTraced); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultVCopyInit(var ctrl: Pointer; fromObj: SOMMTraced); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultConstVCopyInit(var ctrl: Pointer; fromObj: SOMMTraced); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultConstAssign(var ctrl: Pointer; fromObj: SOMMTraced): SOMMTraced; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultVAssign(var ctrl: Pointer; fromObj: SOMMTraced): SOMMTraced; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultConstVAssign(var ctrl: Pointer; fromObj: SOMMTraced): SOMMTraced; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somInit; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somFree; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somUninit; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetClass: SOMClass; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetClassName: {dual_owned} CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetSize: LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somIsA(aClassObj: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somIsInstanceOf(aClassObj: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somRespondsTo(mId: somId): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDispatch(out retValue: Pointer; methodId: somId; ap: va_list): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somClassDispatch(clsObj: SOMClass; out retValue: Pointer; methodId: somId; ap: va_list): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somCastObj(cls: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somResetObj: CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somPrintSelf: SOMMTraced; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDumpSelf(level: LongInt); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDumpSelfInt(level: LongInt); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}

    { Class object access and initialization }
    class function ClassObject: SOMClass; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF} // may be nil before class is created
    class function NewClass: SOMClass; // (not really new every time, but autocreated)

    { Upcasting }
    function As_SOMClass: SOMClass; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function As_SOMMBeforeAfter: SOMMBeforeAfter; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function As_SOMMTraced: SOMMTraced; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}

    { Downcasting }
    class function Supports(Instance: SOMObjectBase): Boolean; overload;
    class function Supports(Instance: SOMObjectBase; out Obj: SOMMTraced): Boolean; overload;

    property sommTraceIsOn: CORBABoolean read _get_sommTraceIsOn write _set_sommTraceIsOn;
    property somDataAlignment: LongInt read _get_somDataAlignment;
    property somInstanceDataOffsets: _IDL_Sequence_SOMClass_somOffsetInfo read _get_somInstanceDataOffsets;
    property somDirectInitClasses: _IDL_Sequence_SOMClass read _get_somDirectInitClasses write _set_somDirectInitClasses;
    property somClassAllocate: PPointer read _get_somClassAllocate;
    property somClassDeallocate: PPointer read _get_somClassDeallocate;
  end;

  SOMETimerEvent = class(SOMObjectBase)
  public
    class function Create: SOMETimerEvent; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function InitInstance(Instance: Pointer): SOMETimerEvent; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function ClassType: SOMClass; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function ClassName: string; reintroduce;
    class function ClassNameIs(const Name: string): Boolean; reintroduce;
    class function InstanceSize: LongInt; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function InheritsFrom(AClass: SOMClass): Boolean; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function MethodAddress(const Name: string): Pointer; reintroduce;
    class function NewInstance: SOMETimerEvent; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function Clone: SOMETimerEvent; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somevGetEventInterval: LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somevSetEventInterval(interval: LongInt); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somevGetEventTime: LongWord; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somevGetEventType: LongWord; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somevSetEventTime(time: LongWord); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somevSetEventType(SOM_type: LongWord); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultInit(var ctrl: Pointer); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDestruct(doFree: Byte; var ctrl: Pointer); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultCopyInit(var ctrl: Pointer; fromObj: SOMETimerEvent); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultAssign(var ctrl: Pointer; fromObj: SOMETimerEvent): SOMETimerEvent; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultConstCopyInit(var ctrl: Pointer; fromObj: SOMETimerEvent); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultVCopyInit(var ctrl: Pointer; fromObj: SOMETimerEvent); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultConstVCopyInit(var ctrl: Pointer; fromObj: SOMETimerEvent); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultConstAssign(var ctrl: Pointer; fromObj: SOMETimerEvent): SOMETimerEvent; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultVAssign(var ctrl: Pointer; fromObj: SOMETimerEvent): SOMETimerEvent; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultConstVAssign(var ctrl: Pointer; fromObj: SOMETimerEvent): SOMETimerEvent; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somInit; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somFree; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somUninit; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetClass: SOMClass; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetClassName: {dual_owned} CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetSize: LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somIsA(aClassObj: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somIsInstanceOf(aClassObj: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somRespondsTo(mId: somId): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDispatch(out retValue: Pointer; methodId: somId; ap: va_list): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somClassDispatch(clsObj: SOMClass; out retValue: Pointer; methodId: somId; ap: va_list): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somCastObj(cls: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somResetObj: CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somPrintSelf: SOMETimerEvent; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDumpSelf(level: LongInt); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDumpSelfInt(level: LongInt); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}

    { Class object access and initialization }
    class function ClassObject: SOMClass; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF} // may be nil before class is created
    class function NewClass: SOMClass; // (not really new every time, but autocreated)

    { Upcasting }
    function As_SOMEEvent: SOMEEvent; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function As_SOMETimerEvent: SOMETimerEvent; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}

    { Downcasting }
    class function Supports(Instance: SOMObjectBase): Boolean; overload;
    class function Supports(Instance: SOMObjectBase; out Obj: SOMETimerEvent): Boolean; overload;

  end;

  TSPortability_Sender = class(SOMObjectBase) { unresolved class name };
  TSPortability_Receiver = class(SOMObjectBase) { unresolved class name };
  TSIdentification = class(SOMObjectBase)
  private
    function _get_sender: TSPortability_Sender; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_receiver: TSPortability_Receiver; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
  public
    class function Create: TSIdentification; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function InitInstance(Instance: Pointer): TSIdentification; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function ClassType: SOMMSingleInstance; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function ClassName: string; reintroduce;
    class function ClassNameIs(const Name: string): Boolean; reintroduce;
    class function InstanceSize: LongInt; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function InheritsFrom(AClass: SOMClass): Boolean; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function MethodAddress(const Name: string): Pointer; reintroduce;
    class function NewInstance: TSIdentification; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function Clone: TSIdentification; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure identify_sender(sender: TSPortability_Sender); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure identify_receiver(receiver: TSPortability_Receiver); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultInit(var ctrl: Pointer); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDestruct(doFree: Byte; var ctrl: Pointer); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultCopyInit(var ctrl: Pointer; fromObj: TSIdentification); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultAssign(var ctrl: Pointer; fromObj: TSIdentification): TSIdentification; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultConstCopyInit(var ctrl: Pointer; fromObj: TSIdentification); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultVCopyInit(var ctrl: Pointer; fromObj: TSIdentification); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultConstVCopyInit(var ctrl: Pointer; fromObj: TSIdentification); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultConstAssign(var ctrl: Pointer; fromObj: TSIdentification): TSIdentification; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultVAssign(var ctrl: Pointer; fromObj: TSIdentification): TSIdentification; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultConstVAssign(var ctrl: Pointer; fromObj: TSIdentification): TSIdentification; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somInit; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somFree; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somUninit; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetClass: SOMMSingleInstance; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetClassName: {dual_owned} CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetSize: LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somIsA(aClassObj: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somIsInstanceOf(aClassObj: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somRespondsTo(mId: somId): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDispatch(out retValue: Pointer; methodId: somId; ap: va_list): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somClassDispatch(clsObj: SOMClass; out retValue: Pointer; methodId: somId; ap: va_list): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somCastObj(cls: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somResetObj: CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somPrintSelf: TSIdentification; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDumpSelf(level: LongInt); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDumpSelfInt(level: LongInt); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}

    { Class object access and initialization }
    class function ClassObject: SOMMSingleInstance; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF} // may be nil before class is created
    class function NewClass: SOMMSingleInstance; // (not really new every time, but autocreated)

    { Upcasting }
    function As_TSIdentification: TSIdentification; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}

    { Downcasting }
    class function Supports(Instance: SOMObjectBase): Boolean; overload;
    class function Supports(Instance: SOMObjectBase; out Obj: TSIdentification): Boolean; overload;

    property sender: TSPortability_Sender read _get_sender;
    property receiver: TSPortability_Receiver read _get_receiver;
  end;

  TypeDef = class(SOMObjectBase)
  private
    function _get_type: TypeCode; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure _set_type(SOM_type: {caller_owns} TypeCode); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_name: CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure _set_name(name: {caller_owns} CORBAString); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_id: CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure _set_id(id: {caller_owns} CORBAString); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_defined_in: CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure _set_defined_in(defined_in: {caller_owns} CORBAString); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function _get_somModifiers: _IDL_Sequence_somModifier; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure _set_somModifiers(const somModifiers: {caller_owns} _IDL_Sequence_somModifier); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
  public
    class function Create: TypeDef; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function InitInstance(Instance: Pointer): TypeDef; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function ClassType: SOMClass; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function ClassName: string; reintroduce;
    class function ClassNameIs(const Name: string): Boolean; reintroduce;
    class function InstanceSize: LongInt; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function InheritsFrom(AClass: SOMClass): Boolean; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function MethodAddress(const Name: string): Pointer; reintroduce;
    class function NewInstance: TypeDef; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function Clone: TypeDef; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function within: _IDL_Sequence_Container; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function describe: Contained_Description; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultInit(var ctrl: Pointer); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDestruct(doFree: Byte; var ctrl: Pointer); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultCopyInit(var ctrl: Pointer; fromObj: TypeDef); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultAssign(var ctrl: Pointer; fromObj: TypeDef): TypeDef; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultConstCopyInit(var ctrl: Pointer; fromObj: TypeDef); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultVCopyInit(var ctrl: Pointer; fromObj: TypeDef); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultConstVCopyInit(var ctrl: Pointer; fromObj: TypeDef); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultConstAssign(var ctrl: Pointer; fromObj: TypeDef): TypeDef; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultVAssign(var ctrl: Pointer; fromObj: TypeDef): TypeDef; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultConstVAssign(var ctrl: Pointer; fromObj: TypeDef): TypeDef; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somInit; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somFree; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somUninit; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetClass: SOMClass; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetClassName: {dual_owned} CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetSize: LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somIsA(aClassObj: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somIsInstanceOf(aClassObj: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somRespondsTo(mId: somId): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDispatch(out retValue: Pointer; methodId: somId; ap: va_list): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somClassDispatch(clsObj: SOMClass; out retValue: Pointer; methodId: somId; ap: va_list): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somCastObj(cls: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somResetObj: CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somPrintSelf: TypeDef; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDumpSelf(level: LongInt); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDumpSelfInt(level: LongInt); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}

    { Class object access and initialization }
    class function ClassObject: SOMClass; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF} // may be nil before class is created
    class function NewClass: SOMClass; // (not really new every time, but autocreated)

    { Upcasting }
    function As_Contained: Contained; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function As_TypeDef: TypeDef; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}

    { Downcasting }
    class function Supports(Instance: SOMObjectBase): Boolean; overload;
    class function Supports(Instance: SOMObjectBase; out Obj: TypeDef): Boolean; overload;

    property SOM_type: TypeCode read _get_type write _set_type;
    property name: CORBAString read _get_name write _set_name;
    property id: CORBAString read _get_id write _set_id;
    property defined_in: CORBAString read _get_defined_in write _set_defined_in;
    property somModifiers: _IDL_Sequence_somModifier read _get_somModifiers write _set_somModifiers;
  end;

  SOMEWorkProcEvent = class(SOMObjectBase)
  public
    class function Create: SOMEWorkProcEvent; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function InitInstance(Instance: Pointer): SOMEWorkProcEvent; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function ClassType: SOMClass; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function ClassName: string; reintroduce;
    class function ClassNameIs(const Name: string): Boolean; reintroduce;
    class function InstanceSize: LongInt; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function InheritsFrom(AClass: SOMClass): Boolean; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    class function MethodAddress(const Name: string): Pointer; reintroduce;
    class function NewInstance: SOMEWorkProcEvent; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function Clone: SOMEWorkProcEvent; reintroduce; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somevGetEventTime: LongWord; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somevGetEventType: LongWord; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somevSetEventTime(time: LongWord); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somevSetEventType(SOM_type: LongWord); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultInit(var ctrl: Pointer); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDestruct(doFree: Byte; var ctrl: Pointer); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultCopyInit(var ctrl: Pointer; fromObj: SOMEWorkProcEvent); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultAssign(var ctrl: Pointer; fromObj: SOMEWorkProcEvent): SOMEWorkProcEvent; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultConstCopyInit(var ctrl: Pointer; fromObj: SOMEWorkProcEvent); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultVCopyInit(var ctrl: Pointer; fromObj: SOMEWorkProcEvent); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDefaultConstVCopyInit(var ctrl: Pointer; fromObj: SOMEWorkProcEvent); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultConstAssign(var ctrl: Pointer; fromObj: SOMEWorkProcEvent): SOMEWorkProcEvent; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultVAssign(var ctrl: Pointer; fromObj: SOMEWorkProcEvent): SOMEWorkProcEvent; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDefaultConstVAssign(var ctrl: Pointer; fromObj: SOMEWorkProcEvent): SOMEWorkProcEvent; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somInit; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somFree; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somUninit; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetClass: SOMClass; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetClassName: {dual_owned} CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somGetSize: LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somIsA(aClassObj: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somIsInstanceOf(aClassObj: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somRespondsTo(mId: somId): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somDispatch(out retValue: Pointer; methodId: somId; ap: va_list): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somClassDispatch(clsObj: SOMClass; out retValue: Pointer; methodId: somId; ap: va_list): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somCastObj(cls: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somResetObj: CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function somPrintSelf: SOMEWorkProcEvent; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDumpSelf(level: LongInt); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    procedure somDumpSelfInt(level: LongInt); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}

    { Class object access and initialization }
    class function ClassObject: SOMClass; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF} // may be nil before class is created
    class function NewClass: SOMClass; // (not really new every time, but autocreated)

    { Upcasting }
    function As_SOMEEvent: SOMEEvent; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
    function As_SOMEWorkProcEvent: SOMEWorkProcEvent; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}

    { Downcasting }
    class function Supports(Instance: SOMObjectBase): Boolean; overload;
    class function Supports(Instance: SOMObjectBase; out Obj: SOMEWorkProcEvent): Boolean; overload;

  end;

  { Arrays }
  _IDL_ArrayOf_SOMObject = array[0 .. (MaxLongInt div (Abs(SizeOf(SOMObject) - 1) + 1)) - 1] of SOMObject;
  _IDL_ArrayOf_Byte = array[0 .. (MaxLongInt div (Abs(SizeOf(Byte) - 1) + 1)) - 1] of Byte;
  _IDL_ArrayOf_SOMObject_somObjectOffset = array[0 .. (MaxLongInt div (Abs(SizeOf(SOMObject_somObjectOffset) - 1) + 1)) - 1] of SOMObject_somObjectOffset;
  _IDL_ArrayOf_Pointer = array[0 .. (MaxLongInt div (Abs(SizeOf(Pointer) - 1) + 1)) - 1] of Pointer;
  _IDL_ArrayOf_SOMClass = array[0 .. (MaxLongInt div (Abs(SizeOf(SOMClass) - 1) + 1)) - 1] of SOMClass;
  _IDL_ArrayOf_SOMClass_somOffsetInfo = array[0 .. (MaxLongInt div (Abs(SizeOf(SOMClass_somOffsetInfo) - 1) + 1)) - 1] of SOMClass_somOffsetInfo;
  _IDL_ArrayOf_somId = array[0 .. (MaxLongInt div (Abs(SizeOf(somId) - 1) + 1)) - 1] of somId;
  _IDL_ArrayOf_CORBAString = array[0 .. (MaxLongInt div (Abs(SizeOf(CORBAString) - 1) + 1)) - 1] of CORBAString;
  _IDL_ArrayOf_ParameterDef_ParameterDescription = array[0 .. (MaxLongInt div (Abs(SizeOf(ParameterDef_ParameterDescription) - 1) + 1)) - 1] of ParameterDef_ParameterDescription;
  _IDL_ArrayOf_ExceptionDef_ExceptionDescription = array[0 .. (MaxLongInt div (Abs(SizeOf(ExceptionDef_ExceptionDescription) - 1) + 1)) - 1] of ExceptionDef_ExceptionDescription;
  _IDL_ArrayOf_OperationDef_OperationDescription = array[0 .. (MaxLongInt div (Abs(SizeOf(OperationDef_OperationDescription) - 1) + 1)) - 1] of OperationDef_OperationDescription;
  _IDL_ArrayOf_AttributeDef_AttributeDescription = array[0 .. (MaxLongInt div (Abs(SizeOf(AttributeDef_AttributeDescription) - 1) + 1)) - 1] of AttributeDef_AttributeDescription;
  _IDL_ArrayOf_somModifier = array[0 .. (MaxLongInt div (Abs(SizeOf(somModifier) - 1) + 1)) - 1] of somModifier;
  _IDL_ArrayOf_Container = array[0 .. (MaxLongInt div (Abs(SizeOf(Container) - 1) + 1)) - 1] of Container;
  _IDL_ArrayOf_Contained = array[0 .. (MaxLongInt div (Abs(SizeOf(Contained) - 1) + 1)) - 1] of Contained;
  _IDL_ArrayOf_Container_ContainerDescription = array[0 .. (MaxLongInt div (Abs(SizeOf(Container_ContainerDescription) - 1) + 1)) - 1] of Container_ContainerDescription;
  _IDL_ArrayOf_ImplementationDef = array[0 .. (MaxLongInt div (Abs(SizeOf(ImplementationDef) - 1) + 1)) - 1] of ImplementationDef;
  _IDL_ArrayOf_SOMDServer = array[0 .. (MaxLongInt div (Abs(SizeOf(SOMDServer) - 1) + 1)) - 1] of SOMDServer;

{ Constants }

const
  tk_null = TCKind(1);
  tk_void = TCKind(2);
  tk_short = TCKind(3);
  tk_long = TCKind(4);
  tk_ushort = TCKind(5);
  tk_ulong = TCKind(6);
  tk_float = TCKind(7);
  tk_double = TCKind(8);
  tk_boolean = TCKind(9);
  tk_char = TCKind(10);
  tk_octet = TCKind(11);
  tk_any = TCKind(12);
  tk_TypeCode = TCKind(13);
  tk_Principal = TCKind(14);
  tk_objref = TCKind(15);
  tk_struct = TCKind(16);
  tk_union = TCKind(17);
  tk_enum = TCKind(18);
  tk_string = TCKind(19);
  tk_sequence = TCKind(20);
  tk_array = TCKind(21);
  tk_pointer = TCKind(101);
  tk_self = TCKind(102);
  tk_foreign = TCKind(103);
  NO_EXCEPTION = exception_type(0);
  USER_EXCEPTION = exception_type(1);
  SYSTEM_EXCEPTION = exception_type(2);
  AttributeDef_NORMAL = AttributeDef_AttributeMode(1);
  AttributeDef_READONLY = AttributeDef_AttributeMode(2);
  YES = completion_status(0);
  NO = completion_status(1);
  MAYBE = completion_status(2);
  SOMD_SOMDVersion = '2.1';
  OperationDef_NORMAL = OperationDef_OperationMode(1);
  OperationDef_ONEWAY = OperationDef_OperationMode(2);
  ParameterDef_IN = ParameterDef_ParameterMode(1);
  ParameterDef_OUT = ParameterDef_ParameterMode(2);
  ParameterDef_INOUT = ParameterDef_ParameterMode(3);
  Repository_NOACCESS = Repository_irOpenErrorCodes(1);
  Repository_BADMAGICNUMBER = Repository_irOpenErrorCodes(2);
  Repository_MISSINGVERSIONINFO = Repository_irOpenErrorCodes(3);
  Repository_IOERROR = Repository_irOpenErrorCodes(4);
  Repository_VERSIONMISMATCH = Repository_irOpenErrorCodes(5);
  ex_Repository_irOpenError = '::Repository::irOpenError';
  somtPrivateE = SOMTTargetTypeT(0);
  somtPublicE = SOMTTargetTypeT(1);
  somtImplementationE = SOMTTargetTypeT(2);
  somtAllE = SOMTTargetTypeT(3);
  somtInternalVE = somtVisibilityT(0);
  somtPublicVE = somtVisibilityT(1);
  somtPrivateVE = somtVisibilityT(2);
  somtDashesE = somtCommentStyleT(0);
  somtCPPE = somtCommentStyleT(1);
  somtCSimpleE = somtCommentStyleT(2);
  somtCBlockE = somtCommentStyleT(3);
  somtInE = somtParameterDirectionT(0);
  somtOutE = somtParameterDirectionT(1);
  somtInOutE = somtParameterDirectionT(2);
  SOMTTemplateOutputC_MAX_INPUT_LINE_LENGTH = 1024;
  SOMTTemplateOutputC_MAX_OUTPUT_LINE_LENGTH = 4096;
  ex_StExcep_UNKNOWN = '::StExcep::UNKNOWN';
  ex_StExcep_BAD_PARAM = '::StExcep::BAD_PARAM';
  ex_StExcep_NO_MEMORY = '::StExcep::NO_MEMORY';
  ex_StExcep_IMP_LIMIT = '::StExcep::IMP_LIMIT';
  ex_StExcep_COMM_FAILURE = '::StExcep::COMM_FAILURE';
  ex_StExcep_INV_OBJREF = '::StExcep::INV_OBJREF';
  ex_StExcep_NO_PERMISSION = '::StExcep::NO_PERMISSION';
  ex_StExcep_INTERNAL = '::StExcep::INTERNAL';
  ex_StExcep_MARSHAL = '::StExcep::MARSHAL';
  ex_StExcep_INITIALIZE = '::StExcep::INITIALIZE';
  ex_StExcep_NO_IMPLEMENT = '::StExcep::NO_IMPLEMENT';
  ex_StExcep_BAD_TYPECODE = '::StExcep::BAD_TYPECODE';
  ex_StExcep_BAD_OPERATION = '::StExcep::BAD_OPERATION';
  ex_StExcep_NO_RESOURCES = '::StExcep::NO_RESOURCES';
  ex_StExcep_NO_RESPONSE = '::StExcep::NO_RESPONSE';
  ex_StExcep_PERSIST_STORE = '::StExcep::PERSIST_STORE';
  ex_StExcep_BAD_INV_ORDER = '::StExcep::BAD_INV_ORDER';
  ex_StExcep_TRANSIENT = '::StExcep::TRANSIENT';
  ex_StExcep_FREE_MEM = '::StExcep::FREE_MEM';
  ex_StExcep_INV_IDENT = '::StExcep::INV_IDENT';
  ex_StExcep_INV_FLAG = '::StExcep::INV_FLAG';
  ex_StExcep_INTF_REPOS = '::StExcep::INTF_REPOS';
  ex_StExcep_CONTEXT = '::StExcep::CONTEXT';
  ex_StExcep_OBJ_ADAPTER = '::StExcep::OBJ_ADAPTER';
  ex_StExcep_DATA_CONVERSION = '::StExcep::DATA_CONVERSION';
  ex_StExcep_OPSYS = '::StExcep::OPSYS';
  ex_StExcep_WMQUIT = '::StExcep::WMQUIT';
  ex_StExcep_DISPATCH = '::StExcep::DISPATCH';
  ex_StExcep_TransactionRequired = '::StExcep::TransactionRequired';
  ex_StExcep_TransactionRolledBack = '::StExcep::TransactionRolledBack';
  ex_StExcep_InvalidTransaction = '::StExcep::InvalidTransaction';
  ex_StExcep_WrongTransaction = '::StExcep::WrongTransaction';
  ex_TSIdentification_NotAvailable = '::TSIdentification::NotAvailable';
  ex_TSIdentification_AlreadyIdentified = '::TSIdentification::AlreadyIdentified';

(*
 *  Method and Data Resolution macros
 *)

(*
 * Default definition of somresolve_ to call the procedure, somResolve.
 * This may be be changed by emitters on systems for which method
 * tokens are thunks.
 *)
function somresolve_(obj: SOMObjectBase; mToken: somMToken): somMethodProc; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}

(*
 *  Method Resolution. Methods are invoked on an object o of some
 *  object class oc, where oc has immediate ancestor classes
 *  called parent classes. Macro arguments include method names
 *  (e.g., mn), object class and parent class names (e.g., ocn, pcn)
 *  and parent class positions (e.g., pcp), expressed in terms of the
 *  left-to-right ordering (beginning with 1, for the first parent)
 *  used when declaring oc's parents. The choice of resolution
 *  macro determines the method table from which methods are selected.
 *
 *  Macros are available to select a method from ...
 *)

(* from oc's mtbl, with verification of o *)
   (*  call somresolve_ but test that the object is well formed and an
       instance of the specified class or a class derived from that class *)

function SOM_Resolve(o: SOMObjectBase; oc: SOMObjectBase{SOMClass}; m: somMToken;
  fileName: PAnsiChar = nil; lineNum: Integer = 0): somMethodProc; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}

(* from oc's mtbl, without verification of o *)
function SOM_ResolveNoCheck(o: SOMObjectBase; oc: SOMObjectBase{SOMClass}; m: somMToken): somMethodProc; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}

  (*
   * Main programs should register for SOM cleanup at exit
   *)

function SOM_MainProgram: SOMClassMgr; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}

(* Check the validity of method resolution using the specified target  *)
(* object.  Note: this macro makes programs bigger and slower.  After  *)
(* you are confident that your program is running correctly you should *)
(* turn off this macro by defining SOM_NoTest, or adding -DSOM_NoTest  *)
(* to your makefile.                                                   *)

function SOM_TestCls(obj: SOMObjectBase; cls: SOMObjectBase{SOMClass};
  fileName: PAnsiChar = nil; lineNum: Integer = 0): SOMObjectBase; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}

function somExceptionId(ev: PEnvironment): PAnsiChar; stdcall;
function somExceptionValue(ev: PEnvironment): Pointer; stdcall;
procedure somExceptionFree(ev: PEnvironment); stdcall;
procedure somSetException(ev: PEnvironment;
    major: exception_type; exception_name: PAnsiChar; params: Pointer); stdcall;
function somGetGlobalEnvironment: PEnvironment; stdcall;

(* Exception function names per CORBA 5.19, p.99 *)
function exception_id(ev: PEnvironment): PAnsiChar; stdcall;
function exception_value(ev: PEnvironment): Pointer; stdcall;
procedure exception_free(ev: PEnvironment); stdcall;

(*  Convenience macros for manipulating environment structures
 *
 *  SOM_CreateLocalEnvironment returns a pointer to an Environment.
 *  The other 3 macros all expect a single argument that is also
 *  a pointer to an Environment.  Use the create/destroy forms for
 *  a dynamic local environment and the init/uninit forms for a stack-based
 *  local environment.
 *
 *  For example
 *
 *      Environment *ev;
 *      ev = SOM_CreateLocalEnvironment ();
 *      ... Use ev in methods
 *      SOM_DestroyLocalEnvironment (ev);
 *
 *  or
 *
 *      Environment ev;
 *      SOM_InitEnvironment (&ev);
 *      ... Use &ev in methods
 *      SOM_UninitEnvironment (&ev);
 *)
function SOM_CreateLocalEnvironment: PEnvironment; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
procedure SOM_DestroyLocalEnvironment(ev: PEnvironment); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
procedure SOM_InitEnvironment(ev: PEnvironment); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
procedure SOM_UninitEnvironment(ev: PEnvironment); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}

// #include <somapi.h>

(*
 *  SOMAPI.H
 *
 *  This file documents the public data structures and functions
 *  of the SOM API (Application Programming Interface). Primitive data
 *  types are defined in sombtype.h, and the public methods provided by
 *  the SOM kernel are declared in somobj.idl, somcls.idl and somcm.idl.
 *  An important header file for language bindings is somdefs.h, which
 *  defines the SOMLINK symbol used in various emitter outputs.
 *
 *  Note: typedefs & prototypes in this file explicitly show pointers
 *  to objects that support an interface described by IDL. These are
 *  C/C++ typedefs that reflect the implementation of object references
 *  in SOM as pointers to structures in memory.
 *)

 (*
  * HISTORY [04/19/96] #21264 nsk Temproary ADD WIN32 Code
  *)

(*  SOM Version Numbers  *)
function Replaceable_SOM_MajorVersion: PLongInt;
function SOM_MajorVersion: LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
function Replaceable_SOM_MinorVersion: PLongInt;
function SOM_MinorVersion: LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}

(*  SOM Thread Support  *)
function Replaceable_SOM_MaxThreads: PLongInt;
function SOM_MaxThreads: LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}

(*----------------------------------------
 * Typedefs for pointers to functions
 *----------------------------------------*)

type
  somTD_SOMMalloc = function(nbytes: UIntPtr): somToken; stdcall;
  PsomTD_SOMMalloc = ^somTD_SOMMalloc;
  somTD_SOMCalloc = function(
    element_count: UIntPtr;
    element_size: UIntPtr): somToken; stdcall;
  PsomTD_SOMCalloc = ^somTD_SOMCalloc;
  somTD_SOMRealloc = function(
    memory: somToken;
    nbytes: UIntPtr): somToken; stdcall;
  PsomTD_SOMRealloc = ^somTD_SOMRealloc;
  somTD_SOMFree = procedure(memory: somToken); stdcall;
  PsomTD_SOMFree = ^somTD_SOMFree;

(*----------------------------------------------------------------------
 * SOM Environment Initialization Section
 *---------------------------------------------------------------------*)

(*
 *  Create and initialize the SOM environment.
 *
 *  This function is idempotent (may be invoked redundantly)
 *
 *  Will be called automatically when first object (including a class
 *  object) is created, if it has not already been done.
 *
 *  Returns the SOMClassMgrObject
 *)
function somEnvironmentNew: SOMClassMgr; stdcall;

procedure somEnvironmentEnd; stdcall;
function somMainProgram: SOMClassMgr; stdcall;
function somAbnormalEnd: ByteBool; stdcall;

(*
 *  Replaceable SOM Memory Management Interfaces
 *
 *  External procedure variables SOMCalloc, SOMFree, SOMMalloc, SOMRealloc
 *  have the same interface as their standard C-library analogs.
 *)
function Replaceable_SOMCalloc: PsomTD_SOMCalloc;
function SOMCalloc(element_count, element_size: UIntPtr): somToken; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
function Replaceable_SOMFree: PsomTD_SOMFree;
procedure SOMFree(memory: somToken); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
procedure SOMMemFree(memory: somToken); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
function Replaceable_SOMMalloc: PsomTD_SOMMalloc;
function SOMMalloc(nbytes: UIntPtr): somToken; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
function Replaceable_SOMRealloc: PsomTD_SOMRealloc;
function SOMRealloc(memory: somToken; nbytes: UIntPtr): somToken; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}

(*
 * Verifies that the passed object is a valid instance of the passed
 * class.  A detected failure generates an error message and causes
 * program termination.  This call is automatically employed as part
 * of the C method resolution macros if the preprocessor variable
 * SOM_TestOn is defined.
 *)
function somTestCls(
    obj: SOMObjectBase;
    classObj: SOMObjectBase{SOMClass};
    fileName: CORBAString;
    lineNumber: Integer): SOMObjectBase; stdcall;

(*
 * Return the class that introduced the method represented by a given
 * method token.
 *)
function somGetClassFromMToken(mToken: somMToken): SOMClass; stdcall;


(*----------------------------------------------------------------------
 *  SOM Id Manager Section
 *---------------------------------------------------------------------*)

(*
 * typedef char* somId; // the "public" somId type (in sombtype.h)
 *
 * This above definition prevents users from building assumptions about
 * how somIds are implemented into their programs. However, a little more
 * information is useful to understand the different alternatives for
 * creating somIds.
 *
 * All somIds point to something called an idKey. The content of the
 * idKey for a somId depends on whether the somId has been registered.
 *
 * The idKey for an unregistered somId is a char* that points to a
 * null-terminated array of chars that is called the id name.
 *
 * When a somId is registered, the idKey it points to is changed to
 * point to a special structure whose representation is not made public.
 * Among other things, of course, this structure contains the address of
 * the id name. Normally the id name for a registered somId will be a copy
 * of the originally indicated name, but copying strings is expensive
 * because it requires dynamic memory allocation. As an alternative, to
 * speed up creation of somIds and minimize memory use, you can use
 * somBeginPersistentIds and somEndPersistentIds to bracket registration
 * of somIds. If you do this, you must use somRelocateIds before the
 * names for any of the "persistent" somIds that you create are changed
 * (or perhaps destroyed as a result of program termination).
 *
 * There are basically two different ways to create registered somIds:
 * from unregistered somIds, or from id names. To create registered
 * somIds from unregistered somIds, you pass the address of an idKey
 * to either somRegisterId or somCheckId; or, to register multiple
 * somIds in one step, you can pass the address of an array of idKeys
 * to somRegisterIds. To create registered somIds from id names, you
 * pass the address of the id name to either somIdFromString or
 * somIdFromStringNoFree. These routines are declared below.
 *)

(*
 * Register a somId. Returns 1 (true) if the id is a new one, and
 * 0 (false) otherwise. An id is new if no previously-registered id
 * has the same name (where name comparison is case-insensitive).
 *)
function somRegisterId(id: somId): LongBool; stdcall;

(*
 * Like somRegisterId, but it returns the somId as its result.
 *)
function somCheckId(id: somId): somId; stdcall;

(*
 * Return a somId that must be freed (using SOMFree) when the user
 * has finished with it.
 *)
function somIdFromString(aString: CORBAString): somId; stdcall;

(*
 * Return a string that must never be freed or modified.
 *)
function somStringFromId(id: somId): CORBAString; stdcall;

(*
 * Returns true (1) if the two ids are equal, else false (0).
 *)
function somCompareIds(id1, id2: somId): LongBool; stdcall;

(*
 * Return the total number of ids that have been registered so far, you
 * can use this to advise the SOM runtime concerning expected number of
 * ids in later executions of your program, via a call to
 * somSetExpectedIds defined below
 *)
function somTotalRegIds: LongWord; stdcall;

(*
 * Tell the SOM runtime how many unique ids you expect to use during
 * the execution of your program, this can improve space and time
 * utilization slightly, this routine must be called before the SOM
 * environment is created to have any effect
 *)
procedure somSetExpectedIds(numIds: LongWord); stdcall;

(*
 * Return the unique key for this id. This is the key used for
 * comparing somIds.
 *)
function somUniqueKey(id: somId): LongWord; stdcall;

(*
 * Signal the beginning of an interval during which the id manager
 * need not copy strings when registering new ids (because the caller
 * knows that these strings will not be destroyed or modified without
 * first calling somRelocateIds for each "persistent" id registered
 * during the interval).
 *)
procedure somBeginPersistentIds; stdcall;

(*
 * End the interval started with somBeginPersistentIds. Tells the
 * id manager that strings for any new ids subsequently registered
 * may be freed or otherwise modified without first calling somRelocateIds.
 * Therefore the id manager must copy the strings remember the name of an
 * id.
 *)
procedure somEndPersistentIds; stdcall;

// #include <somtc.h>

(*
 *  Following constants used with tcNew to create union TypeCodes.
 *  See calling sequences above.
 *)
const
  TCREGULAR_CASE = LongInt(1);
  TCDEFAULT_CASE = LongInt(2);

(* somVaBuf support *)

type
  somVaBuf = type somToken;

function somVaBuf_create(vb: PAnsiChar; size: Integer): somVaBuf; stdcall;
procedure somVaBuf_get_valist(vb: somVaBuf; out ap: va_list); stdcall;
procedure somVaBuf_destroy(vb: somVaBuf); stdcall;
function somVaBuf_add(vb: somVaBuf; arg: Pointer; argType: TCKind): LongInt; stdcall;
function somvalistGetTarget(ap: va_list): LongWord; stdcall;
procedure somvalistSetTarget(ap: va_list; val: LongWord); stdcall;

// not in SOM headers

procedure SOM_UninitEnvironmentOrRaise(ev: PEnvironment); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
procedure SOMFreeAndNil(var Obj);
type
  TAnsiStringArray = array of AnsiString;
// init Buf with nil before; use somVaBuf_destroy on Buf after!
function ArrayOfConstToVaList(var Buf: somVaBuf; var StringBuf: TAnsiStringArray; const Arguments: array of const; AppendNil: Boolean): va_list;

implementation

uses
  Windows;

const
  Unknown_Source = '<unknown>.pas'; // no __FILE__ and __LINE__ macros in Delphi

var
  DLLLoad_CriticalSection : Windows.TRTLCriticalSection;

class procedure SOMObjectBase.Create;
begin
  { hide this method }
end;

procedure SOMObjectBase.Free;
begin
  if Assigned(Self) then SOMObject(Self).somFree;
end;

class procedure SOMObjectBase.InitInstance;
begin
  { hide this method }
end;

procedure SOMObjectBase.CleanupInstance;
begin
  { hard to separate from SOM destructors }
end;

function SOMObjectBase.ClassType: SOMClass;
begin
  Result := SOMObject(Self).somGetClass;
end;

class procedure SOMObjectBase.ClassName;
begin
  { hide this method }
end;

class procedure SOMObjectBase.ClassNameIs;
begin
  { hide this method }
end;

class procedure SOMObjectBase.ClassParent;
begin
  { hide this method }
end;

class procedure SOMObjectBase.ClassInfo;
begin
  { hide this method }
end;

class procedure SOMObjectBase.InstanceSize;
begin
  { hide this method }
end;

class procedure SOMObjectBase.InheritsFrom;
begin
  { hide this method }
end;

class procedure SOMObjectBase.MethodAddress;
begin
  { hide this method }
end;

class procedure SOMObjectBase.MethodName;
begin
  { hide this method }
end;

procedure SOMObjectBase.FieldAddress;
begin
  { hide this method }
end;

procedure SOMObjectBase.GetInterface;
begin
  { hide this method }
end;

class procedure SOMObjectBase.GetInterfaceEntry;
begin
  { hide this method }
end;

class procedure SOMObjectBase.GetInterfaceTable;
begin
  { hide this method }
end;

procedure SOMObjectBase.SafeCallException;
begin
  { hide this method }
end;

procedure SOMObjectBase.AfterConstruction;
begin
  { in SOM that is being done by cooperative metaclass }
end;

procedure SOMObjectBase.BeforeDestruction;
begin
  { in SOM that is being done by cooperative metaclass }
end;

procedure SOMObjectBase.Dispatch;
begin
  { hide this method }
end;

procedure SOMObjectBase.DefaultHandler;
begin
  { hide this method }
end;

class procedure SOMObjectBase.NewInstance;
begin
  { hide this method }
end;

procedure SOMObjectBase.FreeInstance;
begin // somGetClass on almost destroyed object might crash, so we use double dereference
  SOMClass(PPointer(Self)^^).somDeallocate(PAnsiChar(Pointer(Self)));
end;

procedure SOMObjectBase.Destroy;
begin
  SOMObject(Self).somFree;
end;

function SOMObjectBase.As_SOMObject; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
begin
  Result := SOMObject(Self); { upcast }
end;

const
  SOMTC_DLL_Name = 'somtc.dll';

var
  SOMTC_DLL: System.HMODULE = 0;

procedure SOMTC_DLL_Load_Variable(var V_Pointer; const Var_Name: AnsiString);
begin
  if SOMTC_DLL = 0 then
  begin
    Windows.EnterCriticalSection(DLLLoad_CriticalSection);
    if SOMTC_DLL = 0 then
      SOMTC_DLL := Windows.LoadLibraryW(SOMTC_DLL_Name);
    Windows.LeaveCriticalSection(DLLLoad_CriticalSection);
  end;
  if SOMTC_DLL <> 0 then
    Pointer(V_Pointer) := Windows.GetProcAddress(SOMTC_DLL, PAnsiChar(Var_Name));
end;

procedure TypeCode.Free;
begin
  if Assigned(Self) then
  begin
    FreeInstance;
  end;
end;

class procedure TypeCode.InitInstance;
begin
  { hide this method }
end;

procedure TypeCode.CleanupInstance;
begin
  { TypeCode_free does everything at the same time, so no separate Cleanup }
end;

procedure TypeCode.ClassType;
begin
  { hide this method }
end;

class function TypeCode.ClassName: string;
begin
  Result := 'TypeCode';
end;

class function TypeCode.ClassNameIs(const Name: string): Boolean;
begin
  Result := Name = 'TypeCode';
end;

class procedure TypeCode.ClassParent;
begin
  { hide this method }
end;

class procedure TypeCode.ClassInfo;
begin
  { hide this method }
end;

class procedure TypeCode.InstanceSize;
begin
  { hide this method }
end;

class procedure TypeCode.InheritsFrom;
begin
  { hide this method }
end;

class procedure TypeCode.MethodAddress;
begin
  { hide this method }
end;

class procedure TypeCode.MethodName;
begin
  { hide this method }
end;

procedure TypeCode.FieldAddress;
begin
  { hide this method }
end;

procedure TypeCode.GetInterface;
begin
  { hide this method }
end;

class procedure TypeCode.GetInterfaceEntry;
begin
  { hide this method }
end;

class procedure TypeCode.GetInterfaceTable;
begin
  { hide this method }
end;

procedure TypeCode.SafeCallException;
begin
  { hide this method }
end;

procedure TypeCode.AfterConstruction;
begin
  { nothing to do }
end;

procedure TypeCode.BeforeDestruction;
begin
  { nothing to do }
end;

procedure TypeCode.Dispatch;
begin
  { hide this method }
end;

procedure TypeCode.DefaultHandler;
begin
  { hide this method }
end;

class procedure TypeCode.NewInstance;
begin
  { hide this method }
end;

procedure TypeCode_free(t: TypeCode; ev: PEnvironment); stdcall; external SOMTC_DLL_Name name 'tcFree';

procedure TypeCode.FreeInstance;
var
  LocalEnv: Environment;
begin
  SOM_InitEnvironment(@LocalEnv);
  TypeCode_free(Self, @LocalEnv);
  SOM_UninitEnvironmentOrRaise(@LocalEnv);
end;

procedure TypeCode.Destroy;
begin
  FreeInstance;
end;

function TypeCode_kind(t: TypeCode; ev: PEnvironment): TCKind; stdcall; external SOMTC_DLL_Name name 'tcKind';

function TypeCode.GetKind: TCKind;
var
  LocalEnv: Environment;
begin
  SOM_InitEnvironment(@LocalEnv);
  Result := TypeCode_kind(Self, @LocalEnv);
  SOM_UninitEnvironmentOrRaise(@LocalEnv);
end;

function TypeCode_param_count(t: TypeCode; ev: PEnvironment): LongInt; stdcall; external SOMTC_DLL_Name name 'tcParmCount';

function TypeCode.GetParamCount: LongInt;
var
  LocalEnv: Environment;
begin
  SOM_InitEnvironment(@LocalEnv);
  Result := TypeCode_param_count(Self, @LocalEnv);
  SOM_UninitEnvironmentOrRaise(@LocalEnv);
end;

function TypeCode_parameter(t: TypeCode; ev: PEnvironment; index: LongInt): TAnyResult; stdcall; external SOMTC_DLL_Name name 'tcParameter';

function TypeCode.GetParameter(index: LongInt): any;
var
  LocalEnv: Environment;
begin
  SOM_InitEnvironment(@LocalEnv);
  Result := any(TypeCode_parameter(Self, @LocalEnv, index));
  SOM_UninitEnvironmentOrRaise(@LocalEnv);
end;

function TypeCode_alignment(t: TypeCode; ev: PEnvironment): SmallInt; stdcall; external SOMTC_DLL_Name name 'tcAlignment';

function TypeCode.GetAlignment: SmallInt;
var
  LocalEnv: Environment;
begin
  SOM_InitEnvironment(@LocalEnv);
  Result := TypeCode_alignment(Self, @LocalEnv);
  SOM_UninitEnvironmentOrRaise(@LocalEnv);
end;

procedure TypeCode_setAlignment(t: TypeCode; ev: PEnvironment; a: SmallInt); stdcall; external SOMTC_DLL_Name name 'tcSetAlignment';

procedure TypeCode.SetAlignment(a: SmallInt);
var
  LocalEnv: Environment;
begin
  SOM_InitEnvironment(@LocalEnv);
  TypeCode_setAlignment(Self, @LocalEnv, a);
  SOM_UninitEnvironmentOrRaise(@LocalEnv);
end;

function TypeCode_size(t: TypeCode; ev: PEnvironment): LongInt; stdcall; external SOMTC_DLL_Name name 'tcSize';

function TypeCode.GetSize: LongInt;
var
  LocalEnv: Environment;
begin
  SOM_InitEnvironment(@LocalEnv);
  Result := TypeCode_size(Self, @LocalEnv);
  SOM_UninitEnvironmentOrRaise(@LocalEnv);
end;

var
  SOMTC_DLL_TC__null: TypeCode = TypeCode(nil);

class function TypeCode.TC_null: TypeCode;
begin
  if Assigned(SOMTC_DLL_TC__null) then
    Result := SOMTC_DLL_TC__null
  else
  begin
    SOMTC_DLL_Load_Variable(SOMTC_DLL_TC__null, 'TC__null');
    Result := SOMTC_DLL_TC__null;
  end;
end;

var
  SOMTC_DLL_TC__void: TypeCode = TypeCode(nil);

class function TypeCode.TC_void: TypeCode;
begin
  if Assigned(SOMTC_DLL_TC__void) then
    Result := SOMTC_DLL_TC__void
  else
  begin
    SOMTC_DLL_Load_Variable(SOMTC_DLL_TC__void, 'TC__void');
    Result := SOMTC_DLL_TC__void;
  end;
end;

var
  SOMTC_DLL_TC__short: TypeCode = TypeCode(nil);

class function TypeCode.TC_short: TypeCode;
begin
  if Assigned(SOMTC_DLL_TC__short) then
    Result := SOMTC_DLL_TC__short
  else
  begin
    SOMTC_DLL_Load_Variable(SOMTC_DLL_TC__short, 'TC__short');
    Result := SOMTC_DLL_TC__short;
  end;
end;

var
  SOMTC_DLL_TC__long: TypeCode = TypeCode(nil);

class function TypeCode.TC_long: TypeCode;
begin
  if Assigned(SOMTC_DLL_TC__long) then
    Result := SOMTC_DLL_TC__long
  else
  begin
    SOMTC_DLL_Load_Variable(SOMTC_DLL_TC__long, 'TC__long');
    Result := SOMTC_DLL_TC__long;
  end;
end;

var
  SOMTC_DLL_TC__ushort: TypeCode = TypeCode(nil);

class function TypeCode.TC_ushort: TypeCode;
begin
  if Assigned(SOMTC_DLL_TC__ushort) then
    Result := SOMTC_DLL_TC__ushort
  else
  begin
    SOMTC_DLL_Load_Variable(SOMTC_DLL_TC__ushort, 'TC__ushort');
    Result := SOMTC_DLL_TC__ushort;
  end;
end;

var
  SOMTC_DLL_TC__ulong: TypeCode = TypeCode(nil);

class function TypeCode.TC_ulong: TypeCode;
begin
  if Assigned(SOMTC_DLL_TC__ulong) then
    Result := SOMTC_DLL_TC__ulong
  else
  begin
    SOMTC_DLL_Load_Variable(SOMTC_DLL_TC__ulong, 'TC__ulong');
    Result := SOMTC_DLL_TC__ulong;
  end;
end;

var
  SOMTC_DLL_TC__float: TypeCode = TypeCode(nil);

class function TypeCode.TC_float: TypeCode;
begin
  if Assigned(SOMTC_DLL_TC__float) then
    Result := SOMTC_DLL_TC__float
  else
  begin
    SOMTC_DLL_Load_Variable(SOMTC_DLL_TC__float, 'TC__float');
    Result := SOMTC_DLL_TC__float;
  end;
end;

var
  SOMTC_DLL_TC__double: TypeCode = TypeCode(nil);

class function TypeCode.TC_double: TypeCode;
begin
  if Assigned(SOMTC_DLL_TC__double) then
    Result := SOMTC_DLL_TC__double
  else
  begin
    SOMTC_DLL_Load_Variable(SOMTC_DLL_TC__double, 'TC__double');
    Result := SOMTC_DLL_TC__double;
  end;
end;

var
  SOMTC_DLL_TC__boolean: TypeCode = TypeCode(nil);

class function TypeCode.TC_boolean: TypeCode;
begin
  if Assigned(SOMTC_DLL_TC__boolean) then
    Result := SOMTC_DLL_TC__boolean
  else
  begin
    SOMTC_DLL_Load_Variable(SOMTC_DLL_TC__boolean, 'TC__boolean');
    Result := SOMTC_DLL_TC__boolean;
  end;
end;

var
  SOMTC_DLL_TC__char: TypeCode = TypeCode(nil);

class function TypeCode.TC_char: TypeCode;
begin
  if Assigned(SOMTC_DLL_TC__char) then
    Result := SOMTC_DLL_TC__char
  else
  begin
    SOMTC_DLL_Load_Variable(SOMTC_DLL_TC__char, 'TC__char');
    Result := SOMTC_DLL_TC__char;
  end;
end;

var
  SOMTC_DLL_TC__octet: TypeCode = TypeCode(nil);

class function TypeCode.TC_octet: TypeCode;
begin
  if Assigned(SOMTC_DLL_TC__octet) then
    Result := SOMTC_DLL_TC__octet
  else
  begin
    SOMTC_DLL_Load_Variable(SOMTC_DLL_TC__octet, 'TC__octet');
    Result := SOMTC_DLL_TC__octet;
  end;
end;

var
  SOMTC_DLL_TC__any: TypeCode = TypeCode(nil);

class function TypeCode.TC_any: TypeCode;
begin
  if Assigned(SOMTC_DLL_TC__any) then
    Result := SOMTC_DLL_TC__any
  else
  begin
    SOMTC_DLL_Load_Variable(SOMTC_DLL_TC__any, 'TC__any');
    Result := SOMTC_DLL_TC__any;
  end;
end;

var
  SOMTC_DLL_TC__TypeCode: TypeCode = TypeCode(nil);

class function TypeCode.TC_TypeCode: TypeCode;
begin
  if Assigned(SOMTC_DLL_TC__TypeCode) then
    Result := SOMTC_DLL_TC__TypeCode
  else
  begin
    SOMTC_DLL_Load_Variable(SOMTC_DLL_TC__TypeCode, 'TC__TypeCode');
    Result := SOMTC_DLL_TC__TypeCode;
  end;
end;

var
  SOMTC_DLL_TC__Principal: TypeCode = TypeCode(nil);

class function TypeCode.TC_Principal: TypeCode;
begin
  if Assigned(SOMTC_DLL_TC__Principal) then
    Result := SOMTC_DLL_TC__Principal
  else
  begin
    SOMTC_DLL_Load_Variable(SOMTC_DLL_TC__Principal, 'TC__Principal');
    Result := SOMTC_DLL_TC__Principal;
  end;
end;

var
  SOMTC_DLL_TC__Object: TypeCode = TypeCode(nil);

class function TypeCode.TC_Object: TypeCode;
begin
  if Assigned(SOMTC_DLL_TC__Object) then
    Result := SOMTC_DLL_TC__Object
  else
  begin
    SOMTC_DLL_Load_Variable(SOMTC_DLL_TC__Object, 'TC__Object');
    Result := SOMTC_DLL_TC__Object;
  end;
end;

var
  SOMTC_DLL_TC__string: TypeCode = TypeCode(nil);

class function TypeCode.TC_string: TypeCode;
begin
  if Assigned(SOMTC_DLL_TC__string) then
    Result := SOMTC_DLL_TC__string
  else
  begin
    SOMTC_DLL_Load_Variable(SOMTC_DLL_TC__string, 'TC__string');
    Result := SOMTC_DLL_TC__string;
  end;
end;

var
  SOMTC_DLL_TC__NamedValue: TypeCode = TypeCode(nil);

class function TypeCode.TC_NamedValue: TypeCode;
begin
  if Assigned(SOMTC_DLL_TC__NamedValue) then
    Result := SOMTC_DLL_TC__NamedValue
  else
  begin
    SOMTC_DLL_Load_Variable(SOMTC_DLL_TC__NamedValue, 'TC__NamedValue');
    Result := SOMTC_DLL_TC__NamedValue;
  end;
end;

var
  SOMTC_DLL_TC__InterfaceDescription: TypeCode = TypeCode(nil);

class function TypeCode.TC_InterfaceDescription: TypeCode;
begin
  if Assigned(SOMTC_DLL_TC__InterfaceDescription) then
    Result := SOMTC_DLL_TC__InterfaceDescription
  else
  begin
    SOMTC_DLL_Load_Variable(SOMTC_DLL_TC__InterfaceDescription, 'TC__InterfaceDescription');
    Result := SOMTC_DLL_TC__InterfaceDescription;
  end;
end;

var
  SOMTC_DLL_TC__OperationDescription: TypeCode = TypeCode(nil);

class function TypeCode.TC_OperationDescription: TypeCode;
begin
  if Assigned(SOMTC_DLL_TC__OperationDescription) then
    Result := SOMTC_DLL_TC__OperationDescription
  else
  begin
    SOMTC_DLL_Load_Variable(SOMTC_DLL_TC__OperationDescription, 'TC__OperationDescription');
    Result := SOMTC_DLL_TC__OperationDescription;
  end;
end;

var
  SOMTC_DLL_TC__AttributeDescription: TypeCode = TypeCode(nil);

class function TypeCode.TC_AttributeDescription: TypeCode;
begin
  if Assigned(SOMTC_DLL_TC__AttributeDescription) then
    Result := SOMTC_DLL_TC__AttributeDescription
  else
  begin
    SOMTC_DLL_Load_Variable(SOMTC_DLL_TC__AttributeDescription, 'TC__AttributeDescription');
    Result := SOMTC_DLL_TC__AttributeDescription;
  end;
end;

var
  SOMTC_DLL_TC__ParameterDescription: TypeCode = TypeCode(nil);

class function TypeCode.TC_ParameterDescription: TypeCode;
begin
  if Assigned(SOMTC_DLL_TC__ParameterDescription) then
    Result := SOMTC_DLL_TC__ParameterDescription
  else
  begin
    SOMTC_DLL_Load_Variable(SOMTC_DLL_TC__ParameterDescription, 'TC__ParameterDescription');
    Result := SOMTC_DLL_TC__ParameterDescription;
  end;
end;

var
  SOMTC_DLL_TC__RepositoryDescription: TypeCode = TypeCode(nil);

class function TypeCode.TC_RepositoryDescription: TypeCode;
begin
  if Assigned(SOMTC_DLL_TC__RepositoryDescription) then
    Result := SOMTC_DLL_TC__RepositoryDescription
  else
  begin
    SOMTC_DLL_Load_Variable(SOMTC_DLL_TC__RepositoryDescription, 'TC__RepositoryDescription');
    Result := SOMTC_DLL_TC__RepositoryDescription;
  end;
end;

var
  SOMTC_DLL_TC__ModuleDescription: TypeCode = TypeCode(nil);

class function TypeCode.TC_ModuleDescription: TypeCode;
begin
  if Assigned(SOMTC_DLL_TC__ModuleDescription) then
    Result := SOMTC_DLL_TC__ModuleDescription
  else
  begin
    SOMTC_DLL_Load_Variable(SOMTC_DLL_TC__ModuleDescription, 'TC__ModuleDescription');
    Result := SOMTC_DLL_TC__ModuleDescription;
  end;
end;

var
  SOMTC_DLL_TC__ConstDescription: TypeCode = TypeCode(nil);

class function TypeCode.TC_ConstDescription: TypeCode;
begin
  if Assigned(SOMTC_DLL_TC__ConstDescription) then
    Result := SOMTC_DLL_TC__ConstDescription
  else
  begin
    SOMTC_DLL_Load_Variable(SOMTC_DLL_TC__ConstDescription, 'TC__ConstDescription');
    Result := SOMTC_DLL_TC__ConstDescription;
  end;
end;

var
  SOMTC_DLL_TC__ConstantDescription: TypeCode = TypeCode(nil);

class function TypeCode.TC_ConstantDescription: TypeCode;
begin
  if Assigned(SOMTC_DLL_TC__ConstantDescription) then
    Result := SOMTC_DLL_TC__ConstantDescription
  else
  begin
    SOMTC_DLL_Load_Variable(SOMTC_DLL_TC__ConstantDescription, 'TC__ConstantDescription');
    Result := SOMTC_DLL_TC__ConstantDescription;
  end;
end;

var
  SOMTC_DLL_TC__ExceptionDescription: TypeCode = TypeCode(nil);

class function TypeCode.TC_ExceptionDescription: TypeCode;
begin
  if Assigned(SOMTC_DLL_TC__ExceptionDescription) then
    Result := SOMTC_DLL_TC__ExceptionDescription
  else
  begin
    SOMTC_DLL_Load_Variable(SOMTC_DLL_TC__ExceptionDescription, 'TC__ExceptionDescription');
    Result := SOMTC_DLL_TC__ExceptionDescription;
  end;
end;

var
  SOMTC_DLL_TC__TypeDescription: TypeCode = TypeCode(nil);

class function TypeCode.TC_TypeDescription: TypeCode;
begin
  if Assigned(SOMTC_DLL_TC__TypeDescription) then
    Result := SOMTC_DLL_TC__TypeDescription
  else
  begin
    SOMTC_DLL_Load_Variable(SOMTC_DLL_TC__TypeDescription, 'TC__TypeDescription');
    Result := SOMTC_DLL_TC__TypeDescription;
  end;
end;

var
  SOMTC_DLL_TC__FullInterfaceDescription: TypeCode = TypeCode(nil);

class function TypeCode.TC_FullInterfaceDescription: TypeCode;
begin
  if Assigned(SOMTC_DLL_TC__FullInterfaceDescription) then
    Result := SOMTC_DLL_TC__FullInterfaceDescription
  else
  begin
    SOMTC_DLL_Load_Variable(SOMTC_DLL_TC__FullInterfaceDescription, 'TC__FullInterfaceDescription');
    Result := SOMTC_DLL_TC__FullInterfaceDescription;
  end;
end;

function TypeCode_equal(x: TypeCode; ev: PEnvironment; y: TypeCode): CORBABoolean; stdcall; external SOMTC_DLL_Name name 'tcEqual';

function TypeCode.Equal(y: TypeCode): CORBABoolean;
var
  LocalEnv: Environment;
begin
  SOM_InitEnvironment(@LocalEnv);
  Result := TypeCode_equal(Self, @LocalEnv, y);
  SOM_UninitEnvironmentOrRaise(@LocalEnv);
end;

function TypeCode_copy(t: TypeCode; ev: PEnvironment): TypeCode; stdcall; external SOMTC_DLL_Name name 'tcCopy';

function TypeCode.Copy: TypeCode;
var
  LocalEnv: Environment;
begin
  SOM_InitEnvironment(@LocalEnv);
  Result := TypeCode_copy(Self, @LocalEnv);
  SOM_UninitEnvironmentOrRaise(@LocalEnv);
end;

procedure TypeCode_print(t: TypeCode; ev: PEnvironment); stdcall; external SOMTC_DLL_Name name 'tcPrint';

procedure TypeCode.Print;
var
  LocalEnv: Environment;
begin
  SOM_InitEnvironment(@LocalEnv);
  TypeCode_print(Self, @LocalEnv);
  SOM_UninitEnvironmentOrRaise(@LocalEnv);
end;

function TypeCodeNewVL(tag: TCKind; ap: va_list): TypeCode; stdcall; external SOMTC_DLL_Name name 'tcNewVL';

class function TypeCode.Create(tag: TCKind): TypeCode;
begin
  Result := TypeCode.Create(tag, []);
end;

class function TypeCode.Create(tag: TCKind; const Arguments: array of const): TypeCode;
var
  Buf: somVaBuf;
  StringBuf: TAnsiStringArray;
begin
  Buf := nil;
  try
    Result := TypeCodeNewVL(tag, ArrayOfConstToVaList(Buf, StringBuf, Arguments, True));
    // if not Assigned(Result) then raise something;
  finally
    somVaBuf_destroy(Buf);
  end;
end;

class function TypeCode.Create(tag: TCKind; ap: va_list): TypeCode;
begin
  Result := TypeCodeNewVL(tag, ap);
  // if not Assigned(Result) then raise something;
end;

function ESOMException.GetNestedEnvironment: PEnvironment; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
begin
  Result := @FNestedEnvironment;
end;

constructor ESOMException.Create(ev: PEnvironment); // clears ev
var
  Msg: string;
begin
  if ev <> @FNestedEnvironment then // not from parent constructor
  begin
    Move(ev^, FNestedEnvironment, SizeOf(Environment));
    FillChar(ev^, SizeOf(Environment), 0);
  end;
  FMajor := FNestedEnvironment._major;
  case FMajor of
    SYSTEM_EXCEPTION: begin
      FExceptionId := somExceptionId(@FNestedEnvironment);
      FExceptionValue := somExceptionValue(@FNestedEnvironment);
      Msg := 'Error occured; exception string: ' + FExceptionId + '; ' +
        'minor error code: ' + IntToStr(PStExcep(FExceptionValue).minor) + '; ' +
        'completion code: ';
      case PStExcep(FExceptionValue).completed of
        YES: Msg := Msg + 'YES';
        NO: Msg := Msg + 'YES';
      else Msg := Msg + 'MAYBE';
      end;
    end;
    USER_EXCEPTION: begin
      FExceptionId := somExceptionId(@FNestedEnvironment);
      FExceptionValue := somExceptionValue(@FNestedEnvironment);
      Msg := 'Error occured; exception string: ' + FExceptionId;
    end;
  else Msg := 'Exception created from empty environment';
  end;
  inherited Create(Msg);
end;

constructor ESOMException.Create(AMajor: exception_type; const AExceptionId: string; AExceptionValue: Pointer); // from user code
var
  S: AnsiString;
begin
  S := AExceptionId;
  somSetException(@FNestedEnvironment, AMajor, PAnsiChar(S), AExceptionValue);
  Create(@FNestedEnvironment);
end;

destructor ESOMException.Destroy;
begin
  SOM_UninitEnvironment(@FNestedEnvironment);
  inherited;
end;

procedure ESOMException.ResetNestedEnvironment;
begin
  FillChar(FNestedEnvironment, SizeOf(Environment), 0);
end;

const
  SOM_DLL_Name = 'som.dll';

var
  SOM_DLL: System.HMODULE = 0;

procedure SOM_DLL_Load_Variable(var V_Pointer; const Var_Name: AnsiString);
begin
  if SOM_DLL = 0 then
  begin
    Windows.EnterCriticalSection(DLLLoad_CriticalSection);
    if SOM_DLL = 0 then
      SOM_DLL := Windows.LoadLibraryW(SOM_DLL_Name);
    Windows.LeaveCriticalSection(DLLLoad_CriticalSection);
  end;
  if SOM_DLL <> 0 then
    Pointer(V_Pointer) := Windows.GetProcAddress(SOM_DLL, PAnsiChar(Var_Name));
end;

const
  SOMObject_MajorVersion = 1;
  SOMObject_MinorVersion = 4;

(*
 * Declare the class creation procedure
 *)
function SOMObjectNewClass(
  somtmajorVersion: integer4 = SOMObject_MajorVersion;
  somtminorVersion: integer4 = SOMObject_MinorVersion):
  SOMClass; stdcall; external SOM_DLL_Name name 'SOMObjectNewClass';

(*
 * Declare the ABI 2 ClassData structure
 *)
type
  SOMObjectClassDataStructure = packed record
    classObject: SOMClass;
    somInit,
    somUninit,
    somFree,
    somDefaultVCopyInit,
    somGetClassName,
    somGetClass,
    somIsA,
    somRespondsTo,
    somIsInstanceOf,
    somGetSize,
    somDumpSelf,
    somDumpSelfInt,
    somPrintSelf,
    somDefaultConstVCopyInit,
    somDispatchV,
    somDispatchL,
    somDispatchA,
    somDispatchD,
    somDispatch,
    somClassDispatch,
    somCastObj,
    somResetObj,
    somDefaultInit,
    somDestruct,
    somPrivate1,
    somPrivate2,
    somDefaultCopyInit,
    somDefaultConstCopyInit,
    somDefaultAssign,
    somDefaultConstAssign,
    somDefaultVAssign,
    somDefaultConstVAssign: somMToken;
  end;
  PSOMObjectClassDataStructure = ^SOMObjectClassDataStructure;

var
  SOM_DLL_SOMObjectClassData: PSOMObjectClassDataStructure = nil;

function SOMObjectClassData: PSOMObjectClassDataStructure;
begin
  if Assigned(SOM_DLL_SOMObjectClassData) then
    Result := SOM_DLL_SOMObjectClassData
  else
  begin
    SOM_DLL_Load_Variable(SOM_DLL_SOMObjectClassData, 'SOMObjectClassData');
    Result := SOM_DLL_SOMObjectClassData;
  end;
end;

(*
 * Declare the ABI 2 CClassData structure
 *)
type
  SOMObjectCClassDataStructure = packed record
    parentMtab: somMethodTabs;
    instanceDataToken: somDToken;
  end;
  PSOMObjectCClassDataStructure = ^SOMObjectCClassDataStructure;

var
  SOM_DLL_SOMObjectCClassData: PSOMObjectCClassDataStructure = nil;

function SOMObjectCClassData: PSOMObjectCClassDataStructure;
begin
  if Assigned(SOM_DLL_SOMObjectCClassData) then
    Result := SOM_DLL_SOMObjectCClassData
  else
  begin
    SOM_DLL_Load_Variable(SOM_DLL_SOMObjectCClassData, 'SOMObjectCClassData');
    Result := SOM_DLL_SOMObjectCClassData;
  end;
end;

(*
 * Class Object and Method Token Macros
 *)

class function SOMObject.Create: SOMObject; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
begin
  Result := SOMObject(SOMClass(NewClass).somNew);
end;

class function SOMObject.InitInstance(Instance: Pointer): SOMObject; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
begin
  Result := SOMObject(SOMClass(NewClass).somRenewNoInit(Instance));
end;

function SOMObject.ClassType: SOMClass; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
begin
  Result := SOMClass(SOMObject(Self).somGetClass);
end;

class function SOMObject.ClassName: string;
begin
  Result := AnsiString(SOMClass(NewClass).somGetName);
end;

class function SOMObject.ClassNameIs(const Name: string): Boolean;
begin
  Result := AnsiString(SOMClass(NewClass).somGetName) = Name;
end;

class function SOMObject.InstanceSize: LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
begin
  Result := SOMClass(NewClass).somGetInstanceSize;
end;

class function SOMObject.InheritsFrom(AClass: SOMClass): Boolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
begin
  Result := SOMClass(NewClass).somDescendedFrom(AClass);
end;

class function SOMObject.MethodAddress(const Name: string): Pointer;
var
  NameAsAnsiString: AnsiString;
  NameAsSomId: somId;
begin
  NameAsAnsiString := AnsiString(Name);
  NameAsSomId := somIdFromString(PAnsiChar(NameAsAnsiString));
  try
    SOMClass(NewClass).somFindMethod(NameAsSomId, Result);
  finally
    SOMMemFree(NameAsSomId);
  end;
end;

class function SOMObject.NewInstance: SOMObject; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
begin
  Result := SOMObject(SOMClass(NewClass).somNewNoInit);
end;

function SOMObject.Clone: SOMObject; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
begin
  Result := SOMObject(SOMClass(somGetClass).somNewNoInit);
  SOMObject(Result).somDefaultCopyInit(somInitCtrl(nil^), SOMObject(Self));
end;

(*
 * New Method: somDefaultInit
 *)
type
  somTD_SOMObject_somDefaultInit = procedure(somSelf: SOMObjectBase; var ctrl: Pointer); stdcall;

procedure SOMObject.somDefaultInit(var ctrl: Pointer); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somDefaultInit
   (SOM_Resolve(Self, cd.classObject, cd.somDefaultInit))
     (Self, ctrl);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

(*
 * New Method: somDestruct
 *)
type
  somTD_SOMObject_somDestruct = procedure(somSelf: SOMObjectBase; doFree: Byte; var ctrl: Pointer); stdcall;

procedure SOMObject.somDestruct(doFree: Byte; var ctrl: Pointer); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somDestruct
   (SOM_Resolve(Self, cd.classObject, cd.somDestruct))
     (Self, doFree, ctrl);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

(*
 * New Method: somDefaultCopyInit
 *)
type
  somTD_SOMObject_somDefaultCopyInit = procedure(somSelf: SOMObjectBase; var ctrl: Pointer; fromObj: SOMObjectBase); stdcall;

procedure SOMObject.somDefaultCopyInit(var ctrl: Pointer; fromObj: SOMObject); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somDefaultCopyInit
   (SOM_Resolve(Self, cd.classObject, cd.somDefaultCopyInit))
     (Self, ctrl, fromObj);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

(*
 * New Method: somDefaultAssign
 *)
type
  somTD_SOMObject_somDefaultAssign = function(somSelf: SOMObjectBase; var ctrl: Pointer; fromObj: SOMObjectBase): SOMObject; stdcall;

function SOMObject.somDefaultAssign(var ctrl: Pointer; fromObj: SOMObject): SOMObject; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result := SOMObject(
  somTD_SOMObject_somDefaultAssign
   (SOM_Resolve(Self, cd.classObject, cd.somDefaultAssign))
     (Self, ctrl, fromObj));
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

(*
 * New Method: somDefaultConstCopyInit
 *)
type
  somTD_SOMObject_somDefaultConstCopyInit = procedure(somSelf: SOMObjectBase; var ctrl: Pointer; fromObj: SOMObjectBase); stdcall;

procedure SOMObject.somDefaultConstCopyInit(var ctrl: Pointer; fromObj: SOMObject); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somDefaultConstCopyInit
   (SOM_Resolve(Self, cd.classObject, cd.somDefaultConstCopyInit))
     (Self, ctrl, fromObj);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

(*
 * New Method: somDefaultVCopyInit
 *)
type
  somTD_SOMObject_somDefaultVCopyInit = procedure(somSelf: SOMObjectBase; var ctrl: Pointer; fromObj: SOMObjectBase); stdcall;

procedure SOMObject.somDefaultVCopyInit(var ctrl: Pointer; fromObj: SOMObject); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somDefaultVCopyInit
   (SOM_Resolve(Self, cd.classObject, cd.somDefaultVCopyInit))
     (Self, ctrl, fromObj);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

(*
 * New Method: somDefaultConstVCopyInit
 *)
type
  somTD_SOMObject_somDefaultConstVCopyInit = procedure(somSelf: SOMObjectBase; var ctrl: Pointer; fromObj: SOMObjectBase); stdcall;

procedure SOMObject.somDefaultConstVCopyInit(var ctrl: Pointer; fromObj: SOMObject); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somDefaultConstVCopyInit
   (SOM_Resolve(Self, cd.classObject, cd.somDefaultConstVCopyInit))
     (Self, ctrl, fromObj);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

(*
 * New Method: somDefaultConstAssign
 *)
type
  somTD_SOMObject_somDefaultConstAssign = function(somSelf: SOMObjectBase; var ctrl: Pointer; fromObj: SOMObjectBase): SOMObject; stdcall;

function SOMObject.somDefaultConstAssign(var ctrl: Pointer; fromObj: SOMObject): SOMObject; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result := SOMObject(
  somTD_SOMObject_somDefaultConstAssign
   (SOM_Resolve(Self, cd.classObject, cd.somDefaultConstAssign))
     (Self, ctrl, fromObj));
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

(*
 * New Method: somDefaultVAssign
 *)
type
  somTD_SOMObject_somDefaultVAssign = function(somSelf: SOMObjectBase; var ctrl: Pointer; fromObj: SOMObjectBase): SOMObject; stdcall;

function SOMObject.somDefaultVAssign(var ctrl: Pointer; fromObj: SOMObject): SOMObject; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result := SOMObject(
  somTD_SOMObject_somDefaultVAssign
   (SOM_Resolve(Self, cd.classObject, cd.somDefaultVAssign))
     (Self, ctrl, fromObj));
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

(*
 * New Method: somDefaultConstVAssign
 *)
type
  somTD_SOMObject_somDefaultConstVAssign = function(somSelf: SOMObjectBase; var ctrl: Pointer; fromObj: SOMObjectBase): SOMObject; stdcall;

function SOMObject.somDefaultConstVAssign(var ctrl: Pointer; fromObj: SOMObject): SOMObject; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result := SOMObject(
  somTD_SOMObject_somDefaultConstVAssign
   (SOM_Resolve(Self, cd.classObject, cd.somDefaultConstVAssign))
     (Self, ctrl, fromObj));
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

(*
 * New Method: somInit
 *)
type
  somTD_SOMObject_somInit = procedure(somSelf: SOMObjectBase); stdcall;

procedure SOMObject.somInit; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somInit
   (SOM_Resolve(Self, cd.classObject, cd.somInit))
     (Self);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

(*
 * New Method: somFree
 *)
type
  somTD_SOMObject_somFree = procedure(somSelf: SOMObjectBase); stdcall;

procedure SOMObject.somFree; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somFree
   (SOM_Resolve(Self, cd.classObject, cd.somFree))
     (Self);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

(*
 * New Method: somUninit
 *)
type
  somTD_SOMObject_somUninit = procedure(somSelf: SOMObjectBase); stdcall;

procedure SOMObject.somUninit; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somUninit
   (SOM_Resolve(Self, cd.classObject, cd.somUninit))
     (Self);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

(*
 * New Method: somGetClass
 *)
type
  somTD_SOMObject_somGetClass = function(somSelf: SOMObjectBase): SOMClass; stdcall;

function SOMObject.somGetClass: SOMClass; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result := SOMClass(
  somTD_SOMObject_somGetClass
   (SOM_Resolve(Self, cd.classObject, cd.somGetClass))
     (Self));
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

(*
 * New Method: somGetClassName
 *)
type
  somTD_SOMObject_somGetClassName = function(somSelf: SOMObjectBase): {dual_owned} CORBAString; stdcall;

function SOMObject.somGetClassName: {dual_owned} CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result :=
  somTD_SOMObject_somGetClassName
   (SOM_Resolve(Self, cd.classObject, cd.somGetClassName))
     (Self);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

(*
 * New Method: somGetSize
 *)
type
  somTD_SOMObject_somGetSize = function(somSelf: SOMObjectBase): LongInt; stdcall;

function SOMObject.somGetSize: LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result :=
  somTD_SOMObject_somGetSize
   (SOM_Resolve(Self, cd.classObject, cd.somGetSize))
     (Self);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

(*
 * New Method: somIsA
 *)
type
  somTD_SOMObject_somIsA = function(somSelf: SOMObjectBase; aClassObj: SOMClass): CORBABoolean; stdcall;

function SOMObject.somIsA(aClassObj: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result :=
  somTD_SOMObject_somIsA
   (SOM_Resolve(Self, cd.classObject, cd.somIsA))
     (Self, aClassObj);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

(*
 * New Method: somIsInstanceOf
 *)
type
  somTD_SOMObject_somIsInstanceOf = function(somSelf: SOMObjectBase; aClassObj: SOMClass): CORBABoolean; stdcall;

function SOMObject.somIsInstanceOf(aClassObj: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result :=
  somTD_SOMObject_somIsInstanceOf
   (SOM_Resolve(Self, cd.classObject, cd.somIsInstanceOf))
     (Self, aClassObj);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

(*
 * New Method: somRespondsTo
 *)
type
  somTD_SOMObject_somRespondsTo = function(somSelf: SOMObjectBase; mId: somId): CORBABoolean; stdcall;

function SOMObject.somRespondsTo(mId: somId): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result :=
  somTD_SOMObject_somRespondsTo
   (SOM_Resolve(Self, cd.classObject, cd.somRespondsTo))
     (Self, mId);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

(*
 * New Method: somDispatch
 *)
type
  somTD_SOMObject_somDispatch = function(somSelf: SOMObjectBase; out retValue: Pointer; methodId: somId; ap: va_list): CORBABoolean; stdcall;

function SOMObject.somDispatch(out retValue: Pointer; methodId: somId; ap: va_list): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result :=
  somTD_SOMObject_somDispatch
   (SOM_Resolve(Self, cd.classObject, cd.somDispatch))
     (Self, retValue, methodId, ap);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

(*
 * New Method: somClassDispatch
 *)
type
  somTD_SOMObject_somClassDispatch = function(somSelf: SOMObjectBase; clsObj: SOMClass; out retValue: Pointer; methodId: somId; ap: va_list): CORBABoolean; stdcall;

function SOMObject.somClassDispatch(clsObj: SOMClass; out retValue: Pointer; methodId: somId; ap: va_list): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result :=
  somTD_SOMObject_somClassDispatch
   (SOM_Resolve(Self, cd.classObject, cd.somClassDispatch))
     (Self, clsObj, retValue, methodId, ap);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

(*
 * New Method: somCastObj
 *)
type
  somTD_SOMObject_somCastObj = function(somSelf: SOMObjectBase; cls: SOMClass): CORBABoolean; stdcall;

function SOMObject.somCastObj(cls: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result :=
  somTD_SOMObject_somCastObj
   (SOM_Resolve(Self, cd.classObject, cd.somCastObj))
     (Self, cls);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

(*
 * New Method: somResetObj
 *)
type
  somTD_SOMObject_somResetObj = function(somSelf: SOMObjectBase): CORBABoolean; stdcall;

function SOMObject.somResetObj: CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result :=
  somTD_SOMObject_somResetObj
   (SOM_Resolve(Self, cd.classObject, cd.somResetObj))
     (Self);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

(*
 * New Method: somPrintSelf
 *)
type
  somTD_SOMObject_somPrintSelf = function(somSelf: SOMObjectBase): SOMObject; stdcall;

function SOMObject.somPrintSelf: SOMObject; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result := SOMObject(
  somTD_SOMObject_somPrintSelf
   (SOM_Resolve(Self, cd.classObject, cd.somPrintSelf))
     (Self));
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

(*
 * New Method: somDumpSelf
 *)
type
  somTD_SOMObject_somDumpSelf = procedure(somSelf: SOMObjectBase; level: LongInt); stdcall;

procedure SOMObject.somDumpSelf(level: LongInt); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somDumpSelf
   (SOM_Resolve(Self, cd.classObject, cd.somDumpSelf))
     (Self, level);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

(*
 * New Method: somDumpSelfInt
 *)
type
  somTD_SOMObject_somDumpSelfInt = procedure(somSelf: SOMObjectBase; level: LongInt); stdcall;

procedure SOMObject.somDumpSelfInt(level: LongInt); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somDumpSelfInt
   (SOM_Resolve(Self, cd.classObject, cd.somDumpSelfInt))
     (Self, level);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

class function SOMObject.ClassObject: SOMClass; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
begin
  if Self = SOMObject then { invoked on class name literal }
  begin
    Result := SOMClass(SOMObjectClassData.classObject);
  end
  else { invoked on SOM object }
  begin
    Result := SOMClass(PPointer(Self)^);
  end
end;

class function SOMObject.NewClass: SOMClass;
begin
  if Self = SOMObject then { invoked on class name literal }
  begin
    Result := SOMClass(SOMObjectClassData.classObject);
    if not Assigned(Result) then Result := SOMClass(SOMObjectNewClass);
  end
  else { invoked on SOM object }
  begin
    Result := SOMClass(PPointer(Self)^);
  end
end;

class function SOMObject.Supports(Instance: SOMObjectBase): Boolean;
var
  cls: SOMClass;
begin
  if not Assigned(Instance) then
  begin
    Result := False;
  end
  else
  begin
    cls := SOMClass(ClassObject);
    if not Assigned(cls) then
    begin
      Result := False;
    end
    else
    begin
      Result := SOMObject(Instance).somIsA(cls);
    end;
  end;
end;

class function SOMObject.Supports(Instance: SOMObjectBase; out Obj: SOMObject): Boolean;
var
  cls: SOMClass;
begin
  if not Assigned(Instance) then
  begin
    Result := False;
    Obj := nil;
  end
  else
  begin
    cls := SOMClass(ClassObject);
    if not Assigned(cls) then
    begin
      Result := False;
      Obj := nil;
    end
    else if SOMObject(Instance).somIsA(cls) then
    begin
      Result := True;
      Obj := SOMObject(Instance);
    end
    else
    begin
      Result := False;
      Obj := nil;
    end;
  end;
end;

const
  SOMIR_DLL_Name = 'somir.dll';

var
  SOMIR_DLL: System.HMODULE = 0;

procedure SOMIR_DLL_Load_Variable(var V_Pointer; const Var_Name: AnsiString);
begin
  if SOMIR_DLL = 0 then
  begin
    Windows.EnterCriticalSection(DLLLoad_CriticalSection);
    if SOMIR_DLL = 0 then
      SOMIR_DLL := Windows.LoadLibraryW(SOMIR_DLL_Name);
    Windows.LeaveCriticalSection(DLLLoad_CriticalSection);
  end;
  if SOMIR_DLL <> 0 then
    Pointer(V_Pointer) := Windows.GetProcAddress(SOMIR_DLL, PAnsiChar(Var_Name));
end;

const
  Contained_MajorVersion = 2;
  Contained_MinorVersion = 1;

(*
 * Declare the class creation procedure
 *)
function ContainedNewClass(
  somtmajorVersion: integer4 = Contained_MajorVersion;
  somtminorVersion: integer4 = Contained_MinorVersion):
  SOMClass; stdcall; external SOMIR_DLL_Name name 'ContainedNewClass';

(*
 * Declare the ABI 2 ClassData structure
 *)
type
  ContainedClassDataStructure = packed record
    classObject: SOMClass;
    within,
    describe,
    _get_name,
    _set_name,
    _get_id,
    _set_id,
    _get_defined_in,
    _set_defined_in,
    _get_somModifiers,
    _set_somModifiers: somMToken;
  end;
  PContainedClassDataStructure = ^ContainedClassDataStructure;

var
  SOMIR_DLL_ContainedClassData: PContainedClassDataStructure = nil;

function ContainedClassData: PContainedClassDataStructure;
begin
  if Assigned(SOMIR_DLL_ContainedClassData) then
    Result := SOMIR_DLL_ContainedClassData
  else
  begin
    SOMIR_DLL_Load_Variable(SOMIR_DLL_ContainedClassData, 'ContainedClassData');
    Result := SOMIR_DLL_ContainedClassData;
  end;
end;

(*
 * Declare the ABI 2 CClassData structure
 *)
type
  ContainedCClassDataStructure = packed record
    parentMtab: somMethodTabs;
    instanceDataToken: somDToken;
  end;
  PContainedCClassDataStructure = ^ContainedCClassDataStructure;

var
  SOMIR_DLL_ContainedCClassData: PContainedCClassDataStructure = nil;

function ContainedCClassData: PContainedCClassDataStructure;
begin
  if Assigned(SOMIR_DLL_ContainedCClassData) then
    Result := SOMIR_DLL_ContainedCClassData
  else
  begin
    SOMIR_DLL_Load_Variable(SOMIR_DLL_ContainedCClassData, 'ContainedCClassData');
    Result := SOMIR_DLL_ContainedCClassData;
  end;
end;

(*
 * Class Object and Method Token Macros
 *)

(*
 * New Method: _get_name
 *)
type
  somTD_Contained__get_name = function(somSelf: SOMObjectBase{Contained}; ev: PEnvironment): CORBAString; stdcall;

function Contained._get_name: CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PContainedClassDataStructure;
  LocalEnv: Environment;
begin
  cd := ContainedClassData;
  SOM_InitEnvironment(@LocalEnv);
  Result :=
  somTD_Contained__get_name
   (SOM_Resolve(Self, cd.classObject, cd._get_name))
     (Self, @LocalEnv);
  SOM_UninitEnvironmentOrRaise(@LocalEnv);
end;

(*
 * New Method: _set_name
 *)
type
  somTD_Contained__set_name = procedure(somSelf: SOMObjectBase{Contained}; ev: PEnvironment; name: {caller_owns} CORBAString); stdcall;

procedure Contained._set_name(name: {caller_owns} CORBAString); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PContainedClassDataStructure;
  LocalEnv: Environment;
begin
  cd := ContainedClassData;
  SOM_InitEnvironment(@LocalEnv);
  somTD_Contained__set_name
   (SOM_Resolve(Self, cd.classObject, cd._set_name))
     (Self, @LocalEnv, name);
  SOM_UninitEnvironmentOrRaise(@LocalEnv);
end;

(*
 * New Method: _get_id
 *)
type
  somTD_Contained__get_id = function(somSelf: SOMObjectBase{Contained}; ev: PEnvironment): CORBAString; stdcall;

function Contained._get_id: CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PContainedClassDataStructure;
  LocalEnv: Environment;
begin
  cd := ContainedClassData;
  SOM_InitEnvironment(@LocalEnv);
  Result :=
  somTD_Contained__get_id
   (SOM_Resolve(Self, cd.classObject, cd._get_id))
     (Self, @LocalEnv);
  SOM_UninitEnvironmentOrRaise(@LocalEnv);
end;

(*
 * New Method: _set_id
 *)
type
  somTD_Contained__set_id = procedure(somSelf: SOMObjectBase{Contained}; ev: PEnvironment; id: {caller_owns} CORBAString); stdcall;

procedure Contained._set_id(id: {caller_owns} CORBAString); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PContainedClassDataStructure;
  LocalEnv: Environment;
begin
  cd := ContainedClassData;
  SOM_InitEnvironment(@LocalEnv);
  somTD_Contained__set_id
   (SOM_Resolve(Self, cd.classObject, cd._set_id))
     (Self, @LocalEnv, id);
  SOM_UninitEnvironmentOrRaise(@LocalEnv);
end;

(*
 * New Method: _get_defined_in
 *)
type
  somTD_Contained__get_defined_in = function(somSelf: SOMObjectBase{Contained}; ev: PEnvironment): CORBAString; stdcall;

function Contained._get_defined_in: CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PContainedClassDataStructure;
  LocalEnv: Environment;
begin
  cd := ContainedClassData;
  SOM_InitEnvironment(@LocalEnv);
  Result :=
  somTD_Contained__get_defined_in
   (SOM_Resolve(Self, cd.classObject, cd._get_defined_in))
     (Self, @LocalEnv);
  SOM_UninitEnvironmentOrRaise(@LocalEnv);
end;

(*
 * New Method: _set_defined_in
 *)
type
  somTD_Contained__set_defined_in = procedure(somSelf: SOMObjectBase{Contained}; ev: PEnvironment; defined_in: {caller_owns} CORBAString); stdcall;

procedure Contained._set_defined_in(defined_in: {caller_owns} CORBAString); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PContainedClassDataStructure;
  LocalEnv: Environment;
begin
  cd := ContainedClassData;
  SOM_InitEnvironment(@LocalEnv);
  somTD_Contained__set_defined_in
   (SOM_Resolve(Self, cd.classObject, cd._set_defined_in))
     (Self, @LocalEnv, defined_in);
  SOM_UninitEnvironmentOrRaise(@LocalEnv);
end;

(*
 * New Method: _get_somModifiers
 *)
type
  somTD_Contained__get_somModifiers = function(somSelf: SOMObjectBase{Contained}; ev: PEnvironment): _IDL_Sequence_somModifier; stdcall;

function Contained._get_somModifiers: _IDL_Sequence_somModifier; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PContainedClassDataStructure;
  LocalEnv: Environment;
begin
  cd := ContainedClassData;
  SOM_InitEnvironment(@LocalEnv);
  Result :=
  somTD_Contained__get_somModifiers
   (SOM_Resolve(Self, cd.classObject, cd._get_somModifiers))
     (Self, @LocalEnv);
  SOM_UninitEnvironmentOrRaise(@LocalEnv);
end;

(*
 * New Method: _set_somModifiers
 *)
type
  somTD_Contained__set_somModifiers = procedure(somSelf: SOMObjectBase{Contained}; ev: PEnvironment; const somModifiers: {caller_owns} _IDL_Sequence_somModifier); stdcall;

procedure Contained._set_somModifiers(const somModifiers: {caller_owns} _IDL_Sequence_somModifier); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PContainedClassDataStructure;
  LocalEnv: Environment;
begin
  cd := ContainedClassData;
  SOM_InitEnvironment(@LocalEnv);
  somTD_Contained__set_somModifiers
   (SOM_Resolve(Self, cd.classObject, cd._set_somModifiers))
     (Self, @LocalEnv, somModifiers);
  SOM_UninitEnvironmentOrRaise(@LocalEnv);
end;

class function Contained.Create: Contained; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
begin
  Result := Contained(SOMClass(NewClass).somNew);
end;

class function Contained.InitInstance(Instance: Pointer): Contained; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
begin
  Result := Contained(SOMClass(NewClass).somRenewNoInit(Instance));
end;

function Contained.ClassType: SOMClass; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
begin
  Result := SOMClass(SOMObject(Self).somGetClass);
end;

class function Contained.ClassName: string;
begin
  Result := AnsiString(SOMClass(NewClass).somGetName);
end;

class function Contained.ClassNameIs(const Name: string): Boolean;
begin
  Result := AnsiString(SOMClass(NewClass).somGetName) = Name;
end;

class function Contained.InstanceSize: LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
begin
  Result := SOMClass(NewClass).somGetInstanceSize;
end;

class function Contained.InheritsFrom(AClass: SOMClass): Boolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
begin
  Result := SOMClass(NewClass).somDescendedFrom(AClass);
end;

class function Contained.MethodAddress(const Name: string): Pointer;
var
  NameAsAnsiString: AnsiString;
  NameAsSomId: somId;
begin
  NameAsAnsiString := AnsiString(Name);
  NameAsSomId := somIdFromString(PAnsiChar(NameAsAnsiString));
  try
    SOMClass(NewClass).somFindMethod(NameAsSomId, Result);
  finally
    SOMMemFree(NameAsSomId);
  end;
end;

class function Contained.NewInstance: Contained; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
begin
  Result := Contained(SOMClass(NewClass).somNewNoInit);
end;

function Contained.Clone: Contained; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
begin
  Result := Contained(SOMClass(somGetClass).somNewNoInit);
  SOMObject(Result).somDefaultCopyInit(somInitCtrl(nil^), SOMObject(Self));
end;

(*
 * New Method: within
 *)
type
  somTD_Contained_within = function(somSelf: SOMObjectBase{Contained}; ev: PEnvironment): _IDL_Sequence_Container; stdcall;

function Contained.within: _IDL_Sequence_Container; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PContainedClassDataStructure;
  LocalEnv: Environment;
begin
  cd := ContainedClassData;
  SOM_InitEnvironment(@LocalEnv);
  Result :=
  somTD_Contained_within
   (SOM_Resolve(Self, cd.classObject, cd.within))
     (Self, @LocalEnv);
  SOM_UninitEnvironmentOrRaise(@LocalEnv);
end;

(*
 * New Method: describe
 *)
type
  somTD_Contained_describe = function(somSelf: SOMObjectBase{Contained}; ev: PEnvironment): Contained_Description; stdcall;

function Contained.describe: Contained_Description; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PContainedClassDataStructure;
  LocalEnv: Environment;
begin
  cd := ContainedClassData;
  SOM_InitEnvironment(@LocalEnv);
  Result :=
  somTD_Contained_describe
   (SOM_Resolve(Self, cd.classObject, cd.describe))
     (Self, @LocalEnv);
  SOM_UninitEnvironmentOrRaise(@LocalEnv);
end;

procedure Contained.somDefaultInit(var ctrl: Pointer); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somDefaultInit
   (SOM_Resolve(Self, cd.classObject, cd.somDefaultInit))
     (Self, ctrl);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

procedure Contained.somDestruct(doFree: Byte; var ctrl: Pointer); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somDestruct
   (SOM_Resolve(Self, cd.classObject, cd.somDestruct))
     (Self, doFree, ctrl);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

procedure Contained.somDefaultCopyInit(var ctrl: Pointer; fromObj: Contained); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somDefaultCopyInit
   (SOM_Resolve(Self, cd.classObject, cd.somDefaultCopyInit))
     (Self, ctrl, fromObj);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function Contained.somDefaultAssign(var ctrl: Pointer; fromObj: Contained): Contained; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result := Contained(
  somTD_SOMObject_somDefaultAssign
   (SOM_Resolve(Self, cd.classObject, cd.somDefaultAssign))
     (Self, ctrl, fromObj));
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

procedure Contained.somDefaultConstCopyInit(var ctrl: Pointer; fromObj: Contained); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somDefaultConstCopyInit
   (SOM_Resolve(Self, cd.classObject, cd.somDefaultConstCopyInit))
     (Self, ctrl, fromObj);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

procedure Contained.somDefaultVCopyInit(var ctrl: Pointer; fromObj: Contained); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somDefaultVCopyInit
   (SOM_Resolve(Self, cd.classObject, cd.somDefaultVCopyInit))
     (Self, ctrl, fromObj);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

procedure Contained.somDefaultConstVCopyInit(var ctrl: Pointer; fromObj: Contained); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somDefaultConstVCopyInit
   (SOM_Resolve(Self, cd.classObject, cd.somDefaultConstVCopyInit))
     (Self, ctrl, fromObj);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function Contained.somDefaultConstAssign(var ctrl: Pointer; fromObj: Contained): Contained; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result := Contained(
  somTD_SOMObject_somDefaultConstAssign
   (SOM_Resolve(Self, cd.classObject, cd.somDefaultConstAssign))
     (Self, ctrl, fromObj));
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function Contained.somDefaultVAssign(var ctrl: Pointer; fromObj: Contained): Contained; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result := Contained(
  somTD_SOMObject_somDefaultVAssign
   (SOM_Resolve(Self, cd.classObject, cd.somDefaultVAssign))
     (Self, ctrl, fromObj));
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function Contained.somDefaultConstVAssign(var ctrl: Pointer; fromObj: Contained): Contained; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result := Contained(
  somTD_SOMObject_somDefaultConstVAssign
   (SOM_Resolve(Self, cd.classObject, cd.somDefaultConstVAssign))
     (Self, ctrl, fromObj));
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

procedure Contained.somInit; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somInit
   (SOM_Resolve(Self, cd.classObject, cd.somInit))
     (Self);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

procedure Contained.somFree; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somFree
   (SOM_Resolve(Self, cd.classObject, cd.somFree))
     (Self);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

procedure Contained.somUninit; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somUninit
   (SOM_Resolve(Self, cd.classObject, cd.somUninit))
     (Self);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function Contained.somGetClass: SOMClass; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result := SOMClass(
  somTD_SOMObject_somGetClass
   (SOM_Resolve(Self, cd.classObject, cd.somGetClass))
     (Self));
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function Contained.somGetClassName: {dual_owned} CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result :=
  somTD_SOMObject_somGetClassName
   (SOM_Resolve(Self, cd.classObject, cd.somGetClassName))
     (Self);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function Contained.somGetSize: LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result :=
  somTD_SOMObject_somGetSize
   (SOM_Resolve(Self, cd.classObject, cd.somGetSize))
     (Self);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function Contained.somIsA(aClassObj: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result :=
  somTD_SOMObject_somIsA
   (SOM_Resolve(Self, cd.classObject, cd.somIsA))
     (Self, aClassObj);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function Contained.somIsInstanceOf(aClassObj: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result :=
  somTD_SOMObject_somIsInstanceOf
   (SOM_Resolve(Self, cd.classObject, cd.somIsInstanceOf))
     (Self, aClassObj);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function Contained.somRespondsTo(mId: somId): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result :=
  somTD_SOMObject_somRespondsTo
   (SOM_Resolve(Self, cd.classObject, cd.somRespondsTo))
     (Self, mId);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function Contained.somDispatch(out retValue: Pointer; methodId: somId; ap: va_list): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result :=
  somTD_SOMObject_somDispatch
   (SOM_Resolve(Self, cd.classObject, cd.somDispatch))
     (Self, retValue, methodId, ap);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function Contained.somClassDispatch(clsObj: SOMClass; out retValue: Pointer; methodId: somId; ap: va_list): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result :=
  somTD_SOMObject_somClassDispatch
   (SOM_Resolve(Self, cd.classObject, cd.somClassDispatch))
     (Self, clsObj, retValue, methodId, ap);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function Contained.somCastObj(cls: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result :=
  somTD_SOMObject_somCastObj
   (SOM_Resolve(Self, cd.classObject, cd.somCastObj))
     (Self, cls);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function Contained.somResetObj: CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result :=
  somTD_SOMObject_somResetObj
   (SOM_Resolve(Self, cd.classObject, cd.somResetObj))
     (Self);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function Contained.somPrintSelf: Contained; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result := Contained(
  somTD_SOMObject_somPrintSelf
   (SOM_Resolve(Self, cd.classObject, cd.somPrintSelf))
     (Self));
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

procedure Contained.somDumpSelf(level: LongInt); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somDumpSelf
   (SOM_Resolve(Self, cd.classObject, cd.somDumpSelf))
     (Self, level);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

procedure Contained.somDumpSelfInt(level: LongInt); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somDumpSelfInt
   (SOM_Resolve(Self, cd.classObject, cd.somDumpSelfInt))
     (Self, level);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

class function Contained.ClassObject: SOMClass; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
begin
  if Self = Contained then { invoked on class name literal }
  begin
    Result := SOMClass(ContainedClassData.classObject);
  end
  else { invoked on SOM object }
  begin
    Result := SOMClass(PPointer(Self)^);
  end
end;

class function Contained.NewClass: SOMClass;
begin
  if Self = Contained then { invoked on class name literal }
  begin
    Result := SOMClass(ContainedClassData.classObject);
    if not Assigned(Result) then Result := SOMClass(ContainedNewClass);
  end
  else { invoked on SOM object }
  begin
    Result := SOMClass(PPointer(Self)^);
  end
end;

function Contained.As_Contained: Contained; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
begin
  Result := Self;
end;

class function Contained.Supports(Instance: SOMObjectBase): Boolean;
var
  cls: SOMClass;
begin
  if not Assigned(Instance) then
  begin
    Result := False;
  end
  else
  begin
    cls := SOMClass(ClassObject);
    if not Assigned(cls) then
    begin
      Result := False;
    end
    else
    begin
      Result := SOMObject(Instance).somIsA(cls);
    end;
  end;
end;

class function Contained.Supports(Instance: SOMObjectBase; out Obj: Contained): Boolean;
var
  cls: SOMClass;
begin
  if not Assigned(Instance) then
  begin
    Result := False;
    Obj := nil;
  end
  else
  begin
    cls := SOMClass(ClassObject);
    if not Assigned(cls) then
    begin
      Result := False;
      Obj := nil;
    end
    else if SOMObject(Instance).somIsA(cls) then
    begin
      Result := True;
      Obj := Contained(Instance);
    end
    else
    begin
      Result := False;
      Obj := nil;
    end;
  end;
end;

const
  AttributeDef_MajorVersion = 2;
  AttributeDef_MinorVersion = 1;

(*
 * Declare the class creation procedure
 *)
function AttributeDefNewClass(
  somtmajorVersion: integer4 = AttributeDef_MajorVersion;
  somtminorVersion: integer4 = AttributeDef_MinorVersion):
  SOMClass; stdcall; external SOMIR_DLL_Name name 'AttributeDefNewClass';

(*
 * Declare the ABI 2 ClassData structure
 *)
type
  AttributeDefClassDataStructure = packed record
    classObject: SOMClass;
    _get_type,
    _set_type,
    _get_mode,
    _set_mode: somMToken;
  end;
  PAttributeDefClassDataStructure = ^AttributeDefClassDataStructure;

var
  SOMIR_DLL_AttributeDefClassData: PAttributeDefClassDataStructure = nil;

function AttributeDefClassData: PAttributeDefClassDataStructure;
begin
  if Assigned(SOMIR_DLL_AttributeDefClassData) then
    Result := SOMIR_DLL_AttributeDefClassData
  else
  begin
    SOMIR_DLL_Load_Variable(SOMIR_DLL_AttributeDefClassData, 'AttributeDefClassData');
    Result := SOMIR_DLL_AttributeDefClassData;
  end;
end;

(*
 * Declare the ABI 2 CClassData structure
 *)
type
  AttributeDefCClassDataStructure = packed record
    parentMtab: somMethodTabs;
    instanceDataToken: somDToken;
  end;
  PAttributeDefCClassDataStructure = ^AttributeDefCClassDataStructure;

var
  SOMIR_DLL_AttributeDefCClassData: PAttributeDefCClassDataStructure = nil;

function AttributeDefCClassData: PAttributeDefCClassDataStructure;
begin
  if Assigned(SOMIR_DLL_AttributeDefCClassData) then
    Result := SOMIR_DLL_AttributeDefCClassData
  else
  begin
    SOMIR_DLL_Load_Variable(SOMIR_DLL_AttributeDefCClassData, 'AttributeDefCClassData');
    Result := SOMIR_DLL_AttributeDefCClassData;
  end;
end;

(*
 * Class Object and Method Token Macros
 *)

(*
 * New Method: _get_type
 *)
type
  somTD_AttributeDef__get_type = function(somSelf: SOMObjectBase{AttributeDef}; ev: PEnvironment): TypeCode; stdcall;

function AttributeDef._get_type: TypeCode; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PAttributeDefClassDataStructure;
  LocalEnv: Environment;
begin
  cd := AttributeDefClassData;
  SOM_InitEnvironment(@LocalEnv);
  Result :=
  somTD_AttributeDef__get_type
   (SOM_Resolve(Self, cd.classObject, cd._get_type))
     (Self, @LocalEnv);
  SOM_UninitEnvironmentOrRaise(@LocalEnv);
end;

(*
 * New Method: _set_type
 *)
type
  somTD_AttributeDef__set_type = procedure(somSelf: SOMObjectBase{AttributeDef}; ev: PEnvironment; SOM_type: {caller_owns} TypeCode); stdcall;

procedure AttributeDef._set_type(SOM_type: {caller_owns} TypeCode); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PAttributeDefClassDataStructure;
  LocalEnv: Environment;
begin
  cd := AttributeDefClassData;
  SOM_InitEnvironment(@LocalEnv);
  somTD_AttributeDef__set_type
   (SOM_Resolve(Self, cd.classObject, cd._set_type))
     (Self, @LocalEnv, SOM_type);
  SOM_UninitEnvironmentOrRaise(@LocalEnv);
end;

(*
 * New Method: _get_mode
 *)
type
  somTD_AttributeDef__get_mode = function(somSelf: SOMObjectBase{AttributeDef}; ev: PEnvironment): AttributeDef_AttributeMode; stdcall;

function AttributeDef._get_mode: AttributeDef_AttributeMode; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PAttributeDefClassDataStructure;
  LocalEnv: Environment;
begin
  cd := AttributeDefClassData;
  SOM_InitEnvironment(@LocalEnv);
  Result :=
  somTD_AttributeDef__get_mode
   (SOM_Resolve(Self, cd.classObject, cd._get_mode))
     (Self, @LocalEnv);
  SOM_UninitEnvironmentOrRaise(@LocalEnv);
end;

(*
 * New Method: _set_mode
 *)
type
  somTD_AttributeDef__set_mode = procedure(somSelf: SOMObjectBase{AttributeDef}; ev: PEnvironment; mode: AttributeDef_AttributeMode); stdcall;

procedure AttributeDef._set_mode(mode: AttributeDef_AttributeMode); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PAttributeDefClassDataStructure;
  LocalEnv: Environment;
begin
  cd := AttributeDefClassData;
  SOM_InitEnvironment(@LocalEnv);
  somTD_AttributeDef__set_mode
   (SOM_Resolve(Self, cd.classObject, cd._set_mode))
     (Self, @LocalEnv, mode);
  SOM_UninitEnvironmentOrRaise(@LocalEnv);
end;

function AttributeDef._get_name: CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PContainedClassDataStructure;
  LocalEnv: Environment;
begin
  cd := ContainedClassData;
  SOM_InitEnvironment(@LocalEnv);
  Result :=
  somTD_Contained__get_name
   (SOM_Resolve(Self, cd.classObject, cd._get_name))
     (Self, @LocalEnv);
  SOM_UninitEnvironmentOrRaise(@LocalEnv);
end;

procedure AttributeDef._set_name(name: {caller_owns} CORBAString); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PContainedClassDataStructure;
  LocalEnv: Environment;
begin
  cd := ContainedClassData;
  SOM_InitEnvironment(@LocalEnv);
  somTD_Contained__set_name
   (SOM_Resolve(Self, cd.classObject, cd._set_name))
     (Self, @LocalEnv, name);
  SOM_UninitEnvironmentOrRaise(@LocalEnv);
end;

function AttributeDef._get_id: CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PContainedClassDataStructure;
  LocalEnv: Environment;
begin
  cd := ContainedClassData;
  SOM_InitEnvironment(@LocalEnv);
  Result :=
  somTD_Contained__get_id
   (SOM_Resolve(Self, cd.classObject, cd._get_id))
     (Self, @LocalEnv);
  SOM_UninitEnvironmentOrRaise(@LocalEnv);
end;

procedure AttributeDef._set_id(id: {caller_owns} CORBAString); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PContainedClassDataStructure;
  LocalEnv: Environment;
begin
  cd := ContainedClassData;
  SOM_InitEnvironment(@LocalEnv);
  somTD_Contained__set_id
   (SOM_Resolve(Self, cd.classObject, cd._set_id))
     (Self, @LocalEnv, id);
  SOM_UninitEnvironmentOrRaise(@LocalEnv);
end;

function AttributeDef._get_defined_in: CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PContainedClassDataStructure;
  LocalEnv: Environment;
begin
  cd := ContainedClassData;
  SOM_InitEnvironment(@LocalEnv);
  Result :=
  somTD_Contained__get_defined_in
   (SOM_Resolve(Self, cd.classObject, cd._get_defined_in))
     (Self, @LocalEnv);
  SOM_UninitEnvironmentOrRaise(@LocalEnv);
end;

procedure AttributeDef._set_defined_in(defined_in: {caller_owns} CORBAString); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PContainedClassDataStructure;
  LocalEnv: Environment;
begin
  cd := ContainedClassData;
  SOM_InitEnvironment(@LocalEnv);
  somTD_Contained__set_defined_in
   (SOM_Resolve(Self, cd.classObject, cd._set_defined_in))
     (Self, @LocalEnv, defined_in);
  SOM_UninitEnvironmentOrRaise(@LocalEnv);
end;

function AttributeDef._get_somModifiers: _IDL_Sequence_somModifier; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PContainedClassDataStructure;
  LocalEnv: Environment;
begin
  cd := ContainedClassData;
  SOM_InitEnvironment(@LocalEnv);
  Result :=
  somTD_Contained__get_somModifiers
   (SOM_Resolve(Self, cd.classObject, cd._get_somModifiers))
     (Self, @LocalEnv);
  SOM_UninitEnvironmentOrRaise(@LocalEnv);
end;

procedure AttributeDef._set_somModifiers(const somModifiers: {caller_owns} _IDL_Sequence_somModifier); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PContainedClassDataStructure;
  LocalEnv: Environment;
begin
  cd := ContainedClassData;
  SOM_InitEnvironment(@LocalEnv);
  somTD_Contained__set_somModifiers
   (SOM_Resolve(Self, cd.classObject, cd._set_somModifiers))
     (Self, @LocalEnv, somModifiers);
  SOM_UninitEnvironmentOrRaise(@LocalEnv);
end;

class function AttributeDef.Create: AttributeDef; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
begin
  Result := AttributeDef(SOMClass(NewClass).somNew);
end;

class function AttributeDef.InitInstance(Instance: Pointer): AttributeDef; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
begin
  Result := AttributeDef(SOMClass(NewClass).somRenewNoInit(Instance));
end;

function AttributeDef.ClassType: SOMClass; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
begin
  Result := SOMClass(SOMObject(Self).somGetClass);
end;

class function AttributeDef.ClassName: string;
begin
  Result := AnsiString(SOMClass(NewClass).somGetName);
end;

class function AttributeDef.ClassNameIs(const Name: string): Boolean;
begin
  Result := AnsiString(SOMClass(NewClass).somGetName) = Name;
end;

class function AttributeDef.InstanceSize: LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
begin
  Result := SOMClass(NewClass).somGetInstanceSize;
end;

class function AttributeDef.InheritsFrom(AClass: SOMClass): Boolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
begin
  Result := SOMClass(NewClass).somDescendedFrom(AClass);
end;

class function AttributeDef.MethodAddress(const Name: string): Pointer;
var
  NameAsAnsiString: AnsiString;
  NameAsSomId: somId;
begin
  NameAsAnsiString := AnsiString(Name);
  NameAsSomId := somIdFromString(PAnsiChar(NameAsAnsiString));
  try
    SOMClass(NewClass).somFindMethod(NameAsSomId, Result);
  finally
    SOMMemFree(NameAsSomId);
  end;
end;

class function AttributeDef.NewInstance: AttributeDef; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
begin
  Result := AttributeDef(SOMClass(NewClass).somNewNoInit);
end;

function AttributeDef.Clone: AttributeDef; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
begin
  Result := AttributeDef(SOMClass(somGetClass).somNewNoInit);
  SOMObject(Result).somDefaultCopyInit(somInitCtrl(nil^), SOMObject(Self));
end;

function AttributeDef.within: _IDL_Sequence_Container; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PContainedClassDataStructure;
  LocalEnv: Environment;
begin
  cd := ContainedClassData;
  SOM_InitEnvironment(@LocalEnv);
  Result :=
  somTD_Contained_within
   (SOM_Resolve(Self, cd.classObject, cd.within))
     (Self, @LocalEnv);
  SOM_UninitEnvironmentOrRaise(@LocalEnv);
end;

function AttributeDef.describe: Contained_Description; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PContainedClassDataStructure;
  LocalEnv: Environment;
begin
  cd := ContainedClassData;
  SOM_InitEnvironment(@LocalEnv);
  Result :=
  somTD_Contained_describe
   (SOM_Resolve(Self, cd.classObject, cd.describe))
     (Self, @LocalEnv);
  SOM_UninitEnvironmentOrRaise(@LocalEnv);
end;

procedure AttributeDef.somDefaultInit(var ctrl: Pointer); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somDefaultInit
   (SOM_Resolve(Self, cd.classObject, cd.somDefaultInit))
     (Self, ctrl);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

procedure AttributeDef.somDestruct(doFree: Byte; var ctrl: Pointer); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somDestruct
   (SOM_Resolve(Self, cd.classObject, cd.somDestruct))
     (Self, doFree, ctrl);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

procedure AttributeDef.somDefaultCopyInit(var ctrl: Pointer; fromObj: AttributeDef); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somDefaultCopyInit
   (SOM_Resolve(Self, cd.classObject, cd.somDefaultCopyInit))
     (Self, ctrl, fromObj);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function AttributeDef.somDefaultAssign(var ctrl: Pointer; fromObj: AttributeDef): AttributeDef; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result := AttributeDef(
  somTD_SOMObject_somDefaultAssign
   (SOM_Resolve(Self, cd.classObject, cd.somDefaultAssign))
     (Self, ctrl, fromObj));
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

procedure AttributeDef.somDefaultConstCopyInit(var ctrl: Pointer; fromObj: AttributeDef); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somDefaultConstCopyInit
   (SOM_Resolve(Self, cd.classObject, cd.somDefaultConstCopyInit))
     (Self, ctrl, fromObj);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

procedure AttributeDef.somDefaultVCopyInit(var ctrl: Pointer; fromObj: AttributeDef); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somDefaultVCopyInit
   (SOM_Resolve(Self, cd.classObject, cd.somDefaultVCopyInit))
     (Self, ctrl, fromObj);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

procedure AttributeDef.somDefaultConstVCopyInit(var ctrl: Pointer; fromObj: AttributeDef); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somDefaultConstVCopyInit
   (SOM_Resolve(Self, cd.classObject, cd.somDefaultConstVCopyInit))
     (Self, ctrl, fromObj);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function AttributeDef.somDefaultConstAssign(var ctrl: Pointer; fromObj: AttributeDef): AttributeDef; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result := AttributeDef(
  somTD_SOMObject_somDefaultConstAssign
   (SOM_Resolve(Self, cd.classObject, cd.somDefaultConstAssign))
     (Self, ctrl, fromObj));
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function AttributeDef.somDefaultVAssign(var ctrl: Pointer; fromObj: AttributeDef): AttributeDef; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result := AttributeDef(
  somTD_SOMObject_somDefaultVAssign
   (SOM_Resolve(Self, cd.classObject, cd.somDefaultVAssign))
     (Self, ctrl, fromObj));
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function AttributeDef.somDefaultConstVAssign(var ctrl: Pointer; fromObj: AttributeDef): AttributeDef; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result := AttributeDef(
  somTD_SOMObject_somDefaultConstVAssign
   (SOM_Resolve(Self, cd.classObject, cd.somDefaultConstVAssign))
     (Self, ctrl, fromObj));
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

procedure AttributeDef.somInit; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somInit
   (SOM_Resolve(Self, cd.classObject, cd.somInit))
     (Self);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

procedure AttributeDef.somFree; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somFree
   (SOM_Resolve(Self, cd.classObject, cd.somFree))
     (Self);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

procedure AttributeDef.somUninit; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somUninit
   (SOM_Resolve(Self, cd.classObject, cd.somUninit))
     (Self);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function AttributeDef.somGetClass: SOMClass; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result := SOMClass(
  somTD_SOMObject_somGetClass
   (SOM_Resolve(Self, cd.classObject, cd.somGetClass))
     (Self));
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function AttributeDef.somGetClassName: {dual_owned} CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result :=
  somTD_SOMObject_somGetClassName
   (SOM_Resolve(Self, cd.classObject, cd.somGetClassName))
     (Self);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function AttributeDef.somGetSize: LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result :=
  somTD_SOMObject_somGetSize
   (SOM_Resolve(Self, cd.classObject, cd.somGetSize))
     (Self);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function AttributeDef.somIsA(aClassObj: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result :=
  somTD_SOMObject_somIsA
   (SOM_Resolve(Self, cd.classObject, cd.somIsA))
     (Self, aClassObj);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function AttributeDef.somIsInstanceOf(aClassObj: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result :=
  somTD_SOMObject_somIsInstanceOf
   (SOM_Resolve(Self, cd.classObject, cd.somIsInstanceOf))
     (Self, aClassObj);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function AttributeDef.somRespondsTo(mId: somId): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result :=
  somTD_SOMObject_somRespondsTo
   (SOM_Resolve(Self, cd.classObject, cd.somRespondsTo))
     (Self, mId);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function AttributeDef.somDispatch(out retValue: Pointer; methodId: somId; ap: va_list): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result :=
  somTD_SOMObject_somDispatch
   (SOM_Resolve(Self, cd.classObject, cd.somDispatch))
     (Self, retValue, methodId, ap);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function AttributeDef.somClassDispatch(clsObj: SOMClass; out retValue: Pointer; methodId: somId; ap: va_list): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result :=
  somTD_SOMObject_somClassDispatch
   (SOM_Resolve(Self, cd.classObject, cd.somClassDispatch))
     (Self, clsObj, retValue, methodId, ap);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function AttributeDef.somCastObj(cls: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result :=
  somTD_SOMObject_somCastObj
   (SOM_Resolve(Self, cd.classObject, cd.somCastObj))
     (Self, cls);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function AttributeDef.somResetObj: CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result :=
  somTD_SOMObject_somResetObj
   (SOM_Resolve(Self, cd.classObject, cd.somResetObj))
     (Self);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function AttributeDef.somPrintSelf: AttributeDef; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result := AttributeDef(
  somTD_SOMObject_somPrintSelf
   (SOM_Resolve(Self, cd.classObject, cd.somPrintSelf))
     (Self));
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

procedure AttributeDef.somDumpSelf(level: LongInt); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somDumpSelf
   (SOM_Resolve(Self, cd.classObject, cd.somDumpSelf))
     (Self, level);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

procedure AttributeDef.somDumpSelfInt(level: LongInt); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somDumpSelfInt
   (SOM_Resolve(Self, cd.classObject, cd.somDumpSelfInt))
     (Self, level);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

class function AttributeDef.ClassObject: SOMClass; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
begin
  if Self = AttributeDef then { invoked on class name literal }
  begin
    Result := SOMClass(AttributeDefClassData.classObject);
  end
  else { invoked on SOM object }
  begin
    Result := SOMClass(PPointer(Self)^);
  end
end;

class function AttributeDef.NewClass: SOMClass;
begin
  if Self = AttributeDef then { invoked on class name literal }
  begin
    Result := SOMClass(AttributeDefClassData.classObject);
    if not Assigned(Result) then Result := SOMClass(AttributeDefNewClass);
  end
  else { invoked on SOM object }
  begin
    Result := SOMClass(PPointer(Self)^);
  end
end;

function AttributeDef.As_Contained: Contained; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
begin
  Result := Contained(Self);
end;

function AttributeDef.As_AttributeDef: AttributeDef; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
begin
  Result := Self;
end;

class function AttributeDef.Supports(Instance: SOMObjectBase): Boolean;
var
  cls: SOMClass;
begin
  if not Assigned(Instance) then
  begin
    Result := False;
  end
  else
  begin
    cls := SOMClass(ClassObject);
    if not Assigned(cls) then
    begin
      Result := False;
    end
    else
    begin
      Result := SOMObject(Instance).somIsA(cls);
    end;
  end;
end;

class function AttributeDef.Supports(Instance: SOMObjectBase; out Obj: AttributeDef): Boolean;
var
  cls: SOMClass;
begin
  if not Assigned(Instance) then
  begin
    Result := False;
    Obj := nil;
  end
  else
  begin
    cls := SOMClass(ClassObject);
    if not Assigned(cls) then
    begin
      Result := False;
      Obj := nil;
    end
    else if SOMObject(Instance).somIsA(cls) then
    begin
      Result := True;
      Obj := AttributeDef(Instance);
    end
    else
    begin
      Result := False;
      Obj := nil;
    end;
  end;
end;

const
  SOMD_DLL_Name = 'somd.dll';

var
  SOMD_DLL: System.HMODULE = 0;

procedure SOMD_DLL_Load_Variable(var V_Pointer; const Var_Name: AnsiString);
begin
  if SOMD_DLL = 0 then
  begin
    Windows.EnterCriticalSection(DLLLoad_CriticalSection);
    if SOMD_DLL = 0 then
      SOMD_DLL := Windows.LoadLibraryW(SOMD_DLL_Name);
    Windows.LeaveCriticalSection(DLLLoad_CriticalSection);
  end;
  if SOMD_DLL <> 0 then
    Pointer(V_Pointer) := Windows.GetProcAddress(SOMD_DLL, PAnsiChar(Var_Name));
end;

const
  BOA_MajorVersion = 2;
  BOA_MinorVersion = 1;

(*
 * Declare the class creation procedure
 *)
function BOANewClass(
  somtmajorVersion: integer4 = BOA_MajorVersion;
  somtminorVersion: integer4 = BOA_MinorVersion):
  SOMClass; stdcall; external SOMD_DLL_Name name 'BOANewClass';

(*
 * Declare the ABI 2 ClassData structure
 *)
type
  BOAClassDataStructure = packed record
    classObject: SOMClass;
    SOM_create,
    dispose,
    get_id,
    change_implementation,
    get_principal,
    set_exception,
    impl_is_ready,
    deactivate_impl,
    obj_is_ready,
    deactivate_obj,
    activate_impl,
    activate_obj: somMToken;
  end;
  PBOAClassDataStructure = ^BOAClassDataStructure;

var
  SOMD_DLL_BOAClassData: PBOAClassDataStructure = nil;

function BOAClassData: PBOAClassDataStructure;
begin
  if Assigned(SOMD_DLL_BOAClassData) then
    Result := SOMD_DLL_BOAClassData
  else
  begin
    SOMD_DLL_Load_Variable(SOMD_DLL_BOAClassData, 'BOAClassData');
    Result := SOMD_DLL_BOAClassData;
  end;
end;

(*
 * Declare the ABI 2 CClassData structure
 *)
type
  BOACClassDataStructure = packed record
    parentMtab: somMethodTabs;
    instanceDataToken: somDToken;
  end;
  PBOACClassDataStructure = ^BOACClassDataStructure;

var
  SOMD_DLL_BOACClassData: PBOACClassDataStructure = nil;

function BOACClassData: PBOACClassDataStructure;
begin
  if Assigned(SOMD_DLL_BOACClassData) then
    Result := SOMD_DLL_BOACClassData
  else
  begin
    SOMD_DLL_Load_Variable(SOMD_DLL_BOACClassData, 'BOACClassData');
    Result := SOMD_DLL_BOACClassData;
  end;
end;

(*
 * Class Object and Method Token Macros
 *)

class function BOA.Create: BOA; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
begin
  Result := BOA(SOMClass(NewClass).somNew);
end;

class function BOA.InitInstance(Instance: Pointer): BOA; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
begin
  Result := BOA(SOMClass(NewClass).somRenewNoInit(Instance));
end;

function BOA.ClassType: SOMMSingleInstance; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
begin
  Result := SOMMSingleInstance(SOMObject(Self).somGetClass);
end;

class function BOA.ClassName: string;
begin
  Result := AnsiString(SOMClass(NewClass).somGetName);
end;

class function BOA.ClassNameIs(const Name: string): Boolean;
begin
  Result := AnsiString(SOMClass(NewClass).somGetName) = Name;
end;

class function BOA.InstanceSize: LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
begin
  Result := SOMClass(NewClass).somGetInstanceSize;
end;

class function BOA.InheritsFrom(AClass: SOMClass): Boolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
begin
  Result := SOMClass(NewClass).somDescendedFrom(AClass);
end;

class function BOA.MethodAddress(const Name: string): Pointer;
var
  NameAsAnsiString: AnsiString;
  NameAsSomId: somId;
begin
  NameAsAnsiString := AnsiString(Name);
  NameAsSomId := somIdFromString(PAnsiChar(NameAsAnsiString));
  try
    SOMClass(NewClass).somFindMethod(NameAsSomId, Result);
  finally
    SOMMemFree(NameAsSomId);
  end;
end;

class function BOA.NewInstance: BOA; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
begin
  Result := BOA(SOMClass(NewClass).somNewNoInit);
end;

function BOA.Clone: BOA; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
begin
  Result := BOA(SOMClass(somGetClass).somNewNoInit);
  SOMObject(Result).somDefaultCopyInit(somInitCtrl(nil^), SOMObject(Self));
end;

(*
 * New Method: SOM_create
 *)
type
  somTD_BOA_SOM_create = function(somSelf: SOMObjectBase{BOA}; ev: PEnvironment; const id: _IDL_Sequence_Byte; intf: InterfaceDef; impl: ImplementationDef): SOMDObject; stdcall;

function BOA.SOM_create(const id: _IDL_Sequence_Byte; intf: InterfaceDef; impl: ImplementationDef): SOMDObject; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PBOAClassDataStructure;
  LocalEnv: Environment;
begin
  cd := BOAClassData;
  SOM_InitEnvironment(@LocalEnv);
  Result :=
  somTD_BOA_SOM_create
   (SOM_Resolve(Self, cd.classObject, cd.SOM_create))
     (Self, @LocalEnv, id, intf, impl);
  SOM_UninitEnvironmentOrRaise(@LocalEnv);
end;

(*
 * New Method: dispose
 *)
type
  somTD_BOA_dispose = procedure(somSelf: SOMObjectBase{BOA}; ev: PEnvironment; obj: SOMDObject); stdcall;

procedure BOA.dispose(obj: SOMDObject); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PBOAClassDataStructure;
  LocalEnv: Environment;
begin
  cd := BOAClassData;
  SOM_InitEnvironment(@LocalEnv);
  somTD_BOA_dispose
   (SOM_Resolve(Self, cd.classObject, cd.dispose))
     (Self, @LocalEnv, obj);
  SOM_UninitEnvironmentOrRaise(@LocalEnv);
end;

(*
 * New Method: get_id
 *)
type
  somTD_BOA_get_id = function(somSelf: SOMObjectBase{BOA}; ev: PEnvironment; obj: SOMDObject): _IDL_Sequence_Byte; stdcall;

function BOA.get_id(obj: SOMDObject): _IDL_Sequence_Byte; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PBOAClassDataStructure;
  LocalEnv: Environment;
begin
  cd := BOAClassData;
  SOM_InitEnvironment(@LocalEnv);
  Result :=
  somTD_BOA_get_id
   (SOM_Resolve(Self, cd.classObject, cd.get_id))
     (Self, @LocalEnv, obj);
  SOM_UninitEnvironmentOrRaise(@LocalEnv);
end;

(*
 * New Method: get_principal
 *)
type
  somTD_BOA_get_principal = function(somSelf: SOMObjectBase{BOA}; ev: PEnvironment; obj: SOMDObject; const req_ev: Environment): Principal; stdcall;

function BOA.get_principal(obj: SOMDObject; const req_ev: Environment): Principal; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PBOAClassDataStructure;
  LocalEnv: Environment;
begin
  cd := BOAClassData;
  SOM_InitEnvironment(@LocalEnv);
  Result :=
  somTD_BOA_get_principal
   (SOM_Resolve(Self, cd.classObject, cd.get_principal))
     (Self, @LocalEnv, obj, req_ev);
  SOM_UninitEnvironmentOrRaise(@LocalEnv);
end;

(*
 * New Method: set_exception
 *)
type
  somTD_BOA_set_exception = procedure(somSelf: SOMObjectBase{BOA}; ev: PEnvironment; major: exception_type; userid: CORBAString; param: Pointer); stdcall;

procedure BOA.set_exception(major: exception_type; userid: CORBAString; param: Pointer); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PBOAClassDataStructure;
  LocalEnv: Environment;
begin
  cd := BOAClassData;
  SOM_InitEnvironment(@LocalEnv);
  somTD_BOA_set_exception
   (SOM_Resolve(Self, cd.classObject, cd.set_exception))
     (Self, @LocalEnv, major, userid, param);
  SOM_UninitEnvironmentOrRaise(@LocalEnv);
end;

(*
 * New Method: impl_is_ready
 *)
type
  somTD_BOA_impl_is_ready = procedure(somSelf: SOMObjectBase{BOA}; ev: PEnvironment; impl: ImplementationDef); stdcall;

procedure BOA.impl_is_ready(impl: ImplementationDef); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PBOAClassDataStructure;
  LocalEnv: Environment;
begin
  cd := BOAClassData;
  SOM_InitEnvironment(@LocalEnv);
  somTD_BOA_impl_is_ready
   (SOM_Resolve(Self, cd.classObject, cd.impl_is_ready))
     (Self, @LocalEnv, impl);
  SOM_UninitEnvironmentOrRaise(@LocalEnv);
end;

(*
 * New Method: deactivate_impl
 *)
type
  somTD_BOA_deactivate_impl = procedure(somSelf: SOMObjectBase{BOA}; ev: PEnvironment; impl: ImplementationDef); stdcall;

procedure BOA.deactivate_impl(impl: ImplementationDef); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PBOAClassDataStructure;
  LocalEnv: Environment;
begin
  cd := BOAClassData;
  SOM_InitEnvironment(@LocalEnv);
  somTD_BOA_deactivate_impl
   (SOM_Resolve(Self, cd.classObject, cd.deactivate_impl))
     (Self, @LocalEnv, impl);
  SOM_UninitEnvironmentOrRaise(@LocalEnv);
end;

(*
 * New Method: change_implementation
 *)
type
  somTD_BOA_change_implementation = procedure(somSelf: SOMObjectBase{BOA}; ev: PEnvironment; obj: SOMDObject; impl: ImplementationDef); stdcall;

procedure BOA.change_implementation(obj: SOMDObject; impl: ImplementationDef); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PBOAClassDataStructure;
  LocalEnv: Environment;
begin
  cd := BOAClassData;
  SOM_InitEnvironment(@LocalEnv);
  somTD_BOA_change_implementation
   (SOM_Resolve(Self, cd.classObject, cd.change_implementation))
     (Self, @LocalEnv, obj, impl);
  SOM_UninitEnvironmentOrRaise(@LocalEnv);
end;

(*
 * New Method: obj_is_ready
 *)
type
  somTD_BOA_obj_is_ready = procedure(somSelf: SOMObjectBase{BOA}; ev: PEnvironment; obj: SOMDObject; impl: ImplementationDef); stdcall;

procedure BOA.obj_is_ready(obj: SOMDObject; impl: ImplementationDef); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PBOAClassDataStructure;
  LocalEnv: Environment;
begin
  cd := BOAClassData;
  SOM_InitEnvironment(@LocalEnv);
  somTD_BOA_obj_is_ready
   (SOM_Resolve(Self, cd.classObject, cd.obj_is_ready))
     (Self, @LocalEnv, obj, impl);
  SOM_UninitEnvironmentOrRaise(@LocalEnv);
end;

(*
 * New Method: deactivate_obj
 *)
type
  somTD_BOA_deactivate_obj = procedure(somSelf: SOMObjectBase{BOA}; ev: PEnvironment; obj: SOMDObject); stdcall;

procedure BOA.deactivate_obj(obj: SOMDObject); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PBOAClassDataStructure;
  LocalEnv: Environment;
begin
  cd := BOAClassData;
  SOM_InitEnvironment(@LocalEnv);
  somTD_BOA_deactivate_obj
   (SOM_Resolve(Self, cd.classObject, cd.deactivate_obj))
     (Self, @LocalEnv, obj);
  SOM_UninitEnvironmentOrRaise(@LocalEnv);
end;

procedure BOA.somDefaultInit(var ctrl: Pointer); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somDefaultInit
   (SOM_Resolve(Self, cd.classObject, cd.somDefaultInit))
     (Self, ctrl);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

procedure BOA.somDestruct(doFree: Byte; var ctrl: Pointer); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somDestruct
   (SOM_Resolve(Self, cd.classObject, cd.somDestruct))
     (Self, doFree, ctrl);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

procedure BOA.somDefaultCopyInit(var ctrl: Pointer; fromObj: BOA); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somDefaultCopyInit
   (SOM_Resolve(Self, cd.classObject, cd.somDefaultCopyInit))
     (Self, ctrl, fromObj);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function BOA.somDefaultAssign(var ctrl: Pointer; fromObj: BOA): BOA; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result := BOA(
  somTD_SOMObject_somDefaultAssign
   (SOM_Resolve(Self, cd.classObject, cd.somDefaultAssign))
     (Self, ctrl, fromObj));
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

procedure BOA.somDefaultConstCopyInit(var ctrl: Pointer; fromObj: BOA); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somDefaultConstCopyInit
   (SOM_Resolve(Self, cd.classObject, cd.somDefaultConstCopyInit))
     (Self, ctrl, fromObj);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

procedure BOA.somDefaultVCopyInit(var ctrl: Pointer; fromObj: BOA); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somDefaultVCopyInit
   (SOM_Resolve(Self, cd.classObject, cd.somDefaultVCopyInit))
     (Self, ctrl, fromObj);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

procedure BOA.somDefaultConstVCopyInit(var ctrl: Pointer; fromObj: BOA); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somDefaultConstVCopyInit
   (SOM_Resolve(Self, cd.classObject, cd.somDefaultConstVCopyInit))
     (Self, ctrl, fromObj);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function BOA.somDefaultConstAssign(var ctrl: Pointer; fromObj: BOA): BOA; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result := BOA(
  somTD_SOMObject_somDefaultConstAssign
   (SOM_Resolve(Self, cd.classObject, cd.somDefaultConstAssign))
     (Self, ctrl, fromObj));
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function BOA.somDefaultVAssign(var ctrl: Pointer; fromObj: BOA): BOA; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result := BOA(
  somTD_SOMObject_somDefaultVAssign
   (SOM_Resolve(Self, cd.classObject, cd.somDefaultVAssign))
     (Self, ctrl, fromObj));
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function BOA.somDefaultConstVAssign(var ctrl: Pointer; fromObj: BOA): BOA; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result := BOA(
  somTD_SOMObject_somDefaultConstVAssign
   (SOM_Resolve(Self, cd.classObject, cd.somDefaultConstVAssign))
     (Self, ctrl, fromObj));
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

procedure BOA.somInit; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somInit
   (SOM_Resolve(Self, cd.classObject, cd.somInit))
     (Self);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

procedure BOA.somFree; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somFree
   (SOM_Resolve(Self, cd.classObject, cd.somFree))
     (Self);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

procedure BOA.somUninit; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somUninit
   (SOM_Resolve(Self, cd.classObject, cd.somUninit))
     (Self);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function BOA.somGetClass: SOMMSingleInstance; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result := SOMMSingleInstance(
  somTD_SOMObject_somGetClass
   (SOM_Resolve(Self, cd.classObject, cd.somGetClass))
     (Self));
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function BOA.somGetClassName: {dual_owned} CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result :=
  somTD_SOMObject_somGetClassName
   (SOM_Resolve(Self, cd.classObject, cd.somGetClassName))
     (Self);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function BOA.somGetSize: LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result :=
  somTD_SOMObject_somGetSize
   (SOM_Resolve(Self, cd.classObject, cd.somGetSize))
     (Self);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function BOA.somIsA(aClassObj: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result :=
  somTD_SOMObject_somIsA
   (SOM_Resolve(Self, cd.classObject, cd.somIsA))
     (Self, aClassObj);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function BOA.somIsInstanceOf(aClassObj: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result :=
  somTD_SOMObject_somIsInstanceOf
   (SOM_Resolve(Self, cd.classObject, cd.somIsInstanceOf))
     (Self, aClassObj);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function BOA.somRespondsTo(mId: somId): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result :=
  somTD_SOMObject_somRespondsTo
   (SOM_Resolve(Self, cd.classObject, cd.somRespondsTo))
     (Self, mId);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function BOA.somDispatch(out retValue: Pointer; methodId: somId; ap: va_list): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result :=
  somTD_SOMObject_somDispatch
   (SOM_Resolve(Self, cd.classObject, cd.somDispatch))
     (Self, retValue, methodId, ap);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function BOA.somClassDispatch(clsObj: SOMClass; out retValue: Pointer; methodId: somId; ap: va_list): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result :=
  somTD_SOMObject_somClassDispatch
   (SOM_Resolve(Self, cd.classObject, cd.somClassDispatch))
     (Self, clsObj, retValue, methodId, ap);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function BOA.somCastObj(cls: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result :=
  somTD_SOMObject_somCastObj
   (SOM_Resolve(Self, cd.classObject, cd.somCastObj))
     (Self, cls);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function BOA.somResetObj: CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result :=
  somTD_SOMObject_somResetObj
   (SOM_Resolve(Self, cd.classObject, cd.somResetObj))
     (Self);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function BOA.somPrintSelf: BOA; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result := BOA(
  somTD_SOMObject_somPrintSelf
   (SOM_Resolve(Self, cd.classObject, cd.somPrintSelf))
     (Self));
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

procedure BOA.somDumpSelf(level: LongInt); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somDumpSelf
   (SOM_Resolve(Self, cd.classObject, cd.somDumpSelf))
     (Self, level);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

procedure BOA.somDumpSelfInt(level: LongInt); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somDumpSelfInt
   (SOM_Resolve(Self, cd.classObject, cd.somDumpSelfInt))
     (Self, level);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

class function BOA.ClassObject: SOMMSingleInstance; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
begin
  if Self = BOA then { invoked on class name literal }
  begin
    Result := SOMMSingleInstance(BOAClassData.classObject);
  end
  else { invoked on SOM object }
  begin
    Result := SOMMSingleInstance(PPointer(Self)^);
  end
end;

class function BOA.NewClass: SOMMSingleInstance;
begin
  if Self = BOA then { invoked on class name literal }
  begin
    Result := SOMMSingleInstance(BOAClassData.classObject);
    if not Assigned(Result) then Result := SOMMSingleInstance(BOANewClass);
  end
  else { invoked on SOM object }
  begin
    Result := SOMMSingleInstance(PPointer(Self)^);
  end
end;

function BOA.As_BOA: BOA; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
begin
  Result := Self;
end;

class function BOA.Supports(Instance: SOMObjectBase): Boolean;
var
  cls: SOMClass;
begin
  if not Assigned(Instance) then
  begin
    Result := False;
  end
  else
  begin
    cls := SOMClass(ClassObject);
    if not Assigned(cls) then
    begin
      Result := False;
    end
    else
    begin
      Result := SOMObject(Instance).somIsA(cls);
    end;
  end;
end;

class function BOA.Supports(Instance: SOMObjectBase; out Obj: BOA): Boolean;
var
  cls: SOMClass;
begin
  if not Assigned(Instance) then
  begin
    Result := False;
    Obj := nil;
  end
  else
  begin
    cls := SOMClass(ClassObject);
    if not Assigned(cls) then
    begin
      Result := False;
      Obj := nil;
    end
    else if SOMObject(Instance).somIsA(cls) then
    begin
      Result := True;
      Obj := BOA(Instance);
    end
    else
    begin
      Result := False;
      Obj := nil;
    end;
  end;
end;

const
  SOMEM_DLL_Name = 'somem.dll';

var
  SOMEM_DLL: System.HMODULE = 0;

procedure SOMEM_DLL_Load_Variable(var V_Pointer; const Var_Name: AnsiString);
begin
  if SOMEM_DLL = 0 then
  begin
    Windows.EnterCriticalSection(DLLLoad_CriticalSection);
    if SOMEM_DLL = 0 then
      SOMEM_DLL := Windows.LoadLibraryW(SOMEM_DLL_Name);
    Windows.LeaveCriticalSection(DLLLoad_CriticalSection);
  end;
  if SOMEM_DLL <> 0 then
    Pointer(V_Pointer) := Windows.GetProcAddress(SOMEM_DLL, PAnsiChar(Var_Name));
end;

const
  SOMEEvent_MajorVersion = 2;
  SOMEEvent_MinorVersion = 1;

(*
 * Declare the class creation procedure
 *)
function SOMEEventNewClass(
  somtmajorVersion: integer4 = SOMEEvent_MajorVersion;
  somtminorVersion: integer4 = SOMEEvent_MinorVersion):
  SOMClass; stdcall; external SOMEM_DLL_Name name 'SOMEEventNewClass';

(*
 * Declare the ABI 2 ClassData structure
 *)
type
  SOMEEventClassDataStructure = packed record
    classObject: SOMClass;
    somevGetEventTime,
    somevGetEventType,
    somevSetEventTime,
    somevSetEventType: somMToken;
  end;
  PSOMEEventClassDataStructure = ^SOMEEventClassDataStructure;

var
  SOMEM_DLL_SOMEEventClassData: PSOMEEventClassDataStructure = nil;

function SOMEEventClassData: PSOMEEventClassDataStructure;
begin
  if Assigned(SOMEM_DLL_SOMEEventClassData) then
    Result := SOMEM_DLL_SOMEEventClassData
  else
  begin
    SOMEM_DLL_Load_Variable(SOMEM_DLL_SOMEEventClassData, 'SOMEEventClassData');
    Result := SOMEM_DLL_SOMEEventClassData;
  end;
end;

(*
 * Declare the ABI 2 CClassData structure
 *)
type
  SOMEEventCClassDataStructure = packed record
    parentMtab: somMethodTabs;
    instanceDataToken: somDToken;
  end;
  PSOMEEventCClassDataStructure = ^SOMEEventCClassDataStructure;

var
  SOMEM_DLL_SOMEEventCClassData: PSOMEEventCClassDataStructure = nil;

function SOMEEventCClassData: PSOMEEventCClassDataStructure;
begin
  if Assigned(SOMEM_DLL_SOMEEventCClassData) then
    Result := SOMEM_DLL_SOMEEventCClassData
  else
  begin
    SOMEM_DLL_Load_Variable(SOMEM_DLL_SOMEEventCClassData, 'SOMEEventCClassData');
    Result := SOMEM_DLL_SOMEEventCClassData;
  end;
end;

(*
 * Class Object and Method Token Macros
 *)

class function SOMEEvent.Create: SOMEEvent; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
begin
  Result := SOMEEvent(SOMClass(NewClass).somNew);
end;

class function SOMEEvent.InitInstance(Instance: Pointer): SOMEEvent; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
begin
  Result := SOMEEvent(SOMClass(NewClass).somRenewNoInit(Instance));
end;

function SOMEEvent.ClassType: SOMClass; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
begin
  Result := SOMClass(SOMObject(Self).somGetClass);
end;

class function SOMEEvent.ClassName: string;
begin
  Result := AnsiString(SOMClass(NewClass).somGetName);
end;

class function SOMEEvent.ClassNameIs(const Name: string): Boolean;
begin
  Result := AnsiString(SOMClass(NewClass).somGetName) = Name;
end;

class function SOMEEvent.InstanceSize: LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
begin
  Result := SOMClass(NewClass).somGetInstanceSize;
end;

class function SOMEEvent.InheritsFrom(AClass: SOMClass): Boolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
begin
  Result := SOMClass(NewClass).somDescendedFrom(AClass);
end;

class function SOMEEvent.MethodAddress(const Name: string): Pointer;
var
  NameAsAnsiString: AnsiString;
  NameAsSomId: somId;
begin
  NameAsAnsiString := AnsiString(Name);
  NameAsSomId := somIdFromString(PAnsiChar(NameAsAnsiString));
  try
    SOMClass(NewClass).somFindMethod(NameAsSomId, Result);
  finally
    SOMMemFree(NameAsSomId);
  end;
end;

class function SOMEEvent.NewInstance: SOMEEvent; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
begin
  Result := SOMEEvent(SOMClass(NewClass).somNewNoInit);
end;

function SOMEEvent.Clone: SOMEEvent; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
begin
  Result := SOMEEvent(SOMClass(somGetClass).somNewNoInit);
  SOMObject(Result).somDefaultCopyInit(somInitCtrl(nil^), SOMObject(Self));
end;

(*
 * New Method: somevGetEventTime
 *)
type
  somTD_SOMEEvent_somevGetEventTime = function(somSelf: SOMObjectBase{SOMEEvent}; ev: PEnvironment): LongWord; stdcall;

function SOMEEvent.somevGetEventTime: LongWord; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMEEventClassDataStructure;
  LocalEnv: Environment;
begin
  cd := SOMEEventClassData;
  SOM_InitEnvironment(@LocalEnv);
  Result :=
  somTD_SOMEEvent_somevGetEventTime
   (SOM_Resolve(Self, cd.classObject, cd.somevGetEventTime))
     (Self, @LocalEnv);
  SOM_UninitEnvironmentOrRaise(@LocalEnv);
end;

(*
 * New Method: somevGetEventType
 *)
type
  somTD_SOMEEvent_somevGetEventType = function(somSelf: SOMObjectBase{SOMEEvent}; ev: PEnvironment): LongWord; stdcall;

function SOMEEvent.somevGetEventType: LongWord; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMEEventClassDataStructure;
  LocalEnv: Environment;
begin
  cd := SOMEEventClassData;
  SOM_InitEnvironment(@LocalEnv);
  Result :=
  somTD_SOMEEvent_somevGetEventType
   (SOM_Resolve(Self, cd.classObject, cd.somevGetEventType))
     (Self, @LocalEnv);
  SOM_UninitEnvironmentOrRaise(@LocalEnv);
end;

(*
 * New Method: somevSetEventTime
 *)
type
  somTD_SOMEEvent_somevSetEventTime = procedure(somSelf: SOMObjectBase{SOMEEvent}; ev: PEnvironment; time: LongWord); stdcall;

procedure SOMEEvent.somevSetEventTime(time: LongWord); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMEEventClassDataStructure;
  LocalEnv: Environment;
begin
  cd := SOMEEventClassData;
  SOM_InitEnvironment(@LocalEnv);
  somTD_SOMEEvent_somevSetEventTime
   (SOM_Resolve(Self, cd.classObject, cd.somevSetEventTime))
     (Self, @LocalEnv, time);
  SOM_UninitEnvironmentOrRaise(@LocalEnv);
end;

(*
 * New Method: somevSetEventType
 *)
type
  somTD_SOMEEvent_somevSetEventType = procedure(somSelf: SOMObjectBase{SOMEEvent}; ev: PEnvironment; SOM_type: LongWord); stdcall;

procedure SOMEEvent.somevSetEventType(SOM_type: LongWord); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMEEventClassDataStructure;
  LocalEnv: Environment;
begin
  cd := SOMEEventClassData;
  SOM_InitEnvironment(@LocalEnv);
  somTD_SOMEEvent_somevSetEventType
   (SOM_Resolve(Self, cd.classObject, cd.somevSetEventType))
     (Self, @LocalEnv, SOM_type);
  SOM_UninitEnvironmentOrRaise(@LocalEnv);
end;

procedure SOMEEvent.somDefaultInit(var ctrl: Pointer); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somDefaultInit
   (SOM_Resolve(Self, cd.classObject, cd.somDefaultInit))
     (Self, ctrl);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

procedure SOMEEvent.somDestruct(doFree: Byte; var ctrl: Pointer); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somDestruct
   (SOM_Resolve(Self, cd.classObject, cd.somDestruct))
     (Self, doFree, ctrl);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

procedure SOMEEvent.somDefaultCopyInit(var ctrl: Pointer; fromObj: SOMEEvent); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somDefaultCopyInit
   (SOM_Resolve(Self, cd.classObject, cd.somDefaultCopyInit))
     (Self, ctrl, fromObj);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function SOMEEvent.somDefaultAssign(var ctrl: Pointer; fromObj: SOMEEvent): SOMEEvent; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result := SOMEEvent(
  somTD_SOMObject_somDefaultAssign
   (SOM_Resolve(Self, cd.classObject, cd.somDefaultAssign))
     (Self, ctrl, fromObj));
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

procedure SOMEEvent.somDefaultConstCopyInit(var ctrl: Pointer; fromObj: SOMEEvent); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somDefaultConstCopyInit
   (SOM_Resolve(Self, cd.classObject, cd.somDefaultConstCopyInit))
     (Self, ctrl, fromObj);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

procedure SOMEEvent.somDefaultVCopyInit(var ctrl: Pointer; fromObj: SOMEEvent); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somDefaultVCopyInit
   (SOM_Resolve(Self, cd.classObject, cd.somDefaultVCopyInit))
     (Self, ctrl, fromObj);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

procedure SOMEEvent.somDefaultConstVCopyInit(var ctrl: Pointer; fromObj: SOMEEvent); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somDefaultConstVCopyInit
   (SOM_Resolve(Self, cd.classObject, cd.somDefaultConstVCopyInit))
     (Self, ctrl, fromObj);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function SOMEEvent.somDefaultConstAssign(var ctrl: Pointer; fromObj: SOMEEvent): SOMEEvent; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result := SOMEEvent(
  somTD_SOMObject_somDefaultConstAssign
   (SOM_Resolve(Self, cd.classObject, cd.somDefaultConstAssign))
     (Self, ctrl, fromObj));
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function SOMEEvent.somDefaultVAssign(var ctrl: Pointer; fromObj: SOMEEvent): SOMEEvent; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result := SOMEEvent(
  somTD_SOMObject_somDefaultVAssign
   (SOM_Resolve(Self, cd.classObject, cd.somDefaultVAssign))
     (Self, ctrl, fromObj));
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function SOMEEvent.somDefaultConstVAssign(var ctrl: Pointer; fromObj: SOMEEvent): SOMEEvent; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result := SOMEEvent(
  somTD_SOMObject_somDefaultConstVAssign
   (SOM_Resolve(Self, cd.classObject, cd.somDefaultConstVAssign))
     (Self, ctrl, fromObj));
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

procedure SOMEEvent.somInit; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somInit
   (SOM_Resolve(Self, cd.classObject, cd.somInit))
     (Self);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

procedure SOMEEvent.somFree; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somFree
   (SOM_Resolve(Self, cd.classObject, cd.somFree))
     (Self);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

procedure SOMEEvent.somUninit; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somUninit
   (SOM_Resolve(Self, cd.classObject, cd.somUninit))
     (Self);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function SOMEEvent.somGetClass: SOMClass; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result := SOMClass(
  somTD_SOMObject_somGetClass
   (SOM_Resolve(Self, cd.classObject, cd.somGetClass))
     (Self));
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function SOMEEvent.somGetClassName: {dual_owned} CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result :=
  somTD_SOMObject_somGetClassName
   (SOM_Resolve(Self, cd.classObject, cd.somGetClassName))
     (Self);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function SOMEEvent.somGetSize: LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result :=
  somTD_SOMObject_somGetSize
   (SOM_Resolve(Self, cd.classObject, cd.somGetSize))
     (Self);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function SOMEEvent.somIsA(aClassObj: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result :=
  somTD_SOMObject_somIsA
   (SOM_Resolve(Self, cd.classObject, cd.somIsA))
     (Self, aClassObj);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function SOMEEvent.somIsInstanceOf(aClassObj: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result :=
  somTD_SOMObject_somIsInstanceOf
   (SOM_Resolve(Self, cd.classObject, cd.somIsInstanceOf))
     (Self, aClassObj);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function SOMEEvent.somRespondsTo(mId: somId): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result :=
  somTD_SOMObject_somRespondsTo
   (SOM_Resolve(Self, cd.classObject, cd.somRespondsTo))
     (Self, mId);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function SOMEEvent.somDispatch(out retValue: Pointer; methodId: somId; ap: va_list): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result :=
  somTD_SOMObject_somDispatch
   (SOM_Resolve(Self, cd.classObject, cd.somDispatch))
     (Self, retValue, methodId, ap);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function SOMEEvent.somClassDispatch(clsObj: SOMClass; out retValue: Pointer; methodId: somId; ap: va_list): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result :=
  somTD_SOMObject_somClassDispatch
   (SOM_Resolve(Self, cd.classObject, cd.somClassDispatch))
     (Self, clsObj, retValue, methodId, ap);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function SOMEEvent.somCastObj(cls: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result :=
  somTD_SOMObject_somCastObj
   (SOM_Resolve(Self, cd.classObject, cd.somCastObj))
     (Self, cls);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function SOMEEvent.somResetObj: CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result :=
  somTD_SOMObject_somResetObj
   (SOM_Resolve(Self, cd.classObject, cd.somResetObj))
     (Self);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function SOMEEvent.somPrintSelf: SOMEEvent; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result := SOMEEvent(
  somTD_SOMObject_somPrintSelf
   (SOM_Resolve(Self, cd.classObject, cd.somPrintSelf))
     (Self));
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

procedure SOMEEvent.somDumpSelf(level: LongInt); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somDumpSelf
   (SOM_Resolve(Self, cd.classObject, cd.somDumpSelf))
     (Self, level);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

procedure SOMEEvent.somDumpSelfInt(level: LongInt); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somDumpSelfInt
   (SOM_Resolve(Self, cd.classObject, cd.somDumpSelfInt))
     (Self, level);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

class function SOMEEvent.ClassObject: SOMClass; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
begin
  if Self = SOMEEvent then { invoked on class name literal }
  begin
    Result := SOMClass(SOMEEventClassData.classObject);
  end
  else { invoked on SOM object }
  begin
    Result := SOMClass(PPointer(Self)^);
  end
end;

class function SOMEEvent.NewClass: SOMClass;
begin
  if Self = SOMEEvent then { invoked on class name literal }
  begin
    Result := SOMClass(SOMEEventClassData.classObject);
    if not Assigned(Result) then Result := SOMClass(SOMEEventNewClass);
  end
  else { invoked on SOM object }
  begin
    Result := SOMClass(PPointer(Self)^);
  end
end;

function SOMEEvent.As_SOMEEvent: SOMEEvent; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
begin
  Result := Self;
end;

class function SOMEEvent.Supports(Instance: SOMObjectBase): Boolean;
var
  cls: SOMClass;
begin
  if not Assigned(Instance) then
  begin
    Result := False;
  end
  else
  begin
    cls := SOMClass(ClassObject);
    if not Assigned(cls) then
    begin
      Result := False;
    end
    else
    begin
      Result := SOMObject(Instance).somIsA(cls);
    end;
  end;
end;

class function SOMEEvent.Supports(Instance: SOMObjectBase; out Obj: SOMEEvent): Boolean;
var
  cls: SOMClass;
begin
  if not Assigned(Instance) then
  begin
    Result := False;
    Obj := nil;
  end
  else
  begin
    cls := SOMClass(ClassObject);
    if not Assigned(cls) then
    begin
      Result := False;
      Obj := nil;
    end
    else if SOMObject(Instance).somIsA(cls) then
    begin
      Result := True;
      Obj := SOMEEvent(Instance);
    end
    else
    begin
      Result := False;
      Obj := nil;
    end;
  end;
end;

const
  SOMEClientEvent_MajorVersion = 2;
  SOMEClientEvent_MinorVersion = 1;

(*
 * Declare the class creation procedure
 *)
function SOMEClientEventNewClass(
  somtmajorVersion: integer4 = SOMEClientEvent_MajorVersion;
  somtminorVersion: integer4 = SOMEClientEvent_MinorVersion):
  SOMClass; stdcall; external SOMEM_DLL_Name name 'SOMEClientEventNewClass';

(*
 * Declare the ABI 2 ClassData structure
 *)
type
  SOMEClientEventClassDataStructure = packed record
    classObject: SOMClass;
    somevGetEventClientData,
    somevGetEventClientType,
    somevSetEventClientData,
    somevSetEventClientType: somMToken;
  end;
  PSOMEClientEventClassDataStructure = ^SOMEClientEventClassDataStructure;

var
  SOMEM_DLL_SOMEClientEventClassData: PSOMEClientEventClassDataStructure = nil;

function SOMEClientEventClassData: PSOMEClientEventClassDataStructure;
begin
  if Assigned(SOMEM_DLL_SOMEClientEventClassData) then
    Result := SOMEM_DLL_SOMEClientEventClassData
  else
  begin
    SOMEM_DLL_Load_Variable(SOMEM_DLL_SOMEClientEventClassData, 'SOMEClientEventClassData');
    Result := SOMEM_DLL_SOMEClientEventClassData;
  end;
end;

(*
 * Declare the ABI 2 CClassData structure
 *)
type
  SOMEClientEventCClassDataStructure = packed record
    parentMtab: somMethodTabs;
    instanceDataToken: somDToken;
  end;
  PSOMEClientEventCClassDataStructure = ^SOMEClientEventCClassDataStructure;

var
  SOMEM_DLL_SOMEClientEventCClassData: PSOMEClientEventCClassDataStructure = nil;

function SOMEClientEventCClassData: PSOMEClientEventCClassDataStructure;
begin
  if Assigned(SOMEM_DLL_SOMEClientEventCClassData) then
    Result := SOMEM_DLL_SOMEClientEventCClassData
  else
  begin
    SOMEM_DLL_Load_Variable(SOMEM_DLL_SOMEClientEventCClassData, 'SOMEClientEventCClassData');
    Result := SOMEM_DLL_SOMEClientEventCClassData;
  end;
end;

(*
 * Class Object and Method Token Macros
 *)

class function SOMEClientEvent.Create: SOMEClientEvent; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
begin
  Result := SOMEClientEvent(SOMClass(NewClass).somNew);
end;

class function SOMEClientEvent.InitInstance(Instance: Pointer): SOMEClientEvent; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
begin
  Result := SOMEClientEvent(SOMClass(NewClass).somRenewNoInit(Instance));
end;

function SOMEClientEvent.ClassType: SOMClass; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
begin
  Result := SOMClass(SOMObject(Self).somGetClass);
end;

class function SOMEClientEvent.ClassName: string;
begin
  Result := AnsiString(SOMClass(NewClass).somGetName);
end;

class function SOMEClientEvent.ClassNameIs(const Name: string): Boolean;
begin
  Result := AnsiString(SOMClass(NewClass).somGetName) = Name;
end;

class function SOMEClientEvent.InstanceSize: LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
begin
  Result := SOMClass(NewClass).somGetInstanceSize;
end;

class function SOMEClientEvent.InheritsFrom(AClass: SOMClass): Boolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
begin
  Result := SOMClass(NewClass).somDescendedFrom(AClass);
end;

class function SOMEClientEvent.MethodAddress(const Name: string): Pointer;
var
  NameAsAnsiString: AnsiString;
  NameAsSomId: somId;
begin
  NameAsAnsiString := AnsiString(Name);
  NameAsSomId := somIdFromString(PAnsiChar(NameAsAnsiString));
  try
    SOMClass(NewClass).somFindMethod(NameAsSomId, Result);
  finally
    SOMMemFree(NameAsSomId);
  end;
end;

class function SOMEClientEvent.NewInstance: SOMEClientEvent; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
begin
  Result := SOMEClientEvent(SOMClass(NewClass).somNewNoInit);
end;

function SOMEClientEvent.Clone: SOMEClientEvent; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
begin
  Result := SOMEClientEvent(SOMClass(somGetClass).somNewNoInit);
  SOMObject(Result).somDefaultCopyInit(somInitCtrl(nil^), SOMObject(Self));
end;

(*
 * New Method: somevGetEventClientData
 *)
type
  somTD_SOMEClientEvent_somevGetEventClientData = function(somSelf: SOMObjectBase{SOMEClientEvent}; ev: PEnvironment): Pointer; stdcall;

function SOMEClientEvent.somevGetEventClientData: Pointer; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMEClientEventClassDataStructure;
  LocalEnv: Environment;
begin
  cd := SOMEClientEventClassData;
  SOM_InitEnvironment(@LocalEnv);
  Result :=
  somTD_SOMEClientEvent_somevGetEventClientData
   (SOM_Resolve(Self, cd.classObject, cd.somevGetEventClientData))
     (Self, @LocalEnv);
  SOM_UninitEnvironmentOrRaise(@LocalEnv);
end;

(*
 * New Method: somevGetEventClientType
 *)
type
  somTD_SOMEClientEvent_somevGetEventClientType = function(somSelf: SOMObjectBase{SOMEClientEvent}; ev: PEnvironment): CORBAString; stdcall;

function SOMEClientEvent.somevGetEventClientType: CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMEClientEventClassDataStructure;
  LocalEnv: Environment;
begin
  cd := SOMEClientEventClassData;
  SOM_InitEnvironment(@LocalEnv);
  Result :=
  somTD_SOMEClientEvent_somevGetEventClientType
   (SOM_Resolve(Self, cd.classObject, cd.somevGetEventClientType))
     (Self, @LocalEnv);
  SOM_UninitEnvironmentOrRaise(@LocalEnv);
end;

(*
 * New Method: somevSetEventClientData
 *)
type
  somTD_SOMEClientEvent_somevSetEventClientData = procedure(somSelf: SOMObjectBase{SOMEClientEvent}; ev: PEnvironment; clientData: Pointer); stdcall;

procedure SOMEClientEvent.somevSetEventClientData(clientData: Pointer); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMEClientEventClassDataStructure;
  LocalEnv: Environment;
begin
  cd := SOMEClientEventClassData;
  SOM_InitEnvironment(@LocalEnv);
  somTD_SOMEClientEvent_somevSetEventClientData
   (SOM_Resolve(Self, cd.classObject, cd.somevSetEventClientData))
     (Self, @LocalEnv, clientData);
  SOM_UninitEnvironmentOrRaise(@LocalEnv);
end;

(*
 * New Method: somevSetEventClientType
 *)
type
  somTD_SOMEClientEvent_somevSetEventClientType = procedure(somSelf: SOMObjectBase{SOMEClientEvent}; ev: PEnvironment; clientType: CORBAString); stdcall;

procedure SOMEClientEvent.somevSetEventClientType(clientType: CORBAString); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMEClientEventClassDataStructure;
  LocalEnv: Environment;
begin
  cd := SOMEClientEventClassData;
  SOM_InitEnvironment(@LocalEnv);
  somTD_SOMEClientEvent_somevSetEventClientType
   (SOM_Resolve(Self, cd.classObject, cd.somevSetEventClientType))
     (Self, @LocalEnv, clientType);
  SOM_UninitEnvironmentOrRaise(@LocalEnv);
end;

function SOMEClientEvent.somevGetEventTime: LongWord; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMEEventClassDataStructure;
  LocalEnv: Environment;
begin
  cd := SOMEEventClassData;
  SOM_InitEnvironment(@LocalEnv);
  Result :=
  somTD_SOMEEvent_somevGetEventTime
   (SOM_Resolve(Self, cd.classObject, cd.somevGetEventTime))
     (Self, @LocalEnv);
  SOM_UninitEnvironmentOrRaise(@LocalEnv);
end;

function SOMEClientEvent.somevGetEventType: LongWord; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMEEventClassDataStructure;
  LocalEnv: Environment;
begin
  cd := SOMEEventClassData;
  SOM_InitEnvironment(@LocalEnv);
  Result :=
  somTD_SOMEEvent_somevGetEventType
   (SOM_Resolve(Self, cd.classObject, cd.somevGetEventType))
     (Self, @LocalEnv);
  SOM_UninitEnvironmentOrRaise(@LocalEnv);
end;

procedure SOMEClientEvent.somevSetEventTime(time: LongWord); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMEEventClassDataStructure;
  LocalEnv: Environment;
begin
  cd := SOMEEventClassData;
  SOM_InitEnvironment(@LocalEnv);
  somTD_SOMEEvent_somevSetEventTime
   (SOM_Resolve(Self, cd.classObject, cd.somevSetEventTime))
     (Self, @LocalEnv, time);
  SOM_UninitEnvironmentOrRaise(@LocalEnv);
end;

procedure SOMEClientEvent.somevSetEventType(SOM_type: LongWord); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMEEventClassDataStructure;
  LocalEnv: Environment;
begin
  cd := SOMEEventClassData;
  SOM_InitEnvironment(@LocalEnv);
  somTD_SOMEEvent_somevSetEventType
   (SOM_Resolve(Self, cd.classObject, cd.somevSetEventType))
     (Self, @LocalEnv, SOM_type);
  SOM_UninitEnvironmentOrRaise(@LocalEnv);
end;

procedure SOMEClientEvent.somDefaultInit(var ctrl: Pointer); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somDefaultInit
   (SOM_Resolve(Self, cd.classObject, cd.somDefaultInit))
     (Self, ctrl);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

procedure SOMEClientEvent.somDestruct(doFree: Byte; var ctrl: Pointer); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somDestruct
   (SOM_Resolve(Self, cd.classObject, cd.somDestruct))
     (Self, doFree, ctrl);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

procedure SOMEClientEvent.somDefaultCopyInit(var ctrl: Pointer; fromObj: SOMEClientEvent); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somDefaultCopyInit
   (SOM_Resolve(Self, cd.classObject, cd.somDefaultCopyInit))
     (Self, ctrl, fromObj);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function SOMEClientEvent.somDefaultAssign(var ctrl: Pointer; fromObj: SOMEClientEvent): SOMEClientEvent; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result := SOMEClientEvent(
  somTD_SOMObject_somDefaultAssign
   (SOM_Resolve(Self, cd.classObject, cd.somDefaultAssign))
     (Self, ctrl, fromObj));
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

procedure SOMEClientEvent.somDefaultConstCopyInit(var ctrl: Pointer; fromObj: SOMEClientEvent); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somDefaultConstCopyInit
   (SOM_Resolve(Self, cd.classObject, cd.somDefaultConstCopyInit))
     (Self, ctrl, fromObj);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

procedure SOMEClientEvent.somDefaultVCopyInit(var ctrl: Pointer; fromObj: SOMEClientEvent); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somDefaultVCopyInit
   (SOM_Resolve(Self, cd.classObject, cd.somDefaultVCopyInit))
     (Self, ctrl, fromObj);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

procedure SOMEClientEvent.somDefaultConstVCopyInit(var ctrl: Pointer; fromObj: SOMEClientEvent); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somDefaultConstVCopyInit
   (SOM_Resolve(Self, cd.classObject, cd.somDefaultConstVCopyInit))
     (Self, ctrl, fromObj);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function SOMEClientEvent.somDefaultConstAssign(var ctrl: Pointer; fromObj: SOMEClientEvent): SOMEClientEvent; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result := SOMEClientEvent(
  somTD_SOMObject_somDefaultConstAssign
   (SOM_Resolve(Self, cd.classObject, cd.somDefaultConstAssign))
     (Self, ctrl, fromObj));
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function SOMEClientEvent.somDefaultVAssign(var ctrl: Pointer; fromObj: SOMEClientEvent): SOMEClientEvent; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result := SOMEClientEvent(
  somTD_SOMObject_somDefaultVAssign
   (SOM_Resolve(Self, cd.classObject, cd.somDefaultVAssign))
     (Self, ctrl, fromObj));
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function SOMEClientEvent.somDefaultConstVAssign(var ctrl: Pointer; fromObj: SOMEClientEvent): SOMEClientEvent; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result := SOMEClientEvent(
  somTD_SOMObject_somDefaultConstVAssign
   (SOM_Resolve(Self, cd.classObject, cd.somDefaultConstVAssign))
     (Self, ctrl, fromObj));
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

procedure SOMEClientEvent.somInit; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somInit
   (SOM_Resolve(Self, cd.classObject, cd.somInit))
     (Self);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

procedure SOMEClientEvent.somFree; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somFree
   (SOM_Resolve(Self, cd.classObject, cd.somFree))
     (Self);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

procedure SOMEClientEvent.somUninit; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somUninit
   (SOM_Resolve(Self, cd.classObject, cd.somUninit))
     (Self);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function SOMEClientEvent.somGetClass: SOMClass; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result := SOMClass(
  somTD_SOMObject_somGetClass
   (SOM_Resolve(Self, cd.classObject, cd.somGetClass))
     (Self));
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function SOMEClientEvent.somGetClassName: {dual_owned} CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result :=
  somTD_SOMObject_somGetClassName
   (SOM_Resolve(Self, cd.classObject, cd.somGetClassName))
     (Self);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function SOMEClientEvent.somGetSize: LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result :=
  somTD_SOMObject_somGetSize
   (SOM_Resolve(Self, cd.classObject, cd.somGetSize))
     (Self);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function SOMEClientEvent.somIsA(aClassObj: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result :=
  somTD_SOMObject_somIsA
   (SOM_Resolve(Self, cd.classObject, cd.somIsA))
     (Self, aClassObj);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function SOMEClientEvent.somIsInstanceOf(aClassObj: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result :=
  somTD_SOMObject_somIsInstanceOf
   (SOM_Resolve(Self, cd.classObject, cd.somIsInstanceOf))
     (Self, aClassObj);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function SOMEClientEvent.somRespondsTo(mId: somId): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result :=
  somTD_SOMObject_somRespondsTo
   (SOM_Resolve(Self, cd.classObject, cd.somRespondsTo))
     (Self, mId);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function SOMEClientEvent.somDispatch(out retValue: Pointer; methodId: somId; ap: va_list): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result :=
  somTD_SOMObject_somDispatch
   (SOM_Resolve(Self, cd.classObject, cd.somDispatch))
     (Self, retValue, methodId, ap);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function SOMEClientEvent.somClassDispatch(clsObj: SOMClass; out retValue: Pointer; methodId: somId; ap: va_list): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result :=
  somTD_SOMObject_somClassDispatch
   (SOM_Resolve(Self, cd.classObject, cd.somClassDispatch))
     (Self, clsObj, retValue, methodId, ap);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function SOMEClientEvent.somCastObj(cls: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result :=
  somTD_SOMObject_somCastObj
   (SOM_Resolve(Self, cd.classObject, cd.somCastObj))
     (Self, cls);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function SOMEClientEvent.somResetObj: CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result :=
  somTD_SOMObject_somResetObj
   (SOM_Resolve(Self, cd.classObject, cd.somResetObj))
     (Self);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function SOMEClientEvent.somPrintSelf: SOMEClientEvent; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result := SOMEClientEvent(
  somTD_SOMObject_somPrintSelf
   (SOM_Resolve(Self, cd.classObject, cd.somPrintSelf))
     (Self));
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

procedure SOMEClientEvent.somDumpSelf(level: LongInt); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somDumpSelf
   (SOM_Resolve(Self, cd.classObject, cd.somDumpSelf))
     (Self, level);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

procedure SOMEClientEvent.somDumpSelfInt(level: LongInt); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somDumpSelfInt
   (SOM_Resolve(Self, cd.classObject, cd.somDumpSelfInt))
     (Self, level);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

class function SOMEClientEvent.ClassObject: SOMClass; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
begin
  if Self = SOMEClientEvent then { invoked on class name literal }
  begin
    Result := SOMClass(SOMEClientEventClassData.classObject);
  end
  else { invoked on SOM object }
  begin
    Result := SOMClass(PPointer(Self)^);
  end
end;

class function SOMEClientEvent.NewClass: SOMClass;
begin
  if Self = SOMEClientEvent then { invoked on class name literal }
  begin
    Result := SOMClass(SOMEClientEventClassData.classObject);
    if not Assigned(Result) then Result := SOMClass(SOMEClientEventNewClass);
  end
  else { invoked on SOM object }
  begin
    Result := SOMClass(PPointer(Self)^);
  end
end;

function SOMEClientEvent.As_SOMEEvent: SOMEEvent; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
begin
  Result := SOMEEvent(Self);
end;

function SOMEClientEvent.As_SOMEClientEvent: SOMEClientEvent; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
begin
  Result := Self;
end;

class function SOMEClientEvent.Supports(Instance: SOMObjectBase): Boolean;
var
  cls: SOMClass;
begin
  if not Assigned(Instance) then
  begin
    Result := False;
  end
  else
  begin
    cls := SOMClass(ClassObject);
    if not Assigned(cls) then
    begin
      Result := False;
    end
    else
    begin
      Result := SOMObject(Instance).somIsA(cls);
    end;
  end;
end;

class function SOMEClientEvent.Supports(Instance: SOMObjectBase; out Obj: SOMEClientEvent): Boolean;
var
  cls: SOMClass;
begin
  if not Assigned(Instance) then
  begin
    Result := False;
    Obj := nil;
  end
  else
  begin
    cls := SOMClass(ClassObject);
    if not Assigned(cls) then
    begin
      Result := False;
      Obj := nil;
    end
    else if SOMObject(Instance).somIsA(cls) then
    begin
      Result := True;
      Obj := SOMEClientEvent(Instance);
    end
    else
    begin
      Result := False;
      Obj := nil;
    end;
  end;
end;

const
  Context_MajorVersion = 2;
  Context_MinorVersion = 1;

(*
 * Declare the class creation procedure
 *)
function ContextNewClass(
  somtmajorVersion: integer4 = Context_MajorVersion;
  somtminorVersion: integer4 = Context_MinorVersion):
  SOMClass; stdcall; external SOMD_DLL_Name name 'ContextNewClass';

(*
 * Declare the ABI 2 ClassData structure
 *)
type
  ContextClassDataStructure = packed record
    classObject: SOMClass;
    set_one_value,
    set_values,
    get_values,
    delete_values,
    create_child,
    SOM_destroy,
    _get_context_name,
    _set_context_name,
    _get_context_parent,
    _set_context_parent,
    _get_properties,
    _set_properties: somMToken;
  end;
  PContextClassDataStructure = ^ContextClassDataStructure;

var
  SOMD_DLL_ContextClassData: PContextClassDataStructure = nil;

function ContextClassData: PContextClassDataStructure;
begin
  if Assigned(SOMD_DLL_ContextClassData) then
    Result := SOMD_DLL_ContextClassData
  else
  begin
    SOMD_DLL_Load_Variable(SOMD_DLL_ContextClassData, 'ContextClassData');
    Result := SOMD_DLL_ContextClassData;
  end;
end;

(*
 * Declare the ABI 2 CClassData structure
 *)
type
  ContextCClassDataStructure = packed record
    parentMtab: somMethodTabs;
    instanceDataToken: somDToken;
  end;
  PContextCClassDataStructure = ^ContextCClassDataStructure;

var
  SOMD_DLL_ContextCClassData: PContextCClassDataStructure = nil;

function ContextCClassData: PContextCClassDataStructure;
begin
  if Assigned(SOMD_DLL_ContextCClassData) then
    Result := SOMD_DLL_ContextCClassData
  else
  begin
    SOMD_DLL_Load_Variable(SOMD_DLL_ContextCClassData, 'ContextCClassData');
    Result := SOMD_DLL_ContextCClassData;
  end;
end;

(*
 * Class Object and Method Token Macros
 *)

class function Context.Create: Context; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
begin
  Result := Context(SOMClass(NewClass).somNew);
end;

class function Context.InitInstance(Instance: Pointer): Context; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
begin
  Result := Context(SOMClass(NewClass).somRenewNoInit(Instance));
end;

function Context.ClassType: SOMClass; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
begin
  Result := SOMClass(SOMObject(Self).somGetClass);
end;

class function Context.ClassName: string;
begin
  Result := AnsiString(SOMClass(NewClass).somGetName);
end;

class function Context.ClassNameIs(const Name: string): Boolean;
begin
  Result := AnsiString(SOMClass(NewClass).somGetName) = Name;
end;

class function Context.InstanceSize: LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
begin
  Result := SOMClass(NewClass).somGetInstanceSize;
end;

class function Context.InheritsFrom(AClass: SOMClass): Boolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
begin
  Result := SOMClass(NewClass).somDescendedFrom(AClass);
end;

class function Context.MethodAddress(const Name: string): Pointer;
var
  NameAsAnsiString: AnsiString;
  NameAsSomId: somId;
begin
  NameAsAnsiString := AnsiString(Name);
  NameAsSomId := somIdFromString(PAnsiChar(NameAsAnsiString));
  try
    SOMClass(NewClass).somFindMethod(NameAsSomId, Result);
  finally
    SOMMemFree(NameAsSomId);
  end;
end;

class function Context.NewInstance: Context; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
begin
  Result := Context(SOMClass(NewClass).somNewNoInit);
end;

function Context.Clone: Context; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
begin
  Result := Context(SOMClass(somGetClass).somNewNoInit);
  SOMObject(Result).somDefaultCopyInit(somInitCtrl(nil^), SOMObject(Self));
end;

(*
 * New Method: set_one_value
 *)
type
  somTD_Context_set_one_value = function(somSelf: SOMObjectBase{Context}; ev: PEnvironment; prop_name: CORBAString; value: CORBAString): LongWord; stdcall;

function Context.set_one_value(prop_name: CORBAString; value: CORBAString): LongWord; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PContextClassDataStructure;
  LocalEnv: Environment;
begin
  cd := ContextClassData;
  SOM_InitEnvironment(@LocalEnv);
  Result :=
  somTD_Context_set_one_value
   (SOM_Resolve(Self, cd.classObject, cd.set_one_value))
     (Self, @LocalEnv, prop_name, value);
  SOM_UninitEnvironmentOrRaise(@LocalEnv);
end;

(*
 * New Method: set_values
 *)
type
  somTD_Context_set_values = function(somSelf: SOMObjectBase{Context}; ev: PEnvironment; values: NVList): LongWord; stdcall;

function Context.set_values(values: NVList): LongWord; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PContextClassDataStructure;
  LocalEnv: Environment;
begin
  cd := ContextClassData;
  SOM_InitEnvironment(@LocalEnv);
  Result :=
  somTD_Context_set_values
   (SOM_Resolve(Self, cd.classObject, cd.set_values))
     (Self, @LocalEnv, values);
  SOM_UninitEnvironmentOrRaise(@LocalEnv);
end;

(*
 * New Method: get_values
 *)
type
  somTD_Context_get_values = function(somSelf: SOMObjectBase{Context}; ev: PEnvironment; start_scope: CORBAString; op_flags: LongWord; prop_name: CORBAString; out values: NVList): LongWord; stdcall;

function Context.get_values(start_scope: CORBAString; op_flags: LongWord; prop_name: CORBAString; out values: NVList): LongWord; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PContextClassDataStructure;
  LocalEnv: Environment;
begin
  cd := ContextClassData;
  SOM_InitEnvironment(@LocalEnv);
  Result :=
  somTD_Context_get_values
   (SOM_Resolve(Self, cd.classObject, cd.get_values))
     (Self, @LocalEnv, start_scope, op_flags, prop_name, values);
  SOM_UninitEnvironmentOrRaise(@LocalEnv);
end;

(*
 * New Method: delete_values
 *)
type
  somTD_Context_delete_values = function(somSelf: SOMObjectBase{Context}; ev: PEnvironment; prop_name: CORBAString): LongWord; stdcall;

function Context.delete_values(prop_name: CORBAString): LongWord; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PContextClassDataStructure;
  LocalEnv: Environment;
begin
  cd := ContextClassData;
  SOM_InitEnvironment(@LocalEnv);
  Result :=
  somTD_Context_delete_values
   (SOM_Resolve(Self, cd.classObject, cd.delete_values))
     (Self, @LocalEnv, prop_name);
  SOM_UninitEnvironmentOrRaise(@LocalEnv);
end;

(*
 * New Method: create_child
 *)
type
  somTD_Context_create_child = function(somSelf: SOMObjectBase{Context}; ev: PEnvironment; ctx_name: CORBAString; out child_ctx: Context): LongWord; stdcall;

function Context.create_child(ctx_name: CORBAString; out child_ctx: Context): LongWord; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PContextClassDataStructure;
  LocalEnv: Environment;
begin
  cd := ContextClassData;
  SOM_InitEnvironment(@LocalEnv);
  Result :=
  somTD_Context_create_child
   (SOM_Resolve(Self, cd.classObject, cd.create_child))
     (Self, @LocalEnv, ctx_name, child_ctx);
  SOM_UninitEnvironmentOrRaise(@LocalEnv);
end;

(*
 * New Method: SOM_destroy
 *)
type
  somTD_Context_SOM_destroy = function(somSelf: SOMObjectBase{Context}; ev: PEnvironment; flags: LongWord): LongWord; stdcall;

function Context.SOM_destroy(flags: LongWord): LongWord; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PContextClassDataStructure;
  LocalEnv: Environment;
begin
  cd := ContextClassData;
  SOM_InitEnvironment(@LocalEnv);
  Result :=
  somTD_Context_SOM_destroy
   (SOM_Resolve(Self, cd.classObject, cd.SOM_destroy))
     (Self, @LocalEnv, flags);
  SOM_UninitEnvironmentOrRaise(@LocalEnv);
end;

procedure Context.somDefaultInit(var ctrl: Pointer); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somDefaultInit
   (SOM_Resolve(Self, cd.classObject, cd.somDefaultInit))
     (Self, ctrl);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

procedure Context.somDestruct(doFree: Byte; var ctrl: Pointer); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somDestruct
   (SOM_Resolve(Self, cd.classObject, cd.somDestruct))
     (Self, doFree, ctrl);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

procedure Context.somDefaultCopyInit(var ctrl: Pointer; fromObj: Context); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somDefaultCopyInit
   (SOM_Resolve(Self, cd.classObject, cd.somDefaultCopyInit))
     (Self, ctrl, fromObj);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function Context.somDefaultAssign(var ctrl: Pointer; fromObj: Context): Context; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result := Context(
  somTD_SOMObject_somDefaultAssign
   (SOM_Resolve(Self, cd.classObject, cd.somDefaultAssign))
     (Self, ctrl, fromObj));
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

procedure Context.somDefaultConstCopyInit(var ctrl: Pointer; fromObj: Context); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somDefaultConstCopyInit
   (SOM_Resolve(Self, cd.classObject, cd.somDefaultConstCopyInit))
     (Self, ctrl, fromObj);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

procedure Context.somDefaultVCopyInit(var ctrl: Pointer; fromObj: Context); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somDefaultVCopyInit
   (SOM_Resolve(Self, cd.classObject, cd.somDefaultVCopyInit))
     (Self, ctrl, fromObj);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

procedure Context.somDefaultConstVCopyInit(var ctrl: Pointer; fromObj: Context); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somDefaultConstVCopyInit
   (SOM_Resolve(Self, cd.classObject, cd.somDefaultConstVCopyInit))
     (Self, ctrl, fromObj);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function Context.somDefaultConstAssign(var ctrl: Pointer; fromObj: Context): Context; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result := Context(
  somTD_SOMObject_somDefaultConstAssign
   (SOM_Resolve(Self, cd.classObject, cd.somDefaultConstAssign))
     (Self, ctrl, fromObj));
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function Context.somDefaultVAssign(var ctrl: Pointer; fromObj: Context): Context; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result := Context(
  somTD_SOMObject_somDefaultVAssign
   (SOM_Resolve(Self, cd.classObject, cd.somDefaultVAssign))
     (Self, ctrl, fromObj));
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function Context.somDefaultConstVAssign(var ctrl: Pointer; fromObj: Context): Context; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result := Context(
  somTD_SOMObject_somDefaultConstVAssign
   (SOM_Resolve(Self, cd.classObject, cd.somDefaultConstVAssign))
     (Self, ctrl, fromObj));
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

procedure Context.somInit; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somInit
   (SOM_Resolve(Self, cd.classObject, cd.somInit))
     (Self);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

procedure Context.somFree; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somFree
   (SOM_Resolve(Self, cd.classObject, cd.somFree))
     (Self);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

procedure Context.somUninit; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somUninit
   (SOM_Resolve(Self, cd.classObject, cd.somUninit))
     (Self);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function Context.somGetClass: SOMClass; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result := SOMClass(
  somTD_SOMObject_somGetClass
   (SOM_Resolve(Self, cd.classObject, cd.somGetClass))
     (Self));
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function Context.somGetClassName: {dual_owned} CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result :=
  somTD_SOMObject_somGetClassName
   (SOM_Resolve(Self, cd.classObject, cd.somGetClassName))
     (Self);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function Context.somGetSize: LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result :=
  somTD_SOMObject_somGetSize
   (SOM_Resolve(Self, cd.classObject, cd.somGetSize))
     (Self);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function Context.somIsA(aClassObj: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result :=
  somTD_SOMObject_somIsA
   (SOM_Resolve(Self, cd.classObject, cd.somIsA))
     (Self, aClassObj);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function Context.somIsInstanceOf(aClassObj: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result :=
  somTD_SOMObject_somIsInstanceOf
   (SOM_Resolve(Self, cd.classObject, cd.somIsInstanceOf))
     (Self, aClassObj);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function Context.somRespondsTo(mId: somId): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result :=
  somTD_SOMObject_somRespondsTo
   (SOM_Resolve(Self, cd.classObject, cd.somRespondsTo))
     (Self, mId);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function Context.somDispatch(out retValue: Pointer; methodId: somId; ap: va_list): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result :=
  somTD_SOMObject_somDispatch
   (SOM_Resolve(Self, cd.classObject, cd.somDispatch))
     (Self, retValue, methodId, ap);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function Context.somClassDispatch(clsObj: SOMClass; out retValue: Pointer; methodId: somId; ap: va_list): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result :=
  somTD_SOMObject_somClassDispatch
   (SOM_Resolve(Self, cd.classObject, cd.somClassDispatch))
     (Self, clsObj, retValue, methodId, ap);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function Context.somCastObj(cls: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result :=
  somTD_SOMObject_somCastObj
   (SOM_Resolve(Self, cd.classObject, cd.somCastObj))
     (Self, cls);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function Context.somResetObj: CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result :=
  somTD_SOMObject_somResetObj
   (SOM_Resolve(Self, cd.classObject, cd.somResetObj))
     (Self);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function Context.somPrintSelf: Context; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result := Context(
  somTD_SOMObject_somPrintSelf
   (SOM_Resolve(Self, cd.classObject, cd.somPrintSelf))
     (Self));
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

procedure Context.somDumpSelf(level: LongInt); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somDumpSelf
   (SOM_Resolve(Self, cd.classObject, cd.somDumpSelf))
     (Self, level);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

procedure Context.somDumpSelfInt(level: LongInt); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somDumpSelfInt
   (SOM_Resolve(Self, cd.classObject, cd.somDumpSelfInt))
     (Self, level);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

class function Context.ClassObject: SOMClass; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
begin
  if Self = Context then { invoked on class name literal }
  begin
    Result := SOMClass(ContextClassData.classObject);
  end
  else { invoked on SOM object }
  begin
    Result := SOMClass(PPointer(Self)^);
  end
end;

class function Context.NewClass: SOMClass;
begin
  if Self = Context then { invoked on class name literal }
  begin
    Result := SOMClass(ContextClassData.classObject);
    if not Assigned(Result) then Result := SOMClass(ContextNewClass);
  end
  else { invoked on SOM object }
  begin
    Result := SOMClass(PPointer(Self)^);
  end
end;

function Context.As_Context: Context; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
begin
  Result := Self;
end;

class function Context.Supports(Instance: SOMObjectBase): Boolean;
var
  cls: SOMClass;
begin
  if not Assigned(Instance) then
  begin
    Result := False;
  end
  else
  begin
    cls := SOMClass(ClassObject);
    if not Assigned(cls) then
    begin
      Result := False;
    end
    else
    begin
      Result := SOMObject(Instance).somIsA(cls);
    end;
  end;
end;

class function Context.Supports(Instance: SOMObjectBase; out Obj: Context): Boolean;
var
  cls: SOMClass;
begin
  if not Assigned(Instance) then
  begin
    Result := False;
    Obj := nil;
  end
  else
  begin
    cls := SOMClass(ClassObject);
    if not Assigned(cls) then
    begin
      Result := False;
      Obj := nil;
    end
    else if SOMObject(Instance).somIsA(cls) then
    begin
      Result := True;
      Obj := Context(Instance);
    end
    else
    begin
      Result := False;
      Obj := nil;
    end;
  end;
end;

const
  ConstantDef_MajorVersion = 2;
  ConstantDef_MinorVersion = 1;

(*
 * Declare the class creation procedure
 *)
function ConstantDefNewClass(
  somtmajorVersion: integer4 = ConstantDef_MajorVersion;
  somtminorVersion: integer4 = ConstantDef_MinorVersion):
  SOMClass; stdcall; external SOMIR_DLL_Name name 'ConstantDefNewClass';

(*
 * Declare the ABI 2 ClassData structure
 *)
type
  ConstantDefClassDataStructure = packed record
    classObject: SOMClass;
    _get_type,
    _set_type,
    _get_value,
    _set_value: somMToken;
  end;
  PConstantDefClassDataStructure = ^ConstantDefClassDataStructure;

var
  SOMIR_DLL_ConstantDefClassData: PConstantDefClassDataStructure = nil;

function ConstantDefClassData: PConstantDefClassDataStructure;
begin
  if Assigned(SOMIR_DLL_ConstantDefClassData) then
    Result := SOMIR_DLL_ConstantDefClassData
  else
  begin
    SOMIR_DLL_Load_Variable(SOMIR_DLL_ConstantDefClassData, 'ConstantDefClassData');
    Result := SOMIR_DLL_ConstantDefClassData;
  end;
end;

(*
 * Declare the ABI 2 CClassData structure
 *)
type
  ConstantDefCClassDataStructure = packed record
    parentMtab: somMethodTabs;
    instanceDataToken: somDToken;
  end;
  PConstantDefCClassDataStructure = ^ConstantDefCClassDataStructure;

var
  SOMIR_DLL_ConstantDefCClassData: PConstantDefCClassDataStructure = nil;

function ConstantDefCClassData: PConstantDefCClassDataStructure;
begin
  if Assigned(SOMIR_DLL_ConstantDefCClassData) then
    Result := SOMIR_DLL_ConstantDefCClassData
  else
  begin
    SOMIR_DLL_Load_Variable(SOMIR_DLL_ConstantDefCClassData, 'ConstantDefCClassData');
    Result := SOMIR_DLL_ConstantDefCClassData;
  end;
end;

(*
 * Class Object and Method Token Macros
 *)

(*
 * New Method: _get_type
 *)
type
  somTD_ConstantDef__get_type = function(somSelf: SOMObjectBase{ConstantDef}; ev: PEnvironment): TypeCode; stdcall;

function ConstantDef._get_type: TypeCode; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PConstantDefClassDataStructure;
  LocalEnv: Environment;
begin
  cd := ConstantDefClassData;
  SOM_InitEnvironment(@LocalEnv);
  Result :=
  somTD_ConstantDef__get_type
   (SOM_Resolve(Self, cd.classObject, cd._get_type))
     (Self, @LocalEnv);
  SOM_UninitEnvironmentOrRaise(@LocalEnv);
end;

(*
 * New Method: _set_type
 *)
type
  somTD_ConstantDef__set_type = procedure(somSelf: SOMObjectBase{ConstantDef}; ev: PEnvironment; SOM_type: {caller_owns} TypeCode); stdcall;

procedure ConstantDef._set_type(SOM_type: {caller_owns} TypeCode); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PConstantDefClassDataStructure;
  LocalEnv: Environment;
begin
  cd := ConstantDefClassData;
  SOM_InitEnvironment(@LocalEnv);
  somTD_ConstantDef__set_type
   (SOM_Resolve(Self, cd.classObject, cd._set_type))
     (Self, @LocalEnv, SOM_type);
  SOM_UninitEnvironmentOrRaise(@LocalEnv);
end;

(*
 * New Method: _get_value
 *)
type
  somTD_ConstantDef__get_value = function(somSelf: SOMObjectBase{ConstantDef}; ev: PEnvironment): TAnyResult; stdcall;

function ConstantDef._get_value: any; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PConstantDefClassDataStructure;
  LocalEnv: Environment;
begin
  cd := ConstantDefClassData;
  SOM_InitEnvironment(@LocalEnv);
  Result := any(
  somTD_ConstantDef__get_value
   (SOM_Resolve(Self, cd.classObject, cd._get_value))
     (Self, @LocalEnv));
  SOM_UninitEnvironmentOrRaise(@LocalEnv);
end;

(*
 * New Method: _set_value
 *)
type
  somTD_ConstantDef__set_value = procedure(somSelf: SOMObjectBase{ConstantDef}; ev: PEnvironment; const value: {caller_owns} any); stdcall;

procedure ConstantDef._set_value(const value: {caller_owns} any); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PConstantDefClassDataStructure;
  LocalEnv: Environment;
begin
  cd := ConstantDefClassData;
  SOM_InitEnvironment(@LocalEnv);
  somTD_ConstantDef__set_value
   (SOM_Resolve(Self, cd.classObject, cd._set_value))
     (Self, @LocalEnv, value);
  SOM_UninitEnvironmentOrRaise(@LocalEnv);
end;

function ConstantDef._get_name: CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PContainedClassDataStructure;
  LocalEnv: Environment;
begin
  cd := ContainedClassData;
  SOM_InitEnvironment(@LocalEnv);
  Result :=
  somTD_Contained__get_name
   (SOM_Resolve(Self, cd.classObject, cd._get_name))
     (Self, @LocalEnv);
  SOM_UninitEnvironmentOrRaise(@LocalEnv);
end;

procedure ConstantDef._set_name(name: {caller_owns} CORBAString); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PContainedClassDataStructure;
  LocalEnv: Environment;
begin
  cd := ContainedClassData;
  SOM_InitEnvironment(@LocalEnv);
  somTD_Contained__set_name
   (SOM_Resolve(Self, cd.classObject, cd._set_name))
     (Self, @LocalEnv, name);
  SOM_UninitEnvironmentOrRaise(@LocalEnv);
end;

function ConstantDef._get_id: CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PContainedClassDataStructure;
  LocalEnv: Environment;
begin
  cd := ContainedClassData;
  SOM_InitEnvironment(@LocalEnv);
  Result :=
  somTD_Contained__get_id
   (SOM_Resolve(Self, cd.classObject, cd._get_id))
     (Self, @LocalEnv);
  SOM_UninitEnvironmentOrRaise(@LocalEnv);
end;

procedure ConstantDef._set_id(id: {caller_owns} CORBAString); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PContainedClassDataStructure;
  LocalEnv: Environment;
begin
  cd := ContainedClassData;
  SOM_InitEnvironment(@LocalEnv);
  somTD_Contained__set_id
   (SOM_Resolve(Self, cd.classObject, cd._set_id))
     (Self, @LocalEnv, id);
  SOM_UninitEnvironmentOrRaise(@LocalEnv);
end;

function ConstantDef._get_defined_in: CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PContainedClassDataStructure;
  LocalEnv: Environment;
begin
  cd := ContainedClassData;
  SOM_InitEnvironment(@LocalEnv);
  Result :=
  somTD_Contained__get_defined_in
   (SOM_Resolve(Self, cd.classObject, cd._get_defined_in))
     (Self, @LocalEnv);
  SOM_UninitEnvironmentOrRaise(@LocalEnv);
end;

procedure ConstantDef._set_defined_in(defined_in: {caller_owns} CORBAString); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PContainedClassDataStructure;
  LocalEnv: Environment;
begin
  cd := ContainedClassData;
  SOM_InitEnvironment(@LocalEnv);
  somTD_Contained__set_defined_in
   (SOM_Resolve(Self, cd.classObject, cd._set_defined_in))
     (Self, @LocalEnv, defined_in);
  SOM_UninitEnvironmentOrRaise(@LocalEnv);
end;

function ConstantDef._get_somModifiers: _IDL_Sequence_somModifier; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PContainedClassDataStructure;
  LocalEnv: Environment;
begin
  cd := ContainedClassData;
  SOM_InitEnvironment(@LocalEnv);
  Result :=
  somTD_Contained__get_somModifiers
   (SOM_Resolve(Self, cd.classObject, cd._get_somModifiers))
     (Self, @LocalEnv);
  SOM_UninitEnvironmentOrRaise(@LocalEnv);
end;

procedure ConstantDef._set_somModifiers(const somModifiers: {caller_owns} _IDL_Sequence_somModifier); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PContainedClassDataStructure;
  LocalEnv: Environment;
begin
  cd := ContainedClassData;
  SOM_InitEnvironment(@LocalEnv);
  somTD_Contained__set_somModifiers
   (SOM_Resolve(Self, cd.classObject, cd._set_somModifiers))
     (Self, @LocalEnv, somModifiers);
  SOM_UninitEnvironmentOrRaise(@LocalEnv);
end;

class function ConstantDef.Create: ConstantDef; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
begin
  Result := ConstantDef(SOMClass(NewClass).somNew);
end;

class function ConstantDef.InitInstance(Instance: Pointer): ConstantDef; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
begin
  Result := ConstantDef(SOMClass(NewClass).somRenewNoInit(Instance));
end;

function ConstantDef.ClassType: SOMClass; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
begin
  Result := SOMClass(SOMObject(Self).somGetClass);
end;

class function ConstantDef.ClassName: string;
begin
  Result := AnsiString(SOMClass(NewClass).somGetName);
end;

class function ConstantDef.ClassNameIs(const Name: string): Boolean;
begin
  Result := AnsiString(SOMClass(NewClass).somGetName) = Name;
end;

class function ConstantDef.InstanceSize: LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
begin
  Result := SOMClass(NewClass).somGetInstanceSize;
end;

class function ConstantDef.InheritsFrom(AClass: SOMClass): Boolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
begin
  Result := SOMClass(NewClass).somDescendedFrom(AClass);
end;

class function ConstantDef.MethodAddress(const Name: string): Pointer;
var
  NameAsAnsiString: AnsiString;
  NameAsSomId: somId;
begin
  NameAsAnsiString := AnsiString(Name);
  NameAsSomId := somIdFromString(PAnsiChar(NameAsAnsiString));
  try
    SOMClass(NewClass).somFindMethod(NameAsSomId, Result);
  finally
    SOMMemFree(NameAsSomId);
  end;
end;

class function ConstantDef.NewInstance: ConstantDef; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
begin
  Result := ConstantDef(SOMClass(NewClass).somNewNoInit);
end;

function ConstantDef.Clone: ConstantDef; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
begin
  Result := ConstantDef(SOMClass(somGetClass).somNewNoInit);
  SOMObject(Result).somDefaultCopyInit(somInitCtrl(nil^), SOMObject(Self));
end;

function ConstantDef.within: _IDL_Sequence_Container; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PContainedClassDataStructure;
  LocalEnv: Environment;
begin
  cd := ContainedClassData;
  SOM_InitEnvironment(@LocalEnv);
  Result :=
  somTD_Contained_within
   (SOM_Resolve(Self, cd.classObject, cd.within))
     (Self, @LocalEnv);
  SOM_UninitEnvironmentOrRaise(@LocalEnv);
end;

function ConstantDef.describe: Contained_Description; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PContainedClassDataStructure;
  LocalEnv: Environment;
begin
  cd := ContainedClassData;
  SOM_InitEnvironment(@LocalEnv);
  Result :=
  somTD_Contained_describe
   (SOM_Resolve(Self, cd.classObject, cd.describe))
     (Self, @LocalEnv);
  SOM_UninitEnvironmentOrRaise(@LocalEnv);
end;

procedure ConstantDef.somDefaultInit(var ctrl: Pointer); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somDefaultInit
   (SOM_Resolve(Self, cd.classObject, cd.somDefaultInit))
     (Self, ctrl);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

procedure ConstantDef.somDestruct(doFree: Byte; var ctrl: Pointer); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somDestruct
   (SOM_Resolve(Self, cd.classObject, cd.somDestruct))
     (Self, doFree, ctrl);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

procedure ConstantDef.somDefaultCopyInit(var ctrl: Pointer; fromObj: ConstantDef); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somDefaultCopyInit
   (SOM_Resolve(Self, cd.classObject, cd.somDefaultCopyInit))
     (Self, ctrl, fromObj);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function ConstantDef.somDefaultAssign(var ctrl: Pointer; fromObj: ConstantDef): ConstantDef; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result := ConstantDef(
  somTD_SOMObject_somDefaultAssign
   (SOM_Resolve(Self, cd.classObject, cd.somDefaultAssign))
     (Self, ctrl, fromObj));
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

procedure ConstantDef.somDefaultConstCopyInit(var ctrl: Pointer; fromObj: ConstantDef); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somDefaultConstCopyInit
   (SOM_Resolve(Self, cd.classObject, cd.somDefaultConstCopyInit))
     (Self, ctrl, fromObj);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

procedure ConstantDef.somDefaultVCopyInit(var ctrl: Pointer; fromObj: ConstantDef); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somDefaultVCopyInit
   (SOM_Resolve(Self, cd.classObject, cd.somDefaultVCopyInit))
     (Self, ctrl, fromObj);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

procedure ConstantDef.somDefaultConstVCopyInit(var ctrl: Pointer; fromObj: ConstantDef); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somDefaultConstVCopyInit
   (SOM_Resolve(Self, cd.classObject, cd.somDefaultConstVCopyInit))
     (Self, ctrl, fromObj);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function ConstantDef.somDefaultConstAssign(var ctrl: Pointer; fromObj: ConstantDef): ConstantDef; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result := ConstantDef(
  somTD_SOMObject_somDefaultConstAssign
   (SOM_Resolve(Self, cd.classObject, cd.somDefaultConstAssign))
     (Self, ctrl, fromObj));
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function ConstantDef.somDefaultVAssign(var ctrl: Pointer; fromObj: ConstantDef): ConstantDef; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result := ConstantDef(
  somTD_SOMObject_somDefaultVAssign
   (SOM_Resolve(Self, cd.classObject, cd.somDefaultVAssign))
     (Self, ctrl, fromObj));
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function ConstantDef.somDefaultConstVAssign(var ctrl: Pointer; fromObj: ConstantDef): ConstantDef; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result := ConstantDef(
  somTD_SOMObject_somDefaultConstVAssign
   (SOM_Resolve(Self, cd.classObject, cd.somDefaultConstVAssign))
     (Self, ctrl, fromObj));
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

procedure ConstantDef.somInit; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somInit
   (SOM_Resolve(Self, cd.classObject, cd.somInit))
     (Self);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

procedure ConstantDef.somFree; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somFree
   (SOM_Resolve(Self, cd.classObject, cd.somFree))
     (Self);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

procedure ConstantDef.somUninit; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somUninit
   (SOM_Resolve(Self, cd.classObject, cd.somUninit))
     (Self);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function ConstantDef.somGetClass: SOMClass; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result := SOMClass(
  somTD_SOMObject_somGetClass
   (SOM_Resolve(Self, cd.classObject, cd.somGetClass))
     (Self));
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function ConstantDef.somGetClassName: {dual_owned} CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result :=
  somTD_SOMObject_somGetClassName
   (SOM_Resolve(Self, cd.classObject, cd.somGetClassName))
     (Self);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function ConstantDef.somGetSize: LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result :=
  somTD_SOMObject_somGetSize
   (SOM_Resolve(Self, cd.classObject, cd.somGetSize))
     (Self);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function ConstantDef.somIsA(aClassObj: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result :=
  somTD_SOMObject_somIsA
   (SOM_Resolve(Self, cd.classObject, cd.somIsA))
     (Self, aClassObj);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function ConstantDef.somIsInstanceOf(aClassObj: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result :=
  somTD_SOMObject_somIsInstanceOf
   (SOM_Resolve(Self, cd.classObject, cd.somIsInstanceOf))
     (Self, aClassObj);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function ConstantDef.somRespondsTo(mId: somId): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result :=
  somTD_SOMObject_somRespondsTo
   (SOM_Resolve(Self, cd.classObject, cd.somRespondsTo))
     (Self, mId);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function ConstantDef.somDispatch(out retValue: Pointer; methodId: somId; ap: va_list): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result :=
  somTD_SOMObject_somDispatch
   (SOM_Resolve(Self, cd.classObject, cd.somDispatch))
     (Self, retValue, methodId, ap);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function ConstantDef.somClassDispatch(clsObj: SOMClass; out retValue: Pointer; methodId: somId; ap: va_list): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result :=
  somTD_SOMObject_somClassDispatch
   (SOM_Resolve(Self, cd.classObject, cd.somClassDispatch))
     (Self, clsObj, retValue, methodId, ap);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function ConstantDef.somCastObj(cls: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result :=
  somTD_SOMObject_somCastObj
   (SOM_Resolve(Self, cd.classObject, cd.somCastObj))
     (Self, cls);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function ConstantDef.somResetObj: CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result :=
  somTD_SOMObject_somResetObj
   (SOM_Resolve(Self, cd.classObject, cd.somResetObj))
     (Self);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function ConstantDef.somPrintSelf: ConstantDef; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result := ConstantDef(
  somTD_SOMObject_somPrintSelf
   (SOM_Resolve(Self, cd.classObject, cd.somPrintSelf))
     (Self));
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

procedure ConstantDef.somDumpSelf(level: LongInt); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somDumpSelf
   (SOM_Resolve(Self, cd.classObject, cd.somDumpSelf))
     (Self, level);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

procedure ConstantDef.somDumpSelfInt(level: LongInt); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somDumpSelfInt
   (SOM_Resolve(Self, cd.classObject, cd.somDumpSelfInt))
     (Self, level);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

class function ConstantDef.ClassObject: SOMClass; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
begin
  if Self = ConstantDef then { invoked on class name literal }
  begin
    Result := SOMClass(ConstantDefClassData.classObject);
  end
  else { invoked on SOM object }
  begin
    Result := SOMClass(PPointer(Self)^);
  end
end;

class function ConstantDef.NewClass: SOMClass;
begin
  if Self = ConstantDef then { invoked on class name literal }
  begin
    Result := SOMClass(ConstantDefClassData.classObject);
    if not Assigned(Result) then Result := SOMClass(ConstantDefNewClass);
  end
  else { invoked on SOM object }
  begin
    Result := SOMClass(PPointer(Self)^);
  end
end;

function ConstantDef.As_Contained: Contained; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
begin
  Result := Contained(Self);
end;

function ConstantDef.As_ConstantDef: ConstantDef; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
begin
  Result := Self;
end;

class function ConstantDef.Supports(Instance: SOMObjectBase): Boolean;
var
  cls: SOMClass;
begin
  if not Assigned(Instance) then
  begin
    Result := False;
  end
  else
  begin
    cls := SOMClass(ClassObject);
    if not Assigned(cls) then
    begin
      Result := False;
    end
    else
    begin
      Result := SOMObject(Instance).somIsA(cls);
    end;
  end;
end;

class function ConstantDef.Supports(Instance: SOMObjectBase; out Obj: ConstantDef): Boolean;
var
  cls: SOMClass;
begin
  if not Assigned(Instance) then
  begin
    Result := False;
    Obj := nil;
  end
  else
  begin
    cls := SOMClass(ClassObject);
    if not Assigned(cls) then
    begin
      Result := False;
      Obj := nil;
    end
    else if SOMObject(Instance).somIsA(cls) then
    begin
      Result := True;
      Obj := ConstantDef(Instance);
    end
    else
    begin
      Result := False;
      Obj := nil;
    end;
  end;
end;

const
  Container_MajorVersion = 2;
  Container_MinorVersion = 1;

(*
 * Declare the class creation procedure
 *)
function ContainerNewClass(
  somtmajorVersion: integer4 = Container_MajorVersion;
  somtminorVersion: integer4 = Container_MinorVersion):
  SOMClass; stdcall; external SOMIR_DLL_Name name 'ContainerNewClass';

(*
 * Declare the ABI 2 ClassData structure
 *)
type
  ContainerClassDataStructure = packed record
    classObject: SOMClass;
    contents,
    lookup_name,
    describe_contents: somMToken;
  end;
  PContainerClassDataStructure = ^ContainerClassDataStructure;

var
  SOMIR_DLL_ContainerClassData: PContainerClassDataStructure = nil;

function ContainerClassData: PContainerClassDataStructure;
begin
  if Assigned(SOMIR_DLL_ContainerClassData) then
    Result := SOMIR_DLL_ContainerClassData
  else
  begin
    SOMIR_DLL_Load_Variable(SOMIR_DLL_ContainerClassData, 'ContainerClassData');
    Result := SOMIR_DLL_ContainerClassData;
  end;
end;

(*
 * Declare the ABI 2 CClassData structure
 *)
type
  ContainerCClassDataStructure = packed record
    parentMtab: somMethodTabs;
    instanceDataToken: somDToken;
  end;
  PContainerCClassDataStructure = ^ContainerCClassDataStructure;

var
  SOMIR_DLL_ContainerCClassData: PContainerCClassDataStructure = nil;

function ContainerCClassData: PContainerCClassDataStructure;
begin
  if Assigned(SOMIR_DLL_ContainerCClassData) then
    Result := SOMIR_DLL_ContainerCClassData
  else
  begin
    SOMIR_DLL_Load_Variable(SOMIR_DLL_ContainerCClassData, 'ContainerCClassData');
    Result := SOMIR_DLL_ContainerCClassData;
  end;
end;

(*
 * Class Object and Method Token Macros
 *)

class function Container.Create: Container; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
begin
  Result := Container(SOMClass(NewClass).somNew);
end;

class function Container.InitInstance(Instance: Pointer): Container; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
begin
  Result := Container(SOMClass(NewClass).somRenewNoInit(Instance));
end;

function Container.ClassType: SOMClass; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
begin
  Result := SOMClass(SOMObject(Self).somGetClass);
end;

class function Container.ClassName: string;
begin
  Result := AnsiString(SOMClass(NewClass).somGetName);
end;

class function Container.ClassNameIs(const Name: string): Boolean;
begin
  Result := AnsiString(SOMClass(NewClass).somGetName) = Name;
end;

class function Container.InstanceSize: LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
begin
  Result := SOMClass(NewClass).somGetInstanceSize;
end;

class function Container.InheritsFrom(AClass: SOMClass): Boolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
begin
  Result := SOMClass(NewClass).somDescendedFrom(AClass);
end;

class function Container.MethodAddress(const Name: string): Pointer;
var
  NameAsAnsiString: AnsiString;
  NameAsSomId: somId;
begin
  NameAsAnsiString := AnsiString(Name);
  NameAsSomId := somIdFromString(PAnsiChar(NameAsAnsiString));
  try
    SOMClass(NewClass).somFindMethod(NameAsSomId, Result);
  finally
    SOMMemFree(NameAsSomId);
  end;
end;

class function Container.NewInstance: Container; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
begin
  Result := Container(SOMClass(NewClass).somNewNoInit);
end;

function Container.Clone: Container; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
begin
  Result := Container(SOMClass(somGetClass).somNewNoInit);
  SOMObject(Result).somDefaultCopyInit(somInitCtrl(nil^), SOMObject(Self));
end;

(*
 * New Method: contents
 *)
type
  somTD_Container_contents = function(somSelf: SOMObjectBase{Container}; ev: PEnvironment; limit_type: CORBAString; exclude_inherited: CORBABoolean): {caller_owns} _IDL_Sequence_Contained; stdcall;

function Container.contents(limit_type: CORBAString; exclude_inherited: CORBABoolean): {caller_owns} _IDL_Sequence_Contained; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PContainerClassDataStructure;
  LocalEnv: Environment;
begin
  cd := ContainerClassData;
  SOM_InitEnvironment(@LocalEnv);
  Result :=
  somTD_Container_contents
   (SOM_Resolve(Self, cd.classObject, cd.contents))
     (Self, @LocalEnv, limit_type, exclude_inherited);
  SOM_UninitEnvironmentOrRaise(@LocalEnv);
end;

(*
 * New Method: lookup_name
 *)
type
  somTD_Container_lookup_name = function(somSelf: SOMObjectBase{Container}; ev: PEnvironment; search_name: {caller_owns} CORBAString; levels_to_search: LongInt; limit_type: CORBAString; exclude_inherited: CORBABoolean): {caller_owns} _IDL_Sequence_Contained; stdcall;

function Container.lookup_name(search_name: {caller_owns} CORBAString; levels_to_search: LongInt; limit_type: CORBAString; exclude_inherited: CORBABoolean): {caller_owns} _IDL_Sequence_Contained; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PContainerClassDataStructure;
  LocalEnv: Environment;
begin
  cd := ContainerClassData;
  SOM_InitEnvironment(@LocalEnv);
  Result :=
  somTD_Container_lookup_name
   (SOM_Resolve(Self, cd.classObject, cd.lookup_name))
     (Self, @LocalEnv, search_name, levels_to_search, limit_type, exclude_inherited);
  SOM_UninitEnvironmentOrRaise(@LocalEnv);
end;

(*
 * New Method: describe_contents
 *)
type
  somTD_Container_describe_contents = function(somSelf: SOMObjectBase{Container}; ev: PEnvironment; limit_type: CORBAString; exclude_inherited: CORBABoolean; max_returned_objs: LongInt): _IDL_Sequence_Container_ContainerDescription; stdcall;

function Container.describe_contents(limit_type: CORBAString; exclude_inherited: CORBABoolean; max_returned_objs: LongInt): _IDL_Sequence_Container_ContainerDescription; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PContainerClassDataStructure;
  LocalEnv: Environment;
begin
  cd := ContainerClassData;
  SOM_InitEnvironment(@LocalEnv);
  Result :=
  somTD_Container_describe_contents
   (SOM_Resolve(Self, cd.classObject, cd.describe_contents))
     (Self, @LocalEnv, limit_type, exclude_inherited, max_returned_objs);
  SOM_UninitEnvironmentOrRaise(@LocalEnv);
end;

procedure Container.somDefaultInit(var ctrl: Pointer); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somDefaultInit
   (SOM_Resolve(Self, cd.classObject, cd.somDefaultInit))
     (Self, ctrl);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

procedure Container.somDestruct(doFree: Byte; var ctrl: Pointer); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somDestruct
   (SOM_Resolve(Self, cd.classObject, cd.somDestruct))
     (Self, doFree, ctrl);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

procedure Container.somDefaultCopyInit(var ctrl: Pointer; fromObj: Container); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somDefaultCopyInit
   (SOM_Resolve(Self, cd.classObject, cd.somDefaultCopyInit))
     (Self, ctrl, fromObj);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function Container.somDefaultAssign(var ctrl: Pointer; fromObj: Container): Container; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result := Container(
  somTD_SOMObject_somDefaultAssign
   (SOM_Resolve(Self, cd.classObject, cd.somDefaultAssign))
     (Self, ctrl, fromObj));
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

procedure Container.somDefaultConstCopyInit(var ctrl: Pointer; fromObj: Container); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somDefaultConstCopyInit
   (SOM_Resolve(Self, cd.classObject, cd.somDefaultConstCopyInit))
     (Self, ctrl, fromObj);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

procedure Container.somDefaultVCopyInit(var ctrl: Pointer; fromObj: Container); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somDefaultVCopyInit
   (SOM_Resolve(Self, cd.classObject, cd.somDefaultVCopyInit))
     (Self, ctrl, fromObj);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

procedure Container.somDefaultConstVCopyInit(var ctrl: Pointer; fromObj: Container); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somDefaultConstVCopyInit
   (SOM_Resolve(Self, cd.classObject, cd.somDefaultConstVCopyInit))
     (Self, ctrl, fromObj);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function Container.somDefaultConstAssign(var ctrl: Pointer; fromObj: Container): Container; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result := Container(
  somTD_SOMObject_somDefaultConstAssign
   (SOM_Resolve(Self, cd.classObject, cd.somDefaultConstAssign))
     (Self, ctrl, fromObj));
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function Container.somDefaultVAssign(var ctrl: Pointer; fromObj: Container): Container; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result := Container(
  somTD_SOMObject_somDefaultVAssign
   (SOM_Resolve(Self, cd.classObject, cd.somDefaultVAssign))
     (Self, ctrl, fromObj));
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function Container.somDefaultConstVAssign(var ctrl: Pointer; fromObj: Container): Container; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result := Container(
  somTD_SOMObject_somDefaultConstVAssign
   (SOM_Resolve(Self, cd.classObject, cd.somDefaultConstVAssign))
     (Self, ctrl, fromObj));
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

procedure Container.somInit; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somInit
   (SOM_Resolve(Self, cd.classObject, cd.somInit))
     (Self);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

procedure Container.somFree; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somFree
   (SOM_Resolve(Self, cd.classObject, cd.somFree))
     (Self);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

procedure Container.somUninit; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somUninit
   (SOM_Resolve(Self, cd.classObject, cd.somUninit))
     (Self);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function Container.somGetClass: SOMClass; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result := SOMClass(
  somTD_SOMObject_somGetClass
   (SOM_Resolve(Self, cd.classObject, cd.somGetClass))
     (Self));
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function Container.somGetClassName: {dual_owned} CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result :=
  somTD_SOMObject_somGetClassName
   (SOM_Resolve(Self, cd.classObject, cd.somGetClassName))
     (Self);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function Container.somGetSize: LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result :=
  somTD_SOMObject_somGetSize
   (SOM_Resolve(Self, cd.classObject, cd.somGetSize))
     (Self);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function Container.somIsA(aClassObj: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result :=
  somTD_SOMObject_somIsA
   (SOM_Resolve(Self, cd.classObject, cd.somIsA))
     (Self, aClassObj);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function Container.somIsInstanceOf(aClassObj: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result :=
  somTD_SOMObject_somIsInstanceOf
   (SOM_Resolve(Self, cd.classObject, cd.somIsInstanceOf))
     (Self, aClassObj);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function Container.somRespondsTo(mId: somId): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result :=
  somTD_SOMObject_somRespondsTo
   (SOM_Resolve(Self, cd.classObject, cd.somRespondsTo))
     (Self, mId);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function Container.somDispatch(out retValue: Pointer; methodId: somId; ap: va_list): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result :=
  somTD_SOMObject_somDispatch
   (SOM_Resolve(Self, cd.classObject, cd.somDispatch))
     (Self, retValue, methodId, ap);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function Container.somClassDispatch(clsObj: SOMClass; out retValue: Pointer; methodId: somId; ap: va_list): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result :=
  somTD_SOMObject_somClassDispatch
   (SOM_Resolve(Self, cd.classObject, cd.somClassDispatch))
     (Self, clsObj, retValue, methodId, ap);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function Container.somCastObj(cls: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result :=
  somTD_SOMObject_somCastObj
   (SOM_Resolve(Self, cd.classObject, cd.somCastObj))
     (Self, cls);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function Container.somResetObj: CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result :=
  somTD_SOMObject_somResetObj
   (SOM_Resolve(Self, cd.classObject, cd.somResetObj))
     (Self);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function Container.somPrintSelf: Container; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result := Container(
  somTD_SOMObject_somPrintSelf
   (SOM_Resolve(Self, cd.classObject, cd.somPrintSelf))
     (Self));
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

procedure Container.somDumpSelf(level: LongInt); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somDumpSelf
   (SOM_Resolve(Self, cd.classObject, cd.somDumpSelf))
     (Self, level);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

procedure Container.somDumpSelfInt(level: LongInt); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somDumpSelfInt
   (SOM_Resolve(Self, cd.classObject, cd.somDumpSelfInt))
     (Self, level);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

class function Container.ClassObject: SOMClass; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
begin
  if Self = Container then { invoked on class name literal }
  begin
    Result := SOMClass(ContainerClassData.classObject);
  end
  else { invoked on SOM object }
  begin
    Result := SOMClass(PPointer(Self)^);
  end
end;

class function Container.NewClass: SOMClass;
begin
  if Self = Container then { invoked on class name literal }
  begin
    Result := SOMClass(ContainerClassData.classObject);
    if not Assigned(Result) then Result := SOMClass(ContainerNewClass);
  end
  else { invoked on SOM object }
  begin
    Result := SOMClass(PPointer(Self)^);
  end
end;

function Container.As_Container: Container; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
begin
  Result := Self;
end;

class function Container.Supports(Instance: SOMObjectBase): Boolean;
var
  cls: SOMClass;
begin
  if not Assigned(Instance) then
  begin
    Result := False;
  end
  else
  begin
    cls := SOMClass(ClassObject);
    if not Assigned(cls) then
    begin
      Result := False;
    end
    else
    begin
      Result := SOMObject(Instance).somIsA(cls);
    end;
  end;
end;

class function Container.Supports(Instance: SOMObjectBase; out Obj: Container): Boolean;
var
  cls: SOMClass;
begin
  if not Assigned(Instance) then
  begin
    Result := False;
    Obj := nil;
  end
  else
  begin
    cls := SOMClass(ClassObject);
    if not Assigned(cls) then
    begin
      Result := False;
      Obj := nil;
    end
    else if SOMObject(Instance).somIsA(cls) then
    begin
      Result := True;
      Obj := Container(Instance);
    end
    else
    begin
      Result := False;
      Obj := nil;
    end;
  end;
end;

const
  SOMEEMan_MajorVersion = 2;
  SOMEEMan_MinorVersion = 1;

(*
 * Declare the class creation procedure
 *)
function SOMEEManNewClass(
  somtmajorVersion: integer4 = SOMEEMan_MajorVersion;
  somtminorVersion: integer4 = SOMEEMan_MinorVersion):
  SOMClass; stdcall; external SOMEM_DLL_Name name 'SOMEEManNewClass';

(*
 * Declare the ABI 2 ClassData structure
 *)
type
  SOMEEManClassDataStructure = packed record
    classObject: SOMClass;
    someGetEManSem,
    someReleaseEManSem,
    someChangeRegData,
    someProcessEvent,
    someProcessEvents,
    someQueueEvent,
    someRegister,
    someRegisterEv,
    someRegisterProc,
    someShutdown,
    someUnRegister: somMToken;
  end;
  PSOMEEManClassDataStructure = ^SOMEEManClassDataStructure;

var
  SOMEM_DLL_SOMEEManClassData: PSOMEEManClassDataStructure = nil;

function SOMEEManClassData: PSOMEEManClassDataStructure;
begin
  if Assigned(SOMEM_DLL_SOMEEManClassData) then
    Result := SOMEM_DLL_SOMEEManClassData
  else
  begin
    SOMEM_DLL_Load_Variable(SOMEM_DLL_SOMEEManClassData, 'SOMEEManClassData');
    Result := SOMEM_DLL_SOMEEManClassData;
  end;
end;

(*
 * Declare the ABI 2 CClassData structure
 *)
type
  SOMEEManCClassDataStructure = packed record
    parentMtab: somMethodTabs;
    instanceDataToken: somDToken;
  end;
  PSOMEEManCClassDataStructure = ^SOMEEManCClassDataStructure;

var
  SOMEM_DLL_SOMEEManCClassData: PSOMEEManCClassDataStructure = nil;

function SOMEEManCClassData: PSOMEEManCClassDataStructure;
begin
  if Assigned(SOMEM_DLL_SOMEEManCClassData) then
    Result := SOMEM_DLL_SOMEEManCClassData
  else
  begin
    SOMEM_DLL_Load_Variable(SOMEM_DLL_SOMEEManCClassData, 'SOMEEManCClassData');
    Result := SOMEM_DLL_SOMEEManCClassData;
  end;
end;

(*
 * Class Object and Method Token Macros
 *)

class function SOMEEMan.Create: SOMEEMan; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
begin
  Result := SOMEEMan(SOMClass(NewClass).somNew);
end;

class function SOMEEMan.InitInstance(Instance: Pointer): SOMEEMan; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
begin
  Result := SOMEEMan(SOMClass(NewClass).somRenewNoInit(Instance));
end;

function SOMEEMan.ClassType: SOMMSingleInstance; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
begin
  Result := SOMMSingleInstance(SOMObject(Self).somGetClass);
end;

class function SOMEEMan.ClassName: string;
begin
  Result := AnsiString(SOMClass(NewClass).somGetName);
end;

class function SOMEEMan.ClassNameIs(const Name: string): Boolean;
begin
  Result := AnsiString(SOMClass(NewClass).somGetName) = Name;
end;

class function SOMEEMan.InstanceSize: LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
begin
  Result := SOMClass(NewClass).somGetInstanceSize;
end;

class function SOMEEMan.InheritsFrom(AClass: SOMClass): Boolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
begin
  Result := SOMClass(NewClass).somDescendedFrom(AClass);
end;

class function SOMEEMan.MethodAddress(const Name: string): Pointer;
var
  NameAsAnsiString: AnsiString;
  NameAsSomId: somId;
begin
  NameAsAnsiString := AnsiString(Name);
  NameAsSomId := somIdFromString(PAnsiChar(NameAsAnsiString));
  try
    SOMClass(NewClass).somFindMethod(NameAsSomId, Result);
  finally
    SOMMemFree(NameAsSomId);
  end;
end;

class function SOMEEMan.NewInstance: SOMEEMan; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
begin
  Result := SOMEEMan(SOMClass(NewClass).somNewNoInit);
end;

function SOMEEMan.Clone: SOMEEMan; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
begin
  Result := SOMEEMan(SOMClass(somGetClass).somNewNoInit);
  SOMObject(Result).somDefaultCopyInit(somInitCtrl(nil^), SOMObject(Self));
end;

(*
 * New Method: someGetEManSem
 *)
type
  somTD_SOMEEMan_someGetEManSem = procedure(somSelf: SOMObjectBase{SOMEEMan}; ev: PEnvironment); stdcall;

procedure SOMEEMan.someGetEManSem; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMEEManClassDataStructure;
  LocalEnv: Environment;
begin
  cd := SOMEEManClassData;
  SOM_InitEnvironment(@LocalEnv);
  somTD_SOMEEMan_someGetEManSem
   (SOM_Resolve(Self, cd.classObject, cd.someGetEManSem))
     (Self, @LocalEnv);
  SOM_UninitEnvironmentOrRaise(@LocalEnv);
end;

(*
 * New Method: someReleaseEManSem
 *)
type
  somTD_SOMEEMan_someReleaseEManSem = procedure(somSelf: SOMObjectBase{SOMEEMan}; ev: PEnvironment); stdcall;

procedure SOMEEMan.someReleaseEManSem; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMEEManClassDataStructure;
  LocalEnv: Environment;
begin
  cd := SOMEEManClassData;
  SOM_InitEnvironment(@LocalEnv);
  somTD_SOMEEMan_someReleaseEManSem
   (SOM_Resolve(Self, cd.classObject, cd.someReleaseEManSem))
     (Self, @LocalEnv);
  SOM_UninitEnvironmentOrRaise(@LocalEnv);
end;

(*
 * New Method: someChangeRegData
 *)
type
  somTD_SOMEEMan_someChangeRegData = procedure(somSelf: SOMObjectBase{SOMEEMan}; ev: PEnvironment; registrationId: LongInt; registerData: SOMEEMRegisterData); stdcall;

procedure SOMEEMan.someChangeRegData(registrationId: LongInt; registerData: SOMEEMRegisterData); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMEEManClassDataStructure;
  LocalEnv: Environment;
begin
  cd := SOMEEManClassData;
  SOM_InitEnvironment(@LocalEnv);
  somTD_SOMEEMan_someChangeRegData
   (SOM_Resolve(Self, cd.classObject, cd.someChangeRegData))
     (Self, @LocalEnv, registrationId, registerData);
  SOM_UninitEnvironmentOrRaise(@LocalEnv);
end;

(*
 * New Method: someProcessEvent
 *)
type
  somTD_SOMEEMan_someProcessEvent = procedure(somSelf: SOMObjectBase{SOMEEMan}; ev: PEnvironment; mask: LongWord); stdcall;

procedure SOMEEMan.someProcessEvent(mask: LongWord); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMEEManClassDataStructure;
  LocalEnv: Environment;
begin
  cd := SOMEEManClassData;
  SOM_InitEnvironment(@LocalEnv);
  somTD_SOMEEMan_someProcessEvent
   (SOM_Resolve(Self, cd.classObject, cd.someProcessEvent))
     (Self, @LocalEnv, mask);
  SOM_UninitEnvironmentOrRaise(@LocalEnv);
end;

(*
 * New Method: someProcessEvents
 *)
type
  somTD_SOMEEMan_someProcessEvents = procedure(somSelf: SOMObjectBase{SOMEEMan}; ev: PEnvironment); stdcall;

procedure SOMEEMan.someProcessEvents; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMEEManClassDataStructure;
  LocalEnv: Environment;
begin
  cd := SOMEEManClassData;
  SOM_InitEnvironment(@LocalEnv);
  somTD_SOMEEMan_someProcessEvents
   (SOM_Resolve(Self, cd.classObject, cd.someProcessEvents))
     (Self, @LocalEnv);
  SOM_UninitEnvironmentOrRaise(@LocalEnv);
end;

(*
 * New Method: someQueueEvent
 *)
type
  somTD_SOMEEMan_someQueueEvent = procedure(somSelf: SOMObjectBase{SOMEEMan}; ev: PEnvironment; event: SOMEClientEvent); stdcall;

procedure SOMEEMan.someQueueEvent(event: SOMEClientEvent); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMEEManClassDataStructure;
  LocalEnv: Environment;
begin
  cd := SOMEEManClassData;
  SOM_InitEnvironment(@LocalEnv);
  somTD_SOMEEMan_someQueueEvent
   (SOM_Resolve(Self, cd.classObject, cd.someQueueEvent))
     (Self, @LocalEnv, event);
  SOM_UninitEnvironmentOrRaise(@LocalEnv);
end;

(*
 * New Method: someRegister
 *)
type
  somTD_SOMEEMan_someRegister = function(somSelf: SOMObjectBase{SOMEEMan}; ev: PEnvironment; registerData: SOMEEMRegisterData; targetObject: SOMObject; targetMethod: CORBAString; targetData: Pointer): LongInt; stdcall;

function SOMEEMan.someRegister(registerData: SOMEEMRegisterData; targetObject: SOMObject; targetMethod: CORBAString; targetData: Pointer): LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMEEManClassDataStructure;
  LocalEnv: Environment;
begin
  cd := SOMEEManClassData;
  SOM_InitEnvironment(@LocalEnv);
  Result :=
  somTD_SOMEEMan_someRegister
   (SOM_Resolve(Self, cd.classObject, cd.someRegister))
     (Self, @LocalEnv, registerData, targetObject, targetMethod, targetData);
  SOM_UninitEnvironmentOrRaise(@LocalEnv);
end;

(*
 * New Method: someRegisterEv
 *)
type
  somTD_SOMEEMan_someRegisterEv = function(somSelf: SOMObjectBase{SOMEEMan}; ev: PEnvironment; registerData: SOMEEMRegisterData; targetObject: SOMObject; var callbackEv: Environment; targetMethod: CORBAString; targetData: Pointer): LongInt; stdcall;

function SOMEEMan.someRegisterEv(registerData: SOMEEMRegisterData; targetObject: SOMObject; var callbackEv: Environment; targetMethod: CORBAString; targetData: Pointer): LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMEEManClassDataStructure;
  LocalEnv: Environment;
begin
  cd := SOMEEManClassData;
  SOM_InitEnvironment(@LocalEnv);
  Result :=
  somTD_SOMEEMan_someRegisterEv
   (SOM_Resolve(Self, cd.classObject, cd.someRegisterEv))
     (Self, @LocalEnv, registerData, targetObject, callbackEv, targetMethod, targetData);
  SOM_UninitEnvironmentOrRaise(@LocalEnv);
end;

(*
 * New Method: someRegisterProc
 *)
type
  somTD_SOMEEMan_someRegisterProc = function(somSelf: SOMObjectBase{SOMEEMan}; ev: PEnvironment; registerData: SOMEEMRegisterData; targetProcedure: PPointer; targetData: Pointer): LongInt; stdcall;

function SOMEEMan.someRegisterProc(registerData: SOMEEMRegisterData; targetProcedure: PPointer; targetData: Pointer): LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMEEManClassDataStructure;
  LocalEnv: Environment;
begin
  cd := SOMEEManClassData;
  SOM_InitEnvironment(@LocalEnv);
  Result :=
  somTD_SOMEEMan_someRegisterProc
   (SOM_Resolve(Self, cd.classObject, cd.someRegisterProc))
     (Self, @LocalEnv, registerData, targetProcedure, targetData);
  SOM_UninitEnvironmentOrRaise(@LocalEnv);
end;

(*
 * New Method: someShutdown
 *)
type
  somTD_SOMEEMan_someShutdown = procedure(somSelf: SOMObjectBase{SOMEEMan}; ev: PEnvironment); stdcall;

procedure SOMEEMan.someShutdown; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMEEManClassDataStructure;
  LocalEnv: Environment;
begin
  cd := SOMEEManClassData;
  SOM_InitEnvironment(@LocalEnv);
  somTD_SOMEEMan_someShutdown
   (SOM_Resolve(Self, cd.classObject, cd.someShutdown))
     (Self, @LocalEnv);
  SOM_UninitEnvironmentOrRaise(@LocalEnv);
end;

(*
 * New Method: someUnRegister
 *)
type
  somTD_SOMEEMan_someUnRegister = procedure(somSelf: SOMObjectBase{SOMEEMan}; ev: PEnvironment; registrationId: LongInt); stdcall;

procedure SOMEEMan.someUnRegister(registrationId: LongInt); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMEEManClassDataStructure;
  LocalEnv: Environment;
begin
  cd := SOMEEManClassData;
  SOM_InitEnvironment(@LocalEnv);
  somTD_SOMEEMan_someUnRegister
   (SOM_Resolve(Self, cd.classObject, cd.someUnRegister))
     (Self, @LocalEnv, registrationId);
  SOM_UninitEnvironmentOrRaise(@LocalEnv);
end;

procedure SOMEEMan.somDefaultInit(var ctrl: Pointer); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somDefaultInit
   (SOM_Resolve(Self, cd.classObject, cd.somDefaultInit))
     (Self, ctrl);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

procedure SOMEEMan.somDestruct(doFree: Byte; var ctrl: Pointer); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somDestruct
   (SOM_Resolve(Self, cd.classObject, cd.somDestruct))
     (Self, doFree, ctrl);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

procedure SOMEEMan.somDefaultCopyInit(var ctrl: Pointer; fromObj: SOMEEMan); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somDefaultCopyInit
   (SOM_Resolve(Self, cd.classObject, cd.somDefaultCopyInit))
     (Self, ctrl, fromObj);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function SOMEEMan.somDefaultAssign(var ctrl: Pointer; fromObj: SOMEEMan): SOMEEMan; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result := SOMEEMan(
  somTD_SOMObject_somDefaultAssign
   (SOM_Resolve(Self, cd.classObject, cd.somDefaultAssign))
     (Self, ctrl, fromObj));
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

procedure SOMEEMan.somDefaultConstCopyInit(var ctrl: Pointer; fromObj: SOMEEMan); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somDefaultConstCopyInit
   (SOM_Resolve(Self, cd.classObject, cd.somDefaultConstCopyInit))
     (Self, ctrl, fromObj);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

procedure SOMEEMan.somDefaultVCopyInit(var ctrl: Pointer; fromObj: SOMEEMan); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somDefaultVCopyInit
   (SOM_Resolve(Self, cd.classObject, cd.somDefaultVCopyInit))
     (Self, ctrl, fromObj);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

procedure SOMEEMan.somDefaultConstVCopyInit(var ctrl: Pointer; fromObj: SOMEEMan); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somDefaultConstVCopyInit
   (SOM_Resolve(Self, cd.classObject, cd.somDefaultConstVCopyInit))
     (Self, ctrl, fromObj);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function SOMEEMan.somDefaultConstAssign(var ctrl: Pointer; fromObj: SOMEEMan): SOMEEMan; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result := SOMEEMan(
  somTD_SOMObject_somDefaultConstAssign
   (SOM_Resolve(Self, cd.classObject, cd.somDefaultConstAssign))
     (Self, ctrl, fromObj));
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function SOMEEMan.somDefaultVAssign(var ctrl: Pointer; fromObj: SOMEEMan): SOMEEMan; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result := SOMEEMan(
  somTD_SOMObject_somDefaultVAssign
   (SOM_Resolve(Self, cd.classObject, cd.somDefaultVAssign))
     (Self, ctrl, fromObj));
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function SOMEEMan.somDefaultConstVAssign(var ctrl: Pointer; fromObj: SOMEEMan): SOMEEMan; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result := SOMEEMan(
  somTD_SOMObject_somDefaultConstVAssign
   (SOM_Resolve(Self, cd.classObject, cd.somDefaultConstVAssign))
     (Self, ctrl, fromObj));
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

procedure SOMEEMan.somInit; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somInit
   (SOM_Resolve(Self, cd.classObject, cd.somInit))
     (Self);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

procedure SOMEEMan.somFree; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somFree
   (SOM_Resolve(Self, cd.classObject, cd.somFree))
     (Self);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

procedure SOMEEMan.somUninit; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somUninit
   (SOM_Resolve(Self, cd.classObject, cd.somUninit))
     (Self);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function SOMEEMan.somGetClass: SOMMSingleInstance; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result := SOMMSingleInstance(
  somTD_SOMObject_somGetClass
   (SOM_Resolve(Self, cd.classObject, cd.somGetClass))
     (Self));
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function SOMEEMan.somGetClassName: {dual_owned} CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result :=
  somTD_SOMObject_somGetClassName
   (SOM_Resolve(Self, cd.classObject, cd.somGetClassName))
     (Self);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function SOMEEMan.somGetSize: LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result :=
  somTD_SOMObject_somGetSize
   (SOM_Resolve(Self, cd.classObject, cd.somGetSize))
     (Self);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function SOMEEMan.somIsA(aClassObj: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result :=
  somTD_SOMObject_somIsA
   (SOM_Resolve(Self, cd.classObject, cd.somIsA))
     (Self, aClassObj);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function SOMEEMan.somIsInstanceOf(aClassObj: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result :=
  somTD_SOMObject_somIsInstanceOf
   (SOM_Resolve(Self, cd.classObject, cd.somIsInstanceOf))
     (Self, aClassObj);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function SOMEEMan.somRespondsTo(mId: somId): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result :=
  somTD_SOMObject_somRespondsTo
   (SOM_Resolve(Self, cd.classObject, cd.somRespondsTo))
     (Self, mId);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function SOMEEMan.somDispatch(out retValue: Pointer; methodId: somId; ap: va_list): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result :=
  somTD_SOMObject_somDispatch
   (SOM_Resolve(Self, cd.classObject, cd.somDispatch))
     (Self, retValue, methodId, ap);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function SOMEEMan.somClassDispatch(clsObj: SOMClass; out retValue: Pointer; methodId: somId; ap: va_list): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result :=
  somTD_SOMObject_somClassDispatch
   (SOM_Resolve(Self, cd.classObject, cd.somClassDispatch))
     (Self, clsObj, retValue, methodId, ap);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function SOMEEMan.somCastObj(cls: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result :=
  somTD_SOMObject_somCastObj
   (SOM_Resolve(Self, cd.classObject, cd.somCastObj))
     (Self, cls);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function SOMEEMan.somResetObj: CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result :=
  somTD_SOMObject_somResetObj
   (SOM_Resolve(Self, cd.classObject, cd.somResetObj))
     (Self);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function SOMEEMan.somPrintSelf: SOMEEMan; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result := SOMEEMan(
  somTD_SOMObject_somPrintSelf
   (SOM_Resolve(Self, cd.classObject, cd.somPrintSelf))
     (Self));
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

procedure SOMEEMan.somDumpSelf(level: LongInt); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somDumpSelf
   (SOM_Resolve(Self, cd.classObject, cd.somDumpSelf))
     (Self, level);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

procedure SOMEEMan.somDumpSelfInt(level: LongInt); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somDumpSelfInt
   (SOM_Resolve(Self, cd.classObject, cd.somDumpSelfInt))
     (Self, level);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

class function SOMEEMan.ClassObject: SOMMSingleInstance; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
begin
  if Self = SOMEEMan then { invoked on class name literal }
  begin
    Result := SOMMSingleInstance(SOMEEManClassData.classObject);
  end
  else { invoked on SOM object }
  begin
    Result := SOMMSingleInstance(PPointer(Self)^);
  end
end;

class function SOMEEMan.NewClass: SOMMSingleInstance;
begin
  if Self = SOMEEMan then { invoked on class name literal }
  begin
    Result := SOMMSingleInstance(SOMEEManClassData.classObject);
    if not Assigned(Result) then Result := SOMMSingleInstance(SOMEEManNewClass);
  end
  else { invoked on SOM object }
  begin
    Result := SOMMSingleInstance(PPointer(Self)^);
  end
end;

function SOMEEMan.As_SOMEEMan: SOMEEMan; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
begin
  Result := Self;
end;

class function SOMEEMan.Supports(Instance: SOMObjectBase): Boolean;
var
  cls: SOMClass;
begin
  if not Assigned(Instance) then
  begin
    Result := False;
  end
  else
  begin
    cls := SOMClass(ClassObject);
    if not Assigned(cls) then
    begin
      Result := False;
    end
    else
    begin
      Result := SOMObject(Instance).somIsA(cls);
    end;
  end;
end;

class function SOMEEMan.Supports(Instance: SOMObjectBase; out Obj: SOMEEMan): Boolean;
var
  cls: SOMClass;
begin
  if not Assigned(Instance) then
  begin
    Result := False;
    Obj := nil;
  end
  else
  begin
    cls := SOMClass(ClassObject);
    if not Assigned(cls) then
    begin
      Result := False;
      Obj := nil;
    end
    else if SOMObject(Instance).somIsA(cls) then
    begin
      Result := True;
      Obj := SOMEEMan(Instance);
    end
    else
    begin
      Result := False;
      Obj := nil;
    end;
  end;
end;

const
  SOMEEMRegisterData_MajorVersion = 2;
  SOMEEMRegisterData_MinorVersion = 1;

(*
 * Declare the class creation procedure
 *)
function SOMEEMRegisterDataNewClass(
  somtmajorVersion: integer4 = SOMEEMRegisterData_MajorVersion;
  somtminorVersion: integer4 = SOMEEMRegisterData_MinorVersion):
  SOMClass; stdcall; external SOMEM_DLL_Name name 'SOMEEMRegisterDataNewClass';

(*
 * Declare the ABI 2 ClassData structure
 *)
type
  SOMEEMRegisterDataClassDataStructure = packed record
    classObject: SOMClass;
    someClearRegData,
    someSetRegDataClientType,
    someSetRegDataEventMask,
    someSetRegDataSink,
    someSetRegDataSinkMask,
    someSetRegDataTimerCount,
    someSetRegDataTimerInterval: somMToken;
  end;
  PSOMEEMRegisterDataClassDataStructure = ^SOMEEMRegisterDataClassDataStructure;

var
  SOMEM_DLL_SOMEEMRegisterDataClassData: PSOMEEMRegisterDataClassDataStructure = nil;

function SOMEEMRegisterDataClassData: PSOMEEMRegisterDataClassDataStructure;
begin
  if Assigned(SOMEM_DLL_SOMEEMRegisterDataClassData) then
    Result := SOMEM_DLL_SOMEEMRegisterDataClassData
  else
  begin
    SOMEM_DLL_Load_Variable(SOMEM_DLL_SOMEEMRegisterDataClassData, 'SOMEEMRegisterDataClassData');
    Result := SOMEM_DLL_SOMEEMRegisterDataClassData;
  end;
end;

(*
 * Declare the ABI 2 CClassData structure
 *)
type
  SOMEEMRegisterDataCClassDataStructure = packed record
    parentMtab: somMethodTabs;
    instanceDataToken: somDToken;
  end;
  PSOMEEMRegisterDataCClassDataStructure = ^SOMEEMRegisterDataCClassDataStructure;

var
  SOMEM_DLL_SOMEEMRegisterDataCClassData: PSOMEEMRegisterDataCClassDataStructure = nil;

function SOMEEMRegisterDataCClassData: PSOMEEMRegisterDataCClassDataStructure;
begin
  if Assigned(SOMEM_DLL_SOMEEMRegisterDataCClassData) then
    Result := SOMEM_DLL_SOMEEMRegisterDataCClassData
  else
  begin
    SOMEM_DLL_Load_Variable(SOMEM_DLL_SOMEEMRegisterDataCClassData, 'SOMEEMRegisterDataCClassData');
    Result := SOMEM_DLL_SOMEEMRegisterDataCClassData;
  end;
end;

(*
 * Class Object and Method Token Macros
 *)

class function SOMEEMRegisterData.Create: SOMEEMRegisterData; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
begin
  Result := SOMEEMRegisterData(SOMClass(NewClass).somNew);
end;

class function SOMEEMRegisterData.InitInstance(Instance: Pointer): SOMEEMRegisterData; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
begin
  Result := SOMEEMRegisterData(SOMClass(NewClass).somRenewNoInit(Instance));
end;

function SOMEEMRegisterData.ClassType: SOMClass; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
begin
  Result := SOMClass(SOMObject(Self).somGetClass);
end;

class function SOMEEMRegisterData.ClassName: string;
begin
  Result := AnsiString(SOMClass(NewClass).somGetName);
end;

class function SOMEEMRegisterData.ClassNameIs(const Name: string): Boolean;
begin
  Result := AnsiString(SOMClass(NewClass).somGetName) = Name;
end;

class function SOMEEMRegisterData.InstanceSize: LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
begin
  Result := SOMClass(NewClass).somGetInstanceSize;
end;

class function SOMEEMRegisterData.InheritsFrom(AClass: SOMClass): Boolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
begin
  Result := SOMClass(NewClass).somDescendedFrom(AClass);
end;

class function SOMEEMRegisterData.MethodAddress(const Name: string): Pointer;
var
  NameAsAnsiString: AnsiString;
  NameAsSomId: somId;
begin
  NameAsAnsiString := AnsiString(Name);
  NameAsSomId := somIdFromString(PAnsiChar(NameAsAnsiString));
  try
    SOMClass(NewClass).somFindMethod(NameAsSomId, Result);
  finally
    SOMMemFree(NameAsSomId);
  end;
end;

class function SOMEEMRegisterData.NewInstance: SOMEEMRegisterData; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
begin
  Result := SOMEEMRegisterData(SOMClass(NewClass).somNewNoInit);
end;

function SOMEEMRegisterData.Clone: SOMEEMRegisterData; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
begin
  Result := SOMEEMRegisterData(SOMClass(somGetClass).somNewNoInit);
  SOMObject(Result).somDefaultCopyInit(somInitCtrl(nil^), SOMObject(Self));
end;

(*
 * New Method: someClearRegData
 *)
type
  somTD_SOMEEMRegisterData_someClearRegData = procedure(somSelf: SOMObjectBase{SOMEEMRegisterData}; ev: PEnvironment); stdcall;

procedure SOMEEMRegisterData.someClearRegData; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMEEMRegisterDataClassDataStructure;
  LocalEnv: Environment;
begin
  cd := SOMEEMRegisterDataClassData;
  SOM_InitEnvironment(@LocalEnv);
  somTD_SOMEEMRegisterData_someClearRegData
   (SOM_Resolve(Self, cd.classObject, cd.someClearRegData))
     (Self, @LocalEnv);
  SOM_UninitEnvironmentOrRaise(@LocalEnv);
end;

(*
 * New Method: someSetRegDataClientType
 *)
type
  somTD_SOMEEMRegisterData_someSetRegDataClientType = procedure(somSelf: SOMObjectBase{SOMEEMRegisterData}; ev: PEnvironment; clientType: CORBAString); stdcall;

procedure SOMEEMRegisterData.someSetRegDataClientType(clientType: CORBAString); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMEEMRegisterDataClassDataStructure;
  LocalEnv: Environment;
begin
  cd := SOMEEMRegisterDataClassData;
  SOM_InitEnvironment(@LocalEnv);
  somTD_SOMEEMRegisterData_someSetRegDataClientType
   (SOM_Resolve(Self, cd.classObject, cd.someSetRegDataClientType))
     (Self, @LocalEnv, clientType);
  SOM_UninitEnvironmentOrRaise(@LocalEnv);
end;

(*
 * New Method: someSetRegDataEventMask
 *)
type
  somTD_SOMEEMRegisterData_someSetRegDataEventMask = procedure(somSelf: SOMObjectBase{SOMEEMRegisterData}; ev: PEnvironment; eventType: LongInt; ap: va_list); stdcall;

procedure SOMEEMRegisterData.someSetRegDataEventMask(eventType: LongInt; ap: va_list); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMEEMRegisterDataClassDataStructure;
  LocalEnv: Environment;
begin
  cd := SOMEEMRegisterDataClassData;
  SOM_InitEnvironment(@LocalEnv);
  somTD_SOMEEMRegisterData_someSetRegDataEventMask
   (SOM_Resolve(Self, cd.classObject, cd.someSetRegDataEventMask))
     (Self, @LocalEnv, eventType, ap);
  SOM_UninitEnvironmentOrRaise(@LocalEnv);
end;

(*
 * New Method: someSetRegDataSink
 *)
type
  somTD_SOMEEMRegisterData_someSetRegDataSink = procedure(somSelf: SOMObjectBase{SOMEEMRegisterData}; ev: PEnvironment; sink: LongInt); stdcall;

procedure SOMEEMRegisterData.someSetRegDataSink(sink: LongInt); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMEEMRegisterDataClassDataStructure;
  LocalEnv: Environment;
begin
  cd := SOMEEMRegisterDataClassData;
  SOM_InitEnvironment(@LocalEnv);
  somTD_SOMEEMRegisterData_someSetRegDataSink
   (SOM_Resolve(Self, cd.classObject, cd.someSetRegDataSink))
     (Self, @LocalEnv, sink);
  SOM_UninitEnvironmentOrRaise(@LocalEnv);
end;

(*
 * New Method: someSetRegDataSinkMask
 *)
type
  somTD_SOMEEMRegisterData_someSetRegDataSinkMask = procedure(somSelf: SOMObjectBase{SOMEEMRegisterData}; ev: PEnvironment; sinkMask: LongWord); stdcall;

procedure SOMEEMRegisterData.someSetRegDataSinkMask(sinkMask: LongWord); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMEEMRegisterDataClassDataStructure;
  LocalEnv: Environment;
begin
  cd := SOMEEMRegisterDataClassData;
  SOM_InitEnvironment(@LocalEnv);
  somTD_SOMEEMRegisterData_someSetRegDataSinkMask
   (SOM_Resolve(Self, cd.classObject, cd.someSetRegDataSinkMask))
     (Self, @LocalEnv, sinkMask);
  SOM_UninitEnvironmentOrRaise(@LocalEnv);
end;

(*
 * New Method: someSetRegDataTimerCount
 *)
type
  somTD_SOMEEMRegisterData_someSetRegDataTimerCount = procedure(somSelf: SOMObjectBase{SOMEEMRegisterData}; ev: PEnvironment; count: LongInt); stdcall;

procedure SOMEEMRegisterData.someSetRegDataTimerCount(count: LongInt); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMEEMRegisterDataClassDataStructure;
  LocalEnv: Environment;
begin
  cd := SOMEEMRegisterDataClassData;
  SOM_InitEnvironment(@LocalEnv);
  somTD_SOMEEMRegisterData_someSetRegDataTimerCount
   (SOM_Resolve(Self, cd.classObject, cd.someSetRegDataTimerCount))
     (Self, @LocalEnv, count);
  SOM_UninitEnvironmentOrRaise(@LocalEnv);
end;

(*
 * New Method: someSetRegDataTimerInterval
 *)
type
  somTD_SOMEEMRegisterData_someSetRegDataTimerInterval = procedure(somSelf: SOMObjectBase{SOMEEMRegisterData}; ev: PEnvironment; interval: LongInt); stdcall;

procedure SOMEEMRegisterData.someSetRegDataTimerInterval(interval: LongInt); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMEEMRegisterDataClassDataStructure;
  LocalEnv: Environment;
begin
  cd := SOMEEMRegisterDataClassData;
  SOM_InitEnvironment(@LocalEnv);
  somTD_SOMEEMRegisterData_someSetRegDataTimerInterval
   (SOM_Resolve(Self, cd.classObject, cd.someSetRegDataTimerInterval))
     (Self, @LocalEnv, interval);
  SOM_UninitEnvironmentOrRaise(@LocalEnv);
end;

procedure SOMEEMRegisterData.somDefaultInit(var ctrl: Pointer); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somDefaultInit
   (SOM_Resolve(Self, cd.classObject, cd.somDefaultInit))
     (Self, ctrl);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

procedure SOMEEMRegisterData.somDestruct(doFree: Byte; var ctrl: Pointer); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somDestruct
   (SOM_Resolve(Self, cd.classObject, cd.somDestruct))
     (Self, doFree, ctrl);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

procedure SOMEEMRegisterData.somDefaultCopyInit(var ctrl: Pointer; fromObj: SOMEEMRegisterData); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somDefaultCopyInit
   (SOM_Resolve(Self, cd.classObject, cd.somDefaultCopyInit))
     (Self, ctrl, fromObj);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function SOMEEMRegisterData.somDefaultAssign(var ctrl: Pointer; fromObj: SOMEEMRegisterData): SOMEEMRegisterData; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result := SOMEEMRegisterData(
  somTD_SOMObject_somDefaultAssign
   (SOM_Resolve(Self, cd.classObject, cd.somDefaultAssign))
     (Self, ctrl, fromObj));
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

procedure SOMEEMRegisterData.somDefaultConstCopyInit(var ctrl: Pointer; fromObj: SOMEEMRegisterData); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somDefaultConstCopyInit
   (SOM_Resolve(Self, cd.classObject, cd.somDefaultConstCopyInit))
     (Self, ctrl, fromObj);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

procedure SOMEEMRegisterData.somDefaultVCopyInit(var ctrl: Pointer; fromObj: SOMEEMRegisterData); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somDefaultVCopyInit
   (SOM_Resolve(Self, cd.classObject, cd.somDefaultVCopyInit))
     (Self, ctrl, fromObj);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

procedure SOMEEMRegisterData.somDefaultConstVCopyInit(var ctrl: Pointer; fromObj: SOMEEMRegisterData); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somDefaultConstVCopyInit
   (SOM_Resolve(Self, cd.classObject, cd.somDefaultConstVCopyInit))
     (Self, ctrl, fromObj);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function SOMEEMRegisterData.somDefaultConstAssign(var ctrl: Pointer; fromObj: SOMEEMRegisterData): SOMEEMRegisterData; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result := SOMEEMRegisterData(
  somTD_SOMObject_somDefaultConstAssign
   (SOM_Resolve(Self, cd.classObject, cd.somDefaultConstAssign))
     (Self, ctrl, fromObj));
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function SOMEEMRegisterData.somDefaultVAssign(var ctrl: Pointer; fromObj: SOMEEMRegisterData): SOMEEMRegisterData; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result := SOMEEMRegisterData(
  somTD_SOMObject_somDefaultVAssign
   (SOM_Resolve(Self, cd.classObject, cd.somDefaultVAssign))
     (Self, ctrl, fromObj));
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function SOMEEMRegisterData.somDefaultConstVAssign(var ctrl: Pointer; fromObj: SOMEEMRegisterData): SOMEEMRegisterData; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result := SOMEEMRegisterData(
  somTD_SOMObject_somDefaultConstVAssign
   (SOM_Resolve(Self, cd.classObject, cd.somDefaultConstVAssign))
     (Self, ctrl, fromObj));
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

procedure SOMEEMRegisterData.somInit; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somInit
   (SOM_Resolve(Self, cd.classObject, cd.somInit))
     (Self);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

procedure SOMEEMRegisterData.somFree; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somFree
   (SOM_Resolve(Self, cd.classObject, cd.somFree))
     (Self);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

procedure SOMEEMRegisterData.somUninit; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somUninit
   (SOM_Resolve(Self, cd.classObject, cd.somUninit))
     (Self);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function SOMEEMRegisterData.somGetClass: SOMClass; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result := SOMClass(
  somTD_SOMObject_somGetClass
   (SOM_Resolve(Self, cd.classObject, cd.somGetClass))
     (Self));
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function SOMEEMRegisterData.somGetClassName: {dual_owned} CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result :=
  somTD_SOMObject_somGetClassName
   (SOM_Resolve(Self, cd.classObject, cd.somGetClassName))
     (Self);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function SOMEEMRegisterData.somGetSize: LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result :=
  somTD_SOMObject_somGetSize
   (SOM_Resolve(Self, cd.classObject, cd.somGetSize))
     (Self);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function SOMEEMRegisterData.somIsA(aClassObj: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result :=
  somTD_SOMObject_somIsA
   (SOM_Resolve(Self, cd.classObject, cd.somIsA))
     (Self, aClassObj);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function SOMEEMRegisterData.somIsInstanceOf(aClassObj: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result :=
  somTD_SOMObject_somIsInstanceOf
   (SOM_Resolve(Self, cd.classObject, cd.somIsInstanceOf))
     (Self, aClassObj);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function SOMEEMRegisterData.somRespondsTo(mId: somId): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result :=
  somTD_SOMObject_somRespondsTo
   (SOM_Resolve(Self, cd.classObject, cd.somRespondsTo))
     (Self, mId);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function SOMEEMRegisterData.somDispatch(out retValue: Pointer; methodId: somId; ap: va_list): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result :=
  somTD_SOMObject_somDispatch
   (SOM_Resolve(Self, cd.classObject, cd.somDispatch))
     (Self, retValue, methodId, ap);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function SOMEEMRegisterData.somClassDispatch(clsObj: SOMClass; out retValue: Pointer; methodId: somId; ap: va_list): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result :=
  somTD_SOMObject_somClassDispatch
   (SOM_Resolve(Self, cd.classObject, cd.somClassDispatch))
     (Self, clsObj, retValue, methodId, ap);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function SOMEEMRegisterData.somCastObj(cls: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result :=
  somTD_SOMObject_somCastObj
   (SOM_Resolve(Self, cd.classObject, cd.somCastObj))
     (Self, cls);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function SOMEEMRegisterData.somResetObj: CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result :=
  somTD_SOMObject_somResetObj
   (SOM_Resolve(Self, cd.classObject, cd.somResetObj))
     (Self);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function SOMEEMRegisterData.somPrintSelf: SOMEEMRegisterData; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result := SOMEEMRegisterData(
  somTD_SOMObject_somPrintSelf
   (SOM_Resolve(Self, cd.classObject, cd.somPrintSelf))
     (Self));
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

procedure SOMEEMRegisterData.somDumpSelf(level: LongInt); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somDumpSelf
   (SOM_Resolve(Self, cd.classObject, cd.somDumpSelf))
     (Self, level);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

procedure SOMEEMRegisterData.somDumpSelfInt(level: LongInt); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somDumpSelfInt
   (SOM_Resolve(Self, cd.classObject, cd.somDumpSelfInt))
     (Self, level);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

class function SOMEEMRegisterData.ClassObject: SOMClass; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
begin
  if Self = SOMEEMRegisterData then { invoked on class name literal }
  begin
    Result := SOMClass(SOMEEMRegisterDataClassData.classObject);
  end
  else { invoked on SOM object }
  begin
    Result := SOMClass(PPointer(Self)^);
  end
end;

class function SOMEEMRegisterData.NewClass: SOMClass;
begin
  if Self = SOMEEMRegisterData then { invoked on class name literal }
  begin
    Result := SOMClass(SOMEEMRegisterDataClassData.classObject);
    if not Assigned(Result) then Result := SOMClass(SOMEEMRegisterDataNewClass);
  end
  else { invoked on SOM object }
  begin
    Result := SOMClass(PPointer(Self)^);
  end
end;

function SOMEEMRegisterData.As_SOMEEMRegisterData: SOMEEMRegisterData; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
begin
  Result := Self;
end;

class function SOMEEMRegisterData.Supports(Instance: SOMObjectBase): Boolean;
var
  cls: SOMClass;
begin
  if not Assigned(Instance) then
  begin
    Result := False;
  end
  else
  begin
    cls := SOMClass(ClassObject);
    if not Assigned(cls) then
    begin
      Result := False;
    end
    else
    begin
      Result := SOMObject(Instance).somIsA(cls);
    end;
  end;
end;

class function SOMEEMRegisterData.Supports(Instance: SOMObjectBase; out Obj: SOMEEMRegisterData): Boolean;
var
  cls: SOMClass;
begin
  if not Assigned(Instance) then
  begin
    Result := False;
    Obj := nil;
  end
  else
  begin
    cls := SOMClass(ClassObject);
    if not Assigned(cls) then
    begin
      Result := False;
      Obj := nil;
    end
    else if SOMObject(Instance).somIsA(cls) then
    begin
      Result := True;
      Obj := SOMEEMRegisterData(Instance);
    end
    else
    begin
      Result := False;
      Obj := nil;
    end;
  end;
end;

const
  ExceptionDef_MajorVersion = 2;
  ExceptionDef_MinorVersion = 1;

(*
 * Declare the class creation procedure
 *)
function ExceptionDefNewClass(
  somtmajorVersion: integer4 = ExceptionDef_MajorVersion;
  somtminorVersion: integer4 = ExceptionDef_MinorVersion):
  SOMClass; stdcall; external SOMIR_DLL_Name name 'ExceptionDefNewClass';

(*
 * Declare the ABI 2 ClassData structure
 *)
type
  ExceptionDefClassDataStructure = packed record
    classObject: SOMClass;
    _get_type,
    _set_type: somMToken;
  end;
  PExceptionDefClassDataStructure = ^ExceptionDefClassDataStructure;

var
  SOMIR_DLL_ExceptionDefClassData: PExceptionDefClassDataStructure = nil;

function ExceptionDefClassData: PExceptionDefClassDataStructure;
begin
  if Assigned(SOMIR_DLL_ExceptionDefClassData) then
    Result := SOMIR_DLL_ExceptionDefClassData
  else
  begin
    SOMIR_DLL_Load_Variable(SOMIR_DLL_ExceptionDefClassData, 'ExceptionDefClassData');
    Result := SOMIR_DLL_ExceptionDefClassData;
  end;
end;

(*
 * Declare the ABI 2 CClassData structure
 *)
type
  ExceptionDefCClassDataStructure = packed record
    parentMtab: somMethodTabs;
    instanceDataToken: somDToken;
  end;
  PExceptionDefCClassDataStructure = ^ExceptionDefCClassDataStructure;

var
  SOMIR_DLL_ExceptionDefCClassData: PExceptionDefCClassDataStructure = nil;

function ExceptionDefCClassData: PExceptionDefCClassDataStructure;
begin
  if Assigned(SOMIR_DLL_ExceptionDefCClassData) then
    Result := SOMIR_DLL_ExceptionDefCClassData
  else
  begin
    SOMIR_DLL_Load_Variable(SOMIR_DLL_ExceptionDefCClassData, 'ExceptionDefCClassData');
    Result := SOMIR_DLL_ExceptionDefCClassData;
  end;
end;

(*
 * Class Object and Method Token Macros
 *)

(*
 * New Method: _get_type
 *)
type
  somTD_ExceptionDef__get_type = function(somSelf: SOMObjectBase{ExceptionDef}; ev: PEnvironment): TypeCode; stdcall;

function ExceptionDef._get_type: TypeCode; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PExceptionDefClassDataStructure;
  LocalEnv: Environment;
begin
  cd := ExceptionDefClassData;
  SOM_InitEnvironment(@LocalEnv);
  Result :=
  somTD_ExceptionDef__get_type
   (SOM_Resolve(Self, cd.classObject, cd._get_type))
     (Self, @LocalEnv);
  SOM_UninitEnvironmentOrRaise(@LocalEnv);
end;

(*
 * New Method: _set_type
 *)
type
  somTD_ExceptionDef__set_type = procedure(somSelf: SOMObjectBase{ExceptionDef}; ev: PEnvironment; SOM_type: {caller_owns} TypeCode); stdcall;

procedure ExceptionDef._set_type(SOM_type: {caller_owns} TypeCode); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PExceptionDefClassDataStructure;
  LocalEnv: Environment;
begin
  cd := ExceptionDefClassData;
  SOM_InitEnvironment(@LocalEnv);
  somTD_ExceptionDef__set_type
   (SOM_Resolve(Self, cd.classObject, cd._set_type))
     (Self, @LocalEnv, SOM_type);
  SOM_UninitEnvironmentOrRaise(@LocalEnv);
end;

function ExceptionDef._get_name: CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PContainedClassDataStructure;
  LocalEnv: Environment;
begin
  cd := ContainedClassData;
  SOM_InitEnvironment(@LocalEnv);
  Result :=
  somTD_Contained__get_name
   (SOM_Resolve(Self, cd.classObject, cd._get_name))
     (Self, @LocalEnv);
  SOM_UninitEnvironmentOrRaise(@LocalEnv);
end;

procedure ExceptionDef._set_name(name: {caller_owns} CORBAString); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PContainedClassDataStructure;
  LocalEnv: Environment;
begin
  cd := ContainedClassData;
  SOM_InitEnvironment(@LocalEnv);
  somTD_Contained__set_name
   (SOM_Resolve(Self, cd.classObject, cd._set_name))
     (Self, @LocalEnv, name);
  SOM_UninitEnvironmentOrRaise(@LocalEnv);
end;

function ExceptionDef._get_id: CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PContainedClassDataStructure;
  LocalEnv: Environment;
begin
  cd := ContainedClassData;
  SOM_InitEnvironment(@LocalEnv);
  Result :=
  somTD_Contained__get_id
   (SOM_Resolve(Self, cd.classObject, cd._get_id))
     (Self, @LocalEnv);
  SOM_UninitEnvironmentOrRaise(@LocalEnv);
end;

procedure ExceptionDef._set_id(id: {caller_owns} CORBAString); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PContainedClassDataStructure;
  LocalEnv: Environment;
begin
  cd := ContainedClassData;
  SOM_InitEnvironment(@LocalEnv);
  somTD_Contained__set_id
   (SOM_Resolve(Self, cd.classObject, cd._set_id))
     (Self, @LocalEnv, id);
  SOM_UninitEnvironmentOrRaise(@LocalEnv);
end;

function ExceptionDef._get_defined_in: CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PContainedClassDataStructure;
  LocalEnv: Environment;
begin
  cd := ContainedClassData;
  SOM_InitEnvironment(@LocalEnv);
  Result :=
  somTD_Contained__get_defined_in
   (SOM_Resolve(Self, cd.classObject, cd._get_defined_in))
     (Self, @LocalEnv);
  SOM_UninitEnvironmentOrRaise(@LocalEnv);
end;

procedure ExceptionDef._set_defined_in(defined_in: {caller_owns} CORBAString); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PContainedClassDataStructure;
  LocalEnv: Environment;
begin
  cd := ContainedClassData;
  SOM_InitEnvironment(@LocalEnv);
  somTD_Contained__set_defined_in
   (SOM_Resolve(Self, cd.classObject, cd._set_defined_in))
     (Self, @LocalEnv, defined_in);
  SOM_UninitEnvironmentOrRaise(@LocalEnv);
end;

function ExceptionDef._get_somModifiers: _IDL_Sequence_somModifier; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PContainedClassDataStructure;
  LocalEnv: Environment;
begin
  cd := ContainedClassData;
  SOM_InitEnvironment(@LocalEnv);
  Result :=
  somTD_Contained__get_somModifiers
   (SOM_Resolve(Self, cd.classObject, cd._get_somModifiers))
     (Self, @LocalEnv);
  SOM_UninitEnvironmentOrRaise(@LocalEnv);
end;

procedure ExceptionDef._set_somModifiers(const somModifiers: {caller_owns} _IDL_Sequence_somModifier); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PContainedClassDataStructure;
  LocalEnv: Environment;
begin
  cd := ContainedClassData;
  SOM_InitEnvironment(@LocalEnv);
  somTD_Contained__set_somModifiers
   (SOM_Resolve(Self, cd.classObject, cd._set_somModifiers))
     (Self, @LocalEnv, somModifiers);
  SOM_UninitEnvironmentOrRaise(@LocalEnv);
end;

class function ExceptionDef.Create: ExceptionDef; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
begin
  Result := ExceptionDef(SOMClass(NewClass).somNew);
end;

class function ExceptionDef.InitInstance(Instance: Pointer): ExceptionDef; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
begin
  Result := ExceptionDef(SOMClass(NewClass).somRenewNoInit(Instance));
end;

function ExceptionDef.ClassType: SOMClass; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
begin
  Result := SOMClass(SOMObject(Self).somGetClass);
end;

class function ExceptionDef.ClassName: string;
begin
  Result := AnsiString(SOMClass(NewClass).somGetName);
end;

class function ExceptionDef.ClassNameIs(const Name: string): Boolean;
begin
  Result := AnsiString(SOMClass(NewClass).somGetName) = Name;
end;

class function ExceptionDef.InstanceSize: LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
begin
  Result := SOMClass(NewClass).somGetInstanceSize;
end;

class function ExceptionDef.InheritsFrom(AClass: SOMClass): Boolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
begin
  Result := SOMClass(NewClass).somDescendedFrom(AClass);
end;

class function ExceptionDef.MethodAddress(const Name: string): Pointer;
var
  NameAsAnsiString: AnsiString;
  NameAsSomId: somId;
begin
  NameAsAnsiString := AnsiString(Name);
  NameAsSomId := somIdFromString(PAnsiChar(NameAsAnsiString));
  try
    SOMClass(NewClass).somFindMethod(NameAsSomId, Result);
  finally
    SOMMemFree(NameAsSomId);
  end;
end;

class function ExceptionDef.NewInstance: ExceptionDef; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
begin
  Result := ExceptionDef(SOMClass(NewClass).somNewNoInit);
end;

function ExceptionDef.Clone: ExceptionDef; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
begin
  Result := ExceptionDef(SOMClass(somGetClass).somNewNoInit);
  SOMObject(Result).somDefaultCopyInit(somInitCtrl(nil^), SOMObject(Self));
end;

function ExceptionDef.within: _IDL_Sequence_Container; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PContainedClassDataStructure;
  LocalEnv: Environment;
begin
  cd := ContainedClassData;
  SOM_InitEnvironment(@LocalEnv);
  Result :=
  somTD_Contained_within
   (SOM_Resolve(Self, cd.classObject, cd.within))
     (Self, @LocalEnv);
  SOM_UninitEnvironmentOrRaise(@LocalEnv);
end;

function ExceptionDef.describe: Contained_Description; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PContainedClassDataStructure;
  LocalEnv: Environment;
begin
  cd := ContainedClassData;
  SOM_InitEnvironment(@LocalEnv);
  Result :=
  somTD_Contained_describe
   (SOM_Resolve(Self, cd.classObject, cd.describe))
     (Self, @LocalEnv);
  SOM_UninitEnvironmentOrRaise(@LocalEnv);
end;

procedure ExceptionDef.somDefaultInit(var ctrl: Pointer); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somDefaultInit
   (SOM_Resolve(Self, cd.classObject, cd.somDefaultInit))
     (Self, ctrl);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

procedure ExceptionDef.somDestruct(doFree: Byte; var ctrl: Pointer); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somDestruct
   (SOM_Resolve(Self, cd.classObject, cd.somDestruct))
     (Self, doFree, ctrl);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

procedure ExceptionDef.somDefaultCopyInit(var ctrl: Pointer; fromObj: ExceptionDef); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somDefaultCopyInit
   (SOM_Resolve(Self, cd.classObject, cd.somDefaultCopyInit))
     (Self, ctrl, fromObj);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function ExceptionDef.somDefaultAssign(var ctrl: Pointer; fromObj: ExceptionDef): ExceptionDef; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result := ExceptionDef(
  somTD_SOMObject_somDefaultAssign
   (SOM_Resolve(Self, cd.classObject, cd.somDefaultAssign))
     (Self, ctrl, fromObj));
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

procedure ExceptionDef.somDefaultConstCopyInit(var ctrl: Pointer; fromObj: ExceptionDef); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somDefaultConstCopyInit
   (SOM_Resolve(Self, cd.classObject, cd.somDefaultConstCopyInit))
     (Self, ctrl, fromObj);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

procedure ExceptionDef.somDefaultVCopyInit(var ctrl: Pointer; fromObj: ExceptionDef); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somDefaultVCopyInit
   (SOM_Resolve(Self, cd.classObject, cd.somDefaultVCopyInit))
     (Self, ctrl, fromObj);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

procedure ExceptionDef.somDefaultConstVCopyInit(var ctrl: Pointer; fromObj: ExceptionDef); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somDefaultConstVCopyInit
   (SOM_Resolve(Self, cd.classObject, cd.somDefaultConstVCopyInit))
     (Self, ctrl, fromObj);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function ExceptionDef.somDefaultConstAssign(var ctrl: Pointer; fromObj: ExceptionDef): ExceptionDef; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result := ExceptionDef(
  somTD_SOMObject_somDefaultConstAssign
   (SOM_Resolve(Self, cd.classObject, cd.somDefaultConstAssign))
     (Self, ctrl, fromObj));
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function ExceptionDef.somDefaultVAssign(var ctrl: Pointer; fromObj: ExceptionDef): ExceptionDef; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result := ExceptionDef(
  somTD_SOMObject_somDefaultVAssign
   (SOM_Resolve(Self, cd.classObject, cd.somDefaultVAssign))
     (Self, ctrl, fromObj));
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function ExceptionDef.somDefaultConstVAssign(var ctrl: Pointer; fromObj: ExceptionDef): ExceptionDef; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result := ExceptionDef(
  somTD_SOMObject_somDefaultConstVAssign
   (SOM_Resolve(Self, cd.classObject, cd.somDefaultConstVAssign))
     (Self, ctrl, fromObj));
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

procedure ExceptionDef.somInit; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somInit
   (SOM_Resolve(Self, cd.classObject, cd.somInit))
     (Self);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

procedure ExceptionDef.somFree; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somFree
   (SOM_Resolve(Self, cd.classObject, cd.somFree))
     (Self);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

procedure ExceptionDef.somUninit; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somUninit
   (SOM_Resolve(Self, cd.classObject, cd.somUninit))
     (Self);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function ExceptionDef.somGetClass: SOMClass; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result := SOMClass(
  somTD_SOMObject_somGetClass
   (SOM_Resolve(Self, cd.classObject, cd.somGetClass))
     (Self));
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function ExceptionDef.somGetClassName: {dual_owned} CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result :=
  somTD_SOMObject_somGetClassName
   (SOM_Resolve(Self, cd.classObject, cd.somGetClassName))
     (Self);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function ExceptionDef.somGetSize: LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result :=
  somTD_SOMObject_somGetSize
   (SOM_Resolve(Self, cd.classObject, cd.somGetSize))
     (Self);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function ExceptionDef.somIsA(aClassObj: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result :=
  somTD_SOMObject_somIsA
   (SOM_Resolve(Self, cd.classObject, cd.somIsA))
     (Self, aClassObj);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function ExceptionDef.somIsInstanceOf(aClassObj: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result :=
  somTD_SOMObject_somIsInstanceOf
   (SOM_Resolve(Self, cd.classObject, cd.somIsInstanceOf))
     (Self, aClassObj);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function ExceptionDef.somRespondsTo(mId: somId): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result :=
  somTD_SOMObject_somRespondsTo
   (SOM_Resolve(Self, cd.classObject, cd.somRespondsTo))
     (Self, mId);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function ExceptionDef.somDispatch(out retValue: Pointer; methodId: somId; ap: va_list): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result :=
  somTD_SOMObject_somDispatch
   (SOM_Resolve(Self, cd.classObject, cd.somDispatch))
     (Self, retValue, methodId, ap);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function ExceptionDef.somClassDispatch(clsObj: SOMClass; out retValue: Pointer; methodId: somId; ap: va_list): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result :=
  somTD_SOMObject_somClassDispatch
   (SOM_Resolve(Self, cd.classObject, cd.somClassDispatch))
     (Self, clsObj, retValue, methodId, ap);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function ExceptionDef.somCastObj(cls: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result :=
  somTD_SOMObject_somCastObj
   (SOM_Resolve(Self, cd.classObject, cd.somCastObj))
     (Self, cls);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function ExceptionDef.somResetObj: CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result :=
  somTD_SOMObject_somResetObj
   (SOM_Resolve(Self, cd.classObject, cd.somResetObj))
     (Self);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function ExceptionDef.somPrintSelf: ExceptionDef; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result := ExceptionDef(
  somTD_SOMObject_somPrintSelf
   (SOM_Resolve(Self, cd.classObject, cd.somPrintSelf))
     (Self));
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

procedure ExceptionDef.somDumpSelf(level: LongInt); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somDumpSelf
   (SOM_Resolve(Self, cd.classObject, cd.somDumpSelf))
     (Self, level);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

procedure ExceptionDef.somDumpSelfInt(level: LongInt); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somDumpSelfInt
   (SOM_Resolve(Self, cd.classObject, cd.somDumpSelfInt))
     (Self, level);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

class function ExceptionDef.ClassObject: SOMClass; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
begin
  if Self = ExceptionDef then { invoked on class name literal }
  begin
    Result := SOMClass(ExceptionDefClassData.classObject);
  end
  else { invoked on SOM object }
  begin
    Result := SOMClass(PPointer(Self)^);
  end
end;

class function ExceptionDef.NewClass: SOMClass;
begin
  if Self = ExceptionDef then { invoked on class name literal }
  begin
    Result := SOMClass(ExceptionDefClassData.classObject);
    if not Assigned(Result) then Result := SOMClass(ExceptionDefNewClass);
  end
  else { invoked on SOM object }
  begin
    Result := SOMClass(PPointer(Self)^);
  end
end;

function ExceptionDef.As_Contained: Contained; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
begin
  Result := Contained(Self);
end;

function ExceptionDef.As_ExceptionDef: ExceptionDef; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
begin
  Result := Self;
end;

class function ExceptionDef.Supports(Instance: SOMObjectBase): Boolean;
var
  cls: SOMClass;
begin
  if not Assigned(Instance) then
  begin
    Result := False;
  end
  else
  begin
    cls := SOMClass(ClassObject);
    if not Assigned(cls) then
    begin
      Result := False;
    end
    else
    begin
      Result := SOMObject(Instance).somIsA(cls);
    end;
  end;
end;

class function ExceptionDef.Supports(Instance: SOMObjectBase; out Obj: ExceptionDef): Boolean;
var
  cls: SOMClass;
begin
  if not Assigned(Instance) then
  begin
    Result := False;
    Obj := nil;
  end
  else
  begin
    cls := SOMClass(ClassObject);
    if not Assigned(cls) then
    begin
      Result := False;
      Obj := nil;
    end
    else if SOMObject(Instance).somIsA(cls) then
    begin
      Result := True;
      Obj := ExceptionDef(Instance);
    end
    else
    begin
      Result := False;
      Obj := nil;
    end;
  end;
end;

const
  ImplementationDef_MajorVersion = 2;
  ImplementationDef_MinorVersion = 1;

(*
 * Declare the class creation procedure
 *)
function ImplementationDefNewClass(
  somtmajorVersion: integer4 = ImplementationDef_MajorVersion;
  somtminorVersion: integer4 = ImplementationDef_MinorVersion):
  SOMClass; stdcall; external SOMD_DLL_Name name 'ImplementationDefNewClass';

(*
 * Declare the ABI 2 ClassData structure
 *)
type
  ImplementationDefClassDataStructure = packed record
    classObject: SOMClass;
    _set_impl_id,
    _get_impl_id,
    _set_impl_alias,
    _get_impl_alias,
    _set_impl_program,
    _get_impl_program,
    _set_impl_flags,
    _get_impl_flags,
    _set_impl_server_class,
    _get_impl_server_class,
    _set_impl_socket_class,
    _get_impl_socket_class,
    _set_impl_refdata_file,
    _get_impl_refdata_file,
    _set_impl_refdata_bkup,
    _get_impl_refdata_bkup,
    _set_impl_hostname,
    _get_impl_hostname,
    _set_impl_def_struct,
    _get_impl_def_struct,
    get_impl_winserver_handle: somMToken;
  end;
  PImplementationDefClassDataStructure = ^ImplementationDefClassDataStructure;

var
  SOMD_DLL_ImplementationDefClassData: PImplementationDefClassDataStructure = nil;

function ImplementationDefClassData: PImplementationDefClassDataStructure;
begin
  if Assigned(SOMD_DLL_ImplementationDefClassData) then
    Result := SOMD_DLL_ImplementationDefClassData
  else
  begin
    SOMD_DLL_Load_Variable(SOMD_DLL_ImplementationDefClassData, 'ImplementationDefClassData');
    Result := SOMD_DLL_ImplementationDefClassData;
  end;
end;

(*
 * Declare the ABI 2 CClassData structure
 *)
type
  ImplementationDefCClassDataStructure = packed record
    parentMtab: somMethodTabs;
    instanceDataToken: somDToken;
  end;
  PImplementationDefCClassDataStructure = ^ImplementationDefCClassDataStructure;

var
  SOMD_DLL_ImplementationDefCClassData: PImplementationDefCClassDataStructure = nil;

function ImplementationDefCClassData: PImplementationDefCClassDataStructure;
begin
  if Assigned(SOMD_DLL_ImplementationDefCClassData) then
    Result := SOMD_DLL_ImplementationDefCClassData
  else
  begin
    SOMD_DLL_Load_Variable(SOMD_DLL_ImplementationDefCClassData, 'ImplementationDefCClassData');
    Result := SOMD_DLL_ImplementationDefCClassData;
  end;
end;

(*
 * Class Object and Method Token Macros
 *)

(*
 * New Method: _get_impl_id
 *)
type
  somTD_ImplementationDef__get_impl_id = function(somSelf: SOMObjectBase{ImplementationDef}; ev: PEnvironment): CORBAString; stdcall;

function ImplementationDef._get_impl_id: CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PImplementationDefClassDataStructure;
  LocalEnv: Environment;
begin
  cd := ImplementationDefClassData;
  SOM_InitEnvironment(@LocalEnv);
  Result :=
  somTD_ImplementationDef__get_impl_id
   (SOM_Resolve(Self, cd.classObject, cd._get_impl_id))
     (Self, @LocalEnv);
  SOM_UninitEnvironmentOrRaise(@LocalEnv);
end;

(*
 * New Method: _set_impl_id
 *)
type
  somTD_ImplementationDef__set_impl_id = procedure(somSelf: SOMObjectBase{ImplementationDef}; ev: PEnvironment; impl_id: CORBAString); stdcall;

procedure ImplementationDef._set_impl_id(impl_id: CORBAString); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PImplementationDefClassDataStructure;
  LocalEnv: Environment;
begin
  cd := ImplementationDefClassData;
  SOM_InitEnvironment(@LocalEnv);
  somTD_ImplementationDef__set_impl_id
   (SOM_Resolve(Self, cd.classObject, cd._set_impl_id))
     (Self, @LocalEnv, impl_id);
  SOM_UninitEnvironmentOrRaise(@LocalEnv);
end;

(*
 * New Method: _get_impl_alias
 *)
type
  somTD_ImplementationDef__get_impl_alias = function(somSelf: SOMObjectBase{ImplementationDef}; ev: PEnvironment): CORBAString; stdcall;

function ImplementationDef._get_impl_alias: CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PImplementationDefClassDataStructure;
  LocalEnv: Environment;
begin
  cd := ImplementationDefClassData;
  SOM_InitEnvironment(@LocalEnv);
  Result :=
  somTD_ImplementationDef__get_impl_alias
   (SOM_Resolve(Self, cd.classObject, cd._get_impl_alias))
     (Self, @LocalEnv);
  SOM_UninitEnvironmentOrRaise(@LocalEnv);
end;

(*
 * New Method: _set_impl_alias
 *)
type
  somTD_ImplementationDef__set_impl_alias = procedure(somSelf: SOMObjectBase{ImplementationDef}; ev: PEnvironment; impl_alias: CORBAString); stdcall;

procedure ImplementationDef._set_impl_alias(impl_alias: CORBAString); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PImplementationDefClassDataStructure;
  LocalEnv: Environment;
begin
  cd := ImplementationDefClassData;
  SOM_InitEnvironment(@LocalEnv);
  somTD_ImplementationDef__set_impl_alias
   (SOM_Resolve(Self, cd.classObject, cd._set_impl_alias))
     (Self, @LocalEnv, impl_alias);
  SOM_UninitEnvironmentOrRaise(@LocalEnv);
end;

(*
 * New Method: _get_impl_program
 *)
type
  somTD_ImplementationDef__get_impl_program = function(somSelf: SOMObjectBase{ImplementationDef}; ev: PEnvironment): CORBAString; stdcall;

function ImplementationDef._get_impl_program: CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PImplementationDefClassDataStructure;
  LocalEnv: Environment;
begin
  cd := ImplementationDefClassData;
  SOM_InitEnvironment(@LocalEnv);
  Result :=
  somTD_ImplementationDef__get_impl_program
   (SOM_Resolve(Self, cd.classObject, cd._get_impl_program))
     (Self, @LocalEnv);
  SOM_UninitEnvironmentOrRaise(@LocalEnv);
end;

(*
 * New Method: _set_impl_program
 *)
type
  somTD_ImplementationDef__set_impl_program = procedure(somSelf: SOMObjectBase{ImplementationDef}; ev: PEnvironment; impl_program: CORBAString); stdcall;

procedure ImplementationDef._set_impl_program(impl_program: CORBAString); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PImplementationDefClassDataStructure;
  LocalEnv: Environment;
begin
  cd := ImplementationDefClassData;
  SOM_InitEnvironment(@LocalEnv);
  somTD_ImplementationDef__set_impl_program
   (SOM_Resolve(Self, cd.classObject, cd._set_impl_program))
     (Self, @LocalEnv, impl_program);
  SOM_UninitEnvironmentOrRaise(@LocalEnv);
end;

(*
 * New Method: _get_impl_flags
 *)
type
  somTD_ImplementationDef__get_impl_flags = function(somSelf: SOMObjectBase{ImplementationDef}; ev: PEnvironment): LongWord; stdcall;

function ImplementationDef._get_impl_flags: LongWord; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PImplementationDefClassDataStructure;
  LocalEnv: Environment;
begin
  cd := ImplementationDefClassData;
  SOM_InitEnvironment(@LocalEnv);
  Result :=
  somTD_ImplementationDef__get_impl_flags
   (SOM_Resolve(Self, cd.classObject, cd._get_impl_flags))
     (Self, @LocalEnv);
  SOM_UninitEnvironmentOrRaise(@LocalEnv);
end;

(*
 * New Method: _set_impl_flags
 *)
type
  somTD_ImplementationDef__set_impl_flags = procedure(somSelf: SOMObjectBase{ImplementationDef}; ev: PEnvironment; impl_flags: LongWord); stdcall;

procedure ImplementationDef._set_impl_flags(impl_flags: LongWord); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PImplementationDefClassDataStructure;
  LocalEnv: Environment;
begin
  cd := ImplementationDefClassData;
  SOM_InitEnvironment(@LocalEnv);
  somTD_ImplementationDef__set_impl_flags
   (SOM_Resolve(Self, cd.classObject, cd._set_impl_flags))
     (Self, @LocalEnv, impl_flags);
  SOM_UninitEnvironmentOrRaise(@LocalEnv);
end;

(*
 * New Method: _get_impl_server_class
 *)
type
  somTD_ImplementationDef__get_impl_server_class = function(somSelf: SOMObjectBase{ImplementationDef}; ev: PEnvironment): CORBAString; stdcall;

function ImplementationDef._get_impl_server_class: CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PImplementationDefClassDataStructure;
  LocalEnv: Environment;
begin
  cd := ImplementationDefClassData;
  SOM_InitEnvironment(@LocalEnv);
  Result :=
  somTD_ImplementationDef__get_impl_server_class
   (SOM_Resolve(Self, cd.classObject, cd._get_impl_server_class))
     (Self, @LocalEnv);
  SOM_UninitEnvironmentOrRaise(@LocalEnv);
end;

(*
 * New Method: _set_impl_server_class
 *)
type
  somTD_ImplementationDef__set_impl_server_class = procedure(somSelf: SOMObjectBase{ImplementationDef}; ev: PEnvironment; impl_server_class: CORBAString); stdcall;

procedure ImplementationDef._set_impl_server_class(impl_server_class: CORBAString); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PImplementationDefClassDataStructure;
  LocalEnv: Environment;
begin
  cd := ImplementationDefClassData;
  SOM_InitEnvironment(@LocalEnv);
  somTD_ImplementationDef__set_impl_server_class
   (SOM_Resolve(Self, cd.classObject, cd._set_impl_server_class))
     (Self, @LocalEnv, impl_server_class);
  SOM_UninitEnvironmentOrRaise(@LocalEnv);
end;

(*
 * New Method: _get_impl_refdata_file
 *)
type
  somTD_ImplementationDef__get_impl_refdata_file = function(somSelf: SOMObjectBase{ImplementationDef}; ev: PEnvironment): CORBAString; stdcall;

function ImplementationDef._get_impl_refdata_file: CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PImplementationDefClassDataStructure;
  LocalEnv: Environment;
begin
  cd := ImplementationDefClassData;
  SOM_InitEnvironment(@LocalEnv);
  Result :=
  somTD_ImplementationDef__get_impl_refdata_file
   (SOM_Resolve(Self, cd.classObject, cd._get_impl_refdata_file))
     (Self, @LocalEnv);
  SOM_UninitEnvironmentOrRaise(@LocalEnv);
end;

(*
 * New Method: _set_impl_refdata_file
 *)
type
  somTD_ImplementationDef__set_impl_refdata_file = procedure(somSelf: SOMObjectBase{ImplementationDef}; ev: PEnvironment; impl_refdata_file: CORBAString); stdcall;

procedure ImplementationDef._set_impl_refdata_file(impl_refdata_file: CORBAString); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PImplementationDefClassDataStructure;
  LocalEnv: Environment;
begin
  cd := ImplementationDefClassData;
  SOM_InitEnvironment(@LocalEnv);
  somTD_ImplementationDef__set_impl_refdata_file
   (SOM_Resolve(Self, cd.classObject, cd._set_impl_refdata_file))
     (Self, @LocalEnv, impl_refdata_file);
  SOM_UninitEnvironmentOrRaise(@LocalEnv);
end;

(*
 * New Method: _get_impl_refdata_bkup
 *)
type
  somTD_ImplementationDef__get_impl_refdata_bkup = function(somSelf: SOMObjectBase{ImplementationDef}; ev: PEnvironment): CORBAString; stdcall;

function ImplementationDef._get_impl_refdata_bkup: CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PImplementationDefClassDataStructure;
  LocalEnv: Environment;
begin
  cd := ImplementationDefClassData;
  SOM_InitEnvironment(@LocalEnv);
  Result :=
  somTD_ImplementationDef__get_impl_refdata_bkup
   (SOM_Resolve(Self, cd.classObject, cd._get_impl_refdata_bkup))
     (Self, @LocalEnv);
  SOM_UninitEnvironmentOrRaise(@LocalEnv);
end;

(*
 * New Method: _set_impl_refdata_bkup
 *)
type
  somTD_ImplementationDef__set_impl_refdata_bkup = procedure(somSelf: SOMObjectBase{ImplementationDef}; ev: PEnvironment; impl_refdata_bkup: CORBAString); stdcall;

procedure ImplementationDef._set_impl_refdata_bkup(impl_refdata_bkup: CORBAString); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PImplementationDefClassDataStructure;
  LocalEnv: Environment;
begin
  cd := ImplementationDefClassData;
  SOM_InitEnvironment(@LocalEnv);
  somTD_ImplementationDef__set_impl_refdata_bkup
   (SOM_Resolve(Self, cd.classObject, cd._set_impl_refdata_bkup))
     (Self, @LocalEnv, impl_refdata_bkup);
  SOM_UninitEnvironmentOrRaise(@LocalEnv);
end;

(*
 * New Method: _get_impl_hostname
 *)
type
  somTD_ImplementationDef__get_impl_hostname = function(somSelf: SOMObjectBase{ImplementationDef}; ev: PEnvironment): CORBAString; stdcall;

function ImplementationDef._get_impl_hostname: CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PImplementationDefClassDataStructure;
  LocalEnv: Environment;
begin
  cd := ImplementationDefClassData;
  SOM_InitEnvironment(@LocalEnv);
  Result :=
  somTD_ImplementationDef__get_impl_hostname
   (SOM_Resolve(Self, cd.classObject, cd._get_impl_hostname))
     (Self, @LocalEnv);
  SOM_UninitEnvironmentOrRaise(@LocalEnv);
end;

(*
 * New Method: _set_impl_hostname
 *)
type
  somTD_ImplementationDef__set_impl_hostname = procedure(somSelf: SOMObjectBase{ImplementationDef}; ev: PEnvironment; impl_hostname: CORBAString); stdcall;

procedure ImplementationDef._set_impl_hostname(impl_hostname: CORBAString); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PImplementationDefClassDataStructure;
  LocalEnv: Environment;
begin
  cd := ImplementationDefClassData;
  SOM_InitEnvironment(@LocalEnv);
  somTD_ImplementationDef__set_impl_hostname
   (SOM_Resolve(Self, cd.classObject, cd._set_impl_hostname))
     (Self, @LocalEnv, impl_hostname);
  SOM_UninitEnvironmentOrRaise(@LocalEnv);
end;

class function ImplementationDef.Create: ImplementationDef; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
begin
  Result := ImplementationDef(SOMClass(NewClass).somNew);
end;

class function ImplementationDef.InitInstance(Instance: Pointer): ImplementationDef; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
begin
  Result := ImplementationDef(SOMClass(NewClass).somRenewNoInit(Instance));
end;

function ImplementationDef.ClassType: SOMClass; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
begin
  Result := SOMClass(SOMObject(Self).somGetClass);
end;

class function ImplementationDef.ClassName: string;
begin
  Result := AnsiString(SOMClass(NewClass).somGetName);
end;

class function ImplementationDef.ClassNameIs(const Name: string): Boolean;
begin
  Result := AnsiString(SOMClass(NewClass).somGetName) = Name;
end;

class function ImplementationDef.InstanceSize: LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
begin
  Result := SOMClass(NewClass).somGetInstanceSize;
end;

class function ImplementationDef.InheritsFrom(AClass: SOMClass): Boolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
begin
  Result := SOMClass(NewClass).somDescendedFrom(AClass);
end;

class function ImplementationDef.MethodAddress(const Name: string): Pointer;
var
  NameAsAnsiString: AnsiString;
  NameAsSomId: somId;
begin
  NameAsAnsiString := AnsiString(Name);
  NameAsSomId := somIdFromString(PAnsiChar(NameAsAnsiString));
  try
    SOMClass(NewClass).somFindMethod(NameAsSomId, Result);
  finally
    SOMMemFree(NameAsSomId);
  end;
end;

class function ImplementationDef.NewInstance: ImplementationDef; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
begin
  Result := ImplementationDef(SOMClass(NewClass).somNewNoInit);
end;

function ImplementationDef.Clone: ImplementationDef; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
begin
  Result := ImplementationDef(SOMClass(somGetClass).somNewNoInit);
  SOMObject(Result).somDefaultCopyInit(somInitCtrl(nil^), SOMObject(Self));
end;

procedure ImplementationDef.somDefaultInit(var ctrl: Pointer); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somDefaultInit
   (SOM_Resolve(Self, cd.classObject, cd.somDefaultInit))
     (Self, ctrl);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

procedure ImplementationDef.somDestruct(doFree: Byte; var ctrl: Pointer); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somDestruct
   (SOM_Resolve(Self, cd.classObject, cd.somDestruct))
     (Self, doFree, ctrl);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

procedure ImplementationDef.somDefaultCopyInit(var ctrl: Pointer; fromObj: ImplementationDef); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somDefaultCopyInit
   (SOM_Resolve(Self, cd.classObject, cd.somDefaultCopyInit))
     (Self, ctrl, fromObj);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function ImplementationDef.somDefaultAssign(var ctrl: Pointer; fromObj: ImplementationDef): ImplementationDef; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result := ImplementationDef(
  somTD_SOMObject_somDefaultAssign
   (SOM_Resolve(Self, cd.classObject, cd.somDefaultAssign))
     (Self, ctrl, fromObj));
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

procedure ImplementationDef.somDefaultConstCopyInit(var ctrl: Pointer; fromObj: ImplementationDef); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somDefaultConstCopyInit
   (SOM_Resolve(Self, cd.classObject, cd.somDefaultConstCopyInit))
     (Self, ctrl, fromObj);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

procedure ImplementationDef.somDefaultVCopyInit(var ctrl: Pointer; fromObj: ImplementationDef); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somDefaultVCopyInit
   (SOM_Resolve(Self, cd.classObject, cd.somDefaultVCopyInit))
     (Self, ctrl, fromObj);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

procedure ImplementationDef.somDefaultConstVCopyInit(var ctrl: Pointer; fromObj: ImplementationDef); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somDefaultConstVCopyInit
   (SOM_Resolve(Self, cd.classObject, cd.somDefaultConstVCopyInit))
     (Self, ctrl, fromObj);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function ImplementationDef.somDefaultConstAssign(var ctrl: Pointer; fromObj: ImplementationDef): ImplementationDef; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result := ImplementationDef(
  somTD_SOMObject_somDefaultConstAssign
   (SOM_Resolve(Self, cd.classObject, cd.somDefaultConstAssign))
     (Self, ctrl, fromObj));
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function ImplementationDef.somDefaultVAssign(var ctrl: Pointer; fromObj: ImplementationDef): ImplementationDef; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result := ImplementationDef(
  somTD_SOMObject_somDefaultVAssign
   (SOM_Resolve(Self, cd.classObject, cd.somDefaultVAssign))
     (Self, ctrl, fromObj));
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function ImplementationDef.somDefaultConstVAssign(var ctrl: Pointer; fromObj: ImplementationDef): ImplementationDef; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result := ImplementationDef(
  somTD_SOMObject_somDefaultConstVAssign
   (SOM_Resolve(Self, cd.classObject, cd.somDefaultConstVAssign))
     (Self, ctrl, fromObj));
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

procedure ImplementationDef.somInit; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somInit
   (SOM_Resolve(Self, cd.classObject, cd.somInit))
     (Self);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

procedure ImplementationDef.somFree; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somFree
   (SOM_Resolve(Self, cd.classObject, cd.somFree))
     (Self);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

procedure ImplementationDef.somUninit; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somUninit
   (SOM_Resolve(Self, cd.classObject, cd.somUninit))
     (Self);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function ImplementationDef.somGetClass: SOMClass; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result := SOMClass(
  somTD_SOMObject_somGetClass
   (SOM_Resolve(Self, cd.classObject, cd.somGetClass))
     (Self));
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function ImplementationDef.somGetClassName: {dual_owned} CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result :=
  somTD_SOMObject_somGetClassName
   (SOM_Resolve(Self, cd.classObject, cd.somGetClassName))
     (Self);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function ImplementationDef.somGetSize: LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result :=
  somTD_SOMObject_somGetSize
   (SOM_Resolve(Self, cd.classObject, cd.somGetSize))
     (Self);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function ImplementationDef.somIsA(aClassObj: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result :=
  somTD_SOMObject_somIsA
   (SOM_Resolve(Self, cd.classObject, cd.somIsA))
     (Self, aClassObj);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function ImplementationDef.somIsInstanceOf(aClassObj: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result :=
  somTD_SOMObject_somIsInstanceOf
   (SOM_Resolve(Self, cd.classObject, cd.somIsInstanceOf))
     (Self, aClassObj);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function ImplementationDef.somRespondsTo(mId: somId): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result :=
  somTD_SOMObject_somRespondsTo
   (SOM_Resolve(Self, cd.classObject, cd.somRespondsTo))
     (Self, mId);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function ImplementationDef.somDispatch(out retValue: Pointer; methodId: somId; ap: va_list): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result :=
  somTD_SOMObject_somDispatch
   (SOM_Resolve(Self, cd.classObject, cd.somDispatch))
     (Self, retValue, methodId, ap);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function ImplementationDef.somClassDispatch(clsObj: SOMClass; out retValue: Pointer; methodId: somId; ap: va_list): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result :=
  somTD_SOMObject_somClassDispatch
   (SOM_Resolve(Self, cd.classObject, cd.somClassDispatch))
     (Self, clsObj, retValue, methodId, ap);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function ImplementationDef.somCastObj(cls: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result :=
  somTD_SOMObject_somCastObj
   (SOM_Resolve(Self, cd.classObject, cd.somCastObj))
     (Self, cls);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function ImplementationDef.somResetObj: CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result :=
  somTD_SOMObject_somResetObj
   (SOM_Resolve(Self, cd.classObject, cd.somResetObj))
     (Self);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function ImplementationDef.somPrintSelf: ImplementationDef; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result := ImplementationDef(
  somTD_SOMObject_somPrintSelf
   (SOM_Resolve(Self, cd.classObject, cd.somPrintSelf))
     (Self));
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

procedure ImplementationDef.somDumpSelf(level: LongInt); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somDumpSelf
   (SOM_Resolve(Self, cd.classObject, cd.somDumpSelf))
     (Self, level);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

procedure ImplementationDef.somDumpSelfInt(level: LongInt); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somDumpSelfInt
   (SOM_Resolve(Self, cd.classObject, cd.somDumpSelfInt))
     (Self, level);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

class function ImplementationDef.ClassObject: SOMClass; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
begin
  if Self = ImplementationDef then { invoked on class name literal }
  begin
    Result := SOMClass(ImplementationDefClassData.classObject);
  end
  else { invoked on SOM object }
  begin
    Result := SOMClass(PPointer(Self)^);
  end
end;

class function ImplementationDef.NewClass: SOMClass;
begin
  if Self = ImplementationDef then { invoked on class name literal }
  begin
    Result := SOMClass(ImplementationDefClassData.classObject);
    if not Assigned(Result) then Result := SOMClass(ImplementationDefNewClass);
  end
  else { invoked on SOM object }
  begin
    Result := SOMClass(PPointer(Self)^);
  end
end;

function ImplementationDef.As_ImplementationDef: ImplementationDef; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
begin
  Result := Self;
end;

class function ImplementationDef.Supports(Instance: SOMObjectBase): Boolean;
var
  cls: SOMClass;
begin
  if not Assigned(Instance) then
  begin
    Result := False;
  end
  else
  begin
    cls := SOMClass(ClassObject);
    if not Assigned(cls) then
    begin
      Result := False;
    end
    else
    begin
      Result := SOMObject(Instance).somIsA(cls);
    end;
  end;
end;

class function ImplementationDef.Supports(Instance: SOMObjectBase; out Obj: ImplementationDef): Boolean;
var
  cls: SOMClass;
begin
  if not Assigned(Instance) then
  begin
    Result := False;
    Obj := nil;
  end
  else
  begin
    cls := SOMClass(ClassObject);
    if not Assigned(cls) then
    begin
      Result := False;
      Obj := nil;
    end
    else if SOMObject(Instance).somIsA(cls) then
    begin
      Result := True;
      Obj := ImplementationDef(Instance);
    end
    else
    begin
      Result := False;
      Obj := nil;
    end;
  end;
end;

const
  ImplRepository_MajorVersion = 2;
  ImplRepository_MinorVersion = 1;

(*
 * Declare the class creation procedure
 *)
function ImplRepositoryNewClass(
  somtmajorVersion: integer4 = ImplRepository_MajorVersion;
  somtminorVersion: integer4 = ImplRepository_MinorVersion):
  SOMClass; stdcall; external SOMD_DLL_Name name 'ImplRepositoryNewClass';

(*
 * Declare the ABI 2 ClassData structure
 *)
type
  ImplRepositoryClassDataStructure = packed record
    classObject: SOMClass;
    find_impldef,
    find_impldef_by_alias,
    find_impldef2,
    find_impldef_by_alias2,
    find_impldef_by_class,
    add_impldef,
    update_impldef,
    delete_impldef,
    add_class_to_impldef,
    remove_class_from_impldef,
    remove_class_from_all,
    find_classes_by_impldef,
    implr_get_impl,
    implr_search_impl,
    implr_search_class,
    implr_update_impl,
    find_all_impldefs: somMToken;
  end;
  PImplRepositoryClassDataStructure = ^ImplRepositoryClassDataStructure;

var
  SOMD_DLL_ImplRepositoryClassData: PImplRepositoryClassDataStructure = nil;

function ImplRepositoryClassData: PImplRepositoryClassDataStructure;
begin
  if Assigned(SOMD_DLL_ImplRepositoryClassData) then
    Result := SOMD_DLL_ImplRepositoryClassData
  else
  begin
    SOMD_DLL_Load_Variable(SOMD_DLL_ImplRepositoryClassData, 'ImplRepositoryClassData');
    Result := SOMD_DLL_ImplRepositoryClassData;
  end;
end;

(*
 * Declare the ABI 2 CClassData structure
 *)
type
  ImplRepositoryCClassDataStructure = packed record
    parentMtab: somMethodTabs;
    instanceDataToken: somDToken;
  end;
  PImplRepositoryCClassDataStructure = ^ImplRepositoryCClassDataStructure;

var
  SOMD_DLL_ImplRepositoryCClassData: PImplRepositoryCClassDataStructure = nil;

function ImplRepositoryCClassData: PImplRepositoryCClassDataStructure;
begin
  if Assigned(SOMD_DLL_ImplRepositoryCClassData) then
    Result := SOMD_DLL_ImplRepositoryCClassData
  else
  begin
    SOMD_DLL_Load_Variable(SOMD_DLL_ImplRepositoryCClassData, 'ImplRepositoryCClassData');
    Result := SOMD_DLL_ImplRepositoryCClassData;
  end;
end;

(*
 * Class Object and Method Token Macros
 *)

class function ImplRepository.Create: ImplRepository; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
begin
  Result := ImplRepository(SOMClass(NewClass).somNew);
end;

class function ImplRepository.InitInstance(Instance: Pointer): ImplRepository; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
begin
  Result := ImplRepository(SOMClass(NewClass).somRenewNoInit(Instance));
end;

function ImplRepository.ClassType: SOMMSingleInstance; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
begin
  Result := SOMMSingleInstance(SOMObject(Self).somGetClass);
end;

class function ImplRepository.ClassName: string;
begin
  Result := AnsiString(SOMClass(NewClass).somGetName);
end;

class function ImplRepository.ClassNameIs(const Name: string): Boolean;
begin
  Result := AnsiString(SOMClass(NewClass).somGetName) = Name;
end;

class function ImplRepository.InstanceSize: LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
begin
  Result := SOMClass(NewClass).somGetInstanceSize;
end;

class function ImplRepository.InheritsFrom(AClass: SOMClass): Boolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
begin
  Result := SOMClass(NewClass).somDescendedFrom(AClass);
end;

class function ImplRepository.MethodAddress(const Name: string): Pointer;
var
  NameAsAnsiString: AnsiString;
  NameAsSomId: somId;
begin
  NameAsAnsiString := AnsiString(Name);
  NameAsSomId := somIdFromString(PAnsiChar(NameAsAnsiString));
  try
    SOMClass(NewClass).somFindMethod(NameAsSomId, Result);
  finally
    SOMMemFree(NameAsSomId);
  end;
end;

class function ImplRepository.NewInstance: ImplRepository; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
begin
  Result := ImplRepository(SOMClass(NewClass).somNewNoInit);
end;

function ImplRepository.Clone: ImplRepository; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
begin
  Result := ImplRepository(SOMClass(somGetClass).somNewNoInit);
  SOMObject(Result).somDefaultCopyInit(somInitCtrl(nil^), SOMObject(Self));
end;

(*
 * New Method: find_impldef
 *)
type
  somTD_ImplRepository_find_impldef = function(somSelf: SOMObjectBase{ImplRepository}; ev: PEnvironment; implid: CORBAString): ImplementationDef; stdcall;

function ImplRepository.find_impldef(implid: CORBAString): ImplementationDef; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PImplRepositoryClassDataStructure;
  LocalEnv: Environment;
begin
  cd := ImplRepositoryClassData;
  SOM_InitEnvironment(@LocalEnv);
  Result :=
  somTD_ImplRepository_find_impldef
   (SOM_Resolve(Self, cd.classObject, cd.find_impldef))
     (Self, @LocalEnv, implid);
  SOM_UninitEnvironmentOrRaise(@LocalEnv);
end;

(*
 * New Method: find_impldef_by_alias
 *)
type
  somTD_ImplRepository_find_impldef_by_alias = function(somSelf: SOMObjectBase{ImplRepository}; ev: PEnvironment; alias_name: CORBAString): ImplementationDef; stdcall;

function ImplRepository.find_impldef_by_alias(alias_name: CORBAString): ImplementationDef; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PImplRepositoryClassDataStructure;
  LocalEnv: Environment;
begin
  cd := ImplRepositoryClassData;
  SOM_InitEnvironment(@LocalEnv);
  Result :=
  somTD_ImplRepository_find_impldef_by_alias
   (SOM_Resolve(Self, cd.classObject, cd.find_impldef_by_alias))
     (Self, @LocalEnv, alias_name);
  SOM_UninitEnvironmentOrRaise(@LocalEnv);
end;

(*
 * New Method: find_all_impldefs
 *)
type
  somTD_ImplRepository_find_all_impldefs = function(somSelf: SOMObjectBase{ImplRepository}; ev: PEnvironment; out outimpldefs: _IDL_Sequence_ImplementationDef): LongWord; stdcall;

function ImplRepository.find_all_impldefs(out outimpldefs: _IDL_Sequence_ImplementationDef): LongWord; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PImplRepositoryClassDataStructure;
  LocalEnv: Environment;
begin
  cd := ImplRepositoryClassData;
  SOM_InitEnvironment(@LocalEnv);
  Result :=
  somTD_ImplRepository_find_all_impldefs
   (SOM_Resolve(Self, cd.classObject, cd.find_all_impldefs))
     (Self, @LocalEnv, outimpldefs);
  SOM_UninitEnvironmentOrRaise(@LocalEnv);
end;

(*
 * New Method: find_impldef_by_class
 *)
type
  somTD_ImplRepository_find_impldef_by_class = function(somSelf: SOMObjectBase{ImplRepository}; ev: PEnvironment; classname: CORBAString): _IDL_Sequence_ImplementationDef; stdcall;

function ImplRepository.find_impldef_by_class(classname: CORBAString): _IDL_Sequence_ImplementationDef; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PImplRepositoryClassDataStructure;
  LocalEnv: Environment;
begin
  cd := ImplRepositoryClassData;
  SOM_InitEnvironment(@LocalEnv);
  Result :=
  somTD_ImplRepository_find_impldef_by_class
   (SOM_Resolve(Self, cd.classObject, cd.find_impldef_by_class))
     (Self, @LocalEnv, classname);
  SOM_UninitEnvironmentOrRaise(@LocalEnv);
end;

(*
 * New Method: add_impldef
 *)
type
  somTD_ImplRepository_add_impldef = procedure(somSelf: SOMObjectBase{ImplRepository}; ev: PEnvironment; impldef: ImplementationDef); stdcall;

procedure ImplRepository.add_impldef(impldef: ImplementationDef); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PImplRepositoryClassDataStructure;
  LocalEnv: Environment;
begin
  cd := ImplRepositoryClassData;
  SOM_InitEnvironment(@LocalEnv);
  somTD_ImplRepository_add_impldef
   (SOM_Resolve(Self, cd.classObject, cd.add_impldef))
     (Self, @LocalEnv, impldef);
  SOM_UninitEnvironmentOrRaise(@LocalEnv);
end;

(*
 * New Method: update_impldef
 *)
type
  somTD_ImplRepository_update_impldef = procedure(somSelf: SOMObjectBase{ImplRepository}; ev: PEnvironment; impldef: ImplementationDef); stdcall;

procedure ImplRepository.update_impldef(impldef: ImplementationDef); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PImplRepositoryClassDataStructure;
  LocalEnv: Environment;
begin
  cd := ImplRepositoryClassData;
  SOM_InitEnvironment(@LocalEnv);
  somTD_ImplRepository_update_impldef
   (SOM_Resolve(Self, cd.classObject, cd.update_impldef))
     (Self, @LocalEnv, impldef);
  SOM_UninitEnvironmentOrRaise(@LocalEnv);
end;

(*
 * New Method: delete_impldef
 *)
type
  somTD_ImplRepository_delete_impldef = procedure(somSelf: SOMObjectBase{ImplRepository}; ev: PEnvironment; implid: CORBAString); stdcall;

procedure ImplRepository.delete_impldef(implid: CORBAString); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PImplRepositoryClassDataStructure;
  LocalEnv: Environment;
begin
  cd := ImplRepositoryClassData;
  SOM_InitEnvironment(@LocalEnv);
  somTD_ImplRepository_delete_impldef
   (SOM_Resolve(Self, cd.classObject, cd.delete_impldef))
     (Self, @LocalEnv, implid);
  SOM_UninitEnvironmentOrRaise(@LocalEnv);
end;

(*
 * New Method: add_class_to_impldef
 *)
type
  somTD_ImplRepository_add_class_to_impldef = procedure(somSelf: SOMObjectBase{ImplRepository}; ev: PEnvironment; implid: CORBAString; classname: CORBAString); stdcall;

procedure ImplRepository.add_class_to_impldef(implid: CORBAString; classname: CORBAString); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PImplRepositoryClassDataStructure;
  LocalEnv: Environment;
begin
  cd := ImplRepositoryClassData;
  SOM_InitEnvironment(@LocalEnv);
  somTD_ImplRepository_add_class_to_impldef
   (SOM_Resolve(Self, cd.classObject, cd.add_class_to_impldef))
     (Self, @LocalEnv, implid, classname);
  SOM_UninitEnvironmentOrRaise(@LocalEnv);
end;

(*
 * New Method: remove_class_from_impldef
 *)
type
  somTD_ImplRepository_remove_class_from_impldef = procedure(somSelf: SOMObjectBase{ImplRepository}; ev: PEnvironment; implid: CORBAString; classname: CORBAString); stdcall;

procedure ImplRepository.remove_class_from_impldef(implid: CORBAString; classname: CORBAString); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PImplRepositoryClassDataStructure;
  LocalEnv: Environment;
begin
  cd := ImplRepositoryClassData;
  SOM_InitEnvironment(@LocalEnv);
  somTD_ImplRepository_remove_class_from_impldef
   (SOM_Resolve(Self, cd.classObject, cd.remove_class_from_impldef))
     (Self, @LocalEnv, implid, classname);
  SOM_UninitEnvironmentOrRaise(@LocalEnv);
end;

(*
 * New Method: remove_class_from_all
 *)
type
  somTD_ImplRepository_remove_class_from_all = procedure(somSelf: SOMObjectBase{ImplRepository}; ev: PEnvironment; classname: CORBAString); stdcall;

procedure ImplRepository.remove_class_from_all(classname: CORBAString); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PImplRepositoryClassDataStructure;
  LocalEnv: Environment;
begin
  cd := ImplRepositoryClassData;
  SOM_InitEnvironment(@LocalEnv);
  somTD_ImplRepository_remove_class_from_all
   (SOM_Resolve(Self, cd.classObject, cd.remove_class_from_all))
     (Self, @LocalEnv, classname);
  SOM_UninitEnvironmentOrRaise(@LocalEnv);
end;

(*
 * New Method: find_classes_by_impldef
 *)
type
  somTD_ImplRepository_find_classes_by_impldef = function(somSelf: SOMObjectBase{ImplRepository}; ev: PEnvironment; implid: CORBAString): _IDL_Sequence_CORBAString; stdcall;

function ImplRepository.find_classes_by_impldef(implid: CORBAString): _IDL_Sequence_CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PImplRepositoryClassDataStructure;
  LocalEnv: Environment;
begin
  cd := ImplRepositoryClassData;
  SOM_InitEnvironment(@LocalEnv);
  Result :=
  somTD_ImplRepository_find_classes_by_impldef
   (SOM_Resolve(Self, cd.classObject, cd.find_classes_by_impldef))
     (Self, @LocalEnv, implid);
  SOM_UninitEnvironmentOrRaise(@LocalEnv);
end;

procedure ImplRepository.somDefaultInit(var ctrl: Pointer); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somDefaultInit
   (SOM_Resolve(Self, cd.classObject, cd.somDefaultInit))
     (Self, ctrl);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

procedure ImplRepository.somDestruct(doFree: Byte; var ctrl: Pointer); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somDestruct
   (SOM_Resolve(Self, cd.classObject, cd.somDestruct))
     (Self, doFree, ctrl);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

procedure ImplRepository.somDefaultCopyInit(var ctrl: Pointer; fromObj: ImplRepository); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somDefaultCopyInit
   (SOM_Resolve(Self, cd.classObject, cd.somDefaultCopyInit))
     (Self, ctrl, fromObj);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function ImplRepository.somDefaultAssign(var ctrl: Pointer; fromObj: ImplRepository): ImplRepository; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result := ImplRepository(
  somTD_SOMObject_somDefaultAssign
   (SOM_Resolve(Self, cd.classObject, cd.somDefaultAssign))
     (Self, ctrl, fromObj));
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

procedure ImplRepository.somDefaultConstCopyInit(var ctrl: Pointer; fromObj: ImplRepository); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somDefaultConstCopyInit
   (SOM_Resolve(Self, cd.classObject, cd.somDefaultConstCopyInit))
     (Self, ctrl, fromObj);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

procedure ImplRepository.somDefaultVCopyInit(var ctrl: Pointer; fromObj: ImplRepository); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somDefaultVCopyInit
   (SOM_Resolve(Self, cd.classObject, cd.somDefaultVCopyInit))
     (Self, ctrl, fromObj);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

procedure ImplRepository.somDefaultConstVCopyInit(var ctrl: Pointer; fromObj: ImplRepository); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somDefaultConstVCopyInit
   (SOM_Resolve(Self, cd.classObject, cd.somDefaultConstVCopyInit))
     (Self, ctrl, fromObj);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function ImplRepository.somDefaultConstAssign(var ctrl: Pointer; fromObj: ImplRepository): ImplRepository; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result := ImplRepository(
  somTD_SOMObject_somDefaultConstAssign
   (SOM_Resolve(Self, cd.classObject, cd.somDefaultConstAssign))
     (Self, ctrl, fromObj));
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function ImplRepository.somDefaultVAssign(var ctrl: Pointer; fromObj: ImplRepository): ImplRepository; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result := ImplRepository(
  somTD_SOMObject_somDefaultVAssign
   (SOM_Resolve(Self, cd.classObject, cd.somDefaultVAssign))
     (Self, ctrl, fromObj));
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function ImplRepository.somDefaultConstVAssign(var ctrl: Pointer; fromObj: ImplRepository): ImplRepository; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result := ImplRepository(
  somTD_SOMObject_somDefaultConstVAssign
   (SOM_Resolve(Self, cd.classObject, cd.somDefaultConstVAssign))
     (Self, ctrl, fromObj));
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

procedure ImplRepository.somInit; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somInit
   (SOM_Resolve(Self, cd.classObject, cd.somInit))
     (Self);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

procedure ImplRepository.somFree; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somFree
   (SOM_Resolve(Self, cd.classObject, cd.somFree))
     (Self);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

procedure ImplRepository.somUninit; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somUninit
   (SOM_Resolve(Self, cd.classObject, cd.somUninit))
     (Self);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function ImplRepository.somGetClass: SOMMSingleInstance; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result := SOMMSingleInstance(
  somTD_SOMObject_somGetClass
   (SOM_Resolve(Self, cd.classObject, cd.somGetClass))
     (Self));
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function ImplRepository.somGetClassName: {dual_owned} CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result :=
  somTD_SOMObject_somGetClassName
   (SOM_Resolve(Self, cd.classObject, cd.somGetClassName))
     (Self);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function ImplRepository.somGetSize: LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result :=
  somTD_SOMObject_somGetSize
   (SOM_Resolve(Self, cd.classObject, cd.somGetSize))
     (Self);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function ImplRepository.somIsA(aClassObj: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result :=
  somTD_SOMObject_somIsA
   (SOM_Resolve(Self, cd.classObject, cd.somIsA))
     (Self, aClassObj);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function ImplRepository.somIsInstanceOf(aClassObj: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result :=
  somTD_SOMObject_somIsInstanceOf
   (SOM_Resolve(Self, cd.classObject, cd.somIsInstanceOf))
     (Self, aClassObj);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function ImplRepository.somRespondsTo(mId: somId): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result :=
  somTD_SOMObject_somRespondsTo
   (SOM_Resolve(Self, cd.classObject, cd.somRespondsTo))
     (Self, mId);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function ImplRepository.somDispatch(out retValue: Pointer; methodId: somId; ap: va_list): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result :=
  somTD_SOMObject_somDispatch
   (SOM_Resolve(Self, cd.classObject, cd.somDispatch))
     (Self, retValue, methodId, ap);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function ImplRepository.somClassDispatch(clsObj: SOMClass; out retValue: Pointer; methodId: somId; ap: va_list): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result :=
  somTD_SOMObject_somClassDispatch
   (SOM_Resolve(Self, cd.classObject, cd.somClassDispatch))
     (Self, clsObj, retValue, methodId, ap);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function ImplRepository.somCastObj(cls: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result :=
  somTD_SOMObject_somCastObj
   (SOM_Resolve(Self, cd.classObject, cd.somCastObj))
     (Self, cls);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function ImplRepository.somResetObj: CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result :=
  somTD_SOMObject_somResetObj
   (SOM_Resolve(Self, cd.classObject, cd.somResetObj))
     (Self);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function ImplRepository.somPrintSelf: ImplRepository; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result := ImplRepository(
  somTD_SOMObject_somPrintSelf
   (SOM_Resolve(Self, cd.classObject, cd.somPrintSelf))
     (Self));
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

procedure ImplRepository.somDumpSelf(level: LongInt); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somDumpSelf
   (SOM_Resolve(Self, cd.classObject, cd.somDumpSelf))
     (Self, level);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

procedure ImplRepository.somDumpSelfInt(level: LongInt); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somDumpSelfInt
   (SOM_Resolve(Self, cd.classObject, cd.somDumpSelfInt))
     (Self, level);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

class function ImplRepository.ClassObject: SOMMSingleInstance; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
begin
  if Self = ImplRepository then { invoked on class name literal }
  begin
    Result := SOMMSingleInstance(ImplRepositoryClassData.classObject);
  end
  else { invoked on SOM object }
  begin
    Result := SOMMSingleInstance(PPointer(Self)^);
  end
end;

class function ImplRepository.NewClass: SOMMSingleInstance;
begin
  if Self = ImplRepository then { invoked on class name literal }
  begin
    Result := SOMMSingleInstance(ImplRepositoryClassData.classObject);
    if not Assigned(Result) then Result := SOMMSingleInstance(ImplRepositoryNewClass);
  end
  else { invoked on SOM object }
  begin
    Result := SOMMSingleInstance(PPointer(Self)^);
  end
end;

function ImplRepository.As_ImplRepository: ImplRepository; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
begin
  Result := Self;
end;

class function ImplRepository.Supports(Instance: SOMObjectBase): Boolean;
var
  cls: SOMClass;
begin
  if not Assigned(Instance) then
  begin
    Result := False;
  end
  else
  begin
    cls := SOMClass(ClassObject);
    if not Assigned(cls) then
    begin
      Result := False;
    end
    else
    begin
      Result := SOMObject(Instance).somIsA(cls);
    end;
  end;
end;

class function ImplRepository.Supports(Instance: SOMObjectBase; out Obj: ImplRepository): Boolean;
var
  cls: SOMClass;
begin
  if not Assigned(Instance) then
  begin
    Result := False;
    Obj := nil;
  end
  else
  begin
    cls := SOMClass(ClassObject);
    if not Assigned(cls) then
    begin
      Result := False;
      Obj := nil;
    end
    else if SOMObject(Instance).somIsA(cls) then
    begin
      Result := True;
      Obj := ImplRepository(Instance);
    end
    else
    begin
      Result := False;
      Obj := nil;
    end;
  end;
end;

const
  InterfaceDef_MajorVersion = 2;
  InterfaceDef_MinorVersion = 1;

(*
 * Declare the class creation procedure
 *)
function InterfaceDefNewClass(
  somtmajorVersion: integer4 = InterfaceDef_MajorVersion;
  somtminorVersion: integer4 = InterfaceDef_MinorVersion):
  SOMClass; stdcall; external SOMIR_DLL_Name name 'InterfaceDefNewClass';

(*
 * Declare the ABI 2 ClassData structure
 *)
type
  InterfaceDefClassDataStructure = packed record
    classObject: SOMClass;
    describe_interface,
    _get_base_interfaces,
    _set_base_interfaces,
    _get_instanceData,
    _set_instanceData: somMToken;
  end;
  PInterfaceDefClassDataStructure = ^InterfaceDefClassDataStructure;

var
  SOMIR_DLL_InterfaceDefClassData: PInterfaceDefClassDataStructure = nil;

function InterfaceDefClassData: PInterfaceDefClassDataStructure;
begin
  if Assigned(SOMIR_DLL_InterfaceDefClassData) then
    Result := SOMIR_DLL_InterfaceDefClassData
  else
  begin
    SOMIR_DLL_Load_Variable(SOMIR_DLL_InterfaceDefClassData, 'InterfaceDefClassData');
    Result := SOMIR_DLL_InterfaceDefClassData;
  end;
end;

(*
 * Declare the ABI 2 CClassData structure
 *)
type
  InterfaceDefCClassDataStructure = packed record
    parentMtab: somMethodTabs;
    instanceDataToken: somDToken;
  end;
  PInterfaceDefCClassDataStructure = ^InterfaceDefCClassDataStructure;

var
  SOMIR_DLL_InterfaceDefCClassData: PInterfaceDefCClassDataStructure = nil;

function InterfaceDefCClassData: PInterfaceDefCClassDataStructure;
begin
  if Assigned(SOMIR_DLL_InterfaceDefCClassData) then
    Result := SOMIR_DLL_InterfaceDefCClassData
  else
  begin
    SOMIR_DLL_Load_Variable(SOMIR_DLL_InterfaceDefCClassData, 'InterfaceDefCClassData');
    Result := SOMIR_DLL_InterfaceDefCClassData;
  end;
end;

(*
 * Class Object and Method Token Macros
 *)

(*
 * New Method: _get_base_interfaces
 *)
type
  somTD_InterfaceDef__get_base_interfaces = function(somSelf: SOMObjectBase{InterfaceDef}; ev: PEnvironment): _IDL_Sequence_CORBAString; stdcall;

function InterfaceDef._get_base_interfaces: _IDL_Sequence_CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PInterfaceDefClassDataStructure;
  LocalEnv: Environment;
begin
  cd := InterfaceDefClassData;
  SOM_InitEnvironment(@LocalEnv);
  Result :=
  somTD_InterfaceDef__get_base_interfaces
   (SOM_Resolve(Self, cd.classObject, cd._get_base_interfaces))
     (Self, @LocalEnv);
  SOM_UninitEnvironmentOrRaise(@LocalEnv);
end;

(*
 * New Method: _set_base_interfaces
 *)
type
  somTD_InterfaceDef__set_base_interfaces = procedure(somSelf: SOMObjectBase{InterfaceDef}; ev: PEnvironment; const base_interfaces: {caller_owns} _IDL_Sequence_CORBAString); stdcall;

procedure InterfaceDef._set_base_interfaces(const base_interfaces: {caller_owns} _IDL_Sequence_CORBAString); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PInterfaceDefClassDataStructure;
  LocalEnv: Environment;
begin
  cd := InterfaceDefClassData;
  SOM_InitEnvironment(@LocalEnv);
  somTD_InterfaceDef__set_base_interfaces
   (SOM_Resolve(Self, cd.classObject, cd._set_base_interfaces))
     (Self, @LocalEnv, base_interfaces);
  SOM_UninitEnvironmentOrRaise(@LocalEnv);
end;

(*
 * New Method: _get_instanceData
 *)
type
  somTD_InterfaceDef__get_instanceData = function(somSelf: SOMObjectBase{InterfaceDef}; ev: PEnvironment): TypeCode; stdcall;

function InterfaceDef._get_instanceData: TypeCode; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PInterfaceDefClassDataStructure;
  LocalEnv: Environment;
begin
  cd := InterfaceDefClassData;
  SOM_InitEnvironment(@LocalEnv);
  Result :=
  somTD_InterfaceDef__get_instanceData
   (SOM_Resolve(Self, cd.classObject, cd._get_instanceData))
     (Self, @LocalEnv);
  SOM_UninitEnvironmentOrRaise(@LocalEnv);
end;

(*
 * New Method: _set_instanceData
 *)
type
  somTD_InterfaceDef__set_instanceData = procedure(somSelf: SOMObjectBase{InterfaceDef}; ev: PEnvironment; instanceData: {caller_owns} TypeCode); stdcall;

procedure InterfaceDef._set_instanceData(instanceData: {caller_owns} TypeCode); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PInterfaceDefClassDataStructure;
  LocalEnv: Environment;
begin
  cd := InterfaceDefClassData;
  SOM_InitEnvironment(@LocalEnv);
  somTD_InterfaceDef__set_instanceData
   (SOM_Resolve(Self, cd.classObject, cd._set_instanceData))
     (Self, @LocalEnv, instanceData);
  SOM_UninitEnvironmentOrRaise(@LocalEnv);
end;

function InterfaceDef._get_name: CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PContainedClassDataStructure;
  LocalEnv: Environment;
begin
  cd := ContainedClassData;
  SOM_InitEnvironment(@LocalEnv);
  Result :=
  somTD_Contained__get_name
   (SOM_Resolve(Self, cd.classObject, cd._get_name))
     (Self, @LocalEnv);
  SOM_UninitEnvironmentOrRaise(@LocalEnv);
end;

procedure InterfaceDef._set_name(name: {caller_owns} CORBAString); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PContainedClassDataStructure;
  LocalEnv: Environment;
begin
  cd := ContainedClassData;
  SOM_InitEnvironment(@LocalEnv);
  somTD_Contained__set_name
   (SOM_Resolve(Self, cd.classObject, cd._set_name))
     (Self, @LocalEnv, name);
  SOM_UninitEnvironmentOrRaise(@LocalEnv);
end;

function InterfaceDef._get_id: CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PContainedClassDataStructure;
  LocalEnv: Environment;
begin
  cd := ContainedClassData;
  SOM_InitEnvironment(@LocalEnv);
  Result :=
  somTD_Contained__get_id
   (SOM_Resolve(Self, cd.classObject, cd._get_id))
     (Self, @LocalEnv);
  SOM_UninitEnvironmentOrRaise(@LocalEnv);
end;

procedure InterfaceDef._set_id(id: {caller_owns} CORBAString); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PContainedClassDataStructure;
  LocalEnv: Environment;
begin
  cd := ContainedClassData;
  SOM_InitEnvironment(@LocalEnv);
  somTD_Contained__set_id
   (SOM_Resolve(Self, cd.classObject, cd._set_id))
     (Self, @LocalEnv, id);
  SOM_UninitEnvironmentOrRaise(@LocalEnv);
end;

function InterfaceDef._get_defined_in: CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PContainedClassDataStructure;
  LocalEnv: Environment;
begin
  cd := ContainedClassData;
  SOM_InitEnvironment(@LocalEnv);
  Result :=
  somTD_Contained__get_defined_in
   (SOM_Resolve(Self, cd.classObject, cd._get_defined_in))
     (Self, @LocalEnv);
  SOM_UninitEnvironmentOrRaise(@LocalEnv);
end;

procedure InterfaceDef._set_defined_in(defined_in: {caller_owns} CORBAString); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PContainedClassDataStructure;
  LocalEnv: Environment;
begin
  cd := ContainedClassData;
  SOM_InitEnvironment(@LocalEnv);
  somTD_Contained__set_defined_in
   (SOM_Resolve(Self, cd.classObject, cd._set_defined_in))
     (Self, @LocalEnv, defined_in);
  SOM_UninitEnvironmentOrRaise(@LocalEnv);
end;

function InterfaceDef._get_somModifiers: _IDL_Sequence_somModifier; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PContainedClassDataStructure;
  LocalEnv: Environment;
begin
  cd := ContainedClassData;
  SOM_InitEnvironment(@LocalEnv);
  Result :=
  somTD_Contained__get_somModifiers
   (SOM_Resolve(Self, cd.classObject, cd._get_somModifiers))
     (Self, @LocalEnv);
  SOM_UninitEnvironmentOrRaise(@LocalEnv);
end;

procedure InterfaceDef._set_somModifiers(const somModifiers: {caller_owns} _IDL_Sequence_somModifier); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PContainedClassDataStructure;
  LocalEnv: Environment;
begin
  cd := ContainedClassData;
  SOM_InitEnvironment(@LocalEnv);
  somTD_Contained__set_somModifiers
   (SOM_Resolve(Self, cd.classObject, cd._set_somModifiers))
     (Self, @LocalEnv, somModifiers);
  SOM_UninitEnvironmentOrRaise(@LocalEnv);
end;

class function InterfaceDef.Create: InterfaceDef; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
begin
  Result := InterfaceDef(SOMClass(NewClass).somNew);
end;

class function InterfaceDef.InitInstance(Instance: Pointer): InterfaceDef; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
begin
  Result := InterfaceDef(SOMClass(NewClass).somRenewNoInit(Instance));
end;

function InterfaceDef.ClassType: SOMClass; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
begin
  Result := SOMClass(SOMObject(Self).somGetClass);
end;

class function InterfaceDef.ClassName: string;
begin
  Result := AnsiString(SOMClass(NewClass).somGetName);
end;

class function InterfaceDef.ClassNameIs(const Name: string): Boolean;
begin
  Result := AnsiString(SOMClass(NewClass).somGetName) = Name;
end;

class function InterfaceDef.InstanceSize: LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
begin
  Result := SOMClass(NewClass).somGetInstanceSize;
end;

class function InterfaceDef.InheritsFrom(AClass: SOMClass): Boolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
begin
  Result := SOMClass(NewClass).somDescendedFrom(AClass);
end;

class function InterfaceDef.MethodAddress(const Name: string): Pointer;
var
  NameAsAnsiString: AnsiString;
  NameAsSomId: somId;
begin
  NameAsAnsiString := AnsiString(Name);
  NameAsSomId := somIdFromString(PAnsiChar(NameAsAnsiString));
  try
    SOMClass(NewClass).somFindMethod(NameAsSomId, Result);
  finally
    SOMMemFree(NameAsSomId);
  end;
end;

class function InterfaceDef.NewInstance: InterfaceDef; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
begin
  Result := InterfaceDef(SOMClass(NewClass).somNewNoInit);
end;

function InterfaceDef.Clone: InterfaceDef; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
begin
  Result := InterfaceDef(SOMClass(somGetClass).somNewNoInit);
  SOMObject(Result).somDefaultCopyInit(somInitCtrl(nil^), SOMObject(Self));
end;

(*
 * New Method: describe_interface
 *)
type
  somTD_InterfaceDef_describe_interface = function(somSelf: SOMObjectBase{InterfaceDef}; ev: PEnvironment): InterfaceDef_FullInterfaceDescription; stdcall;

function InterfaceDef.describe_interface: InterfaceDef_FullInterfaceDescription; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PInterfaceDefClassDataStructure;
  LocalEnv: Environment;
begin
  cd := InterfaceDefClassData;
  SOM_InitEnvironment(@LocalEnv);
  Result :=
  somTD_InterfaceDef_describe_interface
   (SOM_Resolve(Self, cd.classObject, cd.describe_interface))
     (Self, @LocalEnv);
  SOM_UninitEnvironmentOrRaise(@LocalEnv);
end;

function InterfaceDef.within: _IDL_Sequence_Container; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PContainedClassDataStructure;
  LocalEnv: Environment;
begin
  cd := ContainedClassData;
  SOM_InitEnvironment(@LocalEnv);
  Result :=
  somTD_Contained_within
   (SOM_Resolve(Self, cd.classObject, cd.within))
     (Self, @LocalEnv);
  SOM_UninitEnvironmentOrRaise(@LocalEnv);
end;

function InterfaceDef.describe: Contained_Description; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PContainedClassDataStructure;
  LocalEnv: Environment;
begin
  cd := ContainedClassData;
  SOM_InitEnvironment(@LocalEnv);
  Result :=
  somTD_Contained_describe
   (SOM_Resolve(Self, cd.classObject, cd.describe))
     (Self, @LocalEnv);
  SOM_UninitEnvironmentOrRaise(@LocalEnv);
end;

procedure InterfaceDef.somDefaultInit(var ctrl: Pointer); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somDefaultInit
   (SOM_Resolve(Self, cd.classObject, cd.somDefaultInit))
     (Self, ctrl);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

procedure InterfaceDef.somDestruct(doFree: Byte; var ctrl: Pointer); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somDestruct
   (SOM_Resolve(Self, cd.classObject, cd.somDestruct))
     (Self, doFree, ctrl);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

procedure InterfaceDef.somDefaultCopyInit(var ctrl: Pointer; fromObj: InterfaceDef); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somDefaultCopyInit
   (SOM_Resolve(Self, cd.classObject, cd.somDefaultCopyInit))
     (Self, ctrl, fromObj);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function InterfaceDef.somDefaultAssign(var ctrl: Pointer; fromObj: InterfaceDef): InterfaceDef; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result := InterfaceDef(
  somTD_SOMObject_somDefaultAssign
   (SOM_Resolve(Self, cd.classObject, cd.somDefaultAssign))
     (Self, ctrl, fromObj));
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

procedure InterfaceDef.somDefaultConstCopyInit(var ctrl: Pointer; fromObj: InterfaceDef); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somDefaultConstCopyInit
   (SOM_Resolve(Self, cd.classObject, cd.somDefaultConstCopyInit))
     (Self, ctrl, fromObj);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

procedure InterfaceDef.somDefaultVCopyInit(var ctrl: Pointer; fromObj: InterfaceDef); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somDefaultVCopyInit
   (SOM_Resolve(Self, cd.classObject, cd.somDefaultVCopyInit))
     (Self, ctrl, fromObj);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

procedure InterfaceDef.somDefaultConstVCopyInit(var ctrl: Pointer; fromObj: InterfaceDef); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somDefaultConstVCopyInit
   (SOM_Resolve(Self, cd.classObject, cd.somDefaultConstVCopyInit))
     (Self, ctrl, fromObj);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function InterfaceDef.somDefaultConstAssign(var ctrl: Pointer; fromObj: InterfaceDef): InterfaceDef; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result := InterfaceDef(
  somTD_SOMObject_somDefaultConstAssign
   (SOM_Resolve(Self, cd.classObject, cd.somDefaultConstAssign))
     (Self, ctrl, fromObj));
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function InterfaceDef.somDefaultVAssign(var ctrl: Pointer; fromObj: InterfaceDef): InterfaceDef; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result := InterfaceDef(
  somTD_SOMObject_somDefaultVAssign
   (SOM_Resolve(Self, cd.classObject, cd.somDefaultVAssign))
     (Self, ctrl, fromObj));
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function InterfaceDef.somDefaultConstVAssign(var ctrl: Pointer; fromObj: InterfaceDef): InterfaceDef; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result := InterfaceDef(
  somTD_SOMObject_somDefaultConstVAssign
   (SOM_Resolve(Self, cd.classObject, cd.somDefaultConstVAssign))
     (Self, ctrl, fromObj));
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

procedure InterfaceDef.somInit; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somInit
   (SOM_Resolve(Self, cd.classObject, cd.somInit))
     (Self);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

procedure InterfaceDef.somFree; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somFree
   (SOM_Resolve(Self, cd.classObject, cd.somFree))
     (Self);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

procedure InterfaceDef.somUninit; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somUninit
   (SOM_Resolve(Self, cd.classObject, cd.somUninit))
     (Self);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function InterfaceDef.somGetClass: SOMClass; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result := SOMClass(
  somTD_SOMObject_somGetClass
   (SOM_Resolve(Self, cd.classObject, cd.somGetClass))
     (Self));
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function InterfaceDef.somGetClassName: {dual_owned} CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result :=
  somTD_SOMObject_somGetClassName
   (SOM_Resolve(Self, cd.classObject, cd.somGetClassName))
     (Self);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function InterfaceDef.somGetSize: LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result :=
  somTD_SOMObject_somGetSize
   (SOM_Resolve(Self, cd.classObject, cd.somGetSize))
     (Self);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function InterfaceDef.somIsA(aClassObj: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result :=
  somTD_SOMObject_somIsA
   (SOM_Resolve(Self, cd.classObject, cd.somIsA))
     (Self, aClassObj);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function InterfaceDef.somIsInstanceOf(aClassObj: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result :=
  somTD_SOMObject_somIsInstanceOf
   (SOM_Resolve(Self, cd.classObject, cd.somIsInstanceOf))
     (Self, aClassObj);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function InterfaceDef.somRespondsTo(mId: somId): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result :=
  somTD_SOMObject_somRespondsTo
   (SOM_Resolve(Self, cd.classObject, cd.somRespondsTo))
     (Self, mId);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function InterfaceDef.somDispatch(out retValue: Pointer; methodId: somId; ap: va_list): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result :=
  somTD_SOMObject_somDispatch
   (SOM_Resolve(Self, cd.classObject, cd.somDispatch))
     (Self, retValue, methodId, ap);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function InterfaceDef.somClassDispatch(clsObj: SOMClass; out retValue: Pointer; methodId: somId; ap: va_list): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result :=
  somTD_SOMObject_somClassDispatch
   (SOM_Resolve(Self, cd.classObject, cd.somClassDispatch))
     (Self, clsObj, retValue, methodId, ap);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function InterfaceDef.somCastObj(cls: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result :=
  somTD_SOMObject_somCastObj
   (SOM_Resolve(Self, cd.classObject, cd.somCastObj))
     (Self, cls);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function InterfaceDef.somResetObj: CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result :=
  somTD_SOMObject_somResetObj
   (SOM_Resolve(Self, cd.classObject, cd.somResetObj))
     (Self);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function InterfaceDef.somPrintSelf: InterfaceDef; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result := InterfaceDef(
  somTD_SOMObject_somPrintSelf
   (SOM_Resolve(Self, cd.classObject, cd.somPrintSelf))
     (Self));
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

procedure InterfaceDef.somDumpSelf(level: LongInt); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somDumpSelf
   (SOM_Resolve(Self, cd.classObject, cd.somDumpSelf))
     (Self, level);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

procedure InterfaceDef.somDumpSelfInt(level: LongInt); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somDumpSelfInt
   (SOM_Resolve(Self, cd.classObject, cd.somDumpSelfInt))
     (Self, level);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function InterfaceDef.contents(limit_type: CORBAString; exclude_inherited: CORBABoolean): {caller_owns} _IDL_Sequence_Contained; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PContainerClassDataStructure;
  LocalEnv: Environment;
begin
  cd := ContainerClassData;
  SOM_InitEnvironment(@LocalEnv);
  Result :=
  somTD_Container_contents
   (SOM_Resolve(Self, cd.classObject, cd.contents))
     (Self, @LocalEnv, limit_type, exclude_inherited);
  SOM_UninitEnvironmentOrRaise(@LocalEnv);
end;

function InterfaceDef.lookup_name(search_name: {caller_owns} CORBAString; levels_to_search: LongInt; limit_type: CORBAString; exclude_inherited: CORBABoolean): {caller_owns} _IDL_Sequence_Contained; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PContainerClassDataStructure;
  LocalEnv: Environment;
begin
  cd := ContainerClassData;
  SOM_InitEnvironment(@LocalEnv);
  Result :=
  somTD_Container_lookup_name
   (SOM_Resolve(Self, cd.classObject, cd.lookup_name))
     (Self, @LocalEnv, search_name, levels_to_search, limit_type, exclude_inherited);
  SOM_UninitEnvironmentOrRaise(@LocalEnv);
end;

function InterfaceDef.describe_contents(limit_type: CORBAString; exclude_inherited: CORBABoolean; max_returned_objs: LongInt): _IDL_Sequence_Container_ContainerDescription; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PContainerClassDataStructure;
  LocalEnv: Environment;
begin
  cd := ContainerClassData;
  SOM_InitEnvironment(@LocalEnv);
  Result :=
  somTD_Container_describe_contents
   (SOM_Resolve(Self, cd.classObject, cd.describe_contents))
     (Self, @LocalEnv, limit_type, exclude_inherited, max_returned_objs);
  SOM_UninitEnvironmentOrRaise(@LocalEnv);
end;

class function InterfaceDef.ClassObject: SOMClass; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
begin
  if Self = InterfaceDef then { invoked on class name literal }
  begin
    Result := SOMClass(InterfaceDefClassData.classObject);
  end
  else { invoked on SOM object }
  begin
    Result := SOMClass(PPointer(Self)^);
  end
end;

class function InterfaceDef.NewClass: SOMClass;
begin
  if Self = InterfaceDef then { invoked on class name literal }
  begin
    Result := SOMClass(InterfaceDefClassData.classObject);
    if not Assigned(Result) then Result := SOMClass(InterfaceDefNewClass);
  end
  else { invoked on SOM object }
  begin
    Result := SOMClass(PPointer(Self)^);
  end
end;

function InterfaceDef.As_Contained: Contained; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
begin
  Result := Contained(Self);
end;

function InterfaceDef.As_Container: Container; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
begin
  Result := Container(Self);
end;

function InterfaceDef.As_InterfaceDef: InterfaceDef; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
begin
  Result := Self;
end;

class function InterfaceDef.Supports(Instance: SOMObjectBase): Boolean;
var
  cls: SOMClass;
begin
  if not Assigned(Instance) then
  begin
    Result := False;
  end
  else
  begin
    cls := SOMClass(ClassObject);
    if not Assigned(cls) then
    begin
      Result := False;
    end
    else
    begin
      Result := SOMObject(Instance).somIsA(cls);
    end;
  end;
end;

class function InterfaceDef.Supports(Instance: SOMObjectBase; out Obj: InterfaceDef): Boolean;
var
  cls: SOMClass;
begin
  if not Assigned(Instance) then
  begin
    Result := False;
    Obj := nil;
  end
  else
  begin
    cls := SOMClass(ClassObject);
    if not Assigned(cls) then
    begin
      Result := False;
      Obj := nil;
    end
    else if SOMObject(Instance).somIsA(cls) then
    begin
      Result := True;
      Obj := InterfaceDef(Instance);
    end
    else
    begin
      Result := False;
      Obj := nil;
    end;
  end;
end;

const
  ModuleDef_MajorVersion = 2;
  ModuleDef_MinorVersion = 1;

(*
 * Declare the class creation procedure
 *)
function ModuleDefNewClass(
  somtmajorVersion: integer4 = ModuleDef_MajorVersion;
  somtminorVersion: integer4 = ModuleDef_MinorVersion):
  SOMClass; stdcall; external SOMIR_DLL_Name name 'ModuleDefNewClass';

(*
 * Declare the ABI 2 ClassData structure
 *)
type
  ModuleDefClassDataStructure = packed record
    classObject: SOMClass;
  end;
  PModuleDefClassDataStructure = ^ModuleDefClassDataStructure;

var
  SOMIR_DLL_ModuleDefClassData: PModuleDefClassDataStructure = nil;

function ModuleDefClassData: PModuleDefClassDataStructure;
begin
  if Assigned(SOMIR_DLL_ModuleDefClassData) then
    Result := SOMIR_DLL_ModuleDefClassData
  else
  begin
    SOMIR_DLL_Load_Variable(SOMIR_DLL_ModuleDefClassData, 'ModuleDefClassData');
    Result := SOMIR_DLL_ModuleDefClassData;
  end;
end;

(*
 * Declare the ABI 2 CClassData structure
 *)
type
  ModuleDefCClassDataStructure = packed record
    parentMtab: somMethodTabs;
    instanceDataToken: somDToken;
  end;
  PModuleDefCClassDataStructure = ^ModuleDefCClassDataStructure;

var
  SOMIR_DLL_ModuleDefCClassData: PModuleDefCClassDataStructure = nil;

function ModuleDefCClassData: PModuleDefCClassDataStructure;
begin
  if Assigned(SOMIR_DLL_ModuleDefCClassData) then
    Result := SOMIR_DLL_ModuleDefCClassData
  else
  begin
    SOMIR_DLL_Load_Variable(SOMIR_DLL_ModuleDefCClassData, 'ModuleDefCClassData');
    Result := SOMIR_DLL_ModuleDefCClassData;
  end;
end;

(*
 * Class Object and Method Token Macros
 *)

function ModuleDef._get_name: CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PContainedClassDataStructure;
  LocalEnv: Environment;
begin
  cd := ContainedClassData;
  SOM_InitEnvironment(@LocalEnv);
  Result :=
  somTD_Contained__get_name
   (SOM_Resolve(Self, cd.classObject, cd._get_name))
     (Self, @LocalEnv);
  SOM_UninitEnvironmentOrRaise(@LocalEnv);
end;

procedure ModuleDef._set_name(name: {caller_owns} CORBAString); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PContainedClassDataStructure;
  LocalEnv: Environment;
begin
  cd := ContainedClassData;
  SOM_InitEnvironment(@LocalEnv);
  somTD_Contained__set_name
   (SOM_Resolve(Self, cd.classObject, cd._set_name))
     (Self, @LocalEnv, name);
  SOM_UninitEnvironmentOrRaise(@LocalEnv);
end;

function ModuleDef._get_id: CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PContainedClassDataStructure;
  LocalEnv: Environment;
begin
  cd := ContainedClassData;
  SOM_InitEnvironment(@LocalEnv);
  Result :=
  somTD_Contained__get_id
   (SOM_Resolve(Self, cd.classObject, cd._get_id))
     (Self, @LocalEnv);
  SOM_UninitEnvironmentOrRaise(@LocalEnv);
end;

procedure ModuleDef._set_id(id: {caller_owns} CORBAString); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PContainedClassDataStructure;
  LocalEnv: Environment;
begin
  cd := ContainedClassData;
  SOM_InitEnvironment(@LocalEnv);
  somTD_Contained__set_id
   (SOM_Resolve(Self, cd.classObject, cd._set_id))
     (Self, @LocalEnv, id);
  SOM_UninitEnvironmentOrRaise(@LocalEnv);
end;

function ModuleDef._get_defined_in: CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PContainedClassDataStructure;
  LocalEnv: Environment;
begin
  cd := ContainedClassData;
  SOM_InitEnvironment(@LocalEnv);
  Result :=
  somTD_Contained__get_defined_in
   (SOM_Resolve(Self, cd.classObject, cd._get_defined_in))
     (Self, @LocalEnv);
  SOM_UninitEnvironmentOrRaise(@LocalEnv);
end;

procedure ModuleDef._set_defined_in(defined_in: {caller_owns} CORBAString); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PContainedClassDataStructure;
  LocalEnv: Environment;
begin
  cd := ContainedClassData;
  SOM_InitEnvironment(@LocalEnv);
  somTD_Contained__set_defined_in
   (SOM_Resolve(Self, cd.classObject, cd._set_defined_in))
     (Self, @LocalEnv, defined_in);
  SOM_UninitEnvironmentOrRaise(@LocalEnv);
end;

function ModuleDef._get_somModifiers: _IDL_Sequence_somModifier; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PContainedClassDataStructure;
  LocalEnv: Environment;
begin
  cd := ContainedClassData;
  SOM_InitEnvironment(@LocalEnv);
  Result :=
  somTD_Contained__get_somModifiers
   (SOM_Resolve(Self, cd.classObject, cd._get_somModifiers))
     (Self, @LocalEnv);
  SOM_UninitEnvironmentOrRaise(@LocalEnv);
end;

procedure ModuleDef._set_somModifiers(const somModifiers: {caller_owns} _IDL_Sequence_somModifier); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PContainedClassDataStructure;
  LocalEnv: Environment;
begin
  cd := ContainedClassData;
  SOM_InitEnvironment(@LocalEnv);
  somTD_Contained__set_somModifiers
   (SOM_Resolve(Self, cd.classObject, cd._set_somModifiers))
     (Self, @LocalEnv, somModifiers);
  SOM_UninitEnvironmentOrRaise(@LocalEnv);
end;

class function ModuleDef.Create: ModuleDef; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
begin
  Result := ModuleDef(SOMClass(NewClass).somNew);
end;

class function ModuleDef.InitInstance(Instance: Pointer): ModuleDef; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
begin
  Result := ModuleDef(SOMClass(NewClass).somRenewNoInit(Instance));
end;

function ModuleDef.ClassType: SOMClass; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
begin
  Result := SOMClass(SOMObject(Self).somGetClass);
end;

class function ModuleDef.ClassName: string;
begin
  Result := AnsiString(SOMClass(NewClass).somGetName);
end;

class function ModuleDef.ClassNameIs(const Name: string): Boolean;
begin
  Result := AnsiString(SOMClass(NewClass).somGetName) = Name;
end;

class function ModuleDef.InstanceSize: LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
begin
  Result := SOMClass(NewClass).somGetInstanceSize;
end;

class function ModuleDef.InheritsFrom(AClass: SOMClass): Boolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
begin
  Result := SOMClass(NewClass).somDescendedFrom(AClass);
end;

class function ModuleDef.MethodAddress(const Name: string): Pointer;
var
  NameAsAnsiString: AnsiString;
  NameAsSomId: somId;
begin
  NameAsAnsiString := AnsiString(Name);
  NameAsSomId := somIdFromString(PAnsiChar(NameAsAnsiString));
  try
    SOMClass(NewClass).somFindMethod(NameAsSomId, Result);
  finally
    SOMMemFree(NameAsSomId);
  end;
end;

class function ModuleDef.NewInstance: ModuleDef; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
begin
  Result := ModuleDef(SOMClass(NewClass).somNewNoInit);
end;

function ModuleDef.Clone: ModuleDef; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
begin
  Result := ModuleDef(SOMClass(somGetClass).somNewNoInit);
  SOMObject(Result).somDefaultCopyInit(somInitCtrl(nil^), SOMObject(Self));
end;

function ModuleDef.within: _IDL_Sequence_Container; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PContainedClassDataStructure;
  LocalEnv: Environment;
begin
  cd := ContainedClassData;
  SOM_InitEnvironment(@LocalEnv);
  Result :=
  somTD_Contained_within
   (SOM_Resolve(Self, cd.classObject, cd.within))
     (Self, @LocalEnv);
  SOM_UninitEnvironmentOrRaise(@LocalEnv);
end;

function ModuleDef.describe: Contained_Description; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PContainedClassDataStructure;
  LocalEnv: Environment;
begin
  cd := ContainedClassData;
  SOM_InitEnvironment(@LocalEnv);
  Result :=
  somTD_Contained_describe
   (SOM_Resolve(Self, cd.classObject, cd.describe))
     (Self, @LocalEnv);
  SOM_UninitEnvironmentOrRaise(@LocalEnv);
end;

procedure ModuleDef.somDefaultInit(var ctrl: Pointer); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somDefaultInit
   (SOM_Resolve(Self, cd.classObject, cd.somDefaultInit))
     (Self, ctrl);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

procedure ModuleDef.somDestruct(doFree: Byte; var ctrl: Pointer); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somDestruct
   (SOM_Resolve(Self, cd.classObject, cd.somDestruct))
     (Self, doFree, ctrl);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

procedure ModuleDef.somDefaultCopyInit(var ctrl: Pointer; fromObj: ModuleDef); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somDefaultCopyInit
   (SOM_Resolve(Self, cd.classObject, cd.somDefaultCopyInit))
     (Self, ctrl, fromObj);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function ModuleDef.somDefaultAssign(var ctrl: Pointer; fromObj: ModuleDef): ModuleDef; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result := ModuleDef(
  somTD_SOMObject_somDefaultAssign
   (SOM_Resolve(Self, cd.classObject, cd.somDefaultAssign))
     (Self, ctrl, fromObj));
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

procedure ModuleDef.somDefaultConstCopyInit(var ctrl: Pointer; fromObj: ModuleDef); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somDefaultConstCopyInit
   (SOM_Resolve(Self, cd.classObject, cd.somDefaultConstCopyInit))
     (Self, ctrl, fromObj);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

procedure ModuleDef.somDefaultVCopyInit(var ctrl: Pointer; fromObj: ModuleDef); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somDefaultVCopyInit
   (SOM_Resolve(Self, cd.classObject, cd.somDefaultVCopyInit))
     (Self, ctrl, fromObj);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

procedure ModuleDef.somDefaultConstVCopyInit(var ctrl: Pointer; fromObj: ModuleDef); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somDefaultConstVCopyInit
   (SOM_Resolve(Self, cd.classObject, cd.somDefaultConstVCopyInit))
     (Self, ctrl, fromObj);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function ModuleDef.somDefaultConstAssign(var ctrl: Pointer; fromObj: ModuleDef): ModuleDef; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result := ModuleDef(
  somTD_SOMObject_somDefaultConstAssign
   (SOM_Resolve(Self, cd.classObject, cd.somDefaultConstAssign))
     (Self, ctrl, fromObj));
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function ModuleDef.somDefaultVAssign(var ctrl: Pointer; fromObj: ModuleDef): ModuleDef; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result := ModuleDef(
  somTD_SOMObject_somDefaultVAssign
   (SOM_Resolve(Self, cd.classObject, cd.somDefaultVAssign))
     (Self, ctrl, fromObj));
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function ModuleDef.somDefaultConstVAssign(var ctrl: Pointer; fromObj: ModuleDef): ModuleDef; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result := ModuleDef(
  somTD_SOMObject_somDefaultConstVAssign
   (SOM_Resolve(Self, cd.classObject, cd.somDefaultConstVAssign))
     (Self, ctrl, fromObj));
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

procedure ModuleDef.somInit; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somInit
   (SOM_Resolve(Self, cd.classObject, cd.somInit))
     (Self);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

procedure ModuleDef.somFree; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somFree
   (SOM_Resolve(Self, cd.classObject, cd.somFree))
     (Self);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

procedure ModuleDef.somUninit; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somUninit
   (SOM_Resolve(Self, cd.classObject, cd.somUninit))
     (Self);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function ModuleDef.somGetClass: SOMClass; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result := SOMClass(
  somTD_SOMObject_somGetClass
   (SOM_Resolve(Self, cd.classObject, cd.somGetClass))
     (Self));
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function ModuleDef.somGetClassName: {dual_owned} CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result :=
  somTD_SOMObject_somGetClassName
   (SOM_Resolve(Self, cd.classObject, cd.somGetClassName))
     (Self);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function ModuleDef.somGetSize: LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result :=
  somTD_SOMObject_somGetSize
   (SOM_Resolve(Self, cd.classObject, cd.somGetSize))
     (Self);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function ModuleDef.somIsA(aClassObj: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result :=
  somTD_SOMObject_somIsA
   (SOM_Resolve(Self, cd.classObject, cd.somIsA))
     (Self, aClassObj);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function ModuleDef.somIsInstanceOf(aClassObj: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result :=
  somTD_SOMObject_somIsInstanceOf
   (SOM_Resolve(Self, cd.classObject, cd.somIsInstanceOf))
     (Self, aClassObj);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function ModuleDef.somRespondsTo(mId: somId): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result :=
  somTD_SOMObject_somRespondsTo
   (SOM_Resolve(Self, cd.classObject, cd.somRespondsTo))
     (Self, mId);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function ModuleDef.somDispatch(out retValue: Pointer; methodId: somId; ap: va_list): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result :=
  somTD_SOMObject_somDispatch
   (SOM_Resolve(Self, cd.classObject, cd.somDispatch))
     (Self, retValue, methodId, ap);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function ModuleDef.somClassDispatch(clsObj: SOMClass; out retValue: Pointer; methodId: somId; ap: va_list): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result :=
  somTD_SOMObject_somClassDispatch
   (SOM_Resolve(Self, cd.classObject, cd.somClassDispatch))
     (Self, clsObj, retValue, methodId, ap);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function ModuleDef.somCastObj(cls: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result :=
  somTD_SOMObject_somCastObj
   (SOM_Resolve(Self, cd.classObject, cd.somCastObj))
     (Self, cls);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function ModuleDef.somResetObj: CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result :=
  somTD_SOMObject_somResetObj
   (SOM_Resolve(Self, cd.classObject, cd.somResetObj))
     (Self);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function ModuleDef.somPrintSelf: ModuleDef; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result := ModuleDef(
  somTD_SOMObject_somPrintSelf
   (SOM_Resolve(Self, cd.classObject, cd.somPrintSelf))
     (Self));
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

procedure ModuleDef.somDumpSelf(level: LongInt); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somDumpSelf
   (SOM_Resolve(Self, cd.classObject, cd.somDumpSelf))
     (Self, level);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

procedure ModuleDef.somDumpSelfInt(level: LongInt); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somDumpSelfInt
   (SOM_Resolve(Self, cd.classObject, cd.somDumpSelfInt))
     (Self, level);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function ModuleDef.contents(limit_type: CORBAString; exclude_inherited: CORBABoolean): {caller_owns} _IDL_Sequence_Contained; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PContainerClassDataStructure;
  LocalEnv: Environment;
begin
  cd := ContainerClassData;
  SOM_InitEnvironment(@LocalEnv);
  Result :=
  somTD_Container_contents
   (SOM_Resolve(Self, cd.classObject, cd.contents))
     (Self, @LocalEnv, limit_type, exclude_inherited);
  SOM_UninitEnvironmentOrRaise(@LocalEnv);
end;

function ModuleDef.lookup_name(search_name: {caller_owns} CORBAString; levels_to_search: LongInt; limit_type: CORBAString; exclude_inherited: CORBABoolean): {caller_owns} _IDL_Sequence_Contained; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PContainerClassDataStructure;
  LocalEnv: Environment;
begin
  cd := ContainerClassData;
  SOM_InitEnvironment(@LocalEnv);
  Result :=
  somTD_Container_lookup_name
   (SOM_Resolve(Self, cd.classObject, cd.lookup_name))
     (Self, @LocalEnv, search_name, levels_to_search, limit_type, exclude_inherited);
  SOM_UninitEnvironmentOrRaise(@LocalEnv);
end;

function ModuleDef.describe_contents(limit_type: CORBAString; exclude_inherited: CORBABoolean; max_returned_objs: LongInt): _IDL_Sequence_Container_ContainerDescription; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PContainerClassDataStructure;
  LocalEnv: Environment;
begin
  cd := ContainerClassData;
  SOM_InitEnvironment(@LocalEnv);
  Result :=
  somTD_Container_describe_contents
   (SOM_Resolve(Self, cd.classObject, cd.describe_contents))
     (Self, @LocalEnv, limit_type, exclude_inherited, max_returned_objs);
  SOM_UninitEnvironmentOrRaise(@LocalEnv);
end;

class function ModuleDef.ClassObject: SOMClass; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
begin
  if Self = ModuleDef then { invoked on class name literal }
  begin
    Result := SOMClass(ModuleDefClassData.classObject);
  end
  else { invoked on SOM object }
  begin
    Result := SOMClass(PPointer(Self)^);
  end
end;

class function ModuleDef.NewClass: SOMClass;
begin
  if Self = ModuleDef then { invoked on class name literal }
  begin
    Result := SOMClass(ModuleDefClassData.classObject);
    if not Assigned(Result) then Result := SOMClass(ModuleDefNewClass);
  end
  else { invoked on SOM object }
  begin
    Result := SOMClass(PPointer(Self)^);
  end
end;

function ModuleDef.As_Contained: Contained; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
begin
  Result := Contained(Self);
end;

function ModuleDef.As_Container: Container; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
begin
  Result := Container(Self);
end;

function ModuleDef.As_ModuleDef: ModuleDef; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
begin
  Result := Self;
end;

class function ModuleDef.Supports(Instance: SOMObjectBase): Boolean;
var
  cls: SOMClass;
begin
  if not Assigned(Instance) then
  begin
    Result := False;
  end
  else
  begin
    cls := SOMClass(ClassObject);
    if not Assigned(cls) then
    begin
      Result := False;
    end
    else
    begin
      Result := SOMObject(Instance).somIsA(cls);
    end;
  end;
end;

class function ModuleDef.Supports(Instance: SOMObjectBase; out Obj: ModuleDef): Boolean;
var
  cls: SOMClass;
begin
  if not Assigned(Instance) then
  begin
    Result := False;
    Obj := nil;
  end
  else
  begin
    cls := SOMClass(ClassObject);
    if not Assigned(cls) then
    begin
      Result := False;
      Obj := nil;
    end
    else if SOMObject(Instance).somIsA(cls) then
    begin
      Result := True;
      Obj := ModuleDef(Instance);
    end
    else
    begin
      Result := False;
      Obj := nil;
    end;
  end;
end;

const
  NVList_MajorVersion = 2;
  NVList_MinorVersion = 1;

(*
 * Declare the class creation procedure
 *)
function NVListNewClass(
  somtmajorVersion: integer4 = NVList_MajorVersion;
  somtminorVersion: integer4 = NVList_MinorVersion):
  SOMClass; stdcall; external SOMD_DLL_Name name 'NVListNewClass';

(*
 * Declare the ABI 2 ClassData structure
 *)
type
  NVListClassDataStructure = packed record
    classObject: SOMClass;
    add_item,
    remove_item,
    free,
    free_memory,
    get_count,
    set_item,
    get_item,
    get_item_by_name: somMToken;
  end;
  PNVListClassDataStructure = ^NVListClassDataStructure;

var
  SOMD_DLL_NVListClassData: PNVListClassDataStructure = nil;

function NVListClassData: PNVListClassDataStructure;
begin
  if Assigned(SOMD_DLL_NVListClassData) then
    Result := SOMD_DLL_NVListClassData
  else
  begin
    SOMD_DLL_Load_Variable(SOMD_DLL_NVListClassData, 'NVListClassData');
    Result := SOMD_DLL_NVListClassData;
  end;
end;

(*
 * Declare the ABI 2 CClassData structure
 *)
type
  NVListCClassDataStructure = packed record
    parentMtab: somMethodTabs;
    instanceDataToken: somDToken;
  end;
  PNVListCClassDataStructure = ^NVListCClassDataStructure;

var
  SOMD_DLL_NVListCClassData: PNVListCClassDataStructure = nil;

function NVListCClassData: PNVListCClassDataStructure;
begin
  if Assigned(SOMD_DLL_NVListCClassData) then
    Result := SOMD_DLL_NVListCClassData
  else
  begin
    SOMD_DLL_Load_Variable(SOMD_DLL_NVListCClassData, 'NVListCClassData');
    Result := SOMD_DLL_NVListCClassData;
  end;
end;

(*
 * Class Object and Method Token Macros
 *)

class function NVList.Create: NVList; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
begin
  Result := NVList(SOMClass(NewClass).somNew);
end;

class function NVList.InitInstance(Instance: Pointer): NVList; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
begin
  Result := NVList(SOMClass(NewClass).somRenewNoInit(Instance));
end;

function NVList.ClassType: SOMClass; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
begin
  Result := SOMClass(SOMObject(Self).somGetClass);
end;

class function NVList.ClassName: string;
begin
  Result := AnsiString(SOMClass(NewClass).somGetName);
end;

class function NVList.ClassNameIs(const Name: string): Boolean;
begin
  Result := AnsiString(SOMClass(NewClass).somGetName) = Name;
end;

class function NVList.InstanceSize: LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
begin
  Result := SOMClass(NewClass).somGetInstanceSize;
end;

class function NVList.InheritsFrom(AClass: SOMClass): Boolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
begin
  Result := SOMClass(NewClass).somDescendedFrom(AClass);
end;

class function NVList.MethodAddress(const Name: string): Pointer;
var
  NameAsAnsiString: AnsiString;
  NameAsSomId: somId;
begin
  NameAsAnsiString := AnsiString(Name);
  NameAsSomId := somIdFromString(PAnsiChar(NameAsAnsiString));
  try
    SOMClass(NewClass).somFindMethod(NameAsSomId, Result);
  finally
    SOMMemFree(NameAsSomId);
  end;
end;

class function NVList.NewInstance: NVList; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
begin
  Result := NVList(SOMClass(NewClass).somNewNoInit);
end;

function NVList.Clone: NVList; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
begin
  Result := NVList(SOMClass(somGetClass).somNewNoInit);
  SOMObject(Result).somDefaultCopyInit(somInitCtrl(nil^), SOMObject(Self));
end;

(*
 * New Method: add_item
 *)
type
  somTD_NVList_add_item = function(somSelf: SOMObjectBase{NVList}; ev: PEnvironment; item_name: CORBAString; item_type: TypeCode; value: Pointer; value_len: LongInt; item_flags: LongWord): LongWord; stdcall;

function NVList.add_item(item_name: CORBAString; item_type: TypeCode; value: Pointer; value_len: LongInt; item_flags: LongWord): LongWord; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PNVListClassDataStructure;
  LocalEnv: Environment;
begin
  cd := NVListClassData;
  SOM_InitEnvironment(@LocalEnv);
  Result :=
  somTD_NVList_add_item
   (SOM_Resolve(Self, cd.classObject, cd.add_item))
     (Self, @LocalEnv, item_name, item_type, value, value_len, item_flags);
  SOM_UninitEnvironmentOrRaise(@LocalEnv);
end;

(*
 * New Method: free
 *)
type
  somTD_NVList_free = function(somSelf: SOMObjectBase{NVList}; ev: PEnvironment): LongWord; stdcall;

function NVList.free: LongWord; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PNVListClassDataStructure;
  LocalEnv: Environment;
begin
  cd := NVListClassData;
  SOM_InitEnvironment(@LocalEnv);
  Result :=
  somTD_NVList_free
   (SOM_Resolve(Self, cd.classObject, cd.free))
     (Self, @LocalEnv);
  SOM_UninitEnvironmentOrRaise(@LocalEnv);
end;

(*
 * New Method: free_memory
 *)
type
  somTD_NVList_free_memory = function(somSelf: SOMObjectBase{NVList}; ev: PEnvironment): LongWord; stdcall;

function NVList.free_memory: LongWord; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PNVListClassDataStructure;
  LocalEnv: Environment;
begin
  cd := NVListClassData;
  SOM_InitEnvironment(@LocalEnv);
  Result :=
  somTD_NVList_free_memory
   (SOM_Resolve(Self, cd.classObject, cd.free_memory))
     (Self, @LocalEnv);
  SOM_UninitEnvironmentOrRaise(@LocalEnv);
end;

(*
 * New Method: get_count
 *)
type
  somTD_NVList_get_count = function(somSelf: SOMObjectBase{NVList}; ev: PEnvironment; out count: LongInt): LongWord; stdcall;

function NVList.get_count(out count: LongInt): LongWord; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PNVListClassDataStructure;
  LocalEnv: Environment;
begin
  cd := NVListClassData;
  SOM_InitEnvironment(@LocalEnv);
  Result :=
  somTD_NVList_get_count
   (SOM_Resolve(Self, cd.classObject, cd.get_count))
     (Self, @LocalEnv, count);
  SOM_UninitEnvironmentOrRaise(@LocalEnv);
end;

(*
 * New Method: set_item
 *)
type
  somTD_NVList_set_item = function(somSelf: SOMObjectBase{NVList}; ev: PEnvironment; item_number: LongInt; item_name: CORBAString; item_type: TypeCode; value: Pointer; value_len: LongInt; item_flags: LongWord): LongWord; stdcall;

function NVList.set_item(item_number: LongInt; item_name: CORBAString; item_type: TypeCode; value: Pointer; value_len: LongInt; item_flags: LongWord): LongWord; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PNVListClassDataStructure;
  LocalEnv: Environment;
begin
  cd := NVListClassData;
  SOM_InitEnvironment(@LocalEnv);
  Result :=
  somTD_NVList_set_item
   (SOM_Resolve(Self, cd.classObject, cd.set_item))
     (Self, @LocalEnv, item_number, item_name, item_type, value, value_len, item_flags);
  SOM_UninitEnvironmentOrRaise(@LocalEnv);
end;

(*
 * New Method: get_item
 *)
type
  somTD_NVList_get_item = function(somSelf: SOMObjectBase{NVList}; ev: PEnvironment; item_number: LongInt; out item_name: CORBAString; out item_type: TypeCode; out value: Pointer; out value_len: LongInt; out item_flags: LongWord): LongWord; stdcall;

function NVList.get_item(item_number: LongInt; out item_name: CORBAString; out item_type: TypeCode; out value: Pointer; out value_len: LongInt; out item_flags: LongWord): LongWord; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PNVListClassDataStructure;
  LocalEnv: Environment;
begin
  cd := NVListClassData;
  SOM_InitEnvironment(@LocalEnv);
  Result :=
  somTD_NVList_get_item
   (SOM_Resolve(Self, cd.classObject, cd.get_item))
     (Self, @LocalEnv, item_number, item_name, item_type, value, value_len, item_flags);
  SOM_UninitEnvironmentOrRaise(@LocalEnv);
end;

procedure NVList.somDefaultInit(var ctrl: Pointer); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somDefaultInit
   (SOM_Resolve(Self, cd.classObject, cd.somDefaultInit))
     (Self, ctrl);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

procedure NVList.somDestruct(doFree: Byte; var ctrl: Pointer); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somDestruct
   (SOM_Resolve(Self, cd.classObject, cd.somDestruct))
     (Self, doFree, ctrl);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

procedure NVList.somDefaultCopyInit(var ctrl: Pointer; fromObj: NVList); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somDefaultCopyInit
   (SOM_Resolve(Self, cd.classObject, cd.somDefaultCopyInit))
     (Self, ctrl, fromObj);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function NVList.somDefaultAssign(var ctrl: Pointer; fromObj: NVList): NVList; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result := NVList(
  somTD_SOMObject_somDefaultAssign
   (SOM_Resolve(Self, cd.classObject, cd.somDefaultAssign))
     (Self, ctrl, fromObj));
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

procedure NVList.somDefaultConstCopyInit(var ctrl: Pointer; fromObj: NVList); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somDefaultConstCopyInit
   (SOM_Resolve(Self, cd.classObject, cd.somDefaultConstCopyInit))
     (Self, ctrl, fromObj);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

procedure NVList.somDefaultVCopyInit(var ctrl: Pointer; fromObj: NVList); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somDefaultVCopyInit
   (SOM_Resolve(Self, cd.classObject, cd.somDefaultVCopyInit))
     (Self, ctrl, fromObj);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

procedure NVList.somDefaultConstVCopyInit(var ctrl: Pointer; fromObj: NVList); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somDefaultConstVCopyInit
   (SOM_Resolve(Self, cd.classObject, cd.somDefaultConstVCopyInit))
     (Self, ctrl, fromObj);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function NVList.somDefaultConstAssign(var ctrl: Pointer; fromObj: NVList): NVList; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result := NVList(
  somTD_SOMObject_somDefaultConstAssign
   (SOM_Resolve(Self, cd.classObject, cd.somDefaultConstAssign))
     (Self, ctrl, fromObj));
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function NVList.somDefaultVAssign(var ctrl: Pointer; fromObj: NVList): NVList; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result := NVList(
  somTD_SOMObject_somDefaultVAssign
   (SOM_Resolve(Self, cd.classObject, cd.somDefaultVAssign))
     (Self, ctrl, fromObj));
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function NVList.somDefaultConstVAssign(var ctrl: Pointer; fromObj: NVList): NVList; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result := NVList(
  somTD_SOMObject_somDefaultConstVAssign
   (SOM_Resolve(Self, cd.classObject, cd.somDefaultConstVAssign))
     (Self, ctrl, fromObj));
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

procedure NVList.somInit; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somInit
   (SOM_Resolve(Self, cd.classObject, cd.somInit))
     (Self);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

procedure NVList.somFree; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somFree
   (SOM_Resolve(Self, cd.classObject, cd.somFree))
     (Self);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

procedure NVList.somUninit; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somUninit
   (SOM_Resolve(Self, cd.classObject, cd.somUninit))
     (Self);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function NVList.somGetClass: SOMClass; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result := SOMClass(
  somTD_SOMObject_somGetClass
   (SOM_Resolve(Self, cd.classObject, cd.somGetClass))
     (Self));
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function NVList.somGetClassName: {dual_owned} CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result :=
  somTD_SOMObject_somGetClassName
   (SOM_Resolve(Self, cd.classObject, cd.somGetClassName))
     (Self);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function NVList.somGetSize: LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result :=
  somTD_SOMObject_somGetSize
   (SOM_Resolve(Self, cd.classObject, cd.somGetSize))
     (Self);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function NVList.somIsA(aClassObj: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result :=
  somTD_SOMObject_somIsA
   (SOM_Resolve(Self, cd.classObject, cd.somIsA))
     (Self, aClassObj);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function NVList.somIsInstanceOf(aClassObj: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result :=
  somTD_SOMObject_somIsInstanceOf
   (SOM_Resolve(Self, cd.classObject, cd.somIsInstanceOf))
     (Self, aClassObj);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function NVList.somRespondsTo(mId: somId): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result :=
  somTD_SOMObject_somRespondsTo
   (SOM_Resolve(Self, cd.classObject, cd.somRespondsTo))
     (Self, mId);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function NVList.somDispatch(out retValue: Pointer; methodId: somId; ap: va_list): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result :=
  somTD_SOMObject_somDispatch
   (SOM_Resolve(Self, cd.classObject, cd.somDispatch))
     (Self, retValue, methodId, ap);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function NVList.somClassDispatch(clsObj: SOMClass; out retValue: Pointer; methodId: somId; ap: va_list): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result :=
  somTD_SOMObject_somClassDispatch
   (SOM_Resolve(Self, cd.classObject, cd.somClassDispatch))
     (Self, clsObj, retValue, methodId, ap);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function NVList.somCastObj(cls: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result :=
  somTD_SOMObject_somCastObj
   (SOM_Resolve(Self, cd.classObject, cd.somCastObj))
     (Self, cls);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function NVList.somResetObj: CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result :=
  somTD_SOMObject_somResetObj
   (SOM_Resolve(Self, cd.classObject, cd.somResetObj))
     (Self);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function NVList.somPrintSelf: NVList; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result := NVList(
  somTD_SOMObject_somPrintSelf
   (SOM_Resolve(Self, cd.classObject, cd.somPrintSelf))
     (Self));
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

procedure NVList.somDumpSelf(level: LongInt); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somDumpSelf
   (SOM_Resolve(Self, cd.classObject, cd.somDumpSelf))
     (Self, level);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

procedure NVList.somDumpSelfInt(level: LongInt); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somDumpSelfInt
   (SOM_Resolve(Self, cd.classObject, cd.somDumpSelfInt))
     (Self, level);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

class function NVList.ClassObject: SOMClass; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
begin
  if Self = NVList then { invoked on class name literal }
  begin
    Result := SOMClass(NVListClassData.classObject);
  end
  else { invoked on SOM object }
  begin
    Result := SOMClass(PPointer(Self)^);
  end
end;

class function NVList.NewClass: SOMClass;
begin
  if Self = NVList then { invoked on class name literal }
  begin
    Result := SOMClass(NVListClassData.classObject);
    if not Assigned(Result) then Result := SOMClass(NVListNewClass);
  end
  else { invoked on SOM object }
  begin
    Result := SOMClass(PPointer(Self)^);
  end
end;

function NVList.As_NVList: NVList; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
begin
  Result := Self;
end;

class function NVList.Supports(Instance: SOMObjectBase): Boolean;
var
  cls: SOMClass;
begin
  if not Assigned(Instance) then
  begin
    Result := False;
  end
  else
  begin
    cls := SOMClass(ClassObject);
    if not Assigned(cls) then
    begin
      Result := False;
    end
    else
    begin
      Result := SOMObject(Instance).somIsA(cls);
    end;
  end;
end;

class function NVList.Supports(Instance: SOMObjectBase; out Obj: NVList): Boolean;
var
  cls: SOMClass;
begin
  if not Assigned(Instance) then
  begin
    Result := False;
    Obj := nil;
  end
  else
  begin
    cls := SOMClass(ClassObject);
    if not Assigned(cls) then
    begin
      Result := False;
      Obj := nil;
    end
    else if SOMObject(Instance).somIsA(cls) then
    begin
      Result := True;
      Obj := NVList(Instance);
    end
    else
    begin
      Result := False;
      Obj := nil;
    end;
  end;
end;

const
  ObjectMgr_MajorVersion = 2;
  ObjectMgr_MinorVersion = 1;

(*
 * Declare the class creation procedure
 *)
function ObjectMgrNewClass(
  somtmajorVersion: integer4 = ObjectMgr_MajorVersion;
  somtminorVersion: integer4 = ObjectMgr_MinorVersion):
  SOMClass; stdcall; external SOMD_DLL_Name name 'ObjectMgrNewClass';

(*
 * Declare the ABI 2 ClassData structure
 *)
type
  ObjectMgrClassDataStructure = packed record
    classObject: SOMClass;
    somdNewObject,
    somdGetIdFromObject,
    somdGetObjectFromId,
    somdReleaseObject,
    somdDestroyObject: somMToken;
  end;
  PObjectMgrClassDataStructure = ^ObjectMgrClassDataStructure;

var
  SOMD_DLL_ObjectMgrClassData: PObjectMgrClassDataStructure = nil;

function ObjectMgrClassData: PObjectMgrClassDataStructure;
begin
  if Assigned(SOMD_DLL_ObjectMgrClassData) then
    Result := SOMD_DLL_ObjectMgrClassData
  else
  begin
    SOMD_DLL_Load_Variable(SOMD_DLL_ObjectMgrClassData, 'ObjectMgrClassData');
    Result := SOMD_DLL_ObjectMgrClassData;
  end;
end;

(*
 * Declare the ABI 2 CClassData structure
 *)
type
  ObjectMgrCClassDataStructure = packed record
    parentMtab: somMethodTabs;
    instanceDataToken: somDToken;
  end;
  PObjectMgrCClassDataStructure = ^ObjectMgrCClassDataStructure;

var
  SOMD_DLL_ObjectMgrCClassData: PObjectMgrCClassDataStructure = nil;

function ObjectMgrCClassData: PObjectMgrCClassDataStructure;
begin
  if Assigned(SOMD_DLL_ObjectMgrCClassData) then
    Result := SOMD_DLL_ObjectMgrCClassData
  else
  begin
    SOMD_DLL_Load_Variable(SOMD_DLL_ObjectMgrCClassData, 'ObjectMgrCClassData');
    Result := SOMD_DLL_ObjectMgrCClassData;
  end;
end;

(*
 * Class Object and Method Token Macros
 *)

class function ObjectMgr.Create: ObjectMgr; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
begin
  Result := ObjectMgr(SOMClass(NewClass).somNew);
end;

class function ObjectMgr.InitInstance(Instance: Pointer): ObjectMgr; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
begin
  Result := ObjectMgr(SOMClass(NewClass).somRenewNoInit(Instance));
end;

function ObjectMgr.ClassType: SOMMSingleInstance; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
begin
  Result := SOMMSingleInstance(SOMObject(Self).somGetClass);
end;

class function ObjectMgr.ClassName: string;
begin
  Result := AnsiString(SOMClass(NewClass).somGetName);
end;

class function ObjectMgr.ClassNameIs(const Name: string): Boolean;
begin
  Result := AnsiString(SOMClass(NewClass).somGetName) = Name;
end;

class function ObjectMgr.InstanceSize: LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
begin
  Result := SOMClass(NewClass).somGetInstanceSize;
end;

class function ObjectMgr.InheritsFrom(AClass: SOMClass): Boolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
begin
  Result := SOMClass(NewClass).somDescendedFrom(AClass);
end;

class function ObjectMgr.MethodAddress(const Name: string): Pointer;
var
  NameAsAnsiString: AnsiString;
  NameAsSomId: somId;
begin
  NameAsAnsiString := AnsiString(Name);
  NameAsSomId := somIdFromString(PAnsiChar(NameAsAnsiString));
  try
    SOMClass(NewClass).somFindMethod(NameAsSomId, Result);
  finally
    SOMMemFree(NameAsSomId);
  end;
end;

class function ObjectMgr.NewInstance: ObjectMgr; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
begin
  Result := ObjectMgr(SOMClass(NewClass).somNewNoInit);
end;

function ObjectMgr.Clone: ObjectMgr; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
begin
  Result := ObjectMgr(SOMClass(somGetClass).somNewNoInit);
  SOMObject(Result).somDefaultCopyInit(somInitCtrl(nil^), SOMObject(Self));
end;

(*
 * New Method: somdNewObject
 *)
type
  somTD_ObjectMgr_somdNewObject = function(somSelf: SOMObjectBase{ObjectMgr}; ev: PEnvironment; objclass: CORBAString; hints: CORBAString): SOMObject; stdcall;

function ObjectMgr.somdNewObject(objclass: CORBAString; hints: CORBAString): SOMObject; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PObjectMgrClassDataStructure;
  LocalEnv: Environment;
begin
  cd := ObjectMgrClassData;
  SOM_InitEnvironment(@LocalEnv);
  Result :=
  somTD_ObjectMgr_somdNewObject
   (SOM_Resolve(Self, cd.classObject, cd.somdNewObject))
     (Self, @LocalEnv, objclass, hints);
  SOM_UninitEnvironmentOrRaise(@LocalEnv);
end;

(*
 * New Method: somdGetIdFromObject
 *)
type
  somTD_ObjectMgr_somdGetIdFromObject = function(somSelf: SOMObjectBase{ObjectMgr}; ev: PEnvironment; obj: SOMObject): CORBAString; stdcall;

function ObjectMgr.somdGetIdFromObject(obj: SOMObject): CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PObjectMgrClassDataStructure;
  LocalEnv: Environment;
begin
  cd := ObjectMgrClassData;
  SOM_InitEnvironment(@LocalEnv);
  Result :=
  somTD_ObjectMgr_somdGetIdFromObject
   (SOM_Resolve(Self, cd.classObject, cd.somdGetIdFromObject))
     (Self, @LocalEnv, obj);
  SOM_UninitEnvironmentOrRaise(@LocalEnv);
end;

(*
 * New Method: somdGetObjectFromId
 *)
type
  somTD_ObjectMgr_somdGetObjectFromId = function(somSelf: SOMObjectBase{ObjectMgr}; ev: PEnvironment; id: CORBAString): SOMObject; stdcall;

function ObjectMgr.somdGetObjectFromId(id: CORBAString): SOMObject; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PObjectMgrClassDataStructure;
  LocalEnv: Environment;
begin
  cd := ObjectMgrClassData;
  SOM_InitEnvironment(@LocalEnv);
  Result :=
  somTD_ObjectMgr_somdGetObjectFromId
   (SOM_Resolve(Self, cd.classObject, cd.somdGetObjectFromId))
     (Self, @LocalEnv, id);
  SOM_UninitEnvironmentOrRaise(@LocalEnv);
end;

(*
 * New Method: somdReleaseObject
 *)
type
  somTD_ObjectMgr_somdReleaseObject = procedure(somSelf: SOMObjectBase{ObjectMgr}; ev: PEnvironment; obj: SOMObject); stdcall;

procedure ObjectMgr.somdReleaseObject(obj: SOMObject); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PObjectMgrClassDataStructure;
  LocalEnv: Environment;
begin
  cd := ObjectMgrClassData;
  SOM_InitEnvironment(@LocalEnv);
  somTD_ObjectMgr_somdReleaseObject
   (SOM_Resolve(Self, cd.classObject, cd.somdReleaseObject))
     (Self, @LocalEnv, obj);
  SOM_UninitEnvironmentOrRaise(@LocalEnv);
end;

(*
 * New Method: somdDestroyObject
 *)
type
  somTD_ObjectMgr_somdDestroyObject = procedure(somSelf: SOMObjectBase{ObjectMgr}; ev: PEnvironment; obj: SOMObject); stdcall;

procedure ObjectMgr.somdDestroyObject(obj: SOMObject); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PObjectMgrClassDataStructure;
  LocalEnv: Environment;
begin
  cd := ObjectMgrClassData;
  SOM_InitEnvironment(@LocalEnv);
  somTD_ObjectMgr_somdDestroyObject
   (SOM_Resolve(Self, cd.classObject, cd.somdDestroyObject))
     (Self, @LocalEnv, obj);
  SOM_UninitEnvironmentOrRaise(@LocalEnv);
end;

procedure ObjectMgr.somDefaultInit(var ctrl: Pointer); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somDefaultInit
   (SOM_Resolve(Self, cd.classObject, cd.somDefaultInit))
     (Self, ctrl);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

procedure ObjectMgr.somDestruct(doFree: Byte; var ctrl: Pointer); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somDestruct
   (SOM_Resolve(Self, cd.classObject, cd.somDestruct))
     (Self, doFree, ctrl);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

procedure ObjectMgr.somDefaultCopyInit(var ctrl: Pointer; fromObj: ObjectMgr); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somDefaultCopyInit
   (SOM_Resolve(Self, cd.classObject, cd.somDefaultCopyInit))
     (Self, ctrl, fromObj);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function ObjectMgr.somDefaultAssign(var ctrl: Pointer; fromObj: ObjectMgr): ObjectMgr; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result := ObjectMgr(
  somTD_SOMObject_somDefaultAssign
   (SOM_Resolve(Self, cd.classObject, cd.somDefaultAssign))
     (Self, ctrl, fromObj));
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

procedure ObjectMgr.somDefaultConstCopyInit(var ctrl: Pointer; fromObj: ObjectMgr); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somDefaultConstCopyInit
   (SOM_Resolve(Self, cd.classObject, cd.somDefaultConstCopyInit))
     (Self, ctrl, fromObj);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

procedure ObjectMgr.somDefaultVCopyInit(var ctrl: Pointer; fromObj: ObjectMgr); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somDefaultVCopyInit
   (SOM_Resolve(Self, cd.classObject, cd.somDefaultVCopyInit))
     (Self, ctrl, fromObj);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

procedure ObjectMgr.somDefaultConstVCopyInit(var ctrl: Pointer; fromObj: ObjectMgr); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somDefaultConstVCopyInit
   (SOM_Resolve(Self, cd.classObject, cd.somDefaultConstVCopyInit))
     (Self, ctrl, fromObj);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function ObjectMgr.somDefaultConstAssign(var ctrl: Pointer; fromObj: ObjectMgr): ObjectMgr; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result := ObjectMgr(
  somTD_SOMObject_somDefaultConstAssign
   (SOM_Resolve(Self, cd.classObject, cd.somDefaultConstAssign))
     (Self, ctrl, fromObj));
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function ObjectMgr.somDefaultVAssign(var ctrl: Pointer; fromObj: ObjectMgr): ObjectMgr; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result := ObjectMgr(
  somTD_SOMObject_somDefaultVAssign
   (SOM_Resolve(Self, cd.classObject, cd.somDefaultVAssign))
     (Self, ctrl, fromObj));
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function ObjectMgr.somDefaultConstVAssign(var ctrl: Pointer; fromObj: ObjectMgr): ObjectMgr; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result := ObjectMgr(
  somTD_SOMObject_somDefaultConstVAssign
   (SOM_Resolve(Self, cd.classObject, cd.somDefaultConstVAssign))
     (Self, ctrl, fromObj));
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

procedure ObjectMgr.somInit; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somInit
   (SOM_Resolve(Self, cd.classObject, cd.somInit))
     (Self);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

procedure ObjectMgr.somFree; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somFree
   (SOM_Resolve(Self, cd.classObject, cd.somFree))
     (Self);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

procedure ObjectMgr.somUninit; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somUninit
   (SOM_Resolve(Self, cd.classObject, cd.somUninit))
     (Self);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function ObjectMgr.somGetClass: SOMMSingleInstance; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result := SOMMSingleInstance(
  somTD_SOMObject_somGetClass
   (SOM_Resolve(Self, cd.classObject, cd.somGetClass))
     (Self));
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function ObjectMgr.somGetClassName: {dual_owned} CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result :=
  somTD_SOMObject_somGetClassName
   (SOM_Resolve(Self, cd.classObject, cd.somGetClassName))
     (Self);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function ObjectMgr.somGetSize: LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result :=
  somTD_SOMObject_somGetSize
   (SOM_Resolve(Self, cd.classObject, cd.somGetSize))
     (Self);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function ObjectMgr.somIsA(aClassObj: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result :=
  somTD_SOMObject_somIsA
   (SOM_Resolve(Self, cd.classObject, cd.somIsA))
     (Self, aClassObj);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function ObjectMgr.somIsInstanceOf(aClassObj: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result :=
  somTD_SOMObject_somIsInstanceOf
   (SOM_Resolve(Self, cd.classObject, cd.somIsInstanceOf))
     (Self, aClassObj);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function ObjectMgr.somRespondsTo(mId: somId): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result :=
  somTD_SOMObject_somRespondsTo
   (SOM_Resolve(Self, cd.classObject, cd.somRespondsTo))
     (Self, mId);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function ObjectMgr.somDispatch(out retValue: Pointer; methodId: somId; ap: va_list): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result :=
  somTD_SOMObject_somDispatch
   (SOM_Resolve(Self, cd.classObject, cd.somDispatch))
     (Self, retValue, methodId, ap);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function ObjectMgr.somClassDispatch(clsObj: SOMClass; out retValue: Pointer; methodId: somId; ap: va_list): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result :=
  somTD_SOMObject_somClassDispatch
   (SOM_Resolve(Self, cd.classObject, cd.somClassDispatch))
     (Self, clsObj, retValue, methodId, ap);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function ObjectMgr.somCastObj(cls: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result :=
  somTD_SOMObject_somCastObj
   (SOM_Resolve(Self, cd.classObject, cd.somCastObj))
     (Self, cls);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function ObjectMgr.somResetObj: CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result :=
  somTD_SOMObject_somResetObj
   (SOM_Resolve(Self, cd.classObject, cd.somResetObj))
     (Self);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function ObjectMgr.somPrintSelf: ObjectMgr; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result := ObjectMgr(
  somTD_SOMObject_somPrintSelf
   (SOM_Resolve(Self, cd.classObject, cd.somPrintSelf))
     (Self));
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

procedure ObjectMgr.somDumpSelf(level: LongInt); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somDumpSelf
   (SOM_Resolve(Self, cd.classObject, cd.somDumpSelf))
     (Self, level);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

procedure ObjectMgr.somDumpSelfInt(level: LongInt); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somDumpSelfInt
   (SOM_Resolve(Self, cd.classObject, cd.somDumpSelfInt))
     (Self, level);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

class function ObjectMgr.ClassObject: SOMMSingleInstance; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
begin
  if Self = ObjectMgr then { invoked on class name literal }
  begin
    Result := SOMMSingleInstance(ObjectMgrClassData.classObject);
  end
  else { invoked on SOM object }
  begin
    Result := SOMMSingleInstance(PPointer(Self)^);
  end
end;

class function ObjectMgr.NewClass: SOMMSingleInstance;
begin
  if Self = ObjectMgr then { invoked on class name literal }
  begin
    Result := SOMMSingleInstance(ObjectMgrClassData.classObject);
    if not Assigned(Result) then Result := SOMMSingleInstance(ObjectMgrNewClass);
  end
  else { invoked on SOM object }
  begin
    Result := SOMMSingleInstance(PPointer(Self)^);
  end
end;

function ObjectMgr.As_ObjectMgr: ObjectMgr; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
begin
  Result := Self;
end;

class function ObjectMgr.Supports(Instance: SOMObjectBase): Boolean;
var
  cls: SOMClass;
begin
  if not Assigned(Instance) then
  begin
    Result := False;
  end
  else
  begin
    cls := SOMClass(ClassObject);
    if not Assigned(cls) then
    begin
      Result := False;
    end
    else
    begin
      Result := SOMObject(Instance).somIsA(cls);
    end;
  end;
end;

class function ObjectMgr.Supports(Instance: SOMObjectBase; out Obj: ObjectMgr): Boolean;
var
  cls: SOMClass;
begin
  if not Assigned(Instance) then
  begin
    Result := False;
    Obj := nil;
  end
  else
  begin
    cls := SOMClass(ClassObject);
    if not Assigned(cls) then
    begin
      Result := False;
      Obj := nil;
    end
    else if SOMObject(Instance).somIsA(cls) then
    begin
      Result := True;
      Obj := ObjectMgr(Instance);
    end
    else
    begin
      Result := False;
      Obj := nil;
    end;
  end;
end;

const
  OperationDef_MajorVersion = 2;
  OperationDef_MinorVersion = 1;

(*
 * Declare the class creation procedure
 *)
function OperationDefNewClass(
  somtmajorVersion: integer4 = OperationDef_MajorVersion;
  somtminorVersion: integer4 = OperationDef_MinorVersion):
  SOMClass; stdcall; external SOMIR_DLL_Name name 'OperationDefNewClass';

(*
 * Declare the ABI 2 ClassData structure
 *)
type
  OperationDefClassDataStructure = packed record
    classObject: SOMClass;
    _get_result,
    _set_result,
    _get_mode,
    _set_mode,
    _get_contexts,
    _set_contexts: somMToken;
  end;
  POperationDefClassDataStructure = ^OperationDefClassDataStructure;

var
  SOMIR_DLL_OperationDefClassData: POperationDefClassDataStructure = nil;

function OperationDefClassData: POperationDefClassDataStructure;
begin
  if Assigned(SOMIR_DLL_OperationDefClassData) then
    Result := SOMIR_DLL_OperationDefClassData
  else
  begin
    SOMIR_DLL_Load_Variable(SOMIR_DLL_OperationDefClassData, 'OperationDefClassData');
    Result := SOMIR_DLL_OperationDefClassData;
  end;
end;

(*
 * Declare the ABI 2 CClassData structure
 *)
type
  OperationDefCClassDataStructure = packed record
    parentMtab: somMethodTabs;
    instanceDataToken: somDToken;
  end;
  POperationDefCClassDataStructure = ^OperationDefCClassDataStructure;

var
  SOMIR_DLL_OperationDefCClassData: POperationDefCClassDataStructure = nil;

function OperationDefCClassData: POperationDefCClassDataStructure;
begin
  if Assigned(SOMIR_DLL_OperationDefCClassData) then
    Result := SOMIR_DLL_OperationDefCClassData
  else
  begin
    SOMIR_DLL_Load_Variable(SOMIR_DLL_OperationDefCClassData, 'OperationDefCClassData');
    Result := SOMIR_DLL_OperationDefCClassData;
  end;
end;

(*
 * Class Object and Method Token Macros
 *)

(*
 * New Method: _get_result
 *)
type
  somTD_OperationDef__get_result = function(somSelf: SOMObjectBase{OperationDef}; ev: PEnvironment): TypeCode; stdcall;

function OperationDef._get_result: TypeCode; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: POperationDefClassDataStructure;
  LocalEnv: Environment;
begin
  cd := OperationDefClassData;
  SOM_InitEnvironment(@LocalEnv);
  Result :=
  somTD_OperationDef__get_result
   (SOM_Resolve(Self, cd.classObject, cd._get_result))
     (Self, @LocalEnv);
  SOM_UninitEnvironmentOrRaise(@LocalEnv);
end;

(*
 * New Method: _set_result
 *)
type
  somTD_OperationDef__set_result = procedure(somSelf: SOMObjectBase{OperationDef}; ev: PEnvironment; SOM_result: TypeCode); stdcall;

procedure OperationDef._set_result(SOM_result: TypeCode); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: POperationDefClassDataStructure;
  LocalEnv: Environment;
begin
  cd := OperationDefClassData;
  SOM_InitEnvironment(@LocalEnv);
  somTD_OperationDef__set_result
   (SOM_Resolve(Self, cd.classObject, cd._set_result))
     (Self, @LocalEnv, SOM_result);
  SOM_UninitEnvironmentOrRaise(@LocalEnv);
end;

(*
 * New Method: _get_mode
 *)
type
  somTD_OperationDef__get_mode = function(somSelf: SOMObjectBase{OperationDef}; ev: PEnvironment): OperationDef_OperationMode; stdcall;

function OperationDef._get_mode: OperationDef_OperationMode; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: POperationDefClassDataStructure;
  LocalEnv: Environment;
begin
  cd := OperationDefClassData;
  SOM_InitEnvironment(@LocalEnv);
  Result :=
  somTD_OperationDef__get_mode
   (SOM_Resolve(Self, cd.classObject, cd._get_mode))
     (Self, @LocalEnv);
  SOM_UninitEnvironmentOrRaise(@LocalEnv);
end;

(*
 * New Method: _set_mode
 *)
type
  somTD_OperationDef__set_mode = procedure(somSelf: SOMObjectBase{OperationDef}; ev: PEnvironment; mode: OperationDef_OperationMode); stdcall;

procedure OperationDef._set_mode(mode: OperationDef_OperationMode); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: POperationDefClassDataStructure;
  LocalEnv: Environment;
begin
  cd := OperationDefClassData;
  SOM_InitEnvironment(@LocalEnv);
  somTD_OperationDef__set_mode
   (SOM_Resolve(Self, cd.classObject, cd._set_mode))
     (Self, @LocalEnv, mode);
  SOM_UninitEnvironmentOrRaise(@LocalEnv);
end;

(*
 * New Method: _get_contexts
 *)
type
  somTD_OperationDef__get_contexts = function(somSelf: SOMObjectBase{OperationDef}; ev: PEnvironment): _IDL_Sequence_CORBAString; stdcall;

function OperationDef._get_contexts: _IDL_Sequence_CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: POperationDefClassDataStructure;
  LocalEnv: Environment;
begin
  cd := OperationDefClassData;
  SOM_InitEnvironment(@LocalEnv);
  Result :=
  somTD_OperationDef__get_contexts
   (SOM_Resolve(Self, cd.classObject, cd._get_contexts))
     (Self, @LocalEnv);
  SOM_UninitEnvironmentOrRaise(@LocalEnv);
end;

(*
 * New Method: _set_contexts
 *)
type
  somTD_OperationDef__set_contexts = procedure(somSelf: SOMObjectBase{OperationDef}; ev: PEnvironment; const contexts: _IDL_Sequence_CORBAString); stdcall;

procedure OperationDef._set_contexts(const contexts: _IDL_Sequence_CORBAString); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: POperationDefClassDataStructure;
  LocalEnv: Environment;
begin
  cd := OperationDefClassData;
  SOM_InitEnvironment(@LocalEnv);
  somTD_OperationDef__set_contexts
   (SOM_Resolve(Self, cd.classObject, cd._set_contexts))
     (Self, @LocalEnv, contexts);
  SOM_UninitEnvironmentOrRaise(@LocalEnv);
end;

function OperationDef._get_name: CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PContainedClassDataStructure;
  LocalEnv: Environment;
begin
  cd := ContainedClassData;
  SOM_InitEnvironment(@LocalEnv);
  Result :=
  somTD_Contained__get_name
   (SOM_Resolve(Self, cd.classObject, cd._get_name))
     (Self, @LocalEnv);
  SOM_UninitEnvironmentOrRaise(@LocalEnv);
end;

procedure OperationDef._set_name(name: {caller_owns} CORBAString); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PContainedClassDataStructure;
  LocalEnv: Environment;
begin
  cd := ContainedClassData;
  SOM_InitEnvironment(@LocalEnv);
  somTD_Contained__set_name
   (SOM_Resolve(Self, cd.classObject, cd._set_name))
     (Self, @LocalEnv, name);
  SOM_UninitEnvironmentOrRaise(@LocalEnv);
end;

function OperationDef._get_id: CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PContainedClassDataStructure;
  LocalEnv: Environment;
begin
  cd := ContainedClassData;
  SOM_InitEnvironment(@LocalEnv);
  Result :=
  somTD_Contained__get_id
   (SOM_Resolve(Self, cd.classObject, cd._get_id))
     (Self, @LocalEnv);
  SOM_UninitEnvironmentOrRaise(@LocalEnv);
end;

procedure OperationDef._set_id(id: {caller_owns} CORBAString); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PContainedClassDataStructure;
  LocalEnv: Environment;
begin
  cd := ContainedClassData;
  SOM_InitEnvironment(@LocalEnv);
  somTD_Contained__set_id
   (SOM_Resolve(Self, cd.classObject, cd._set_id))
     (Self, @LocalEnv, id);
  SOM_UninitEnvironmentOrRaise(@LocalEnv);
end;

function OperationDef._get_defined_in: CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PContainedClassDataStructure;
  LocalEnv: Environment;
begin
  cd := ContainedClassData;
  SOM_InitEnvironment(@LocalEnv);
  Result :=
  somTD_Contained__get_defined_in
   (SOM_Resolve(Self, cd.classObject, cd._get_defined_in))
     (Self, @LocalEnv);
  SOM_UninitEnvironmentOrRaise(@LocalEnv);
end;

procedure OperationDef._set_defined_in(defined_in: {caller_owns} CORBAString); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PContainedClassDataStructure;
  LocalEnv: Environment;
begin
  cd := ContainedClassData;
  SOM_InitEnvironment(@LocalEnv);
  somTD_Contained__set_defined_in
   (SOM_Resolve(Self, cd.classObject, cd._set_defined_in))
     (Self, @LocalEnv, defined_in);
  SOM_UninitEnvironmentOrRaise(@LocalEnv);
end;

function OperationDef._get_somModifiers: _IDL_Sequence_somModifier; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PContainedClassDataStructure;
  LocalEnv: Environment;
begin
  cd := ContainedClassData;
  SOM_InitEnvironment(@LocalEnv);
  Result :=
  somTD_Contained__get_somModifiers
   (SOM_Resolve(Self, cd.classObject, cd._get_somModifiers))
     (Self, @LocalEnv);
  SOM_UninitEnvironmentOrRaise(@LocalEnv);
end;

procedure OperationDef._set_somModifiers(const somModifiers: {caller_owns} _IDL_Sequence_somModifier); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PContainedClassDataStructure;
  LocalEnv: Environment;
begin
  cd := ContainedClassData;
  SOM_InitEnvironment(@LocalEnv);
  somTD_Contained__set_somModifiers
   (SOM_Resolve(Self, cd.classObject, cd._set_somModifiers))
     (Self, @LocalEnv, somModifiers);
  SOM_UninitEnvironmentOrRaise(@LocalEnv);
end;

class function OperationDef.Create: OperationDef; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
begin
  Result := OperationDef(SOMClass(NewClass).somNew);
end;

class function OperationDef.InitInstance(Instance: Pointer): OperationDef; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
begin
  Result := OperationDef(SOMClass(NewClass).somRenewNoInit(Instance));
end;

function OperationDef.ClassType: SOMClass; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
begin
  Result := SOMClass(SOMObject(Self).somGetClass);
end;

class function OperationDef.ClassName: string;
begin
  Result := AnsiString(SOMClass(NewClass).somGetName);
end;

class function OperationDef.ClassNameIs(const Name: string): Boolean;
begin
  Result := AnsiString(SOMClass(NewClass).somGetName) = Name;
end;

class function OperationDef.InstanceSize: LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
begin
  Result := SOMClass(NewClass).somGetInstanceSize;
end;

class function OperationDef.InheritsFrom(AClass: SOMClass): Boolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
begin
  Result := SOMClass(NewClass).somDescendedFrom(AClass);
end;

class function OperationDef.MethodAddress(const Name: string): Pointer;
var
  NameAsAnsiString: AnsiString;
  NameAsSomId: somId;
begin
  NameAsAnsiString := AnsiString(Name);
  NameAsSomId := somIdFromString(PAnsiChar(NameAsAnsiString));
  try
    SOMClass(NewClass).somFindMethod(NameAsSomId, Result);
  finally
    SOMMemFree(NameAsSomId);
  end;
end;

class function OperationDef.NewInstance: OperationDef; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
begin
  Result := OperationDef(SOMClass(NewClass).somNewNoInit);
end;

function OperationDef.Clone: OperationDef; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
begin
  Result := OperationDef(SOMClass(somGetClass).somNewNoInit);
  SOMObject(Result).somDefaultCopyInit(somInitCtrl(nil^), SOMObject(Self));
end;

function OperationDef.within: _IDL_Sequence_Container; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PContainedClassDataStructure;
  LocalEnv: Environment;
begin
  cd := ContainedClassData;
  SOM_InitEnvironment(@LocalEnv);
  Result :=
  somTD_Contained_within
   (SOM_Resolve(Self, cd.classObject, cd.within))
     (Self, @LocalEnv);
  SOM_UninitEnvironmentOrRaise(@LocalEnv);
end;

function OperationDef.describe: Contained_Description; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PContainedClassDataStructure;
  LocalEnv: Environment;
begin
  cd := ContainedClassData;
  SOM_InitEnvironment(@LocalEnv);
  Result :=
  somTD_Contained_describe
   (SOM_Resolve(Self, cd.classObject, cd.describe))
     (Self, @LocalEnv);
  SOM_UninitEnvironmentOrRaise(@LocalEnv);
end;

procedure OperationDef.somDefaultInit(var ctrl: Pointer); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somDefaultInit
   (SOM_Resolve(Self, cd.classObject, cd.somDefaultInit))
     (Self, ctrl);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

procedure OperationDef.somDestruct(doFree: Byte; var ctrl: Pointer); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somDestruct
   (SOM_Resolve(Self, cd.classObject, cd.somDestruct))
     (Self, doFree, ctrl);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

procedure OperationDef.somDefaultCopyInit(var ctrl: Pointer; fromObj: OperationDef); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somDefaultCopyInit
   (SOM_Resolve(Self, cd.classObject, cd.somDefaultCopyInit))
     (Self, ctrl, fromObj);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function OperationDef.somDefaultAssign(var ctrl: Pointer; fromObj: OperationDef): OperationDef; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result := OperationDef(
  somTD_SOMObject_somDefaultAssign
   (SOM_Resolve(Self, cd.classObject, cd.somDefaultAssign))
     (Self, ctrl, fromObj));
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

procedure OperationDef.somDefaultConstCopyInit(var ctrl: Pointer; fromObj: OperationDef); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somDefaultConstCopyInit
   (SOM_Resolve(Self, cd.classObject, cd.somDefaultConstCopyInit))
     (Self, ctrl, fromObj);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

procedure OperationDef.somDefaultVCopyInit(var ctrl: Pointer; fromObj: OperationDef); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somDefaultVCopyInit
   (SOM_Resolve(Self, cd.classObject, cd.somDefaultVCopyInit))
     (Self, ctrl, fromObj);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

procedure OperationDef.somDefaultConstVCopyInit(var ctrl: Pointer; fromObj: OperationDef); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somDefaultConstVCopyInit
   (SOM_Resolve(Self, cd.classObject, cd.somDefaultConstVCopyInit))
     (Self, ctrl, fromObj);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function OperationDef.somDefaultConstAssign(var ctrl: Pointer; fromObj: OperationDef): OperationDef; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result := OperationDef(
  somTD_SOMObject_somDefaultConstAssign
   (SOM_Resolve(Self, cd.classObject, cd.somDefaultConstAssign))
     (Self, ctrl, fromObj));
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function OperationDef.somDefaultVAssign(var ctrl: Pointer; fromObj: OperationDef): OperationDef; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result := OperationDef(
  somTD_SOMObject_somDefaultVAssign
   (SOM_Resolve(Self, cd.classObject, cd.somDefaultVAssign))
     (Self, ctrl, fromObj));
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function OperationDef.somDefaultConstVAssign(var ctrl: Pointer; fromObj: OperationDef): OperationDef; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result := OperationDef(
  somTD_SOMObject_somDefaultConstVAssign
   (SOM_Resolve(Self, cd.classObject, cd.somDefaultConstVAssign))
     (Self, ctrl, fromObj));
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

procedure OperationDef.somInit; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somInit
   (SOM_Resolve(Self, cd.classObject, cd.somInit))
     (Self);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

procedure OperationDef.somFree; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somFree
   (SOM_Resolve(Self, cd.classObject, cd.somFree))
     (Self);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

procedure OperationDef.somUninit; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somUninit
   (SOM_Resolve(Self, cd.classObject, cd.somUninit))
     (Self);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function OperationDef.somGetClass: SOMClass; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result := SOMClass(
  somTD_SOMObject_somGetClass
   (SOM_Resolve(Self, cd.classObject, cd.somGetClass))
     (Self));
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function OperationDef.somGetClassName: {dual_owned} CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result :=
  somTD_SOMObject_somGetClassName
   (SOM_Resolve(Self, cd.classObject, cd.somGetClassName))
     (Self);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function OperationDef.somGetSize: LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result :=
  somTD_SOMObject_somGetSize
   (SOM_Resolve(Self, cd.classObject, cd.somGetSize))
     (Self);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function OperationDef.somIsA(aClassObj: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result :=
  somTD_SOMObject_somIsA
   (SOM_Resolve(Self, cd.classObject, cd.somIsA))
     (Self, aClassObj);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function OperationDef.somIsInstanceOf(aClassObj: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result :=
  somTD_SOMObject_somIsInstanceOf
   (SOM_Resolve(Self, cd.classObject, cd.somIsInstanceOf))
     (Self, aClassObj);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function OperationDef.somRespondsTo(mId: somId): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result :=
  somTD_SOMObject_somRespondsTo
   (SOM_Resolve(Self, cd.classObject, cd.somRespondsTo))
     (Self, mId);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function OperationDef.somDispatch(out retValue: Pointer; methodId: somId; ap: va_list): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result :=
  somTD_SOMObject_somDispatch
   (SOM_Resolve(Self, cd.classObject, cd.somDispatch))
     (Self, retValue, methodId, ap);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function OperationDef.somClassDispatch(clsObj: SOMClass; out retValue: Pointer; methodId: somId; ap: va_list): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result :=
  somTD_SOMObject_somClassDispatch
   (SOM_Resolve(Self, cd.classObject, cd.somClassDispatch))
     (Self, clsObj, retValue, methodId, ap);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function OperationDef.somCastObj(cls: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result :=
  somTD_SOMObject_somCastObj
   (SOM_Resolve(Self, cd.classObject, cd.somCastObj))
     (Self, cls);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function OperationDef.somResetObj: CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result :=
  somTD_SOMObject_somResetObj
   (SOM_Resolve(Self, cd.classObject, cd.somResetObj))
     (Self);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function OperationDef.somPrintSelf: OperationDef; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result := OperationDef(
  somTD_SOMObject_somPrintSelf
   (SOM_Resolve(Self, cd.classObject, cd.somPrintSelf))
     (Self));
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

procedure OperationDef.somDumpSelf(level: LongInt); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somDumpSelf
   (SOM_Resolve(Self, cd.classObject, cd.somDumpSelf))
     (Self, level);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

procedure OperationDef.somDumpSelfInt(level: LongInt); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somDumpSelfInt
   (SOM_Resolve(Self, cd.classObject, cd.somDumpSelfInt))
     (Self, level);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function OperationDef.contents(limit_type: CORBAString; exclude_inherited: CORBABoolean): {caller_owns} _IDL_Sequence_Contained; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PContainerClassDataStructure;
  LocalEnv: Environment;
begin
  cd := ContainerClassData;
  SOM_InitEnvironment(@LocalEnv);
  Result :=
  somTD_Container_contents
   (SOM_Resolve(Self, cd.classObject, cd.contents))
     (Self, @LocalEnv, limit_type, exclude_inherited);
  SOM_UninitEnvironmentOrRaise(@LocalEnv);
end;

function OperationDef.lookup_name(search_name: {caller_owns} CORBAString; levels_to_search: LongInt; limit_type: CORBAString; exclude_inherited: CORBABoolean): {caller_owns} _IDL_Sequence_Contained; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PContainerClassDataStructure;
  LocalEnv: Environment;
begin
  cd := ContainerClassData;
  SOM_InitEnvironment(@LocalEnv);
  Result :=
  somTD_Container_lookup_name
   (SOM_Resolve(Self, cd.classObject, cd.lookup_name))
     (Self, @LocalEnv, search_name, levels_to_search, limit_type, exclude_inherited);
  SOM_UninitEnvironmentOrRaise(@LocalEnv);
end;

function OperationDef.describe_contents(limit_type: CORBAString; exclude_inherited: CORBABoolean; max_returned_objs: LongInt): _IDL_Sequence_Container_ContainerDescription; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PContainerClassDataStructure;
  LocalEnv: Environment;
begin
  cd := ContainerClassData;
  SOM_InitEnvironment(@LocalEnv);
  Result :=
  somTD_Container_describe_contents
   (SOM_Resolve(Self, cd.classObject, cd.describe_contents))
     (Self, @LocalEnv, limit_type, exclude_inherited, max_returned_objs);
  SOM_UninitEnvironmentOrRaise(@LocalEnv);
end;

class function OperationDef.ClassObject: SOMClass; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
begin
  if Self = OperationDef then { invoked on class name literal }
  begin
    Result := SOMClass(OperationDefClassData.classObject);
  end
  else { invoked on SOM object }
  begin
    Result := SOMClass(PPointer(Self)^);
  end
end;

class function OperationDef.NewClass: SOMClass;
begin
  if Self = OperationDef then { invoked on class name literal }
  begin
    Result := SOMClass(OperationDefClassData.classObject);
    if not Assigned(Result) then Result := SOMClass(OperationDefNewClass);
  end
  else { invoked on SOM object }
  begin
    Result := SOMClass(PPointer(Self)^);
  end
end;

function OperationDef.As_Contained: Contained; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
begin
  Result := Contained(Self);
end;

function OperationDef.As_Container: Container; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
begin
  Result := Container(Self);
end;

function OperationDef.As_OperationDef: OperationDef; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
begin
  Result := Self;
end;

class function OperationDef.Supports(Instance: SOMObjectBase): Boolean;
var
  cls: SOMClass;
begin
  if not Assigned(Instance) then
  begin
    Result := False;
  end
  else
  begin
    cls := SOMClass(ClassObject);
    if not Assigned(cls) then
    begin
      Result := False;
    end
    else
    begin
      Result := SOMObject(Instance).somIsA(cls);
    end;
  end;
end;

class function OperationDef.Supports(Instance: SOMObjectBase; out Obj: OperationDef): Boolean;
var
  cls: SOMClass;
begin
  if not Assigned(Instance) then
  begin
    Result := False;
    Obj := nil;
  end
  else
  begin
    cls := SOMClass(ClassObject);
    if not Assigned(cls) then
    begin
      Result := False;
      Obj := nil;
    end
    else if SOMObject(Instance).somIsA(cls) then
    begin
      Result := True;
      Obj := OperationDef(Instance);
    end
    else
    begin
      Result := False;
      Obj := nil;
    end;
  end;
end;

const
  ORB_MajorVersion = 2;
  ORB_MinorVersion = 1;

(*
 * Declare the class creation procedure
 *)
function ORBNewClass(
  somtmajorVersion: integer4 = ORB_MajorVersion;
  somtminorVersion: integer4 = ORB_MinorVersion):
  SOMClass; stdcall; external SOMD_DLL_Name name 'ORBNewClass';

(*
 * Declare the ABI 2 ClassData structure
 *)
type
  ORBClassDataStructure = packed record
    classObject: SOMClass;
    object_to_string,
    string_to_object,
    create_list,
    create_operation_list,
    get_default_context,
    object_to_binary,
    binary_to_object: somMToken;
  end;
  PORBClassDataStructure = ^ORBClassDataStructure;

var
  SOMD_DLL_ORBClassData: PORBClassDataStructure = nil;

function ORBClassData: PORBClassDataStructure;
begin
  if Assigned(SOMD_DLL_ORBClassData) then
    Result := SOMD_DLL_ORBClassData
  else
  begin
    SOMD_DLL_Load_Variable(SOMD_DLL_ORBClassData, 'ORBClassData');
    Result := SOMD_DLL_ORBClassData;
  end;
end;

(*
 * Declare the ABI 2 CClassData structure
 *)
type
  ORBCClassDataStructure = packed record
    parentMtab: somMethodTabs;
    instanceDataToken: somDToken;
  end;
  PORBCClassDataStructure = ^ORBCClassDataStructure;

var
  SOMD_DLL_ORBCClassData: PORBCClassDataStructure = nil;

function ORBCClassData: PORBCClassDataStructure;
begin
  if Assigned(SOMD_DLL_ORBCClassData) then
    Result := SOMD_DLL_ORBCClassData
  else
  begin
    SOMD_DLL_Load_Variable(SOMD_DLL_ORBCClassData, 'ORBCClassData');
    Result := SOMD_DLL_ORBCClassData;
  end;
end;

(*
 * Class Object and Method Token Macros
 *)

class function ORB.Create: ORB; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
begin
  Result := ORB(SOMClass(NewClass).somNew);
end;

class function ORB.InitInstance(Instance: Pointer): ORB; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
begin
  Result := ORB(SOMClass(NewClass).somRenewNoInit(Instance));
end;

function ORB.ClassType: SOMMSingleInstance; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
begin
  Result := SOMMSingleInstance(SOMObject(Self).somGetClass);
end;

class function ORB.ClassName: string;
begin
  Result := AnsiString(SOMClass(NewClass).somGetName);
end;

class function ORB.ClassNameIs(const Name: string): Boolean;
begin
  Result := AnsiString(SOMClass(NewClass).somGetName) = Name;
end;

class function ORB.InstanceSize: LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
begin
  Result := SOMClass(NewClass).somGetInstanceSize;
end;

class function ORB.InheritsFrom(AClass: SOMClass): Boolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
begin
  Result := SOMClass(NewClass).somDescendedFrom(AClass);
end;

class function ORB.MethodAddress(const Name: string): Pointer;
var
  NameAsAnsiString: AnsiString;
  NameAsSomId: somId;
begin
  NameAsAnsiString := AnsiString(Name);
  NameAsSomId := somIdFromString(PAnsiChar(NameAsAnsiString));
  try
    SOMClass(NewClass).somFindMethod(NameAsSomId, Result);
  finally
    SOMMemFree(NameAsSomId);
  end;
end;

class function ORB.NewInstance: ORB; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
begin
  Result := ORB(SOMClass(NewClass).somNewNoInit);
end;

function ORB.Clone: ORB; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
begin
  Result := ORB(SOMClass(somGetClass).somNewNoInit);
  SOMObject(Result).somDefaultCopyInit(somInitCtrl(nil^), SOMObject(Self));
end;

(*
 * New Method: object_to_string
 *)
type
  somTD_ORB_object_to_string = function(somSelf: SOMObjectBase{ORB}; ev: PEnvironment; obj: SOMDObject): CORBAString; stdcall;

function ORB.object_to_string(obj: SOMDObject): CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PORBClassDataStructure;
  LocalEnv: Environment;
begin
  cd := ORBClassData;
  SOM_InitEnvironment(@LocalEnv);
  Result :=
  somTD_ORB_object_to_string
   (SOM_Resolve(Self, cd.classObject, cd.object_to_string))
     (Self, @LocalEnv, obj);
  SOM_UninitEnvironmentOrRaise(@LocalEnv);
end;

(*
 * New Method: string_to_object
 *)
type
  somTD_ORB_string_to_object = function(somSelf: SOMObjectBase{ORB}; ev: PEnvironment; str: CORBAString): SOMDObject; stdcall;

function ORB.string_to_object(str: CORBAString): SOMDObject; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PORBClassDataStructure;
  LocalEnv: Environment;
begin
  cd := ORBClassData;
  SOM_InitEnvironment(@LocalEnv);
  Result :=
  somTD_ORB_string_to_object
   (SOM_Resolve(Self, cd.classObject, cd.string_to_object))
     (Self, @LocalEnv, str);
  SOM_UninitEnvironmentOrRaise(@LocalEnv);
end;

(*
 * New Method: create_list
 *)
type
  somTD_ORB_create_list = function(somSelf: SOMObjectBase{ORB}; ev: PEnvironment; count: LongInt; out new_list: NVList): LongWord; stdcall;

function ORB.create_list(count: LongInt; out new_list: NVList): LongWord; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PORBClassDataStructure;
  LocalEnv: Environment;
begin
  cd := ORBClassData;
  SOM_InitEnvironment(@LocalEnv);
  Result :=
  somTD_ORB_create_list
   (SOM_Resolve(Self, cd.classObject, cd.create_list))
     (Self, @LocalEnv, count, new_list);
  SOM_UninitEnvironmentOrRaise(@LocalEnv);
end;

(*
 * New Method: create_operation_list
 *)
type
  somTD_ORB_create_operation_list = function(somSelf: SOMObjectBase{ORB}; ev: PEnvironment; oper: OperationDef; out new_list: NVList): LongWord; stdcall;

function ORB.create_operation_list(oper: OperationDef; out new_list: NVList): LongWord; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PORBClassDataStructure;
  LocalEnv: Environment;
begin
  cd := ORBClassData;
  SOM_InitEnvironment(@LocalEnv);
  Result :=
  somTD_ORB_create_operation_list
   (SOM_Resolve(Self, cd.classObject, cd.create_operation_list))
     (Self, @LocalEnv, oper, new_list);
  SOM_UninitEnvironmentOrRaise(@LocalEnv);
end;

(*
 * New Method: get_default_context
 *)
type
  somTD_ORB_get_default_context = function(somSelf: SOMObjectBase{ORB}; ev: PEnvironment; out ctx: Context): LongWord; stdcall;

function ORB.get_default_context(out ctx: Context): LongWord; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PORBClassDataStructure;
  LocalEnv: Environment;
begin
  cd := ORBClassData;
  SOM_InitEnvironment(@LocalEnv);
  Result :=
  somTD_ORB_get_default_context
   (SOM_Resolve(Self, cd.classObject, cd.get_default_context))
     (Self, @LocalEnv, ctx);
  SOM_UninitEnvironmentOrRaise(@LocalEnv);
end;

procedure ORB.somDefaultInit(var ctrl: Pointer); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somDefaultInit
   (SOM_Resolve(Self, cd.classObject, cd.somDefaultInit))
     (Self, ctrl);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

procedure ORB.somDestruct(doFree: Byte; var ctrl: Pointer); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somDestruct
   (SOM_Resolve(Self, cd.classObject, cd.somDestruct))
     (Self, doFree, ctrl);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

procedure ORB.somDefaultCopyInit(var ctrl: Pointer; fromObj: ORB); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somDefaultCopyInit
   (SOM_Resolve(Self, cd.classObject, cd.somDefaultCopyInit))
     (Self, ctrl, fromObj);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function ORB.somDefaultAssign(var ctrl: Pointer; fromObj: ORB): ORB; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result := ORB(
  somTD_SOMObject_somDefaultAssign
   (SOM_Resolve(Self, cd.classObject, cd.somDefaultAssign))
     (Self, ctrl, fromObj));
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

procedure ORB.somDefaultConstCopyInit(var ctrl: Pointer; fromObj: ORB); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somDefaultConstCopyInit
   (SOM_Resolve(Self, cd.classObject, cd.somDefaultConstCopyInit))
     (Self, ctrl, fromObj);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

procedure ORB.somDefaultVCopyInit(var ctrl: Pointer; fromObj: ORB); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somDefaultVCopyInit
   (SOM_Resolve(Self, cd.classObject, cd.somDefaultVCopyInit))
     (Self, ctrl, fromObj);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

procedure ORB.somDefaultConstVCopyInit(var ctrl: Pointer; fromObj: ORB); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somDefaultConstVCopyInit
   (SOM_Resolve(Self, cd.classObject, cd.somDefaultConstVCopyInit))
     (Self, ctrl, fromObj);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function ORB.somDefaultConstAssign(var ctrl: Pointer; fromObj: ORB): ORB; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result := ORB(
  somTD_SOMObject_somDefaultConstAssign
   (SOM_Resolve(Self, cd.classObject, cd.somDefaultConstAssign))
     (Self, ctrl, fromObj));
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function ORB.somDefaultVAssign(var ctrl: Pointer; fromObj: ORB): ORB; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result := ORB(
  somTD_SOMObject_somDefaultVAssign
   (SOM_Resolve(Self, cd.classObject, cd.somDefaultVAssign))
     (Self, ctrl, fromObj));
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function ORB.somDefaultConstVAssign(var ctrl: Pointer; fromObj: ORB): ORB; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result := ORB(
  somTD_SOMObject_somDefaultConstVAssign
   (SOM_Resolve(Self, cd.classObject, cd.somDefaultConstVAssign))
     (Self, ctrl, fromObj));
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

procedure ORB.somInit; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somInit
   (SOM_Resolve(Self, cd.classObject, cd.somInit))
     (Self);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

procedure ORB.somFree; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somFree
   (SOM_Resolve(Self, cd.classObject, cd.somFree))
     (Self);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

procedure ORB.somUninit; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somUninit
   (SOM_Resolve(Self, cd.classObject, cd.somUninit))
     (Self);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function ORB.somGetClass: SOMMSingleInstance; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result := SOMMSingleInstance(
  somTD_SOMObject_somGetClass
   (SOM_Resolve(Self, cd.classObject, cd.somGetClass))
     (Self));
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function ORB.somGetClassName: {dual_owned} CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result :=
  somTD_SOMObject_somGetClassName
   (SOM_Resolve(Self, cd.classObject, cd.somGetClassName))
     (Self);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function ORB.somGetSize: LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result :=
  somTD_SOMObject_somGetSize
   (SOM_Resolve(Self, cd.classObject, cd.somGetSize))
     (Self);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function ORB.somIsA(aClassObj: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result :=
  somTD_SOMObject_somIsA
   (SOM_Resolve(Self, cd.classObject, cd.somIsA))
     (Self, aClassObj);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function ORB.somIsInstanceOf(aClassObj: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result :=
  somTD_SOMObject_somIsInstanceOf
   (SOM_Resolve(Self, cd.classObject, cd.somIsInstanceOf))
     (Self, aClassObj);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function ORB.somRespondsTo(mId: somId): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result :=
  somTD_SOMObject_somRespondsTo
   (SOM_Resolve(Self, cd.classObject, cd.somRespondsTo))
     (Self, mId);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function ORB.somDispatch(out retValue: Pointer; methodId: somId; ap: va_list): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result :=
  somTD_SOMObject_somDispatch
   (SOM_Resolve(Self, cd.classObject, cd.somDispatch))
     (Self, retValue, methodId, ap);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function ORB.somClassDispatch(clsObj: SOMClass; out retValue: Pointer; methodId: somId; ap: va_list): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result :=
  somTD_SOMObject_somClassDispatch
   (SOM_Resolve(Self, cd.classObject, cd.somClassDispatch))
     (Self, clsObj, retValue, methodId, ap);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function ORB.somCastObj(cls: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result :=
  somTD_SOMObject_somCastObj
   (SOM_Resolve(Self, cd.classObject, cd.somCastObj))
     (Self, cls);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function ORB.somResetObj: CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result :=
  somTD_SOMObject_somResetObj
   (SOM_Resolve(Self, cd.classObject, cd.somResetObj))
     (Self);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function ORB.somPrintSelf: ORB; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result := ORB(
  somTD_SOMObject_somPrintSelf
   (SOM_Resolve(Self, cd.classObject, cd.somPrintSelf))
     (Self));
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

procedure ORB.somDumpSelf(level: LongInt); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somDumpSelf
   (SOM_Resolve(Self, cd.classObject, cd.somDumpSelf))
     (Self, level);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

procedure ORB.somDumpSelfInt(level: LongInt); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somDumpSelfInt
   (SOM_Resolve(Self, cd.classObject, cd.somDumpSelfInt))
     (Self, level);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

class function ORB.ClassObject: SOMMSingleInstance; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
begin
  if Self = ORB then { invoked on class name literal }
  begin
    Result := SOMMSingleInstance(ORBClassData.classObject);
  end
  else { invoked on SOM object }
  begin
    Result := SOMMSingleInstance(PPointer(Self)^);
  end
end;

class function ORB.NewClass: SOMMSingleInstance;
begin
  if Self = ORB then { invoked on class name literal }
  begin
    Result := SOMMSingleInstance(ORBClassData.classObject);
    if not Assigned(Result) then Result := SOMMSingleInstance(ORBNewClass);
  end
  else { invoked on SOM object }
  begin
    Result := SOMMSingleInstance(PPointer(Self)^);
  end
end;

function ORB.As_ORB: ORB; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
begin
  Result := Self;
end;

class function ORB.Supports(Instance: SOMObjectBase): Boolean;
var
  cls: SOMClass;
begin
  if not Assigned(Instance) then
  begin
    Result := False;
  end
  else
  begin
    cls := SOMClass(ClassObject);
    if not Assigned(cls) then
    begin
      Result := False;
    end
    else
    begin
      Result := SOMObject(Instance).somIsA(cls);
    end;
  end;
end;

class function ORB.Supports(Instance: SOMObjectBase; out Obj: ORB): Boolean;
var
  cls: SOMClass;
begin
  if not Assigned(Instance) then
  begin
    Result := False;
    Obj := nil;
  end
  else
  begin
    cls := SOMClass(ClassObject);
    if not Assigned(cls) then
    begin
      Result := False;
      Obj := nil;
    end
    else if SOMObject(Instance).somIsA(cls) then
    begin
      Result := True;
      Obj := ORB(Instance);
    end
    else
    begin
      Result := False;
      Obj := nil;
    end;
  end;
end;

const
  ParameterDef_MajorVersion = 2;
  ParameterDef_MinorVersion = 1;

(*
 * Declare the class creation procedure
 *)
function ParameterDefNewClass(
  somtmajorVersion: integer4 = ParameterDef_MajorVersion;
  somtminorVersion: integer4 = ParameterDef_MinorVersion):
  SOMClass; stdcall; external SOMIR_DLL_Name name 'ParameterDefNewClass';

(*
 * Declare the ABI 2 ClassData structure
 *)
type
  ParameterDefClassDataStructure = packed record
    classObject: SOMClass;
    _get_type,
    _set_type,
    _get_mode,
    _set_mode: somMToken;
  end;
  PParameterDefClassDataStructure = ^ParameterDefClassDataStructure;

var
  SOMIR_DLL_ParameterDefClassData: PParameterDefClassDataStructure = nil;

function ParameterDefClassData: PParameterDefClassDataStructure;
begin
  if Assigned(SOMIR_DLL_ParameterDefClassData) then
    Result := SOMIR_DLL_ParameterDefClassData
  else
  begin
    SOMIR_DLL_Load_Variable(SOMIR_DLL_ParameterDefClassData, 'ParameterDefClassData');
    Result := SOMIR_DLL_ParameterDefClassData;
  end;
end;

(*
 * Declare the ABI 2 CClassData structure
 *)
type
  ParameterDefCClassDataStructure = packed record
    parentMtab: somMethodTabs;
    instanceDataToken: somDToken;
  end;
  PParameterDefCClassDataStructure = ^ParameterDefCClassDataStructure;

var
  SOMIR_DLL_ParameterDefCClassData: PParameterDefCClassDataStructure = nil;

function ParameterDefCClassData: PParameterDefCClassDataStructure;
begin
  if Assigned(SOMIR_DLL_ParameterDefCClassData) then
    Result := SOMIR_DLL_ParameterDefCClassData
  else
  begin
    SOMIR_DLL_Load_Variable(SOMIR_DLL_ParameterDefCClassData, 'ParameterDefCClassData');
    Result := SOMIR_DLL_ParameterDefCClassData;
  end;
end;

(*
 * Class Object and Method Token Macros
 *)

(*
 * New Method: _get_type
 *)
type
  somTD_ParameterDef__get_type = function(somSelf: SOMObjectBase{ParameterDef}; ev: PEnvironment): TypeCode; stdcall;

function ParameterDef._get_type: TypeCode; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PParameterDefClassDataStructure;
  LocalEnv: Environment;
begin
  cd := ParameterDefClassData;
  SOM_InitEnvironment(@LocalEnv);
  Result :=
  somTD_ParameterDef__get_type
   (SOM_Resolve(Self, cd.classObject, cd._get_type))
     (Self, @LocalEnv);
  SOM_UninitEnvironmentOrRaise(@LocalEnv);
end;

(*
 * New Method: _set_type
 *)
type
  somTD_ParameterDef__set_type = procedure(somSelf: SOMObjectBase{ParameterDef}; ev: PEnvironment; SOM_type: {caller_owns} TypeCode); stdcall;

procedure ParameterDef._set_type(SOM_type: {caller_owns} TypeCode); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PParameterDefClassDataStructure;
  LocalEnv: Environment;
begin
  cd := ParameterDefClassData;
  SOM_InitEnvironment(@LocalEnv);
  somTD_ParameterDef__set_type
   (SOM_Resolve(Self, cd.classObject, cd._set_type))
     (Self, @LocalEnv, SOM_type);
  SOM_UninitEnvironmentOrRaise(@LocalEnv);
end;

(*
 * New Method: _get_mode
 *)
type
  somTD_ParameterDef__get_mode = function(somSelf: SOMObjectBase{ParameterDef}; ev: PEnvironment): ParameterDef_ParameterMode; stdcall;

function ParameterDef._get_mode: ParameterDef_ParameterMode; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PParameterDefClassDataStructure;
  LocalEnv: Environment;
begin
  cd := ParameterDefClassData;
  SOM_InitEnvironment(@LocalEnv);
  Result :=
  somTD_ParameterDef__get_mode
   (SOM_Resolve(Self, cd.classObject, cd._get_mode))
     (Self, @LocalEnv);
  SOM_UninitEnvironmentOrRaise(@LocalEnv);
end;

(*
 * New Method: _set_mode
 *)
type
  somTD_ParameterDef__set_mode = procedure(somSelf: SOMObjectBase{ParameterDef}; ev: PEnvironment; mode: ParameterDef_ParameterMode); stdcall;

procedure ParameterDef._set_mode(mode: ParameterDef_ParameterMode); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PParameterDefClassDataStructure;
  LocalEnv: Environment;
begin
  cd := ParameterDefClassData;
  SOM_InitEnvironment(@LocalEnv);
  somTD_ParameterDef__set_mode
   (SOM_Resolve(Self, cd.classObject, cd._set_mode))
     (Self, @LocalEnv, mode);
  SOM_UninitEnvironmentOrRaise(@LocalEnv);
end;

function ParameterDef._get_name: CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PContainedClassDataStructure;
  LocalEnv: Environment;
begin
  cd := ContainedClassData;
  SOM_InitEnvironment(@LocalEnv);
  Result :=
  somTD_Contained__get_name
   (SOM_Resolve(Self, cd.classObject, cd._get_name))
     (Self, @LocalEnv);
  SOM_UninitEnvironmentOrRaise(@LocalEnv);
end;

procedure ParameterDef._set_name(name: {caller_owns} CORBAString); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PContainedClassDataStructure;
  LocalEnv: Environment;
begin
  cd := ContainedClassData;
  SOM_InitEnvironment(@LocalEnv);
  somTD_Contained__set_name
   (SOM_Resolve(Self, cd.classObject, cd._set_name))
     (Self, @LocalEnv, name);
  SOM_UninitEnvironmentOrRaise(@LocalEnv);
end;

function ParameterDef._get_id: CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PContainedClassDataStructure;
  LocalEnv: Environment;
begin
  cd := ContainedClassData;
  SOM_InitEnvironment(@LocalEnv);
  Result :=
  somTD_Contained__get_id
   (SOM_Resolve(Self, cd.classObject, cd._get_id))
     (Self, @LocalEnv);
  SOM_UninitEnvironmentOrRaise(@LocalEnv);
end;

procedure ParameterDef._set_id(id: {caller_owns} CORBAString); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PContainedClassDataStructure;
  LocalEnv: Environment;
begin
  cd := ContainedClassData;
  SOM_InitEnvironment(@LocalEnv);
  somTD_Contained__set_id
   (SOM_Resolve(Self, cd.classObject, cd._set_id))
     (Self, @LocalEnv, id);
  SOM_UninitEnvironmentOrRaise(@LocalEnv);
end;

function ParameterDef._get_defined_in: CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PContainedClassDataStructure;
  LocalEnv: Environment;
begin
  cd := ContainedClassData;
  SOM_InitEnvironment(@LocalEnv);
  Result :=
  somTD_Contained__get_defined_in
   (SOM_Resolve(Self, cd.classObject, cd._get_defined_in))
     (Self, @LocalEnv);
  SOM_UninitEnvironmentOrRaise(@LocalEnv);
end;

procedure ParameterDef._set_defined_in(defined_in: {caller_owns} CORBAString); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PContainedClassDataStructure;
  LocalEnv: Environment;
begin
  cd := ContainedClassData;
  SOM_InitEnvironment(@LocalEnv);
  somTD_Contained__set_defined_in
   (SOM_Resolve(Self, cd.classObject, cd._set_defined_in))
     (Self, @LocalEnv, defined_in);
  SOM_UninitEnvironmentOrRaise(@LocalEnv);
end;

function ParameterDef._get_somModifiers: _IDL_Sequence_somModifier; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PContainedClassDataStructure;
  LocalEnv: Environment;
begin
  cd := ContainedClassData;
  SOM_InitEnvironment(@LocalEnv);
  Result :=
  somTD_Contained__get_somModifiers
   (SOM_Resolve(Self, cd.classObject, cd._get_somModifiers))
     (Self, @LocalEnv);
  SOM_UninitEnvironmentOrRaise(@LocalEnv);
end;

procedure ParameterDef._set_somModifiers(const somModifiers: {caller_owns} _IDL_Sequence_somModifier); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PContainedClassDataStructure;
  LocalEnv: Environment;
begin
  cd := ContainedClassData;
  SOM_InitEnvironment(@LocalEnv);
  somTD_Contained__set_somModifiers
   (SOM_Resolve(Self, cd.classObject, cd._set_somModifiers))
     (Self, @LocalEnv, somModifiers);
  SOM_UninitEnvironmentOrRaise(@LocalEnv);
end;

class function ParameterDef.Create: ParameterDef; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
begin
  Result := ParameterDef(SOMClass(NewClass).somNew);
end;

class function ParameterDef.InitInstance(Instance: Pointer): ParameterDef; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
begin
  Result := ParameterDef(SOMClass(NewClass).somRenewNoInit(Instance));
end;

function ParameterDef.ClassType: SOMClass; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
begin
  Result := SOMClass(SOMObject(Self).somGetClass);
end;

class function ParameterDef.ClassName: string;
begin
  Result := AnsiString(SOMClass(NewClass).somGetName);
end;

class function ParameterDef.ClassNameIs(const Name: string): Boolean;
begin
  Result := AnsiString(SOMClass(NewClass).somGetName) = Name;
end;

class function ParameterDef.InstanceSize: LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
begin
  Result := SOMClass(NewClass).somGetInstanceSize;
end;

class function ParameterDef.InheritsFrom(AClass: SOMClass): Boolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
begin
  Result := SOMClass(NewClass).somDescendedFrom(AClass);
end;

class function ParameterDef.MethodAddress(const Name: string): Pointer;
var
  NameAsAnsiString: AnsiString;
  NameAsSomId: somId;
begin
  NameAsAnsiString := AnsiString(Name);
  NameAsSomId := somIdFromString(PAnsiChar(NameAsAnsiString));
  try
    SOMClass(NewClass).somFindMethod(NameAsSomId, Result);
  finally
    SOMMemFree(NameAsSomId);
  end;
end;

class function ParameterDef.NewInstance: ParameterDef; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
begin
  Result := ParameterDef(SOMClass(NewClass).somNewNoInit);
end;

function ParameterDef.Clone: ParameterDef; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
begin
  Result := ParameterDef(SOMClass(somGetClass).somNewNoInit);
  SOMObject(Result).somDefaultCopyInit(somInitCtrl(nil^), SOMObject(Self));
end;

function ParameterDef.within: _IDL_Sequence_Container; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PContainedClassDataStructure;
  LocalEnv: Environment;
begin
  cd := ContainedClassData;
  SOM_InitEnvironment(@LocalEnv);
  Result :=
  somTD_Contained_within
   (SOM_Resolve(Self, cd.classObject, cd.within))
     (Self, @LocalEnv);
  SOM_UninitEnvironmentOrRaise(@LocalEnv);
end;

function ParameterDef.describe: Contained_Description; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PContainedClassDataStructure;
  LocalEnv: Environment;
begin
  cd := ContainedClassData;
  SOM_InitEnvironment(@LocalEnv);
  Result :=
  somTD_Contained_describe
   (SOM_Resolve(Self, cd.classObject, cd.describe))
     (Self, @LocalEnv);
  SOM_UninitEnvironmentOrRaise(@LocalEnv);
end;

procedure ParameterDef.somDefaultInit(var ctrl: Pointer); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somDefaultInit
   (SOM_Resolve(Self, cd.classObject, cd.somDefaultInit))
     (Self, ctrl);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

procedure ParameterDef.somDestruct(doFree: Byte; var ctrl: Pointer); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somDestruct
   (SOM_Resolve(Self, cd.classObject, cd.somDestruct))
     (Self, doFree, ctrl);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

procedure ParameterDef.somDefaultCopyInit(var ctrl: Pointer; fromObj: ParameterDef); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somDefaultCopyInit
   (SOM_Resolve(Self, cd.classObject, cd.somDefaultCopyInit))
     (Self, ctrl, fromObj);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function ParameterDef.somDefaultAssign(var ctrl: Pointer; fromObj: ParameterDef): ParameterDef; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result := ParameterDef(
  somTD_SOMObject_somDefaultAssign
   (SOM_Resolve(Self, cd.classObject, cd.somDefaultAssign))
     (Self, ctrl, fromObj));
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

procedure ParameterDef.somDefaultConstCopyInit(var ctrl: Pointer; fromObj: ParameterDef); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somDefaultConstCopyInit
   (SOM_Resolve(Self, cd.classObject, cd.somDefaultConstCopyInit))
     (Self, ctrl, fromObj);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

procedure ParameterDef.somDefaultVCopyInit(var ctrl: Pointer; fromObj: ParameterDef); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somDefaultVCopyInit
   (SOM_Resolve(Self, cd.classObject, cd.somDefaultVCopyInit))
     (Self, ctrl, fromObj);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

procedure ParameterDef.somDefaultConstVCopyInit(var ctrl: Pointer; fromObj: ParameterDef); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somDefaultConstVCopyInit
   (SOM_Resolve(Self, cd.classObject, cd.somDefaultConstVCopyInit))
     (Self, ctrl, fromObj);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function ParameterDef.somDefaultConstAssign(var ctrl: Pointer; fromObj: ParameterDef): ParameterDef; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result := ParameterDef(
  somTD_SOMObject_somDefaultConstAssign
   (SOM_Resolve(Self, cd.classObject, cd.somDefaultConstAssign))
     (Self, ctrl, fromObj));
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function ParameterDef.somDefaultVAssign(var ctrl: Pointer; fromObj: ParameterDef): ParameterDef; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result := ParameterDef(
  somTD_SOMObject_somDefaultVAssign
   (SOM_Resolve(Self, cd.classObject, cd.somDefaultVAssign))
     (Self, ctrl, fromObj));
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function ParameterDef.somDefaultConstVAssign(var ctrl: Pointer; fromObj: ParameterDef): ParameterDef; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result := ParameterDef(
  somTD_SOMObject_somDefaultConstVAssign
   (SOM_Resolve(Self, cd.classObject, cd.somDefaultConstVAssign))
     (Self, ctrl, fromObj));
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

procedure ParameterDef.somInit; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somInit
   (SOM_Resolve(Self, cd.classObject, cd.somInit))
     (Self);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

procedure ParameterDef.somFree; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somFree
   (SOM_Resolve(Self, cd.classObject, cd.somFree))
     (Self);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

procedure ParameterDef.somUninit; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somUninit
   (SOM_Resolve(Self, cd.classObject, cd.somUninit))
     (Self);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function ParameterDef.somGetClass: SOMClass; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result := SOMClass(
  somTD_SOMObject_somGetClass
   (SOM_Resolve(Self, cd.classObject, cd.somGetClass))
     (Self));
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function ParameterDef.somGetClassName: {dual_owned} CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result :=
  somTD_SOMObject_somGetClassName
   (SOM_Resolve(Self, cd.classObject, cd.somGetClassName))
     (Self);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function ParameterDef.somGetSize: LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result :=
  somTD_SOMObject_somGetSize
   (SOM_Resolve(Self, cd.classObject, cd.somGetSize))
     (Self);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function ParameterDef.somIsA(aClassObj: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result :=
  somTD_SOMObject_somIsA
   (SOM_Resolve(Self, cd.classObject, cd.somIsA))
     (Self, aClassObj);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function ParameterDef.somIsInstanceOf(aClassObj: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result :=
  somTD_SOMObject_somIsInstanceOf
   (SOM_Resolve(Self, cd.classObject, cd.somIsInstanceOf))
     (Self, aClassObj);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function ParameterDef.somRespondsTo(mId: somId): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result :=
  somTD_SOMObject_somRespondsTo
   (SOM_Resolve(Self, cd.classObject, cd.somRespondsTo))
     (Self, mId);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function ParameterDef.somDispatch(out retValue: Pointer; methodId: somId; ap: va_list): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result :=
  somTD_SOMObject_somDispatch
   (SOM_Resolve(Self, cd.classObject, cd.somDispatch))
     (Self, retValue, methodId, ap);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function ParameterDef.somClassDispatch(clsObj: SOMClass; out retValue: Pointer; methodId: somId; ap: va_list): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result :=
  somTD_SOMObject_somClassDispatch
   (SOM_Resolve(Self, cd.classObject, cd.somClassDispatch))
     (Self, clsObj, retValue, methodId, ap);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function ParameterDef.somCastObj(cls: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result :=
  somTD_SOMObject_somCastObj
   (SOM_Resolve(Self, cd.classObject, cd.somCastObj))
     (Self, cls);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function ParameterDef.somResetObj: CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result :=
  somTD_SOMObject_somResetObj
   (SOM_Resolve(Self, cd.classObject, cd.somResetObj))
     (Self);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function ParameterDef.somPrintSelf: ParameterDef; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result := ParameterDef(
  somTD_SOMObject_somPrintSelf
   (SOM_Resolve(Self, cd.classObject, cd.somPrintSelf))
     (Self));
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

procedure ParameterDef.somDumpSelf(level: LongInt); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somDumpSelf
   (SOM_Resolve(Self, cd.classObject, cd.somDumpSelf))
     (Self, level);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

procedure ParameterDef.somDumpSelfInt(level: LongInt); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somDumpSelfInt
   (SOM_Resolve(Self, cd.classObject, cd.somDumpSelfInt))
     (Self, level);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

class function ParameterDef.ClassObject: SOMClass; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
begin
  if Self = ParameterDef then { invoked on class name literal }
  begin
    Result := SOMClass(ParameterDefClassData.classObject);
  end
  else { invoked on SOM object }
  begin
    Result := SOMClass(PPointer(Self)^);
  end
end;

class function ParameterDef.NewClass: SOMClass;
begin
  if Self = ParameterDef then { invoked on class name literal }
  begin
    Result := SOMClass(ParameterDefClassData.classObject);
    if not Assigned(Result) then Result := SOMClass(ParameterDefNewClass);
  end
  else { invoked on SOM object }
  begin
    Result := SOMClass(PPointer(Self)^);
  end
end;

function ParameterDef.As_Contained: Contained; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
begin
  Result := Contained(Self);
end;

function ParameterDef.As_ParameterDef: ParameterDef; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
begin
  Result := Self;
end;

class function ParameterDef.Supports(Instance: SOMObjectBase): Boolean;
var
  cls: SOMClass;
begin
  if not Assigned(Instance) then
  begin
    Result := False;
  end
  else
  begin
    cls := SOMClass(ClassObject);
    if not Assigned(cls) then
    begin
      Result := False;
    end
    else
    begin
      Result := SOMObject(Instance).somIsA(cls);
    end;
  end;
end;

class function ParameterDef.Supports(Instance: SOMObjectBase; out Obj: ParameterDef): Boolean;
var
  cls: SOMClass;
begin
  if not Assigned(Instance) then
  begin
    Result := False;
    Obj := nil;
  end
  else
  begin
    cls := SOMClass(ClassObject);
    if not Assigned(cls) then
    begin
      Result := False;
      Obj := nil;
    end
    else if SOMObject(Instance).somIsA(cls) then
    begin
      Result := True;
      Obj := ParameterDef(Instance);
    end
    else
    begin
      Result := False;
      Obj := nil;
    end;
  end;
end;

const
  Principal_MajorVersion = 1;
  Principal_MinorVersion = 0;

(*
 * Declare the class creation procedure
 *)
function PrincipalNewClass(
  somtmajorVersion: integer4 = Principal_MajorVersion;
  somtminorVersion: integer4 = Principal_MinorVersion):
  SOMClass; stdcall; external SOMD_DLL_Name name 'PrincipalNewClass';

(*
 * Declare the ABI 2 ClassData structure
 *)
type
  PrincipalClassDataStructure = packed record
    classObject: SOMClass;
    _set_userName,
    _get_userName,
    _set_hostName,
    _get_hostName: somMToken;
  end;
  PPrincipalClassDataStructure = ^PrincipalClassDataStructure;

var
  SOMD_DLL_PrincipalClassData: PPrincipalClassDataStructure = nil;

function PrincipalClassData: PPrincipalClassDataStructure;
begin
  if Assigned(SOMD_DLL_PrincipalClassData) then
    Result := SOMD_DLL_PrincipalClassData
  else
  begin
    SOMD_DLL_Load_Variable(SOMD_DLL_PrincipalClassData, 'PrincipalClassData');
    Result := SOMD_DLL_PrincipalClassData;
  end;
end;

(*
 * Declare the ABI 2 CClassData structure
 *)
type
  PrincipalCClassDataStructure = packed record
    parentMtab: somMethodTabs;
    instanceDataToken: somDToken;
  end;
  PPrincipalCClassDataStructure = ^PrincipalCClassDataStructure;

var
  SOMD_DLL_PrincipalCClassData: PPrincipalCClassDataStructure = nil;

function PrincipalCClassData: PPrincipalCClassDataStructure;
begin
  if Assigned(SOMD_DLL_PrincipalCClassData) then
    Result := SOMD_DLL_PrincipalCClassData
  else
  begin
    SOMD_DLL_Load_Variable(SOMD_DLL_PrincipalCClassData, 'PrincipalCClassData');
    Result := SOMD_DLL_PrincipalCClassData;
  end;
end;

(*
 * Class Object and Method Token Macros
 *)

(*
 * New Method: _get_userName
 *)
type
  somTD_Principal__get_userName = function(somSelf: SOMObjectBase{Principal}; ev: PEnvironment): CORBAString; stdcall;

function Principal._get_userName: CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PPrincipalClassDataStructure;
  LocalEnv: Environment;
begin
  cd := PrincipalClassData;
  SOM_InitEnvironment(@LocalEnv);
  Result :=
  somTD_Principal__get_userName
   (SOM_Resolve(Self, cd.classObject, cd._get_userName))
     (Self, @LocalEnv);
  SOM_UninitEnvironmentOrRaise(@LocalEnv);
end;

(*
 * New Method: _set_userName
 *)
type
  somTD_Principal__set_userName = procedure(somSelf: SOMObjectBase{Principal}; ev: PEnvironment; userName: CORBAString); stdcall;

procedure Principal._set_userName(userName: CORBAString); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PPrincipalClassDataStructure;
  LocalEnv: Environment;
begin
  cd := PrincipalClassData;
  SOM_InitEnvironment(@LocalEnv);
  somTD_Principal__set_userName
   (SOM_Resolve(Self, cd.classObject, cd._set_userName))
     (Self, @LocalEnv, userName);
  SOM_UninitEnvironmentOrRaise(@LocalEnv);
end;

(*
 * New Method: _get_hostName
 *)
type
  somTD_Principal__get_hostName = function(somSelf: SOMObjectBase{Principal}; ev: PEnvironment): CORBAString; stdcall;

function Principal._get_hostName: CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PPrincipalClassDataStructure;
  LocalEnv: Environment;
begin
  cd := PrincipalClassData;
  SOM_InitEnvironment(@LocalEnv);
  Result :=
  somTD_Principal__get_hostName
   (SOM_Resolve(Self, cd.classObject, cd._get_hostName))
     (Self, @LocalEnv);
  SOM_UninitEnvironmentOrRaise(@LocalEnv);
end;

(*
 * New Method: _set_hostName
 *)
type
  somTD_Principal__set_hostName = procedure(somSelf: SOMObjectBase{Principal}; ev: PEnvironment; hostName: CORBAString); stdcall;

procedure Principal._set_hostName(hostName: CORBAString); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PPrincipalClassDataStructure;
  LocalEnv: Environment;
begin
  cd := PrincipalClassData;
  SOM_InitEnvironment(@LocalEnv);
  somTD_Principal__set_hostName
   (SOM_Resolve(Self, cd.classObject, cd._set_hostName))
     (Self, @LocalEnv, hostName);
  SOM_UninitEnvironmentOrRaise(@LocalEnv);
end;

class function Principal.Create: Principal; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
begin
  Result := Principal(SOMClass(NewClass).somNew);
end;

class function Principal.InitInstance(Instance: Pointer): Principal; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
begin
  Result := Principal(SOMClass(NewClass).somRenewNoInit(Instance));
end;

function Principal.ClassType: SOMClass; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
begin
  Result := SOMClass(SOMObject(Self).somGetClass);
end;

class function Principal.ClassName: string;
begin
  Result := AnsiString(SOMClass(NewClass).somGetName);
end;

class function Principal.ClassNameIs(const Name: string): Boolean;
begin
  Result := AnsiString(SOMClass(NewClass).somGetName) = Name;
end;

class function Principal.InstanceSize: LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
begin
  Result := SOMClass(NewClass).somGetInstanceSize;
end;

class function Principal.InheritsFrom(AClass: SOMClass): Boolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
begin
  Result := SOMClass(NewClass).somDescendedFrom(AClass);
end;

class function Principal.MethodAddress(const Name: string): Pointer;
var
  NameAsAnsiString: AnsiString;
  NameAsSomId: somId;
begin
  NameAsAnsiString := AnsiString(Name);
  NameAsSomId := somIdFromString(PAnsiChar(NameAsAnsiString));
  try
    SOMClass(NewClass).somFindMethod(NameAsSomId, Result);
  finally
    SOMMemFree(NameAsSomId);
  end;
end;

class function Principal.NewInstance: Principal; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
begin
  Result := Principal(SOMClass(NewClass).somNewNoInit);
end;

function Principal.Clone: Principal; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
begin
  Result := Principal(SOMClass(somGetClass).somNewNoInit);
  SOMObject(Result).somDefaultCopyInit(somInitCtrl(nil^), SOMObject(Self));
end;

procedure Principal.somDefaultInit(var ctrl: Pointer); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somDefaultInit
   (SOM_Resolve(Self, cd.classObject, cd.somDefaultInit))
     (Self, ctrl);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

procedure Principal.somDestruct(doFree: Byte; var ctrl: Pointer); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somDestruct
   (SOM_Resolve(Self, cd.classObject, cd.somDestruct))
     (Self, doFree, ctrl);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

procedure Principal.somDefaultCopyInit(var ctrl: Pointer; fromObj: Principal); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somDefaultCopyInit
   (SOM_Resolve(Self, cd.classObject, cd.somDefaultCopyInit))
     (Self, ctrl, fromObj);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function Principal.somDefaultAssign(var ctrl: Pointer; fromObj: Principal): Principal; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result := Principal(
  somTD_SOMObject_somDefaultAssign
   (SOM_Resolve(Self, cd.classObject, cd.somDefaultAssign))
     (Self, ctrl, fromObj));
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

procedure Principal.somDefaultConstCopyInit(var ctrl: Pointer; fromObj: Principal); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somDefaultConstCopyInit
   (SOM_Resolve(Self, cd.classObject, cd.somDefaultConstCopyInit))
     (Self, ctrl, fromObj);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

procedure Principal.somDefaultVCopyInit(var ctrl: Pointer; fromObj: Principal); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somDefaultVCopyInit
   (SOM_Resolve(Self, cd.classObject, cd.somDefaultVCopyInit))
     (Self, ctrl, fromObj);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

procedure Principal.somDefaultConstVCopyInit(var ctrl: Pointer; fromObj: Principal); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somDefaultConstVCopyInit
   (SOM_Resolve(Self, cd.classObject, cd.somDefaultConstVCopyInit))
     (Self, ctrl, fromObj);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function Principal.somDefaultConstAssign(var ctrl: Pointer; fromObj: Principal): Principal; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result := Principal(
  somTD_SOMObject_somDefaultConstAssign
   (SOM_Resolve(Self, cd.classObject, cd.somDefaultConstAssign))
     (Self, ctrl, fromObj));
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function Principal.somDefaultVAssign(var ctrl: Pointer; fromObj: Principal): Principal; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result := Principal(
  somTD_SOMObject_somDefaultVAssign
   (SOM_Resolve(Self, cd.classObject, cd.somDefaultVAssign))
     (Self, ctrl, fromObj));
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function Principal.somDefaultConstVAssign(var ctrl: Pointer; fromObj: Principal): Principal; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result := Principal(
  somTD_SOMObject_somDefaultConstVAssign
   (SOM_Resolve(Self, cd.classObject, cd.somDefaultConstVAssign))
     (Self, ctrl, fromObj));
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

procedure Principal.somInit; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somInit
   (SOM_Resolve(Self, cd.classObject, cd.somInit))
     (Self);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

procedure Principal.somFree; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somFree
   (SOM_Resolve(Self, cd.classObject, cd.somFree))
     (Self);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

procedure Principal.somUninit; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somUninit
   (SOM_Resolve(Self, cd.classObject, cd.somUninit))
     (Self);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function Principal.somGetClass: SOMClass; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result := SOMClass(
  somTD_SOMObject_somGetClass
   (SOM_Resolve(Self, cd.classObject, cd.somGetClass))
     (Self));
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function Principal.somGetClassName: {dual_owned} CORBAString; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result :=
  somTD_SOMObject_somGetClassName
   (SOM_Resolve(Self, cd.classObject, cd.somGetClassName))
     (Self);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function Principal.somGetSize: LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result :=
  somTD_SOMObject_somGetSize
   (SOM_Resolve(Self, cd.classObject, cd.somGetSize))
     (Self);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function Principal.somIsA(aClassObj: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result :=
  somTD_SOMObject_somIsA
   (SOM_Resolve(Self, cd.classObject, cd.somIsA))
     (Self, aClassObj);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function Principal.somIsInstanceOf(aClassObj: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result :=
  somTD_SOMObject_somIsInstanceOf
   (SOM_Resolve(Self, cd.classObject, cd.somIsInstanceOf))
     (Self, aClassObj);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function Principal.somRespondsTo(mId: somId): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result :=
  somTD_SOMObject_somRespondsTo
   (SOM_Resolve(Self, cd.classObject, cd.somRespondsTo))
     (Self, mId);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function Principal.somDispatch(out retValue: Pointer; methodId: somId; ap: va_list): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result :=
  somTD_SOMObject_somDispatch
   (SOM_Resolve(Self, cd.classObject, cd.somDispatch))
     (Self, retValue, methodId, ap);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function Principal.somClassDispatch(clsObj: SOMClass; out retValue: Pointer; methodId: somId; ap: va_list): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result :=
  somTD_SOMObject_somClassDispatch
   (SOM_Resolve(Self, cd.classObject, cd.somClassDispatch))
     (Self, clsObj, retValue, methodId, ap);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function Principal.somCastObj(cls: SOMClass): CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result :=
  somTD_SOMObject_somCastObj
   (SOM_Resolve(Self, cd.classObject, cd.somCastObj))
     (Self, cls);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function Principal.somResetObj: CORBABoolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result :=
  somTD_SOMObject_somResetObj
   (SOM_Resolve(Self, cd.classObject, cd.somResetObj))
     (Self);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

function Principal.somPrintSelf: Principal; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  Result := Principal(
  somTD_SOMObject_somPrintSelf
   (SOM_Resolve(Self, cd.classObject, cd.somPrintSelf))
     (Self));
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

procedure Principal.somDumpSelf(level: LongInt); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somDumpSelf
   (SOM_Resolve(Self, cd.classObject, cd.somDumpSelf))
     (Self, level);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

procedure Principal.somDumpSelfInt(level: LongInt); {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
var
  cd: PSOMObjectClassDataStructure;
begin
  cd := SOMObjectClassData;
  somTD_SOMObject_somDumpSelfInt
   (SOM_Resolve(Self, cd.classObject, cd.somDumpSelfInt))
     (Self, level);
  SOM_UninitEnvironmentOrRaise(somGetGlobalEnvironment);
end;

class function Principal.ClassObject: SOMClass; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
begin
  if Self = Principal then { invoked on class name literal }
  begin
    Result := SOMClass(PrincipalClassData.classObject);
  end
  else { invoked on SOM object }
  begin
    Result := SOMClass(PPointer(Self)^);
  end
end;

class function Principal.NewClass: SOMClass;
begin
  if Self = Principal then { invoked on class name literal }
  begin
    Result := SOMClass(PrincipalClassData.classObject);
    if not Assigned(Result) then Result := SOMClass(PrincipalNewClass);
  end
  else { invoked on SOM object }
  begin
    Result := SOMClass(PPointer(Self)^);
  end
end;

function Principal.As_Principal: Principal; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
begin
  Result := Self;
end;

class function Principal.Supports(Instance: SOMObjectBase): Boolean;
var
  cls: SOMClass;
begin
  if not Assigned(Instance) then
  begin
    Result := False;
  end
  else
  begin
    cls := SOMClass(ClassObject);
    if not Assigned(cls) then
    begin
      Result := False;
    end
    else
    begin
      Result := SOMObject(Instance).somIsA(cls);
    end;
  end;
end;

class function Principal.Supports(Instance: SOMObjectBase; out Obj: Principal): Boolean;
var
  cls: SOMClass;
begin
  if not Assigned(Instance) then
  begin
    Result := False;
    Obj := nil;
  end
  else
  begin
    cls := SOMClass(ClassObject);
    if not Assigned(cls) then
    begin
      Result := False;
      Obj := nil;
    end
    else if SOMObject(Instance).somIsA(cls) then
    begin
      Result := True;
      Obj := Principal(Instance);
    end
    else
    begin
      Result := False;
      Obj := nil;
    end;
  end;
end;

const
  Repository_MajorVersion = 2;
  Repository_MinorVersion = 1;

(*
 * Declare the class creation procedure
 *)
function RepositoryNewClass(
  somtmajorVersion: integer4 = Repository_MajorVersion;
  somtminorVersion: integer4 = Repository_MinorVersion):
  SOMClass; stdcall; external SOMIR_DLL_Name name 'RepositoryNewClass';

(*
 * Declare the ABI 2 ClassData structure
 *)
type
  RepositoryClassDataStructure = packed record
    classObject: SOMClass;
    lookup_id,
    lookup_modifier,
    release_cache: somMToken;
  end;
  PRepositoryClassDataStructure = ^RepositoryClassDataStructure;

var
  SOMIR_DLL_RepositoryClassData: PRepositoryClassDataStructure = nil;

function RepositoryClassData: PRepositoryClassDataStructure;
begin
  if Assigned(SOMIR_DLL_RepositoryClassData) then
    Result := SOMIR_DLL_RepositoryClassData
  else
  begin
    SOMIR_DLL_Load_Variable(SOMIR_DLL_RepositoryClassData, 'RepositoryClassData');
    Result := SOMIR_DLL_RepositoryClassData;
  end;
end;

(*
 * Declare the ABI 2 CClassData structure
 *)
type
  RepositoryCClassDataStructure = packed record
    parentMtab: somMethodTabs;
    instanceDataToken: somDToken;
  end;
  PRepositoryCClassDataStructure = ^RepositoryCClassDataStructure;

var
  SOMIR_DLL_RepositoryCClassData: PRepositoryCClassDataStructure = nil;

function RepositoryCClassData: PRepositoryCClassDataStructure;
begin
  if Assigned(SOMIR_DLL_RepositoryCClassData) then
    Result := SOMIR_DLL_RepositoryCClassData
  else
  begin
    SOMIR_DLL_Load_Variable(SOMIR_DLL_RepositoryCClassData, 'RepositoryCClassData');
    Result := SOMIR_DLL_RepositoryCClassData;
  end;
end;

(*
 * Class Object and Method Token Macros
 *)

class function Repository.Create: Repository; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
begin
  Result := Repository(SOMClass(NewClass).somNew);
end;

class function Repository.InitInstance(Instance: Pointer): Repository; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
begin
  Result := Repository(SOMClass(NewClass).somRenewNoInit(Instance));
end;

function Repository.ClassType: SOMClass; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
begin
  Result := SOMClass(SOMObject(Self).somGetClass);
end;

class function Repository.ClassName: string;
begin
  Result := AnsiString(SOMClass(NewClass).somGetName);
end;

class function Repository.ClassNameIs(const Name: string): Boolean;
begin
  Result := AnsiString(SOMClass(NewClass).somGetName) = Name;
end;

class function Repository.InstanceSize: LongInt; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
begin
  Result := SOMClass(NewClass).somGetInstanceSize;
end;

class function Repository.InheritsFrom(AClass: SOMClass): Boolean; {$IFDEF DELPHI_HAS_INLINE} inline; {$ENDIF}
begin
  Result := SOMClass(NewClass).somDescendedFrom(AClass);
end;

class function Repository.MethodAddress(const Name: string): Pointer;
var
  NameAsAnsiString: AnsiString;
  NameAsSomId: somId;
begin
  NameAsAnsiString := AnsiString(Name);
  NameAsSomId := somIdFromString(PAnsiChar(NameAsAnsiString));
  try
    SOMClass(NewClass).so