
program = {
  comment:  "cat program in soopy2";
  author:   "$Author: randy $";
  date:     "$Date: 2003/01/26 07:17:55 $";
  revision: "$Revision: 1.1 $";

  fun usage(){
    do: [
      println "usage: soopy cat.sp file1 [file2 ... fileN]";
    ];
  };

  fun printlines(lines){
    comment: "print each lines with newline";
    do: if(lines){
          []: true;
          x::xs: [
              println x;
              printlines xs;
            ];
        };
  };

  fun with_openEncodeIn_file(encoder, filename, body){
    comment: "open file & eval body & close file";
    var: [fin, f];
    do: [
      f = openIn filename;
      fin = encoder encoderIn(f);
      body eval(fin);
      fin close;
    ];
    rescue: fin close;
  };


  fun cat(file){
    comment: "cat a file";
    do: [
      with_openEncodeIn_file SJIS file {
        arg: [fin];
        var: [lines];
        do: [
          lines = fin readlines;
          printlines lines;
        ];
      };
    ];
  };

  fun cats(files){
    comment: "cat files";
    do: if(files){
          []:    [];
          x::xs: [ cat x; cats xs; ];
        };
  };

  /*
   * Main routine
   */
  fun main(){
    comment: "main routine";
    var: [files];
    do: [
      files = Soopy commandLine;
      if(files){
        []: usage();
        _:  cats(files);
      };
    ];
  };
};

/*
 * run program
 */
program main();

