#
# for
#

fun for(init, cond, step, body){
  do: [
    loop {
      from:  init each {arg:[dammy]; do: [];};
      while: cond head;
      step:  step each {arg:[dammy]; do: [];};
      do:    body each {arg:[dammy]; do: [];};
    };
  ];
};


#
# local
#

fun local(vars, body){
  do: (vars + {do: body;}) eval();
};


#
# lambda
#

fun lambda(args, body){
  do: {arg: args; do: body;} eval;
};

#
# if -- like C
#

fun c_if(cond, then, else){
  do: [
    if(cond){
      true:  then each {arg:[dammy]; do: [];};
      false: else each {arg:[dammy]; do: [];};
    };
  ];
};

#
# when
#

fun when(cond, body){
  do: [
    if(cond){
      true: body each {arg:[dammy]; do: [];};
    };
  ];
};


#
# unless
#

fun unless(cond, body){
  do: [
    if(cond){
      false: body each {arg:[dammy]; do: [];};
    };
  ];
};


#
# while
#

fun while(cond, body){
  do: [
    loop {
      while: cond head;
      do: body each {arg:[dammy]; do: [];};
    };
  ];
};


#
# until
#

fun until(cond, body){
  do: [
    loop {
      until: cond head;
      do: body each {arg:[dammy]; do: [];};
    };
  ];
};


#
# do
#

fun do(body){
  do: [
    body each {arg:[dammy]; do: [];};
    {
      while: {
          arg:[cond];
          do: [
            loop {
              while: cond head;
              do: body each {arg:[dammy]; do: [];};
            };
          ];
        } eval;
      until: {
          arg:[cond];
          do: [
            loop {
              until: cond head;
              do: body each {arg:[dammy]; do: [];};
            };
          ];
        } eval;
    };
  ];
};


# test  -- for & local

println "<<for & local>>";
i = 5;
local{i: 0;}[
  for[i=0][i < 10][i = i + 1][
    print "i = "; println i;
  ];
];
print "global i = "; println i; # => 5

# test  -- labmda

println "<<lambda>>";
sq = lambda[x][x * x];
print "sq 9 = "; println(sq 9);

# test c_if

println "<<c_if>>";
c_if(1 == 1)[
  print "1 == 1."; println "SUCCESS.";
][
  print "1 != 1."; println "Error.";
];

c_if(1 == 2)[
  print "1 == 2."; println "Error";
][
  print "1 != 2."; println "SUCCESS";
];

# test -- when

println "<<when>>";
when(true)[println "when true"];
when(false)[println "when false"];

# test -- unless

println "<<unless>>";
unless(true)[println "unless true"];
unless(false)[println "unless false"];

# test -- while

println "<<while>>";
i = 0;
while[i < 10][
  println i;
  i = i + 1;
];

# test -- until

println "<<until>>";
i = 0;
until[i == 10][
  println i;
  i = i + 1;
];


# test -- do

println "<<do while>>";
i = 0;
do [
  println i;
  i = i + 1;
] while [i < 5];


println "<<do until>>";
i = 0;
do [
  println i;
  i = i + 1;
] until [i == 5];




