fun printlines(lines){
  do: match(lines){
        []: true;
        x::xs: [
            println x;
            printlines xs;
          ];
      };
};

fun cat(file){
  var: [fin, lines];
  do: [
    fin = openIn file;
    lines = fin readlineS;
    printlines lines;
    fin close;
  ];
};


fun cats(files){
  do: match(files){
        []:    [];
        x::xs: [ cat x; cats xs; ];
      };
};

fun usage(){
  do: [
    println "usage: soopy cat.sp file1 [file2 ... fileN]";
  ];
};

/*
 * Main routine
 */

files = Soopy commandLine;
match(files){
  []: usage();
  _:  cats(files);
};


