#!/usr/local/bin/soopy
#
# SoopyWiki Version 1.0
#
# wiki.cgi
#
# Copyright (C) 2003 by SUZUKI Jun.
# <randy@users.sourceforge.jp>
# http://soopy.sourceforge.jp/
#
# $Id: wiki.cgi,v 1.42 2004/03/27 05:59:44 randy Exp $
#

  #########################
  # 
  #########################

  dbdir      = "spwiki/";
  baseurl    = "http://soopy.sourceforge.jp/cgi-bin/";
  cgi_name   = "wiki.cgi";  # ΣãǣɤΥե̾
  frontpage  = "FrontPage"; # FrontPageɽ̾
  recentpage = "Recent";    # RecentΥȥ̾
  indexpage  = "Index";     # IndexΥȥ̾
  errorpage  = "Error";     # ErrorΥȥ̾
  naviwrite  = "Write";     # WriteΥȥ̾
  naviedit   = "Edit";      # EditΥʥӥɽ̾
  navirecent = "Recent";    # RecentΥʥӥɽ̾
  naviindex  = "Index";     # IndexΥʥӥɽ̾
  navi_rss   = "RSS";       # RSSΥʥӥɽ̾
  use_rss    = true;        # RSSȤɤ
  msgdeleted = " is deleted.";
  editchar   = "?";
  cols = 80;                 # EditΥƥȥꥢη
  rows = 20;                 # EditΥƥȥꥢιԿ
  recents    = 10;           # Recentɽ륿ȥ
  titlecolor = "#F0E0E7";    # Wikiȥο
  bgcolor    = "white";      # background
  rss = {
    #file:  "../htdocs/wiki/rss.rdf";   # RSSե̾
    file:  "rss.rdf";   # RSSե̾
    #location: "http://soopy.sourceforge.jp/wiki/rss.rdf";
    location: "http://soopy.sourceforge.jp/cgi-bin/wiki.cgi?cmd=rss";
    title: "Soopy";
    link:  "http://soopy.sourceforge.jp/wiki/";
    description: "Soopy";
    max_item: 15;
    TZ: "+09:00";
  };
  style = "
<style type=\"text/css\">
<!--
pre     { line-height: 130% }
a       {}
a:hover {
          color: red;
          background-color: white;
          text-decoration: underline
        }
h2      { text-align: left;
          border: #b9a 1px solid;
          color: black;
          background: #f0e0e7;
          padding: .3em .5em .2em .5em;
        }
h3      { text-align: left;
          border-bottom: #b9a 1px solid;
          color: black;
          background: #f0e0e7;
          padding: .2em .5em .0em .5em;
        }
-->
</style>
";  # 롡ޤ

  contenttype = "Content-type: text/html; charset=Shift_JIS";
  rss_contenttype = "Content-type: text/xml; charset=Shift_JIS";
  # contenttype = "Content-type: text/html; charset=euc-jp";
  # rss_contenttype = "Content-type: text/xml; charset=euc-jp";

  #####################
  # ꡡޤ
  #####################

  KANJI_DECODER = Japanese;


  /*
   * utility routines
   */

  fun with_openIn_file(filename, body){
    comment: "open input-file & eval body & close file";
    var: [fin];
    do: [
      fin = openIn filename;
      body eval(fin);
      fin close;
    ];
    rescue: [
      match(fin isNil?){
        false: fin close;
      };
    ];
  };

  fun with_openOut_file(filename, body){
    comment: "open output-file & eval body & close file";
    var: [fout];
    do: [
      fout = openOut filename;
      body eval(fout);
      fout close;
    ];
    rescue: [
      match(fout isNil?){
        false: fout close;
      };
    ];
  };

  fun add_line(x, y){
    do: x + "\n" + y;
  };

  fun encode_url(url:string){
    var: [reader];
    do: [
      reader = EucJP encoderIn (url reader);
      reader = URLencoder encoderIn reader;
      reader readline;
    ];
  };

  fun make_link(url:string){
    var: [list, mail, name, link];
    do: [
      list = url split1 ':';
      match(list head){
        "http":  "<a href=\"" + url + "\">" + url + "</a>";
        "https": "<a href=\"" + url + "\">" + url + "</a>";
        "ftp":   "<a href=\"" + url + "\">" + url + "</a>";
        "mailto": [
            mail = list nth 1;
            "<a href=\"" + url + "\">" + mail + "</a>";
          ];
        other: [
          let [name, link] = url split1 '|';
          match(link){
            "": [
              match((database get url length) == 0){
                true: url + "<a href=\"" + cgi_name + "?cmd=edit&mypage=" + (encode_url url) + "\">" + editchar + "</a>";
                false: "<a href=\"" + cgi_name + "?cmd=read&mypage=" + (encode_url url) + "\">" + url + "</a>";
              };
            ];
            else: [
                "<a href=\"" + link + "\">" + name + "</a>";
            ];
          };
        ];
      };
    ];
  };

  fun convert_link(line){
    var: [f, g, start, end, prev, res];
    do: [
      loop {
        from: [
          start = 0;
          prev = 0;
          f = line find "[[";
          g = line find "]]";
          res = "";
        ];
        step: [
          start = end + 2;
          prev = start;
        ];
        do: [
          start = f start;
          match(start >= 0){
            false: [
              res = res + (line sub prev ((line length) - prev));
              exit;
            ];
            true: [
              end = g start;
              match(end >= 0){
                true: [
                  res = res + (line sub prev (start - prev))
                            + (make_link (line sub (start+2) (end - (start+2))));
                ];
              };
            ];
          };
        ];
      };
      res;
    ];
  };

  fun tag_convert(line){
    do: [
      match(line length > 0){
        true: [
          match(line nth 0){
            '*': [
               match((line length) >= 2){
                 true: [
                   match(line nth 1){
                     '*': line = "<H3>" + (line sub 2 (line length - 2)) + "</H3>\n";
                     _:   line = "<H2>" + (line sub 1 (line length - 1)) + "</H2>\n";
                   };
                 ];
               };
            ];
            _: [
              match((line length) >= 4){
                true: [
                  match(line sub 0 4){
                    "----": line = "<HR>\n";
                    _: [
                      line = convert_link line;
                      line = line + "\n";
                    ];
                  };
                ];
                false: [
                  line = line + "\n";
                ];
              };
            ];
          };
        ];
        false: [ # null line
              line = "\n";
        ];
      };
      line;
    ];
  };

  fun print_content(){
    var: [temp];
    do: [
      temp = escape(database get (form "mypage"));

      reader = temp reader;
      temp = "";
      loop {
        until: reader eof?;
        do: [
          line = reader readline;
          line = tag_convert line;
          temp = temp + line;
        ];
      };

      print "<pre>" temp; println "</pre>";
    ];
  };

  fun escape(str:string){
    do: [
      str = str replace "&" "&amp;";
      str = str replace "<" "&lt;";
      str = str replace ">" "&gt;";
      str = str replace "\"" "&quot;";
      str;
    ];
  };

  fun print_footer(){
    do: [
      println "</body></html>";
    ];
  };

  fun print_header(title:string, canedit:bool){
    do: [
      println contenttype;
      println "";
      println "<html>";
      println ("<head><title>" + title + "</title>");
      println ("  <link rel=\"alternate\" type=\"application/rss+xml\" title=\"RSS\" href=\"" + (rss location) + "\" />");
      println style;
      println "</head>";
      println ("<body bgcolor=\"" + bgcolor + "\">");
      println ("  <table width=\"100%\" bgcolor=\"" + titlecolor + "\" border=\"0\">");
      println ("    <tr valign=\"top\">");
      println ("      <td><b><tt>" + title + "</tt></b></td>");
      println "      <td align=\"right\"><tt>";
      println ("        <a href=\"" + cgi_name + "?cmd=read&mypage=" + (encode_url frontpage) + "\">" + frontpage + "</a> | ");
      println ("        <a href=\"" + cgi_name + "?cmd=new\">New</a> | ");
      match(canedit){
        true: [
          println ("        <a href=\"" + cgi_name + "?cmd=edit&mypage=" + (encode_url (form "mypage")) + "\">" + naviedit + "</a> | ");
        ];
      };
      println ("        <a href=\"" + cgi_name + "?cmd=recent\">" + navirecent + "</a> | ");
      match(use_rss){
        true: [
          println ("        <a href=\"" + (rss location) + "\">" + navi_rss + "</a> | ");
        ];
      };
      println ("        <a href=\"" + cgi_name + "?cmd=index\">" + naviindex + "</a> | ");
      println ("        <a href=\"http://soopy.sourceforge.jp/wiki/\">Soopy Wiki</a>");
      println "      </tt></td>";
      println "    </tr>";
      println "  </table>";
    ];
  };

  fun print_error(msg:string){
    do: [
      print_header(errorpage, false);
      print ("<h1>" + msg + "</h1>");
      print_footer();
      quit();
    ];
  };

  #
  # RSS
  #

  fun print_rss_header(fout){
    do: [
      fout writeline "<?xml version=\"1.0\" encoding=\"EUC-JP\" ?>";
      fout writeline "<rdf:RDF";
      fout writeline "  xmlns=\"http://purl.org/rss/1.0/\"";
      fout writeline "  xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\"";
      fout writeline "  xmlns:dc=\"http://purl.org/dc/elements/1.1/\"";
      fout writeline "  xml:lang=\"ja\">";
    ];
  };

  fun print_rss_channel(fout, lines){
    var: [i, item];
    do: [
      fout writeline ("  <channel rdf:about=\"" + (rss link) + "\">");
      fout writeline ("    <title>" + (rss title) + "</title>");
      fout writeline ("    <link>" + (rss link) + "</link>");
      fout writeline ("    <description>" + (rss description) + "</description>");
      fout writeline  "    <items>";
      fout writeline  "      <rdf:Seq>";
      loop {
        from: i = 0;
        step: i = i + 1;
        while: (i < (rss max_item)) and (!(lines isNil?));
        do: [
          item = lines head;
          print_channel_item fout item;
          lines = lines tail;
        ];
      };
      fout writeline  "      </rdf:Seq>";
      fout writeline  "    </items>";
      fout writeline  "  </channel>" "";
    ];
  };

  fun make_rss_item_url(item){
    var: [name, ext];
    do: [
      let [name, ext] = item split1('.');
      baseurl + cgi_name + "?cmd=read&amp;mypage=" + (encode_url name);
    ];
  };

  fun print_channel_item(fout, item){
    do: [
      fout writeline ("        <rdf:li rdf:resource=\"" + (make_rss_item_url item) + "\" />");
    ];
  };

  fun print_rss_items(fout, lines){
    var: [i, item];
    do: [
      loop {
        from: i = 0;
        step: i = i + 1;
        while: (i < (rss max_item)) and (!(lines isNil?));
        do: [
          item = lines head;
          print_rss_anItem fout item;
          lines = lines tail;
        ];
      };
    ];
  };

  fun print_rss_anItem(fout, item){
    var: [url, name, ext, t, day, tm, retried];
    do: [
      url = make_rss_item_url item;
      let [name, ext] = item split1('.');
      let [ext, t]    = ext  split1('.');
      let [day, tm]   = t split1(' ');
      fout writeline ("  <item rdf:about=\"" + url + "\">");
      fout writeline ("    <title>" + name + "</title>");
      fout writeline ("    <link>" + url + "</link>");
      fout writeline ("    <description>" + (rss description) + ":" + name + "(" + t + ")" + "</description>");
      fout writeline ("    <dc:date>" + day + "T" + tm + (rss TZ) + "</dc:date>");
      fout writeline ("  </item>");
      fout writeline  "";
    ];
    rescue: [
      match(retried isNil?){
        true: [
          line = line + ".2000-01-01 00:00:00";
          retried = true;
          retry;
        ];
      }
    ];
  };

  fun print_rss_footer(fout){
    do: [
      fout writeline "</rdf:RDF>";
    ];
  };

  fun make_rss(lines){
    do: [
      with_openOut_file(rss file){
        arg: [fout];
        do: [
          print_rss_header(fout);
          print_rss_channel fout lines;
          print_rss_items fout lines;
          print_rss_footer(fout);
        ];
      };
    ];
  };

/*
 * Main Object
 */
{
  /*
   * variables
   */
  form:     {};
  database: nil;

  /*
   * Databse
   */

  db: {
   private

    index_file: "wiki.index";
    index: {}; # key: WikiName, value: (Version, datetime)

    # each line: key.version.datetime

    fun find(key){
      var: [str, values, ver, file_datetime];
      do: [
        let values = index lookup key;
        match(values isNil?){
          true: ("", false);
          false: [
            let (ver, file_datetime) = values;
            with_openIn_file (dbdir + key + "." + ver) {
              arg: [fin];
              var: [list];
              do: [
                list = fin readLines;
                str = list foldl add_line;
              ];
            };
            (str, true);
          ];
        };
      ];
    };

    fun append_index(line:string){
      var: [name, ver, t, retried];
      do: [
        # let [filename, ext] = line split1(',');
        let [name, ver] = line split1('.');
        let [ver, t] = ver split1('.');
        index append name (ver, t);
      ];
      rescue: [
        match(retried isNil?){
          true: [
            line = line + ".2000-01-01 00:00:00";
            retried = true;
            retry;
          ];
        }
      ];
    };

    fun update_index(key:string, ver:string){
      var: [idx, data];
      do: [
        with_openIn_file (dbdir + index_file) {
          arg: [fin];
          do: [
            idx = fin readlines;
          ];
        };
        data = key + "." + ver + "." + (datetime now toString);
        match((index lookup key) isNil?){
          true:  idx = data :: idx;
          false: idx = data :: (idx filter (not_eq_key key));
        };
        with_openOut_file (dbdir + index_file) {
          arg: [fout];
          do: [
            fout writelines idx;
          ];
        };
        match(use_rss){
          true: make_rss idx;
        };
        # update var 'index'
        index = {};
        idx map append_index;
      ];
    };

    fun line2tuple(str:string){
      var: [key, ext, t, retried];
      do: [
        let [key, ext] = str split1('.');
        let [ext, t]   = ext split1('.');
        (key, ext, t);
      ];
      rescue: [
        match(retried isNil?){
          true: [
            str = str + ".2000-01-01 00:00:00";
            retried = true;
            retry;
          ];
        }
      ];
    };

   public

    fun get_indexes(){
      var: [lines, tuples];
      do: [
        with_openIn_file (dbdir + index_file) {
          arg: [fin];
          var: [i, line, key, rest];
          do: [
            lines = fin readlines;
            tuples = lines map line2tuple;
          ];
        };
        tuples;
      ];
    };

    fun cut_ext(filename:string){
      var: [name, ext];
      do: [
        let [name, ext] = filename split1('.');
        name;
      ];
    };

    fun get_keys(){
      var: [dlist];
      do: [
        dlist = index keys;
        dlist map cut_ext;
      ];
    };

    fun not_eq_key(key, key2){
      var: [name, ext];
      do: [
        match(key2 split1('.')){
          [name, ext]: key != name;
          _: true;
        }
      ];
    };

    fun delete(key){
      var: [idx];
      do: [
        with_openIn_file (dbdir + index_file) {
          arg: [fin];
          do: [
            idx = fin readlines;
            idx = idx filter (not_eq_key key);
          ];
        };
        with_openOut_file (dbdir + index_file) {
          arg: [fout];
          do: [
            fout writelines idx;
          ];
        };
        # update var 'index'
        index = {};
        idx map append_index;
      ];
    };

    fun set(key, value){
      var: [ver, filename, t];
      do: [
        ver = index lookup key;
        match(ver isNil?){
          true: [
            ver = "1";
          ];
          false: [
            let (ver, t) = ver;
            ver = (ver toInt + 1) toString;
          ];
        };
        filename = key + "." + ver;
        with_openOut_file (dbdir + filename) {
          arg: [fout];
          do: [
            fout write value;
          ];
        };
        update_index(key, ver);
      ];
    };

    fun get(key){
      var: [found, str];
      do: [
        let (str, found) = find key;
        match(found){
          true:  str;
          false: "";
        };
      ];
    };

    fun open(){
      var: [filelist];
      do: [
        with_openIn_file (dbdir + index_file) {
          arg: [fin];
          do: [
            filelist = fin readlines;
            filelist map append_index;
          ];
        };
      ];
    };

    fun close(){
    };

  }; /* end db */


  /*
   * Main Program
   */

  fun init_form(){
    var: [query, pairs];
    do: [
      match(Env "REQUEST_METHOD"){
        "GET":  [query = Env "QUERY_STRING"];
        "POST": [query = STDIN read(Env "CONTENT_LENGTH" toInt)];
      };
      pairs = query split('&');
      pairs each {
        arg: [pair];
        var: [key, value, reader];
        do: [
          let [key, value] = pair split1('=');
          value = value tr '+' ' ';
          reader = value reader; # get string reader;
          reader = URLencoder decoderIn reader;
          reader = KANJI_DECODER decoderIn reader;
          reader = CRLF2LF encoderIn reader;
          value = reader readlines;
          match(value isNil?){
            true:  value = "";
            false: value = value foldl add_line;
          };
          form append (key, value);
        ];
      };
    ];
  };

  fun do_write(){
    do: [
      match(form "mymsg"){
        "": [
            database delete (form "mypage");
            print_header((form "mypage") + msgdeleted, false);
          ];
        else: [
            database set((form "mypage"), (form "mymsg"));
            print_header(form "mypage", true);
            print_content();
          ];
      };
      print_footer();
    ];
  };

  fun do_index(){
    do: [
      print_header(indexpage, false);
      println "<ul>";
      database get_keys() sort each {
        arg: [key];
        do: [
          print "<li><a href=\"" cgi_name "?cmd=read&mypage=" (encode_url key) "\"><tt>" key "</tt></a></li>";
          println "";
        ];
      };
      println "</ul>";
      print_footer();
    ];
  };

  fun do_edit(){
    var: [mymsg];
    do: [
      print_header(form "mypage", false);
      mymsg = escape(database get (form "mypage"));

      println ("<form action=\"" + cgi_name + "\" method=\"POST\">");
      println ("  <input type=\"hidden\" name=\"cmd\" value=\"write\">");
      println ("  <input type=\"hidden\" name=\"mypage\" value=\"" + (form "mypage") + "\">");
      println ("  <input type=\"submit\" value=\"" + naviwrite + "\"><br>");
      println ("  <textarea cols=\"" + (cols toString)
               + "\" rows=\"" + (rows tostring)
               + "\" name=\"mymsg\" wrap=\"virtual\">" + mymsg
               + "</textarea><br>");
      println ("  <input type=\"submit\" value=\"" + naviwrite + "\">");
      println "</form>";

      println "<H1>ƥΥ롼</H1>";
      println "̾ϤʸΤޤϤޤ<br>";
      println "ϻѤǤޤ<br>";
      println "<br>";
      println "ޥʥ(----)Ƭ˽񤯤ȿʿˤʤޤ<br>";
      println "ꥹ(*)Ƭ˽񤯤縫Фˤʤޤ<br>";
      println "ꥹ(**)Ƭ˽񤯤ȾФˤʤޤ<br>";
      println "Ť[[]]Ǥäʸ񤯤ȡ󥯤ˤʤޤ<br>";
      println "[[]]ΤʤǥС(|)ǶڤȥСɽ̾襢ɥ쥹ˤʤޤ<br>";
      println "<br>";

      print_footer();
    ];
  };

  fun do_read(){
    do: [
      print_header(form "mypage", true);
      print_content();
      print_footer();
    ];
  };

  fun do_new(){
    do: [
      print_header("Create New Page", false);
      println "<br><br>";
      println "ڡ̾ϤƤ";
      println ("<form action=\"" + cgi_name + "\" method=\"POST\">");
      println ("  <input type=\"hidden\" name=\"cmd\" value=\"edit\">");
      println ("  <input type=\"text\" name=\"mypage\" size=\"20\">");
      println ("  <input type=\"submit\" value=\"" + naviwrite + "\"><br>");
      println "</form>";
      print_footer();
    ];
  };

  fun do_recent(){
    var: [key, ver, t, tuples, i];
    do: [
      print_header(recentpage, false);
      println "<ul>";

      tuples = database get_indexes();
      loop {
        from: i = 0;
        step: [i = i + 1; tuples = tuples tail];
        while: (i < recents) and (! (tuples isNil?));
        do: [
          let (key, ver, t) = tuples head;
          print "<li><a href=\"" cgi_name "?cmd=read&mypage=" (encode_url key) "\"><tt>" key "</tt></a> (" t ")</li>";
          println "";
        ];
      };

      println "</ul>";
      print_footer();
    ];
  };

  fun do_rss(){
    var: [lines];
    do: [
      with_openIn_file(rss file){
        arg: [fin];
        do: [
          lines = fin readLines;
        ];
      };
      println rss_contenttype;
      println "";
      lines each {
        arg: [line];
        do: [
          println line;
        ];
      };
    ];
  };

  fun open_database(){
    do: [
      database = db;
      database open();
    ];
  };

  fun close_database(){
    do: [
      database close();
    ];
  };

  #
  # main program
  #
  fun main(){
    do: [
      init_form();

      #### database open ####
      open_database();

      match(form "cmd"){
        "read":   do_read();
        "write":  do_write();
        "edit":   do_edit();
        "index":  do_index();
        "new":    do_new();
        "recent": do_recent();
        "rss":    do_rss();
        other: [
          form "mypage" = frontpage;
          do_read();
        ];
      };

      #### database close ####
      close_database();

    ];
    rescue: [
      print_header("Soopy Error", false);
      print_footer();
    ];
  };

} main();
